; archutil/asm - kjw/bqsd - version 0.00
;
; created 03/30/83 - kjw
; revised 03/30/83 - kjw
;
	TITLE	'<ARCHUTIL - Archive Utilities>'
;
	SUBTTL	'<by Kim Watt - (C) Copyright 1983 - Breeze/QSD, Inc. - Dallas, Texas>'
;
TRS13	EQU	-1
TRS2	EQU	0
;
;	system equates
;
	IF	TRS13
CODE	EQU	5200H
BOL	EQU	01DH
EOL	EQU	01EH
BREAK	EQU	003H
	ENDIF
;
	IF	TRS2
CODE	EQU	2200H
UFEED	EQU	00BH
EOL	EQU	017H
BREAK	EQU	001H
	ENDIF
;
CR	EQU	00DH
ETX	EQU	003H
;
	PAGE
;
	ORG	CODE
;
ENTRY	CALL	@SETUP		;setup for normal exit
	PUSH	HL		;save input pointer
	LD	HL,HELLO	;sign on message
	CALL	@VDLINE		;display it
	POP	HL		;unstack
	CALL	@POSHL		;any input?
	JP	Z,PROMPT	;nope, prompt for it
;
;	parse input command line, clear params
;
PARSE	LD	BC,0		;load zero
	LD	(IPARAM),BC	;clear $INIT
	LD	(PPARAM),BC	;clear $PRINT
	LD	(LPARAM),BC	;clear $LIST
	LD	(CPARAM),BC	;clear $COPY
	LD	(RPARAM),BC	;init $RECORDS
	LD	(RPARAM+1),BC	;init 3 bytes
	DEC	BC		;load FFFF
	LD	(NPARAM),BC	;pass it
	LD	(NPARAM+1),BC	;clear 3 bytes
	LD	BC,8080H	;non true/false
	LD	(UPARAM),BC	;init $USE
;
;	evaluate user input
;
	LD	IX,EBLOCK	;evaluation block
	CALL	@EVAL		;evaluate!
	JR	NZ,PERROR	;param error!
	BIT	3,(IX+0)	;any input?
	JR	Z,PERROR	;param error if not!
;
;	parameters issued, execute!
;
	PAGE
;
;	initialize diskette
;
	LD	BC,$		;get $INIT flag
IPARAM	EQU	$-2
	LD	A,B		;any input?
	OR	C		;BC = 0000?
	CALL	NZ,$INIT	;do it if specified
	JR	NZ,ERROR	;go if any errors
;
;	list file set
;
	LD	BC,$		;get $LIST flag
LPARAM	EQU	$-2
	LD	A,B		;any input?
	OR	C		;BC = 0000?
	CALL	NZ,$LIST	;list if specified
	JR	NZ,ERROR	;go if any errors
;
;	print file set
;
	LD	BC,$		;get $PRINT flag
PPARAM	EQU	$-2
	LD	A,B		;any input?
	OR	C		;BC = 0000?
	CALL	NZ,$PRINT	;print if specified
	JR	NZ,ERROR	;go if any errors
;
;	copy file set
;
	LD	BC,$		;get $COPY flag
CPARAM	EQU	$-2
	LD	A,B		;any input?
	OR	C		;BC = 0000?
	CALL	NZ,$COPY	;copy if specified
	JR	NZ,ERROR	;go if any errors
;
;	all functions completed, exit back to DOS
;
@EXIT	LD	SP,$		;reset stack
STACK	EQU	$-2
	PUSH	BC		;save
	LD	BC,$		;get interrupt latch
INTLAT	EQU	$-2
	PUSH	BC		;pass to AF
	POP	AF		;F = int latch
	POP	BC		;restore BC
	JP	PO,$+4		;go if interrupts off
	EI			;else re-enable them
	XOR	A		;return Z
	RET			;back to last level
;
;	setup for normal program exit
;
@SETUP	POP	AF		;get caller address
	LD	(STACK),SP	;preserve stack
	PUSH	AF		;call back to stack
	LD	A,I		;get I register
	PUSH	BC		;save BC
	PUSH	AF		;pass AF => BC
	POP	BC		;C = int latch
	LD	(INTLAT),BC	;save for exit
	POP	BC		;restore stack
	XOR	A		;return Z
	RET			;done!
;
;	error vectors
;
ERROR	CALL	@ERROR		;display error
	JR	PROMPT		;prompt for input
;
IERROR	LD	HL,ERRMSGI	;'identity error'
	JR	DSPERR		;display error
;
NERROR	LD	HL,ERRMSGN	;'nil file'
	JR	DSPERR		;display error
;
PERROR	LD	HL,ERRMSGP	;'param error'
;
DSPERR	CALL	@VDLINE		;display message
;
;	prompt for input parameters
;
PROMPT	LD	SP,(STACK)	;reset stack
	LD	HL,PTEXT	;prompt text
	LD	DE,KEYBUFF	;key input buffer
	LD	B,63		;key input length
	CALL	@VIDKEY		;display & keyboard
	JP	C,@EXIT		;go on BREAK
	CALL	@POSHL		;any input?
	JP	NZ,PARSE	;yes, parse it out
;
	LD	HL,HELP		;help text
	CALL	@VDLINE		;display to video
	JR	PROMPT		;ask again
;
;**	subroutines
;
;	initialize INDEX file
;
$INIT	LD	A,(IX+0)	;get field params
	BIT	0,A		;mask field?
	JP	NZ,PERROR	;error if yes!
;
;	check for source/dest input
;
	AND	6		;bits 2/1
	JP	Z,PERROR	;must be there
	JP	PE,PERROR	;must be only one field
;
;	fetch pointer to FCB block
;
	LD	DE,SFCB		;source file block
	BIT	2,A		;source field?
	JR	NZ,$+5		;go if yes
	LD	DE,DFCB		;else in dest file block
;
;	check that drive number issued
;
	LD	A,(DE)		;get user data type
	AND	0E0H		;get flags
	CP	80H		;must be drive only!
	JP	NZ,PERROR	;param error if else
;
	INC	DE		;point to user text
	LD	A,(DE)		;get data
	CP	':'		;must be drive specifier
	JP	NZ,PERROR	;param error if else
;
;	move user drive # into filespec text
;
	INC	DE		;point to text
	LD	A,(DE)		;get drive # ascii
	LD	(INAMED),A	;to text
;
;	check if two char drive # used
;
	INC	DE		;bump pointer
	LD	A,(DE)		;get second char
	LD	BC,ETX<8+ETX	;load ETX chars
	CP	B		;done?
	JR	Z,$+3		;go if end
	LD	C,A		;else pass second char
	LD	(INAMED+1),BC	;load remainder drive #
;
;	leave error exit on stack for easy exit
;
	LD	HL,$ERROR	;error exit
	PUSH	HL		;to the stack
;
;	move filespec for index into FCB block
;
	LD	HL,INAME	;index filespec
	LD	DE,SFCB		;use source FCB
	LD	BC,50		;max length
	PUSH	DE		;save start
	LDIR			;move it!
	POP	DE		;DE => filename text
	LD	HL,SBUFF	;I/O buffer
	XOR	A		;LRL for file
	CALL	$OPEN		;open the file
	RET	NZ		;go if disk error
;
;	clear I/O buffer to FF's
;
	LD	HL,SBUFF	;start I/O buffer
	LD	DE,SBUFF+1	;start +1
	LD	BC,0FFH		;length -1
	LD	(HL),-1		;load FF
	LDIR			;fill FF
;
;	fetch # desired records from user
;
GETREC	LD	IX,RPARAM	;# records
	LD	C,(IX+0)	;get # records
	LD	D,(IX+1)
	LD	E,(IX+2)
	LD	A,C		;check for nil
	OR	D
	OR	E		;CDE = 000000H?
	JR	NZ,HAVREC	;nope, have it!
;
GETREC1	LD	HL,RECMSG	;'# records?'
	LD	DE,KEYBUFF	;key input buffer
	LD	B,63		;max key input
	CALL	@VIDKEY		;display/keyboard
	JP	C,@EXIT		;go on BREAK
	CALL	@POSHL		;any input?
	JR	Z,GETREC1	;nope, ask again
	CALL	@VALUE		;get user input value
	JR	NZ,GETREC1	;go if invalid amount
;
;	move value from CDE => BHL for math
;
HAVREC	LD	B,C		;pass MSB
	EX	DE,HL		;pass NSB/LSB
;
;	compute # physical sectors needed
;
	LD	C,16		;# entries / sector
	CALL	@DIVID		;BHL = BHL/C
	OR	A		;any remainder?
	CALL	NZ,@INC		;increment BHL if partial
	LD	IY,DBLOCK	;data block
	LD	(IY+0),B	;save # phy sectors
	LD	(IY+1),H
	LD	(IY+2),L
	CALL	@INC		;+1 for header sector
	LD	(IY+3),B	;pass sector #
	LD	(IY+4),H
	LD	(IY+5),L
;
;	allocate enough file space for # records
;
	LD	DE,SFCB		;point to open FCB
	LD	BC,DBLOCK+3	;point to record #
	CALL	@POSN		;position to record
	JR	Z,CONT1		;go if no error
	CP	1CH		;at EOF?
	JR	Z,CONT1		;go if yes
	CP	1DH		;beyond EOF?
	RET	NZ		;go $ERROR if neither!
CONT1	CALL	@WRITE		;allocate disk space!
	RET	NZ		;go if disk error
;
;	rewind file to beginning
;
	LD	BC,DBLOCK+6	;3 00's
	CALL	@POSN		;rewind file
	RET	NZ		;go if any error
;
;	buffer is filled with FF's
;	write to all sectors of file to assure
;	that all parts of the file are useable
;
;	init parameters for loop
;
	LD	A,(IY+3)	;get # sectors
	LD	(IY+9),A	;pass to counter
	LD	A,(IY+4)
	LD	(IY+10),A
	LD	A,(IY+5)
	LD	(IY+11),A
;
;	setup loop to write to entire file
;
INTLP	CALL	@WRITE		;write the sector
	RET	NZ		;go if any error
;
;	decrement counter
;
	LD	B,(IY+9)	;get counter
	LD	H,(IY+10)
	LD	L,(IY+11)
	CALL	@DEC		;BHL = BHL -1
	LD	(IY+9),B	;update
	LD	(IY+10),H
	LD	(IY+11),L
	LD	A,B		;BHL = 000000H?
	OR	H
	OR	L
	JR	NZ,INTLP	;write more if any left
;
;	entire file written, write out header sector
;	rewind file to first record
;
	LD	BC,DBLOCK+6	;3 00's
	CALL	@POSN		;rewind file
	RET	NZ		;go if any errors
;
;	initialize I/O buffer with parameters
;	clear to all zeros to init
;
	LD	HL,SBUFF	;I/O buffer
	LD	DE,SBUFF+1	;start +1
	LD	BC,0FFH		;length -1
	LD	(HL),0		;load zero
	LDIR			;fill zero
;
;	move in header ID string
;
	LD	HL,HEADER	;header text
	LD	DE,SBUFF	;start I/O buffer
	LD	BC,HEADERL	;length of header
	LDIR			;move to buffer
;
;	compute # REAL index records available
;	and bucket size to be used for table
;
	LD	B,(IY+0)	;get # phys sectors
	LD	H,(IY+1)	;that can be used for
	LD	L,(IY+2)	;actual records
	LD	C,16		;# records / sector
	CALL	@MULT		;BHL = actual # real
	LD	C,26		;# buckets total
	CALL	@DIVID		;BHL = bucket size
	LD	(IY+18),B	;save bucket size
	LD	(IY+19),H
	LD	(IY+20),L
	LD	C,26		;# buckets total
	CALL	@MULT		;compute ACTUAL # records
	LD	(IY+15),B	;save # records total
	LD	(IY+16),H
	LD	(IY+17),L
;
;	pass information to index header sector
;
	LD	IX,SBUFF	;point to I/O buffer
	LD	(IX+23H),B	;save max entries
	LD	(IX+24H),H
	LD	(IX+25H),L
	LD	D,(IY+19)	;get bucket size
	LD	E,(IY+20)
	LD	(IX+2CH),D	;pass to buffer
	LD	(IX+2DH),E
;
;	create bucket table
;
	LD	IX,SBUFF+30H	;start bucket table
	LD	BC,0		;init MSB's
	LD	HL,0		;init record #'s
	LD	A,26		;# buckets
;
;	CDE = bucket size
;	BHL = current record #
;	IX  => bucket table
;	A   = # buckets
;
INTBUCK	EX	AF,AF'		;save counter
	XOR	A		;load zero
	LD	(IX+0),A	;init # entries in bucket
	LD	(IX+1),A
	LD	(IX+2),B	;init bucket start record
	LD	(IX+3),H
	LD	(IX+4),L
	LD	(IX+5),A	;init bucket last record
	LD	(IX+6),A
	LD	(IX+7),A
	CALL	@ADD		;BHL = BHL + CDE
	PUSH	BC		;save
	LD	BC,8		;bytes / entry
	ADD	IX,BC		;IX => next entry
	POP	BC		;restore
	EX	AF,AF'		;get counter
	DEC	A		;less this pass
	JR	NZ,INTBUCK	;go if more
;
;	index header sector created, write to disk
;
	LD	DE,SFCB		;source file block
	CALL	@WRITE		;write the first sector
	RET	NZ		;go if disk error
	CALL	@CLOSE		;close the file
	RET	NZ		;go if disk error
;
;	file created/verified/closed
;
	LD	HL,COMMSG	;'completed'
	CALL	@VDLINE		;display message
	JP	@EXIT		;exit program to DOS
;
;	open file, asks to use if it exists
;
$OPEN	CALL	@INIT		;open/create file
	RET	NZ		;go if any error
	RET	C		;go if new file created
;
;	check if param issued to USE disk
;
	LD	BC,$		;get param
UPARAM	EQU	$-2
	LD	A,B		;BC = 0000H?
	OR	C
	JP	Z,@EXIT		;don't use it
	INC	A		;BC = FFFFH?
	RET	Z		;use issued
;
OPENASK	LD	HL,EXMSG	;'exists, use?'
	LD	DE,KEYBUFF	;key input buffer
	LD	B,3		;input length
	CALL	@VIDKEY		;display/keyboard
	JP	C,@EXIT		;go on BREAK
	CALL	@POSHL		;position to input
	JR	Z,OPENASK	;go if nil input
	CALL	@UCASE		;make upper case
	CP	'U'		;use it?
	RET	Z		;yes, go!
	CP	'Y'		;use it?
	RET	Z		;yes, go!
	CP	'N'		;no?
	JP	Z,@EXIT		;nope, exit!
	CP	'D'		;don't?
	JP	Z,@EXIT		;nope, exit!
	JR	OPENASK		;else ask again
;
;	error encountered during I/O
;
$ERROR	CALL	@ERROR		;display error message
	JP	@EXIT		;abort program
;
;	external modules
;
*GET	ARCHUTL1		;support module 1
*GET	ARCHUTL2		;support module 2
*GET	ARCHUTL3		;print/list
;
;	fill memory block
;
@FILL	LD	(HL),A		;load a char
	INC	HL		;bump pointer
	DJNZ	@FILL		;go for count
	RET			;filled!
;
;	compare two strings for B bytes
;
@COMP	LD	A,(DE)		;get a byte
	CP	(HL)		;match?
	RET	NZ		;nope, go!
	INC	DE		;bump pointers
	INC	HL
	DJNZ	@COMP		;go for length
	RET			;done, Z set for equal!
;
;	position HL to significant input
;
	INC	HL		;bump pointer
@POSHL	LD	A,(HL)		;get input char
	CP	' '		;separator?
	JR	Z,@POSHL-1	;yes, ignore it
	CP	','		;separator?
	JR	Z,@POSHL-1	;yes, ignore
	CP	CR		;terminator?
	RET	Z		;yes, return Z
	CP	ETX		;terminator?
	RET			;Z = yes, else A = char
;
;	point to table entry
;
@POINT	INC	B		;request 0?
POINT1	DEC	B		;done?
	RET	Z		;yes, go!
	LD	A,C		;get offset
	ADD	A,L		;add LSB to table
	LD	L,A		;update
	JR	NC,POINT1	;go if no page cross
	INC	H		;bump page
	JR	POINT1		;continue
;
;	display error message
;
@ERROR	EQU	$
;
	IF	TRS13
	OR	0C0H		;normal display
	JP	4409H		;display & return
	ENDIF
;
	IF	TRS2
	PUSH	BC		;save it
	AND	7FH		;assure a return
	LD	B,A		;pass error code
	LD	A,39		;SVC # error
	RST	8		;display error
	POP	BC		;restore stack
	RET			;done
	ENDIF
;
;	video display + keyboard
;
@VIDKEY	CALL	@VDLINE		;display prompt
	EX	DE,HL		;HL => key input
;
;	fetch input string from keyboard
;
@KBLINE	EQU	$
;
	IF	TRS13
	CALL	0040H		;get key input
	LD	A,0		;set no error
	INC	A		;set Z flag
	DEC	A		;but leave C intact
	RET			;return Z
	ENDIF
;
	IF	TRS2
	LD	A,5		;SVC # kbline
	RST	8		;fetch input
	RET			;done!
	ENDIF
;
;	display string to video
;
@VDLINE	PUSH	HL		;save string start
;
VDLINY	LD	A,(HL)		;get a char
	CP	ETX		;terminator?
	JR	Z,VDLINZ	;go if yes
	CALL	@VDCHAR		;display char to video
	JR	NZ,VDLINZ	;go if error
	INC	HL		;else bump pointer
	JR	VDLINY		;go next char
;
VDLINZ	POP	HL		;restore pointer
	RET	NZ		;go if any error
	XOR	A		;else return ZERO
	RET			;done!
;
;	display char to video
;
@VDCHAR	EQU	$
;
	IF	TRS13
	PUSH	DE		;save
	PUSH	IY		;save
	CALL	0033H		;display char
	POP	IY		;restore
	POP	DE		;restore
	RET			;done!
	ENDIF
;
	IF	TRS2
	PUSH	BC		;save
	LD	B,A		;pass char
	LD	A,8		;SVC # vdchar
	RST	8		;display char
	POP	BC		;restore
	RET			;return status
	ENDIF
;
;	fetch character from keyboard
;
@KBCHAR	EQU	$
;
	IF	TRS13
	PUSH	DE		;save
	PUSH	IY		;save
	CALL	002BH		;scan keyboard
	POP	IY		;restore
	POP	DE		;restore
	OR	A		;any keys?
	JR	Z,$+4		;go if not
	CP	A		;set Z,NC
	RET			;go!
	OR	8		;char not available
	RET			;go!
	ENDIF
;
	IF	TRS2
	LD	A,4		;SVC # kbchar
	RST	8		;scan keyboard
	RET			;done!
	ENDIF
;
;	send character to printer
;
@PRCHAR	EQU	$
;
	IF	TRS13
	PUSH	DE		;save
	PUSH	IY		;save
	CALL	003BH		;print char
	POP	IY		;restore
	POP	DE		;restore
	RET			;done!
	ENDIF
;
	IF	TRS2
	PUSH	BC		;save BC
	LD	B,A		;pass char
	LD	A,18		;SVC # prchar
	RST	8		;print char
	POP	BC		;restore
	RET			;return status
	ENDIF
;
;	preserve registers
;
@SAVREG	POP	AF		;get caller address
	PUSH	IY		;save 'em
	PUSH	IX
	PUSH	HL
	PUSH	DE
	PUSH	BC
	PUSH	HL		;again
	LD	HL,SAVREG1	;unstacker address
	EX	(SP),HL		;get HL, leave vector
	PUSH	AF		;caller to stack
	RET			;done!
;
SAVREG1	POP	BC		;unstack 'em
	POP	DE
	POP	HL
	POP	IX
	POP	IY
	RET			;A left intact
;
;	convert character to upper case
;
@UCASE	CP	'a'		;in range?
	RET	C		;nope, leave it
	CP	'z'+1		;in range?
	RET	NC		;nope, leave it
	SUB	20H		;make upper case
	RET			;done!
;
;##	text
;
HELLO	DEFB	CR
	DEFM	'ARCHUTIL - '
	DEFM	'Archive Utilities - '
	DEFM	'by Kim Watt - '
	DEFM	'Version 0.00'
	DEFB	CR
	DEFM	'(C) Copyright 1983 - '
	DEFM	'Breeze/QSD, Inc. - '
	DEFM	'Dallas, Texas'
	DEFB	CR
	DEFB	CR
	DEFB	ETX
;
HEADER	DEFM	'Virtual  Archive'
	DEFM	'Breeze/QSD, Inc.'
HEADERL	EQU	$-HEADER
;
PTEXT	DEFB	CR
	DEFM	'*'
	DEFB	ETX
;
HELP	DEFB	CR
	DEFM	'Source Destination Wildmask,'
	DEFM	'(INIT,PRINT,LIST,COPY,USE,SIZE)'
	DEFB	CR
	DEFB	ETX
;
MNTMSG	DEFM	'Mount Disk # '
MNTDISK	DEFM	'xxxxx'
	DEFB	ETX
;
CLRLIN	EQU	$
	IF	TRS13
	DEFB	BOL
	DEFB	EOL
	DEFB	ETX
	ENDIF
	IF	TRS2
	DEFB	CR
	DEFB	UFEED
	DEFB	EOL
	DEFB	ETX
	ENDIF
;
ERRMSGP	DEFM	'Parameter Error'
	DEFB	CR
	DEFB	ETX
;
ERRMSGI	DEFM	'Index Identity Error'
	DEFB	CR
	DEFB	ETX
;
ERRMSGN	DEFM	'Nil Index File'
	DEFB	CR
	DEFB	ETX
;
INAME	DEFM	'VDISK/IND:'
INAMED	DEFM	'xx'
	DEFB	ETX
;
RECMSG	DEFM	'# Records to Allocate? '
	DEFB	ETX
;
COMMSG	DEFM	'VDISK/IND - '
	DEFM	'Virtual-Disk Archive Index Created'
	DEFB	CR
	DEFB	ETX
;
EXMSG	DEFM	'File Exists, Use? '
	DEFB	ETX
;
;$$	data/buffer area
;
;	evaluation definition block
;
EBLOCK	DEFB	0		;work byte
	DEFW	SFCB		;source file block
	DEFW	DFCB		;dest file block
	DEFW	MFCB		;mask file block
	DEFW	PARAMS		;param list
	DEFW	WFCB		;work file block
;
;	parameter block
;
PARAMS	DEFB	20H+3		;switch + length-1
	DEFW	IPARAM		;indirect vector
	DEFM	'INIT'		;param word
;
	DEFB	20H+4		;switch + length-1
	DEFW	PPARAM		;indirect vector
	DEFM	'PRINT'		;param word
;
	DEFB	20H+3		;switch + length-1
	DEFW	LPARAM		;indirect vector
	DEFM	'LIST'		;param word
;
	DEFB	20H+3		;switch + length-1
	DEFW	CPARAM		;indirect vector
	DEFM	'COPY'		;param word
;
	DEFB	20H+2		;switch + length-1
	DEFW	UPARAM		;indirect vector
	DEFM	'USE'
;
	DEFB	40H+3		;value + length-1
	DEFW	RPARAM		;# records
	DEFM	'SIZE'		;param word
;
	DEFB	40H+6		;value + length-1
	DEFW	RPARAM		;alternate word
	DEFM	'RECORDS'	;word
;
	DEFB	40H+4		;value + length-1
	DEFW	NPARAM		;index drive #
	DEFM	'INDEX'		;param word
;
	DEFB	00H		;terminator
;
ALLWILD	DEFM	'*/*'
	DEFB	ETX
;
;	internal data block
;
DBLOCK	DEFB	0,0,0		;0,1,2 - # phys sectors
	DEFB	0,0,0		;3,4,5 - # logical secs
	DEFB	0,0,0		;6,7,8 - rewind record #
	DEFB	0,0,0		;9,10,11 - counter
	DEFB	0,0,0		;12,13,14 - pointer
	DEFB	0,0,0		;15,16,17 - # recs total
	DEFB	0,0,0		;18,19,20 - bucket size
;
SFCB	DEFS	51		;source file block
DFCB	DEFS	51		;dest file block
MFCB	DEFS	51		;mask FCB
WFCB	DEFS	51		;work FCB
SBUFF	DEFS	256		;source I/O buffer
DBUFF	DEFS	256		;dest I/O buffer
KEYBUFF	DEFS	64		;key input buffer
RPARAM	DEFS	3		;# records in file
NPARAM	DEFS	3		;index drive #
SDRV	DEFS	3		;source drive text
DDRV	DEFS	3		;dest drive text
;
ZZZZZ	EQU	$
;
	END	ENTRY
