; wd1002/asm - kjw/bqsd - April 12, 1983
;
; created 04/12/83 - kjw/bqsd
; revised 05/23/83 - kjw
;
	PAGE
;
;	DCT definition
;
; +0		X'C3' (JP) or X'C9' (RET)
; +1/+2		driver address if +0 = C3
; +3	7	0=no		1=soft write protect
;	6	0=SDEN		1=DDEN
;	5	0=5"		1=8"
;	4	0=implied seek	1=seek before read/write
;	3	0=floppy	1=rigid
;	2	0=no		1=deselect drive
;	1	(unused)
;	0	(unused)
; +4	7	(reserved by LDOS)
;	6	0=no		1=engage 'LOCK' feature
;	5	0=no		1=double cylinder count
;	4	0=no		1=alien driver
;	3-0	physical drive number (0-3)
; +5	current cylinder
; +6	highest cylinder number
; +7	7-4	head count -1
;	5-0	highest sector # / track
; +8	7-5	grans / track -1
;	4-0	sectors / gran -1
; +9	directory cylinder
;
;	when the driver is installed in memory
;	the first 3 bytes will be a call to a common
;	subroutine driver.  immediately following
;	the call will be 4 data bytes as follows:
;
; +0/1	cylinder offset (lsb,msb)
; +2	sector offset
; +3	7	if ECC to be engaged for drive
;	6-5	sector size (00=256 bytes)
;	4-3	drive select code (0-3)
;	2-0	head offset factor
; +4	7-4	sector/sector skewing factor
;	3-0	track/track skewing factor
;
	PAGE
;
;	system equates
;
PRECYL	EQU	61		;precomp cylinder(center)
ROMID	EQU	0125H		;rom identity address
MODIII	EQU	'I'		;mod III identifier
@MULT1	EQU	44C1H		;vector Mod I
@MULT3	EQU	444EH		;vector Mod III
@HIGH1	EQU	4409H		;highmem Mod I
@HIGH3	EQU	4411H		;highmem Mod III
;
;	disk I/O command assignments
;
@NOP	EQU	00H		;test for drive ready
@SELECT	EQU	01H		;select drive & status
@INIT	EQU	02H		;initialize drive
@RESET	EQU	03H		;reset controller
@RESTOR	EQU	04H		;move to cylinder zero
@STEPIN	EQU	05H		;move head in one cyl
@SEEK	EQU	06H		;seek cylinder
@TSTBSY	EQU	07H		;test for drive busy
@RDHDR	EQU	08H		;read sector header
@RDSEC	EQU	09H		;read sector
@VERSEC	EQU	0AH		;verify sector
@RDCYL	EQU	0BH		;read cylinder
@FORMAT	EQU	0CH		;format device
@WRSEC	EQU	0DH		;write sector
@WRSYS	EQU	0EH		;write system sector
@WRCYL	EQU	0FH		;write cylinder
;
;	rigid drive I/O port assignment
;
@BASE	EQU	50H		;base I/O port
@DATA	EQU	@BASE+0		;data read/write
@ERROR	EQU	@BASE+1		;error register
@PRECMP	EQU	@BASE+1		;write precomp reg
@SECCNT	EQU	@BASE+2		;sector count register
@SECNUM	EQU	@BASE+3		;sector number register
@CYLNUM	EQU	@BASE+4		;cylinder number low
@CYHNUM	EQU	@BASE+5		;cylinder number high
@SDH	EQU	@BASE+6		;size/drive/head
@STATUS	EQU	@BASE+7		;status register
@CMD	EQU	@BASE+7		;command register
@LOCK	EQU	@BASE+8		;drive lockout
;
;	status register assignments
;
_SBUSY	EQU	10000000B	;busy
_SREADY	EQU	01000000B	;ready
_SFAULT	EQU	00100000B	;write fault
_SEEKOK	EQU	00010000B	;seek complete
_SDRQ	EQU	00001000B	;data request
_SCORR	EQU	00000100B	;corrected error
_SERROR	EQU	00000001B	;error register valid
;
;	error register assignments
;
_EBBD	EQU	10000000B	;bad block detect
_UNCORR	EQU	01000000B	;uncorrectable error
_CRCID	EQU	00100000B	;crc error in ID field
_IDNOTF	EQU	00010000B	;id not found
_ABORT	EQU	00000100B	;aborted command
_TR000	EQU	00000010B	;track 000 error
_DAMNF	EQU	00000001B	;DAM not found
;
;	command assignments
;
CMDRES	EQU	00010000B	;restore drive
CMDSEK	EQU	01110000B	;seek cylinder
CMDRED	EQU	00100000B	;read sector
CMDWRT	EQU	00110000B	;write sector
CMDFMT	EQU	01010000B	;write track
;
;	dos error equivalences
;
@ERR00	EQU	00H		;no error
@ERR01	EQU	01H		;parity header read
@ERR02	EQU	02H		;seek read error
@ERR03	EQU	03H		;lost data on read
@ERR04	EQU	04H		;crc error on read
@ERR05	EQU	05H		;not found on read
@ERR06	EQU	06H		;read system data record
@ERR07	EQU	07H		;read locked data record
@ERR08	EQU	08H		;device not available
@ERR09	EQU	09H		;parity header write
@ERR10	EQU	0AH		;seek write error
@ERR11	EQU	0BH		;load data on write
@ERR12	EQU	0CH		;crc error on write
@ERR13	EQU	0DH		;not found on write
@ERR14	EQU	0EH		;write fault on drive
@ERR15	EQU	0FH		;write protected disk
@ERR99	EQU	3FH		;undefined error!
;
	PAGE
;
;	rigid I/O driver header block
;	appears once for each drive using driver
;
;	ENTRY	B  =	command #
;		C  =	drive #
;		D  =	cylinder
;		E  =	sector
;		HL =>	I/O buffer
;		IY =>	DCT
;
;	EXIT	Z  =	OK, no error, A=0
;		NZ =	A=error code
;
DRIVER	JR	DRIVSTA		;go driver start
OLDTOP	DEFW	$-$		;old top memory
	DEFB	HEADL		;header length
HEAD	DEFM	'WDDVR'		;header text
HEADL	EQU	$-HEAD		;header length
;
DRIVSTA	CALL	$-$		;call driver
RELO1	EQU	$-2
DRIVDAT	DEFW	0000H		;cylinder offset
	DEFW	0000H		;sec offset / flags
	DEFB	00H		;sector skew
DRIVERL	EQU	$-DRIVER	;length of driver
;
;	actual I/O driver
;	appears only once in memory
;
IODVR	EX	(SP),IX		;IX to stack/ => data
	PUSH	HL		;save I/O buffer address
	PUSH	DE		;save track/sector
	PUSH	BC		;save drive/B register
	CALL	PERFORM		;perform indicated cmd
RELO2	EQU	$-2
	POP	BC		;unstack
	POP	DE
	POP	HL
	POP	IX
	BIT	2,(IY+03)	;de-select driver?
	JR	Z,IOEXIT	;go if not
;
	PUSH	AF		;save status
	LD	A,-1		;load FF
	OUT	(@SDH),A	;de-select drive
	POP	AF		;restore status
;
IOEXIT	OR	A		;set flags on result
	RET			;done, return AF status
;
;	perform I/O from table of vectors
;
PERFORM	LD	A,B		;get command number
	CP	@WRCYL+1	;valid command?
	JR	C,EXEDVR	;yes, go!
;
;	command out of range!
;
	LD	A,@ERR99	;'undefined error'
	RET			;return in error
;
EXEDVR	PUSH	HL		;save
	LD	HL,TABLE	;command lookup table
RELO3	EQU	$-2
	ADD	A,A		;2 byte entries
	ADD	A,L		;add to LSB table
	LD	L,A		;L = lsb table
	JR	NC,$+3		;go if no overflow
	INC	H		;H = msb table
	LD	A,(HL)		;get LSB vector
	INC	HL		;bump table
	LD	H,(HL)		;get MSB vector
	LD	L,A		;HL = vector
	EX	(SP),HL		;leave, get HL
	RET			;go driver!
;
;	driver command table
;
TABLE	EQU	$		;command table
RELO61	DEFW	$NOP		;no operation
RELO4	DEFW	$SELECT		;select drive
RELO5	DEFW	$INIT		;set cyl 0, restore
RELO6	DEFW	$RESET		;reset FDC
RELO7	DEFW	$RESTOR		;restore drive
RELO8	DEFW	$STEPIN		;step in
RELO9	DEFW	$SEEK		;seek cylinder
RELO10	DEFW	$TSTBSY		;test drive busy
RELO11	DEFW	$RDHDR		;read header
RELO12	DEFW	$RDSEC		;read sector
RELO13	DEFW	$VERSEC		;verify sector
RELO14	DEFW	$RDCYL		;read cylinder
RELO15	DEFW	$FORMAT		;format device
RELO16	DEFW	$WRSEC		;write sector
RELO17	DEFW	$WRSYS		;write system sector
RELO18	DEFW	$WRCYL		;write cylinder
;
	PAGE
;
;	$NOP	- test if drive assigned in DCT
;
;	ENTRY	IY =>	DCT
;
;	EXIT	Z  =	OK, drive assigned
;		NZ = 	A = error code
;
$NOP	LD	A,(IY+0)	;get DCT byte
	SUB	0C3H		;active vector?
	RET	Z		;yes, go!
	LD	A,@ERR08	;device not available
	RET			;return in error
;
	PAGE
;
;	$SELECT	- select current drive and return status
;
;	ENTRY	IY =>	DCT
;
;	EXIT	Z  =	drive selected and ready
;		NZ =	A = error code
;
$SELECT	CALL	$TSTBSY		;check if busy
RELO19	EQU	$-2
	RET	NZ		;go if not available
	CALL	SELECT		;select drive
RELO20	EQU	$-2
;
;	$TSTBSY	- check if drive is busy
;
;	ENTRY	none
;
;	EXIT	Z  =	OK, drive ready
;		NZ =	A = error code
;
$TSTBSY	IN	A,(@STATUS)	;read status register
	AND	_SBUSY		;busy?
	RET	Z		;nope, return OK
	LD	A,@ERR08	;drive not available
	RET			;return NZ for not ready
;
;	SELECT	- select current drive
;
;	ENTRY	A  =	head number to select
;
;	EXIT	drive select issued
;
SELECT	OR	(IX+3)		;create select command
	OUT	(@SDH),A	;select drive
	RET			;drive selected!
;
	PAGE
;
;	$INIT	- init drive/restore head
;	$RESET	- reset FDC controller
;	$RESTOR	- restore head to track 000
;
;	ENTRY	IY =>	DCT
;
;	EXIT	Z  =	OK, drive ready
;		NZ =	A = error code
;
$INIT	EQU	$
$RESET	EQU	$
$RESTOR	EQU	$
	CALL	LOCK		;lock the drive
RELO21	EQU	$-2
;
;	check if drive has 35 us step rate
;
	CALL	DOINIT		;home/init drive
RELO22	EQU	$-2
	JR	UNLOCK		;auto step setup
;
DOINIT	LD	A,(IY+04)	;get step rate
	AND	0FH		;low 4 bits
	LD	D,CMDRES	;FDC command
	JR	NZ,$+4		;go if not 0
	OR	7		;slow down rate for $HOME
	OR	D		;combine with command
	LD	DE,0		;dummy cyl/sector
	CALL	MOVE		;issue head command
RELO23	EQU	$-2
	OR	A		;any errors?
	RET	NZ		;yes, exit!
	JR	SEEK		;set step & return status
;
	PAGE
;
;	$STEPIN	- step in head a single cylinder
;
;	ENTRY	IY =>	DCT
;
;	EXIT	Z  =	OK, head moved in one cylinder
;		NZ = 	A = error code
;
$STEPIN	LD	D,(IY+5)	;get current cylinder
	INC	D		;add one for next cyl
	LD	E,0		;dummy sector for tasktbl
;
	PAGE
;
;	$SEEK	- seek desired cylinder/sector
;
;	ENTRY	D  =	cylinder
;		E  =	sector
;
;	EXIT	Z  =	OK, no error
;		NZ =	A = error code
;
$SEEK	CALL	LOCK		;lock on drive
RELO24	EQU	$-2
	CALL	SEEK		;seek cylinder
RELO25	EQU	$-2
;
;	unlock current drive
;
UNLOCK	PUSH	AF		;save status
	BIT	6,(IY+04)	;'lock' enagaged?
	JR	Z,UNLK		;nope, exit!
	XOR	A		;load zero
	OUT	(@LOCK),A	;unlock drive
UNLK	POP	AF		;restore status
	RET			;done!
;
;	lock current drive
;
LOCK	CALL	$TSTBSY		;drive busy?
RELO26	EQU	$-2
	JR	NZ,LOCK		;busy, wait here
	BIT	6,(IY+04)	;'lock' engaged?
	RET	Z		;nope, done!
	LD	A,1		;set bit 0
	OUT	(@LOCK),A	;lock onto drive
	RET			;drive locked!
;
;	seek cylinder
;
SEEK	LD	A,CMDSEK	;FDC command
;
;	common vector for head movement commands
;
MOVE	PUSH	BC		;save
	PUSH	AF		;save I/O command
	CALL	UPTASK		;update task file
RELO27	EQU	$-2
	LD	A,(IY+4)	;get DCT data
	AND	0FH		;step rate
	POP	BC		;get I/O command
	OR	B		;combine with step rate
	CALL	ISSUE		;issue command
RELO28	EQU	$-2
	CALL	WAIT		;wait for completion
RELO29	EQU	$-2
	POP	BC		;restore BC
;
;	update current track and return
;
UPTRAK	PUSH	AF		;save status
	PUSH	BC		;save
	PUSH	HL		;save
	IN	A,(@CYLNUM)	;get cylinder low
	LD	L,A		;HL = current cylinder
	IN	A,(@CYHNUM)	;get cylinder high
	LD	H,A		;pass to H
	LD	C,(IX+0)	;get cylinder offset
	LD	B,(IX+1)	;BC = offset
	OR	A		;clear carry
	SBC	HL,BC		;L = current cylinder
	LD	(IY+5),L	;update current cylinder
	POP	HL		;restore
	POP	BC		;restore
	POP	AF		;restore status
	RET			;done!
;
;	wait for command completion
;
WAIT	CALL	$TSTBSY		;busy?
RELO30	EQU	$-2
	JR	NZ,WAIT		;wait if yes
COMPLET	IN	A,(@STATUS)	;read status register
	AND	_SERROR		;any errors?
	RET	Z		;nope, go!
	JR	AERROR		;else interpret error
;
;	issue I/O command and wait for completion
;
ISSUE	PUSH	AF		;save I/O command
ISSUE1	CALL	$TSTBSY		;busy?
RELO31	EQU	$-2
	JR	NZ,ISSUE1	;wait for NOT busy
	CALL	SLOW		;disk slowdown
RELO62	EQU	$-2
	POP	AF		;restore command
	OUT	(@CMD),A	;issue FDC command
	EX	(SP),HL		;short delay
	EX	(SP),HL
;
;	wait for busy bit
;
ISSUE2	CALL	$TSTBSY		;busy?
RELO32	EQU	$-2
	JR	Z,ISSUE2	;wait for busy YES
	RET			;FDC is now BUSY!
;
;	interpret error code
;
;	ENTRY	A  =	status bits from operation
;		B  =	operation command #
;
;	EXIT	A  =	adjusted error code
;
AERROR	IN	A,(@ERROR)	;read error register
	LD	L,B		;pass I/O command
	LD	BC,8<8+0	;H=count, L=offset
;
ERROR1	RLA			;bit => carry
	JR	C,ERROR2	;go if found
	INC	C		;bump offset
	DJNZ	ERROR1		;go till bit found
;
	LD	A,@ERR99	;cannot find bit!
	RET			;return 'unknown error'
;
ERROR2	LD	A,L		;get command #
	CP	@FORMAT		;write command?
	LD	A,C		;get offset
	JR	C,$+4		;go if READ
	ADD	A,8		;offset to write
	LD	HL,ETABLE	;error table
RELO33	EQU	$-2
	LD	C,A		;pass offset
	LD	B,0		;BC = offset
	ADD	HL,BC		;HL => error code
	LD	A,(HL)		;get converted error
	RET			;return with it
;
	PAGE
;
;	$RDHDR	- read sector
;	$RDSEC	- read sector
;	$VERSEC	- verify sector
;	$RDCYL	- read sector
;
;	ENTRY	DE =	cylinder/sector
;		HL =>	I/O buffer
;
;	EXIT	Z  =	OK, A=0
;		NZ =	A = error code
;
$RDHDR	EQU	$
$RDSEC	EQU	$
$VERSEC	EQU	$
$RDCYL	EQU	$
	CALL	LOCK		;lock onto drive
RELO34	EQU	$-2
	BIT	4,(IY+3)	;implied seeks?
	CALL	NZ,SEEK		;seek cylinder if not
RELO35	EQU	$-2
	JP	NZ,UNLOCK	;go if error
RELO36	EQU	$-2
	BIT	4,(IY+3)	;implied seeks?
	CALL	Z,UPTASK	;update task file if yes
RELO37	EQU	$-2
	LD	A,CMDRED	;FDC command
	CALL	ISSUE		;issue command
RELO38	EQU	$-2
	CALL	WAIT		;wait for completed
RELO39	EQU	$-2
	RET	NZ		;go if any errors
;
;	read data from I/O data port
;
	LD	A,B		;get command
	CP	@VERSEC		;verify?
	PUSH	BC		;save
	LD	BC,0<8+@DATA	;count + data register
	JR	Z,RDVER		;go if verify
	INIR			;else load data
	JR	RDCONT		;continue
;
;	verify, do not load data to memory
;
RDVER	IN	A,(C)		;read a byte
	DJNZ	RDVER		;for 256 to flush buffer
;
RDCONT	POP	BC		;unstack
	CALL	COMPLET		;get resulting status
RELO40	EQU	$-2
	CALL	UPTRAK		;update current track
RELO41	EQU	$-2
	CALL	UNLOCK		;unlock drive
RELO42	EQU	$-2
	OR	A		;any errors?
	RET	NZ		;yes, go!
	LD	A,(IY+5)	;get current track
	SUB	(IY+9)		;read directory?
	JR	Z,RDDIR		;yes, read dir!
	XOR	A		;else NO error
	RET			;return OK
RDDIR	OR	@ERR06		;directory read error
	RET			;return in error
;
	PAGE
;
;	$FORMAT	- format device
;
;	ENTRY	HL =>	I/O buffer (256 bytes)
;
;	EXIT	Z  =	OK, device formatted
;		NZ =	A = error code
;
$FORMAT	CALL	LOCK		;lock onto drive
RELO43	EQU	$-2
	LD	DE,UNLOCK	;exit vector
RELO44	EQU	$-2
	PUSH	DE		;to stack
	CALL	DOINIT		;init/home drive
RELO45	EQU	$-2
	RET	NZ		;go if error!
;
;	locate free memory buffer
;
	LD	A,(ROMID)	;read ROM
	CP	MODIII		;mod III?
	LD	HL,(@HIGH3)	;get high memory III
	JR	Z,$+5		;go if yes
	LD	HL,(@HIGH1)	;get high memory I
	DEC	H		;less 256 byte buffer
	LD	L,0		;highest even page
;
FMTLOOP	CALL	FMTCYL		;format cylinder
RELO46	EQU	$-2
	RET	NZ		;go if I/O error
;
	LD	A,(IY+05)	;get current cylinder
	SUB	(IY+06)		;at highest cylinder?
	RET	Z		;yes, exit!
	INC	(IY+05)		;bump current cylinder
	JR	FMTLOOP		;continue
;
;	$FMTCYL - format all heads for desired cylinder
;
FMTCYL	PUSH	BC		;save
	PUSH	DE		;save
	LD	A,(IY+07)	;get DCT data
	AND	1FH		;A = highest sector
	INC	A		;correct to actual
	LD	C,A		;C = sector count
	LD	D,(IX+04)	;get interleave factor
;
	LD	B,C		;sectors/track
	XOR	A		;load zero
;
BUILD1	LD	(HL),A		;init sector
	INC	L		;bump pointer
	LD	(HL),-1		;unused sector
	INC	L		;bump pointer
	DJNZ	BUILD1		;go for count
;
BUILD2	LD	(HL),A		;init sector
	INC	L		;bump sector
	JR	NZ,BUILD2	;go for remainder
;
	LD	E,A		;init sector
	LD	B,C		;secs/track
;
BUILD3	CP	C		;end of track?
	JR	C,BUILD4	;go if not
	SUB	C		;correct
BUILD4	LD	L,A		;save
	SLA	L		;* 2
	INC	L		;correct
	BIT	7,(HL)		;unused?
	JR	NZ,BUILD5	;go if yes
	INC	A		;next
	JR	BUILD4		;try again
;
BUILD5	LD	(HL),E		;set sector
	INC	E		;next
	ADD	A,D		;next interleave
	DJNZ	BUILD3		;go for count
;
	POP	DE		;unstack
	POP	BC
;
	PUSH	BC		;save drive
	LD	E,0		;init sector
	LD	A,(IY+07)	;get DCT data
	RLCA			;high 3 bits => low
	RLCA
	RLCA
	AND	07H		;A = head count -1
	INC	A		;correct to actual
	LD	L,A		;save
;
BUILD6	PUSH	HL		;save surface
	CALL	BUILD8		;write track
RELO47	EQU	$-2
	POP	HL		;restore
	JR	NZ,BUILD7	;go if error
	LD	A,(IY+07)	;get DCT data
	AND	1FH		;A = highest sector
	INC	A		;correct to actual
	ADD	A,E		;add to sector
	LD	E,A		;restore
	DEC	L		;less head count
	JR	NZ,BUILD6	;go for count
	XOR	A		;set NO error
;
BUILD7	POP	BC		;restore
	RET			;next cylinder
;
BUILD8	LD	A,(IY+07)	;DCT data
	AND	1FH		;A = highest sector
	INC	A		;correct
	OUT	(@SECCNT),A	;to FDC sector count
	LD	L,0		;HL => buffer
	LD	D,(IY+05)	;get current cylinder
	LD	A,CMDFMT	;I/O command
	JP	DOWRIT		;write track and return
RELO48	EQU	$-2
;
	PAGE
;
;	$WRSEC	- write sector
;	$WRSYS	- write system sector
;	$WRCYL	- write cylinder
;
;	ENTRY	DE =	cylinder/sector
;		HL =>	I/O buffer
;
;	EXIT	Z  =	OK, A=0
;		NZ =	A = error code
;
$WRSEC	LD	A,CMDWRT	;I/O command
	JR	GOWRIT		;go common
;
$WRSYS	LD	A,CMDWRT+1	;I/O command
	JR	GOWRIT		;go common
;
$WRCYL	LD	A,CMDFMT	;I/O command
;
GOWRIT	PUSH	AF		;save I/O command
	CALL	LOCK		;lock onto drive
RELO49	EQU	$-2
	POP	AF		;restore command
	CALL	DOWRIT		;execute I/O
RELO50	EQU	$-2
	JP	UNLOCK		;unlock drive
RELO51	EQU	$-2
;
DOWRIT	LD	(WRCMD),A	;pass write command
RELO52	EQU	$-2
;
	LD	A,(IY+03)	;get DCT data
	AND	80H		;bit 7?
	LD	A,@ERR15	;'soft write protect'
	RET	NZ		;go if yes!
;
	BIT	4,(IY+3)	;implied seeks?
	CALL	NZ,SEEK		;seek cylinder if not
RELO53	EQU	$-2
	RET	NZ		;go if error
	BIT	4,(IY+3)	;implied seeks?
	CALL	Z,UPTASK	;update task file if yes
RELO54	EQU	$-2
	LD	A,0		;FDC command
WRCMD	EQU	$-1
	CALL	ISSUE		;issue command
RELO55	EQU	$-2
;
	LD	BC,0<8+@DATA	;count + I/O address
	OTIR			;load controller buffer
;
	CALL	WAIT		;wait for completed
RELO56	EQU	$-2
	RET	NZ		;go if any errors
	CALL	COMPLET		;get resulting status
RELO57	EQU	$-2
	JP	UPTRAK		;update curr track & ret
RELO58	EQU	$-2
;
	PAGE
;
;	$UPTASK - update disk register task file
;
UPTASK	CALL	$TSTBSY		;test if drive busy
RELO59	EQU	$-2
	JR	NZ,UPTASK	;wait till 'clear'
;
	PUSH	HL		;save 'em
	PUSH	DE
	PUSH	BC
;
	LD	A,(IY+07)	;get DCT data
	AND	1FH		;A = highest sector
	INC	A		;correct to actual
	LD	C,A		;C = sector/head count
;
	LD	A,E		;get sector # requested
	LD	E,0		;init head #
;
UPTASK1	SUB	C		;less secs/track
	JR	C,UPTASK2	;go if found
	INC	E		;bump head #
	JR	UPTASK1		;continue
;
UPTASK2	PUSH	AF		;save sector #
	LD	A,E		;get head #
	CALL	SELECT		;select drive for file
RELO60	EQU	$-2
	POP	AF		;get sector #
	ADD	A,C		;add less subtract
	ADD	A,(IX+02)	;+ sector offset
	OUT	(@SECNUM),A	;load sector # register
	LD	A,1		;single sector
	OUT	(@SECCNT),A	;load sector count reg
	LD	A,PRECYL	;write precomp cylinder
	OUT	(@PRECMP),A	;load precomp register
;
	LD	L,(IX+00)	;get cylinder offset
	LD	H,(IX+01)	;HL = offset
	LD	E,D		;pass cylinder needed
	LD	D,0		;DE = needed cylinder
	ADD	HL,DE		;add offset factor
	LD	A,L		;get LSB cylinder
	OUT	(@CYLNUM),A	;load LSB cyl register
	LD	A,H		;get MSB cylinder
	OUT	(@CYHNUM),A	;load MSB cyl register
;
	POP	BC		;unstack
	POP	DE
	POP	HL
	RET			;done, task file loaded!
;
;	delay for valid disk status
;
SLOW	PUSH	BC		;save
	LD	B,30		;delay count
	DJNZ	$		;wait here
	POP	BC		;restore
	RET			;can test now
;
;	error conversion table
;
ETABLE	EQU	$
;
RTABLE	DEFB	@ERR07		;7 - bad block detect
	DEFB	@ERR04		;6 - uncorrectable error
	DEFB	@ERR01		;5 - CRC error ID field
	DEFB	@ERR05		;4 - ID field not found
	DEFB	@ERR00		;3 - unused
	DEFB	@ERR03		;2 - aborted command
	DEFB	@ERR02		;1 - track 000 error
	DEFB	@ERR05		;0 - DAM not found
;
WTABLE	DEFB	@ERR07		;7 - bad block detect
	DEFB	@ERR12		;6 - uncorrectable error
	DEFB	@ERR09		;5 - CRC error ID field
	DEFB	@ERR13		;4 - ID field not found
	DEFB	@ERR00		;3 - unused
	DEFB	@ERR11		;2 - aborted command
	DEFB	@ERR10		;1 - track 000 error
	DEFB	@ERR13		;0 - DAM not found
;
IODVRL	EQU	$-DRIVER	;length of driver
;
