RESTOR ;********************************************************
 ;		       RESTORE/CMD			;
 ;		   by David Rollinson			;
 ;	     Dementia Software --  Apr 1986		;
 ;********************************************************
 
 	;DOS subroutine definitions
 CHRDSP	EQU	0033H
 CLOSE	EQU	4428H
 CURSOR	EQU	4020H
 DISKON	EQU	445EH
 DOS	EQU	402DH
 DOSERR	EQU	4409H
 DSPMSG	EQU	4467H
 GET	EQU	4436H
 OPEN	EQU	4424H
 PUTV	EQU	443CH
 SPINON	EQU	4416H
 
 GAT	EQU	6000H
 HIT	EQU	6100H
 FDES	EQU	6200H
 
 	ORG	5200H
 RSTABL	DEFB	0AH
 	DEFM	'These files are RESTORABLE...'
 	DEFW	0D0AH
 UNABLE	DEFB	0AH
 	DEFM	'That file cannot be restored, '
 	DEFM	'sorry!'
 	DEFB	0DH
 ALLDON	DEFB	0AH
 	DEFM	'File RESTORED... courtesy of '
 	DEFM	'Dementia Software -- April 1986'
 	DEFB	0DH
 INTROM	DEFB	0AH
 	DEFM	'RESTORE V2.1'
 	DEFB	0AH
 	DEFM	'Use form:   1. '
 	DEFM	'RESTORE ?:n   (where n = Drive #)'
 	DEFB	0AH
 	DEFM	'      or    2. RESTORE filename:n'
 	DEFB	0DH
 BADDRV	DEFM	'Bad or missing Drive #'
 	DEFB	0DH
 FILNAM	DEFM	'           '
 	DEFB	03H
 FDENAM	DEFS	0BH
 	DEFB	03H
 LSTFLG	DEFB	00H		;Set to ? if lsting files
 
 ENTRY	LD	DE,ARGMNT
 	CALL	GETARG
 	EX	DE,HL		;HL => filespec
 	LD	A,(HL)
 	CP	03H
 	JR	Z,INTRO		;Jump if no arguement
 	CALL	GETDRV
 	JR	Z,VALID
 	LD	HL,BADDRV
 	JP	GODOS
 VALID	LD	(DRIVE),A	;Save Drive # in Ascii
 	SUB	30H		;Convert to Hex
 	CALL	GETGPL		;Calculate then
 	LD	(GPL),A		; save # grans per lump
 	LD	DE,FILNAM
 	LD	A,'?'
 	CP	(HL)		;? listing (not rstoring)
 	JR	NZ,MOVCHR
 	LD	(LSTFLG),A
 	LD	(SRCHFL),A
 	JR	GETDIR
 INTRO	LD	HL,INTROM
 	JR	GODOS
 
 MOVCHR	LD	A,(HL)
 	CP	03H
 	JR	Z,GETDIR
 	CP	':'
 	JR	Z,GETDIR
 	CP	'/'
 	JR	Z,GETEXT
 	LD	(DE),A
 	INC	HL
 	INC	DE
 	JR	MOVCHR
 GETEXT	LD	DE,FILNAM+08H
 	INC	HL
 	JR	MOVCHR
 
 GETDIR	LD	HL,6000H
 	LD	A,(DRIVE)
 	CALL	RDDIR
 	JP	NZ,DOS		;Exit if Dir. read error
 	LD	A,(HIT+1FH)
 	ADD	A,08H
 	LD	(NSECS),A
 	LD	A,(LSTFLG)
 	LD	(SRCHFL),A
 	CP	'?'
 	JR	NZ,RESTOR
 	LD	HL,RSTABL
 	CALL	DSPMSG
 	LD	BC,00FFH
 	LD	HL,FILNAM
 	LD	DE,FDENAM
 CHKNXT	XOR	A
 	LD	(MASK),A	;Killed FPDE
 	LD	A,(LSTFLG)
 	LD	(SRCHFL),A
 	CALL	NXTFDE		;Find next killed FPDE
 	JR	NZ,ENDDSP	;Jp if none left
 	LD	A,(FDENAM)
 	OR	A		;? a zero FPDE
 	JR	Z,CHKNXT
 	EXX
 	LD	HL,FDENAM
 	LD	DE,FILNAM
 	LD	BC,0BH
 	LDIR
 	EXX
 	CALL	CANRES		;Can it be restored?
 	CALL	Z,DSPNAM	;Yes, then display it
 	JR	CHKNXT
 ENDDSP	LD	A,0DH
 	CALL	CHRDSP		;Enter
 	JP	DOS
 
 CANT	LD	HL,UNABLE
 GODOS	CALL	DSPMSG
 	JP	DOS
 
 RESTOR	LD	B,00H		;Init. sector #
 	LD	C,0FFH		;Init. FDE # in sector
 	LD	HL,FILNAM
 	LD	DE,FDENAM
 NOTTH1	XOR	A		;Mask for killed FPDE
 	LD	(MASK),A
 	CALL	NXTFDE		;Find FPDE with this name
 	JR	NZ,CANT		;No more FPDE's to check
 	CALL	CANRES		;Check restorable
 	JR	NZ,NOTTH1	;Get restorable FPDE
 
 ;Reset FDE used flag's on all relevant FDE's,
 ;reallocate grans in GAT (gran alloc'n table) &
 ;restore Hashcode in HIT (hashcode index table).
 ;	Entry:	BC specifies FPDE (sector/entry)
 ;	Exit:	All registers used
 
 RESFDE	LD	DE,FDES
 	CALL	FDEADR		;Get FDE address is IX
 	SET	4,(IX)		;Reset FDE used flag
 	LD	HL,FILNAM
 	LD	DE,HIT
 	CALL	REHASH		;Replace hashcode in FDE
 	LD	HL,GAT
 	LD	DE,16H
 	ADD	IX,DE		;Point HL to EE's
 NXTRES	LD	A,(IX)		;Get relative byte in GAT
 	INC	IX		;Index 2nd byte of EE
 	CP	0FFH		;? end of EE's
 	JR	Z,RSTRED	; & go next section if so
 	CP	0FEH		;? pointer to FXDE & cont
 	JR	Z,NEXTDE	; checking FXDE if so
 	LD	C,A		;C = relative byte in GAT
 	LD	A,(IX)		;A = gran offset/# contig
 	INC	IX		;Index next EE
 	CALL	RESGRA		;Reset GAT bits for EE
 	JR	NXTRES		;Repeat for next EE
 NEXTDE	LD	A,(IX)		;Get DEC of next FXDE
 	CALL	FDE		; & calc sector/rel FDE
 	JR	RESFDE		;Cont for this new FXDE
 ;-------------------------------;
 
 ;Replace correct HASHCODE in HIT
 ;	Entry:	BC specifies FDE (sector/entry)
 ;		HL => filename (11 dec characters)
 ;		DE => HIT in memory
 ;	Exit:	All registers saved
 ;	Uses:	HASH,DEC
 
 REHASH	PUSH	HL		;Save HL
 	PUSH	DE		;Save DE
 	CALL	HASH		;Calculate hash code for
 	PUSH	AF		; filename & save
 	CALL	DEC		;Calc DEC from BC
 	EX	DE,HL		;HL => HIT
 	LD	D,00H		;Index HIT by
 	LD	E,A		; value of
 	ADD	HL,DE		; DEC
 	POP	AF		;Put hashcode at this
 	LD	(HL),A		; location in HIT
 	POP	DE		;Retrieve DE
 	POP	HL		;Retrieve HL
 	RET
 ;-------------------------------;
 
 ;Calculate HASHCODE of a 11(dec) character filename
 ;	Entry:	HL points to filename
 ;	Exit:	A  contains HASHCODE
 ;		No other registers altered
 
 HASH	PUSH	HL
 	PUSH	BC
 	LD	BC,0B00H
 HA1	LD	A,(HL)
 	INC	HL
 	XOR	C
 	RLCA
 	LD	C,A
 	DJNZ	HA1
 	LD	A,C
 	OR	A
 	JR	NZ,HA2
 	INC	A
 HA2	POP	BC
 	POP	HL
 	RET
 ;-------------------------------;
 
 ;Calculate DEC (directory entry code)
 ;	Entry:	B = sector # in directory
 ;		C = relative FDE in that sector
 ;	Exit:	A = DEC
 ;		No other registers altered
 
 DEC	LD	A,C
 	RRCA
 	RRCA
 	RRCA
 	OR	B
 	RET
 ;-------------------------------;
 
 RSTRED	LD	A,(DRIVE)	;Get drive # (ASCII)
 	LD	HL,6000H	;DIR in memory
 	CALL	WTDIR		;Write DIR back to disk
 	JP	NZ,DOS		;Jump on write error
 	LD	HL,ALLDON
 	JP	GODOS
 
 ;Reset 'granule allocated' bits in GAT (gran alloc table)
 ;	Entry:	C = relative byte in GAT
 ;		A = gran offset / # contiguous grans
 ;		HL => GAT in memory
 ;	Exit:	Only AF altered
 
 RESGRA	PUSH	HL		;Save ptr to EE's
 	PUSH	DE
 	LD	B,00H		;BC = rel byte in GAT
 	ADD	HL,BC		;HL --> relevant GAT byte
 	CALL	FDE		;Now C = gran offset
 				;    B = # contig grans-1
 	LD	D,B
 	INC	D		;D = # contiguous grans
 	LD	A,(GPL)		;Get # grans
 	DEC	A		; per lump
 	RLCA			; & calculate maximum
 	RLCA			; allowed value for byte
 	RLCA			; two of SET n,(HL)
 	OR	0C6H		; instruction &
 	LD	B,A		; save in B.
 	LD	A,C		;Calculate which bit
 	RLCA			; to set initially
 	RLCA			; from granule offset
 	RLCA			; value, & modify
 	OR	0C6H		; SET n,(HL) instruction
 RNGBIT	LD	(BITSET),A	; accordingly
 	SET	0,(HL)		;Set next bit in GAT
 BITSET	EQU	$-1		;To change which bit set
 	DEC	D		;Decr # contig grans
 	JR	Z,GRDONE	;Return if finished
 	CP	B		;? --> next GAT byte yet
 	JR	NZ,NRBIT	;No, then do nxt bit
 	INC	HL		;Point to nxt GAT byte
 	LD	A,0C6H		;Start again at bit 0
 	JR	RNGBIT		;Cont with next GAT bit
 NRBIT	ADD	A,08H		;Set next higher bit
 	JR	RNGBIT		; & continue
 GRDONE	POP	DE
 	POP	HL		;Restore ptr to EE
 	RET
 ;-------------------------------;
 
 ;Check if file can be restored
 ;	Entry:	HL => filename to test
 ;		DE => FPDE filename buffer (03H at end)
 ;		BC => FPDE to test restorability
 ;	Exit:	Z set if file restorable
 ;		NZ set otherwise
 ;		Only AF altered
 
 CANRES	PUSH	IX		;Save ptr to FPDE
 	PUSH	BC		;Save sector/FDE in sect
 	LD	A,10H		;Mask for In Use FPDE
 	LD	(MASK),A
 	LD	(SRCHFL),A
 	LD	BC,0000H	;Zero sector/FDE # in sec
 	CALL	IFEXIS		;? filename already lives
 	POP	BC		;Restore sect/FDE in sect
 	POP	IX		;Restore ptr to FPDE
 	JR	NZ,IFINT
 	XOR	A
 	INC	A		;Set NZ
 	RET
 ;-------------------------------;
 
 ;Checks for an intact FDE sequence (FPDE's & FXDE's) &
 ;that no granules have been re-allocated in the GAT.
 ;	Entry:	IX = pointer to FPDE to check
 ;		BC => sector/rel entry in sector
 ;	Exit:	Z set if entry intact (else NZ)
 ;		Only AF altered
 
 IFINT	PUSH	HL
 	PUSH	DE
 	PUSH	BC
 IIR	PUSH	IX
 	POP	HL		;HL indexes ext elements
 	BIT	4,(HL)		;Check FDE is free
 	JR	NZ,IFINTR	; & return if not
 	LD	DE,16H
 	ADD	HL,DE
 NXTEE	LD	A,(HL)		;Get 1st byte of EE
 	CP	0FFH		;? end of extents
 	JR	Z,IFINTR	;Yes, return
 	CP	0FEH		;? pointer to FXDE
 	JR	Z,EXTDE		;Yes, then check FXDE
 	INC	HL
 	PUSH	BC
 	LD	C,A
 	LD	A,(HL)
 	INC	HL		;Point to next EE
 	LD	DE,GAT
 	CALL	GRANS
 	POP	BC
 	JR	NZ,IFINTR
 	JR	NXTEE		; & repeat
 
 EXTDE	INC	HL
 	LD	A,(HL)		;DEC for next FXDE
 	PUSH	BC		;Save prev FDE location
 	CALL	FDE		;Get loc'n of this FXDE
 	LD	DE,FDES
 	CALL	FDEADR
 	LD	A,(IX+1)	;Get reverse chain ptr
 	CALL	FDE		; & see where it points
 	POP	DE		;Where it should point
 	LD	A,D
 	CP	B
 	JR	NZ,IFINTR	;Rev chain doesn't match
 	LD	A,E
 	CP	C
 	JR	NZ,IFINTR	;Rev chain doesn't match
 	LD	A,(HL)		;Recalculate B & C from
 	CALL	FDE		; forward chain pointer,
 	LD	DE,FDES		;Point to FDEs in memory
 	CALL	FDEADR		;Point IX to FXDE
 	JR	IIR		; & repeat checks
 IFINTR	POP	BC
 	POP	DE
 	POP	HL
 	RET
 ;-------------------------------;
 
 ;Display filename at next screen filename position
 ;	Entry:	HL => 11 (dec) char filename (FPDE form)
 ;		   and terminated by 03H.
 ;	Exit:	Only AF altered
 ;	Uses:	CHRDSP (0033H), TAB16
 
 DSPNAM	PUSH	BC
 	PUSH	DE
 	PUSH	HL
 	CALL	TAB16		;Tab to next 16 space pos
 	LD	B,08H
 NAM1	LD	A,(HL)
 	INC	HL
 	CP	' '
 	JR	Z,DSPEXT
 	CALL	CHRDSP
 	DJNZ	NAM1
 DSPEXT	LD	DE,0008H
 	POP	HL
 	PUSH	HL
 	ADD	HL,DE		;Point to extension
 	LD	A,(HL)
 	CP	' '
 	JR	Z,DNRET
 	LD	A,'/'
 	CALL	CHRDSP
 EXT1	LD	A,(HL)
 	INC	HL
 	CP	03H
 	JR	Z,DNRET
 	CALL	CHRDSP
 	JR	EXT1
 DNRET	POP	HL
 	POP	DE
 	POP	BC
 	RET
 ;-------------------------------;
 
 ;Position cursor to next 16 space tab position
 ;	Entry:	No data
 ;	Exit:	Only AF altered
 ;	Uses:	CHRDSP (0033H)
 
 TAB16	PUSH	HL
 	LD	HL,(CURSOR)
 	DEC	HL
 	LD	A,L
 	OR	0FH
 	LD	L,A
 	INC	HL
 	BIT	6,H
 	JR	Z,T16R1
 	LD	A,0DH
 	CALL	CHRDSP
 	JR	T16R2
 T16R1	LD	(CURSOR),HL
 T16R2	POP	HL
 	RET
 ;-------------------------------;
 
 ;Searches directory starting at Sector B, Entry C, for a
 ;specific FDE or type of FDE.
 ;If SRCHFL =  '?' find first FDE matching MASK
 ;If SRCHFL <> '?' find first FDE matching MASK & with
 ;	      filename matching that pointed to by HL.
 ;Entry: BC specifies sector/FDE in sector
 ;	DE => 12 (dec) byte buffer (last being 03H)
 ;	HL => filename to compare with
 ;Exit:	DE => filename from relevant FDE found
 ;	BC specifies relevant FDE found (form as above)
 ;	IX => FDE address in memory
 ;	HL & DE saved
 ;	Z set if matching FDE found
 ;	NZ set if not found
 ;Uses:	FDEADR, GTDENM, COMPAR
 
 IFEXIS	PUSH	DE
 	LD	DE,FDES
 	CALL	FDEADR		;IX => FDE in memory
 	POP	DE
 	LD	A,(IX)		;Get 1st byte of FDE
 	AND	90H		;Leave only FPDE/FXDE &
 				; live/killed bits
 	PUSH	HL
 	LD	HL,MASK		;Is it of the required
 	CP	(HL)		; FDE type?
 	POP	HL
 	JR	NZ,NXTFDE	;No, then check next FDE
 	CALL	GFDENM		;Get Filename from FPDE
 	LD	A,(SRCHFL)	;Check whether listing
 	CP	'?'		; restorable files. If
 	RET	Z		; so skip filename match
 	PUSH	HL
 	CALL	COMPAR		;Do filenames match?
 	POP	HL
 	RET	Z		;Ret if so
 NXTFDE	INC	C		;Inc FDE within sector
 	BIT	3,C		;Was it last in sector
 	JR	Z,IFEXIS	;No, then try this FDE
 	LD	C,00H		;Yes, then make zero &
 	INC	B		; incr sector counter
 	LD	A,(NSECS)	;Check that have not
 	CP	B		; reached end of
 	JR	NZ,IFEXIS	; directory yet
 	INC	A		;If at end, set NZ flag
 	RET			; and ret (ie not found)
 ;-------------------------------;
 
 ;Returns address of FDE in IX
 ;	Entry:	BC specifies sector/FDE # in sector
 ;		DE => start of FDEs in memory
 ;	Exit:	IX => FDE in memory
 ;		Only IX & flags altered
 
 FDEADR	PUSH	BC
 	PUSH	DE
 	PUSH	DE
 	POP	IX
 	LD	DE,0100H
 	INC	B
 	JR	FD2
 FD1	ADD	IX,DE
 FD2	DJNZ	FD1
 	LD	DE,0020H
 	LD	B,C
 	INC	B
 	JR	FD4
 FD3	ADD	IX,DE
 FD4	DJNZ	FD3
 	POP	DE
 	POP	BC
 	RET
 ;-------------------------------;
 
 ;Gets filename (11 dec ASCII characters) from FPDE
 ;	Entry:	IX => FPDE
 ;		DE => buffer (11 dec bytes) to put name
 ;	Exit:	Buffer contains filename
 ;		All registers saved
 
 GFDENM	PUSH	HL
 	PUSH	DE
 	PUSH	BC
 	PUSH	IX
 	POP	HL
 	LD	BC,0005H
 	ADD	HL,BC
 	LD	BC,0BH
 	LDIR
 	POP	BC
 	POP	DE
 	POP	HL
 	RET
 ;-------------------------------;
 
 ;Find FDE (file directory entry) given its DEC
 ;	Entry:	A = DEC (directory entry code) of FDE
 ;	Exit:	B = Sector # in directory
 ;		C = # of entry in sector
 ;		Only BC altered
 
 FDE	PUSH	AF
 	LD	C,A
 	AND	1FH		;Clear bits 5-7
 	LD	B,A		;Sector # => B
 	LD	A,C
 	RLCA
 	RLCA
 	RLCA			;Justify entry #
 	AND	07H		; & clr non-relevant bits
 	LD	C,A		;Entry # in sector => C
 	POP	AF
 	RET
 ;-------------------------------;
 
 ;Get drive # from a filespec
 ;	Entry:	HL => filespec (ended by 03H)
 ;	Exit:	A = Drive # in ASCII
 ;		Only AF altered
 ;		NZ set if invalid Drive #
 
 GETDRV	PUSH	HL
 GE1	LD	A,(HL)
 	INC	HL
 	CP	':'
 	JR	Z,GETNUM
 	SUB	03H
 	JR	NZ,GE1
 INVDRV	INC	A		;Set NZ
 	POP	HL
 	RET
 GETNUM	LD	A,(HL)
 	CP	'0'
 	JR	C,INVDRV
 	CP	'9'
 	JR	NC,INVDRV
 	CP	A		;Set Z flag
 	POP	HL
 	RET
 ;-------------------------------;
 
 ;Get # grans per lump (GPL) for drive specified by A reg
 ;	Entry:	A = drive # (in Hex)
 ;	Exit:	A = GPL (in Hex)
 ;		Only AF altered
 
 GETGPL	PUSH	HL
 	PUSH	DE
 	PUSH	BC
 	LD	HL,4371H+05H	;Point to GPL values
 	LD	DE,000AH
 	INC	A
 	LD	B,A
 	JR	NXTGPL
 NXTDRV	ADD	HL,DE
 NXTGPL	DJNZ	NXTDRV
 	LD	A,(HL)
 	POP	BC
 	POP	DE
 	POP	HL
 	RET
 ;-------------------------------;
 
 ;Check whether Grans are allocated in GAT sector
 ;	Entry:	C = relative byte in GAT to start testing
 ;		A = gran offset / # contiguous grans
 ;		DE => GAT in memory
 ;	Exit:	Z set if grans all unallocated
 ;		NZ if some grans allocated to file(s)
 ;		Only AF altered
 ;	Uses:	FDE
 
 GRANS	PUSH	HL
 	PUSH	DE
 	PUSH	BC
 	EX	DE,HL		;HL => GAT
 	LD	B,00H
 	ADD	HL,BC		;Point HL to relevant byt
 	CALL	FDE		;Now C = gran offset
 				;    B = # contig grans-1
 	LD	D,B
 	INC	D		;D = # contiguous grans
 
 NGATBY	LD	A,(GPL)
 	LD	B,A		;B = # GPL
 	INC	C
 	LD	A,(HL)		;Get GAT byte
 	JR	JUSTFY
 GROFST	DEC	B
 	RRCA
 JUSTFY	DEC	C		;Justify to correct
 	JR	NZ,GROFST	; granule offset
 
 TNBIT	BIT	0,A		;Test next GAT bit
 	JR	NZ,GRRET	;Gran reallocated
 	DEC	D
 	JR	Z,GRRET		;All grans still free
 	RRCA
 	DJNZ	TNBIT
 	INC	HL
 	LD	C,00H		;Gran offset = 0
 	JR	NGATBY		;Check this GAT byte
 
 GRRET	POP	BC
 	POP	DE
 	POP	HL
 	RET
 ;-------------------------------;
 
 ;Retrieve argument from DOS command line buffer
 ;	Entry:	HL => argument
 ;		DE => where to put it (buffer)
 ;	Exit:	DE => argument (terminated by 03H)
 ;		Only AF altered
 
 GETARG	PUSH	HL
 	PUSH	DE
 GTR1	LD	A,(HL)
 	INC	HL
 	CP	0DH
 	JR	Z,GOTARG
 	LD	(DE),A
 	INC	DE
 	JR	GTR1
 GOTARG	LD	A,03H
 	LD	(DE),A
 	POP	DE
 	POP	HL
 	RET
 ;-------------------------------;
 
 ;COMPAR  Compares source string pointed to by DE with
 	;destination string pointed to by HL. Both must
 	;end with 03H. Returns with Z flag set if strings
 	;are equal, else cleared. On return, HL points to
 	;byte following last matching character.
 	;All other registers saved.
 
 COMPAR	PUSH	DE
 	PUSH	AF		;Save registers
 CPNEXT	LD	A,(DE)		;Get next char from src
 	CP	(HL)		;  & cmp with dest'n
 	INC	DE
 	INC	HL		;Bump pointers
 	JR	NZ,ENDCMP	;Finish if unequal
 	CP	03H		;? last char in string
 	JR	NZ,CPNEXT	;No, then cmp next
 ENDCMP	POP	DE		;Get saved AF
 	LD	A,D		;  & restore A
 	POP	DE		;Restore old DE
 	RET			;Ret with Z set approp
 	;------------------------------------------------
 
 ;********************* DIRECTORY I/O ********************
 ;RDDIR	Reads a directory into memory. On entry...
 ;	HL points to buffer to read directory into
 ;	A contains ASCII char for drive # to read from
 ;				       On exit...
 ;	HL points to byte following last byte read
 ;	C contains # sectors in DIR/SYS read
 ;	B is altered. All other registers saved.
 ;WTDIR	Writes a directory from memory to disk. On entry
 ;	HL points to start of directory in memory
 ;	A contains ASCII char for drive # to write to
 ;	Alters BC, HL, & AF.
 ;--------------------------------------------------------
 
 DIRFCB	DEFM	'DIR/SYS:                        '
 RDDIR	PUSH	DE
 	LD	(DIRFCB+8),A
 	SUB	'0'
 	CALL	POWRUP
 	JR	NZ,IOERR
 	LD	DE,DIRFCB
 	LD	B,00H
 	CALL	OPEN
 	JR	NZ,IOERR
 	LD	A,(DIRFCB+0CH)		;Get EOF (middle)
 	LD	C,A
 NXTSEC	CALL	GET
 	JR	Z,NOERR
 	CP	06H			;? read protected
 	JR	Z,NOERR
 	CP	1CH		;? EOF
 	JR	NZ,IOERR
 	LD	HL,(DIRFCB+03H)	;Point to end of buffer
 DRDONE	CALL	CLOSE
 	POP	DE
 	RET
 NOERR	LD	A,(DIRFCB+04H)	;Increment buffer by 256
 	INC	A
 	LD	(DIRFCB+04H),A
 	CALL	SPINON		;Keep drives rotating
 	JR	NXTSEC
 
 IOERR	OR	80H		;Set bit 7 (simulate err)
 	CALL	DOSERR
 	POP	DE
 	RET
 
 POWRUP	PUSH	BC
 	LD	C,A		;Save Drive #
 	LD	B,02H		;Try twice
 PWRAGN	LD	A,C		;Get Drive #
 	CALL	DISKON
 	JR	Z,DKREDY
 	DJNZ	PWRAGN
 DKREDY	POP	BC
 	OR	A
 	RET
 	;------------------------------------------------
 WTDIR	PUSH	DE
 	LD	(DIRFCB+8),A	;Save Drive # in filespec
 	SUB	'0'
 	CALL	POWRUP		;Power up & ? ready
 	JR	NZ,IOERR
 	LD	DE,DIRFCB
 	LD	B,00H
 	CALL	OPEN		;Open DIR/SYS
 	JR	NZ,IOERR
 	LD	A,(DE)		;Set flag to cause file
 	OR	01H		; to be written
 	LD	(DE),A		; read protected
 	LD	A,(DIRFCB+0CH)	;Get # sectors in DIR/SYS
 	LD	C,A		; in C
 WRTNXT	CALL	PUTV		;Save sector with verify
 	JR	NZ,IOERR
 	CALL	SPINON		;Keep drives rotating
 	LD	A,(DIRFCB+0AH)	;Get sector up to
 	CP	C		; & compare with # secs
 	JR	NZ,WR1
 	POP	DE
 	RET
 WR1	LD	A,(DIRFCB+04H)	;Add 256 to buffer
 	INC	A		; pointer
 	LD	(DIRFCB+04H),A	;
 	JR	WRTNXT
 ;********************************************************
 
 IOBUFF	DEFS	0100H		;Sector buffer
 ARGMNT	DEFS	20H		;Argument from screen
 MASK	DEFS	01H		;Mask for FDE type
 DRIVE	DEFS	01H		;Drive # in ASCII
 GPL	DEFS	01H		;# of granules / lump
 NSECS	DEFS	01H		;# of sectors of FDEs
 SRCHFL	DEFS	01H
 
 	END	ENTRY
