; ptld3/asm - kjw/bqsd - 04/83
;
; revised 04/21/83 - kjw/bqsd
;
	TITLE	'<PowerTOOL 1.00 Loader III>'
;
	SUBTTL	'<by Kim Watt - Copyright (C) 1983 Breeze/QSD, Inc. - Dallas, TX>'
;
;	equates
;
BUFFER	EQU	5000H-600H	;end of buff-length
NMI	EQU	0E4H		;NMI control port
FDC	EQU	0F0H		;FDC command/status
TRACK	EQU	0F1H		;FDC track register
SECTOR	EQU	0F2H		;FDC sector register
XFER	EQU	0F3H		;FDC transfer register
SELFDC	EQU	0F4H		;FDC select register
;
CLEAR	EQU	0D0H		;fdc reset command
ETX	EQU	000H		;end of text marker
DRIVE	EQU	081H		;drive select code
;
	ORG	4400H		;start loader
;
;	head is over track one, read ID marks
;
ENTRY	CALL	CLS		;clear video
	CALL	MEMTEST		;test memory
	CALL	IDMARKS		;read id marks
	CP	40H		;< 40H?
	JP	C,IERROR	;go if yes!
	CP	51H		;> 50H?
	JP	NC,IERROR	;protection error!
;
	CALL	STEPIN		;move head to track 2
	CALL	STEPIN		;track 3
	CALL	STEPIN		;track 4
	CALL	STEPIN		;track 5
;
;	sectors are protected here, check 'em out
;
	CALL	PROTECT		;check protection
;
	CALL	STEPIN		;move head to track 6
	CALL	IDMARKS		;read ID marks 1 time
	SUB	40H		;lowest possible value
	JP	C,IERROR	;go if error
	CP	29H		;max value now
	JP	NC,IERROR	;go if error!
;
;	begin program load here
;
	LD	HL,0		;init buffer
	LD	IY,0		;init checksum
	EXX			;save here
;
LOAD	CALL	BYTEBC		;fetch 2 bytes
	PUSH	BC		;save on stack
	CALL	BYTEBC		;fetch 2 more
	LD	H,B		;pass 'em
	LD	L,C
	POP	BC		;restore counter
;
	LD	A,B		;get bytes
	AND	C		;check for 0000 entry
	JR	NZ,LOAD1	;go if nz
	OR	B		;check for 0000
	OR	C		;any bits at all?
	JP	NZ,LERROR	;go data error
;
;	hl = entry point, verify checksum
;
	PUSH	HL		;save entry
	CALL	BYTEBC		;fetch checksum
	PUSH	IY		;IY = checksum
	POP	HL		;HL = checksum
	OR	A		;clear carry flag
	SBC	HL,BC		;test checksum
	JP	NZ,LERROR	;go checksum error
;
	RET			;go program!
;
LOAD1	INC	A		;A=0?
	JP	NZ,LERROR	;data error!
;
	CALL	BYTEBC		;fetch block length
;
	CALL	BYTE		;fetch checksum byte
	LD	(CODE),A	;save code
	LD	IX,0		;init sector checksum
;
LOADIT	CALL	BYTE		;fetch a byte
	XOR	'$'		;de-code it
CODE	EQU	$-1
	LD	E,A		;pass for checksum
	LD	(HL),A		;to buffer
	CP	(HL)		;still there?
	JP	NZ,MERROR	;nope, memory error
	INC	HL		;bump buffer
	LD	D,0		;DE = checksum
	ADD	IX,DE		;add to sector checksum
	ADD	IY,DE		;add to program checksum
	DEC	BC		;less byte count
	LD	A,B		;any more?
	OR	C		;any bits on?
	JR	NZ,LOADIT	;go if more to do
;
;	check block checksum
;
	CALL	BYTEBC		;fetch a byte
	PUSH	IX		;pass checksum to HL
	POP	HL		;HL = computed checksum
	OR	A		;clear carry
	SBC	HL,BC		;compare
	JP	NZ,LERROR	;checksum error!
	JR	LOAD		;else go next block
;
BYTEBC	CALL	BYTE		;fetch byte
	LD	B,A		;pass MSB
	CALL	BYTE		;fetch another
	LD	C,A		;pass LSB
	RET			;done
;
;	fetch byte from disk
;
BYTE	EXX			;swap back
	LD	A,H		;check for read
	OR	L		;anything?
	JR	NZ,BYTEIN	;yes, in memory
;
;	read in all 6 sectors
;
	LD	E,40H		;init start sector
	LD	HL,BUFFER	;start of buffer
RDLP	CALL	SREAD		;read it
	INC	H		;bump buffer
	LD	A,E		;get sector
	ADD	A,8		;offset to next
	LD	E,A		;put it back
	CP	70H		;40H - 68H?
	JR	C,RDLP		;go till done!
	CALL	STEPIN		;step in a track
	CALL	ADJUST		;adjust buffer order
	LD	HL,BUFFER	;reset buffer
;
BYTEIN	LD	B,(HL)		;get the byte
	INC	HL		;bump buffer
	LD	A,H		;get msb
	CP	50H		;end of buffer?
	JR	C,BYTEOK	;nope, continue
	LD	HL,0		;force read next time
;
BYTEOK	LD	A,B		;get byte
	EXX			;swap back
	RET			;A = byte
;
;	select disk drive
;
SELECT	LD	A,DRIVE		;select drive
DRIV	EQU	$-1
	OUT	(SELFDC),A	;select drive
	RET			;else done!
;
;	move head in one track
;
STEPIN	PUSH	BC		;save
	LD	BC,(4300H)	;C = step count
;
STEPER	CALL	STEPIT		;step a track
	DEC	C		;less count
	JR	NZ,STEPER	;go for count
	POP	BC		;restore
	RET			;done
;
STEPIT	CALL	SELECT		;select drive
	LD	A,5BH		;step in command
	CALL	SLOW		;issue and wait
;
STEPWT	IN	A,(FDC)		;read status
	RRCA			;command pending?
	JR	C,STEPWT	;wait for it
	RET			;else done!
;
;	read sector on current track
;
SREAD	LD	A,080H		;FDC read command
	JR	SARD		;go common
;
AREAD	LD	A,0C0H		;FDC read id command
;
SARD	LD	(RDTYPE),A	;save type of read
;
	LD	A,10		;10 I/O tries
;
READ	EX	AF,AF'		;save # retries
	PUSH	HL		;save buffer
	CALL	READ1		;read the sector
	POP	HL		;restore buffer
	RET	Z		;return if no error
;
	EX	AF,AF'		;get error counter
	DEC	A		;less this pass
	JR	NZ,READ		;go if more
	JP	DERROR		;go disk error
;
READ1	CALL	SELECT		;select drive
	LD	A,E		;get track/sector
	OUT	(TRACK),A	;to FDC track reg
	OUT	(SECTOR),A	;to FDC sector reg
;
	CALL	SETNMI		;setup for NMI
	LD	A,'$'		;fetch read command
RDTYPE	EQU	$-1
	CALL	SLOW		;issue and wait
;
READ2	IN	A,(FDC)		;read status
	AND	2		;byte ready
	JR	Z,READ2		;wait for it
	INI			;read the byte
READ3	LD	A,D		;get 'wait' command
	OUT	(SELFDC),A	;issue command
	INI			;read a byte
	JR	READ3		;wait for interrupt
;
RETNMI	XOR	A		;load zero
	OUT	(NMI),A		;disable immediately
	LD	BC,NMIRET	;non-disk NMI's
	LD	(404AH),BC	;disable NMI
	POP	AF		;remove NMI address
	IN	A,(FDC)		;read status
	OR	A		;any errors?
	PUSH	AF		;save result
	LD	A,CLEAR		;reset FDC
	OUT	(FDC),A		;reset it
	POP	AF		;restore status
	RET			;return to caller
;
NMIRET	RETN			;non-disk NMI
;
SETNMI	LD	BC,RETNMI	;disk NMI vector
	LD	(404AH),BC	;setup vector
	LD	A,(DRIV)	;get binary drive
	OR	40H		;set wait bit
	LD	D,A		;pass here
	LD	BC,00<8+XFER	;point to xfer port
	IN	A,(FDC)		;clear FDC latch
	LD	A,0C0H		;NMI command
	OUT	(NMI),A		;enable NMI
	RET			;done!
;
;	issue disk command and wait
;
SLOW	OUT	(FDC),A		;issue disk command
	LD	A,13		;delay count
SLOW1	DEC	A		;less count
	JR	NZ,SLOW1	;finish
	RET			;done
;
;	read ID marks from disk
;
IDMARKS	LD	HL,BUFFER	;init address
	CALL	AREAD		;read ID marks
;
	LD	A,(HL)		;get track #
	INC	HL		;bump pointer
	OR	(HL)		;get head #
	INC	HL		;bump buffer
	OR	(HL)		;get sector #
	RET			;return with it
;
;	check protection on diskette
;
PROTECT	LD	HL,BUFFER	;reset buffer
	LD	A,80H		;set read command
	LD	(RDTYPE),A	;save it
	LD	E,44H		;sector #
	CALL	READ1		;read it
	CP	18H		;must be NF/CRC error
	JR	NZ,IERROR	;ident error!
;
	LD	E,33H		;sector #
	PUSH	HL		;save buffer
	CALL	READ1		;read it
	POP	HL		;restore buffer
	CP	08H		;must be CRC error
	JR	NZ,IERROR	;go id error
	LD	DE,NAME
	LD	B,NAMEL		;name length
CHECK	LD	A,(DE)		;get a byte
	CP	(HL)		;match?
	JR	NZ,IERROR	;go if not
	INC	HL		;bump pointer
	INC	DE		;bump test string
	DJNZ	CHECK		;check 'em all
;
;	load serial # and checksum
;
	LD	B,16		;length
	LD	DE,0F000H-16	;place it here
CHECKS	LD	A,(HL)		;get serial # byte
	XOR	'$'		;correct it
	LD	(DE),A		;to buffer
	INC	DE		;bump pointer
	INC	HL		;bump passer
	DJNZ	CHECKS		;go for length
	CALL	GETCOR		;get checksum correction
	LD	C,A		;save it
	CALL	GETCOR		;get second half
	RLCA			;align to high bits
	RLCA
	RLCA
	RLCA
	AND	0F0H		;keep 4 bits only
	OR	C		;A = checksum
	CP	40H		;<40h?
	JR	NC,$+4		;go if not
	ADD	A,40H		;adjust it
	LD	I,A		;pass checksum
	RET			;return if OK
;
GETCOR	LD	A,(HL)		;get buffer byte
	INC	HL		;bump pointer
	XOR	'#'		;correct it
	RET			;done!
;
;	adjust load buffer to correct format
;
ADJUST	LD	HL,BUFFER	;start of buffer
	LD	C,6		;6 pages long
;
ADJLP	PUSH	HL		;save buffer
	CALL	ADJIT		;adjust this page
	POP	HL		;restore buffer
	INC	H		;bump page
	DEC	C		;less this page
	JR	NZ,ADJLP	;go for # pages
	RET			;done!
;
ADJIT	LD	D,H		;pass to DE
	LD	E,L		;DE => start
	DEC	E		;DE => end
	LD	B,80H		;1/2 length
;
SWAP	LD	A,(HL)		;get a byte
	EX	AF,AF'		;save it
	LD	A,(DE)		;get second byte
	LD	(HL),A		;swap with first
	EX	AF,AF'		;get first back
	LD	(DE),A		;swap with second
	DEC	DE		;end -1
	INC	HL		;start +1
	DJNZ	SWAP		;go till end
	RET			;done
;
;	error vectors
;
IERROR	CALL	SELECT		;select drive
	LD	A,0BH		;restore drive
	CALL	SLOW		;issue command
IERR	IN	A,(FDC)		;read port
	RRCA			;done?
	JR	C,IERR		;wait for restore
	RST	0		;re-boot
;
LERROR	LD	DE,LMSG		;load file format!
	JR	ERROR		;go dummy
;
DERROR	LD	DE,DMSG		;disk error
	JR	ERROR		;go common
;
MERROR	LD	DE,MMSG		;memory error
;
ERROR	LD	HL,3C00H	;start of video
	CALL	PRINT		;display it
	LD	DE,MSG		;error
	CALL	PRINT		;display it
;
HOLD	LD	A,(3840H)	;read keyboard
	RRCA			;enter pressed?
	JR	NC,HOLD		;wait till yes
	RST	0		;re-boot III
;
PRINT	LD	A,(DE)		;get string byte
	OR	A		;end of message
	RET	Z		;yes, done!
	INC	DE		;bump message
	LD	(HL),A		;to video
	INC	HL		;bump video
	JR	PRINT		;go next char
;
;	clear video
;
CLS	LD	HL,3C00H	;start video
	LD	DE,3C01H	;start +1
	LD	BC,3FFH		;length -1
	LD	(HL),' '	;load space
	LDIR			;fill spaces
	RET			;done
;
;	test memory for 48K
;
MEMTEST	LD	HL,BUFFER	;start free memory
MEMLP	LD	A,-1		;set all bits
	LD	(HL),A		;to memory
	CP	(HL)		;still there?
	JR	NZ,MERROR	;go mem error if not
	INC	A		;clear all bits
	LD	(HL),A		;to memory
	CP	(HL)		;still there?
	JR	NZ,MERROR	;go mem error if not
	INC	HL		;bump pointer
	OR	H		;at 0000H?
	OR	L
	JR	NZ,MEMLP	;go if more to do
	RET			;else memory OK!
;
DMSG	DEFM	'Disk',ETX
MMSG	DEFM	'Memory',ETX
LMSG	DEFM	'Data',ETX
MSG	DEFM	' Error ',5FH,ETX
;
;	special string to override SU+ special backup
;
NAME	DEFM	'P'.XOR.'*'
	DEFM	'o'.XOR.'*'
	DEFM	'w'.XOR.'*'
	DEFM	'e'.XOR.'*'
	DEFM	'r'.XOR.'*'
	DEFM	'T'.XOR.'*'
	DEFM	'O'.XOR.'*'
	DEFM	'O'.XOR.'*'
	DEFM	'L'.XOR.'*'
NAMEL	EQU	$-NAME
;
ZZZZZ	EQU	$
	END	ENTRY
