; ptinit/asm - kjw/bqsd - 10/82 - version 1.00 - 04/83
;
; revised 04/21/83 - kjw/bqsd
;
	PAGE
;
ENTRY	DI			;disable interrupts
	IM	1		;interrupt mode 1
	LD	SP,STACK	;reset stack to top
;
	LD	HL,BUFFPRT	;get printer buffer
	LD	(PRBUFF),HL	;pass to data area
	LD	HL,MIDPNT	;get midpoint buffer
	LD	L,0		;set even page
	LD	(MIDMEM),HL	;save it
;
	CALL	INTFDC		;interrupt & clear FDC
;
;	clear cassette latch, reset drive 1
;
;i*
	IF	MODI
	XOR	A
	LD	(CASSEL),A	;set cassette #1
	ENDIF
;i*
;iii*
	IF	MODIII
	XOR	A		;load zero
	OUT	(0E4H),A	;disable NMI's
	LD	A,4		;enable RTC
	OUT	(0E0H),A	;enabled
	LD	A,28H		;video flags
	OUT	(0ECH),A	;enabled
	ENDIF
;iii*
;
;	automatic doubler recognition for Mod I only
;
;i*
	IF	MODI
;
	LD	HL,FDCTRK	;FDC track register
	LD	DE,FDCCMD	;FDC command register
	LD	A,-1		;turn on double density
	LD	(DE),A		;select doubler
	LD	(HL),A		;give to track register
	LD	A,-2		;turn on single density
	LD	(DE),A		;select doubler
	XOR	A		;load zero
	LD	(HL),A		;into track register
;
	LD	A,-1		;back to double density
	LD	(DE),A		;to FDC
	LD	A,(HL)		;is it -1?
	INC	A		;FF?
	LD	B,00000100B	;percom doubler
	JR	Z,HAVDBLR	;have it, go!
;
;	check for radio shack doubler
;
	LD	DE,FDCSEC	;FDC sector register
	LD	A,80H		;select double density
	LD	(DE),A		;select doubler
	LD	A,-1		;load track register
	LD	(HL),A		;to track reg
	LD	A,0A0H		;select single density
	LD	(DE),A		;single on
	XOR	A		;load zero
	LD	(HL),A		;set track register
	LD	A,80H		;back to double den
	LD	(DE),A		;select it
	LD	A,(HL)		;get track register
	INC	A		;is it -1?
	LD	B,00000000B	;radio shack doubler
	JR	Z,HAVDBLR	;go if found
	LD	B,00010000B	;no doubler
;
HAVDBLR	LD	A,(FLAGB)	;get system flag
	AND	11101011B	;remove pertaining bits
	OR	B		;merge with new
	LD	(FLAGB),A	;update doubler flags
	CALL	RESFDC		;reset FDC
;
	ENDIF
;i*
;
;	fetch program serial # and load into storage
;
CLEARX	LD	HL,0F000H-16	;start of serial #
	LD	DE,SERIAL1	;it goes here
	LD	BC,16		;length
	PUSH	HL		;save
	LDIR			;move it in
	POP	HL		;restore
	LD	B,16		;length
	XOR	A		;load zero
	CALL	FILL		;delete code
	LD	HL,CLEARX	;start this code
	LD	B,CLEARY	;length
	CALL	FILL		;remove
CLEARY	EQU	$-CLEARX	;length of code
;
;	setup jumps in page 0 memory in case program
;	is running in pure RAM machine
;	if ROM is there, then no effect
;	else RST vectors will be established
;
	LD	HL,0008H	;first restart
	LD	DE,BASE+1000H	;start RAM
	LD	B,7		;7 to do
;
RSTLP	LD	(HL),0C3H	;JP opcode
	INC	L		;bump table
;
	LD	(HL),E		;lsb address
	INC	L		;bump ram
	LD	(HL),D		;msb address
	INC	E		;bump by 3
	INC	E
	INC	E
;
	LD	A,L		;get LSB ram
	ADD	A,6		;remainder offset to next
	LD	L,A		;HL => next restart
	DJNZ	RSTLP		;go till done
	CALL	SERIALS		;setup serial #'s
;
	LD	HL,MASTER	;program entry
	LD	(TEMP2),HL	;save it for vector
;
	XOR	A		;load zero
	CALL	SETDRV		;setup for I/O
	LD	A,(IY+5)	;get flags
	LD	(TEMP0),A	;save
	LD	A,(IY+6)	;get type
	LD	(TEMP0+1),A	;save it
	LD	(IY+5),0	;set side 0
	LD	(IY+6),0	;set single density
	LD	A,(FLAGA)	;get sys flag
	LD	(TEMP1),A	;save
	SET	1,A		;turn off alive
	LD	(FLAGA),A	;update
	XOR	A		;load zero
	LD	D,A		;pass track
	CALL	SETDRV		;setup again
	LD	A,(KBDR7)	;read keyboard
	AND	2		;bit 1 right shift?
	CALL	Z,LOADCON	;load configuration
	LD	A,(KBDR7)	;read again
	AND	1		;bit 0 left shift?
	CALL	Z,LOADPAT	;load patch data
;
	LD	A,(TEMP0)	;get flags
	LD	(IY+5),A	;update
	LD	A,(TEMP0+1)	;fetch dos type
	LD	(IY+6),A	;reset it
;
	CALL	TURNSPD		;set hispeed clock
	CALL	LOGO		;display logo
	LD	A,(TEMP1)	;get saved flags
	LD	(FLAGA),A	;update
	LD	HL,(TEMP2)	;get program vector
	JP	(HL)		;go entry!
;
LOADCON	CALL	STAT		;disk ready?
	RET	NZ		;nope, go!
	LD	BC,BUFFER	;I/O buffer to use
	PUSH	BC		;save it
;i/m*
	IF	MODI.OR.MAX80
	LD	DE,0002H	;config I
	ENDIF
;i/m*
;iii*
	IF	MODIII
	LD	DE,0003H	;config III
	ENDIF
;iii*
	CALL	READ		;read it
	POP	HL		;HL => data
	RET	NZ		;error, skip it
;
;	check for header in sector
;
	LD	DE,HEADCON	;header for config
	LD	B,HEADCOL	;length of header
	CALL	COMPARE		;match?
	RET	NZ		;nope, not valid sector
;
;	load data
;
	LD	A,(HL)		;get data
	INC	HL		;bump pointer
	LD	(ALVFLAG),A	;save alive flag
	LD	A,(HL)		;get data
	INC	HL		;bump pointer
	LD	(MODE),A	;modify mode
	LD	A,(HL)		;get data
	INC	HL		;bump pointer
	LD	(DRIVES),A	;# drives
	LD	A,(HL)		;get allflag
	LD	(ALLFLAG),A	;save it
	INC	HL		;bump pointer
	LD	A,(HL)		;get flag A
	INC	HL		;bump pointer
	LD	(TEMP1),A	;save flag A
	LD	A,(HL)		;get flag B
	INC	HL		;bump pointer
	LD	(FLAGB),A	;save flag B
	LD	DE,DISP1	;decrypt settings
	LD	BC,4		;length
	LDIR			;move it in
	LD	DE,DCT0		;DCT table
	LD	BC,8*13		;length
	LDIR			;move it in
	LD	DE,$U		;user defined DCT
	LD	BC,7		;length
	LDIR			;move in
	LD	DE,$X		;extra DCT's
	LD	BC,7*4		;length
	LDIR			;move in
	LD	DE,SPDOFF	;speed off table
	LD	BC,9*2		;length
	LDIR			;pass it
	LD	DE,FMTNAME	;default format name
	LD	BC,8*2		;length
	LDIR			;move in
	LD	DE,SPATTRN	;format patterns
	LD	BC,16*2		;length
	LDIR			;move in
	LD	A,(IY+5)	;get config
	LD	(TEMP0),A	;save it
	LD	A,(IY+6)	;get new configuration
	LD	(TEMP0+1),A	;pass for reset
	XOR	A		;set Z flag
	LD	(IY+5),A	;set single side
	LD	(IY+6),A	;set single den
	RET			;done!
;
;	read patch information from disk
;
LOADPAT	CALL	STAT		;drive ready?
	RET	NZ		;go if not!
;i/m*
	IF	MODI.OR.MAX80
	LD	DE,0004H	;patch I
	ENDIF
;i/m*
;iii*
	IF	MODIII
	LD	DE,0007H	;patch III
	ENDIF
;iii*
	LD	L,-1		;pointer to data
	LD	B,4		;max patch sectors+1
	EXX			;save here
;
PATLP	CALL	PAT1B		;get a byte
	OR	A		;terminator?
	RET	Z		;yes, done!
	DEC	A		;1 loader?
	JR	Z,PAT1		;yes, go!
	DEC	A		;2 entry?
	JR	Z,PAT2		;yes, go!
	CP	1EH		;1-1FH?
	RET	NC		;nope, error, return!
;
;	remove remark block
;
	CALL	PAT1B		;get a byte
	LD	B,A		;pass length
PATREM	CALL	PAT1B		;get a byte
	DJNZ	PATREM		;finish remark
	JR	PATLP		;go next block
;
;	load block
;
PAT1	CALL	PATLD		;get load address
;
PAT1L	CALL	PAT1B		;get a byte
	LD	(HL),A		;to buffer
	INC	HL		;bump buffer
	DJNZ	PAT1L		;go for block length
	JR	PATLP		;go next block
;
;	entry block
;
PAT2	CALL	PATLD		;get load address
	LD	(TEMP2),HL	;save vector
	RET			;done!
;
;	fetch load address
;
PATLD	CALL	PAT1B		;get a byte
	SUB	2		;less 2
	LD	B,A		;pass length
	CALL	PAT1B		;get LSB address
	LD	L,A		;pass it
	CALL	PAT1B		;get MSB address
	LD	H,A		;HL = address
	RET			;done!
;
;	fetch 1 byte from patch file
;
PAT1B	EXX			;swap registers
	INC	L		;bump buffer
	JR	NZ,PAT1H	;have it, go!
;
	PUSH	BC		;save count
	LD	BC,BUFFER	;I/O buffer
	PUSH	BC		;save on stack
	CALL	READ		;read the sector
	POP	HL		;restore buffer
	POP	BC		;restore BC
	JR	NZ,PATCAN	;abort if error!
	DEC	B		;less this sector
	JR	Z,PATCAN	;too many!
	INC	E		;bump sector
;
PAT1H	LD	A,(HL)		;get buffer byte
	EXX			;swap back
	RET			;done, A = byte
;
PATCAN	POP	HL		;unstack caller address
	RET			;done!
;
