; ptcopy0/asm - kjw/bqsd - 04/83
;
; revised 04/21/83 - kjw/bqsd
;
ENTRY	DI			;disable for setup
	LD	SP,STACK	;reset stack
	LD	A,(3880H)	;read keyboard
	AND	3		;low 2 bits only
	RRA			;align bits
	ADC	A,0		;catch both bits
	XOR	1		;opposite bits
	LD	(VERFLAG),A	;save as verify flag
	LD	A,0C3H		;JP opcode
	LD	(4012H),A	;for RST 38H
	LD	HL,TASK		;interrupt task
	LD	(4013H),HL	;save it
	XOR	A		;load zero
	OUT	(0E4H),A	;disable NMI's
	LD	A,28H		;setup video
	OUT	(0ECH),A	;setup registers
	LD	A,4		;enable RTC
	OUT	(0E0H),A	;enable it
	IM	1		;interrupt mode 1
	EI			;enable interrupts
	LD	HL,HELLO	;sign on message
	CALL	DISPLAY		;display it
	CALL	TESTMEM		;test memory
;
BEGIN	LD	SP,STACK	;reset stack
	LD	IY,SYSTEM	;setup data table
	LD	HL,HELLO	;sign on message
	CALL	DISPLAY		;re-display it
	JP	PARAMS		;get user params
;
;	test memory before using it
;
TESTMEM	LD	HL,TESTMSG	;testing...
	CALL	DISPLAY
	XOR	A		;load all bits off
	CALL	TESTSET		;settling test
	LD	A,-1		;load all bits on
	CALL	TESTSET		;settling test
	LD	HL,PGMEND	;end of program
;
TESTLP1	LD	DE,TESTBL	;test table
TESTLP2	LD	A,(DE)		;get table byte
	CP	80H		;terminator?
	JR	Z,TESTLP3	;go if done with byte
	LD	(HL),A		;to buffer
	CP	(HL)		;still there?
	JR	NZ,BADMEM	;go if bad
	INC	DE		;bump test table
	JR	TESTLP2		;go outer loop
;
TESTLP3	INC	HL		;bump memory
	LD	A,H		;any more?
	OR	L		;any bits set?
	JR	NZ,TESTLP1	;go if not 0000H
	RET			;else done with test!
;
;	test memory with settling time
;
TESTSET	LD	HL,PGMEND	;end of program
	LD	DE,PGMEND+1	;end +1
	LD	BC,-1-PGMEND	;length -1
	LD	(HL),A		;test byte to buffer
	PUSH	HL		;save buffer start
	LDIR			;fill memory
	POP	HL		;restore buffer
;
TESTSL	CP	(HL)		;still there?
	JR	NZ,BADMEM	;go bad if not!
	INC	L		;go till 0000H
	JR	NZ,TESTSL
	INC	H
	JR	NZ,TESTSL
	RET			;done!
;
;	bad memory!
;
BADMEM	LD	HL,BADMSG	;bad memory
	CALL	DISPLAY		;display it
	LD	B,1		;one key input
	CALL	GETSTR		;from keyboard
	JP	ENTRY		;restart program
;
TESTBL	DEFB	11001100B	;pairs
	DEFB	00110011B	;opposite
	DEFB	11110000B	;nybbles
	DEFB	00001111B	;opposite
	DEFB	11111111B	;all bits on
	DEFB	00000000B	;all bits off
	DEFB	80H		;terminator
;
;
;	execute copy here
;
LOOPER	LD	SP,STACK	;reset stack
	LD	A,'D'		;duplicating
	LD	(OPERATE),A	;save operation
	LD	HL,LOOPER	;abort vector
	LD	(VECTOR),HL	;save it
	CALL	RESET		;reset for loop
	LD	HL,MNTMSGA	;mount message A
	CALL	MOUNT		;mount diskettes
	CALL	CHECKEM		;find mounted drives
	CALL	SERIAL		;get serial #'s
	CALL	FORMAT		;format diskettes
	CALL	COPY		;copy data
	CALL	RESULT		;display result
	JR	LOOPER		;go again
;
;	prompt user to mount disks or press BREAK
;
MOUNT	CALL	DISPLAY		;display it
	LD	B,1		;one key input
	CALL	GETSTR		;wait for keys
	PUSH	AF		;save key/flags
	LD	A,LF		;send linefeed
	CALL	VOUT		;to video
	POP	AF		;restore input
	JP	C,UPDATE	;update serial <BREAK>
	RET			;return if <ENTER>
;
FORMAT	LD	HL,FORMIT	;subroutine
	JP	COMMON		;go common
;
;	check for mounted diskettes
;
CHECKEM	LD	HL,CHECKER	;subroutine
	JP	COMMON		;do all drives
;
CHECKER	CALL	STAT		;check if drive ready
	LD	A,80H		;lockout byte
	JP	NZ,LOCKIT	;remove from table
	CALL	RESTORE		;move head to track 0
	LD	A,80H		;lockout byte
	JP	NZ,LOCKIT	;remove from table if bad
	RET			;else return ready
;
;	transfer data!
;
COPY	LD	A,LF		;send linefeed to display
	CALL	VOUT		;fresh line
	CALL	READ0		;read track 0
	LD	A,(TSTFLAG)	;get source verify
	RRCA			;on?
	CALL	C,READ0V	;verify source
	LD	HL,WRITE0	;write track 0
	CALL	COMMON		;do all drives
	LD	HL,VERIFY0	;verify track 0
	LD	A,(VERFLAG)	;get verify flag
	RRCA			;on?
	CALL	C,COMMON	;do if yes
;
	CALL	READ1		;read track 1
	LD	A,(TSTFLAG)	;verify source?
	RRCA			;on?
	CALL	C,READ1V	;verify if yes
	LD	HL,WRITE1	;write track 1
	CALL	COMMON		;do all drives
	LD	HL,VERIFY1	;verify track 1
	LD	A,(VERFLAG)	;get verify flag
	RRCA			;on?
	CALL	C,COMMON	;do if yes
;
	CALL	READ2		;read I program
	LD	A,(TSTFLAG)	;source verify flag
	RRCA			;on?
	CALL	C,READ2V	;verify if yes
	LD	HL,WRITE2	;write I program
	CALL	COMMON		;do all drives
	LD	HL,VERIFY2	;verify I program
	LD	A,(VERFLAG)	;get verify flag
	RRCA			;on?
	CALL	C,COMMON	;go if yes
;
	CALL	READ3		;read III program
	LD	A,(TSTFLAG)	;get flag
	RRCA			;verify on?
	CALL	C,READ3V	;verify if yes
	LD	HL,WRITE3	;write III program
	CALL	COMMON		;do all drives
	LD	HL,VERIFY3	;verify III program
	LD	A,(VERFLAG)	;get verify flag
	RRCA			;on?
	CALL	C,COMMON	;go if yes
;
	RET			;done
;
SERIAL	LD	HL,SERIT	;subroutine
	JP	COMMON		;do all drives
;
SERIT	LD	B,_SERLEN	;serial # length
	LD	HL,_SERIAL	;default serial #
	PUSH	BC		;save length
	CALL	TOSERL		;point to serial #
	PUSH	DE		;save start
	LD	B,16		;length
	LD	A,' '		;space
	CALL	FILL		;fill it
	POP	DE		;get buff start
	POP	BC		;get length
	LD	C,B		;C = length
	LD	B,0		;BC = length
	LDIR			;move it in
	RET			;to next drive
;
;	common vector for active drives
;
COMMON	LD	(CVECT),HL	;save vector
	XOR	A		;load current drive
;
COMMLP	CALL	SETDRV		;setup for I/O
;
	CALL	ANYDEST		;any dest drives left?
	LD	HL,LTABLE	;lockout table
	CALL	POINT		;point to byte
	LD	A,(HL)		;get flag
	INC	A		;true (FF)?
	CALL	Z,$		;call vector if active
CVECT	EQU	$-2
	LD	A,(IY+6)	;get current drive
	INC	A		;bump it
	CP	4		;0-3?
	JR	C,COMMLP	;go if more
	RET			;else done!
;
;	reset tables for next loop
;
RESET	LD	HL,ATABLE	;active drive table
	LD	DE,LTABLE	;lockout table
	LD	BC,4		;4 bytes long
	LDIR			;reset for next pass
	RET			;return
;
;	display results of current copy
;
RESULT	LD	A,LF		;send extra linefeed
	CALL	VOUT		;to display
;
	LD	BC,0400H	;B=counter, C=drive
;
RESULT1	LD	(IY+6),C	;setup drive
	LD	HL,ATABLE	;active drive table
	CALL	POINT		;point to drive
	LD	A,(HL)		;get the byte
	INC	A		;active this loop?
	JR	NZ,RESULT5	;go if not
	LD	HL,LTABLE	;lockout table
	CALL	POINT		;point to drive
	LD	A,(HL)		;get the byte
	CP	80H		;nilled?
	JR	Z,RESULT5	;skip if yes
	INC	A		;still active (FF)?
	LD	A,C		;get drive #
	PUSH	BC		;save on stack
	JR	NZ,RESULT3	;go if bad
;
	ADD	A,'0'		;add ascii to drive #
	LD	(OKMSGD),A	;to string
	LD	(OKMSGE),A	;to alt string
	LD	A,'$'		;get operation
OPERATE	EQU	$-1
	CP	'A'		;applying loaders?
	LD	HL,OKMSG2	;alternate message
	JR	RESULT4		;continue
	LD	HL,OKMSG	;text
	CALL	DISPLAY		;display message
	CALL	TOSERL		;fetch serial # address
	EX	DE,HL		;HL => serial #
	JR	RESULT4		;display it
;
RESULT3	ADD	A,'0'		;add ascii to drive
	LD	(NOKMSGD),A	;to the string
	LD	HL,NOKMSG	;not ok message
;
RESULT4	CALL	DISPLAY		;display string
	POP	BC		;restore counter
;
RESULT5	INC	C		;bump drive #
	DJNZ	RESULT1		;go till done
	RET			;all drives posted
;
;	read boot / config / patch data from source
;
READ0V	LD	HL,VERIFY	;subroutine
	JR	READ0+3		;go common
;
READ0	LD	HL,READ		;subroutine
	LD	(READ0X),HL	;pass call
	LD	DE,0200H	;track/sector
	LD	HL,BUFFER	;start of buffer
	LD	A,(IY+4)	;get source drive
	LD	(IY+8),80H	;set double density
	CALL	SETDRV		;setup for I/O
;
READ0L	LD	C,1		;256 bytes
	CALL	$		;read/verify
READ0X	EQU	$-2
	JP	NZ,SRCERR	;source error!
	INC	H		;bump buffer
	INC	E		;bump sector
	LD	A,E		;get sector
	CP	10		;0-9?
	JR	C,READ0L	;finish it off
	RET			;else done!
;
;	write boot / config / patch data to disk
;
WRITE0	LD	HL,WRITE	;subroutine
	JR	WRITE0C		;go common
;
VERIFY0	LD	HL,VERIFY	;subroutine
;
WRITE0C	LD	DE,0000H	;track/sector
	LD	(WRITE0V),HL	;save vector
	LD	HL,BUFFER	;init buffer
	LD	(IY+8),E	;set single density
;
WRITE0L	LD	A,(IY+6)	;current drive
	CALL	SETDRV		;setup for I/O
	LD	C,1		;set sector length
	CALL	$		;write/verify sector
WRITE0V	EQU	$-2
	JP	NZ,REMDRIV	;remove drive
	INC	H		;bump buffer
	INC	E		;bump sector
	LD	(IY+8),0	;set single density
	LD	A,E		;fetch it
	CP	1		;sector 1?
	JR	NZ,WRITE01	;go if not
	SET	7,(IY+8)	;set double density
WRITE01	CP	10		;0-9?
	JR	C,WRITE0L	;go if more to do
	RET			;else done!
;
;	read loaders from source
;
READ1V	LD	HL,VERIFY	;subroutine
	JR	READ1+3		;go common
;
READ1	LD	HL,READ		;subroutine
	LD	(READ1X),HL	;pass vector
	LD	DE,0300H	;track 3/ sector 0
	JR	READ12		;go common
;
VERIFY8	LD	HL,VERIFY	;subroutine
	JR	READ80+3	;go common
READ80	LD	HL,READ		;subroutine
	LD	(READ1X),HL	;pass it
	LD	DE,0400H	;track 4/ sector 0
;
READ12	LD	HL,BUFFER	;I/O buffer
	LD	(IY+8),80H	;set double density
	LD	A,(IY+4)	;get source drive
	CALL	SETDRV		;setup for I/O
	LD	BC,0C01H	;B=count, C=sec length
;
READ1L	PUSH	BC		;save
	CALL	$		;read verify
READ1X	EQU	$-2
	POP	BC		;restore
	JP	NZ,SRCERR	;go source error
	INC	H		;bump buffer
	INC	E		;bump sector
	DJNZ	READ1L		;go for 6 sectors
	RET			;else done!
;
;	write loaders to target disk
;
WRITE1	LD	HL,WRITENS	;subroutine
	JR	WRITE1C		;go common
;
VERIFY1	LD	HL,VERIFYN	;subroutine
;
WRITE1C	LD	(WRITE1V),HL	;save sub vector
	LD	(WRITE1W),HL	;4 places
	LD	(WRITE1X),HL
	LD	(WRITE1Y),HL
	LD	(WRITE1U),HL
	LD	(WRITE1Z),HL
	LD	HL,REMDRIV	;leave error vector
	PUSH	HL		;on stack for easy exit
;
	LD	A,(IY+6)	;get current drive
	LD	(IY+8),0	;set single density
	CALL	SETDRV		;setup for I/O
	LD	HL,BUFFER	;start of buffer
	LD	DE,0120H	;track 1/sector 20h
	LD	C,2		;length = 512
	CALL	$
WRITE1V	EQU	$-2
	RET	NZ		;error!
	LD	E,25H		;sector 25H
	INC	H		;512 byte sectors
	INC	H
	LD	C,2		;512 bytes
	CALL	$
WRITE1W	EQU	$-2
	RET	NZ		;go if any error!
	LD	E,30H		;sector 30H
	INC	H		;bump buffer
	INC	H
	LD	C,2		;512 byte sector
	CALL	$		;write it
WRITE1U	EQU	$-2
	RET	NZ		;go on error
;
	LD	A,(IY+6)	;get drive #
	LD	(IY+8),80H	;set double den
	CALL	SETDRV		;set it up
	LD	E,40H		;sector 40H
	LD	HL,BUFFER+600H	;start of buffer
	LD	C,2		;512 bytes
	CALL	$
WRITE1X	EQU	$-2
	RET	NZ		;return if error
;
	LD	E,45H		;sector 45H
	INC	H		;512 byte sectors
	INC	H
	LD	C,2		;512 bytes
	CALL	$
WRITE1Y	EQU	$-2
	RET	NZ		;return if error
;
	LD	E,50H		;sector 50H
	INC	H		;bump buffer
	INC	H
	LD	C,2		;512 bytes
	CALL	$		;write it out!
WRITE1Z	EQU	$-2
	RET	NZ		;go on error
;
	POP	AF		;remove error vector
	XOR	A		;return zero
	RET			;done
;
;	read program from disk
;
READ2V	LD	HL,VERIFY	;subroutine
	JR	READ2+3		;continue
;
READ2	LD	HL,READ		;subroutine
	LD	DE,0600H	;high/low sectors
	JR	READ23		;go common
;
READ3V	LD	HL,VERIFY	;sub
	JR	READ3+3		;continue
;
READ3	LD	HL,READ		;sub
	LD	DE,0C06H	;high/low sectors
;
READ23	LD	(READ2X),HL	;pass vector
	CALL	ANYDEST		;any dest drives left?
	LD	(IY+10),E	;load low sector
	LD	(IY+11),D	;load high sector
	LD	(IY+8),80H	;set double density
	LD	HL,BUFFER	;start I/O buffer
	LD	A,(IY+4)	;get source drive
	CALL	SETDRV		;setup for I/O
	LD	D,06		;start on track 6
;
READ2L	LD	C,1		;256 bytes
	CALL	$		;read/verify
READ2X	EQU	$-2
	JP	NZ,SRCERR	;go if source error!
	INC	H		;bump buffer
	INC	E		;bump sector
	LD	A,E		;fetch new sector
	CP	(IY+11)		;test to highest +1
	JR	C,READ2L	;go if not
	LD	E,(IY+10)	;reset to 0
	INC	D		;bump track
	LD	A,D		;fetch result
	CP	(IY+1)		;compare to track count
	JR	C,READ2L	;go if more
	XOR	A		;return zero
	RET			;Mod I loaded
;
;	write program file
;
WRITE2	LD	(IY+8),0	;set single density
	JR	WRITE23		;go common
;
VERIFY2	LD	(IY+8),0	;set single density
	JR	VERIFY4		;go common
;
WRITE3	LD	(IY+8),80H	;set double density
	JR	WRITE23		;go common
;
VERIFY3	LD	(IY+8),80H	;set double
;
VERIFY4	LD	HL,VERIFYN	;verify with no seek
	JR	VERIFY5		;go common
;
WRITE23	LD	HL,WRITENS	;write with no seek
;
VERIFY5	LD	(WRITE2V),HL	;save vector
;
	LD	A,(IY+6)	;get current drive
	CALL	SETDRV		;setup for I/O
	LD	DE,0640H	;start track/sector
	LD	HL,BUFFER	;buffer start
WRIT2LO	LD	IX,WRIT2BL	;lookup table
;
WRIT2LI	LD	E,(IX+0)	;get sector #
	LD	C,(IX+1)	;get buff offset
	LD	B,(IX+2)	;BC = buffer
	PUSH	HL		;save buffer
	ADD	HL,BC		;HL => I/O buffer
	LD	C,1		;sector length 256
	CALL	$
WRITE2V	EQU	$-2
	POP	HL		;restore buffer
	JP	NZ,REMDRIV	;go if error
	LD	BC,3		;offset to next entry
	ADD	IX,BC		;IX => next sector
	LD	A,(IX+0)	;get next entry
	INC	A		;terminator?
	JR	NZ,WRIT2LI	;go inner loop
;
	LD	BC,600H		;offset to next buffer
	ADD	HL,BC		;HL => next block
	INC	D		;bump track
	LD	A,D		;fetch result
	CP	(IY+1)		;still in range?
	JR	C,WRIT2LO	;go if more
	XOR	A		;return zero
	RET			;done!
;
;	update serial #'s to disk
;
UPDATE	JP	PARAMS		;go params
;
;	check if any dest drives left in que
;
ANYDEST	LD	HL,LTABLE	;lockout table
	LD	B,4		;4 entries
;
ANYDESL	LD	A,(HL)		;get a byte
	INC	A		;FF = true?
	RET	Z		;yes, have one!
	INC	HL		;bump table
	DJNZ	ANYDESL		;go if any more
;
;	no dest drives, abort operation!
;
	LD	HL,DESMSG	;text
	CALL	DISPLAY		;display it
	LD	HL,$		;fetch vector
VECTOR	EQU	$-2
	JP	(HL)		;restart current loop
;
;	fetch parameters from users
;
PARAMS	LD	HL,ATABLE	;active drive table
	LD	DE,ATABLE+1	;start +1
	LD	BC,3		;length -1
	LD	(HL),-1		;activate a drive
	LDIR			;activate all drives
;
PARAM1	LD	HL,SDRMSG	;source drive?
	CALL	DISPLAY
	LD	B,1		;one key input
	CALL	GETSTR		;get from keyboard
	LD	A,'0'		;default to zero
	JR	Z,PARAM1A	;go default
	LD	A,(HL)		;fetch input
PARAM1A	SUB	'0'		;remove ascii
	JR	C,PARAM1	;go if invalid
	CP	4		;0-3?
	JR	NC,PARAM1	;go if bad
	LD	(IY+4),A	;save drive
	CALL	SETDRV		;set it up
	LD	HL,ATABLE	;active table
	CALL	POINT		;point to byte
	LD	(HL),0		;de-activate this drive
;
;	fetch step rate from user
;
PARAM2	LD	HL,STPMSG	;step rate
	CALL	DISPLAY		;display prompt
	LD	B,1		;one key input
	CALL	GETSTR		;get input
	JP	C,PARAM1	;go if break
	LD	A,'0'		;default zero
	JR	Z,PARAM2A	;go if nil
	LD	A,(HL)		;get input from user
PARAM2A	SUB	'0'		;remove ascii
	JR	C,PARAM2	;go if invalid
	CP	4		;0-3?
	JR	NC,PARAM2	;go if invalid
	LD	(IY+7),A	;save step rate
;
;	see if <D>uplicate or <A>pply 80 track loaders
;
PARAM3	JP	LOOPER		;duplicate!
;
;	toggle verify mode
;
TOGVER	LD	A,1		;get verify flag
VERFLAG	EQU	$-1
	XOR	1		;reverse bit 0
	LD	(VERFLAG),A	;re-save it
	JR	PARAM4		;display settings
;
TOGSRC	LD	A,0		;get verify flag
TSTFLAG	EQU	$-1
	XOR	1		;reverse bit 0
	LD	(TSTFLAG),A	;update
;
;	display verify settings
;
PARAM4	LD	HL,PMSG2	;param msg 2
	CALL	DISPLAY		;display it
	LD	A,(TSTFLAG)	;get source flag
	CALL	DSPFLAG		;display flag
	LD	HL,PMSG1	;param msg 1
	CALL	DISPLAY		;display
	LD	A,(VERFLAG)	;get dest verify flag
	CALL	DSPFLAG		;display flag
	JP	PARAM3		;continue
;
DSPFLAG	LD	HL,ONMSG	;'ON'
	RRCA			;verify on?
	JR	C,$+5		;go if yes
	LD	HL,OFFMSG	;'OFF'
	JP	DISPLAY		;display & return
;
ONMSG	DEFM	'ON'
	DEFB	LF
	DEFB	ETX
;
OFFMSG	DEFM	'OFF'
	DEFB	LF
	DEFB	ETX
;
PMSG1	DEFM	'Destination Verify: '
	DEFB	ETX
;
PMSG2	DEFB	LF
	DEFM	'Source Verify: '
	DEFB	ETX
;
INSTALL	LD	SP,STACK	;reset stack
	LD	HL,INSTALL	;abort vector
	LD	(VECTOR),HL	;save it
	CALL	RESET		;reset active drives
	LD	HL,MNTMSGI	;mount message
	CALL	MOUNT		;request disk mount
	CALL	CHECKEM		;locate mounted disks
	CALL	SERIAL		;get serial #'s
	LD	HL,INSTAL	;subroutine
	CALL	COMMON		;do all drives
	CALL	READ0		;read track 0
	LD	A,(TSTFLAG)	;get verify flag
	RRCA			;on?
	CALL	C,READ0V	;verify if yes
	LD	HL,WRITE0	;write track 0
	CALL	COMMON		;do all drives
	LD	HL,VERIFY0	;verify track 0
	LD	A,(VERFLAG)	;get verify flag
	RRCA			;on?
	CALL	C,COMMON	;do if yes
;
	CALL	READ1		;read track 1
	LD	A,(TSTFLAG)	;get flag
	RRCA			;verify on?
	CALL	C,READ1V	;verify if yes
	LD	HL,WRITE1	;write track 1
	CALL	COMMON		;do all drives
	LD	HL,VERIFY1	;verify track 1
	LD	A,(VERFLAG)	;get verify flag
	RRCA			;on?
	CALL	C,COMMON	;go if yes
	CALL	RESULT		;display result
	JR	INSTALL		;go next loop
;
;	apply 80 track loaders to diskettes
;
APPLY	LD	SP,STACK	;reset stack
	LD	HL,APPLY	;start of routine
	LD	(VECTOR),HL	;abort vector
	CALL	RESET		;reset active drives
	LD	HL,MNTMSGB	;mount message B
	CALL	MOUNT		;request disk mount
	CALL	CHECKEM		;locate mounted diskettes
	CALL	APPLY80		;apply the loaders
	CALL	RESULT		;display result
	JR	APPLY		;continue
;
APPLY80	LD	HL,FORM80	;format first
	CALL	COMMON		;do all drives
;
	CALL	READ80		;read it
	LD	A,(TSTFLAG)	;get source verify flag
	RRCA			;on?
	CALL	C,VERIFY8	;verify if yes
	LD	HL,WRITE1	;write to 80 tracks
	CALL	COMMON		;do all drives
	LD	HL,VERIFY1	;verify 80 track loader
	LD	A,(VERFLAG)	;get verify flag
	RRCA			;on?
	CALL	C,COMMON	;go if yes
;
	RET
;
WRIT2BL	DEFB	40H
	DEFW	0000
	DEFB	50H
	DEFW	0512
	DEFB	60H
	DEFW	1024
	DEFB	48H
	DEFW	0256
	DEFB	58H
	DEFW	0768
	DEFB	68H
	DEFW	1280
	DEFB	-1
;
