; ptconf/asm - kjw/bqsd - 10/82 - version 1.00 - 04/83
;
; revised 04/25/83 - kjw/bqsd
;
	PAGE
;
;	display system configuration
;
SHOCFG	LD	BC,(FLAGA)	;B = flagb, C = flaga
;
;	display printer/doubler information
;
	BIT	5,C		;dual ON?
	CALL	SETYES		;load Y/N
	LD	(VIDEO+320+7),A	;to the video
;
;	printer graphics
;
	BIT	7,B		;graphics printer?
	CALL	SETYES		;load Y/N
	CP	'Y'		;graphics enabled?
	JR	NZ,CNFCT	;nope, continue
	BIT	5,B		;MX80 graphics?
	JR	Z,CNFCT		;nope, continue
	LD	A,'M'		;MX80
CNFCT	LD	(VIDEO+320+18),A ;to the video
;
;	printer lower case
;
	BIT	6,B		;locase printer?
	CALL	SETYES		;load Y/N
	LD	(VIDEO+320+27),A ;to video
;
;	printer linefeeds
;
	BIT	3,B		;linefeeds?
	CALL	SETYES		;load Y/N
	LD	(VIDEO+320+39),A ;to video
;
;	type of doubler being used
;
	BIT	4,B		;double den available?
	LD	A,'N'		;NO
	JR	NZ,CONCF0	;go if not
	BIT	2,B		;radio shack doubler?
;
;i/iii*
	IF	MODI.OR.MODIII
	LD	A,'R'		;Radio/Shack
	ENDIF
;i/iii*
;m*
	IF	MAX80
	LD	A,'M'		;max double
	ENDIF
;m*
	JR	Z,CONCF0	;go if yes
	LD	A,'X'		;brand X
CONCF0	LD	(VIDEO+320+49),A ;to video
;
;	display disk drive information
;
	XOR	A		;start drive offset
	LD	(TEMP9),A	;save it
	LD	IX,VIDEO+384	;start video drive data
;
SETSD0	LD	BC,(TEMP8)	;C=start drive
	LD	A,(TEMP9)	;get drive offset
	ADD	A,C		;add offset
	CALL	SETDRV		;set up the drive
	LD	(IX+4),A	;enter drive # ascii
;
;	active, inactive, double-step
;
	LD	A,'='		;double step?
	BIT	6,(IY+5)	;yes?
	JR	NZ,CF0		;go if yes
	LD	A,'-'		;not in system?
	BIT	7,(IY+4)	;yes?
	JR	NZ,CF0		;go if not in
	LD	A,'+'		;in system
CF0	LD	(IX+2),A	;to video
;
;	insert dos specifiers
;
	LD	C,(IY+7)	;get dos type
	LD	A,C		;fetch it
	ADD	A,A		;*2
	ADD	A,C		;*3
	LD	C,A		;C = 3 byte offset
	LD	B,0		;BC = table offset
	LD	HL,DNAMES	;dos ascii table
	ADD	HL,BC		;HL => text
	PUSH	IX		;save video
	LD	BC,6		;video offset to display
	ADD	IX,BC		;IX => video
	PUSH	IX		;pass to DE
	POP	DE		;DE => video
	POP	IX		;restore IX
;
	LD	C,3		;3 char names
	LDIR			;move to video
;
;	check for relative addressing
;
	BIT	3,(IY+6)	;relative engaged?
	JR	Z,NOTREG	;nope, continue
	LD	A,'R'		;set relative
	LD	(DE),A		;to video
	INC	DE		;bump video
;
;	display # sides
;
NOTREG	LD	A,27H		;single side
	BIT	0,(IY+5)	;double sided?
	JR	Z,NOTDSD	;nope, continue
	LD	A,'"'		;double side
NOTDSD	LD	(DE),A		;to display
	INC	DE		;bump display
	LD	A,SPACE		;load space
	LD	(DE),A		;adjust display
;
;	track count
;
	LD	A,(IY+1)	;get relative tracks
	RST	@18		;to decimal ascii
	LD	(IX+26),A	;MSB
	LD	(IX+27),C	;NSB
	LD	(IX+28),B	;LSB
;
;	directory track
;
	LD	A,(IY+2)	;directory track
	RST	@18		;to ascii
	LD	(IX+34),A	;MSB
	LD	(IX+35),C	;NSB
	LD	(IX+36),B	;LSB
;
;	step rate
;
	LD	A,(IY+4)	;get step
	AND	3		;low 2 bits only
	ADD	A,'0'		;adjust to ascii
	LD	(IX+42),A	;to video
;
;	motor on delay / read operations
;
	LD	A,(IY+4)	;get read mdelay
	RRCA			;move 2 bits
	RRCA
	CALL	STPRAT		;fetch in ascii 1-4
	LD	(IX+49),A	;to video
;
;	motor on delay / write operations
;
	LD	A,(IY+4)	;get write delay
	CALL	STPRAT		;fetch in ascii
	LD	(IX+56),A	;to video
;
;	software write protect
;
	BIT	6,(IY+4)	;soft write protect?
	CALL	SETYES		;load Y/N
	LD	(IX+61),A	;to video
;
;	density of track 0
;
	LD	A,'S'		;single den?
	BIT	7,(IY+6)	;single?
	JR	Z,$+4		;yes, go!
	LD	A,'D'		;double den
	LD	(IX+64+13),A	;to video
;
;	density disk remainder
;
	LD	A,'S'		;single den disk?
	BIT	6,(IY+6)	;yes?
	JR	Z,$+4		;yes, go!
	LD	A,'D'		;double disk
	LD	(IX+64+18),A	;to video
;
;	starting sector track 0
;
	LD	A,(IY+6)	;get system flag
	RRCA			;align bit 1 => 0
	AND	1		;mask upper 7
	ADD	A,'0'		;add ascii
	LD	(IX+64+24),A	;to video
;
;	starting sector disk remainder
;
	LD	A,(IY+6)	;get flag
	AND	1		;mask high bits
	ADD	A,'0'		;add ascii
	LD	(IX+64+37),A	;low sector disk to video
;
;	highest sector on track 0
;
	LD	A,(IY+8)	;high sector track 0
	RST	@18		;to ascii
	LD	(IX+64+30),C	;to video
	LD	(IX+64+31),B
;
;	highest sector disk remainder
;
	LD	A,(IY+9)	;high sector disk
	RST	@18		;to decimal ascii
	LD	(IX+64+43),C	;to video
	LD	(IX+64+44),B
;
;	sectors / gran
;
	LD	A,(IY+10)	;sectors / gran
	RST	@18		;to decimal ascii
	LD	(IX+64+50),B	;LSB to video
;
;	grans / track
;
	LD	A,(IY+11)	;grans / track
	BIT	0,(IY+5)	;2 sides?
	JR	Z,$+3		;go if not
	ADD	A,A		;*2
	RST	@18		;to decimal ascii
	LD	(IX+64+56),B	;LSB to video
;
;	standard/inverted address marks on directory trk
;
	LD	A,'S'		;standard dir dams?
	BIT	2,(IY+6)	;yes?
	JR	Z,$+4		;yes, go!
	LD	A,'I'		;inverted dams
	LD	(IX+64+61),A	;to video
;
;	move to next drive
;
	LD	DE,80H		;offset to next video
	ADD	IX,DE		;bump video pointer
	LD	A,(TEMP9)	;get drive offset
	INC	A		;bump it
	LD	(TEMP9),A	;re-stash it
	CP	4		;any more?
	RET	NC		;nope, done!
	JP	SETSD0		;else go next drive
;
;	return with Y or N in A depending on Z flag
;
SETYES	LD	A,'Y'		;set ON
	RET	NZ		;bit set, return
	LD	A,'N'		;set OFF
	RET			;bit reset, return
;
	PAGE
;
;	$CONFIG - set/display system configuration
;
CONFIG	LD	A,9		;sub-menu return code
	CALL	SETUPS		;setup for activity
	RST	@08		;display title
;
	DEFB	CLSF		;clear screen
	DEFB	HGRAF
	DEFB	LGRAF
	DEFM	'  CONFIGURATION  '
	DEFB	RGRAF
	DEFB	HGRAF
	DEFB	LF
;
	DEFM	'Dual=x Graphics=x Locase=x '
	DEFM	'Linefeeds=x Doubler=x'
	DEFB	LF
	DEFB	ETX
;
;	display drive headers
;
	LD	B,4		;B=looper
FIGLP1	RST	@08		;display line
	DEFM	'x:x xxxx  '
	DEFM	'  Track Count=xxx Dir=xxx '
	DEFM	'Stp=x Rdly=x Wdly=x WP=x'
	DEFB	LF
	DEFM	'        D0=x Dd=x '
	DEFM	'LS0=x HS0=xx '
	DEFM	'LSd=x HSd=xx '
	DEFM	'S/G=x G/T=x DD=x'
	DEFB	LF
	DEFB	ETX
;
	DEC	B		;less looper
	JP	NZ,FIGLP1	;finish all headers
;
	XOR	A		;set beginning drive
	LD	(TEMP8),A	;pass it
;
;	fetch printer/doubler data from user
;
ASK1	CALL	SHOCFG		;display values
	LD	HL,VIDEO+320	;video line for prompt
	CALL	ASKFIG		;get keyboard input
	CALL	POSHL		;move HL to input
	JP	Z,ASK2		;nothing more
;
;	check 'DUAL'
;
	CALL	UCASE		;make it upper
	CP	'Y'		;yes?
	LD	B,20H		;bit 5 on
	JR	Z,ASK1A		;yes, go!
	LD	B,0		;bit 5 off
	CP	'N'		;no?
	JR	NZ,ASK1		;invalid, go!
ASK1A	LD	A,(FLAGA)	;read flag
	AND	0DFH		;reset bit 5
	OR	B		;set new condition
	LD	(FLAGA),A	;resave flag
	CALL	DLON		;turn dual on/off
;
;	check printer graphics
;
	INC	HL		;bump input pointer
	CALL	POSHL		;position to input
	JP	Z,ASK2		;no more input
	CALL	UCASE		;make it upper
	CP	'N'		;no?
	LD	B,0		;bits 7,5 off
	JR	Z,ASK1B		;none, go!
	CP	'Y'		;yes?
	LD	B,80H		;bit 7 on, 5 off
	JR	Z,ASK1B		;yes, go!
	CP	'M'		;mx80?
	LD	B,0A0H		;bit 7,5 on
	JR	NZ,ASK1		;invalid, ask again
ASK1B	LD	A,(FLAGB)	;get system flag
	AND	5FH		;bits 7,5 off
	OR	B		;set new condition
	LD	(FLAGB),A	;resave flag
;
;	check printer lower case
;
	INC	HL		;bump input pointer
	CALL	POSHL		;any more?
	JP	Z,ASK2		;nothing more, go!
	CALL	UCASE		;make it upper case
	CP	'Y'		;locase yes?
	LD	B,40H		;bit 6 on
	JR	Z,ASK1C		;yes, go!
	CP	'N'		;no?
	LD	B,0		;bit 6 off
	JP	NZ,ASK1		;invalid, ask again
ASK1C	LD	A,(FLAGB)	;get system flag
	AND	0BFH		;bit 6 off
	OR	B		;merge with new setting
	LD	(FLAGB),A	;put back the flag
;
;	check printer linefeeds on carriage returns
;
	INC	HL		;bump input pointer
	CALL	POSHL		;any more?
	JP	Z,ASK2		;nope, go drives!
	CALL	UCASE		;make upper case
	CP	'Y'		;linefeeds yes?
	LD	B,8		;bit 3 on
	JR	Z,ASK1D		;yes, go!
	LD	B,0		;bit 3 off
	CP	'N'		;no?
	JP	NZ,ASK1		;invalid, ask again
ASK1D	LD	A,(FLAGB)	;get system flag
	AND	0F7H		;bit 3 off
	OR	B		;merge with new
	LD	(FLAGB),A	;save flag
;
;	check doubler type
;
	INC	HL		;bump input pointer
	CALL	POSHL		;any more input?
	JP	Z,ASK2		;nope, continue
	CALL	UCASE		;make it upper
	CP	'N'		;no doubler?
	LD	B,10H		;bit 4 on
	JR	Z,ASK1E		;go if no doubler
	CP	'R'		;radio shack doubler?
	LD	B,0		;yes?
	JR	Z,ASK1E		;yes, go!
;
;m*
	IF	MAX80
	CP	'M'		;max 80 doubler?
	JR	Z,ASK1E		;yes, go!
	ENDIF
;m*
	CP	'X'		;brand X doubler?
	LD	B,4		;bit 2 flag
	JP	NZ,ASK1		;invalid, ask again
ASK1E	LD	A,(FLAGB)	;get system flag
	AND	0EBH		;bit 2/4 off
	OR	B		;set new bits
	LD	(FLAGB),A	;reset flags
;
;	check if HISPEED clock operation
;	(undocumented feature)
;
	INC	HL		;go next field
	CALL	POSHL		;any more input?
	JR	Z,ASK2		;nope, go drives!
	CALL	UCASE		;make it upper case
	CP	'N'		;no highspeed?
	LD	B,0		;nil bit
	JR	Z,ASK1F		;yes, go!
	CP	'Y'		;yes highspeed?
	LD	B,40H		;bit 6
	JP	NZ,ASK1		;go if invalid
ASK1F	LD	A,(FLAGA)	;get system flag
	RES	6,A		;bit 6 off
	OR	B		;merge it
	LD	(FLAGA),A	;update flag
;
	CALL	TURNSPD		;setup new clock
;
;	check if ON or OFF descriptors
;
	INC	HL		;bump pointer
ASK1G	CALL	POSHL		;any more input?
	JR	Z,ASK2		;nope, go!
	CALL	UCASE		;make upper case
	CP	'O'		;on?
	LD	DE,SPDON	;on code
	JR	Z,ASK1H		;go fetch it
	CP	'F'		;off?
	JP	NZ,ASK1		;go if invalid
	LD	DE,SPDOFF	;off code
;
ASK1H	INC	HL		;bump pointer
	LD	A,(HL)		;fetch char
	CP	'='		;equals?
	JP	NZ,ASK1		;invalid, ask again
	INC	HL		;bump to field
	EX	DE,HL		;DE => input
	PUSH	HL		;save table start
	LD	B,8		;8 chars long
	XOR	A		;load NOP's
	CALL	FILL		;clear it
	POP	IX		;get table start
	LD	B,8		;reset counter
;
ASK1I	LD	HL,STRING	;input pointer
	PUSH	HL		;save start
	LD	A,(DE)		;get string byte
	LD	(HL),A		;to string
	INC	DE		;bump 'em
	INC	HL
	LD	A,(DE)		;2 byte pairs
	LD	(HL),A		;to string
	INC	DE		;bump 'em
	INC	HL
	LD	(HL),'H'	;insert specifier
	INC	HL		;bump string
	LD	(HL),CR		;load terminator
	POP	HL		;get string start
;
	PUSH	BC		;save looper
	CALL	VALUE		;get hex value
	LD	A,C		;get LSB
	POP	BC		;restore stack
	JP	C,ASK1		;invalid, ask again
	LD	(IX),A		;to code
	INC	IX		;bump pointer
;
	EX	DE,HL		;HL => remainder input
	CALL	POSHL		;any more?
	JR	NZ,ASK1G	;go if more
;
;	fetch disk drive data from user
;
ASK2	XOR	A		;set drive 0 base
	CALL	GETCF		;get config 4 drives
	LD	A,(DRIVES)	;set drive 4 base
	CP	4		;4 drives only?
	JP	Z,SAVECON	;go if yes
	LD	A,4		;else set new base
	CALL	GETCF		;get config 4 drives
	JP	SAVECON		;return to main menu
;
GETCF	LD	(TEMP8),A	;save base pointer
	XOR	A		;set drive offset 0
	LD	(TEMP7),A	;save it
	LD	HL,VIDEO+384	;video offset
	LD	(TEMP6),HL	;save it
;
GETCFL	CALL	SHOCFG		;display settings
	LD	BC,(TEMP7)	;C=drive offset
	LD	A,(TEMP8)	;get base drive
	ADD	A,C		;add offset
	CALL	SETDRV		;setup drive activity
;
GETCNF	PUSH	IY		;save DCT
	PUSH	BC		;save drive
	CALL	SHOCFG		;display partial input
	POP	BC		;unstack
	POP	IY
	LD	HL,(TEMP6)	;get video prompt loc.
	CALL	ASKFIG		;prompt for input
	CALL	POSHL		;any input?
	LD	(CPPDIR),A	;save type
	JP	Z,GETCFN	;none, next drive
;
;	check for new 'copy' command
;
	CP	'<'		;copy?
	JR	Z,NCCPCF	;yes, go!
	CP	'>'		;copy?
	JR	NZ,NOTCCP	;not config copy, go!
NCCPCF	LD	(CPPDIR),A	;save for direction
	INC	HL		;bump pointer
	LD	A,(HL)		;get next char
	SUB	'0'		;check for digit
	JR	C,GETCNF	;error, ask again
	LD	BC,(DRIVES)	;get # drives
	CP	C		;in range?
	JR	NC,GETCNF	;go if not!
	LD	(IY+3),0	;reset current track
	PUSH	HL		;save input pointer
	PUSH	IY		;save
	PUSH	IY		;for pass to DE
	CALL	SETDRV		;locate DCT for new drive
	LD	(IY+3),0	;reset current drive
	PUSH	IY		;pass to HL
	POP	HL		;HL => new dct
	POP	DE		;DE => current DCT
	POP	IY		;restore IY
	LD	BC,13		;dct length
	LD	A,'$'		;get direction flag
CPPDIR	EQU	$-1
	CP	'>'		;copy TO new drive?
	JR	NZ,$+3		;go if not
	EX	DE,HL		;swap pointers
	LDIR			;move it in
	POP	HL		;restore input pointer
	INC	HL		;bump pointer
	CALL	POSHL		;any more input?
	JP	Z,GETCFN	;none, go next drive
;
;	check active, inactive, double step
;
NOTCCP	CP	'='		;double step?
	JR	Z,GETCNFC	;go if yes
	LD	B,0		;bits 7 off
	CP	'+'		;active drive?
	JR	Z,GETCNFA	;yes, go!
	LD	B,80H		;bit 7 on
	CP	'-'		;inactive drive?
	JR	NZ,GETCNFB+1	;neither, continue
GETCNFA	LD	A,(IY+4)	;get DCT data
	AND	7FH		;bit 7 off
	OR	B		;set new bits
	LD	(IY+4),A	;resave data
	RES	6,(IY+5)	;disable double step
	JR	GETCNFB		;continue
;
GETCNFC	SET	6,(IY+5)	;set double step
	RES	7,(IY+4)	;set drive as active
;
;	check for dos specifiers
;
GETCNFB	INC	HL		;bump pointer
	CALL	POSHL		;any more input?
	JP	Z,GETCFN	;get next drive
	CALL	CKCONF		;check for dos specifier
	JP	C,GETCNF	;error, ask again
;
;	fetch diskette track count
;
	CALL	POSHL		;any more input
	JP	Z,GETCFN	;none more, go next drive
	CALL	VALUE		;fetch input value
	JP	C,GETCNF	;error, ask again
	LD	A,C		;get value
	CP	2		;less than 2?
	JP	C,GETCNF	;disallow it
	CP	97		;1-96?
	JP	NC,GETCNF	;go if out of range
	LD	(IY+0),A	;to DCT
	CALL	RELTKS		;compute rel tracks
;
;	fetch directory track
;
	CALL	POSHL		;any more input?
	JR	Z,GETCFN	;go if not
	CALL	VALUE		;fetch value
	JP	C,GETCNF	;invalid, ask again
	LD	(IY+2),C	;insert dir into DCT
;
;	fetch disk drive step rate
;
	CALL	POSHL		;any more input?
	JR	Z,GETCFN	;no, continue
	CALL	VALUE		;fetch step rate
	JP	C,GETCNF	;invalid input
	LD	A,C		;get LSB
	CP	4		;must be 0-3
	JP	NC,GETCNF	;invalid (out of range)
	LD	B,A		;save it here
	LD	A,(IY+4)	;get DCT data
	AND	0FCH		;mask low 2 bits off
	OR	B		;merge with user input
	LD	(IY+4),A	;insert into DCT
;
;	check for READ motor delay
;
	CALL	POSHL		;any more input?
	JR	Z,GETCFN	;nope, go next drive
	CALL	VALUE		;fetch value
	JP	C,GETCNF	;go if invalid
	CALL	RATSTP		;convert to binary
	JP	C,GETCNF	;go if invalid
	LD	A,(IY+4)	;get current step
	AND	0CFH		;bit 5,4 off
	OR	B		;merge with new condition
	LD	(IY+4),A	;replace into DCT
;
;	check for WRITE motor on delay
;
	CALL	POSHL		;any more input?
	JR	Z,GETCFN	;nope, go next drive
	CALL	VALUE		;fetch value
	JP	NZ,GETCNF	;go if invalid
	CALL	RATSTP		;convert it
	JP	C,GETCNF	;go if out of range
	LD	A,(IY+4)	;fetch current
	AND	0F3H		;bits 3,2 off
	OR	C		;combine with new
	LD	(IY+4),A	;update DCT
;
;	check for software write protect
;
	CALL	POSHL		;any more input?
	JR	Z,GETCFN	;nope, get next drive
	CALL	UCASE		;make it upper case
	CP	'Y'		;yes?
	LD	B,40H		;bit 6 on
	JR	Z,CFF2		;go if yes
	CP	'N'		;no?
	LD	B,0		;bit 6 off
	JP	NZ,GETCNF	;nope, invalid
CFF2	LD	A,(IY+4)	;get DCT data
	AND	0BFH		;mask bit 6 off
	OR	B		;merge with new setting
	LD	(IY+4),A	;insert into DCT
;
;	advance to next drive
;
GETCFN	LD	A,(CPPDIR)	;get dir flag
	CP	'>'		;move?
	JP	Z,GETCNF	;yes, same line!
	CP	'<'		;move?
	JP	Z,GETCNF	;yes, same line!
	LD	HL,(TEMP6)	;get video prompt offset
	LD	DE,80H		;offset to next (2 lines)
	ADD	HL,DE		;HL => new video prompt
	LD	(TEMP6),HL	;save it back
	LD	A,(TEMP7)	;get drive offset
	INC	A		;bump it
	LD	(TEMP7),A	;put it back
	CP	4		;0-3?
	JP	NC,SHOCFG	;re-display
	JP	GETCFL		;else go next drive
;
	PAGE
;
;	$ASKFIG - prompt video for user input
;
;	ENT	HL = start of video line to prompt
;
;	EXT	HL => input string from keyboard
;
ASKFIG	PUSH	HL		;save video on stack
	LD	(HL),'='	;prompt char
	INC	HL		;bump it
	LD	(HL),'>'	;prompt char
;
	LD	HL,VIDEO+898	;set cursor to bottom
	LD	(CURSOR),HL	;set it there
	RST	@08		;display prompt
;
	DEFB	EOL		;clear input line
	DEFM	'? '
	DEFB	ETX
;
	LD	B,55		;length of input
	RST	@10		;fetch keyboard input
	EX	(SP),HL		;fetch prompt location
	LD	(HL),BLOCK	;reset graphics
	INC	HL		;next spot
	LD	(HL),SPACE	;clear prompt
	POP	HL		;HL => user input
	RET			;done!
;
;	$SAVECON - see if configuration is to be saved
;
SAVECON	CALL	SHOCFG		;display new config
	LD	HL,VIDEO+898	;cursor location
	LD	(CURSOR),HL	;save it
	RST	@08		;display prompt
;
	DEFB	EOL		;clear line
	DEFM	'Save Configuration? '
	DEFB	ETX
;
	LD	B,1		;1 char input
	RST	@10		;get fro keyboard
;
	CALL	POSHL		;any input?
	JP	Z,MASTER	;go master menu if not
	CALL	UCASE		;make upper case
	CP	'N'		;no?
	JP	Z,MASTER	;go if no save
	CP	'Y'		;yes?
	JR	NZ,SAVECON	;neither, ask again
;
;	saving configuration
;
	LD	HL,VIDEO+898	;reset cursor
	LD	(CURSOR),HL	;save it
	RST	@08		;display prompt
;
	DEFB	EOL		;clear line
	DEFM	'Mount PowerTOOL diskette, <KEY>:'
	DEFB	ETX
;
	LD	B,1		;one key
	RST	@10		;inkey it
;
;	writing to disk
;
PUTCONF	LD	BC,BUFFER	;I/O buffer to use
	CALL	ZBUFF		;clear it out
	PUSH	BC		;save buffer
	XOR	A		;load drive zero
	CALL	SETDRV		;setup for I/O
	CALL	DSTAT		;check for status
	JP	NZ,MENU		;go if SKIP bad
	LD	D,B		;pass to DE
	LD	E,C		;DE => buffer
	LD	HL,HEADCON	;header config sector
	LD	BC,HEADCOL	;length of header
	LDIR			;move it in
	LD	A,(ALVFLAG)	;alive flag
	LD	(DE),A		;to buffer
	INC	DE		;bump it
	LD	A,(MODE)	;modify mode
	LD	(DE),A		;to buffer
	INC	DE		;bump it
	LD	A,(DRIVES)	;# drives
	LD	(DE),A		;to buffer
	INC	DE		;bump pointer
	LD	A,(ALLFLAG)	;get dos system flag
	LD	(DE),A		;to buffer
	INC	DE		;bump pointer
	LD	A,(FLAGA)	;get flag A
	LD	(DE),A		;to buffer
	INC	DE		;bump buffer
	LD	A,(FLAGB)	;get flag B
	LD	(DE),A		;to buffer
	INC	DE		;bump buffer
	LD	HL,DISP1	;decrypt settings
	LD	BC,4		;length
	LDIR			;move in
	LD	HL,DCT0		;start of drive table
	LD	BC,13*8		;table length
	LDIR			;to I/O buffer
	LD	HL,$U		;user defined
	LD	BC,7		;length
	LDIR			;move in
	LD	HL,$X		;extra DCT's
	LD	BC,7*4		;length
	LDIR			;move in
	LD	HL,SPDOFF	;clock speed settings
	LD	BC,9*2		;length
	LDIR			;move it in
	LD	HL,FMTNAME	;default disk name
	LD	BC,8*2		;length
	LDIR			;move it in
	LD	HL,SPATTRN	;format patterns
	LD	BC,16*2		;length
	LDIR			;move it in
	CALL	COMPDAT		;compute DATA write
	LD	(WRTYPE),A	;pass it
	POP	BC		;restore buffer
	LD	A,(IY+5)	;get flags
	PUSH	AF		;to stack
	LD	A,(IY+6)	;flags
	PUSH	AF		;to stack
	LD	(IY+5),0	;single den
	LD	(IY+6),0	;single side
;
;i/m*
	IF	MODI.OR.MAX80
	LD	DE,0002H	;config mod I
	ENDIF
;i/m*
;iii*
	IF	MODIII
	LD	DE,0003H	;config mod III
	ENDIF
;iii*
	CALL	WRITE		;write the sector
	CALL	KILDISK		;kill disk
	EX	AF,AF'		;get flags
	POP	AF		;restore density flag
	LD	(IY+6),A	;save it
	POP	AF		;get type
	LD	(IY+5),A	;update
	EX	AF,AF'		;get flag back
	JP	Z,MASTER	;go menu if OK
	CALL	BDWTCLS		;monitor
	JP	Z,MASTER	;go if SKIP
	JP	PUTCONF		;try to write again
;
;	format directory track of current disk
;
KILDISK	PUSH	AF		;save
	PUSH	BC		;save
	PUSH	DE		;save
	LD	DE,0		;track0/sector 0
	LD	BC,BUFFER	;I/O buffer
	CALL	READ		;read it
	JR	Z,KILDSK	;go if OK
	BIT	4,A		;not found?
	CALL	NZ,TREAD	;try other density if not
	JR	NZ,KILRET	;go on error
KILDSK	LD	A,(BUFFER+2)	;get dir track
	LD	D,A		;pass to D
	LD	E,0		;sector 0
	CALL	SEEK		;move head there
	JR	NZ,KILRET	;go on error
	LD	BC,0		;point to ROM
	SET	7,(IY+5)	;set WRITE operation
	CALL	TRWRITE		;format track!
;
KILRET	POP	DE		;unstack
	POP	BC
	POP	AF		;restore
	RET			;done
;
;	header for config sector
;
HEADCON	DEFM	'PowerTOOL  '
	DEFM	'Configuration   '
HEADCOL	EQU	$-HEADCON
;
;	compute motor on delay in ascii
;
STPRAT	RRCA			;move 2 bits
	RRCA
	AND	3		;0-3 only
	JR	NZ,$+4		;go if 00
	LD	A,4		;make it 4/4 secs
	ADD	A,'0'		;add ascii
	RET			;done
;
;	compute bit position for input motor delay
;
RATSTP	LD	A,C		;fetch value
	OR	A		;check for zero
	SCF			;C = invalid
	RET	Z		;nil, return
	CP	5		;1-4?
	CCF			;reverse carry
	RET	C		;return if out of range
;
	AND	3		;adjust to 0-3
	ADD	A,A		;align to bits 2,3
	ADD	A,A
	LD	C,A		;save for WRITE
	ADD	A,A		;align to bits 4,5
	ADD	A,A
	LD	B,A		;save for READ
	OR	A		;clear carry flag
	RET			;done!
;
