; ptboot3/asm - kjw/bqsd - 10/82 - version 1.00 - 04/83
;
	PAGE
;
;	this is the actual TANDY Mod III DD loader
;	TRSDOS Version 1.3dd - 07/01/81
;
$DIF3	EQU	4300H-$		;offset to actual load
$SECL3	EQU	01		;lowest sector on track
$SECH3	EQU	18		;highest sector
;
;	boot entry point 4300H
;
BOOT3	CP	11H		;directory trk indicator
;
;	reset FDC controller
;
@3DENT	LD	A,0D0H		;FDC 'reset' command
	OUT	(0F0H),A	;FDC is clear
;
;	reset data pointer/flag
;
	LD	HL,0<8+2	;track 0 / sector 2
	LD	(@3DDAT1+$DIF3),HL ;save into DATA1
	XOR	A		;load zero for flag
	LD	(@3DDAT2+$DIF3),A ;save into DATA2
;
;	setup loop to load SYS0/SYS
;
@3DLOOP	CALL	@3DGETB+$DIF3	;read single byte
	CP	01H		;load block header?
	JR	Z,@3DLOP1	;go if yes
	CP	02H		;entry block header?
	JR	NZ,@3DENT	;restart if not!
;
;	entry block
;
	CALL	@3DGETB+$DIF3	;read length and ignore
	CALL	@3DGETL+$DIF3	;read load address
	JP	(HL)		;go SYS0/SYS!
;
	DEFB	-1		;filler?
;
;	load block
;
@3DLOP1	CALL	@3DGETB+$DIF3	;get length byte
	SUB	2		;less address length
	LD	B,A		;pass to B
	CALL	@3DGETL+$DIF3	;get load address
;
@3DLP1	CALL	@3DGETB+$DIF3	;get data byte
	LD	(HL),A		;to load address
	INC	HL		;bump load pointer
	DJNZ	@3DLP1		;go for length
	JR	@3DLOOP		;go next block
;
;	fetch load address from file
;
@3DGETL	CALL	@3DGETB+$DIF3	;get single byte
	LD	L,A		;pass LSB to L
	CALL	@3DGETB+$DIF3	;get single byte
	LD	H,A		;pass MSB to H
	RET			;done, HL = address
;
;	fetch single byte from file
;
@3DGETB	PUSH	BC		;save
	PUSH	HL		;save
	LD	A,(@3DDAT2+$DIF3) ;get buffer flag
	OR	A		;data in buffer?
	JR	NZ,@3DINBF	;yes, get it!
;
;	read next sector from file
;
	LD	B,09H		;init # retries
;
@3DRDLP	PUSH	BC		;save retry counter
	CALL	@3DREAD+$DIF3	;read the sector
	POP	BC		;restore count
	AND	1DH		;check for errors
	JR	Z,@3DRDOK	;go if no error
;
	LD	A,0D0H		;FDC 'reset' command
	OUT	(0F0H),A	;clear FDC from error
	DJNZ	@3DRDLP		;go for # retries
;
;	disk error!
;
	LD	A,17H		;double wide video
	CALL	0033H		;display control code
	LD	HL,@3DMG1+$DIF3	;'disk error'
	CALL	021BH		;display string to video
	JR	$		;wait here for re-boot
;
;	disk read OK, fetch byte from buffer
;
@3DRDOK	LD	HL,(@3DDAT1+$DIF3) ;fetch track sector
	INC	L		;bump sector #
	LD	A,L		;get sector #
	CP	$SECH3+1	;end of track?
	JR	C,@3DRDBO	;nope, continue
	LD	L,$SECL3	;reset to first sector
	INC	H		;bump track #
@3DRDBO	LD	(@3DDAT1+$DIF3),HL ;update next sector #
	XOR	A		;reset buffer to start
;
@3DINBF	LD	L,A		;pass buffer offset
	LD	H,4DH		;msb buffer address
	INC	A		;bump byte offset
	LD	(@3DDAT2+$DIF3),A ;update for next fetch
	LD	A,(HL)		;get byte from buffer
	POP	HL		;restore stack
	POP	BC		;restore counter
	RET			;done!
;
;	read sector from disk
;
@3DREAD	CALL	@3DSEEK+$DIF3	;execute 'SEEK' command
	LD	BC,0<8+0F3H	;B=counter, C=I/O port
	LD	A,81H		;drive 0/ double density
	OUT	(0F4H),A	;select drive
	LD	D,A		;pass select code
	LD	HL,@3DNMIR+$DIF3 ;NMI disk return vector
	LD	(404AH),HL	;setup pointer for NMI
	LD	A,0C3H		;JP opcode
	LD	(4049H),A	;setup jump for NMI
	DI			;disable for transfer
	LD	A,0C0H		;NMI condition bits
	OUT	(0E4H),A	;engage NMI
	LD	E,02H		;bit 1 test mask
	LD	HL,4D00H	;I/O buffer to use
	LD	A,84H		;FDC 'read' command
	OUT	(0F0H),A	;issue read command
	CALL	@3DSLO+$DIF3	;wait for valid status
;
@3DRD1	IN	A,(0F0H)	;read FDC status
	AND	E		;byte ready?
	JR	Z,@3DRD1	;wait for one
	INI			;read data from FDC
;
	LD	A,D		;get select code
	OR	40H		;set 'wait' command bit
;
@3DRD2	OUT	(0F4H),A	;issue 'wait' command
	INI			;read data byte
	JP	@3DRD2+$DIF3	;wait for interrupt
;
;	disk NMI interrupt vector
;
@3DNMIR	POP	HL		;remove interrupted addr
	XOR	A		;clear all bits
	OUT	(0E4H),A	;disable disk NMI
	LD	A,81H		;drive 0/double density
	OUT	(0F4H),A	;select drive 0
	CALL	@3DSLO2+$DIF3	;short delay for status
	IN	A,(0F0H)	;read FDC status result
	RET			;return with result
;
;	seek head to desired track
;
@3DSEEK	LD	A,81H		;drive 0/double density
	OUT	(0F4H),A	;select drive
	LD	HL,(@3DDAT1+$DIF3) ;read track/sector
	LD	A,H		;get track
	OUT	(0F3H),A	;to FDC track register
	LD	A,1CH		;FDC 'seek' command
	OUT	(0F0H),A	;issue command
	CALL	@3DSLO2+$DIF3	;delay for valid status
;
;	wait for seek to complete
;
@3DSEK	IN	A,(0F0H)	;read FDC status register
	BIT	0,A		;command in progress?
	JR	NZ,@3DSEK	;wait till completed
;
	LD	A,L		;get sector #
	OUT	(0F2H),A	;to FDC sector register
	RET			;done!
;
;	delay for valid FDC status
;
@3DSLO	PUSH	AF
	POP	AF
	PUSH	AF
	POP	AF
	PUSH	AF
	POP	AF
@3DSLO2	PUSH	AF
	POP	AF
	NOP
	RET
;
;	data storage for track/sector/byte offset
;
@3DDAT1	DEFW	0002H		;track/sector
@3DDAT2	DEFB	00H		;byte offset
;
;	text area
;
@3DMG1	DEFB	17H		;double wide video
	DEFM	'ERROR'
	DEFB	0DH		;terminator
;
;	serial # 00000000000000010000
;
@3DSER	MACRO	#@3DA,#@3DB
	DEFB	#@3DA-'0'<4+#@3DB-'0'
	ENDM
;
	@3DSER	'0','0'
	@3DSER	'0','0'
	@3DSER	'0','0'
	@3DSER	'0','0'
	@3DSER	'0','0'
	@3DSER	'0','0'
	@3DSER	'0','0'
	@3DSER	'0','1'
;
	DEFW	0000H		;filler?
	DEFB	13H		;version # 1.3 (bcd)
	DEFB	40		;track count
;
BOOT3L	EQU	$-BOOT3		;length of boot code
;
