; work3 - kjw/bqsd - dallas, texas
;
; created 02/24/83 - kjw
; revised 02/25/83 - kjw
;
	TITLE	'<WORK3/ASM>'
	SUBTTL	'<by Kim Watt - (c)(p) 1983 Breeze/QSD, Inc. - Dallas, Texas>'
;
;	size is 1352 bytes
;
;	contains the following subroutines
;
;	$SAVREG	- save registers and unstacker
;	$LOOKUP	- locate table vector
;	$POINT	- point to table by offset
;	$FILL	- fill buffer with character
;	$MOVE	- move memory block
;	$COMPAR	- compare memory blocks exact
;	$COMP	- compare memory blocks wild/independent
;	$POSHL	- position HL to significant character
;	$UCASE	- convert character to upper case
;	$LCASE	- convert character to lower case
;	$PARAM	- fetch parameters from user string
;	$EVAL	- fetch operation from user string
;	$WILD	- compare/set wildmask
;	$FETMEM	- allocate top memory
;	$RECMEM	- reclaim top memory
;	$RELO	- relocate program
;	$ERRMON	- error monitor
;	$RANDOM	- random number generator
;	$SORT	- sort memory buffer
;
	PAGE
;
;	$SAVREG	- preserve registers
;
;	ENT	none
;
;	EXIT	AF destroyed
;
@SAVREG	POP	AF		;get caller address
	PUSH	IY		;save registers
	PUSH	IX
	PUSH	HL
	PUSH	DE
	PUSH	BC
	PUSH	HL
	LD	HL,SAVREG1	;return vector
	EX	(SP),HL		;leave on stack, get HL
	PUSH	AF		;caller address
	RET			;return!
;
SAVREG1	POP	BC		;unstack 'em
	POP	DE
	POP	HL
	POP	IX
	POP	IY
	RET			;A returned from sub
;
	PAGE
;
;	$LOOKUP	- locate entry in table
;
;	ENT	HL => table (3 byte entries/term 00H)
;		A  = search character
;
;	EXIT	Z  = found, HL = table vector
;		NZ = A = -1 (not found), HL unchanged
;
@LOOKUP	PUSH	HL		;save start
LOOKUP1	INC	(HL)		;check for terminator
	DEC	(HL)		;(HL) = 00?
	JR	Z,LOOKUP3	;yes, not found!
	CP	(HL)		;matching entry?
	INC	HL		;bump table
	JR	Z,LOOKUP2	;yes, go!
	INC	HL		;bump table to next entry
	INC	HL		;3 bytes each
	JR	LOOKUP1		;try next entry
;
LOOKUP2	LD	A,(HL)		;get LSB vector
	INC	HL		;bump table
	LD	H,(HL)		;get MSB vector
	LD	L,A		;HL = vector
	POP	AF		;dummy pop HL
	XOR	A		;return Z for found
	RET			;done!
;
LOOKUP3	POP	HL		;restore table start
	OR	-1		;set NZ flag
	RET			;return NOT FOUND
;
	PAGE
;
;	$POINT	- point to table entry
;
;	ENT	HL => variable length table
;		C  =  number of bytes / entry
;		B  =  entry number to position (0 rel.)
;
;	EXIT	HL => table entry
;
@POINT	PUSH	BC		;save BC
	INC	B		;request 0?
POINT1	DEC	B		;yes?
	RET	Z		;done, go!
	LD	A,C		;get # bytes / entry
	ADD	A,L		;add to LSB table
	LD	L,A		;update
	JR	NC,POINT1	;go if no overflow
	INC	H		;bump MSB
	JR	POINT1		;continue
;
	PAGE
;
;	$FILL	- fill memory block
;
;	ENT	HL => buffer
;		B  = char count
;		A  = fill char
;
;	EXIT	buffer filled for length
;
@FILL	LD	(HL),A		;load character
	INC	HL		;bump pointer
	DJNZ	@FILL		;go for length
	RET			;done!
;
	PAGE
;
;	$MOVE	- move memory block (blocks can overlap)
;
;	ENT	HL = source address
;		DE = dest address
;		BC = block length in bytes
;
;	EXIT	block move from (HL) => (DE) for BC bytes
;
@MOVE	PUSH	HL		;save block start
	OR	A		;clear carry flag
	SBC	HL,DE		;compare source/dest
	POP	HL		;restore start
	JR	C,MOVBAK	;move backwards
	LDIR			;move forward
	RET			;block moved!
;
MOVBAK	ADD	HL,BC		;HL => end source +1
	DEC	HL		;HL => end source
	EX	DE,HL		;swap, DE=>source
	ADD	HL,BC		;HL => end dest +1
	DEC	HL		;HL => dest end
	EX	DE,HL		;HL=>source, DE=>dest
	LDDR			;move backward
	RET			;block moved!
;
	PAGE
;
;	$COMPAR	- compare two memory blocks
;
;	ENT	HL = source block address
;		DE = test block address
;		BC = block length
;
;	EXIT	Z  = blocks are identical
;			HL = HL + BC
;			DE = DE + BC
;			BC = 0000H
;		NZ = block differ
;			HL => mismatch
;			DE => mismatch
;			BC =  remaining byte count
;		Carry = DE < HL
;		NC/NZ = DE > HL
;
@COMPAR	LD	A,(DE)		;get test byte
	CP	(HL)		;match?
	RET	NZ		;nope, end test!
	INC	HL		;bump source
	INC	DE		;bump test
	DEC	BC		;less count
	LD	A,B		;any more left?
	OR	C		;BC = 0000H?
	JR	NZ,@COMPAR	;go if more to do
	RET			;done! Z = identical
;
	PAGE
;
;	$COMP	- special string comparator
;
;	ENT	HL = source block address (compare mask)
;		DE = test block address
;		BC = block length
;
;	EXIT	Z  = blocks are identical
;			HL = HL + BC
;			DE = DE + BC
;			BC = 0000H
;		NZ = block differ
;			HL => mismatch
;			DE => mismatch
;			BC =  remaining byte count
;		Carry = DE < HL
;
@COMP	LD	A,(HL)		;get mask byte
	CALL	@UCASE		;make upper case
	CP	'?'		;wild character?
	JR	Z,CMPNX		;yes, assume match
	CP	'$'		;wild character?
	RET	Z		;yes, match entire string
	LD	(CMPCH),A	;save wild character
	LD	A,(DE)		;get test char
	CALL	@UCASE		;make upper case
	CP	'$'		;match?
CMPCH	EQU	$-1
	RET	NZ		;nope, end compare!
CMPNX	INC	HL		;bump mask string
	INC	DE		;bump test string
	DEC	BC		;less byte counter
	LD	A,B		;any more?
	OR	C		;BC = 0000H?
	JR	NZ,@COMP	;go next char if more
	RET			;done!
;
	PAGE
;
;	$POSHL	- position HL to significant character
;
;	ENT	HL => string to parse
;
;	EXIT	HL => significant char or terminator
;		Z  = terminator 03H or 0DH found
;		NZ = A = first valid char @ (HL)
;		Carry = valid character < 0DH
;		spaces and commas are ignored
;
	INC	HL		;bump pointer
@POSHL	LD	A,(HL)		;get character
	CP	' '		;space?
	JR	Z,@POSHL-1	;yes, ignore it
	CP	','		;comma?
	JR	Z,@POSHL-1	;yes, ignore it
CKTERM	CP	03H		;terminator?
	RET	Z		;yes, go!
	CP	0DH		;terminator?
	RET			;return with Z/C flags
;
	PAGE
;
;	$UCASE	- convert character to upper case
;
;	ENT	A = character
;
;	EXIT	A = upper case character
;
@UCASE	CP	'a'		;in lowcase range?
	RET	C		;nope, not valid
	CP	'z'+1		;in range?
	RET	NC		;nope, not valid
	SUB	20H		;make upper case
	RET			;done!
;
	PAGE
;
;	$LCASE	- convert character to lower case
;
;	ENT	A = character
;
;	EXIT	A = lower case character
;
@LCASE	CP	'A'		;in range?
	RET	C		;nope, return!
	CP	'Z'+1		;in range?
	RET	NC		;nope, return!
	ADD	A,20H		;make lower case
	RET			;done!
;
	PAGE
;
;	$PARAM	- evaluate user input
;
;	ENT	HL => string to parse
;		DE => parameter list
;
;	EXIT	DE = unchanged
;		Z  = all params OK or NO params
;		NZ = A = FFH error
;		HL => terminating/offending char
;
;	PARAMETER LIST:
;
;	+0	- 7 = string expression valid
;		- 6 = value expression valid
;		- 5 = switch expression valid
;		- 4-0 = string length -1 (1-16 chars)
;	+1,+2	- parameter data indirect address
;	+3->	- string (must be in upper case)
;		terminate list with 00H
;
;	if string expression, vector will be loaded with
;		start of string which will be forced to
;		terminate with ETX (03H)
;	if value expression, indirect vector address
;		must be 3 bytes in length for 24 bit val.
;	if switch expression, true with leave FFFFH
;		false will leave 0000H
;
@PARAM	CALL	@POSHL		;position to input
	JR	Z,PARAMB	;no more, return Z
	PUSH	DE		;save param block start
	CALL	DOPARAM		;locate parameter
	POP	DE		;restore
	RET	NZ		;go if not found!
	JR	@PARAM		;fetch next one!
PARAMB	XOR	A		;return ZERO
	RET			;done!
;
;	evaluate parameter
;
DOPARAM	LD	A,(DE)		;get table entry
	OR	A		;table terminator?
	JR	Z,EXPERR	;expression error!
	AND	0FH		;get length
	INC	A		;adjust 0-15 => 1-16
	LD	B,A		;pass length
	PUSH	BC		;save length
	PUSH	DE		;save param pointer
	CALL	THISONE		;matching?
	POP	DE		;restore
	POP	BC		;restore
	JR	Z,HAVTHIS	;found! go!
	INC	DE		;bump past vector
	INC	DE
	INC	DE		;bump past param word
HAVNXT	INC	DE		;bump pointer
	DJNZ	HAVNXT		;for word length
	JR	DOPARAM		;check next word
;
;	check for any expression
;
HAVTHIS	LD	BC,-1		;default value (TRUE)
	LD	A,(HL)		;get next char
	CP	'='		;expression follows?
	JR	Z,HAVEXP	;yes, go!
	EX	DE,HL		;HL => param control bits
	BIT	5,(HL)		;switch valid?
	EX	DE,HL		;swap back
	JR	Z,EXPERR	;nope, expression error!
;
;	place result of expression
;
PUTPAR	PUSH	HL		;save string pointer
	CALL	GETIND		;get indirect pointer
	LD	(HL),C		;load LSB value
	INC	HL		;bump pointer
	LD	(HL),B		;load MSB value
	POP	HL
	XOR	A		;set Z for OK
	RET			;go next param
;
;	check for string expression
;
HAVEXP	INC	HL		;bump string
	LD	A,(HL)		;get next char
	CP	'"'		;string start?
	JR	Z,HAVSTR	;yes, go!
	CP	27H		;string start?
	JR	Z,HAVSTR	;yes, go!
	EX	DE,HL		;HL => param flag bits
	BIT	5,(HL)		;can it be a switch?
	EX	DE,HL		;swap back
	JR	Z,EXPVAL	;no switch allowed!
;
;	evaluate logical expression
;
	PUSH	DE		;save table
	LD	DE,ONMSG-3	;ON?
	LD	B,2		;length
	CALL	THISONE		;match?
	JR	Z,HAVTRUE	;yes, have true
	LD	DE,OFFMSG-3	;OFF?
	LD	B,3		;length
	CALL	THISONE		;match?
	JR	Z,HAVFAL	;yes, have false exp.
	LD	DE,YESMSG-3	;YES?
	LD	B,3		;length
	CALL	THISONE		;match?
	JR	Z,HAVTRUE	;yes, true
	LD	DE,NOMSG-3	;NO?
	LD	B,2		;length
	CALL	THISONE		;match?
	JR	Z,HAVFAL	;yes, false expression
	POP	DE		;restore
;
;	evaluate numeric expression
;
EXPVAL	EX	DE,HL		;HL => flag bits
	BIT	6,(HL)		;value valid?
	EX	DE,HL		;swap back
	JR	Z,EXPVOK	;yes, value OK
EXPERR	LD	A,-1		;set NZ
	OR	A		;return NC, NZ
	RET			;param error!
;
EXPVOK	PUSH	DE		;save DE
	CALL	@VALUE		;fetch numeric value
	LD	A,C		;get MSB value
	LD	B,D		;get NSB value
	LD	C,E		;get LSB value
	POP	DE		;restore (ABC = value)
	RET	NZ		;go if error!
;
;	place result of numerical expression
;
	PUSH	HL		;save string pointer
	CALL	GETIND		;get indirect pointer
	LD	(HL),A		;place MSB
	INC	HL		;bump pointer
	LD	(HL),B		;place NSB
	INC	HL		;bump pointer
	LD	(HL),C		;place LSB
	POP	HL		;restore
	XOR	A		;return Z for OK
	RET			;done!
;
GETIND	PUSH	DE		;save DE
	INC	DE		;bump pointer
	EX	DE,HL		;HL => vector
	LD	E,(HL)		;get LSB
	INC	HL		;bump pointer
	LD	D,(HL)		;get MSB
	EX	DE,HL		;HL = indirect vector
	POP	DE		;restore DE
	RET			;done, HL => vector
;
;	evaluate string expression
;
HAVSTR	EX	DE,HL		;HL => param flag bits
	BIT	7,(HL)		;string OK?
	EX	DE,HL		;swap back
	JR	Z,EXPERR	;go if not!
	INC	HL		;bump past ' "
	LD	B,H		;pass pointer to BC
	LD	C,L		;BC => string start
	LD	(STRTRM),A	;save string terminator
HAVSLP	LD	A,(HL)		;get next char
	CALL	CKTERM		;terminator?
	JR	Z,TERMSTR	;yes, terminate string!
	INC	HL		;bump pointer
	CP	'$'		;terminator?
STRTRM	EQU	$-1
	JR	NZ,HAVSLP	;continue if not
	LD	(HL),3		;force terminate with 03H
	INC	HL		;bump pointer
	JP	PUTPAR		;load expression
TERMSTR	LD	(HL),3		;force terminate string
	JP	PUTPAR		;load expression
;
HAVFAL	LD	BC,0000H	;0 = false
	POP	DE		;restore stack
	JP	PUTPAR		;load parameter
;
HAVTRUE	LD	BC,0FFFFH	;-1 = true
	JR	HAVFAL+3	;continue
;
;	scan field for a match
;
THISONE	PUSH	HL		;save string pointer
	INC	DE		;bump to string
	INC	DE
	INC	DE
	XOR	A		;init counter
	EX	AF,AF'		;save it in A'
THISLP	LD	A,(HL)		;get a char
	CALL	@UCASE		;make upper case
	LD	C,A		;save test byte
	LD	A,(DE)		;get param byte
	CP	C		;match?
	JR	Z,THISNOT	;nope, go!
	INC	HL		;bump string
	INC	DE		;bump param
	EX	AF,AF'		;get length
	INC	A		;+1
	EX	AF,AF'		;save length
	DJNZ	THISLP		;go for length
	EX	(SP),HL		;replace new HL
	POP	HL		;restore stack
	EX	AF,AF'		;get counter back
	CP	A		;set Z flag
	RET			;done!
;
THISNOT	EX	AF,AF'		;get flag
	DEC	A		;single char?
	JR	NZ,THISBAD	;nope, mismatch
	LD	A,(HL)		;get next char
	CALL	VALCHR		;valid character?
	JR	NZ,THISBAD	;yes, go!
	EX	(SP),HL		;replace new HL
	POP	HL		;restore stack
	LD	A,1		;set 1 byte matches
	CP	A		;set Z flag
	RET			;return match
;
THISBAD	POP	HL		;restore string start
	OR	A		;set NZ
	RET			;done!
;
	PAGE
;
;	$EVAL	- evaluate user input string
;
;	ENT	IX => parameter block
;		HL => string to evaluate
;
;	EXIT	HL => terminating/offending char
;		DE => param address block (if Z set)
;		Z  =  OK, params loaded
;		NZ = A = FFH error
;
;	PARAMETER BLOCK:
;
;	+0	- work byte for flag use
;	+1,+2	- source DCB pointer (50 bytes)
;	+3,+4	- dest DCB pointer (50 bytes)
;	+5,+6	- mask DCB pointer (50 bytes)
;	+7,+8	- param list address for param
;
;	on exit, IX + 0
;	bit 3 = 0 = nil parameters
;	bit 2 = 1 = source field filled
;	bit 1 = 1 = dest field filled
;	bit 0 = 1 = mask field filled
;
@EVAL	PUSH	BC		;save it
	LD	(IX+0),0	;clear flags
;
EVALLP	LD	A,(IX+0)	;get flags
	AND	0FH		;low 4 bits only
	LD	(IX+0),A	;update flags
;
;	check for param field
;
EVALO	LD	A,(HL)		;get a char
	CP	','		;start param field?
	JR	Z,EVALP		;yes, go param!
	CP	'('		;start param field?
	JR	Z,EVALP-1	;yes, go param!
;
;	check for field end
;
	CALL	CKTERM		;terminator?
	JR	Z,EVALRET	;yes, go!
;
;	check for field tabs
;
	INC	HL		;bump pointer
	CP	' '		;separator?
	JR	Z,EVALO		;yes, go!
	DEC	HL		;adjust back
;
;	TO field specified?
;
	LD	DE,TOMSG-3	;TO?
	LD	B,2		;2 chars
	CALL	THISONE		;match?
	JR	NZ,CKFROM	;nope, go!
	DEC	A		;single char?
	JR	Z,CKFROM-1	;yes, cannot use!
	SET	6,(IX+0)	;set TO flag
	JR	EVALO		;continue
;
EVALERR	LD	A,-1		;param error
	OR	A		;set NZ/NC
;
;	exit eval routine
;
EVALRET	POP	BC		;restore stack
	RET	NZ		;go on error
	XOR	A		;else return Z
	RET			;done!
;
;	evaluate PARAM field
;
	INC	HL		;bump pointer
EVALP	POP	BC		;restore stack
	LD	E,(IX+7)	;get param block
	LD	D,(IX+8)	;DE => param block
	JP	@PARAM		;go $PARAM
;
;	FROM field specified?
;
	DEC	HL		;reset pointer
CKFROM	LD	DE,FROMMSG-3	;FROM?
	LD	B,4		;length
	CALL	THISONE		;match?
	JR	NZ,CKUSE	;nope, go!
	DEC	A		;single char match?
	JR	Z,CKUSE-1	;yes, backspace
	SET	7,(IX+0)	;set FROM flag
	JR	EVALO		;continue
;
;	USING field specified?
;
	DEC	HL		;reset pointer
CKUSE	LD	DE,USEMSG-3	;start message
	LD	B,5		;text length
	CALL	THISONE		;match?
	JR	NZ,CKNXT	;nope, go!
	DEC	A		;single char?
	JR	Z,CKNXT-1	;yes, backspace & cont.
	SET	5,(IX+0)	;set USING field
	JR	EVALO		;continue
;
;	fetch field here
;
	DEC	HL		;backspace HL
CKNXT	LD	E,(IX+9)	;get work area
	LD	D,(IX+10)	;DE => 51 byte area
	CALL	@FSPEC		;fetch filespec
	JR	NZ,EVALRET	;go if error!
	LD	A,(DE)		;get first byte
	BIT	5,A		;wild card chars?
	JR	NZ,CHKMASK	;wild, force MASK
	LD	A,(IX+0)	;get flags
	AND	0E0H		;anything here?
	JR	NZ,EVALC	;nope, load next field
	LD	A,(IX+0)	;get again
	CPL			;reverse bits
	RLCA			;align to high bits
	RLCA
	RLCA
	RLCA
	RLCA
;
EVALC	RLCA			;bit 7?
	JR	C,FILSRC	;yes, fill source!
	RLCA			;bit 6?
	JR	C,FILDES	;yes, fill dest!
	JR	FILMASK		;fill mask!
;
CHKMASK	LD	A,(IX+0)	;get flags
	AND	0C0H		;TO/FROM specified?
	JR	NZ,EVALERR	;yes, error!
;
;	fill mask field
;
FILMASK	BIT	0,(IX+0)	;mask filled?
	JR	NZ,EVALERR	;yes, go error!
	LD	C,(IX+5)	;get mask address
	LD	B,(IX+6)
	SET	0,(IX+0)	;set filled
	JR	EVALFIL		;move field in!
;
;	fill source field
;
FILSRC	BIT	2,(IX+0)	;source filled?
	JP	NZ,EVALERR	;yes, go error!
	LD	C,(IX+1)	;get source address
	LD	B,(IX+2)
	SET	2,(IX+0)	;set filled
	JR	EVALFIL		;move field in!
;
;	fill dest field
;
FILDES	BIT	1,(IX+0)	;dest filled?
	JP	NZ,EVALERR	;yes, go error!
	LD	C,(IX+3)	;get field address
	LD	B,(IX+4)
	SET	1,(IX+0)	;set filled
;
;	fill general field
;
EVALFIL	PUSH	HL		;save string pointer
	EX	DE,HL		;HL => DCB
	LD	D,B		;pass BC => DE
	LD	E,C		;DE => field
	LD	BC,51		;field length
	LDIR			;move it in
	POP	HL		;restore string pointer
	JP	EVALLP		;go next field
;
;	text for $PARAM/$EVAL use
;
FROMMSG	DEFM	'FROM'
USEMSG	DEFM	'USING'
YESMSG	DEFM	'YES'
TOMSG	DEFM	'T'
ONMSG	DEFM	'O'
NOMSG	DEFM	'N'
OFFMSG	DEFM	'OFF'
;
	PAGE
;
;	$WILD	- set/compare wild mask
;
;	ENT	B  = 0	- set wild card mask
;		HL => wildmask
;	EXIT	Z  = OK
;		NZ = invalid mask specification
;
;	ENT	B  = 1	- compare filespec with mask
;		HL => filespec to compare
;	EXIT	Z  = OK, match
;		NZ = file does not match mask
;
;	ENT	B  = 2	- combine name/ext to filespec
;		HL => 11 byte buffer (NAME    EXT) padded
;		DE => 13 byte buffer to hold filespec
;	EXIT	Z  = OK
;		NZ = invalid filespec chars
;
;	ENT	B  = 3	- compare cracked with mask
;		HL => cracked filespec to compare
;	EXIT	Z  = match
;		NZ = NO match
;
@WILD	CALL	@SAVREG		;save registers
	XOR	A		;load zero
	CP	B		;B = 0?
	JR	Z,WILD0		;yes, set mask
	DEC	B		;B = 1?
	JP	Z,WILD1		;compare file => mask
	DEC	B		;B = 2?
	JR	Z,WILD2		;un-crack filespec
	DEC	B		;B = 3?
	RET	NZ		;error, return!
	JP	WILD3		;compare cracked
;
;	combine name/ext into filespec
;
WILD2	LD	B,8		;8 chars in name
	CALL	WILD2M		;move it in
	RET	NZ		;invalid chars
;
;	check for extension
;
	LD	A,(HL)		;get next char
	CP	' '		;space?
	JR	Z,WILD2D	;yes, done!
;
;	exists, insert extension
;
	LD	A,'/'		;extension
	LD	(DE),A		;to string
	INC	DE		;bump pointer
	LD	B,3		;3 chars in extension
	CALL	WILD2M		;move it in
	RET	NZ		;invalid chars!
;
;	completed, insert ETX
;
WILD2D	LD	A,3		;ETX
	LD	(DE),A		;terminate string
;
WILDRET	XOR	A		;return Z
	RET			;done!
;
;	move characters from (HL) => (DE)
;
WILD2M	LD	A,(HL)		;get a char
	CP	' '		;space?
	JR	Z,WILD2N	;yes, skip it
	CALL	VALCHR		;valid character?
	JR	Z,WILD2B	;error, go!
	LD	(DE),A		;to string
	INC	DE		;bump dest
WILD2N	INC	HL		;bump source
	DJNZ	WILD2M		;finish move
	XOR	A		;return Z
	RET			;done!
;
WILD2B	LD	A,-1		;set error
	OR	A		;set NZ
	RET			;invalid chars
;
;	set wildmask
;
WILD0	PUSH	HL		;save string pointer
	LD	HL,WILDMSK	;internal mask
	PUSH	HL		;leave on stack
	LD	B,11		;11 byte field
	LD	A,'?'		;fill char
	CALL	@FILL		;fill buffer
	POP	DE		;DE => mask
	POP	HL		;HL => user string
;
	LD	B,8		;8 chars max in name
	CALL	WILD0M		;move in
	JR	Z,WILD0E	;go if OK
	CP	'/'		;offending char?
	JR	NZ,WILD2B	;error if not!
;
WILD0E	LD	B,3		;3 chars max extension
	CALL	WILD0M		;move it in
	JR	NZ,WILD2B	;go if error
	XOR	A		;else return Z
	RET			;done!
;
;	move chars into mask field
;
WILD0M	LD	A,(HL)		;get a char
	CALL	CKTERM		;terminator?
	JR	Z,WILD0T	;term, go!
;
	CALL	VALCHR		;valid character?
	JR	Z,WILD0B	;nope, check for error
;
	CP	'$'		;wildcard char?
	JR	Z,WILD0F	;yes, fill!
	CP	'!'		;wildcard char?
	JR	Z,WILD0F	;yes, fill!
;
	CALL	@UCASE		;make upper case
	LD	(DE),A		;to wildmask
	INC	DE		;bump mask
	INC	HL		;bump string
	DJNZ	WILD0M		;continue for length
	LD	A,(HL)		;get next char
	CP	'/'		;extension?
	JR	NZ,WILD0R	;nope, go!
	INC	HL		;skip past it
WILD0R	XOR	A		;return OK
	RET			;done!
;
;	fill remainder of field with blanks
;
WILD0F	LD	A,'?'		;use to fill
	CALL	WILD0FS		;fill it up
	LD	A,(HL)		;get char back
	CP	'!'		;fill remainder?
	RET	Z		;yes, go!
	INC	HL		;bump pointer
	LD	A,(HL)		;get next char
	CALL	CKTERM		;terminator?
	RET	Z		;yes, return!
	JR	WILD0B		;else generate error
;
WILD0FS	INC	B		;done with field?
WILD0FF	DEC	B		;B = 0?
	JR	Z,WILD0R	;yes, go!
	LD	(DE),A		;char to field
	INC	DE		;bump pointer
	JR	WILD0FF		;continue
;
WILD0B	CP	'/'		;extension?
	INC	HL		;bump pointer
	RET	NZ		;nope, error!
WILD0T	LD	A,' '		;fill character
	JR	WILD0FS		;fill field
;
;	compare filespec to mask
;
WILD3	LD	DE,WILDMSK	;start wildmask
	EX	DE,HL		;HL => mask
	JP	@COMP		;special comparator
;
;	compare filespec to mask
;
WILD1	EX	DE,HL		;DE => filename
	LD	HL,NAME		;work buffer
	PUSH	HL		;save start
	CALL	CRACK		;crack filespec
	POP	HL		;HL => name
	RET	NZ		;go if error!
	JR	WILD3		;compare now
;
;	crack open filespec
;
CRACK	PUSH	HL		;save start
	LD	B,11		;field length
	LD	A,' '		;fill with spaces
	CALL	@FILL		;fill it up
	POP	HL		;HL => start
;
	EX	DE,HL		;HL=> filespec
	LD	B,8		;8 chars in name
	CALL	GETFLD		;crack field
	LD	C,A		;save term char
	LD	A,B		;get length
	CP	8		;anything?
	JR	NZ,CRACK2	;nope, go!
CRACKN	OR	-1		;set NZ flag
	RET			;return with error
;
CRACK2	LD	A,C		;get term char
	CP	'/'		;extension?
	JR	Z,CRACK3	;yes, go!
	XOR	A		;else done!
	RET			;go!
;
CRACK3	LD	B,3		;3 chars to move
	LD	DE,NAME+8	;start where it goes
	CALL	GETFLD		;get field
	LD	A,B		;get field
	CP	3		;anything?
	JR	Z,CRACKN	;nil, go!
	XOR	A		;else OK
	RET			;done!
;
GETFLD	LD	A,(HL)		;get a character
	CALL	VALCHR		;valid character?
	INC	HL		;bump pointer
	RET	Z		;nope, return!
	CALL	@UCASE		;make upper case
	LD	(DE),A		;to buffer
	INC	DE		;bump pointer
	DJNZ	GETFLD		;go for length
;
	LD	A,(HL)		;get next char
	INC	HL		;bump pointer
	RET			;done!
;
;	wildmask storage and crack workspace
;
WILDMSK	DEFM	'???????????'
NAME	DEFM	'???????????'
;
	PAGE
;
;	$FETMEM	- fetch top memory allocation
;
;	ENT	BC = # bytes requested in HIMEM
;
;	EXIT	NZ = A = error code (insufficient mem)
;		Z  = OK &
;		BC = # bytes needed (unchanged)
;		HL = first free address to use
;		(HIMEM) adjust accordingly
;
FETMEM	PUSH	DE		;save
	PUSH	HL		;save
	PUSH	BC		;save # needed
	CALL	@HIMEM		;fetch memory pointers
	PUSH	HL		;save himem
	OR	A		;clear carry flag
	SBC	HL,BC		;HIMEM - LOMEM
	POP	AF		;get HL
	POP	BC		;restore BC
	PUSH	AF		;put HL back
	OR	A		;clear carry
	SBC	HL,BC		;any room?
	LD	A,-1		;set error
	POP	HL		;restore topmem
	JR	C,FETMRET	;go if insufficient
	SBC	HL,BC		;HL = free memory
	CALL	@SETMEM		;set HIMEM @ HL
	INC	HL		;HL => user area
	EX	(SP),HL		;leave on stack
	XOR	A		;set Z for OK
;
FETMRET	POP	HL		;unstack HL
	POP	DE		;restore DE
	RET			;Z = OK, NZ = insuffic.
;
	PAGE
;
;	$RECMEM	- reclaim top memory pointer
;
;	ENT	HL = address of block to reclaim
;		BC = block length
;
;	EXIT	memory reclaimed if (HIMEM) = HL -1
;
@RECMEM	PUSH	DE		;save
	PUSH	BC		;save length
	PUSH	HL		;save start
	CALL	@HIMEM		;get current HIMEM
	LD	B,H		;pass to BC
	LD	C,L		;BC = current himem
	POP	HL		;get start back
	PUSH	HL		;back to stack
	SCF			;for test
	SBC	HL,BC		;same?
	POP	HL		;get start
	POP	BC		;get length
	POP	DE		;get stack
	RET	NZ		;nope, cannot touch!
	PUSH	HL		;save HL
	ADD	HL,BC		;new topmem
	CALL	@SETMEM		;set new himem
	POP	HL		;restore HL
	RET			;done, memory reclaimed!
;
	PAGE
;
;	$RELO	- relocate program
;
;	ENT	IX => resolve table terminate FFFFH
;		DE =  program current low address
;		HL =  program current high address +1
;		BC =  program current entry vector
;
;	EXIT	NZ = A = FFH (cannot relocate)
;		will not return if relocate OK
;
@RELO	PUSH	BC		;save entry vector
	OR	A		;clear carry
	SBC	HL,DE		;HL = program length
	LD	B,H		;pass to BC
	LD	C,L		;BC = program length
	CALL	@FETMEM		;fetch high memory
	JR	NZ,RELONOT	;cannot relocate!
	PUSH	BC		;save program length
	PUSH	HL		;save new address
	OR	A		;clear carry flag
	SBC	HL,DE		;HL = offset factor
	LD	B,H		;pass to BC
	LD	C,L		;BC = offset
;
;	resolve program addresses
;
RESOL	LD	L,(IX+0)	;get address
	LD	H,(IX+1)	;HL = resolve address
	LD	A,H		;terminator?
	AND	L		;HL = FFFFH?
	INC	A		;yes?
	JR	Z,RESOK		;yes, resolved!
	LD	A,(HL)		;get LSB address
	ADD	A,C		;add to LSB offset
	LD	(HL),A		;update
	INC	HL		;point to MSB
	LD	A,(HL)		;get MSB address
	ADC	A,B		;add to MSB offset
	LD	(HL),A		;update
	INC	IX		;bump table
	INC	IX		;2 byte entries
	JR	RESOL		;go next entry
;
RESOK	LD	(RESOFF),BC	;save offset factor
	POP	HL		;get program start
	POP	BC		;get program length
	EX	DE,HL		;HL=>OLD, DE=>NEW
	LDIR			;move program to new loc.
	POP	BC		;get program entry
	LD	A,B		;entry = 0000H?
	OR	C
	JP	Z,@EXIT		;yes, exit program!
	LD	HL,$		;get offset factor
RESOFF	EQU	$-2
	ADD	HL,BC		;HL = new vector
	JP	(HL)		;go offset program
;
RELONOT	POP	BC		;restore stack
	OR	-1		;set NZ
	RET			;done!
;
	PAGE
;
;	$RANDOM	- generate random number
;
;	ENT	B = limit value (2-255)
;
;	EXIT	C = random number in range 0 to B-1
;		if B = 0 or 1, then return C = 0
;		A = 0
;		Z set
;
@RANDOM	LD	A,B		;get limit value
	OR	A		;0?
	JR	Z,RANRET	;yes, go!
	DEC	A		;1?
	JR	Z,RANRET	;yes, go!
	CALL	RANDO		;get random number
;
;	force into specified range
;
RANDI	CP	B		;within limit?
	JR	C,RANRET	;yes, go!
	SUB	B		;less limit
	JR	RANDI		;continue
RANRET	LD	C,A		;pass value
	XOR	A		;return Z
	RET			;done!
;
;	generate pseudo-random number
;
RANDO	LD	A,R		;refresh register
	XOR	37H
RAND1	EQU	$-1
	LD	(RAND3),A
	RRCA
	RRCA
	XOR	2FH
RAND2	EQU	$-1
	LD	(RAND1),A
	RLA
	XOR	77H
RAND3	EQU	$-1
	LD	(RAND2),A
	RET			;A = 'random' number
;
	PAGE
;
;	$SORT	- sort memory block
;
;	ENT	IX => first entry in list
;		DE => start of last entry in list
;		B  =  position of key
;		C  =  length of each entry
;		L  =  length of sort key
;		H  =  sort flag/ 0=ascending
;
;	$SORT2	- sort memory block
;
;	ENT	same as above except
;		DE =  # entries to sort
;
@SORT	CALL	@SAVREG		;save registers
	CALL	NUMENT		;DE = entry count
	JR	$+5		;continue
;
@SORT2	CALL	@SAVREG		;save registers
	CALL	SETSORT		;setup parameters
	RET	NZ		;invalid params
;
SORT0	LD	(BASE),HL	;save base address
	LD	D,H		;pass to DE
	LD	E,L		;DE = current posit
	PUSH	BC		;save count
	JR	SORT2		;continue
;
SORT1	CALL	CPAIR		;compare
	JR	Z,SORT2		;go if equal
	JR	C,SORT2		;go if <>
SRTDIR	EQU	$-1
	LD	H,D		;pass lowest to HL
	LD	L,E		;HL = lowest
;
SORT2	PUSH	HL		;save address
	LD	HL,0		;get length
SRTLEN	EQU	$-2
	ADD	HL,DE		;HL => next entry
	EX	DE,HL		;DE => next entry
	POP	HL		;get lowest one
	DEC	BC		;less entry counter
	LD	A,B		;any more
	OR	C		;yes?
	JR	NZ,SORT1	;finish this pass
;
;	test for current = lowest found
;
	EX	DE,HL		;DE = test lowest
	LD	HL,$		;get start address
BASE	EQU	$-2
	OR	A		;clear carry
	SBC	HL,DE		;at lowest?
	JR	Z,SORT3		;go if at lowest!
	LD	HL,(BASE)	;get base address back
	PUSH	BC		;save count
	LD	B,'$'		;fetch entry length
ENTLEN	EQU	$-1
;
SWAP	LD	C,(HL)		;get first byte
	LD	A,(DE)		;get second
	LD	(HL),A		;to first
	LD	A,C		;get first
	LD	(DE),A		;to second
	INC	HL		;bump pointer
	INC	DE		;both
	DJNZ	SWAP		;go for length
	POP	BC		;restore
;
SORT3	LD	BC,(ENTLEN)	;C = entry length
	LD	HL,(BASE)	;start this pass
	LD	B,0		;BC = length
	ADD	HL,BC		;HL => next entry
	POP	BC		;restore counter
	DEC	BC		;less this pass
	LD	A,B		;any more?
	OR	C		;BC = 0000H?
	JP	NZ,SORT0	;go next loop
	XOR	A		;return Z for OK
	RET			;sorted!
;
;	compare buffers at (HL) and (DE)
;
CPAIR	PUSH	BC		;save all
	PUSH	DE
	PUSH	HL
;
;	point to keys
;
	LD	BC,0		;get key offset
KEYOFF	EQU	$-2
	ADD	HL,BC		;point to key
	EX	DE,HL		;get dest
	ADD	HL,BC		;point to key
	EX	DE,HL		;swap back
	LD	B,'$'		;get key length
KEYLEN	EQU	$-1
;
CPRLP	LD	A,(DE)		;get a byte
	CP	(HL)		;match?
	JR	NZ,CPRET	;nope, go!
	INC	DE		;bump first
	INC	HL		;bump second
	DJNZ	CPRLP		;go for key length
;
CPRET	POP	HL		;unstack 'em
	POP	DE
	POP	BC
	RET			;return with status
;
;	compute number of entries to sort
;
NUMENT	PUSH	HL		;save
	PUSH	IX		;pass start to HL
	POP	HL		;HL = start
	EX	DE,HL		;DE => start
	OR	A		;clear carry
	SBC	HL,DE		;HL = # bytes to sort
	PUSH	BC		;save from math
	LD	B,0		;BHL=#bytes, C=entry len.
	CALL	@DIVID		;divide BHL/C
	POP	BC		;restore BC
	EX	DE,HL		;DE = # entries
	POP	HL		;restore HL
	INC	DE		;DE = # entries
	RET			;done!
;
;	setup for sort parameters
;
SETSORT	CALL	PARSORT		;check valid
	OR	A		;error code?
	RET	NZ		;if error!
;
	LD	A,L		;search key length
	LD	(KEYLEN),A	;save it
	LD	A,38H		;JR C opcode
	INC	H		;H = 0?
	DEC	H
	JR	Z,$+4		;go if yes
	LD	A,30H		;JR NC opcode
	LD	(SRTDIR),A	;save direction
	PUSH	IX		;pass start to HL
	POP	HL		;HL => first entry
	LD	A,B		;get key offset
	LD	(KEYOFF),A	;save it
	LD	A,C		;get entry length
	LD	(ENTLEN),A	;save it
	LD	B,D		;pass # entries to BC
	LD	C,E
	XOR	A		;set NO error
	RET			;return OK
;
;	check for valid parameters
;
PARSORT	LD	A,L		;sort field length
	OR	A		;0?
	LD	A,-1		;set error
	RET	Z		;invalid!
;
	LD	A,C		;entry length
	OR	A		;0?
	LD	A,-1		;set error
	RET	Z		;invalid!
;
	LD	A,B		;key position
	CP	C		;entry length
	LD	A,-1		;set error
	RET	NC		;invalid!
;
	LD	A,L		;sort length
	ADD	A,B		;key offset
	DEC	A		;adjust for compare
	CP	C		;key off+len < ent leng.
	LD	A,-1		;set error
	RET	NC		;invalid!
;
	LD	A,D		;see if nil length
	OR	E		;any entries?
	LD	A,-1		;set error
	RET	Z		;nothing to sort!
	XOR	A		;all OK
	RET			;done!
;
	PAGE
;
;	$ERRMON	- error monitor
;
;	ENT	A = error code
;
;	EXIT	C  = QUIT selected (or <BREAK>)
;		Z  = SKIP selected
;		NZ = RETRY selected
;		all registers preserved
;
;	EXAMPLE:
;
;RETRY1	CALL	@READ		;read sector
;	CALL	@ERRMON		;call error monitor
;	JP	C,@EXIT		;QUIT selected
;	JR	NZ,RETRY1	;go if RETRY select
;	will get here if NO ERROR, or SKIP selected
;
@ERRMON	SCF			;clear carry flag
	CCF
	RET	Z		;no error, return!
	CALL	@ERROR		;display error message
	CALL	@SAVREG		;save registers
;
ERRASK	LD	HL,ERRMSG	;prompt text
	LD	DE,STRING	;input buffer
	LD	B,1		;single key input
	CALL	@VIDKEY		;display/keyboard
	RET	C		;<BREAK> = QUIT!
	DEC	B		;any keys?
	RET	NZ		;no keys = RETRY
	LD	A,(HL)		;get input key
	CALL	@UCASE		;make upper case
	CP	'Q'		;quit?
	SCF			;carry = yes
	RET	Z		;yes, go!
	CP	'S'		;skip?
	RET	Z		;yes, go!
	CP	'R'		;retry?
	JR	NZ,ERRASK	;invalid, ask again
	OR	-1		;NC/NZ
	RET			;retry!
;
ERRMSG	DEFM	'(R)etry, (S)kip or (Q)uit ? '
	DEFB	3
STRING	DEFB	3,3
;
ZZZZZ	EQU	$
;
