; work2 - kjw/bqsd - dallas, texas
;
; created 02/24/83 - kjw
; revised 03/04/83 - kjw
;
	TITLE	'<WORK2/ASM>'
	SUBTTL	'<by Kim Watt - (c)(p) 1983 Breeze/QSD, Inc. - Dallas, Texas>'
;
;	Mod I/III/MAX LDOS size is 399 bytes
;	Mod I/III DOSPLUS  size is 380 bytes
;	Mod II/12/16  size is 407 bytes
;	LDOS SVC size is 417 bytes
;
;	contains the following subroutines
;
;	$FSPEC	- fetch filespec to DCB
;	$FEXT	- add default extension to filename
;	$OPEN	- open existing file
;	$INIT	- open/create file
;	$LOAD	- load program file
;	$RUN	- run program file
;	$CLOSE	- close file
;	$KILL	- delete file
;	$POSN	- position file to logical record
;	$READ	- read logical record
;	$WRITE	- write logical record
;	$DSIZE	- return disk size parameters
;	$DCHECK	- check drive for ready/write protect
;	$HOME	- home drive to track 0
;	$SEEK	- move head to specific cylinder
;	$RDSEC	- read disk data sector
;	$WRSEC	- write disk data sector
;	$RDDIR	- read disk directory sector
;	$WRDIR	- write disk directory sector
;	$WRDAM	- write alternate DAM to sector
;	$WRCYL	- write cylinder to disk
;
TRS13	EQU	-1		;mod I/III/MAX
TRS2	EQU	0		;mod II/12/16
LDOS	EQU	-1		;LDOS/MAX
DOSPLUS	EQU	0		;DOSPLUS 3.5
LDOSSVC	EQU	0		;LDOS supervisor calls
;
	PAGE
;
;	$FSPEC	- move/check filespec
;
;	ENT	HL => string terminated 03H/0DH
;		DE => 51 byte DCB
;
;	EXIT	NZ = A = error code
;		Z  = OK &
;		(DE)	7 - device field evaluated
;			6 - filespec field evaluated
;			5 - filespec has wild card chars
;
@FSPEC	PUSH	HL		;save string start
	PUSH	BC		;need to use
	PUSH	DE		;save DCB start
	XOR	A		;clear flags
	LD	(DE),A		;to first byte
	INC	DE		;bump pointer
	DEC	HL		;move HL back
	CALL	MOVBLK8		;move in block
	JR	NZ,CKDEV	;check for device only
	JR	NC,MBLK1	;no wild card chars
;
	EX	(SP),HL		;get first DCB byte
	SET	5,(HL)		;set wild card bit
	EX	(SP),HL		;update
;
MBLK1	EX	(SP),HL		;get DCB byte
	SET	6,(HL)		;set contains file
	EX	(SP),HL		;swap back
;
	CP	'/'		;extension?
	JR	NZ,FSPEC1	;go if not
	LD	(DE),A		;to buffer
	INC	DE		;bump pointer
	LD	B,3		;3 char extension
	CALL	MOVBLK-1	;move it in
	JR	NZ,FSPCER	;go if invalid!
	JR	NC,FSPEC1	;go if not
	EX	(SP),HL		;get flags back
	SET	5,(HL)		;set WILD bit
	EX	(SP),HL		;swap back
;
FSPEC1	CP	'.'		;password?
	JR	NZ,FSPEC2	;go if not
	LD	(DE),A		;char to buffer
	INC	DE		;bump pointer
	CALL	MOVBLK8		;move it in!
	JR	NZ,FSPCER	;go if invalid!
	JR	C,FSPCER	;go if wild card chars!
;
FSPEC2	CP	':'		;drive #?
	JR	NZ,FSPEC3	;nope, terminate
;
;	check for wild card chars & device
;
FSPEC4	EX	(SP),HL		;get flags
	BIT	5,(HL)		;wild here?
	EX	(SP),HL		;swap back
	JR	NZ,FSPEC3	;terminate now if yes
;
	LD	(DE),A		;move into string
	INC	DE		;bump pointer
	LD	B,2		;up to 2 chars in drive
	CALL	MOVBLK-1	;move it in!
	JR	NZ,FSPCER	;go if error!
;
FSPEC3	LD	A,3		;end of text
	LD	(DE),A		;to string
	POP	DE		;DCB start
	POP	BC		;restore BC
	POP	AF		;dummy pop HL start
	XOR	A		;set NO error
	RET			;done!
;
FSPCER	LD	A,19		;'illegal filename'
	POP	DE		;restore DCB start
	POP	BC		;restore
	POP	HL		;original string start
	OR	A		;set NZ for error
	RET			;done!
;
;	check for DEVICE specification
;
CKDEV	CP	':'		;drive only?
	JR	Z,FSPEC4	;go if yes
	CP	'@'		;device?
	JR	Z,FSPEC4	;go if yes
	JR	FSPCER		;go if none of above!
;
MOVBLK8	LD	B,8		;go for 8 chars
;
	INC	HL		;bump string pointer
MOVBLK	LD	A,-1		;set ERROR
	OR	A		;set flags
	EX	AF,AF'		;save flags
;
MOVBLK1	LD	A,(HL)		;get string char
	CALL	VALCHR		;valid character?
	JR	Z,MOVBLK5	;go if invalid!
	INC	HL		;bump pointer
;
	CP	'?'		;wild?
	JR	Z,MOVBLK2	;go if yes!
	CP	'!'		;wild?
	JR	Z,MOVBLK2	;go if yes!
	CP	'$'		;wild?
	JR	NZ,MOVBLK3	;go if neither
;
MOVBLK2	EX	AF,AF'		;get flags
	SCF			;carry = wild chars
	EX	AF,AF'		;swap back
;
MOVBLK3	LD	(DE),A		;to dcb
	INC	DE		;bump pointer
	EX	AF,AF'		;get flags back
	LD	A,0		;load zero
	INC	A		;set Z flag but do not
	DEC	A		;affect carry flag
	EX	AF,AF'		;save in A'
	DJNZ	MOVBLK1		;continue for length
;
MOVBLK5	EX	AF,AF'		;get flags back
	LD	A,(HL)		;return with next char
	RET			;done!
;
VALCHR	PUSH	BC		;save
	PUSH	HL		;save
	LD	HL,CHARTBL	;invalid char table
	LD	BC,CHARLEN	;length of table
	CPIR			;find it!
	POP	HL		;restore
	POP	BC		;restore
	RET			;Z = invalid char!
;
CHARTBL	DEFB	'('
	DEFB	')'
	DEFB	','
	DEFB	'.'
	DEFB	'/'
	DEFB	';'
	DEFB	' '
	DEFB	':'
	DEFB	'@'
	DEFB	'='
	DEFB	'"'
	DEFB	27H
	DEFB	03H
	DEFB	0DH
	DEFB	7BH
	DEFB	7DH
CHARLEN	EQU	$-CHARTBL
;
	PAGE
;
;	$FEXT	- add default file extension
;
;	ENT	DE => normalized filespec
;		HL => extension (3 chars padded)
;
;	EXIT	Z  = no extension added (one exists)
;		NZ = extension added
;
@FEXT	CALL	@REGSAV		;save registers
	LD	B,9		;max chars to check
	EX	DE,HL		;HL => dcb
;
FEXTLP	LD	A,(HL)		;get a char
	CP	'/'		;extension now?
	JR	Z,FEXTRET	;yes, go!
	CALL	VALCHR		;valid character?
	JR	Z,FEXTADD	;nope, add extension
	INC	HL		;bump pointer
	DJNZ	FEXTLP		;go for 9 chars
FEXTRET	XOR	A		;return Z not added
	RET			;done!
;
FEXTADD	PUSH	DE		;save extension start
	LD	BC,3<8+1	;max chars + length
FEXTLEN	LD	A,(DE)		;get a char
	CP	' '		;blank?
	JR	Z,FEXTHAV	;yes, have length
	INC	C		;bump length
	INC	DE		;bump pointer
	DJNZ	FEXTLEN		;go for max length
FEXTHAV	LD	A,C		;get max length
	LD	BC,24		;max length ext+term
	ADD	HL,BC		;point to end
	LD	D,H		;pass to DE
	LD	E,L		;DE => end
	INC	DE		;+1 for /
	PUSH	AF		;save counter
FEXTADJ	INC	DE		;bump pointer
	DEC	A		;less count
	JR	NZ,FEXTADJ	;adjust it
	POP	AF		;restore counter
	INC	BC		;+ terminator
	LDDR			;make a hole
	POP	HL		;get extension pointer
	LD	C,A		;pass ext length
FEXTAJ	DEC	A		;less length
	JR	Z,FEXTAD	;go if at end
	INC	HL		;bump pointer
	JR	FEXTAJ		;continue
FEXTAD	LDDR			;move in extension
	LD	A,'/'		;install header
	LD	(DE),A		;do it
	OR	-1		;set NZ for added
	RET			;done!
;
	PAGE
;
;	$OPEN	- open existing file
;
;	ENT	DE => FCB
;		HL => I/O buffer
;		A  =  LRL
;		BC => blocking buffer if A <> 0
;
;	EXIT	NZ = A = error code
;		Z  = OK, file/device open
;
@OPEN	EQU	$
;
	IF	TRS13
	PUSH	BC		;save
	LD	B,A		;pass LRL
	CALL	4424H		;open existing file
	POP	BC		;restore
	RET			;return status
	ENDIF
;
	IF	TRS2
	LD	(OLISTL),A	;pass LRL
	LD	(OLISTI),HL	;pass I/O buffer
	LD	(OLISTB),BC	;pass blocking buffer
	PUSH	HL		;save
	LD	HL,OLIST	;start param list
	XOR	A		;open type code
	LD	(OLISTT),A	;pass it
	LD	A,40		;SVC # open
	RST	08H		;open file
	POP	HL		;restore HL
	RET			;return with status
	ENDIF
;
	IF	LDOSSVC
	PUSH	BC		;save BC
	LD	B,A		;pass LRL
	LD	A,59		;SVC # open
	RST	28H		;open file
	POP	BC		;restore
	RET			;done!
	ENDIF
;
	PAGE
;
;	$INIT	- open/create file
;
;	ENT	DE => FCB
;		HL => I/O buffer
;		A  =  LRL
;		BC => blocking buffer if A <> 0
;
;	EXIT	NZ = A = error code
;		Z  = OK, file/device open
;		Carry = new file created
;
@INIT	EQU	$
;
	IF	TRS13
	PUSH	BC		;save
	LD	B,A		;pass LRL
	CALL	4420H		;open/create file
	POP	BC		;restore
	RET			;return with status
	ENDIF
;
	IF	TRS2
	LD	(OLISTL),A	;pass LRL
	LD	(OLISTI),HL	;pass I/O buffer
	LD	(OLISTB),BC	;pass blocking buffer
	PUSH	HL		;save
	LD	HL,OLIST	;start param list
	LD	A,2		;open/create file
	LD	(OLISTT),A	;save type
	LD	A,40		;SVC # open
	RST	08H		;open/create file
	POP	HL		;restore HL
	RET			;return with dos status
	ENDIF
;
	IF	LDOSSVC
	PUSH	BC		;save
	LD	B,A		;pass LRL
	LD	A,58		;SVC # init
	RST	28H		;open file
	POP	BC		;restore
	RET			;return with status
	ENDIF
;
;	open param list for Mod II/12/16
;
	IF	TRS2
OLIST	EQU	$
OLISTI	DEFW	0000H		;I/O buffer
OLISTB	DEFW	0000H		;blocking buffer
	DEFW	0000H		;end of file xfer address
	DEFB	'W'		;access type read/write
OLISTL	DEFB	0		;logical record length
	DEFB	'E'		;access mode extended
OLISTT	DEFB	0		;creation code
	DEFB	0		;list terminator
	ENDIF
;
	PAGE
;
;	$LOAD	- load program file
;
;	ENT	DE => filespec (closed)
;
;	EXIT	Z  = OK, program loaded
;		NZ = A = error code
;
@LOAD	EQU	$
;
	IF	TRS13
	JP	4430H		;load program
	ENDIF
;
	IF	TRS2
	LD	A,86		;SVC # load
	RST	08H		;load program
	RET			;return
	ENDIF
;
	IF	LDOSSVC
	LD	A,76		;SVC # load
	RST	28H		;load program
	RET			;return status
	ENDIF
;
	PAGE
;
;	$RUN	- run program file
;
;	ENT	DE => filespec (closed)
;
;	EXIT	NZ = A = error code
;		else program executed
;
@RUN	EQU	$
;
	IF	TRS13
	JP	4433H		;run program file
	ENDIF
;
	IF	TRS2
	LD	A,85		;SVC # run
	RST	08H		;run program file
	RET			;return if error!
	ENDIF
;
	IF	LDOSSVC
	LD	A,77		;SVC # run
	RST	28H		;run program file
	RET			;return if error!
	ENDIF
;
	PAGE
;
;	$CLOSE	- close file/device
;
;	ENT	DE => DCB
;
;	EXIT	Z  = OK
;		NZ = A = error code
;
@CLOSE	EQU	$
;
	IF	TRS13
	JP	4428H		;close file
	ENDIF
;
	IF	TRS2
	LD	A,42		;SVC # close
	RST	08H		;close file
	RET			;done!
	ENDIF
;
	IF	LDOSSVC
	LD	A,60		;SVC # close
	RST	28H		;close file
	RET			;done!
	ENDIF
;
	PAGE
;
;	$KILL	- kill existing file
;
;	ENT	DE => DCB (open)
;
;	EXIT	Z  = OK
;		NZ = A = error code
;
@KILL	EQU	$
;
	IF	TRS13
	JP	442CH		;kill file
	ENDIF
;
	IF	TRS2
	LD	A,41		;SVC # kill
	RST	08H		;kill file
	RET			;return status
	ENDIF
;
	IF	LDOSSVC
	LD	A,57		;SVC # kill
	RST	28H		;kill file
	RET			;return status
	ENDIF
;
	PAGE
;
;	$POSN	- position file to logical record
;
;	ENT	DE => open FCB/DCB
;		BC => 3 byte record # (msb,nsb,lsb)
;
;	EXIT	Z  = OK
;		NZ = A = error code
;
@POSN	EQU	$
;
	IF	TRS13
	PUSH	BC		;save pointer
	PUSH	HL		;save for use
	LD	H,B		;pass BC => HL
	LD	L,C		;HL => record
	INC	HL		;bump it
	LD	B,(HL)		;get NSB
	INC	HL		;bump it
	LD	C,(HL)		;get LSB
	POP	HL		;restore
	CALL	4442H		;position to record
	POP	BC		;restore
	RET			;done!
	ENDIF
;
	IF	TRS2
	LD	A,79		;SVC # posn
	RST	08H		;position to record
	RET			;return status
	ENDIF
;
	IF	LDOSSVC
	PUSH	BC		;save it
	PUSH	HL		;save it
	LD	H,B		;pass rec # to HL
	LD	L,C		;HL => 3 byte record
	INC	HL		;ignore MSB
	LD	B,(HL)		;get NSB
	INC	HL		;bump pointer
	LD	C,(HL)		;get LSB
	POP	HL		;restore
	LD	A,66		;SVC # posn
	RST	28H		;position file
	POP	BC		;restore BC
	RET			;done, return status
	ENDIF
;
	PAGE
;
;	$READ	- read next logical record
;
;	ENT	DE => open FCB/DCB
;
;	EXIT	Z  = OK, buffer loaded
;		NZ = A = error code
;
;	NOTE	mod I/III/MAX
;			if opened with LRL <> 0 then
;			HL => record buffer on entry
;		mod II/12/16
;			if opened with LRL <> 0 then
;			blocking buffer is loaded
;
@READ	EQU	$
;
	IF	TRS13
	JP	4436H		;read record!
	ENDIF
;
	IF	TRS2
	LD	A,34		;SVC # readnx
	RST	08H		;read record!
	RET			;return with status
	ENDIF
;
	IF	LDOSSVC
	LD	A,67		;SVC # read
	RST	28H		;read record
	RET			;return status
	ENDIF
;
	PAGE
;
;	$WRITE	- write next logical record
;
;	ENT	DE => open FCB/DCB
;
;	EXIT	Z  = OK
;		NZ = A = error code
;
;	NOTE	mod I/III/MAX/LDOSSVC
;			if file opened with LRL <> 0 then
;			HL => user buffer on entry
;		mod II/12/16
;			if file opened with LRL <> 0 then
;			data must be placed into blocker
;
@WRITE	EQU	$
;
	IF	TRS13
	JP	4439H		;write next record
	ENDIF
;
	IF	TRS2
	LD	A,43		;SVC # writnx
	RST	08H		;write next record!
	RET			;return with status
	ENDIF
;
	IF	LDOSSVC
	LD	A,75		;SVC # write
	RST	28H		;write record
	RET			;return status
	ENDIF
;
	PAGE
;
;	$DSIZE	- fetch disk size parameters
;
;	ENT	C  = drive # to load
;
;	EXIT	NZ = A = error code
;		Z  = OK &
;		B  = directory cylinder
;		C  = cylinder count
;		D  = sectors / gran
;		E  = grans / cylinder
;		H  = highest sector
;		L  = lowest sector
;
@DSIZE	EQU	$
;
	IF	TRS13.AND.LDOS.OR.LDOSSVC
	PUSH	IY		;save it
	CALL	478FH		;locate DCT address
	LD	B,(IY+9)	;dir track
	LD	C,(IY+6)	;highest cylinder
	INC	C		;# cylinders
	BIT	3,(IY+3)	;rigid?
	JR	Z,DSIZE1	;go if not
	BIT	5,(IY+4)	;double cyl count?
	JR	Z,DSIZE1	;go if not
	SLA	C		;double cyl count
DSIZE1	LD	A,(IY+8)	;DCT data
	AND	1FH		;low 5 bits
	INC	A		;adjust to actual
	LD	D,A		;sectors / gran
	LD	A,(IY+8)	;DCT data
	RLCA			;move bits 7-5 => 2-0
	RLCA
	RLCA
	AND	7		;low 3 bits only
	INC	A		;adjust to actual
	BIT	3,(IY+3)	;rigid drive?
	JR	NZ,DSIZE2	;go if yes
	BIT	5,(IY+4)	;2 sided?
	JR	Z,DSIZE2	;go if not
	ADD	A,A		;double it
DSIZE2	LD	E,A		;grans / cylinder
	LD	A,(IY+7)	;DCT data
	AND	1FH		;low 5 bits only
	LD	H,A		;highest sector #
	POP	IY		;restore stack
	XOR	A		;return Z
	LD	L,A		;lowest sector #
	RET			;done!
	ENDIF
;
	IF	TRS13.AND.DOSPLUS
	PUSH	IY		;save it
	CALL	@MODEL		;mod I/III?
	DEC	C		;mod I?
	LD	BC,448BH	;vector Mod I
	JR	Z,$+5		;go if yes
	LD	BC,44A3H	;vector Mod III
	LD	(DSIZV),BC	;save vector
	CALL	$		;locate DCT
DSIZV	EQU	$-2
	LD	B,(IY+18)	;get dir cylinder
	LD	C,(IY+19)	;get cylinder count
	LD	D,(IY+15)	;get sectors / gran
	LD	E,(IY+16)	;get grans / cylinder
	LD	H,(IY+17)	;get sects / cylinder
	DEC	H		;highest sector #
	POP	IY		;restore stack
	XOR	A		;return Z
	LD	L,A		;lowest sector #
	RET			;done!
	ENDIF
;
	IF	TRS2
	PUSH	IY		;save it
	CALL	032DH		;locate DCT address
	LD	B,(IY+18)	;dir cylinder
	LD	C,(IY+15)	;cylinder count
	LD	D,(IY+19)	;sectors / gran
	LD	E,(IY+20)	;grans / cylinder
	LD	H,(IY+21)	;sectors / cylinder
	DEC	H		;highest sector
	POP	IY		;restore stack
	XOR	A		;return Z
	LD	L,A		;lowest sector #
	RET			;done!
	ENDIF
;
	PAGE
;
;	$DCHECK	- check if drive ready
;
;	ENT	C  = drive #
;
;	EXIT	Z  = OK
;		NZ = A = error code
;		Carry = write protected
;
@DCHECK	EQU	$
;
	IF	TRS13.AND.LDOS
	PUSH	BC		;save
	CALL	@MODEL		;get model #
	DEC	C		;mod I?
	LD	BC,44B8H	;chkdrv I
	JR	Z,$+5		;go if mod I
	LD	BC,4209H	;chkdrv III
	LD	(CHKCAL),BC	;save call vector
	POP	BC		;restore BC
	JP	$		;check drive
CHKCAL	EQU	$-2
	ENDIF
;
	IF	TRS13.AND.DOSPLUS
	XOR	A		;command 0
	JR	DOSPDSK		;go common I/O
	ENDIF
;
	IF	TRS2
	XOR	A		;command 0
	RST	10H		;execute disk command
	RET			;done!
	ENDIF
;
	IF	LDOSSVC
	LD	A,33		;SVC # ckdrv
	RST	28H		;check drive
	RET			;return status
	ENDIF
;
	PAGE
;
;	$HOME	- home drive to track 0
;
;	ENT	C  = drive #
;
;	EXIT	Z  = OK
;		NZ = A = error code
;
@HOME	EQU	$
;
	IF	TRS13.AND.LDOS.OR.LDOSSVC
	PUSH	DE		;save
	LD	D,0		;track 0
	CALL	@SEEK		;seek it
	POP	DE		;restore
	RET			;return with status
	ENDIF
;
	IF	TRS13.AND.DOSPLUS
	LD	A,1		;command #
	JR	DOSPDSK		;go common
	ENDIF
;
	IF	TRS2
	LD	A,1		;command #
	RST	10H		;go disk command
	RET			;return with status
	ENDIF
;
	PAGE
;
;	$SEEK	- move head to desired track
;
;	ENT	C  = drive #
;		D  = cylinder
;
;	EXIT	Z  = OK
;		NZ = A = error code
;
@SEEK	EQU	$
;
	IF	TRS13.AND.LDOS
	JP	475EH		;seek track
	ENDIF
;
	IF	TRS13.AND.DOSPLUS
	LD	A,2		;command #
	JR	DOSPDSK		;go common
	ENDIF
;
	IF	TRS2
	LD	A,2		;command #
	PUSH	BC		;save
	LD	B,0		;MSB sector #
	RST	10H		;seek track
	POP	BC		;restore
	RET			;return status
	ENDIF
;
	IF	LDOSSVC
	LD	A,46		;SVC # seek
	RST	28H		;seek track
	RET			;return status
	ENDIF
;
	PAGE
;
;	$RDSEC	- read disk data sector
;
;	ENT	C  = drive #
;		D  = cylinder
;		E  = sector
;		HL => I/O buffer
;
;	EXIT	Z  = OK
;		NZ = A = error code
;
@RDSEC	EQU	$
;
	IF	TRS13.AND.LDOS
	JP	4777H		;read data sector
	ENDIF
;
	IF	TRS13.AND.DOSPLUS
	LD	A,3		;command #
	JR	DOSPDSK		;go common
	ENDIF
;
	IF	TRS2
	LD	A,3		;command #
	PUSH	BC		;save
	LD	B,0		;MSB sector #
	RST	10H		;disk I/O
	POP	BC		;restore
	RET			;return status
	ENDIF
;
	IF	LDOSSVC
	LD	A,49		;SVC # rdsect
	RST	28H		;read sector
	RET			;return status
	ENDIF
;
	PAGE
;
;	$WRSEC	- write disk data sector
;
;	ENT	C  = drive #
;		D  = cylinder
;		E  = sector
;		HL => I/O buffer
;
;	EXIT	Z  = OK
;		NZ = A = error code
;
@WRSEC	EQU	$
;
	IF	TRS13.AND.LDOS
	JP	4763H		;write sector
	ENDIF
;
	IF	TRS13.AND.DOSPLUS
	LD	A,5		;command #
	JR	DOSPDSK		;go common
	ENDIF
;
	IF	TRS2
	LD	A,5		;command #
	PUSH	BC		;save
	LD	B,0		;MSB sector #
	RST	10H		;disk I/O
	POP	BC		;restore
	RET			;return status
	ENDIF
;
	IF	LDOSSVC
	LD	A,53		;SVC # wrsect
	RST	28H		;write sector
	RET			;return status
	ENDIF
;
	PAGE
;
;	$RDDIR	- read disk directory sector
;
;	ENT	C  = drive #
;		E  = sector #
;		HL => I/O buffer
;
;	EXIT	Z  = OK
;		NZ = A = error code
;
@RDDIR	EQU	$
;
	IF	TRS13.AND.LDOS
	JP	4B45H		;read directory
	ENDIF
;
	IF	TRS13.AND.DOSPLUS
	LD	A,6		;command #
	JR	DOSPDSK		;go common I/O
	ENDIF
;
	IF	TRS2
	LD	A,6		;command #
	PUSH	BC		;save
	LD	B,0		;MSB sector #
	RST	10H		;read it!
	POP	BC		;restore
	RET			;return status
	ENDIF
;
	IF	LDOSSVC
	PUSH	BC		;save
	PUSH	DE		;save
	PUSH	HL		;save
	CALL	@DSIZE		;fetch disk params
	LD	A,B		;get dir cylinder
	POP	HL		;get buffer
	POP	DE		;get sector
	POP	BC		;get drive
	LD	D,A		;pass dir track
	CALL	@RDSEC		;read sector
	CP	6		;sys sector?
	RET			;return with status
	ENDIF
;
	PAGE
;
;	$WRDIR	- write directory sector
;
;	ENT	C  = drive #
;		E  = sector #
;		HL => I/O buffer
;
;	EXIT	Z  = OK
;		NZ = A = error code
;
@WRDIR	EQU	$
;
	IF	TRS13.AND.LDOS
	JP	4763H		;write sys sector
	ENDIF
;
	IF	TRS13.AND.DOSPLUS
	LD	A,7		;command #
	JR	DOSPDSK		;go common
	ENDIF
;
	IF	TRS2
	LD	A,7		;command #
	PUSH	BC		;save
	LD	B,0		;MSB sector #
	RST	10H		;write
	POP	BC		;restore
	RET			;return with status
	ENDIF
;
	IF	LDOSSVC
	PUSH	BC		;save
	PUSH	DE		;save
	PUSH	HL		;save
	CALL	@DSIZE		;get dir track
	LD	A,B		;A = dir
	POP	HL		;get buffer
	POP	DE		;get sector
	POP	BC		;get drive
	LD	D,A		;pass dir track
	JR	@WRDAM		;write protected
	ENDIF
;
	PAGE
;
;	$WRDAM	- write sector with address marks
;
;	ENT	C  = drive #
;		D  = cylinder
;		E  = sector
;		HL => I/O buffer
;
;	EXIT	Z  = OK
;		NZ = A = error code
;
@WRDAM	EQU	$
;
	IF	TRS13.AND.LDOS
	JP	4768H		;write with A/M
	ENDIF
;
	IF	TRS13.AND.DOSPLUS
	LD	A,8		;command #
	JR	DOSPDSK		;go common I/O
	ENDIF
;
	IF	TRS2
	LD	A,9		;command #
	PUSH	BC		;save
	LD	B,0		;MSB sector #
	RST	10H		;write
	POP	BC		;restore
	RET			;return status
	ENDIF
;
	IF	LDOSSVC
	LD	A,54		;SVC # wrprot
	RST	28H		;write the sector
	RET			;return with status
	ENDIF
;
	PAGE
;
;	$WRCYL	- format cylinder
;
;	ENT	C  = drive #
;		D  = cylinder
;		E  = sector
;		HL => I/O buffer
;
;	EXIT	Z  = OK
;		NZ = A = error code
;
@WRCYL	EQU	$
;
	IF	TRS13.AND.LDOS
	JP	476DH		;write cylinder
	ENDIF
;
	IF	TRS13.AND.DOSPLUS
	LD	A,9		;command #
	JR	DOSPDSK		;go common I/O
	ENDIF
;
	IF	TRS2
	LD	A,8		;command #
	RST	10H		;write cylinder
	RET			;return status
	ENDIF
;
	IF	LDOSSVC
	LD	A,55		;SVC # wrtrak
	RST	28H		;write cylinder
	RET			;return status
	ENDIF
;
;	dosplus common disk I/O
;
	IF	TRS13.AND.DOSPLUS
DOSPDSK	PUSH	BC		;save BC
	CALL	@MODEL		;get mod I/III
	DEC	C		;mod I?
	LD	BC,4485H	;vector Mod I
	JR	Z,$+5		;go if I
	LD	BC,4488H	;vector Mod III
	LD	(DSKCAL),BC	;save vector
	POP	BC		;restore
	JP	$		;go disk I/O
DSKCAL	EQU	$-2
	ENDIF
;
ZZZZZ	EQU	$
;
