; pmoda/asm - kjw/bqsd - 06/82 - version 3.0 - 03/83
;
; created 06/82 - kjw
; revised 04/15/83 - kjw
;
ENTRY	CALL	@SETUP		;setup for return
RENTRY	PUSH	HL		;save command pointer
	CALL	@CLS		;clear video
	LD	HL,HELLO	;sign on message
	CALL	@VDLINE		;display it
	POP	HL		;restore input pointer
	JR	SCAN		;scan input
;
;	restart program
;
RESTART	LD	SP,(STACK)	;reset stack
	LD	HL,STRING	;internal string buff
	LD	(HL),CR		;set as nil command
	JR	RENTRY		;continue
;
;	evaluate input params
;
SCAN	CALL	@POSHL		;find next character
	JP	Z,ASKPARM	;ask for parameters
	CP	':'		;drive #?
	JR	Z,ZAPDRV	;yes, go!
	CP	'!'		;file force?
	JR	Z,ZAPFIL-1	;yes, go!
;
;	not disk or file, check if address value supplied
;
	PUSH	HL		;save input pointer
	CALL	@VALUE		;fetch input value
	POP	HL		;restore input
	JR	NZ,ZAPFIL	;invalid, get file
	LD	(ADDRESS),DE	;save NSB/LSB address
	LD	A,1		;set type of modify
	LD	(TYPE),A	;pass it
	JP	CONT1		;continue!
;
;	zapping disk sector direct
;
ZAPDRV	INC	HL		;bump past :
	LD	A,(HL)		;get next char
	SUB	'0'		;remove ascii
	JP	C,ILLDRV	;go if invalid drive
	CP	8		;0-7?
	JP	NC,ILLDRV	;go if out of range
	LD	(DRIVE),A	;save drive #
	LD	C,A		;pass drive #
	CALL	@DCHECK		;drive ready?
	JP	NZ,ERROR	;go if not ready
	INC	HL		;bump input pointer
	XOR	A		;load zero
	LD	(TRACK),A	;track #
	LD	(SECTOR),A	;sector #
	CALL	@POSHL		;any more input?
	JR	Z,ZAPDGO	;nope, use default
ZAPTRK	CP	'@'		;directory track?
	JR	NZ,GOTTRK	;nope, go!
	PUSH	HL		;save input pointer
	CALL	@DSIZE		;get dir track
	LD	A,B		;get dir track
	POP	HL		;restore pointer
	INC	HL		;bump past char
	JR	CONTRK		;install track #
;
GOTTRK	CALL	@VALUE		;fetch track #
	JP	NZ,PARERR	;go param error!
	LD	A,E		;get LSB value
CONTRK	LD	(TRACK),A	;save requested track
	CALL	@POSHL		;any more input?
	JR	Z,ZAPDGO	;go if nil!
	CALL	@VALUE		;get sector #
	JR	NZ,PARERR	;go if invalid number
	LD	A,E		;get LSB value
	LD	(SECTOR),A	;save sector #
ZAPDGO	LD	A,2		;type of modify
	LD	(TYPE),A	;pass it
	JP	CONT2		;continue!
;
;	new file relative sector requested
;
NEWFILE	CALL	@CLS		;clear video
	LD	HL,FILMSG	;prompt text
	LD	B,31		;31 char input
	LD	DE,STRING	;key input buffer
	CALL	@VIDKEY		;display and key input
	JP	C,EXIT		;go on BREAK
	CALL	@POSHL		;any input?
	JP	Z,RESTART	;yes, restart program
	JR	INTFIL		;interrogate file sector
;
;	zapping disk file sector
;
	INC	HL		;bump input past !
ZAPFIL	LD	DE,$FCB-1	;file control block
	CALL	@FSPEC		;evaluate filespec
	JR	NZ,ERROR	;go if invalid!
;
;	save ascii filespec for display
;
	PUSH	HL		;save string pointer
	EX	DE,HL		;HL => stored filespec
	LD	DE,FILNAME	;store text here
	LD	BC,30		;max length
	LDIR			;save it!
;
;	open file to see if it exists
;
	LD	DE,$FCB		;start of FCB
	LD	HL,$BUFFER	;I/O buffer
	LD	(ADDRESS),HL	;save display buffer
	XOR	A		;LRL
	CALL	@OPEN		;open existing file!
	POP	HL		;restore input pointer
	JR	NZ,ERROR	;go if error!
	LD	A,3		;type of modify
	LD	(TYPE),A	;pass it
;
;	check if relative sector supplied
;
INTFIL	LD	BC,0		;init sector #
	LD	(POSIT),BC	;set MSB/NSB to 0
	LD	(POSIT+1),BC	;init NSB/LSB to 0
	CALL	@POSHL		;any more input?
	JP	Z,CONT3		;go if no more!
	CALL	@VALUE		;get relative sector
	JR	NZ,PARERR	;go if invalid numeric
	LD	HL,POSIT	;stored sector #
	LD	(HL),C		;load MSB
	INC	HL		;bump
	LD	(HL),D		;load NSB
	INC	HL		;bump
	LD	(HL),E		;load LSB
	JP	CONT3		;continue!
;
;	illegal drive #
;
ILLDRV	LD	A,32		;'illegal drive #'
ERROR	CALL	@ERROR		;display error message
	JR	ASKPARM		;prompt for parameters
;
;	parameter error
;
PARERR	LD	HL,PARMSG	;'param error'
	CALL	@VDLINE		;display it
;
;	prompt user for input parameters
;
ASKPARM	LD	HL,DRVMSG	;'parameters?'
	LD	B,31		;31 char input
	LD	DE,STRING	;input buffer
	CALL	@VIDKEY		;display & get input
	JR	C,EXIT		;go on <BREAK>
	CALL	@POSHL		;any input?
	JP	NZ,SCAN		;input, evaluate it!
;
;	<ENTER> alone pressed, display HELP text
;
	LD	HL,HELP1	;help text
	CALL	@VDLINE		;display to video
	JR	ASKPARM		;re-prompt again
;
;	program exit vector
;
EXIT	CALL	@CLS		;clear video
	LD	HL,EXMSG	;'exiting'
	CALL	@VDLINE		;display it
	JP	@EXIT		;exit program to DOS
;
;	error monitors
;
BADWRT	PUSH	HL		;save HL
	LD	HL,BADWMSG	;bad write message
	JR	DOBAD		;go common
;
BADRD	PUSH	HL		;save HL
	LD	HL,BADRMSG	;bad read message
;
DOBAD	SCF			;clear carry
	CCF
	JR	Z,BADRET	;go if no error!
	PUSH	AF		;save error code
	CALL	@CLS		;clear video
	CALL	@VDLINE		;display error text
	POP	AF		;get error back
	CALL	@ERRMON		;go error monitor
	PUSH	AF		;save response
	CALL	@CLS		;clear video again
	POP	AF		;get response
BADRET	POP	HL		;unstack
	RET			;done!
;
;	advance DE to next logical sector
;
NEXSEC	PUSH	BC		;save
	CALL	HISEC		;B=high track/C=high sect
	LD	A,C		;get high sector
	SUB	E		;less sector #
	JR	NZ,NEXSBA	;not at end, go!
	LD	E,A		;E = 0, start sector
	LD	A,D		;get track
	CP	B		;at highest track?
	JR	Z,NEXSBK	;yes, cannot inc it
	INC	D		;bump track
	DEC	E		;adjust for inc
NEXSBA	INC	E		;bump sector
NEXSBK	POP	BC		;restore BC
	RET			;DE = next sector
;
;	move DE to previous logical sector
;
BAKSEC	LD	A,E		;get sector #
	OR	A		;at sector 0?
	JR	Z,BADEND	;yes, move back a track
	DEC	E		;else dec sector #
	RET			;done!
;
BADEND	LD	A,D		;get track
	OR	A		;on track 0?
	RET	Z		;yes, do not move!
	PUSH	BC		;save
	CALL	HISEC		;get highest sector
	LD	E,C		;E = highest sector
	DEC	D		;move track back
	POP	BC		;restore
	RET
;
;	memory modify vector
;
CONT1	LD	HL,DISRETM	;update vector
	LD	(VECTOR1),HL	;UPDATE vector
	LD	(VECTOR2),HL	;CANCEL vector
	LD	HL,DISMCN1	;continue
	LD	(VECTOR3),HL	;for base change
;
DISRETM	CALL	@CLS		;clear video
DISMCON	CALL	SHOW		;display buffer data
DISMCN1	CALL	SHOWLF		;display data source
	CALL	@VSIZE		;get video start
	LD	B,H		;pass video to BC
	LD	C,L		;BC => video memory
	LD	HL,SPACES	;3 spaces
	LD	DE,3		;3 bytes to move
	LD	A,3		;command #
	CALL	@VIDRAM		;move to video
;
DISMCN2	CALL	@VSIZE		;get start video memory
	LD	A,RATE		;flash counter
;
	IF	TRS13.OR.LDOSSVC
	LD	BC,20B0H	;on/off display bytes
	ENDIF
	IF	TRS2
	LD	BC,2019H	;on/off display bytes
	ENDIF
;
	CALL	FLICKS		;special input routine
	PUSH	AF		;save input key
	CALL	@UCASE		;make upper case
	CP	' '		;control byte?
	JR	NC,$+4		;go if not
	LD	A,BLOCK		;invalid char
	CALL	@VPOKE		;to video
	POP	AF		;restore char
	LD	HL,DISMTBL	;jump table
	CALL	@LOOKUP		;in table?
	JR	NZ,DISMCN2	;nope, get another key
	LD	BC,(ADDRESS)	;get address of display
	LD	DE,DISMRET	;return vector
	PUSH	DE		;leave on stack
	JP	(HL)		;go vector!
;
DISMRET	LD	(ADDRESS),BC	;update new address
	JR	DISMCON		;re-display new data
;
DISMTBL	DEFB	UARR		;up arrow
	DEFW	DMEMUP
	DEFB	DARR		;down arrow
	DEFW	DMEMDP
	DEFB	LARR		;left arrow
	DEFW	DMEMD
	DEFB	RARR		;right arrow
	DEFW	DMEMU
	DEFB	SLARR		;shift left
	DEFW	DMEMDP
	DEFB	SRARR		;shift right
	DEFW	DMEMUP
	DEFB	SDARR		;shift down
	DEFW	DMEMB
	DEFB	SUARR		;shift up
	DEFW	DMEMT
	DEFB	'A'		;ascii modify
	DEFW	ASCIT
	DEFB	'B'		;binary modify
	DEFW	BINIT
	DEFB	'D'		;decimal mode
	DEFW	DECIT
	DEFB	'H'		;hex modify
	DEFW	HEXIT
	DEFB	'O'		;octal modify
	DEFW	OCTIT
	DEFB	'Q'
	DEFW	OCTIT
	DEFB	'M'		;modify mode
	DEFW	MODIFY
	DEFB	CLEAR		;clear key
	DEFW	NEWMEM
	DEFB	BREAK		;restart?
	DEFW	RESTART
	DEFB	ETBL		;end of table
;
DMEMU	INC	BC		;mem +1
	RET			;done
;
DMEMD	DEC	BC		;mem -1
	RET			;done
;
DMEMUP	INC	B		;mem +256
	RET			;done
;
DMEMT	CALL	@HIMEM		;get high memory
	LD	B,H		;pass to BC
	LD	C,L		;BC = top free memory
	RET			;done
;
DMEMDP	DEC	B		;mem -256
	RET			;done
;
DMEMB	LD	BC,0		;first byte
	RET			;done
;
NEWMEM	CALL	@CLS		;clear video
	LD	HL,NEWADD	;prompt text
	LD	DE,STRING	;string input buff
	LD	B,31		;max input length
	CALL	@VIDKEY		;display & get key input
	JP	C,EXIT		;go on BREAK
	CALL	@POSHL		;any input?
	JP	Z,RESTART	;yes, restart program
	CALL	@VALUE		;get input value
	JR	NZ,NEWMEM	;go if invalid
	LD	B,D		;pass to BC
	LD	C,E		;BC = new address
	JP	@CLS		;clear video & return
;
;	flash cursor and fetch input key
;
FLICKS	LD	(FLK2),A	;save init flash count
	LD	A,C		;get prompt char
	CALL	@VPOKE		;to video
;
FLKRES	LD	A,'$'		;get init counter
FLK2	EQU	$-1
	LD	(FLK1),A	;set loop counter
;
FLKWT	CALL	@KBCHAR		;scan keyboard
	JR	Z,FLKDON	;have a key, go!
	LD	A,'$'		;get countdown
FLK1	EQU	$-1
	DEC	A		;less one
	LD	(FLK1),A	;update
	JR	NZ,FLKWT	;wait for flash time
;
	CALL	@VPEEK		;read video char
	CP	C		;on?
	LD	A,C		;get on byte
	JR	NZ,$+3		;go if not
	LD	A,B		;get off byte
	CALL	@VPOKE		;to video
	JR	FLKRES		;reset counter
;
FLKDON	PUSH	AF		;save input key
	LD	A,B		;get OFF byte
	CALL	@VPOKE		;to video
	POP	AF		;restore input key
	RET			;return with key
;
;	special input key subroutine
;
FLICKSP	LD	(FLICK4),A	;save reset byte
	PUSH	HL		;save from use
	LD	A,B		;get ON byte
	JR	FLICK7		;continue
;
FLKSRET	LD	A,0		;get reset count
FLICK4	EQU	$-1
	LD	(FLICK3),A	;reset counter
;
FLKSWT	CALL	@KBCHAR		;scan keyboard
	JR	Z,FLKSDON	;have one, go!
;
	LD	A,0		;get counter
FLICK3	EQU	$-1
	DEC	A		;less one
	LD	(FLICK3),A	;update count
	JR	NZ,FLKSWT	;wait if not time
;
	PUSH	IX		;pass IX => HL
	POP	HL		;HL => video
	CALL	@VPEEK		;read char
	CP	B		;match?
	LD	A,B		;get if not
	JR	NZ,FLICK7	;display
	LD	A,C		;get C
	OR	A		;C = 0?
	JR	NZ,FLICK7	;go if not 0
	CALL	MODFIX		;update originals
	JR	FLKSRET		;continue
;
FLICK7	PUSH	IX		;pass IX => HL
	POP	HL		;HL => video
	CALL	@VPOKE		;char => video
	INC	HL		;bump pointer
	CALL	@VPOKE		;char => video
	PUSH	IY		;pass IY => HL
	POP	HL		;HL => video
	CALL	@VPOKE		;char => video
	JR	FLKSRET		;continue
;
FLKSDON	PUSH	AF		;save char
	CALL	MODFIX		;restore video chars
	POP	AF		;restore key
	POP	HL		;restore pointer
	RET			;done!
;
;	restore hex/ascii chars to display
;
MODFIX	LD	A,(DE)		;get buffer byte
	PUSH	HL		;save pointer
	PUSH	BC		;save
	CALL	HEXCV		;convert to hex ascii
	PUSH	IX		;pass IX => HL
	POP	HL		;HL => video
	LD	A,B		;get MSB
	CALL	@VPOKE		;to video
	INC	HL		;bump video
	LD	A,C		;get LSB
	CALL	@VPOKE		;to video
	LD	A,(DE)		;get buffer byte
	PUSH	IY		;pass IY => HL
	POP	HL		;HL => video
	POP	BC		;restore
	CALL	@VPOKE		;write to video
	POP	HL		;restore HL
	RET			;done
;
;	display hex/ascii portions of buffer
;
SHOW	CALL	@SAVREG		;save registers
	LD	IX,0		;fetch buffer address
ADDRESS	EQU	$-2
	CALL	VCLEAR		;clear video buffer
	CALL	@VSIZE		;get video params
	LD	B,0		;BC = # columns
	LD	(SHOWOFF),BC	;save row offset
	LD	(SHOWOFG),BC	;need it twice
	LD	(SHOWOFH),BC	;need it thrice
	LD	(SHOWOFI),BC	;need it more
	LD	IY,$VBUFF+8	;start video buffer
	LD	B,16		;16 rows to create
;
SHOWLP	PUSH	BC		;save row counter
	PUSH	IY		;save video location
	PUSH	IX		;save data start
	LD	(IY-1),LVBAR	;vertical bar
	LD	L,8		;8 two byte pairs (16)
;
SHOWPL1	LD	H,2		;loop for 2 byte pair
SHOWPL	LD	A,(IX)		;get data byte
	CALL	HEXCV		;to hex ascii
	LD	(IY),B		;MSB to video buffer
	INC	IY		;bump vbuffer
	LD	(IY),C		;LSB to video buffer
	INC	IY		;bump vbuffer
	INC	IX		;bump data buffer
	DEC	H		;less pair counter
	JR	NZ,SHOWPL	;go for pair
	INC	IY		;bump vbuffer
	DEC	L		;less quad counter
	JR	NZ,SHOWPL1	;go for # quads
	POP	IX		;restore data start
	LD	B,16		;16 bytes of ascii to do
	LD	(IY-1),RVBAR	;right vertical bar
;
SHOWPP	LD	A,(IX)		;get data byte
	LD	(IY),A		;to video buffer
	INC	IY		;bump video buffer
	INC	IX		;bump data pointer
	DJNZ	SHOWPP		;go for 16 bytes
	POP	IY		;get video start back
	LD	BC,$		;get video row length
SHOWOFF	EQU	$-2
	ADD	IY,BC		;IY => next row
	POP	BC		;restore counter
	DJNZ	SHOWLP		;go next row
;
;	send video buffer to video
;
PUTVID	CALL	@VSIZE		;HL => video memory
	LD	B,H		;pass start to BC
	LD	C,L		;BC = video memory
	LD	HL,$VBUFF	;DE=length, HL=buffer
	LD	A,3		;command #
	JP	@VIDRAM		;move to video!
;
;	display data source
;
SHOWLF	CALL	@SAVREG		;save registers
	CALL	SHOMODE		;display modify base
;
	LD	BC,3		;string length
	LD	HL,MODDRV	;'DRV'
	LD	A,0		;get modify type
TYPE	EQU	$-1
	DEC	A		;from memory?
	PUSH	AF		;save on stack
	JR	NZ,$+5		;go if not from memory
	LD	HL,MODMEM	;'MEM'
	LD	E,2		;row #
	CALL	SETVID		;set DE => $VBUFF
	PUSH	BC		;save length
	LDIR			;move to buffer
	POP	BC		;restore 3
	POP	AF		;get flags
	JP	Z,SHONUMB	;display address range
;
	LD	A,(ADDRESS)	;get LSB buff address
	LD	IY,$VBUFF+5	;start video buffer
;
NBLP	PUSH	AF		;save address
	CALL	HEXCV		;to hex ascii
	LD	(IY+0),B	;MSB to video
	LD	(IY+1),C	;LSB to video
	LD	BC,$		;get video row length
SHOWOFG	EQU	$-2
	ADD	IY,BC		;IY => next row
	POP	AF		;restore offset
	ADD	A,10H		;next row offset
	JR	NZ,NBLP		;go for 16 rows
	LD	A,(TYPE)	;get type of modify
	CP	3		;file?
	JP	Z,SHOFILE	;yes, display filename
;
	LD	HL,DVMSG	;'DRV'
	LD	E,2		;video row
	CALL	SETVID		;load DE with $VBUFF
	LD	BC,3		;3 bytes to move
	LDIR			;move to buffer
	LD	E,3		;row 3
	CALL	SETVID		;DE => buffer
	INC	DE		;+1
	LD	A,0		;get drive #
DRIVE	EQU	$-1
	ADD	A,'0'		;make it ascii
	LD	(DE),A		;to video buffer
	LD	HL,CYLMSG	;'CYL'
	LD	E,4		;row #
	CALL	SETVID		;setup video address
	LD	C,3		;3 bytes
	LDIR			;to video buffer
	LD	E,5		;row 5
	CALL	SETVID		;point to vbuffer
	EX	DE,HL		;HL => video buff
	LD	A,(TRACK)	;get track
	CALL	ASCII		;to decimal ascii
	LD	(HL),A		;to video buffer
	INC	HL		;bump pointer
	LD	(HL),B		;to video buffer
	INC	HL		;bump pointer
	LD	(HL),C		;lsb to buffer
;
	LD	E,6		;row #
	CALL	SETVID		;point to video
	LD	HL,SECMSG	;'SEC'
	LD	BC,3		;text length
	LDIR			;move to buffer
	LD	E,7		;row #
	CALL	SETVID		;point to vbuffer
	EX	DE,HL		;HL => buffer
	LD	A,(SECTOR)	;get sector
	CALL	ASCII		;to decimal ascii
	LD	(HL),A		;MSB to video
	INC	HL		;bump pointer
	LD	(HL),B		;NSB to video
	INC	HL		;bump pointer
	LD	(HL),C		;LSB to video
	LD	E,10		;row #
	CALL	SETVID		;point to vbuffer
	LD	HL,RPTMSG	;read protected?
	LD	A,0		;get read type
RDTYP	EQU	$-1
	CP	6		;read protected?
	JR	Z,GOTTP		;yes, go!
	LD	HL,DELMSG	;user defined?
	CP	7		;user mark?
	JR	Z,GOTTP		;yes, go!
	LD	HL,STDMSG	;'STD'
GOTTP	LD	BC,3		;3 chars
	LDIR			;move to buffer
	JP	PUTVID		;buffer => video
;
;	locate address of row E on video
;
SETVID	PUSH	BC		;save
	PUSH	HL		;save
	PUSH	DE		;column to stack
	CALL	@VSIZE		;C = # video columns
	POP	HL		;L = desired column
	LD	H,0		;NSB = 0
	LD	B,H		;BHL = desired column
	LD	A,L		;get LSB
	OR	A		;zero?
	CALL	NZ,@MULT	;ABHL = BHL * C
	LD	DE,$VBUFF	;start video buffer
	ADD	HL,DE		;HL => video
	EX	DE,HL		;DE => video
	POP	HL		;restore stack
	POP	BC
	RET			;done!
;
;	display current filespec to video
;
SHOFILE	LD	HL,$VBUFF+4	;where to place name
	LD	DE,FILNAME+1	;stored filespec
	LD	BC,$		;get # video columns
SHOWOFH	EQU	$-2
	LD	A,16		;16 chars max
;
SHOWFL1	PUSH	AF		;save char count
	LD	A,(DE)		;get text byte
	INC	DE		;bump pointer
	CP	':'		;drive marker?
	JR	Z,SHOWFL2	;yes, go!
	CP	ETX		;end of text?
	JR	Z,SHOWFL2	;yes, done!
	CP	CR		;end of text?
	JR	Z,SHOWFL2	;yes, done!
	CP	'.'		;password?
	JR	Z,SHOWFL2	;yes, done!
	LD	(HL),A		;place in vid buffer
	ADD	HL,BC		;offset to next row
	POP	AF		;restore counter
	DEC	A		;less this char
	JR	NZ,SHOWFL1	;go for max length
	PUSH	AF		;setup for pop
SHOWFL2	POP	AF		;restore stack
	LD	E,12		;video column
	CALL	SETVID		;get video offset
	LD	HL,RELMSG	;'RSEC'
	LD	BC,4		;text length
	LDIR			;move to buffer
	LD	DE,STRING	;temp work area
	LD	IX,POSIT	;point to rel sec
	LD	B,(IX+0)	;get MSB
	LD	H,(IX+1)	;get NSB
	LD	L,(IX+2)	;get LSB
	LD	C,3		;precision
	CALL	@BINASC		;binary => ascii
	EX	DE,HL		;HL => converted string
	LD	E,13		;row #
	CALL	SETVID		;DE => video buffer
	LD	BC,4		;4 digits
	LDIR			;to video buffer
	LD	E,14		;row #
	CALL	SETVID		;DE => video buffer
	LD	C,4		;BC = 4
	LDIR			;to video buffer
	JP	PUTVID		;move buffer => video
;
;	display hex addresses for memory display
;
SHONUMB	LD	HL,(ADDRESS)	;get memory address
	LD	DE,$		;get video offset
SHOWOFI	EQU	$-2
	LD	IY,$VBUFF+3	;where to place digits
	LD	A,16		;16 rows to do
;
SHONUML	PUSH	AF		;save count
	LD	A,H		;get MSB address
	CALL	HEXCV		;to hex ascii
	LD	(IY+0),B	;MSB to video buffer
	LD	(IY+1),C	;LSB to buffer
	LD	A,L		;get LSB address
	CALL	HEXCV		;to hex ascii
	LD	(IY+2),B	;MSB to vbuff
	LD	(IY+3),C	;LSB to vbuff
	ADD	IY,DE		;point to next row
	POP	AF		;restore count
	LD	BC,10H		;offset to next address
	ADD	HL,BC		;HL = next address row
	DEC	A		;less count
	JR	NZ,SHONUML	;go for count
	JP	PUTVID		;move into video
;
;	display modify mode base
;
SHOMODE	CALL	@SAVREG		;save registers
	LD	E,1		;row #
	CALL	SETVID		;DE => video offset
	LD	A,0		;get current base
MODE	EQU	$-1
	LD	B,A		;save it
	ADD	A,A		;*2
	ADD	A,B		;*3
	LD	C,A		;C = offset
	LD	B,0		;BC = offset
	LD	HL,MODTYP	;start of table
	ADD	HL,BC		;HL => text
	LD	BC,3		;text length
	LDIR			;move to buffer
	RET			;done!
;
PUTMODE	CALL	@SAVREG		;save registers
	LD	A,(MODE)	;get mode
	LD	B,A		;save it
	ADD	A,A		;*2
	ADD	A,B		;*3
	LD	C,A		;C=offset
	LD	B,0		;BC=offset
	LD	HL,MODTYP	;lookup table
	ADD	HL,BC		;HL => 3 chars text
;
	PUSH	HL		;save text
	CALL	@VSIZE		;get video size
	LD	B,0		;BC = # cols
	ADD	HL,BC		;HL => row 1
	LD	B,H		;pass to BC
	LD	C,L		;BC => video
	POP	HL		;HL => text
	LD	DE,3		;3 chars to display
	LD	A,E		;get command #
	JP	@VIDRAM		;move to video
;
MODTYP	DEFM	'HEXDECBINOCTASC'
MODDRV	DEFM	'DRV'
MODMEM	DEFM	'MEM'
RELMSG	DEFM	'RSEC'
;
POSIT	DEFB	0,0,0		;3 byte record position
;
;	entry modify mode on buffer
;
MODIFY	CALL	@VSIZE		;get video size
	PUSH	HL		;pass video mem => IX
	POP	IX		;IX => video
	PUSH	HL		;pass video mem => IY
	POP	IY		;IY => video
	LD	BC,8		;offset to hex side
	ADD	IX,BC		;IX => first hex char
	LD	C,48		;offset to ascii side
	ADD	IY,BC		;IY => first ascii char
	LD	DE,(ADDRESS)	;get buffer address
;
;	compute relative offset of current cursor
;
MODWT	PUSH	DE		;save buffer pointer
	LD	HL,(ADDRESS)	;get address start block
	EX	DE,HL		;HL = current
	OR	A		;clear carry
	SBC	HL,DE		;compare current <> start
	LD	A,L		;get LSB = offset
	LD	(TEMP2),A	;save offset
	CALL	HEXCV		;to hex ascii
	PUSH	BC		;save
	CALL	@VSIZE		;locate video
	POP	BC		;restore ascii
	LD	A,B		;get MSB
	CALL	@VPOKE		;to video
	INC	HL		;bump pointer
	LD	A,C		;get LSB
	CALL	@VPOKE		;to video
	POP	DE		;restore buffer
	LD	A,RATE		;flash counter
;
	IF	TRS13.OR.LDOSSVC
	LD	BC,8F00H	;B=off, C=modfix
	ENDIF
	IF	TRS2
	LD	BC,1E00H	;B=off, C=modfix
	ENDIF
	CALL	FLICKSP		;special key input
;
	LD	HL,MODWT	;return vector
	PUSH	HL		;leave on stack
	PUSH	AF		;save input key
	LD	A,(MODE)	;get modify mode type
	CP	4		;ascii modify?
	LD	HL,MODTBL	;modify table
	JR	Z,MODCONT	;go if yes
	LD	HL,MODTBL0	;non-ascii table
MODCONT	POP	AF		;restore char
	CALL	@LOOKUP		;command key?
	JP	NZ,NUMBER	;nope, interpret as numb
	JP	(HL)		;go vector!
;
MODTBL0	DEFB	'P'		;propogate mode?
	DEFW	FILBYTS
	DEFB	'G'		;go to offset?
	DEFW	GOBYTE
	DEFB	'L'		;locate byte?
	DEFW	FINBYTE
	DEFB	'+'		;inc offset
	DEFW	INCOFF
	DEFB	'-'		;dec offset
	DEFW	DECOFF
	DEFB	'S'		;start of page?
	DEFW	STAOFF
	DEFB	'Q'		;end of page?
	DEFW	ENDOFF
	DEFB	'Z'		;zero to end of page?
	DEFW	ZEROFF
;
MODTBL	DEFB	'>'		;insert mode?
	DEFW	INSBYTE
	DEFB	'<'		;delete mode?
	DEFW	DELBYTE
	DEFB	LARR		;cursor left
	DEFW	MODL
	DEFB	RARR		;cursor right
	DEFW	MODR
	DEFB	UARR		;cursor up
	DEFW	MODU
	DEFB	DARR		;cursor down
	DEFW	MODD
	DEFB	SRARR		;right end
	DEFW	MODRE
	DEFB	SLARR		;left end
	DEFW	MODLE
	DEFB	SDARR		;bottom
	DEFW	MODDE
	DEFB	SUARR		;top
	DEFW	MODUE
	DEFB	ESCAPE		;cancel?
	DEFW	CANCEL
	DEFB	BREAK		;cancel?
	DEFW	CANCEL
	DEFB	CR		;update
	DEFW	UPDATE
	DEFB	CLEAR		;base change
	DEFW	CHWT
	DEFB	ETBL		;end of table
;
BLKS	DEFB	BLOCK,BLOCK,BLOCK
;
;	get new modify mode base
;
CHWT	LD	HL,BLKS		;prompt
CHWT2	PUSH	DE		;save address
	PUSH	HL		;save text
	CALL	@VSIZE		;C = # columns
	LD	B,0		;BC = columns
	ADD	HL,BC		;HL => video
	LD	B,H		;pass to BC
	LD	C,L		;BC => video
	POP	HL		;HL => text
	LD	DE,3		;text length
	LD	A,3		;command
	CALL	@VIDRAM		;prompt => video
	POP	DE		;DE => buffer
	LD	A,RATE		;delay count
	LD	(CHWT4),A	;save count
CHWT3	CALL	@KBCHAR		;scan keyboard
	JR	Z,CHWT5		;go if have one!
	LD	A,'$'		;get counter
CHWT4	EQU	$-1
	DEC	A		;-1
	LD	(CHWT4),A	;update count
	JR	NZ,CHWT3	;wait if more
	LD	H,B		;pass video => HL
	LD	L,C		;HL => video @ cursor
	CALL	@VPEEK		;read the char
	CP	BLOCK
	JR	NZ,CHWT		;nope, draw block
	LD	HL,SPACES	;else spaces
	JR	CHWT2		;continue
;
CHWT5	CALL	@UCASE		;make char upper case
	CP	'H'		;hex?
	LD	B,0		;flag
	JR	Z,CHAVE		;yes, go!
	INC	B		;flag decimal
	CP	'D'		;yes?
	JR	Z,CHAVE		;yes, go!
	INC	B		;flag binary
	CP	'B'		;yes?
	JR	Z,CHAVE		;yes, go!
	INC	B		;flag octal
	CP	'O'		;yes?
	JR	Z,CHAVE		;yes, go!
	CP	'Q'		;octal?
	JR	Z,CHAVE
	INC	B		;flag ascii
	CP	'A'		;yes?
	JR	NZ,CHAVE1	;none, ignore input
CHAVE	LD	A,B		;get mode
	LD	(MODE),A	;set new mode
CHAVE1	JP	PUTMODE		;redisplay new mode & ret
;
SPACES	DEFM	'                '
;
;	clear video buffer
;
VCLEAR	LD	HL,$VBUFF	;video buffer
	LD	DE,$VBUFF+1	;start +1
	LD	BC,24*80-1	;max video size -1
	LD	(HL),' '	;load blank
	LDIR			;load many blanks
	RET			;done
;
;	convert binary => hex ascii
;
HEXCV	LD	C,A		;save digit
	RRCA			;align high nybble => low
	RRCA
	RRCA
	RRCA
	CALL	HEXDIG		;convert
	LD	B,A		;save MSB
	LD	A,C		;get original
	CALL	HEXDIG		;convert
	LD	C,A		;save LSB
	RET			;done
;
HEXDIG	AND	0FH		;low 4 bits only
	ADD	A,'0'		;make it ascii
	CP	'9'+1		;in range?
	RET	C		;yes, done!
	ADD	A,7		;adjust for A-F
	RET			;done
;
;	convert binary => ascii
;
ASCII	LD	B,'0'		;init MSB
ASC1	SUB	100		;less 100's place
	JR	C,ASC2		;go if found
	INC	B		;bump digit
	JR	ASC1		;continue
ASC2	PUSH	BC		;save MSB
	ADD	A,100		;add last sub
	LD	B,'0'		;init NSB
ASC3	SUB	10		;less 10's place
	JR	C,ASC4		;go if found
	INC	B		;bump digit
	JR	ASC3		;continue
ASC4	ADD	A,10+'0'	;last sub + ascii
	LD	C,A		;save LSB
	POP	AF		;get MSB
	RET			;ABC = ascii
;
