;pdsedit2/asm
;
PUTSNG	LD	HL,BUFFER	;point to buffer
	LD	DE,3C00H	;move to video
	LD	BC,1024
	LDIR
	NOP
	JP	RESPUT		;continue
PRINT	PUSH	HL		;save the string
	SET	5,(IY)		;video needs update
PRTLP	LD	A,(HL)		;get a byte
	INC	HL		;bump it
	CP	3		;terminator?
	JR	Z,PRTDN		;done
	CALL	VOUT		;out to video
	CP	13		;terminator?
	JR	NZ,PRTLP
PRTDN	POP	HL
	RET
VOUT	CP	20H		;control code?
	JR	C,VCTRL
	PUSH	HL		;else save pointer
	LD	HL,(4020H)	;get cursor
	LD	(HL),A		;put on screen
	CP	(HL)		;still there?
	JR	Z,VIDOK		;lower case in
	SUB	20H		;else make it upper
	LD	(HL),A		;put it back
VIDOK	CALL	INCHL		;bump video
	LD	(4020H),HL	;update cursor
	POP	HL		;restore pointer
	RET			;done
VCTRL	CP	1CH
	JP	NZ,33H
	RES	6,(IY)
	JP	33H
GET	POP	BC		;restore stack
	POP	DE
	POP	HL
	OR	A		;set flags
	RET
INKEY	PUSH	HL		;save all registers
	PUSH	DE
	PUSH	BC
	LD	HL,GET		;unstacker address
	PUSH	HL
	IN	A,(0)		;check for joystick
	CP	0FFH		;check for FFH
	JP	NZ,JOYSTK	;decode this
	LD	A,(387FH)	;any keys pressed?
	OR	A
	JR	NZ,ADDRPT	;check repeat if yes
GONWKEY	LD	HL,400H		;first key delay
	LD	(DLY1),HL	;save it
;
CONTRPT	LD	A,3		;between key delay
	LD	(DLY2),A	;save it
	JR	KIGO		;continue
ADDRPT	CP	0		;lastkey
LSTKEY	EQU	$-1
	LD	(LSTKEY),A
	JR	NZ,GONWKEY	;new key
;
	LD	HL,200H		;repeat counter
DLY1	EQU	$-2
	LD	A,H		;any bits on?
	OR	L
	JR	Z,CKDLY2	;go if yes
	DEC	HL		;less one
	LD	(DLY1),HL	;re-save it
	JR	KIGO		;continue
;
CKDLY2	LD	A,3		;get second delay
DLY2	EQU	$-1
	DEC	A		;less one
	LD	(DLY2),A	;re-save it
	JR	NZ,KIGO		;go if not time
;
	LD	HL,MASK		;zero out mask area
	LD	DE,MASK+1
	LD	BC,6
	LD	(HL),0
	LDIR
	JR	CONTRPT		;continue
KIGO	LD	HL,MASK		;point to mask area
	LD	BC,3801H	;keyboard memory
	LD	D,0		;row counter
	LD	A,(3840H)
	AND	2
	JR	Z,NEXROW
	LD	A,(3880H)
	OR	A
	JR	Z,NEXROW
	LD	A,3
	JP	@KEYG
NEXROW	LD	A,(BC)		;check for key
	LD	E,A		;save here
	XOR	(HL)		;check for same as last
	LD	(HL),E		;save this key
	AND	E		;same as last?
	JR	NZ,HAVEIT	;have a new one if NZ
	INC	D		;bump row counter
	INC	L		;next mask byte
	RLC	C		;next keyboard row
	JP	P,NEXROW	;go next row
	XOR	A		;nothing here
	RET			;go back
HAVEIT	LD	E,A		;save masked byte
	LD	A,D		;get row counter
	RLCA			;*2
	RLCA			;*4
	RLCA			;*8
	LD	D,A		;save row*8
	LD	C,1		;column mask bit
MKT1	LD	A,C
	AND	E		;right column?
	JR	NZ,MKT2		;have it
	INC	D		;bump counter
	RLC	C		;shift mask bit
	JR	MKT1		;conti.ue
MKT2	LD	E,D		;save LSB
	LD	D,0		;DE = byte positi/n
	LD	HL,KEYS1	;keytable #1
	LD	A,(3840H)	;check for aontrol key
	AND	2		;on?
	JR	NZ,GOTKEY	;have the iey
	LD	HL,KEYS2	;keytable #2
	LD	A,(3880H)	;check for shift key
	OR	A		;on?
	JR	NZ,GOTKEY	;have the key
	LD	HL,KEYS3	;keytable #3
GOTKEY	ADD	HL,DE		;point to the byte
	LD	BC,1000H	;keybounce delay
	CALL	60H		;wait a bit
	LD	A,(HL)		;fetch it
	BIT	7,(IY)
	RET	Z
	PUSH	AF
	LD	BC,900H
	CALL	60H
	POP	AF
	RET
@KEYG	CALL	@SCPRT
	XOR	A
	RET
JOYSTK	LD	B,'I'
	CP	0FAH
	JR	Z,GOTJOY
	LD	B,'O'
	CP	0F6H
	JR	Z,GOTJOY
	LD	B,'K'
	CP	0F9H
	JR	Z,GOTJOY
	LD	B,'L'
	CP	0F5H
	JR	Z,GOTJOY
	LD	B,5BH
	BIT	0,A
	JR	Z,HAVJOY
	INC	B
	BIT	1,A
	JR	Z,HAVJOY
	INC	B
	BIT	2,A
	JR	Z,HAVJOY
	INC	B
	BIT	3,A
	JR	Z,HAVJOY
	XOR	A
	RET
HAVJOY	BIT	4,A
	JR	NZ,GOTJOY
	LD	A,B
	SUB	67
	LD	B,A
GOTJOY	LD	A,B
	PUSH	AF
	LD	BC,1800H
	CALL	60H
	POP	AF
	RET
KEYS1	DB	192,193,194,195,196,197,198,199
	DB	200,201,202,203,204,205,206,207
	DB	208,209,210,211,212,213,214,215
	DB	216,217,218,0,0,0,0,0
	DB	176,177,178,179,180,181,182,183
	DB	184,185,186,171,188,173,190,191
	DB	141,0,129,219,220,221,222,160
KEYS3	DB	'@ABCDEFG'
	DB	'HIJKLMNO'
	DB	'PQRSTUVW'
	DB	'XYZ',0,0,0,0,0
	DB	'01234567'
	DB	'89:;,-./'
	DB	13,0,1,5BH,5CH,5DH,5EH,20H
KEYS2	DB	'`abcdefg'
	DB	'hijklmno'
	DB	'pqrstuvw'
	DB	'xyz',0,0,0,0,0
	DB	5FH,'!"#$%&',27H
	DB	'()*+<=>?'
	DB	14,0,2,18H,19H,1AH,1BH,7FH
FLKEY	LD	HL,LFEED	;1 line down
	CALL	PRINT
	LD	HL,FLMSG	;flash message
	EXX			;save here
	LD	HL,FLMSGB	;clear line message
FLWAIT	EXX			;swap sets
	CALL	PRINT		;display the message
	LD	B,0		;loops
FLWAITB	CALL	INKEY		;check keyboard
	CP	13		;enter key?
	JR	Z,FLDONE	;finished
	CP	14		;sh enter?
	JR	Z,FLDONE
	DJNZ	FLWAITB		;wait some more
	JR	FLWAIT		;reverse message
FLDONE	LD	HL,FLMSGB	;clear the line
	JP	PRINT		;display and return
KEYTEXT	XOR	A		;load zero
;
KEYTXT	CALL	INKEY		;check for a key
	RET	NZ		;done now
	LD	A,8
GCNT1	EQU	$-1
	DEC	A
	LD	(GCNT1),A
	JR	NZ,KEYTXT
	LD	A,1
FLASH1	EQU	$-1
	LD	(GCNT1),A
GCNTY	CALL	FIGTPOS		;figure the position
	JR	GCNTX
FIGTPOS	LD	H,(IY+6)	;get position
	LD	L,(IY+7)
FIGPOS	LD	DE,0		;start of buffer
	LD	A,H		;get vertical posit
YTST	OR	A
	JR	Z,YHAV		;have the row
	PUSH	HL		;save this
	LD	HL,40H		;next row
	ADD	HL,DE		;point to it
	EX	DE,HL		;DE has it
	POP	HL		;restore this
	DEC	A
	JR	YTST		;check next row
YHAV	LD	A,E		;get lsb
	OR	L		;set with row
	LD	E,A		;put it back
	BIT	6,(IY)
	RET	Z
	LD	L,E		;save E
	LD	A,E
	AND	0C0H
	LD	E,A
	LD	A,L
	AND	3FH
	ADD	A,A
	OR	E
	LD	E,A
	RET
GCNTX	LD	HL,3C00H	;go to video
	ADD	HL,DE
	LD	A,0
GCNT2	EQU	$-1
	XOR	1
	LD	(GCNT2),A	;check for on/off
	LD	A,191		;on block
	JR	NZ,GHAV
	LD	A,80H		;off block
GHAV	LD	(HL),A		;display it
	NOP
	JR	KEYTXT		;continue
KEYWT	LD	A,(387FH)	;any keys pressed?
	OR	A
	JR	NZ,KEYWT	;wait if any are
KEY	BIT	7,(IY)		;text entry ?
	JR	NZ,KEYTEXT	;different input
;	JR	KESET		;turn on cursor
GKEYLP	CALL	INKEY		;check for a key
	RET	NZ
	LD	A,8		;get flash count
FCNT1	EQU	$-1
	DEC	A
	LD	(FCNT1),A	;put it back
	JR	NZ,GKEYLP	;continue
	LD	A,1
FLASH2	EQU	$-1
	LD	(FCNT1),A	;re-initialize counter
	LD	A,0		;get set/reset
FCNT2	EQU	$-1
	XOR	1		;reverse bit 0
	LD	(FCNT2),A	;put it back
	JR	NZ,KESET	;turn on the dot
	CALL	VRESET		;turn it off
	JR	GKEYLP		;continue
KESET	CALL	VSET		;turn it on
	JR	GKEYLP
VRESET	LD	HL,3C00H
	LD	(SBUFF),HL	;do it on video
	CALL	RESET		;turn it off
	LD	HL,BUFFER
	LD	(SBUFF),HL	;restore it
	RET
VSET	LD	HL,3C00H
	LD	(SBUFF),HL
	CALL	SET
	LD	HL,BUFFER
	LD	(SBUFF),HL
	RET
SET	LD	A,0C6H
	JR	TEST10
POINT	LD	A,46H
	JR	TEST10
RESET	LD	A,86H
TEST10	LD	(INST+1),A
	LD	D,(IY+4)
	LD	E,(IY+5)
DOSET	CALL	SIZFIX
	LD	A,E
	INC	H
	CP	H
	RET	NC
	LD	A,D
;	INC	L
;	CP	L
;	RET	NC
	PUSH	BC
	LD	B,-1
LOOPX	INC	B
	SUB	3
	JP	P,LOOPX
	ADD	A,3
	ADD	A,A
	LD	C,A
	LD	L,B
	LD	H,0
	LD	B,6
LOOPY	ADD	HL,HL
	DJNZ	LOOPY
	LD	D,0
	SRL	E
	JR	NC,LOOPZ
	INC	C
LOOPZ	ADD	HL,DE
	LD	DE,BUFFER
SBUFF	EQU	$-2
	ADD	HL,DE
	SLA	C
	SLA	C
	SLA	C
	LD	A,(INST+1)
	ADD	A,C
	LD	(INST+1),A
	POP	BC
	BIT	6,(IY)
	JR	Z,INST
	LD	A,L
	PUSH	AF
	EX	AF,AF'
	POP	AF
	AND	0C0H
	LD	L,A
	EX	AF,AF'		;get original
	AND	3FH
	ADD	A,A
	OR	L
	LD	L,A		;have double size now
INST	DB	0CBH
	DB	0
	NOP
	SET	7,(HL)
	NOP
	RET
FLASH	LD	A,(FLASH1)	;get text flash
	ADD	A,30H		;make it ascii
	LD	(TFLASH),A
	LD	A,(FLASH2)
	ADD	A,30H
	LD	(GFLASH),A
	LD	HL,FMSG1
	CALL	ASKFLS		;ask for it
	JR	Z,GFL2
	LD	(FLASH2),A
GFL2	LD	HL,FMSG2	;text flash
	CALL	ASKFLS
	JP	Z,RESUME
	LD	(FLASH1),A	;save this too
	JP	RESUME		;continue
ASKFLS	CALL	PRINT		;display message
	LD	B,1		;1 char input
	CALL	GETSTR		;get fromkeyboard
	RET	Z
	SUB	31H		;test 1-9
	JR	C,FIXFLS
	CP	9
	JR	NC,FIXFLS
	INC	A		;adjust for 1-9
	RET
FIXFLS	JP	RESUME		;continue
ANGLES	LD	A,(IY+2)	;get horizontal
	ADD	A,30H		;make it ascii
	LD	(HMUCH),A	;put in string
	LD	A,(IY+3)	;get vertical speed
	ADD	A,30H
	LD	(VMUCH),A
	LD	HL,AMSG1	;first message
	CALL	ASKFLS		;get the input
	JR	Z,DOSK1
	LD	(IY+2),A	;resave it
DOSK1	LD	HL,AMSG2	;second message
	CALL	ASKFLS
	JR	Z,DOSK2
	LD	(IY+3),A
DOSK2	LD	HL,AMSG3	;3rd messge
	CALL	PRINT
	LD	B,1
	CALL	GETSTR
	JP	Z,RESUME
	CALL	UCASE
	SET	2,(IY)
	CP	'D'
	JP	Z,RESUME
	RES	2,(IY)
	JP	RESUME
HEXCV	LD	B,A		;convert char in A to
	SRL	A		;HEX ascii in CB
	SRL	A
	SRL	A
	SRL	A
	CALL	HEXTST
	LD	C,A
	LD	A,B
	AND	0FH
	CALL	HEXTST
	LD	B,A
	RET
HEXTST	ADD	A,30H
	CP	3AH
	RET	M
	ADD	A,7
	RET
ASCII	PUSH	HL		;convert number in A
	CALL	ASCI		;to decimal ascii in ACB
	LD	H,B
	PUSH	HL
	LD	A,C
	SUB	30H
	CALL	ASCI
	LD	A,C
ASCIGO1	POP	HL
	LD	C,B
	LD	B,H
	POP	HL
	RET
ASCI	LD	C,'0'
ASCII1	SUB	10
	JR	C,ASCII2
	INC	C
	JR	ASCII1
ASCII2	ADD	A,3AH
	LD	B,A
	RET
ASKFILE	LD	HL,FILEMSG	;filename message
	CALL	PRINT		;display it
	LD	B,14		;14 chars possible
	LD	HL,DCB		;where to put the data
	CALL	WAITKEY		;get key input
	EX	DE,HL
	JP	Z,RESUME
	PUSH	BC
	PUSH	DE
FIXFL	LD	A,(DE)		;make all uppercase
	CALL	UCASE
	LD	(DE),A
	INC	DE
	DJNZ	FIXFL
	POP	DE
	LD	HL,DEFEXT	;/DRW
	LD	A,(IY-1)
	BIT	3,A
	JR	Z,DODEF
	AND	7
	JR	Z,DODEF
	LD	HL,DEFASM	;/ASM
	DEC	A
	JR	Z,DODEF
	DEC	A
	JR	Z,DODEF
	LD	HL,DEFBAS	;/BAS
	DEC	A
	JR	Z,DODEF
	DEC	A
	JR	Z,DODEF
	DEC	A
	JR	Z,DODEF
	LD	HL,DEFCMD	;/CMD
DODEF	CALL	ADDEXT		;add default extension
	POP	BC		;restore length
	RET
LOAD	LD	HL,LOADMSG	;loading message
	CALL	PRINT		;display it
	RES	3,(IY-1)	;set LOAD flag
	CALL	DISKTAPE	;setup parameters
	LD	HL,IOBUFF	;where data goes
	LD	DE,DCB
	LD	(IY+8),1
	LD	(IY+9),0
	CALL	RDBUFF		;read 256 bytes
	JP	NZ,CERROR	;no good
	LD	HL,IOBUFF	;check for valid
	LD	DE,QUICK
	LD	B,21		;21 bytes must match
	CALL	COMPARE		;test 'em
	JR	Z,RVALID	;ok to read
INVALID	CALL	CLSBUFF
	LD	HL,VALMSG	;invalid data
	CALL	PRINT
	CALL	FLKEY
	JP	RESUME		;continue
RVALID	LD	BC,0E600H	;40 loops through
	LD	(IY+10),L	;save position
	LD	(IY+11),H
LCKLP	LD	A,(HL)		;get a slot
	CP	99
	JR	NZ,CKLP
	INC	C		;bump counter
CKLP	INC	HL		;bump table
	DJNZ	LCKLP		;do 'em all
	PUSH	BC		;save it
	LD	A,C		;get result
	LD	(IY+8),A
	CALL	ASCII		;make it ascii
	LD	(RDMSG),BC	;save it in string
	LD	HL,RDMSG	;reading message
	CALL	PRINT		;display it
	POP	BC		;restore count
	LD	A,(IY+1)	;get # available
	CP	C		;test
	JR	NC,LOADLPX	;enough to read 'em
	CALL	CLSBUFF
	LD	HL,MEMMSG	;not enough memory
	CALL	PRINT
	CALL	FLKEY		;flash for key
	JP	RESUME		;resume action
LOADLPX	LD	L,(IY+10)	;get position back
	LD	H,(IY+11)
	LD	DE,STRING	;save data here for now
	PUSH	DE		;save this
	LD	BC,230		;230 entries possible
	LDIR			;move it in
	LD	A,(IY+8)	;get # buffers
	ADD	A,A
	ADD	A,A
	LD	(IY+8),A	;# sectors to read
	CALL	ASCII
	BIT	7,(IY-1)
	JR	Z,SKPSHW
	LD	(3C7DH),A
	LD	(3C7EH),BC
SKPSHW	POP	HL		;hl => bufftable
	LD	BC,0E601H	;40 entries, C counter
LOADLP	LD	A,(HL)		;get a byte
	CP	99		;anything there?
	JR	NZ,NEXTLD	;skip if not
	LD	A,C		;get buff #
	LD	(IY+12),A	;save here
	INC	A
	CP	(IY+1)
	JR	NC,NEXTLD
	PUSH	HL		;save pointer
	PUSH	BC		;save counter
	LD	HL,BUFFTABLE-1	;buffer table
	LD	B,0
	ADD	HL,BC
	LD	(HL),99		;buffer has data
	LD	HL,BUFFER
	LD	DE,400H
FIXB1	ADD	HL,DE
	DEC	C
	JR	NZ,FIXB1
	LD	B,4		;4 sectors / screen
RDLP	PUSH	HL		;save pointer
	PUSH	BC
	LD	DE,DCB		;read a sector
	LD	HL,IOBUFF
	CALL	RDBUFF		;read the buffer
	POP	BC		;restore count
	POP	HL		;restore pointer
	JR	NZ,BADLD	;no good
	EX	DE,HL		;put the bytes there
	PUSH	BC		;save this
	LD	HL,IOBUFF
	LD	BC,100H
	LDIR			;move 'em
	EX	DE,HL
	POP	BC		;done here
	DJNZ	RDLP
	POP	BC		;restore stack
	POP	HL
NEXTLD	INC	HL		;bump table pointer
	INC	C
	DJNZ	LOADLP		;continue for 230 entries
	CALL	CLSBUFF		;close files
	CALL	FLKEY
	JP	RESUME		;load completed
BADLD	POP	BC		;restore stack
	POP	HL
	JP	CERROR
COMPARE	LD	A,(DE)		;compare buffers
	CP	(HL)
	INC	DE
	INC	HL
	RET	NZ
	DJNZ	COMPARE
	RET
ERROR	OR	0C0H		;for return
	CALL	4409H		;display DOS error
	CALL	FLKEY		;wait for key
	JP	RESUME		;clear and continue
SAVE	LD	HL,SAVEMSG	;saving message
	CALL	PRINT
	SET	3,(IY-1)	;set SAVE operation
	LD	B,(IY+1)
	LD	C,0
	LD	HL,BUFFTABLE
SVLP	LD	A,(HL)
	CP	99
	JR	NZ,SVLP1
	INC	C
SVLP1	INC	HL
	DJNZ	SVLP
	LD	A,C		;get count
	LD	(IY+8),A
	OR	A
	JR	NZ,SVCONT	;continue
	LD	HL,NOSAVE	;nothing to save
	CALL	PRINT
	CALL	FLKEY		;wait for ENTER
	JP	RESUME		;continue
SVCONT	CALL	ASCII		;# buffer=>ascii
	LD	(SAVNUM),BC	;put in string
	LD	A,(IY+8)
	ADD	A,A
	ADD	A,A
	INC	A
	LD	(IY+8),A
	LD	(IY+9),1
	LD	HL,PUTMSG	;# of buffers
	CALL	PRINT
	CALL	DISKTAPE	;setup parameters
	BIT	7,(IY-1)
	JP	NZ,NOWTHERE	;continue if tape
	JR	C,THERENOW	;new file created
	LD	HL,THEREMSG	;see if yes/no
	CALL	PRINT		;display it
	LD	B,3		;3 char input
	CALL	GETSTR		;get request
	JP	Z,RESUME	;cancel it
	CALL	UCASE		;make it upper
	CP	'Y'		;must be YES
	JP	NZ,RESUME	;quit now
	JR	NOWTHERE
THERENOW
	LD	HL,THRMSG
	CALL	PRINT
NOWTHERE	LD	HL,IOBUFF
	LD	DE,IOBUFF+1
	LD	BC,0FFH
	LD	(HL),0
	LDIR			;clear the buffer
	LD	HL,QUICK	;insert identity
	LD	DE,IOBUFF
	LD	BC,21
	LDIR
	LD	HL,BUFFTABLE
	LD	BC,230
	LDIR
	LD	DE,DCB		;point to DCB
	LD	HL,IOBUFF
	CALL	WRBUFF		;write the buffer
	JP	NZ,CERROR	;close and return
	LD	HL,BUFFTABLE
	LD	B,(IY+1)
	LD	C,1
SVLOOP	LD	A,(HL)		;get a byte
	CP	99		;anything ?
	JR	NZ,NEXTSAV	;skip it
	LD	A,C		;get buff #
	LD	(IY+12),A
	PUSH	HL
	PUSH	BC
	LD	HL,BUFFER
	LD	DE,400H
FIGB2	ADD	HL,DE
	DEC	C
	JR	NZ,FIGB2
	LD	B,4		;4 sectors/screen
SSAVLP	PUSH	BC
	LD	DE,IOBUFF	;move data to buffer
	LD	BC,100H
	LDIR
	PUSH	HL
	LD	DE,DCB
	LD	HL,IOBUFF
	CALL	WRBUFF2		;write the buffer
	POP	HL
	POP	BC
	JR	NZ,BADSAV
	DJNZ	SSAVLP
	POP	BC
	POP	HL
NEXTSAV	INC	HL
	INC	C
	DJNZ	SVLOOP
	LD	A,(IY-1)	;check for special write
	AND	7
	CALL	NZ,FLUSH	;write last data back
	CALL	CLSBUFF
	JP	NZ,ERROR	;print error
	CALL	FLKEY
	JP	RESUME
BADSAV	POP	BC
	POP	HL
CERROR	PUSH	AF		;save error code
	CALL	CLSBUFF		;close it
	JR	Z,OKDONE	;ok, done
	OR	0C0H
	CALL	4409H		;display THIS error
OKDONE	POP	AF		;restore original error
	JP	ERROR		;print this one now
CLSBUFF	LD	DE,DCB		;point to DCB
	BIT	7,(IY-1)	;from disk ?
	JR	NZ,CLSTAPE	;turn off tape
	BIT	3,(IY-1)
	RET	Z
	LD	A,(DE)		;get a byte
	BIT	7,A		;open now?
	RET	Z
	JP	4428H		;close it
CLSTAPE	CALL	01F8H		;turn off cassette
	XOR	A		;set Z flag
	RET
GETSTR	LD	HL,STRING	;point to string
DRAIN	CALL	2BH
	OR	A
	JR	NZ,DRAIN
WAITKEY	LD	A,(387FH)
	OR	A
	JR	NZ,WAITKEY
	PUSH	IY
	CALL	40H
	POP	IY
	JP	C,RESUME	;cancel
	LD	A,B		;get length of input
	OR	A		;set flags
	LD	A,(HL)		;get first character
	RET
UCASE	CP	'a'
	RET	C
	CP	'z'+1
	RET	NC
	AND	5FH
	RET
DOBUFF	LD	A,(IY+1)	;get number of buffers
	CALL	ASCII		;convert to ascii
	LD	(BUFNUM),BC	;save it
	LD	HL,BUFMSG	;header
	CALL	PRINT		;display it
	CALL	PARAMS		;show settings
	LD	HL,BUFMSG0
	CALL	PRINT
	LD	B,1
	CALL	GETSTR		;get answer
	JP	Z,RESUME
	CALL	UCASE		;make it upper
	CP	'S'		;save to buffer?
	JP	Z,SAVBUF
	CP	'R'		;restore a buffer
	JP	Z,RESBUF
	CP	'C'		;clear all?
	JP	Z,ERABUF
	CP	'Z'
	JP	Z,ZROBUF
	CP	'M'
	JP	Z,MERGBUF
	CP	'E'		;exchange?
	JP	NZ,RESUME	;forget it
	LD	HL,EBFMSG	;exchange what?
	CALL	ASKBUF		;which one?
	LD	DE,BUFFER	;exchange here
	LD	BC,400H		;1k to do
EXCHG	LD	A,(DE)		;get a byte
	EX	AF,AF'		;save it
	LD	A,(HL)		;get other one
	LD	(DE),A		;swap one
	EX	AF,AF'
	LD	(HL),A		;fix this one now
	INC	DE		;bump buffers
	INC	HL
	DEC	BC		;counter
	LD	A,B
	OR	C
	JR	NZ,EXCHG	;go till all done
	LD	A,99		;set active
	JR	SETACT
MERGBUF	LD	HL,MBUFMSG
	CALL	ASKBUF
	LD	DE,BUFFER
	LD	BC,400H		;one screen full
MERLP	LD	A,(HL)		;get a byte
	CP	20H
	JR	Z,SKPM
	CP	80H
	JR	Z,SKPM
	LD	(DE),A		;put on video
SKPM	INC	HL
	INC	DE
	DEC	BC
	LD	A,B
	OR	C
	JR	NZ,MERLP
	SET	5,(IY)
	JP	RESUME
SAVBUF	LD	HL,SBFMSG	;save buffer
	CALL	ASKBUF		;get reply
	LD	DE,BUFFER	;point to buffer
	EX	DE,HL		;video => buffer
CONBUF	LD	BC,400H
	LDIR			;move 'em
	LD	A,99		;set active
SETACT	LD	E,(IY+8)	;get position
	LD	D,(IY+9)
	LD	(DE),A		;save value
	JP	RESUME		;continue
RESBUF	LD	HL,RBFMSG
	CALL	ASKBUF
	LD	DE,BUFFER
	LD	BC,400H
	LDIR
	JP	RESUME
ERABUF	LD	A,(IY+1)
	LD	HL,BUFFER+400H
	LD	DE,BUFFER+401H
	LD	(HL),80H
ELOP	LD	BC,400H
	LDIR
	DEC	A
	JR	NZ,ELOP
	LD	HL,BUFFTABLE
	LD	DE,BUFFTABLE+1
	LD	(HL),0
	LD	BC,229
	LDIR
	JP	RESUME
ZROBUF	LD	HL,ZBFMSG
	CALL	ASKBUF
	LD	D,H
	LD	E,L
	INC	DE
	LD	BC,3FFH
	LD	(HL),80H
	LDIR
	XOR	A
	JP	SETACT
ASKBUF	CALL	PRINT
	LD	HL,UBFMSG
	CALL	PRINT
	LD	B,2
	CALL	GETSTR
	JR	Z,BUFNOP
	CALL	VALUE
	JR	C,BUFNOP
	LD	A,(IY+1)
	CP	C
	JR	C,BUFNOP
	LD	A,C
	OR	A
	JR	Z,BUFNOP
	LD	HL,BUFFER
	LD	DE,400H
COMPBF	ADD	HL,DE
	DEC	C
	JR	NZ,COMPBF
	LD	DE,BUFFTABLE-1
	PUSH	HL
	LD	H,0
	LD	L,A
	ADD	HL,DE
	LD	(IY+8),L
	LD	(IY+9),H
	POP	HL
	RET
VALUE	LD	C,0
VALLP	LD	A,(HL)
	CALL	CKVAL
	RET	C
	LD	C,A
	INC	HL
	LD	A,(HL)
	CP	13
	RET	Z
	CALL	CKVAL
	RET	C
	LD	B,A
	LD	A,C
	ADD	A,A
	ADD	A,A
	ADD	A,C
	ADD	A,A
	ADD	A,B
	LD	C,A
	OR	A
	RET
CKVAL	SUB	30H
	RET	C
	CP	10
	CCF
	RET
BUFNOP	JP	RESUME
PARAMETERS
	LD	HL,PARMSG
	CALL	PRINT
	CALL	PARAMS
	JP	PARAMRET
PARAMS	LD	HL,(4020H)
	LD	B,(IY+1)
	LD	C,1
PARLP	PUSH	BC
	LD	A,C
	PUSH	AF
	CALL	ASCII
	LD	(HL),C
	INC	HL
	LD	(HL),B
	INC	HL
	LD	(HL),'='
	INC	HL
	POP	AF
	LD	C,A
	LD	B,0
	PUSH	HL
	LD	HL,BUFFTABLE-1
	ADD	HL,BC
	LD	A,(HL)
	CP	99
	POP	HL
	POP	BC
	JR	NZ,DEADSPT
	LD	(HL),143
	INC	HL
	LD	(HL),143
	INC	HL
	LD	(HL),143
	JR	DEADCNT
DEADSPT	INC	HL
	INC	HL
DEADCNT	INC	HL
	INC	HL
	INC	HL
	INC	C
	DJNZ	PARLP
	LD	(4020H),HL
	LD	HL,LFEED
	JP	PRINT
PARAMRET	CALL	FLKEY
	JP	RESUME
DUBREV	LD	B,16
	LD	HL,BUFFER
	LD	DE,BUFFER+20H
DUBL1	PUSH	HL
	PUSH	DE
	LD	C,32
DUBL2	LD	A,(HL)
	EX	AF,AF'
	LD	A,(DE)
	LD	(HL),A
	EX	AF,AF'
	LD	(DE),A
	INC	HL
	INC	DE
	DEC	C
	JR	NZ,DUBL2
	POP	DE
	POP	HL
	PUSH	BC
	LD	BC,40H
	ADD	HL,BC
	EX	DE,HL
	ADD	HL,BC
	EX	DE,HL
	POP	BC
	DJNZ	DUBL1
	SET	5,(IY)
	JP	RESUME
;
