; pdraw3/asm - kjw/bqsd - revised 05/20/83 - dwh
;
;	move video buffer to video
;
PUTSNG	LD	HL,VBUFF	;point to buffer
	LD	DE,$VIDEO	;start video memory
	LD	BC,$VIDLEN	;length of video
	LDIR			;move buffer => video
	NOP
	JP	RESPUT		;continue
;
;	display string to video
;
PRINT	PUSH	HL		;save the string startt
	SET	5,(IY+0)	;video needs update
;
PRTLP	LD	A,(HL)		;get a byte
	INC	HL		;bump pointer
	CP	_ETX		;terminator?
	JR	Z,PRTDN		;done if yes
	CALL	VOUT		;out to video
	CP	_CR		;terminator?
	JR	NZ,PRTLP	;go if not
;
PRTDN	POP	HL		;restore string start
	RET			;done!
;
;	display char to video
;
VOUT	CP	_SPACE		;control code?
	JR	C,VCTRL		;go if yes!
	PUSH	HL		;else save pointer
	LD	HL,($CURSOR)	;get cursor
	LD	(HL),A		;put on screen
	NOP
	CP	(HL)		;still there?
	NOP
	JR	Z,VIDOK		;lower case in
	SUB	20H		;else make it upper
	LD	(HL),A		;put it back
	NOP
VIDOK	CALL	INCHL		;bump video pointer
	LD	($CURSOR),HL	;update cursor
	POP	HL		;restore pointer
	RET			;done
;
;	display control code
;
VCTRL	CP	_HOME		;home cursor?
	JR	NZ,DOVOUT	;go if not
	RES	6,(IY+0)	;set single wide
;
DOVOUT	PUSH	IY		;save pointer
	PUSH	DE		;ROM will destroy
	CALL	@VDCHAR		;display char
	POP	DE		;restore
	POP	IY		;restore
	RET			;done!
;
;	unstacker for keyboard driver
;
GET	POP	BC		;restore stack
	POP	DE
	POP	HL
	OR	A		;set flags
	RET
;
;	scan keyboard
;
INKEY	CALL	INK		;get char
	RET	Z		;none
	PUSH	HL		;save
	PUSH	BC
	LD	HL,INKOUT	;return vector
	PUSH	HL		;save it
	LD	HL,INKBUF	;storage
	LD	B,3		;number chars
	JR	INKSUBT
INKLP	CALL	INK		;get char
	JR	Z,INKLP		;none yet
INKSUBT	CP	176
	RET	C		;too small
	CP	186
	RET	NC		;too big
	SUB	176-30H		;adjust ASCII
	LD	(HL),A		;save
	INC	HL		;next loc
	DJNZ	INKLP		;more
	LD	HL,INKBUF	;start
	CALL	VALUE		;load C with code
	LD	A,C		;get char
	RET			;to vector
INKOUT	OR	A		;flags
	POP	BC		;restore
	POP	HL
	RET			;done!
INK	PUSH	HL		;save all registers
	PUSH	DE
	PUSH	BC
	LD	HL,GET		;unstacker address
	PUSH	HL
;
;	since different machines will hold the ports
;	with different bits (normal/reversed)
;	allow the joystick operation to be disabled
;
;	holding down the 'J' key on entry will
;	enable the joystick operation
;
JOYCMD	JR	NOTJOY		;NOP's loaded if enabled
	IN	A,(0)		;check for joystick
	CP	-1		;normal bus inverted
	JP	NZ,JOYSTK	;decode if active
;
NOTJOY	LD	A,($KBDR7-1)	;read all key rows
	OR	A		;any keys?
	JR	NZ,ADDRPT	;check repeat if yes
;
GONWKEY	LD	HL,$DELAY1	;first key delay
	LD	(DLY1),HL	;save it
;
CONTRPT	LD	HL,$DELAY2	;between key delay
	LD	(DLY2),HL	;save it
	JR	KIGO		;continue
;
;	check if current key same as last key
;
ADDRPT	CP	0		;lastkey
LSTKEY	EQU	$-1
	LD	(LSTKEY),A	;save new key as last
	JR	NZ,GONWKEY	;new key, go!
;
;	check if time to repeat
;
	LD	HL,$DELAY1	;repeat counter
DLY1	EQU	$-2
	LD	A,H		;any bits on?
	OR	L
	JR	Z,CKDLY2	;go if yes, repeating!
	DEC	HL		;less one
	LD	(DLY1),HL	;re-save it
	JR	KIGO		;continue
;
;	keyboard is repeating, check for between delay
;
CKDLY2	LD	HL,$DELAY2	;get second delay
DLY2	EQU	$-2
	DEC	HL		;less one
	LD	(DLY2),HL	;update counter
	LD	A,H		;time yet?
	OR	L		;any bits on?
	JR	NZ,KIGO		;go if not time
;
;	key is repeating, clear key work mask
;
	LD	HL,MASK		;start key mask
	LD	DE,MASK+1	;start +1
	LD	BC,6		;length -1
	LD	(HL),0		;load zero
	LDIR			;fill zeroes
	JR	CONTRPT		;continue
;
;	scan keyboard for the pressed key
;
KIGO	LD	HL,MASK		;point to mask area
	LD	BC,$KBDR0	;start keyboard memory
	LD	D,0		;row counter
;
;	check for control key
;
	LD	A,($KBDR6)	;last row matrix
	AND	2		;CLEAR key (control?)
	JR	Z,NEXROW	;go if not
	LD	A,($KBDR7)	;read shift key row
	AND	3		;low 2 bits only
	JR	Z,NEXROW	;go if not pressed
	LD	A,_CLEAR	;else set CLEAR key
	JP	KEYG		;go screen printer
;
;	decode keyboard matrix
;
NEXROW	LD	A,(BC)		;read keyboard
	LD	E,A		;save here
	XOR	(HL)		;reverse with bit mask
	LD	(HL),E		;save as new key
	AND	E		;same as last?
	JR	NZ,HAVEIT	;have a new one if NZ
	INC	D		;bump row counter
	INC	HL		;next mask byte
	RLC	C		;next keyboard row
	JP	P,NEXROW	;go all but last row
	XOR	A		;nothing here
	RET			;go back, no keys!
;
;	have a new key, compute table offset
;
HAVEIT	LD	E,A		;save masked byte
	LD	A,D		;get row counter
	ADD	A,A		;*2
	ADD	A,A		;*4
	ADD	A,A		;*8
	LD	D,A		;save row*8
	LD	C,1		;column mask bit
;
MKT1	LD	A,C		;get mask bit
	AND	E		;right column?
	JR	NZ,MKT2		;have it
	INC	D		;bump counter
	RLC	C		;shift mask bit
	JR	MKT1		;continue
;
;	have key offset, row * 8 + column
;
MKT2	LD	E,D		;save LSB
	LD	D,0		;DE = byte position
	LD	HL,KEYS1	;keytable #1
	LD	A,($KBDR6)	;read keyboard
	AND	2		;control key (CLEAR) ?
	JR	NZ,GOTKEY	;have the key if yes
	LD	HL,KEYS2	;keytable #2
	LD	A,($KBDR7)	;check for shift key
	AND	3		;pressed?
	JR	NZ,GOTKEY	;have the key if yes
	LD	HL,KEYS3	;keytable #3
;
GOTKEY	ADD	HL,DE		;point to the byte
	LD	BC,$DELAY3	;keybounce delay
	CALL	@DELAY		;wait a bit
	LD	A,(HL)		;fetch the key
	BIT	7,(IY+0)	;text mode?
	RET	Z		;nope, go!
;
;	extra keybounce delay for text mode
;
	LD	BC,$DELAY4	;extra debounce delay
	CALL	@DELAY		;countdown
	LD	A,(HL)		;fetch key again
	RET			;done!
;
;	send contents of video to printer
;
KEYG	CALL	SCRPRT		;print video
	XOR	A		;set NO key
	RET			;return
;
;	decode joystick matrix
;
JOYSTK	LD	B,'I'		;up/left
	CP	11111010B
	JR	Z,GOTJOY
	LD	B,'O'		;up/right
	CP	11110110B
	JR	Z,GOTJOY
	LD	B,'K'		;down/left
	CP	11111001B
	JR	Z,GOTJOY
	LD	B,'L'		;down/right
	CP	11110101B
	JR	Z,GOTJOY
;
	LD	B,_UARR		;up
	BIT	0,A
	JR	Z,HAVJOY
	INC	B		;down
	BIT	1,A
	JR	Z,HAVJOY
	INC	B		;left
	BIT	2,A
	JR	Z,HAVJOY
	INC	B		;right
	BIT	3,A
	JR	Z,HAVJOY
	JP	NOTJOY		;what happened??
;
;	check for button
;
HAVJOY	BIT	4,A		;button pressed?
	JR	NZ,GOTJOY	;go if not
	LD	A,B		;get the key
	SUB	_UARR-_SUARR	;make it shifted!
	LD	B,A		;update
;
;	B = simulated keystroke, add debounce delay
;
GOTJOY	PUSH	BC		;save key on stack
	LD	BC,$DELAY5	;joystick delay
	CALL	@DELAY		;countdown BC till 0
	POP	AF		;A = input key
	RET			;done, go!
;
;	keyboard lookup table - CONTROL keys
;
KEYS1	DEFB	192,193,194,195,196,197,198,199
	DEFB	200,201,202,203,204,205,206,207
	DEFB	208,209,210,211,212,213,214,215
	DEFB	216,217,218,219,220,221,222,223
	DEFB	176,177,178,179,180,181,182,183
	DEFB	184,185,186,171,188,173,190,191
	DEFB	141,000,129,219,220,221,222,160
;
;	keyboard lookup table - SHIFTED keys
;
KEYS3	DEFB	064,065,066,067,068,069,070,071
	DEFB	072,073,074,075,076,077,078,079
	DEFB	080,081,082,083,084,085,086,087
	DEFB	088,089,090,091,092,093,094,095
	DEFB	048,049,050,051,052,053,054,055
	DEFB	056,057,058,059,044,045,046,047
	DEFB	013,000,001,091,092,093,094,032
;
;	keyboard lookup table - UNSHIFTED keys
;
KEYS2	DEFB	096,097,098,099,100,101,102,103
	DEFB	104,105,106,107,108,109,110,111
	DEFB	112,113,114,115,116,117,118,119
	DEFB	120,121,122,123,124,125,126,127
	DEFB	095,033,034,035,036,037,038,039
	DEFB	040,041,042,043,060,061,062,063
	DEFB	014,000,002,024,025,026,027,127
;
;	flash prompt string and wait for a key
;
FLKEY	LD	HL,LFEED	;1 line down
	CALL	PRINT		;display to video
	LD	HL,FLMSG	;flash message
	EXX			;save here
	LD	HL,FLMSGB	;clear line message
;
FLWAIT	EXX			;swap sets
	CALL	PRINT		;display the message
	LD	B,0		;loop counter
;
FLWAITB	CALL	INKEY		;check keyboard
	CP	_CR		;enter key?
	JR	Z,FLDONE	;finished if yes
	CP	_CR+1		;sh enter?
	JR	Z,FLDONE	;done if yes
	DJNZ	FLWAITB		;wait some more for key
	JR	FLWAIT		;reverse message and wait
;
;	have a key, clear video line and return
;
FLDONE	LD	HL,FLMSGB	;clear the line
	JP	PRINT		;display and return
;
;	wait for input key in text mode
;
KEYTEXT	XOR	A		;load zero
;
KEYTXT	CALL	INKEY		;check for a key
	RET	NZ		;return if we have one
	LD	A,2		;delay count
GCNT1	EQU	$-1
	DEC	A		;less one
	LD	(GCNT1),A	;update counter
	JR	NZ,KEYTXT	;wait if not time
	LD	A,2		;reset counter
FLASH1	EQU	$-1
	LD	(GCNT1),A	;have it
;
;	reverse video cursor character
;
GCNTY	CALL	FIGTPOS		;figure the position
	JR	GCNTX		;continue
;
;	compute location of cursor in TEXT mode
;
FIGTPOS	LD	H,(IY+6)	;get vert posit
	LD	L,(IY+7)	;get horiz posit
;
FIGPOS	LD	DE,0		;start of buffer
	LD	A,H		;get vertical posit
	OR	A		;at top?
	JR	Z,YHAV		;have the row, go!
;
YTST	PUSH	HL		;save this
	LD	HL,$TCOLS	;next row
	ADD	HL,DE		;point to it
	EX	DE,HL		;DE has it
	POP	HL		;restore this
	DEC	A		;less row counter
	JR	NZ,YTST		;check next row if more
;
YHAV	LD	A,E		;get column
	OR	L		;set with row
	LD	E,A		;put it back, DE=> offset
	BIT	6,(IY+0)	;double wide?
	RET	Z		;nope, done!
;
;	compute offset in double wide video
;
	LD	L,E		;save E
	LD	A,E		;get into accum
	AND	0C0H		;top 2 bits only (ROW)
	LD	E,A		;E = row offset
	LD	A,L		;get original
	AND	3FH		;low 6 bits only (COLUMN)
	ADD	A,A		;*2 (every other char)
	OR	E		;combine with offset
	LD	E,A		;update offset
	RET			;DE = video offset
;
;	flash video cursor in text mode
;
GCNTX	LD	HL,$VIDEO	;start video memory
	ADD	HL,DE		;HL => current cursor
	LD	A,0		;get flash factor
GCNT2	EQU	$-1
	XOR	1		;reverse bit 0
	LD	(GCNT2),A	;check for on/off
	LD	A,191		;on block
	JR	NZ,GHAV		;go if cursor off
	LD	A,80H		;off block
GHAV	LD	(HL),A		;display it to video
	NOP
	JR	KEYTXT		;continue
;
;	scan keyboard - wait till all keys released
;
KEYWT	LD	A,($KBDR7-1)	;read all key rows
	OR	A		;any keys pressed?
	JR	NZ,KEYWT	;wait if any are
;
KEY	BIT	7,(IY+0)	;text entry ?
	JR	NZ,KEYTEXT	;different input, go!
;
GKEYLP	CALL	INKEY		;check for a key
	RET	NZ		;return if we have one
	LD	A,2		;get flash count
FCNT1	EQU	$-1
	DEC	A		;less this pass
	LD	(FCNT1),A	;put it back
	JR	NZ,GKEYLP	;continue if not time
;
	LD	A,2		;get original count
FLASH2	EQU	$-1
	LD	(FCNT1),A	;re-initialize counter
	LD	A,0		;get set/reset
FCNT2	EQU	$-1
	XOR	1		;reverse bit 0
	LD	(FCNT2),A	;put it back
	JR	NZ,KESET	;turn on the dot if on
	CALL	VRESET		;turn it off
	JR	GKEYLP		;continue
;
;	turn on pixel at current cursor
;
KESET	CALL	VSET		;turn it on
	JR	GKEYLP		;continue scanning
;
;	turn off pixel at current cursor
;
VRESET	LD	HL,$VIDEO	;start video memory
	LD	(BUFPTR),HL	;do it on video
	CALL	RESET		;turn it off
	LD	HL,VBUFF	;start video buffer
	LD	(BUFPTR),HL	;restore it
	RET			;done
;
;	set pixel at current cursor location
;
VSET	LD	HL,$VIDEO	;start video memory
	LD	(BUFPTR),HL	;pass to SET/RESET
	CALL	SET		;set the pixel
	LD	HL,VBUFF	;start video buffer
	LD	(BUFPTR),HL	;reset pointer
	RET			;done!
;
;	SET/RESET/POINT - pixel manipulation
;
SET	LD	A,0C6H		;SET x,(HL) opcode
	JR	TEST10		;go common
;
POINT	LD	A,46H		;BIT x,(HL) opcode
	JR	TEST10		;go common
;
RESET	LD	A,86H		;RES x,(HL) opcode
;
TEST10	LD	(INST+1),A	;pass opcode
	LD	D,(IY+4)	;get column
	LD	E,(IY+5)	;get row
DOSET	CALL	SIZFIX		;adjust pointer
;
;	check that point is horizontally in boundary
;
	LD	A,E		;get column
	INC	H		;adjust for compare
	CP	H		;at max?
	RET	NC		;abort if beyond
	LD	A,D		;get row
;
	PUSH	BC		;save
	LD	B,-1		;init
LOOPX	INC	B		;bump row #
	SUB	3		;less # pixels / row
	JP	P,LOOPX		;go if not found
	ADD	A,3		;re-add last subtract
	ADD	A,A		;*2
	LD	C,A		;save result
	LD	L,B		;get column
	LD	H,0		;HL = row * 3
	LD	B,6		;6 graphic bits / byte
LOOPY	ADD	HL,HL		;*2
	DJNZ	LOOPY		;go for count
	LD	D,0		;init offset
	SRL	E		;check if odd/even
	JR	NC,LOOPZ	;go if even
	INC	C		;shift test bit
LOOPZ	ADD	HL,DE		;HL = video offset
	LD	DE,VBUFF	;start video buffer
BUFPTR	EQU	$-2
	ADD	HL,DE		;HL => current byte
	SLA	C		;align bit => opcode
	SLA	C
	SLA	C
	LD	A,(INST+1)	;get opcode
	ADD	A,C		;combine with bit #
	LD	(INST+1),A	;update instruction
	POP	BC		;restore stack
	BIT	6,(IY+0)	;single/double wide?
	JR	Z,INST		;go if single
;
;	double wide video, keep row, double column number
;
	LD	A,L		;get LSB offset
	EX	AF,AF'		;save here also
	LD	A,L		;fetch again for work
	AND	0C0H		;keep row offset
	LD	L,A		;update
	EX	AF,AF'		;get original back
	AND	3FH		;get column offset
	ADD	A,A		;*2
	OR	L		;merge with row offset
	LD	L,A		;have double size now
;
INST	DEFB	0CBH		;SET/RESET/BIT x,(HL)
	DEFB	0
	NOP
	SET	7,(HL)		;assure a graphic char
	NOP
	RES	6,(HL)		;standard graphics
	NOP
	RET			;done!
;
;	alter flash rate delays
;
FLASH	LD	A,(FLASH1)	;get text flash
	ADD	A,'0'		;make it ascii
	LD	(TFLASH),A	;save into text
	LD	A,(FLASH2)	;get graphic flash
	ADD	A,'0'		;make it ascii
	LD	(GFLASH),A	;save into text
	LD	HL,FMSG1	;flash message graphic
	CALL	ASKFLS		;ask for it
	JR	Z,GFL2		;go if no input
	LD	(FLASH2),A	;else update flash
;
GFL2	LD	HL,FMSG2	;text flash prompt
	CALL	ASKFLS		;get user input
	JP	Z,RESUME	;go if nil input
	LD	(FLASH1),A	;else update graph flash
	JP	RESUME		;continue
;
;	prompt user for flash delay
;
ASKFLS	CALL	PRINT		;display message
	LD	B,1		;1 char input
	CALL	GETSTR		;get from keyboard
	RET	Z		;go if nil input
	SUB	'1'		;test 1-9
	JR	C,FIXFLS	;go if out of range
	CP	9		;1-9?
	JR	NC,FIXFLS	;go if out of range
	INC	A		;adjust for 1-9
	RET			;A = flash rate
;
;	abort flash command back to draw mode
;
FIXFLS	JP	RESUME		;continue
;
