; pdraw2/asm - kjw/bqsd - revised 04/22/83
;
;	toggle single/double wide video
;
VIDEO	BIT	6,(IY+0)	;check for size
	JR	NZ,GOVIDEO	;go if at double wide
;
;	change from single wide => double wide
;	assure that horiz positions are EVEN!
;
	RES	0,(IY+5)	;set EVEN horiz graphic
	RES	0,(IY+7)	;set EVEN horiz text
	LD	A,(IY+5)	;get horiz graphic
	BIT	7,(IY+0)	;text mode?
	JR	Z,VIDE1		;go if graphic
	LD	A,(IY+7)	;else get horiz text
;
;	check that cursor will lie in left half of video
;
VIDE1	INC	A		;adjust for compare
	CP	L		;compare to max edge
	JR	C,GOVIDEO	;don't adjust if in range
	LD	A,30		;set at right side
	LD	(IY+7),A	;set text position
	LD	A,62		;set at right side
	LD	(IY+5),A	;set graphic position
;
GOVIDEO	LD	A,(IY+0)	;get size flag
	XOR	40H		;reverse bit 6
	OR	20H		;set video update flag
	LD	(IY+0),A	;put it back
	JP	RESUME		;re-draw it
;
;	reverse grid mode
;
GRID	LD	A,(IY+0)	;get grid flag
	XOR	8		;reverse bit 3
	SET	5,A		;set updated screen
	LD	(IY+0),A	;update flags
	JP	RESUME		;continue
;
;	display grid to video buffer
;
DOGRID	LD	HL,$VIDEO	;start video memory
	LD	(BUFPTR),HL	;where to set the points
	LD	IX,GRDTBL1	;grid table double wide
	BIT	6,(IY+0)	;double wide video?
	JR	NZ,GRIDLP	;go if yes
	LD	IX,GRDTBL2	;grid table single wide
;
GRIDLP	LD	D,(IX+0)	;get horiz MSB
	LD	E,(IX+1)	;get horiz LSB
	INC	D		;D= -1 terminator?
	RET	Z		;yes, go!
	DEC	D		;adjust back
;
	LD	A,0C6H		;SET x,(HL) opcode
	LD	(INST+1),A	;pass into SET code
	CALL	DOSET		;turn on pixel
	INC	IX		;bump table
	INC	IX		;2 byte entries
	JR	GRIDLP		;go next entry
;
;	set SKIP mode
;
SKIP	RES	0,(IY+0)	;reset draw mode
	RES	1,(IY+0)	;reset erase mode
	JR	SCOMM		;continue
;
;	set ERASE mode
;
ERASE	RES	0,(IY+0)	;reset draw mode
	SET	1,(IY+0)	;set erase mode
	JR	SCOMM		;continue
;
;	set DRAW mode
;
DRAW	SET	0,(IY+0)	;set draw mode
	RES	1,(IY+0)	;reset erase mode
;
SCOMM	CALL	DRAWIT		;display it
	JP	RESUME		;continue
;
;	toggle trace update mode
;
TRACE	LD	A,(IY+0)	;get flag
	XOR	10H		;reverse bit 4
	SET	5,A		;set update flag
	LD	(IY+0),A	;update flags
	JP	RESUME		;continue
;
;	watch memory buffers
;
WATCH	BIT	6,(IY+0)	;double size?
	JP	NZ,RESUME	;cancel if yes
;
	LD	HL,WATMSG	;delay prompt text
	CALL	PRINT		;display prompt
	LD	B,3		;3 char input
	CALL	GETSTR		;get from keyboard
	SET	1,(IY-1)	;set KEY mode
	JR	Z,DOWATCH	;go if nil input
	CALL	VALUE		;else fetch input value
	JP	C,RESUME	;invalid, abort!
	LD	A,C		;get LSB value
	LD	(DLYNUM),A	;save it
	RES	1,(IY-1)	;set TIME mode
;
DOWATCH	LD	HL,BFTABLE	;start of table
	LD	B,(IY+1)	;# memory buffers
	LD	C,1		;current buffer to disply
	SET	5,(IY+0)	;re-draw video when done
;
WATCHLP	LD	A,(HL)		;fetch buffer flag
	CP	_ACTBUF		;active buffer?
	JR	NZ,WATNXT	;skip this one if not!
;
	PUSH	HL		;save table pointer
	PUSH	BC		;save count/position
	LD	HL,VBUFF	;start stored buffers
	LD	DE,$VIDLEN	;length of buffer
	LD	A,C		;get buffer number
WATLP	ADD	HL,DE		;add offset to next buff
	DEC	C		;less buffer #
	JR	NZ,WATLP	;position to area
;
;	HL => current stored buffer
;
	LD	B,D		;pass video length to BC
	LD	C,E		;BC = video length
	LD	DE,$VIDEO	;start video memory
	LDIR			;move buffer to video
	NOP
	CALL	ASCII		;convert buff # to ascii
	LD	($VIDEO+$TCOLS-2),BC ;where to put on vid
	NOP
	POP	BC		;restore counters
	POP	HL		;restore buffer pointer
	BIT	1,(IY-1)	;KEY/DELAY mode?
	JR	NZ,WAT1		;go if KEY mode
;
;	wait for specified delay
;
	LD	A,0		;get counter
DLYNUM	EQU	$-1
	PUSH	BC		;save counter/pointer
;
DLYGO	LD	BC,2000H	;delay count
	PUSH	AF		;save loop counter
	CALL	@DELAY		;countdown BC till 0
	POP	AF		;restore looper
	DEC	A		;less this delay
	JR	NZ,DLYGO	;go for specified loops
	POP	BC		;restore counter/pointer
	JR	WATNXT		;go next buffer
;
;	wait for all keys to be released
;
WAT1	LD	A,($KBDR7-1)	;read all key rows
	OR	A		;any keys pressed?
	JR	NZ,WAT1		;wait till ALL released
;
;	wait for SPACEBAR to continue
;
WAT2	LD	A,($KBDR6)	;now wait till spacebar
	AND	80H		;spacebar?
	JR	Z,WAT2		;wait here if not
;
;	check for BREAK key to abort WATCH mode
;
WATNXT	LD	A,($KBDR6)	;read keyboard
	AND	4		;BREAK key?
	JP	NZ,RESUME	;abort WATCH if yes
	INC	HL		;else bump buffer table
	INC	C		;bump buffer number
	DJNZ	WATCHLP		;go for buffer count
	JP	RESUME		;re-draw screen and cont
;
;	clear video, must be pressed TWICE
;	this is to prevent accidental loss of drawing
;
CLEAR	CALL	KEY		;scan keyboard
	CP	'C'+_CTL	;control C?
	JP	NZ,RESUME	;cancel routine if not
	CALL	CLRBUFF		;zero the buffer
	JP	RESUME		;redraw and continue
;
;	'special' key
;
SPECIAL	BIT	7,(IY+0)	;check for text entry
	JP	Z,LOOP		;non valid in graphics
;
	LD	HL,$VIDEO+$VIDLEN-$TCOLS
	LD	($CURSOR),HL	;set cursor to last row
	LD	HL,AREAMG1	;special key prompt
	BIT	5,(IY-1)	;MOD III?
	JR	Z,UR01		;go if mod I
	LD	HL,AREAMG3	;special prompt mod III
;
UR01	CALL	PRINT		;display prompt text
	CALL	KEYWT		;get a key
	CALL	UCASE		;make upper case
	LD	(IY+8),A	;save this key
	LD	HL,($CURSOR)	;get cursor
	LD	(HL),A		;put char on video
	NOP
	CALL	INCHL		;bump HL to next posit
	LD	($CURSOR),HL	;update cursor
	CALL	KEYWT		;get next key
	CALL	UCASE		;make upper case
	LD	(IY+9),A	;save it here
	LD	HL,($CURSOR)	;get cursor
	LD	(HL),A		;display char
	NOP
	CALL	INCHL		;bump to next posit
	LD	($CURSOR),HL	;update cursor
	LD	HL,ACTMSG1	;action msg (graphic)
	CALL	PRINT		;display it
	CALL	KEYWT		;wait for a key
	CALL	UCASE		;make upper case
	LD	(IY+10),A	;save it
	LD	HL,($CURSOR)	;get cursor posit
	LD	(HL),A		;char to video
	NOP
	CALL	INCHL		;bump pointer
	LD	($CURSOR),HL	;update new cursor
;
AREANXT	CALL	SIZFIX2		;load HL with max val's
	LD	A,L		;get max bottom boundary
	LD	(IY+15),A	;max bottom
	LD	A,H		;get max right boundary
	LD	(IY+13),A	;max right
	XOR	A		;load zero
	LD	(IY+12),A	;max left
	LD	(IY+14),A	;max top
	LD	A,(IY+8)	;get first indicator
	CALL	SETARR		;setup arrows
	JP	NXAREA		;continue
;
;	setup area parameters
;
SETARR	CALL	ADJARR		;adjust arrows
	CP	_UARR		;up arrow?
	JR	Z,ARUP
	CP	_DARR		;down arrow?
	JR	Z,ARDN
	CP	_LARR		;left arrow?
	JR	Z,ARLF
	CP	_RARR		;right arrow?
	JR	Z,ARRT
	JP	RESUME		;invalid entry, abort!
;
ARRT	LD	A,(IY+5)	;get horizontal graphic
	BIT	7,(IY+0)	;text entry?
	JR	Z,QBZ1		;go if not
	LD	A,(IY+7)	;get horiz text
QBZ1	LD	(IY+12),A	;set left boundry
	RET			;done
;
ARLF	LD	A,(IY+5)	;get horizontal graphic
	BIT	7,(IY+0)	;text mode?
	JR	Z,QBZ2		;go if not
	LD	A,(IY+7)	;get horiz text
QBZ2	LD	(IY+13),A	;set max right
	RET			;done
;
ARDN	LD	A,(IY+4)	;get vertical graphic
	BIT	7,(IY+0)	;text mode?
	JR	Z,QBZ3		;go if not
	LD	A,(IY+6)	;get vert text
QBZ3	LD	(IY+14),A	;save lower bound
	RET			;done
;
ARUP	LD	A,(IY+4)	;get vert graphic
	BIT	7,(IY+0)	;text mode?
	JR	Z,QBZ4		;go if not
	LD	A,(IY+6)	;get vert text
QBZ4	LD	(IY+15),A	;top boundry
	RET			;done!
;
;	area defined, determine action to be taken
;
NXAREA	LD	A,(IY+9)	;second area
	CP	'A'		;all?
	JR	Z,CNTAREA	;have the area
	CP	'L'		;set a line?
	JR	Z,SETLINE	;have the area
	CALL	SETARR		;setup arrows area
	JR	CNTAREA		;continue
;
;	setup for line action
;
SETLINE	LD	A,(IY+8)	;get first area
	CP	_UARR		;up arrow?
	JR	Z,VSETUP	;setup for vertical
	CP	_DARR		;down arrow?
	JR	Z,VSETUP	;setup for vertical
	LD	A,(IY+6)	;get vertical
	LD	(IY+14),A	;pass as horiz
	LD	(IY+15),A	;pass as horiz
	JR	CNTAREA	;continue
;
;	setup for vertical line
;
VSETUP	LD	A,(IY+7)	;get horiz
	LD	(IY+12),A	;pass as vertical
	LD	(IY+13),A	;pass as vertical
;
;	compute command action
;
CNTAREA	LD	A,(IY+10)	;get action key
	JR	AREATXT		;do it in text
;
;	adjust arrow keys
;
ADJARR	CP	_SUARR		;shifted arrow?
	RET	C		;nope, resume
	CP	_SRARR+1	;shifted arrow?
	RET	NC		;nope, resume
	ADD	A,_UARR-_SUARR	;change shift>non-shift
	RET			;A = respective arrow
;
;	evaluate action command
;
AREATXT	LD	HL,PERFILL	;fill vector
	CP	'F'		;fill?
	JR	Z,GOTPER
	LD	HL,PERREV	;reverse vector
	CP	'R'		;reverse?
	JR	Z,GOTPER
	LD	HL,PERCLR	;clear vector
	CP	'C'		;clear?
	JR	Z,GOTPER
	LD	HL,PERDUP	;duplicate vector
	CP	'D'		;duplicate character?
	JP	NZ,RESUME	;forget it if none!
;
GOTPER	LD	(PERCALL),HL	;save calling address
	LD	A,(IY+12)	;save left area
	LD	(IY+8),A	;save it here
	CALL	FIGTPOS		;get position
	LD	HL,VBUFF	;video buffer
	ADD	HL,DE		;add offset
	LD	A,(HL)		;get first char
	LD	(IY+9),A	;save it here for DUP
;
;	perform action on all chars in area
;
PERLP	LD	L,(IY+12)	;get left
	LD	H,(IY+14)	;get top
	CALL	FIGPOS		;compute position
	LD	HL,VBUFF	;start video buffer
	ADD	HL,DE		;add offset
	CALL	$		;set from above
PERCALL	EQU	$-2
	LD	A,(IY+12)	;get left
	INC	A		;bump it
	LD	(IY+12),A	;re-save it
	CP	(IY+13)		;check for bounds
	JR	Z,PERLP		;go if the same
	JR	C,PERLP		;or less
	LD	A,(IY+8)	;restore value
	LD	(IY+12),A	;starting position
	LD	A,(IY+14)	;get vertical
	INC	A		;bump this
	LD	(IY+14),A	;re-save it
	CP	(IY+15)		;check for bounds
	JR	Z,PERLP		;go if the same
	JR	C,PERLP		;or less
	JP	RESUME		;done now, continue
;
;	perform FILL operation
;
PERFILL	LD	(HL),191	;all bits on
	NOP
	RET			;done
;
;	perform REVERSE operation
;
PERREV	LD	A,(HL)		;grahics?
	NOP
	OR	A		;graphic bit on?
	RET	P		;don't do if not
	XOR	3FH		;reverse graphic char
	LD	(HL),A		;re-display it
	NOP
	RET			;done!
;
;	perform CLEAR operation
;
PERCLR	LD	(HL),80H	;all bits off
	NOP
	RET			;done!
;
;	perform DUPLICATE operation
;
PERDUP	LD	A,(IY+9)	;get duplicate byte
	LD	(HL),A		;display it
	NOP
	RET			;done!
;
;	terminate program back to DOS
;	force key to be pressed TWICE to prevent
;	accidental loss of video
;
QUIT	CALL	KEY		;wait for a key
	CP	'Q'+_CTL	;quit AGAIN?
	JP	NZ,RESUME	;nope, abort to pdraw
	LD	HL,QUITMSG	;exit message
	CALL	PRINT		;display it
;
;	drain all keys in case of type-ahead buffer
;
DRN2	CALL	@KBCHAR		;scan keyboard
	OR	A		;any keys?
	JR	NZ,DRN2		;go if yes
	CALL	@KBCHAR		;just to be sure
	LD	SP,(STACK)	;reset stack to entry
	XOR	A		;load ZERO
	RET			;back to DOS!
;
;	clear video buffer
;
CLRBUFF	LD	HL,VBUFF	;start video buffer
	LD	DE,VBUFF+1	;start +1
	LD	BC,$VIDLEN-1	;length -1
	LD	(HL),80H	;graphic "spaces"
	LDIR			;fill buffer
	NOP
	SET	5,(IY+0)	;new data for re-draw
	RET			;done, go!
;
;	reverse pixels on video
;
REVERSE	LD	HL,VBUFF	;start video buffer
	LD	BC,$VIDLEN	;length of video
;
REVLP	LD	A,(HL)		;get a byte from buffer
	NOP
	OR	A		;graphic char?
	JP	P,REVNXT	;skip if not!
	XOR	3FH		;reverse low 6 bits
	LD	(HL),A		;put it back in buffer
	NOP
;
REVNXT	INC	HL		;bump buffer pointer
	DEC	BC		;less counter
	LD	A,B		;any more?
	OR	C		;BC = 0000?
	JR	NZ,REVLP	;go if more to do
	SET	5,(IY+0)	;new data, re-draw video
	JP	RESUME		;re-draw and continue
;
;	move video buffer to actual video
;
PUTBUFF	BIT	5,(IY+0)	;buffer has new data?
	RET	Z		;forget if not!
;
	BIT	5,(IY-1)	;check for Mod I or III
	JR	NZ,PUTIII	;go if mod III
;
;	select video size mod I
;
	BIT	6,(IY+0)	;check size
	LD	A,00000000B	;64 char select bit
	JR	Z,PUTI		;go if single wide
	LD	A,00001000B	;32 char select bit
PUTI	OUT	($VSEL1),A	;select video size
	JR	PUTCONT		;continue
;
;	select video size mod III/max
;
PUTIII	PUSH	HL		;save HL
	LD	HL,0000H	;ROM address
	LD	A,(HL)		;get a byte
	CPL			;reverse bits
	LD	(HL),A		;update
	CP	(HL)		;still there?
	CPL			;adjust back
	LD	(HL),A		;update
	POP	HL		;restore video
	JR	Z,PUTMAX	;setup for MAX
;
	BIT	6,(IY+0)	;get size
	LD	A,00110000B	;64 char select bits
	JR	Z,PUTIIIX	;go if single wide
	LD	A,00110100B	;32 char select bits
PUTIIIX	OUT	($VSEL3),A	;select video size
	JR	PUTCONT		;continue
;
PUTMAX	BIT	6,(IY+0)	;get size
	LD	A,($VSELM)	;get current settings
	RES	3,A		;set 64 char
	JR	Z,PUTMAXX	;go if yes
	SET	3,A		;set 32 char
PUTMAXX	LD	($VSELM),A	;set video size
;
PUTCONT	JP	Z,PUTSNG	;do it LDIR if 64 char
;
;	double wide video, load only every other char
;
	LD	HL,VBUFF	;start video buffer
	LD	DE,$VIDEO	;start video memory
	LD	B,$TROWS	;16 lines to do
;
PUTLPO	LD	C,$TCOLS/2	;32 chars / line
	PUSH	HL		;save buff pointer
	PUSH	DE		;save video pointer
;
PUTLPI	LD	A,(HL)		;get data byte
	LD	(DE),A		;to the video
	NOP
	INC	HL		;bump buffer
	INC	DE		;bump video twice
	INC	DE		;for double wide
	DEC	C		;do this line
	JR	NZ,PUTLPI	;continue
	POP	DE		;get start pointers back
	POP	HL
	PUSH	BC		;save count
	LD	BC,$TCOLS	;next line
	ADD	HL,BC		;add to buffer
	EX	DE,HL		;swap for math
	ADD	HL,BC		;add to video
	EX	DE,HL		;swap back
	POP	BC		;restore row counter
	DJNZ	PUTLPO		;continue 16 rows
;
RESPUT	RES	5,(IY+0)	;data updated
	BIT	3,(IY+0)	;grid ON?
	CALL	NZ,DOGRID	;display if yes
	BIT	4,(IY+0)	;"trace" ON?
	RET	Z		;go if not
;
;	display current cursor location
;
	LD	HL,$VIDEO+57	;place here single wide
	BIT	6,(IY+0)	;check video flag
	JR	Z,TRSNG		;go if single wide
	LD	L,50		;double wide start
;
TRSNG	LD	DE,GXMSG	;text table (8 bytes)
	LD	A,_SPACE	;space
	BIT	7,(IY+0)	;text entry?
	JR	NZ,TRSGG	;go if yes
	LD	A,'>'		;else set pointer
TRSGG	EX	AF,AF'		;store it here
	LD	A,(IY+5)	;graphic horizontal
	CALL	PUTRACE		;display it
	LD	A,(IY+4)	;graphic vertical
	CALL	PUTRACE		;display it
	LD	A,_SPACE	;space
	BIT	7,(IY+0)	;text entry?
	JR	Z,TRSGY		;go if not
	LD	A,'>'		;else set pointer
TRSGY	EX	AF,AF'		;save pointer char
	LD	A,(IY+7)	;text horizontal
	CALL	PUTRACE		;to video
	LD	A,(IY+6)	;text vertical
;
PUTRACE	PUSH	HL		;save video start
	PUSH	AF		;save value
	EX	AF,AF'		;get "active" symbol
	LD	(HL),A		;display it to video
	NOP
	EX	AF,AF'		;re-save it
	CALL	INCHL		;point to next posit
	LD	A,(DE)		;get string byte
	INC	DE		;bump it
	LD	(HL),A		;display it
	NOP
	CALL	INCHL		;bump HL
	LD	A,(DE)		;get 2nd string byte
	INC	DE
	LD	(HL),A		;display it
	NOP
	CALL	INCHL		;bump HL
	LD	(HL),'='	;right arrow
	NOP
	CALL	INCHL		;bump it
	POP	AF		;restore character
	CALL	ASCII		;convert to decimal ascii
	LD	(HL),A		;display it
	NOP
	CALL	INCHL		;bump video pointer
	LD	(HL),C		;NSB
	NOP
	CALL	INCHL		;bump pointer
	LD	(HL),B		;on screen now
	NOP
	POP	HL		;restore original
	LD	BC,$TCOLS	;next line down
	ADD	HL,BC		;point to it
	RET			;done
;
;	increment HL for single/double wide
;
INCHL	INC	HL		;bump video
	BIT	6,(IY+0)	;double wide?
	RET	Z		;skip if not
	INC	HL		;else bump again
	RET			;HL => next position
;
;	capture current video => video buffer
;
CAPTURE	LD	HL,$VIDEO	;start video memory
	LD	DE,VBUFF	;video display buffer
	LD	BC,$VIDLEN	;length of video
	LDIR			;move video => buffer
	NOP
	SET	5,(IY+0)	;set buffer updated
	RET			;done!
;
;	enable alt I/O bus on Mod III
;
SETPRTS	PUSH	AF		;save flag
	LD	A,00110000B	;vid wait,ex bus, alt set
	OUT	($VSEL3),A	;setup port
	POP	AF		;restore flag
	RET			;done!
;
