; pdraw1/asm - kjw/bqsd - revised 05/20/83
;
;	program entry point
;
ENTRY	JP	BEGIN		;go program start
;
;	system data block (IY => here)
;
FGBYTE	DEFB	0,0,0		;flags/pointer
;
	DEFB	0		;system flag #-1
; bit 7 = 1 = tape vs disk
; bit 6 =
; bit 5 = 1 = Mod III vs Mod I
; bit 4 =
; bit 3 = 1 = saving vs loading
; bit 2 =
; bit 1 =
; bit 0 =
;
SYSTEM	DEFB	0		;system flag #1
; bit 7 = 1 = text entry mode
; bit 6 = 1 = double wide mode
; bit 5 = 1 = buffer contains data not updated to video
; bit 4 = 1 = "trace" mode ON
; bit 3 = 1 = grid mode ON
; bit 2 = 1 = solid angles
; bit 1 = 1 = erase mode
; bit 0 = 1 = draw mode
	DEFB	0		;+1, # memory buffers
	DEFB	1		;+2, horizontal speed
	DEFB	1		;+3, vertical speed
	DEFW	0		;+4+5, graphic mode posit
	DEFW	0		;+6+7, text mode position
	DEFW	0		;+8+9, temp storage
	DEFB	0		;+10 temp
	DEFB	0		;+11 temp
	DEFB	0		;+12 temp
	DEFW	0		;+13+14, temp
	DEFW	0		;+15+16, temp
	DEFW	0		;+17+18, temp
;
;	keyboard scan mask
;
MASK	DEFB	0,0,0,0,0,0,0	;keyboard mask area
;
;	clear all buffer flags
;
ZERTBL	LD	HL,BFTABLE	;start of buffer table
	LD	DE,BFTABLE+1	;start +1
	LD	(HL),0		;99 indicates active
	LD	BC,BFTSIZE-1	;buffer table size -1
	LDIR			;clear table
	RET			;done!
;
;	program entry point
;
BEGIN	LD	IY,SYSTEM	;point to parameter table
	LD	(STACK),SP	;save stack pointer
	LD	BC,0000H	;about 1 second delay
	CALL	@DELAY		;countdown
	CALL	@DELAY		;leave graphics on video
	LD	IX,FGBYTE	;extra flag byte
	LD	(IX+0),0	;reset all bits
	DEC	HL		;adjust for command check
;
;	check for any input commands
;
POSHL	INC	HL		;bump input pointer
	LD	A,(HL)		;fetch input char
	CP	' '		;separator?
	JR	Z,POSHL		;ignore if yes
	CP	','		;separator?
	JR	Z,POSHL		;ignore if yes
	CP	_CR		;carriage return?
	JR	Z,PARSED	;terminator if yes
	CP	_ETX		;end of text?
	JR	Z,PARSED	;terminator if yes
;
;	check for 'recovery' mode
;
	CP	'*'		;recover?
	JR	Z,SETRECO	;yes, go!
;
;	assume filespec entered, save text pointer
;
	LD	(IX+1),L	;pass HL pointer
	LD	(IX+2),H
	SET	7,(IX+0)	;set filespec flag
	JR	PARSED		;continue
;
SETRECO	SET	0,(IX+0)	;set recovery flag
;
;	check if lower case available on video
;
PARSED	LD	HL,$VIDEO	;start video memory
	LD	E,(HL)		;fetch current char
	NOP
	LD	A,'a'		;lower case char
	LD	(HL),A		;move to video
	NOP
	CP	(HL)		;still there?
	NOP
	LD	(HL),E		;restore original char
	NOP
	JR	NZ,KEYS0K	;no locase, continue
;
;	lowercase available, swap key lookup tables
;
	LD	HL,KEYS2	;table 2
	LD	DE,KEYS3	;table 3
	LD	B,20H		;# keys to swap
;
EXKEY	LD	C,(HL)		;fetch a char
	LD	A,(DE)		;fetch second
	LD	(HL),A		;pass to first
	LD	A,C		;get first
	LD	(DE),A		;pass to second
	INC	HL		;bump table 2
	INC	DE		;bump table 3
	DJNZ	EXKEY		;continue for length
;
;	check if video is to be 'captured'
;
KEYS0K	LD	A,($KBDR2)	;read keyboard
	BIT	3,A		;check for 'S'
	CALL	NZ,CAPTURE	;capture video to buffer
;
;	check if 'recovery' mode key pressed
;
	BIT	0,(IX+0)	;recovery?
	JR	NZ,$+7		;go if yes
	LD	A,($KBDR2)	;read keyboard
	AND	4		;check for 'R'
	CALL	Z,ZERTBL	;clear the table if not
;
;	check if joysticks are to be used
;
	LD	A,($KBDR2)	;read keyboard
	AND	4		;check for 'J'
	CALL	NZ,ALLOWJ	;allow joystick if yes
;
;	setup flag for Mod I/III
;
	LD	A,($ROMID)	;read rom ID address
	CP	$MOD3		;Mod III?
	CALL	Z,SETPRTS	;setup ports if yes
	SET	5,(IY-1)	;set Mod III
	LD	HL,($HIMEM3)	;get top of mem III
	JR	Z,HTPMEM	;if Z, then have it
	LD	HL,($HIMEM1)	;else get top mem I
	RES	5,(IY-1)	;set Mod I
;
;	compute # of memory buffers available
;
HTPMEM	LD	(HIMEM),HL	;save high memory
	LD	DE,SBUFF	;start storage buffer
	OR	A		;clear carry flag
	SBC	HL,DE		;how much memory avail
	DEC	H		;don't use last partial
	LD	A,H		;get into A for math
	SRL	A		;divide by 2
	SRL	A		;again, 400H per buffer
	LD	(IY+1),A	;# buffers available
	BIT	0,(IX+0)	;recovery mode?
	JR	NZ,$+7		;go if yes
	LD	A,($KBDR2)	;read keyboard
	AND	12		;check for 'R'/'S' again
	CALL	Z,CLRBUFF	;keep video buff if yes
;
;	check if filespec indicated to be loaded
;
	BIT	7,(IX+0)	;filespec here?
	JP	NZ,LOAD		;load it if yes
;
;	check for space bar to keep video display
;
HALTER	LD	A,($KBDR6)	;read keyboard
	AND	80H		;pressed?
	JR	NZ,HALTER	;hold here if pressed
;
;	display menu options
;
MENU	LD	HL,MESG		;menu page
	CALL	PRINT		;display it
	CALL	FLKEY		;flash <KEY> message
;
;	redisplay memory buffer to video and wait key
;
RESUME	LD	SP,0		;reset stack
STACK	EQU	$-2
	CALL	PUTBUFF		;move buffer to video
;
;	wait for key to be pressed
;
LOOP	CALL	KEY		;wait for a key
	SET	5,(IY+0)	;buffer updated
;
;	check for screenprinter controls
;
	CP	_CR.OR._CTL	;control enter?
	JP	Z,SCRNPRT	;go if yes
	CP	_SPACE.OR._CTL	;control space?
	JP	Z,SCRNPRT	;go if yes
;
;	normal key interpretation
;
	BIT	7,(IY+0)	;text entry mode?
	JR	Z,NOTTXT	;nope if not set
	CP	_CTL		;check for control key
	JP	C,TEXTEN	;to video if not control
;
;	interpret control command
;
NOTTXT	AND	_CTL.XOR.-1	;remove control bit
	CALL	UCASE		;make it upper case
	CP	'G'		;get file?
	JP	Z,LOAD
	CP	'P'		;put file?
	JP	Z,SAVE
	CP	'B'		;buffer control?
	JP	Z,DOBUFF
	CP	'A'		;angle control?
	JP	Z,ANGLES
	CP	'T'		;text mode?
	JP	Z,TEXTCHG
	CP	'R'		;reverse video
	JP	Z,REVERSE
	CP	'S'		;set skip mode?
	JP	Z,SKIP
	CP	'D'		;set draw mode?
	JP	Z,DRAW
	CP	'E'		;set erase mode?
	JP	Z,ERASE
	CP	'M'		;display menu?
	JP	Z,MENU
	CP	'?'		;buffer display?
	JP	Z,PMETER
	CP	'/'		;buffer display?
	JP	Z,PMETER
	CP	'F'		;set flash speed?
	JP	Z,FLASH
	CP	'C'		;clear video?
	JP	Z,CLEAR
	CP	'V'		;reverse video size?
	JP	Z,VIDEO
	CP	'Q'		;quit to DOS?
	JP	Z,QUIT
	CP	_UARR		;cursor up?
	JP	Z,UARROW
	CP	_DARR		;cursor down?
	JP	Z,DARROW
	CP	_LARR		;cursor left?
	JP	Z,LARROW
	CP	_RARR		;cursor right?
	JP	Z,RARROW
	CP	_SUARR		;cursor up fast?
	JP	Z,SUARROW
	CP	_SDARR		;cursor down fast?
	JP	Z,SDARROW
	CP	_SLARR		;cursor left fast?
	JP	Z,SLARROW
	CP	_SRARR		;cursor right fast?
	JP	Z,SRARROW
	CP	'I'		;cursor up/left?
	JP	Z,LUARROW
	CP	'K'		;cursor down/left?
	JP	Z,LDARROW
	CP	'O'		;cursor up/right?
	JP	Z,RUARROW
	CP	'L'		;cursor down/right?
	JP	Z,RDARROW
	CP	'@'		;special key?
	JP	Z,SPECIAL
	CP	'`'		;special key?
	JP	Z,SPECIAL
	CP	'W'		;watch buffers?
	JP	Z,WATCH
	CP	'U'		;toggle 'trace' mode?
	JP	Z,TRACE
	CP	'J'		;toggle 'grid' mode?
	JP	Z,GRID
	CP	'X'		;horizontal reverse?
	JP	Z,REVVID
	CP	'Y'		;vertical reverse?
	JP	Z,REVVID2
	CP	'Z'		;move video?
	JP	Z,MOVVID
	CP	'H'		;home cursor?
	JR	Z,HOME
	CP	'N'
	JP	Z,DUBREV	;reverse right/left?
	RES	5,(IY+0)	;buffer not updated
	JP	LOOP		;invalid key, continue
;
;	home cursor to 0,0
;
HOME	XOR	A		;load zero
	LD	(IY+4),A	;graphic cursor posit
	LD	(IY+5),A
	LD	(IY+6),A	;text cursor posit
	LD	(IY+7),A
	SET	5,(IY+0)	;buffer updated
	JP	RESUME		;continue
;
;	text entry mode, check for motion keys
;
TEXTEN	CP	_SUARR		;cursor up fast?
	JP	Z,SUARROW
	CP	_SDARR		;cursor down fast?
	JP	Z,SDARROW
	CP	_SLARR		;cursor left fast?
	JP	Z,SLARROW
	CP	_SRARR		;cursor right fast?
	JP	Z,SRARROW
	CP	_UARR		;cursor up?
	JP	Z,UARROWX
	CP	_DARR		;cursor down?
	JP	Z,DARROWX
	CP	_LARR		;cursor left?
	JP	Z,LARROWX
	CP	_RARR		;cursor right?
	JP	Z,RARROWX
	CP	_SSPACE		;shift space?
	JR	NZ,TEXTRET	;go if not
	LD	A,191		;change to block if yes
;
;	load text char to video
;
TEXTRET	PUSH	AF		;save character
	LD	A,(IY+0)	;fetch size flag
	PUSH	AF		;save on stack
	RES	6,(IY+0)	;force non-adjust for buf
	CALL	FIGTPOS		;compute the position
	POP	AF		;restore size
	LD	(IY+0),A	;put it back
	POP	AF		;restore character
;
	LD	HL,VBUFF	;start video buffer
	ADD	HL,DE		;point to position
	LD	(HL),A		;put it in buffer
	SET	5,(IY+0)	;buffer has new data
	JP	RARROWX		;go next position
;
;	toggle text/graphic mode
;
TEXTCHG	LD	A,(IY+0)	;get text flag
	XOR	80H		;reverse bit 7
	LD	(IY+0),A	;put it back
	JP	RESUME		;continue
;
;	compute video sizes
;
SIZFIX	BIT	6,(IY+0)	;get video size flag
	LD	HL,127<8+63	;H=graphic / L=text
	RET	Z		;go if size wide
	LD	HL,64<8+32	;half value (must be even
	RET			;done
;
;	compute video sizes
;
SIZFIX2	BIT	7,(IY+0)	;text entry?
	JR	Z,SIZFIX	;go if graphics mode
;
	LD	HL,63<8+15	;max size text entry
	BIT	6,(IY+0)	;get video size flag
	RET	Z		;go if single wide
	LD	HL,30<8+15	;else set double wide
	RET			;done!
;
;	shifted left arrow key
;
SRARROW	CALL	DORARR		;do it
	CALL	DORARR		;again
	CALL	DORARR		;real fast
	JP	RESUME		;continue
;
;	right arrow
;
RARROW	BIT	7,(IY+0)	;text mode?
	JP	NZ,TEXTRET	;go if yes!
;
;	right arrow in graphic mode
;
RARROWX	CALL	DORARR		;move single pixel
	JP	RESUME		;continue
;
DORARR	SET	5,(IY+0)	;new buffer data
	CALL	SIZFIX		;get max values
	LD	A,H		;get horizontal
	LD	(RFIX1),A	;pass it
	LD	A,L		;get vertical
	LD	(RFIX2),A	;pass it
	BIT	7,(IY+0)	;text entry ?
	JR	NZ,RTEXT	;move text if yes
	LD	A,(IY+5)	;get horiz position
	CP	127		;compare for last posit
RFIX1	EQU	$-1		;set from above
	JR	NZ,XXYY1	;go if not
	LD	A,-1		;else setup for wrap
XXYY1	INC	A		;bump position
	LD	(IY+5),A	;put it back
	JP	DRAWIT		;draw the new spot
;
;	right arrow in text mode
;
RTEXT	LD	A,(IY+7)	;horiz text position
	CP	63		;at end?
RFIX2	EQU	$-1
	JR	NZ,XXYY2	;go if not
	LD	A,-1		;else setup for wrap
XXYY2	INC	A		;move one more
RCFIX	LD	(IY+7),A	;update new spot
	RET			;done!
;
;	shift left arrow key
;
SLARROW	CALL	DOLARR		;once
	CALL	DOLARR		;twice
	CALL	DOLARR		;thrice
	JP	RESUME		;continue
;
;	left arrow key
;
LARROW	BIT	7,(IY+0)	;text mode?
	JP	NZ,TEXTRET	;go if yes
;
LARROWX	CALL	DOLARR		;move cursor left
	JP	RESUME		;continue
;
;	left arrow motion
;
DOLARR	SET	5,(IY+0)	;updated buffer
	BIT	7,(IY+0)	;text entry?
	JR	NZ,LTEXT	;go if yes!
;
;	move cursor left in graphic mode
;
	LD	A,(IY+5)	;get horiz posit
	OR	A		;at left now?
	JR	NZ,XXYY3	;go if not
	CALL	SIZFIX		;get size params
	LD	A,H		;get max horiz
	INC	A		;setup for wrap
XXYY3	DEC	A		;move left
	LD	(IY+5),A	;update horiz posit
	JP	DRAWIT		;draw new position
;
;	cursor left in text mode
;
LTEXT	LD	A,(IY+7)	;fetch horiz posit
	OR	A		;at left side?
	JR	NZ,XXYY4	;go if not
	CALL	SIZFIX		;get max size
	LD	A,L		;get text result
	INC	A		;setup for wrap
XXYY4	DEC	A		;move cursor left
	LD	(IY+7),A	;update horiz posit
	RET			;done!
;
;	angle commands
;
RUARROW	LD	HL,DORARR	;right
	LD	DE,DOUARR	;up
	JR	ACOMM		;go common
;
RDARROW	LD	HL,DORARR	;right
	LD	DE,DODARR	;down
	JR	ACOMM		;go common
;
LUARROW	LD	HL,DOLARR	;left
	LD	DE,DOUARR	;up
	JR	ACOMM		;go common
;
LDARROW	LD	HL,DOLARR	;left
	LD	DE,DODARR	;down
;
ACOMM	LD	(CAL1),HL	;pass vector 1
	LD	(CAL2),DE	;pass vector 2
;
;	save flags / check for solid/dotted draw
;
	LD	A,(IY+0)	;fetch flags
	PUSH	AF		;save on stack
	BIT	2,(IY+0)	;solid?
	JR	Z,AXLP		;continue if yes
	AND	0FCH		;mask out low 2 bits
	LD	(IY+0),A	;update flags
;
AXLP	LD	A,(IY+2)	;get horiz speed
ACLOOP	PUSH	AF		;save count
	CALL	$		;horizontal call
CAL1	EQU	$-2
	POP	AF		;restore count
	DEC	A		;less this call
	JR	NZ,ACLOOP	;go for count
	LD	A,(IY+3)	;get vertical speed
AVLOOP	PUSH	AF		;save counter
	CALL	$		;vertical call
CAL2	EQU	$-2
	POP	AF		;restore count
	DEC	A		;less this call
	JR	NZ,AVLOOP	;continue for count
	POP	AF		;restore flags
	LD	(IY+0),A	;update flags
	JP	RESUME		;continue
;
;	shifted up arrow key
;
SUARROW	CALL	DOUARR		;once
	CALL	DOUARR		;twice
	CALL	DOUARR		;thrice
	JP	RESUME		;continue
;
UARROW	BIT	7,(IY+0)	;text entry?
	JP	NZ,TEXTRET	;go if yes
;
UARROWX	CALL	DOUARR		;single call
	JP	RESUME		;continue
;
;	move cursor up
;
DOUARR	SET	5,(IY+0)	;set buffer updated
	BIT	7,(IY+0)	;text mode?
	JR	NZ,UTEXT	;yes, go!
;
;	move cursor up graphic mode
;
	LD	A,(IY+4)	;get vert posit
	OR	A		;at top?
	JR	NZ,XXYY5	;go if not
	LD	A,48		;lowest graphic +1
XXYY5	DEC	A		;adjust
	LD	(IY+4),A	;update vert posit
	JP	DRAWIT		;update video
;
;	move cursor up text mode
;
UTEXT	LD	A,(IY+6)	;get vert posit
	OR	A		;at the top?
	JR	NZ,XXYY6	;go if not
	LD	A,16		;bottom veritcal +1
XXYY6	DEC	A		;move up
	LD	(IY+6),A	;update vertical
	RET			;done!
;
;	shift down arrow
;
SDARROW	CALL	DODARR		;once
	CALL	DODARR		;twice
	CALL	DODARR		;thrice
	JP	RESUME		;continue
;
;	move cursor down
;
DARROW	BIT	7,(IY+0)	;text mode?
	JP	NZ,TEXTRET	;go if yes!
;
;	down
;
DARROWX	CALL	DODARR		;move once
	JP	RESUME		;continue
;
DODARR	SET	5,(IY+0)	;set buffer updated
	BIT	7,(IY+0)	;text mode?
	JR	NZ,DTEXT	;go if yes
;
;	move cursor down in graphic mode
;
	LD	A,(IY+4)	;get vert posit
	CP	47		;at bottom?
	JR	NZ,XXYY7	;go if not
	LD	A,-1		;setup for wrap
XXYY7	INC	A		;move down
	LD	(IY+4),A	;update vert posit
	JP	DRAWIT		;update video & return
;
;	move cursor down in text mode
;
DTEXT	LD	A,(IY+6)	;get vert posit
	CP	15		;at bottom now?
	JR	NZ,XXYY8	;go if not
	LD	A,-1		;setup for wrap
XXYY8	INC	A		;move down
	LD	(IY+6),A	;update vert posit
	RET			;done!
;
;	cursor position changed, check draw/skip/erase
;
DRAWIT	LD	A,(IY+0)	;get mode
	AND	3		;SKIP?
	RET	Z		;yes, no change
;
	LD	A,(IY+0)	;get it back
	PUSH	AF		;save on stack
	BIT	1,A		;check for ERASE
	RES	6,(IY+0)	;set single wide
	JR	NZ,DRWER	;RESET pixel
	CALL	SET		;else SET pixel
	JR	DRWER+3		;continue
DRWER	CALL	RESET		;turn it off
	POP	AF		;restore flags
	LD	(IY+0),A	;replace original flags
	SET	5,(IY+0)	;buffer has changed
	RET			;done!
;
;	enable joystick operation
;
ALLOWJ	LD	HL,0		;2 NOP's
	LD	(JOYCMD),HL	;enable joystick
	RET			;done!
;
