DISK   ; DISK/ASM
 SELECT0	LD	A,D
 	CP	16H
 	LD	A,0
 	JR	C,SELECT1
 	LD	A,20H
 SELECT1	LD	(SELECT2),A
 	LD	A,(DRIV)
 	AND	0FH
 	OR	0
 SELECT2	EQU	$-1
 	OR	0		;set density
 DENSITY	EQU	$-1
 	LD	(DRIV),A
 SELECT	IN	A,(0F0H)	;read status
 	AND	80H
 	LD	A,1		;get drive bit
 DRIV	EQU	$-1
 	OUT	(0F4H),A
 	RET	Z
 	PUSH	BC
 	LD	BC,0
 	CALL	60H
 	POP	BC
 	JR	SELECT
 SEEK	CALL	SELECT0	;select drive, set den & precomp
 	CALL	GETTRK	;get track from table
 	OUT	(0F1H),A	;give to FDC
 	JR	NZ,SEEK1	;continue if not track 0
 	CALL	RESTORE		;restore to track 0
 	RET	NZ		;bad, return
 SEEK1	LD	A,D		;get track
 	OUT	(0F3H),A	;track to seek
 	LD	A,18H		;seek command
 	CALL	MOVE		;move the head
 	RET	NZ		;bad seek
 	IN	A,(0F1H)	;get track
 PUTTRK	PUSH	HL		;save this
 	LD	HL,CTRACK	;current track table
 	PUSH	AF
 	LD	A,0		;get binary drive
 DRIVE	EQU	$-1
 	ADD	A,L		;point to drive
 	LD	L,A
 	POP	AF		;get track back
 	LD	(HL),A		;put in table
 	POP	HL		;restore HL
 	LD	A,E		;set sector register
 	OUT	(0F2H),A
 	XOR	A
 	RET		;Z flag set
 RESTORE	LD	A,8	;restore command
 	CALL	MOVE
 	RET	NZ
 	CPL
 	BIT	2,A
 	RET
 MOVE	OR	0	;set step speed
 SPEED	EQU	$-1
 	OUT	(0F0H),A	;issue command to FDC
 MOVEWT	CALL	SELECT		;keep drive on
 	IN	A,(0F0H)	;read status
 	BIT	0,A		;still busy?
 	JR	NZ,MOVEWT	;wait till done
 	BIT	4,A		;not found?
 	RET			;Z flag set if OK
 STEPIN	CALL	SELECT
 	LD	A,58H
 	JP	MOVE
 FORMIT	CALL	BUILDTRK
 	LD	A,(TRACK)
 	LD	D,A
 	CALL	SELECT0
 	IN	A,(0F0H)
 	BIT	6,A
 	RET	NZ
 TRYWRTG	LD	A,10
 	LD	(FCOUNT),A
 TRYGOW	CALL	W0
 	AND	0FCH
 	RET	Z
 	EX	AF,AF'
 	LD	A,0
 FCOUNT	EQU	$-1
 	DEC	A
 	LD	(FCOUNT),A
 	JR	NZ,TRYGOW
 	EX	AF,AF'
 	RET
 DSKSLO	EX	(SP),HL
 	EX	(SP),HL
 	EX	(SP),HL
 	EX	(SP),HL
 	EX	(SP),HL
 	EX	(SP),HL
 	RET
 R1	CALL	SETNMI		;setup return vectors
 	RET	NZ
 	LD	A,80H
 	OUT	(0F0H),A
 	CALL	DSKSLO
 	LD	E,2
 R100	IN	A,(0F0H)
 	AND	E
 	JR	Z,R100
 	INI
 	LD	A,D
 R101	OUT	(0F4H),A
 	INI
 	JR	NZ,R101
 	JR	$
 W1	CALL	SETNMI
 	RET	NZ
 	LD	A,0
 TYPE	EQU	$-1
 W000	OUT	(0F0H),A
 	CALL	DSKSLO
 	LD	E,2
 WR100	IN	A,(0F0H)
 	AND	E
 	JR	Z,WR100
 	OUTI
 	LD	B,60H
 	DJNZ	$
 	LD	A,D
 WR101	OUT	(0F4H),A
 	OUTI
 	JR	WR101
 ORDNEW	PUSH	BC
 	PUSH	DE
 	PUSH	HL
 	EX	DE,HL
 	LD	B,3
 	DEC	C
 	LD	A,(DENSITY)
 	OR	A
 	JR	Z,ORDNEW1
 	LD	B,4
 ORDNEW1	PUSH	BC
 	LD	A,(HL)
 	PUSH	HL
 	INC	HL
 ORDNEW2	LD	E,(HL)
 	LD	(HL),A
 	LD	A,E
 	INC	HL
 	DEC	C
 	JR	NZ,ORDNEW2
 	POP	HL
 	LD	(HL),A
 	POP	BC
 	DJNZ	ORDNEW1
 	POP	HL
 	POP	DE
 	POP	BC
 	RET
 BUILDTRK	LD	A,(DENSITY)
 	LD	HL,ORDER
 	OR	A
 	JR	Z,GOTORD
 	LD	HL,DORDER
 	LD	A,(SIZE)
 	CP	'A'
 	JR	NZ,GOTORD
 	LD	HL,DORDER2
 GOTORD	LD	C,(HL)
 	INC	HL
 	LD	E,(HL)
 	INC	HL
 	LD	D,(HL)
 	INC	HL
 	CALL	ORDNEW
 	PUSH	DE
 	LD	DE,BUFFER
 	EX	DE,HL
 	CALL	MOVEIN
 	LD	(DESVE),DE
 SECLP	CALL	MOVEIN
 	CALL	MOVEIN
 	LD	(HL),0FEH
 	INC	HL
 	LD	A,(TRACK)
 	LD	(HL),A
 	INC	HL
 	LD	(HL),0
 	INC	HL
 	EX	(SP),HL
 	LD	A,(HL)
 	INC	HL
 	EX	(SP),HL
 	LD	(HL),A
 	INC	HL
 	LD	(HL),1
 	INC	HL
 	LD	(HL),0F7H
 	INC	HL
 	CALL	MOVEIN
 	CALL	MOVEIN
 	CALL	MOVEIN
 	LD	(HL),0F8H
 	INC	HL
 	CALL	FILLDATA
 	LD	(HL),0F7H
 	INC	HL
 	CALL	MOVEIN
 	LD	DE,0
 DESVE	EQU	$-2
 	DEC	C
 	JR	NZ,SECLP
 	INC	SP
 	INC	SP
 	DEC	DE
 	LD	A,(DE)
 	JP	FILL
 ORDER	DB	10
 	DW	ORDERS
 	DB	1FH,0FFH
 	DB	3,0
 	DB	3,0
 	DB	0BH,0FFH
 	DB	3,0
 	DB	3,0
 	DB	0BH,0FFH
 DORDER	DB	18
 	DW	ORDERD
 	DB	3EH,4EH
 	DB	0CH,0
 	DB	3,0F5H
 	DB	16H,4EH
 	DB	0CH,0
 	DB	3,0F5H
 	DB	16H,4EH
 DORDER2	DB	18
 	DW	ORDERD2
 	DB	3EH,4EH
 	DB	0CH,0
 	DB	3,0F5H
 	DB	16H,4EH
 	DB	0CH,0
 	DB	3,0F5H
 	DB	16H,4EH
 ORDERS	DB	0,5,1,6,2,7,3,8,4,9
 ORDERD	DB	1,4,7,0AH,0DH,10H,2,5,8,0BH
 	DB	0EH,11H,3,6,9,0CH,0FH,12H
 ORDERD2	DB	0,6,12,1,7,13,2,8,14
 	DB	3,9,15,4,10,16,5,11,17
 MOVEIN	LD	A,(DE)
 	INC	DE
 	LD	B,A
 	LD	A,(DE)
 	INC	DE
 FILL	LD	(HL),A
 	INC	HL
 	DJNZ	FILL
 	RET
 READ	LD	A,10
 	LD	(RCOUNT),A
 READGO	PUSH	BC
 	CALL	R1
 	POP	HL
 	AND	9CH
 	RET	Z
 	EX	AF,AF'
 	LD	B,H
 	LD	C,L
 	LD	A,0
 RCOUNT	EQU	$-1
 	DEC	A
 	LD	(RCOUNT),A
 	JR	NZ,READGO
 	EX	AF,AF'
 	RET
 WRITE	LD	A,10
 	LD	(WRCOUNT),A
 WRGO	PUSH	BC
 	CALL	W1
 	POP	HL
 	AND	0FCH
 	RET	Z
 	EX	AF,AF'
 	LD	B,H
 	LD	C,L
 	LD	A,0
 WRCOUNT	EQU	$-1
 	DEC	A
 	LD	(WRCOUNT),A
 	JR	NZ,WRGO
 	EX	AF,AF'
 	RET
 W0	CALL	SETNMI2
 	RET	NZ
 	LD	E,2
 	LD	B,3
 	LD	A,0F0H
 	LD	HL,BUFFER
 	OUT	(0F0H),A
 	CALL	DSKSLO
 WW101	LD	A,D
 	OUT	(0F4H),A
 	IN	A,(0F0H)
 	AND	B
 	JP	PO,WW101
 	OUTI
 WW102	LD	A,D
 	OUT	(0F4H),A
 	IN	A,(0F0H)
 	AND	E
 	JR	Z,WW102
 	OUTI
 	LD	A,D
 WW103	OUT	(0F4H),A
 	OUTI
 	JP	WW103
 NMIRET	RETN
 GETTRK	PUSH	HL
 	LD	HL,CTRACK
 	LD	A,(DRIVE)
 	ADD	A,L
 	LD	L,A
 	LD	A,(HL)
 	POP	HL
 	OR	A
 	RET
 SETNMI	LD	(BUFFSAVE),BC	;save buffer
 	LD	(SECSAVE),DE	;save track/sector
 	LD	H,B		;pass buffer to HL
 	LD	L,C
 	CALL	SEEK		;seek the track
 	RET	NZ		;not found
 SETNMI2	LD	A,(DRIV)	;get drive bit
 	OR	40H		;set wait state
 	LD	D,A		;save here
 	PUSH	HL
 	LD	HL,RETNMI
 	LD	(404AH),HL
 	POP	HL
 	IN	A,(0F0H)	;clear FDC latch
 	LD	BC,0F3H		;set C = data register
 	DI
 	LD	A,0C0H
 	OUT	(0E4H),A
 	XOR	A		;set OK
 	RET
 RETNMI	POP	HL		;fix the stack
 	XOR	A		;reset NMI
 	OUT	(0E4H),A	;turn it off
 	LD	DE,0		;restore track/sector
 SECSAVE	EQU	$-2
 	LD	BC,0		;restore buffer
 BUFFSAVE	EQU	$-2
 	INC	B		;bump page pointer
 	LD	HL,NMIRET	;return vector now
 	LD	(404AH),HL
 	IN	A,(0F0H)	;read status
 	LD	(RESULT),A	;save answer
 	PUSH	AF
 	LD	A,0D0H
 	OUT	(0F0H),A
 	POP	AF
 	EI
 	RET
 FILLDATA	PUSH	DE
 	LD	DE,0E5E5H
 	LD	A,(DENSITY)
 	OR	A
 	JR	Z,FILLGO
 	LD	DE,6DB6H
 FILLGO	LD	B,128
 	LD	(HL),D
 	INC	HL
 	LD	(HL),E
 	INC	HL
 	DJNZ	FILLGO+2
 	POP	DE
 	RET
 STATCK	CALL	SELECT
 	LD	BC,200H
 STAT1	DEC	BC
 	LD	A,B
 	OR	C
 	JR	Z,STATBAD
 	IN	A,(0F0H)
 	AND	2
 	JR	NZ,STAT1
 	LD	BC,4000H
 STAT2	DEC	BC
 	LD	A,B
 	OR	C
 	JR	Z,STATBAD
 	IN	A,(0F0H)
 	AND	2
 	JR	Z,STAT2
 	LD	BC,200H
 STAT3	DEC	BC
 	LD	A,B
 	OR	C
 	JR	Z,STATBAD
 	IN	A,(0F0H)
 	AND	2
 	JR	NZ,STAT3
 	XOR	A
 	RET
 STATBAD	OR	1
 	RET
