SWAPIT MEM48K	EQU	0F878H
 KBD	EQU	4016H		;KEYBOARD DEVICE ADDR.
 	ORG	MEM48K		;ORIGIN FOR 48K
 ADDR	DEFW	BASIC		;BASIC COMMAND
 BASIC	DEFM	'BASIC 45467'	;INITIALIZE BASIC
 	NOP
 	DEFB	0DH
 START	LD	HL,(KBD)	;GET OLD KBD DEVICE ADDR.
 	LD	(SKBD+1),HL	;PLUG IT INTO $-$
 	LD	HL,PATCH	;EST. PATCH
 	LD	(KBD),HL	;AS DRIVER
 	JP	402DH		;BACK TO DOS
 PATCH	LD	HL,(ADDR)	;GET A BYTE OF COMMAND
 	LD	A,(HL)		;PUT INTO A
 	INC	HL		;BUMP UP
 	LD	(ADDR),HL	;SAVE NEW ARDDR.
 	OR	A		;TEST END OF COMMAND
 	RET	NZ		;  NO: RETURN
 	LD	HL,SPLIT	;SET UP NEW DRIVER ADDR
 	LD	(KBD),HL	;STORE IT
 	JR	PATCH		;GET CR
 SPLIT	LD	HL,3C00H	;GET START OF SCREEN ADR.
 	LD	DE,VSAVE	;GET ADDR. OF SAVE AREA
 	LD	BC,1024		;AND NO. OF BYTES
 	LDIR			;SAVE SCREEN
 	LD	HL,401DH	;1ST ADDR. OF BASIC RAM
 	LD	BC,42E8H-401DH	;NO. OF BYTES
 	LDIR			;SAVE IT, TOO
 	LD	(SPSAVE),SP	;SAVE STACK POINTER
 	CALL	01C9H		;CLEAR SCREEN
 	LD	HL,(40B1H)	;GET MEMORY SIZE
 	INC	HL		;+1
 	LD	(HL),0		;MUST BE ZERO
 	INC	HL		;+1
 	LD	(40A4H),HL	;SAVE AS PROGRAM POINTER
 	LD	HL,IKBD		;ADDR. OF INITIAL KBD
 	LD	(KBD),HL	;SAVE AS NEW KBD DEVICE ADDR.
 	LD	HL,SKBD-1	;-1
 	LD	(40B1H),HL	;ESTABLISH NEW MEM SIXE
 	LD	DE,0FFCEH	;-50 DECIMAL
 	ADD	HL,DE		;ADD (SAVE AS SUB 50)
 	LD	(40A0H),HL	;EST. 50 BYTE STRING SPACE
 	CALL	1B4DH		;SET UP OTHER POINTERS
 	JP	06CCH		;RE-ENTER BASIC
 IKBD	LD	HL,SKBD		;CALLED JUST ONCE
 	LD	(KBD),HL	;FINAL NEW KBD DEVICE ADR.
 	CALL	CHANGE		;SWITCH BACK TO OLD BASIC
 	JP	06CCH		;"RESET" OLD BASIC
 SKBD	CALL	$-$		;CALL OLD KBD ROUTINE
 	CP	01		;BREAK KEY HIT?
 	RET	NZ		;  NO: JUST RETURN
 	LD	A,(3880H)	;SHIFT KEY DOWN?
 	AND	01		;(IF USER HAS CONTROL KEY)
 	XOR	01		;(REVERSE BIT)
 	RET	NZ		;  NO: RETURN A 1 FOR BREAK
 	CALL	CHANGE		;  YES: CHANGE ENVIRONMENT
 	XOR	A		;AND RETURN A ZERO
 	RET
 CHANGE	LD	HL,3C00H	;GET VIDEO ADR.
 	LD	DE,VSAVE	;AND SAVE AREA ADDR.
 	LD	BC,1024		;AND BYTE COUNT
 	CALL	SWAP		;SWITCH 'EM
 	LD	HL,401DH	;GET BASIC RAM ADDR.
 	LD	BC,42E8H-401DH	;AND BYTE COUNT
 	CALL	SWAP		;SWITCH 'EM
 	POP	BC		;POP RETURN ARRD.
 	LD	HL,(SPSAVE)	;GET OLD STACK POINTER
 	LD	(SPSAVE),SP	;SAVE NEW SP
 	LD	SP,HL		;RESTORE
 	LD	A,(403DH)	;GET 64/32 CHAR. FLAG
 	OUT	(0FFH),A	;FIX UP SCREEN
 	PUSH	BC		;RETURN ADDRESS ONTO STACK
 	RET			;AND RETURN
 SWAP	LD	A,(DE)		;A=(DE)
 	LDI		;(DE)=(HL):HL=HL+1:DE=DE+1:BC=BC-1
 	DEC	HL		;GET OLD HL BACK
 	LD	(HL),A		;(HL)=A
 	INC	HL		;NOW OK TO INCREMENT
 	JP	PE,SWAP		;LOOP BACK IF BC NOT ZERO
 	RET			;ELSE RETURN
 VSAVE	DEFS	1024		;SCREEN SAVE AREA
 BSAVE	DEFS	42E8H-401DH	;BASIC RAM SAVE AREA
 SPSAVE	DEFS	2		;STACK PIONTER SAVE AREA
 MKEND	EQU	$-1	;JUST TO CHECK END OF PROGRAM ADDR.
 	END	START
