QUERY/ ;*****
 ;	QUERY - routine dosplays a directory
 ;	 A => drive # in ASCII
 ;	 BUFFER = 256 byte buffer
 ;	 routine assumes single density 5-1/4" drives
 ;	 uses: WRLNO
 ;*****
 NODRV	LD	A,8
 	DB	1
 DIRERR	LD	A,17
 	OR	0C0H
 	JP	@ERROR
 ;*****
 ;	query entry point
 ;*****
 QUERY	LD	(DIRMSG+31),A	;p/u the drive (ASCII)
 	SUB	30H		;CVRT TO BINARY
 	JR	C,NODRV		;ERROR IF < 0
 	CP	4
 	JR	NC,NODRV		;ERROR IF > 3
 	LD	(DIRDCB+6),A	;STUFF DRIVE -> DCB
 	RLCA
 	RLCA
 	RLCA
 	OR	0C7H
 	LD	(SETDRV+1),A
 	XOR	A
 SETDRV	SET	0,A
 	LD	(RESELECT+1),A
 	CALL	RESELECT
 	CALL	RESTOR		;seek track 0
 	LD	BC,0
 	CALL	@PAUSE		;wait for restore
 TSTBSY	LD	A,(37ECH)
 	BIT	0,A		;drive busy?
 	JR	NZ,TSTBSY
 	BIT	7,A		;drive not ready?
 	JR	NZ,NODRV
 	BIT	2,A		;no track 0?
 	JR	Z,NODRV
 	LD	BC,205		;test if diskette in
 TST1	DEC	BC		;must see index off first
 	LD	A,B
 	OR	C		;loop run out?
 	JR	Z,NODRV
 	LD	A,(37ECH)
 	BIT	1,A		;make sure not constant
 	JR	NZ,TST1
 	LD	BC,6557		;diskette in, & turning?
 TST2	DEC	BC		;must see another index
 	LD	A,B		;before loop runs out
 	OR	C
 	JR	Z,NODRV
 	LD	A,(37ECH)
 	BIT	1,A		;got index yet?
 	JR	Z,TST2
 	CALL	@CLS		;CLEAR SCREEN
 	LD	HL,0		;read BOOT sector to
 	LD	(DIRDCB+10),HL	;determine directory track
 	LD	HL,BUFFER	;*** your buffer ***
 	PUSH	HL
 	CALL	RDSCTR
 	JR	NZ,DIRERR	;error on BOOT read?
 	INC	HL		;pt to dir tk
 	INC	HL
 	LD	E,(HL)		;p/u dir track byte
 	XOR	A
 	LD	D,A
 	CALL	MULTEN		;ten sectors per track
 	PUSH	DE
 	LD	(DIRDCB+10),DE
 	CALL	RDSCTR		;GET GAT SECTOR
 	XOR	A
 	LD	C,A		;init gat counter
 	LD	B,96		;max tracks all drives
 GATLP1	LD	A,(HL)		;P/U GRAN FREE/ASSIGN STATUS
 	CPL			;SWITCH TO GET 1'S FOR FREE
 	RRA			;SET CARRY IF 1 OR 3
 	ADC	A,C		;INC C BY 1 OR 2
 	LD	C,A
 	INC	HL		;ADVANCE TO NEXT TRACK STATUS
 	DJNZ	GATLP1		;loop until thru
 	LD	L,C
 	LD	H,0
 	CALL	WRLNO		;WRITE # OF FREE GRANS
 	LD	HL,BUFFER+0D0H
 	LD	DE,DIRMSG+35	;INSERT FILENAME & DATE
 	LD	BC,8
 	PUSH	BC
 	LDIR			;MOVE IN DISKNAME
 	INC	DE
 	INC	DE
 	INC	DE
 	POP	BC		;MOVE IN DATE
 	LDIR
 	LD	HL,DIRMSG
 	CALL	@DSPLY		;OUTPUT DIRECTORY HEADER
 	POP	DE		;RECOVER SECTOR #
 	INC	DE		;POINT TO SECTOR 2
 	INC	DE
 	LD	(DIRPTR),DE
 	LD	(DIRDCB+10),DE
 	POP	HL		;RECOVER BUF PTR
 	LD	B,8
 	LD	D,15		;INIT FOR 16 - DIRMSG
 SCTRLP	PUSH	BC
 	PUSH	DE		;SAVE SCREEN COUNTER
 	CALL	RDSCTR		;GET NEXT SECTOR
 	LD	DE,(DIRPTR)
 	INC	DE
 	LD	(DIRPTR),DE
 	LD	(DIRDCB+10),DE	;INC NRN BY ONE
 	POP	DE
 	CALL	PRTDIR		;OUTPUT ANY VISIBLE DEC'S
 	POP	BC
 	DJNZ	SCTRLP
 	RET			;BACK TO EDTASM COMMAND
 RDSCTR	LD	DE,DIRDCB
 	JP	@READ
 ;*****
 ;	routine multiplies DE by ten
 ;*****
 MULTEN	PUSH	HL
 	LD	H,D
 	LD	L,E
 	ADD	HL,HL
 	ADD	HL,HL
 	ADD	HL,DE
 	ADD	HL,HL
 	EX	DE,HL
 	POP	HL
 	RET
 ;*****
 ;	routine to display the directory
 ;*****
 PRTDIR	PUSH	HL		;SAVE PTR TO BUFFER
 	LD	B,8		;INIT FOR 8 DECS/SECTOR
 PRTLP1	PUSH	BC		;SAVE COUNTER
 	PUSH	HL		;SAVE BUF PTR
 	LD	A,(HL)		;BYPASS DEC IF SPARE
 	RLCA
 	JR	C,ENDLP
 	RLCA
 	JR	C,ENDLP
 	RLCA
 	RLCA
 	JR	NC,ENDLP
 	LD	A,L		;PT TO FILENAME
 	ADD	A,5
 	LD	L,A
 	LD	C,8		;INIT FOR 8 BYTES
 PRTLP2	LD	A,(HL)
 	CP	' '
 	CALL	NZ,WRCHR
 	INC	HL
 	DEC	C
 	JR	NZ,PRTLP2
 	LD	C,3		;INIT FOR EXT
 	LD	A,(HL)
 	CP	' '		;BYPASS IF NO EXT
 	JR	Z,PRTLP4
 	LD	A,'/'		;WRITE A "/"
 	CALL	WRCHR
 PRTLP3	LD	A,(HL)		;REGET CHAR
 	CP	' '
 	CALL	NZ,WRCHR	;WRITE IT IF NON-BLANK
 	INC	HL
 	DEC	C
 	JR	NZ,PRTLP3
 PRTLP4	POP	HL		;GET START OF DEC
 	PUSH	HL
 	LD	A,L
 	ADD	A,20		;PT TO EOF SECTOR
 	LD	L,A
 	LD	A,(HL)
 	INC	HL
 	LD	H,(HL)
 	LD	L,A
 	LD	A,9		;WRITE A TAB
 	CALL	WRCHR
 	LD	H,L		;MUL EOF SECTOR BY 256
 	LD	L,0
 	CALL	WRLNO		;& WRITE # OF BYTES
 	DEC	D		;DEC LINES/SCREEN
 	JR	NZ,DORET
 	CALL	@KEY		;PAUSE FOR ENTRY
 	LD	D,16		;REINIT TO 16
 DORET	CALL	WRRET
 ENDLP	POP	HL
 	LD	A,L		;PT TO NEXT DEC
 	ADD	A,32
 	LD	L,A
 	POP	BC
 	DJNZ	PRTLP1
 	POP	HL
 	RET
 RESTOR	CALL	RESELECT
 	LD	A,11
 	LD	(37ECH),A	;Restore
 RES1	CALL	RESELECT
 	LD	A,(37ECH)
 	RRCA
 	RET	NC
 	JR	RES1
 RESELECT	LD	A,0
 	LD	(37E1H),A
 	RET
 DIRMSG	DM	'Free grans - Directory - Drive x'
 	DM	' - Filename - DATEXXXX',0DH
 DIRDCB	DW	2080H		;SHOW FILE OPEN & SECTOR
 	DB	0		;NOT IN BUFFER
 	DW	BUFFER		;PHYSICAL BUFFER
 	DB	0
 	DW	1000H		;DEC OF FILE IN FIRST ENTRY
 	DW	0		;LRECL & EOF OFFSET TO 0
 	DW	0		;INIT NRN TO 0
 	DW	0FFFFH		;ENDING RECORD NUMBER
 	DW	1F00H,20H,1F10H,40H,1F20H
 	DW	60H,1F30H,80H,1F40H
 DIRPTR	DS	2
 WRRET	LD	A,0DH
 WRCHR	PUSH	DE
 	CALL	@DSP
 	POP	DE
 	RET
