PTRDVR ;*****************************************************
 ;**  LOADS PRINTER DRIVER AND RESETS HIMEM          **
 ;**  ADDS L/F AFTER C/R TO ROM PRINTER DRIVER  *******
 ;*****************************************************
 PORT	EQU	37E8H		;PRINTER PORT ADDRESS
 TOPMEM	EQU	4049H		;HOLDS HIMEM ADDRESS
 DSPMSG	EQU	4467H		;DISPLAY VECTOR
 PTRDCB	EQU	4025H		;PRINTER DCB
 DOSRTN	EQU	402DH		;DOS ENTRY POINT
 	ORG	5200H		;STANDARD LOAD POINT
 LOADER	LD	DE,PTRDCB	;PRINTER DCB
 	PUSH	DE		;SAVE DCB ADDRESS
 SHOW	LD	HL,TITLE	;TEXT FOR SCREEN DISPLAY
 DISP	CALL	DSPMSG		;DISPLAY TITLE
 	POP	IX		;PUT DCB IN IX
 	LD	BC,LAST-HIDVR	;LENGTH OF DRIVER
 TOP1	LD	HL,(TOPMEM)	;HIMEM ADDRESS
 	XOR	A		;RESET CARRY FLAG
 	SBC	HL,BC		;GET NEW HIMEM VALUE
 TOP2	LD	(TOPMEM),HL	;PUT IT IN HIMEM
 	INC	HL		;ADD 1 TO HIMEM VALUE
 	PUSH	HL		; AND SAVE IT
 	EX	DE,HL		;TRANSFER VALUE TO DE
 	LD	HL,HIDVR	;POINT TO DRIVER
 	LDIR			;TRANSFER TO HIGH MEM
 	POP	HL		;HIDVR START ADDRESS
 	LD	(IX+01),L	;LSB
 	LD	(IX+02),H	;MSB
 	JP	DOSRTN		;       "
 ;*---------------------------------------------------*
 TITLE	DEFM	'AUTO L/F PRINTER DRIVER'
 	DEFB	0DH		;END OF DISPLAY MSG
 ;*---------------------------------------------------*
 HIDVR	LD	A,C		;GET CHAR TO BE PRINTED
 	OR	A		;SET STATUS FLAGS
 	JR	Z,STATUS	;IF ZERO,GET PRINTER 
 				; STATUS & RTN TO CALLER
 	CP	0BH		;SKIP TO TOP OF FORM?
 				; CONTROL CODES:
 				;  A=LF+CR
 				;  B=SKIP TO TOP OF FORM
 				;  C=COND. SKIP TO TOF
 				;  D=CR
 	JR	Z,PAGECK	;YES,ISSUE LF'S TIL THERE
 	CP	0CH		;COND. TOP OF FORM?
 	JR	NZ,PTCHAR	;NO,THEN DATA CHAR
 	XOR	A		;YES,CLEAR A - NULL CHAR
 	OR	(IX+03H)	;CHECK LINES/PAGE (4028H)
 	JR	Z,PTCHAR	;IF ZERO,DON'T SKIP LINES
 PAGECK	LD	A,(IX+03H)	;GET LINES/PAGE (4028H)
 	SUB	(IX+04H)	;SB LINES PRINTED (4029H)
 	LD	B,A		;B=LINES TO SKIP 
 LINEFD	LD	A,(PORT)	;GET PRINTER STATUS
 	AND	0F0H		;    "
 	CP	30H		;    "
 	JR	NZ,LINEFD	;LOOP TIL NOT BUSY
 	LD	A,0AH		;GET L/F CHAR
 	LD	(PORT),A	;SEND IT TO PRINTER
 	DJNZ	LINEFD		;LP TIL TOP OF NEXT PAGE
 	JR	ZERO		;ZERO CNT & RTN TO CALLER
 PTCHAR	PUSH	AF		;SAVE PRINT STATUS
 LOOP1	LD	A,(PORT)	; GET PRINT STATUS
 	AND	0F0H		;      "
 	CP	30H		;      "
 	JR	NZ,LOOP1	;LOOP TIL NOT BUSY
 	POP	AF		;GET CHAR TO PRINT
 	LD	(PORT),A	;SEND IT TO PRINTER
 	CP	0DH		;C/R?
 	RET	NZ		;NO,DATA CHAR-RETURN
 ADDLF	LD	A,(PORT)	;GET PRINT STATUS
 	AND	0F0H		;   "
 	CP	30H		;   "
 	JR	NZ,ADDLF	; LOOP TILL NOT BUSY
 	LD	A,0AH		;GET LF CHARACTER
 	LD	(PORT),A	;SEND IT TO PRINTER
 	INC	(IX+04H)	;YES,BUMP LINE COUNT
 	LD	A,(IX+04H)	;GET LN CNT FOR THIS PAGE
 	CP	(IX+03H)	;END OF PAGE?
 	LD	A,C		;RESTORE CHAR(C/R) TO A
 	RET	NZ		;RTN IF PAGE NOT FULL
 ZERO	LD	(IX+04H),00H	;PAGE FULL,ZERO LN CNT
 	RET			;RETURN TO CALLER
 STATUS	LD	A,(PORT)	;GET PRINT STATUS WORD
 	AND	0F0H		;ISOLATE STATUS
 	CP	30H		;PRINTER READY?
 	RET			;RTN WITH ZERO IF READY
 LAST	EQU	$		;LAST BYTE OF DRIVER
 	END	LOADER
 FULL,ZERO LN CNT
 	RET			;RETURN TO CALLER
 STATUS	LD	A,(PORT)	;GET PRINT STATUS WORD
 	AND	0F0H		;ISOLATE STATUS
 	CP	30H		;PRINTER READY?
 	RET			;RTN WITH ZERO IF READY
 LAST	EQU	$		;LAST BYTE OF DR