PAGER/ ;********************************************************
 ;** PAGER/CMD  BY TOM PRICE VOICE OF THE 80 JUL81 P7   **
 ;**	MODIFIED 08/09/81 BY T.B.K		      **
 ;********************************************************
 TOPMEM	EQU	4049H		;HOLDS HIMEM ADDRESS
 DSPMSG	EQU	4467H		;DISPLAY VECTOR
 LENGTH	EQU	43H		;66 LINES/PAGE + 1
 MAXCNT	EQU	36H		;54 PRINTED LINES
 PTRDVR	EQU	058DH		;PRINTER DRIVER
 PTRDCB	EQU	4025H		;PRINTER DCB
 ;
 ;
 	ORG	5200H		;STANDARD LOAD POINT
 ENTRY	LD	DE,PTRDCB	;PRINTER DCB
 	PUSH	DE		;SAVE DCB ADDRESS
 SHOW	LD	HL,TITLE	;TEXT FOR SCREEN DISPLAY
 DISP	CALL	DSPMSG		;DISPLAY TITLE
 	POP	IX		;PUT DCB IN IX
 	LD	BC,0FH		;LENGTH	OF DRIVER
 TOP1	LD	HL,(TOPMEM)	;HIMEM ADDRESS
 	XOR	A		;RESET CARRY FLAG
 	SBC	HL,BC		;GET NEW HIMEM VALUE
 TOP2	LD	(TOPMEM),HL	;PUT IT	IN HIMEM
 	INC	HL		;ADD 1 TO HIMEM VALUE
 	PUSH	HL		; AND SAVE IT
 	EX	DE,HL		;TRANSFER VALUE	TO DE
 	LD	HL,PAGER	;POINT TO DRIVER
 	LDIR			;TRANSFER TO HIGH MEMORY
 	LD	(IX+00),06	;DRIVER TYPE VALUE
 	POP	HL		;PAGER START ADDRESS
 	LD	(IX+01),L	;LSB
 	LD	(IX+02),H	;MSB
 	LD	(IX+03),LENGTH	;LINES/PAGE
 	LD	(IX+04),01H	;ZERO LINE COUNTER
 	JP	402DH		;EXIT TO DOS
 ;
 TITLE	DEFM	'AUTO-PAGING  PRINTER DRIVER - 54 LINES/PAGE'
 	DEFB	0AH		;LINEFEED
 	DEFM	'02/11/81 - TOM	PRICE <70015,232>'
 	DEFB	0DH		;END OF DISPLAY MESSAGE
 PAGER	LD	A,(IX+04)	;GET LINE COUNT
 	CP	MAXCNT		;IS IT MAXIMUM?
 	JR	NZ,PRINT	;IF NOT,PRINT CHARACTER
 	LD	A,0CH		;FORM FEED CODE
 FORM	CALL	PTRDVR+1	;GO TO TOP OF FORM
 PRINT	JP	PTRDVR		;PRINT NEXT CHARACTER
 	END	ENTRY
 PAGER