;****	LINEFEED/FLT	Version 5.1
;
@ABORT	EQU	4030H
@DSPLY	EQU	4467H
@EXIT	EQU	402DH
CR	EQU	0DH
LF	EQU	0AH
;
	ORG 5200H
	PUSH	DE		;save DCB
	PUSH	HL		;save parameters
	LD	A,(DE)		;type byte
	PUSH	AF
	LD	HL,SIGNON
	CALL	@DSPLY
;
;****	Mod I or III determination
;
	LD	A,(125H)	;Mod I or III?
	CP	49H		;III=49h
	JR	Z,M3
	LD	HL,MOD1EQU
	JR	LDHIGH
M3	LD	HL,MOD3EQU
LDHIGH	LD	IX,PARMREL
CKREL	LD	D,(IX+1)
	LD	E,(IX)
	LD	A,(HL)
	OR	A
	JR	Z,DUNREL
	LD	(DE),A
	INC	HL
	INC	DE
	LD	A,(HL)
	LD	(DE),A
	INC	IX
	INC	IX
	INC	HL
	JR	CKREL
;
DUNREL	POP	AF		;device type byte
	BIT	3,A		;device set NIL?
	JP	NZ,DEVNIL
	BIT	4,A		;Routed?
	JP	NZ,DEVROUT
	BIT	1,A		;Output device?
	JP	Z,NOTOUT
;
;****	Pick up parameters
;
	POP	HL		;recover command line
	LD	DE,PARMTBL
PARM	CALL	0000H		;@param call
	JP	NZ,PERROR
;
ACHAR	LD	HL,0000H	;add parm
	LD	A,L
	OR	H		;parm entered?
	JR	NZ,ISADD
RCHAR	LD	HL,0000H	;remove parm
	LD	A,L
	OR	H
	JR	Z,PERROR
	LD	HL,REMLF	;else assume remove
	LD	BC,REMLEN
	JR	DUNPARM
ISADD	LD	HL,ADDLF
	LD	BC,ADDLEN
;
;****	ok to filter device
DUNPARM	POP	IX		;get dcb
	PUSH	HL		;save rem or add
	LD	L,(IX+1)
	LD	H,(IX+2)	;get old address
	LD	(OUTP1+1),HL	;install in filter code
	LD	(OUTP2+1),HL
	LD	(OUTP3+1),HL
	PUSH	IX
;
;****	install new HIGH$ and move filter code
MHI	LD	HL,(0000H)	;get current HIGH$
	LD	(OLDHIA),HL	;put in filter header
	LD	(OLDHIR),HL
	XOR	A
	SBC	HL,BC		;figure new HIGH$
SHI	LD	(0000H),HL	;store HIGH$
	INC	HL
	POP	DE
	PUSH	DE
	PUSH	HL
	PUSH	BC		;save filter byte count
	LD	C,E		;filter start
	LD	B,D		;into BC
	OR	A
	SBC	HL,BC		;calc. offset for reloc.
	LD	C,L
	LD	B,H		;offset into BC
	LD	IX,RELTBL	;table of labels to adj.
RELP	LD	L,(IX)		;pre-move address
	LD	H,(IX+1)
	LD	A,H		;msb
	OR	A
	JR	Z,DUNTBL	;end of reloc.
	PUSH	HL		;save loc. of address
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	EX	DE,HL
	ADD	HL,BC		;get move offset
	EX	DE,HL		;new address into DE
	POP	HL		;loc of address
	LD	(HL),E
	INC	HL
	LD	(HL),D		;install new addr
	INC	IX		;next loc in table
	INC	IX
	JR	RELP		;reloc. next label
;
DUNTBL	POP	BC		;restore byte count
	POP	HL		;restore relo address
	POP	IX
	LD	(IX+1),L
	LD	(IX+2),H	;install addr into dcb
	EX	DE,HL		;DE to new address
	POP	HL		;filter code start
	LDIR			;relocate filter
	JP	@EXIT		;all done
;
PERROR	LD	HL,PARMSG
	JR	ERROR
DEVNIL	LD	HL,NILMSG
	JR	ERROR
DEVROUT	LD	HL,ROUTMSG
	JR	ERROR
NOTOUT	LD	HL,OUTMSG
ERROR	CALL	0000H		;call @LOGOT
	JP	@ABORT
;
SIGNON	DB	31,'LINEFEED - Adjust Linefeed Filter - Version 5.1',0AH
	DB	'Copyright (c) 1981 by Logical Systems',2CH,' Inc.',0AH,0DH
;
PARMSG	DB	'Parameter error',0DH
NILMSG	DB	'Device not active',0DH
ROUTMSG	DB	'Device is routed',0DH
OUTMSG	DB	'Not an output device',0DH
;
PARMTBL	DB	'ADD   '
	DW	ACHAR+1
	DB	'A     '
	DW	ACHAR+1
	DB	'REMOVE'
	DW	RCHAR+1
	DB	'R     '
	DW	RCHAR+1
	DW	0000H		;end of table
;
;HIGH$,HIGH$,@LOGOT,@PARAM
;
MOD1EQU	DW	4049H,4049H,447BH,4476H,0000H
MOD3EQU	DW	4411H,4411H,428AH,4454H,0000H
PARMREL	DW	MHI+1,SHI+1,ERROR+1,PARM+1
;
RELTBL	DW	REL1+1,REL2+1,REL3+1,0000H
;
;****	 ADD LF code
;
ADDLF	JR	STARTA
OLDHIA	DW	0000H		;HIGH$ before filter
	DB	STARTA-FNAMEA
FNAMEA	DB	'LINEFEED'
;
STARTA	JR	C,OUTP1		;go if input
	PUSH	AF
	LD	A,C
	CP	CR		;CR ?
	JR	NZ,ADDOUT
	XOR	A
OUTP2	CALL	0000H
	LD	C,LF		;add LF
ADDOUT	POP	AF
OUTP1	JP	0000H
ADDLEN	EQU	$-ADDLF
;
;****	REM LF code
;
REMLF	JR	STARTR
OLDHIR	DW	0000H		;HIGH$ before filtering
	DB	STARTR-FNAMER
FNAMER	DB	'LINEFEED'
;
STARTR	JR	C,OUTP3
	PUSH	AF
REL1	LD	A,(WASCR)	;see if last was CR
	OR	A
	LD	A,C
	JR	Z,NOREM		;last not CR
	CP	LF		;is a LF
	JR	NZ,NOREM	;go if not
	POP	AF		;return if LF
	XOR	A
REL2	LD	(WASCR),A
	RET
;
NOREM	CP	CR		;is it a CR?
	JR	Z,REL3
	XOR	A		;else be sure to zero
REL3	LD	(WASCR),A	;store for next char cp
REMOUT	POP	AF
OUTP3	JP	0000H
;
WASCR	DB	0
;
REMLEN	EQU	$-REMLF
	END	5200H
