; erase/asm - kjw/breeze - 08/10/83
;
	TITLE	'<Disk Erase Utility>'
;
	SUBTTL	'<Copyright (C) 1983 Breeze Computing>'
;
;	dos equates
;
@EXIT	EQU	402DH		;dos exit vector
@ERROR	EQU	4409H		;display error message
@DISPLY	EQU	4467H		;display text
@CKDRV	EQU	4209H		;check drive ready
@CMDI	EQU	4299H		;command interpreter
@TOPMEM	EQU	4411H		;top memory
@RDSSEC	EQU	4B45H		;read system sector
;
	ORG	5200H
;
;	interpret input command
;
ENTRY	LD	A,(HL)		;fetch prompt char
	INC	HL		;bump pointer
	CP	' '		;blank?
	JR	Z,ENTRY		;yes, ignore
	CP	','		;comma?
	JR	Z,ENTRY		;yes, ignore
;
	CP	0DH		;terminator?
	JR	Z,ERR1		;missing information
	CP	03H		;terminator?
	JR	Z,ERR1		;missing information
;
;	check if colon issued
;
	CP	':'		;colon?
	JR	NZ,$+3		;go if not
	LD	A,(HL)		;else fetch next char
;
;	check for valid drive specified
;
	SUB	'0'		;remove ascii
	JR	C,ERR2		;go if invalid
	CP	8		;0-7?
	JR	NC,ERR2		;go if invalid
	CP	4		;0-3?
	JR	C,ERR2		;protect rigid drive!!
;
;	check if drive ready
;
	LD	C,A		;pass drive number
	ADD	A,'0'		;add back ascii
	LD	(PKILLD),A	;pass to command lines
	LD	(PCLEARD),A
	LD	(PCHECKD),A
	CALL	@CKDRV		;drive ready?
	JR	NZ,ERROR	;go if not!
;
;	make sure disk is readable
;
	LD	HL,IOBUFF	;I/O buffer
	LD	DE,0<8+0	;cyl/sector
	CALL	@RDSSEC		;read directory
	JR	NZ,ERROR	;go if error in reading!
;
;	relocate program to high memory
;
	LD	BC,CODEL	;length of code
	LD	HL,(@TOPMEM)	;fetch current high mem
	LD	(OLDTOP),HL	;save original value
	OR	A		;clear carry flag
	SBC	HL,BC		;HL = new top memory
	LD	(@TOPMEM),HL	;update high memory
	LD	DE,CODES	;start of code
	PUSH	HL		;save new address
	OR	A		;clear carry flag
	SBC	HL,DE		;HL = relocate offset
	EX	DE,HL		;DE = relocate offset
;
;	relocate via resolve table
;
	LD	IX,RESOLT	;resolve table
RESOL	LD	L,(IX+0)	;get lsb
	LD	H,(IX+1)	;get msb
	LD	A,H		;check for terminator
	OR	L		;HL = 0000?
	JR	Z,RESOLD	;table end if yes
;
;	resolve new relocation address
;
	LD	A,(HL)		;get LSB address
	ADD	A,E		;add offset lsb
	LD	(HL),A		;update address
	INC	HL		;bump to MSB
	LD	A,(HL)		;get MSB address
	ADC	A,D		;add offset msb
	LD	(HL),A		;update address
;
;	next table entry
;
	INC	IX		;bump table pointer
	INC	IX		;2 byte entries
	JR	RESOL		;go for table length
;
;	program address resolved, relocate and go!
;
RESOLD	POP	DE		;new address
	PUSH	DE		;save on stack for jump
	LD	HL,CODES	;current code address
	LDIR			;move program!
	RET			;go program!
;
;	error vectors
;
ERR1	LD	HL,ERRMSG1	;'missing drive'
	JR	ERR0		;go
;
ERR2	LD	HL,ERRMSG2	;'invalid drive'
;
ERR0	CALL	@DISPLY		;display message
	JR	QUIT		;quit program
;
ERROR	OR	0C0H		;return from error
	CALL	@ERROR		;display message
;
QUIT	XOR	A		;set NO error
	RET			;return from program
;
;	resolve lookup table
;
RESOLT	DEFW	RESOL1
	DEFW	RESOL2
	DEFW	RESOL3
	DEFW	RESOL4
	DEFW	RESOL5
	DEFW	RESOL6
	DEFW	RESOL7
	DEFW	RESOL8
	DEFW	RESOL9
	DEFW	RESOL10
	DEFW	RESOL11
	DEFW	RESOL12
	DEFW	0000H		;terminator
;
;	text
;
ERRMSG1	DEFM	'Missing Drivespec'
	DEFB	0DH
;
ERRMSG2	DEFM	'Invalid Drivespec'
	DEFB	0DH
IOBUFF	DEFS	100H		;I/O buffer
;
;	actual run-time code, save exit data
;
CODES	LD	(SPSAVE),SP	;save stack
RESOL1	EQU	$-2
	LD	HL,@EXIT	;dos exit vectors
	LD	DE,EXIT		;save it here
RESOL2	EQU	$-2
	LD	BC,6		;code length
	LDIR			;all data saved
;
;	setup new vectors
;
	LD	HL,VECTS	;new vectors
RESOL3	EQU	$-2
	LD	DE,@EXIT	;dos exit vectors
	LD	BC,6		;code length
	LDIR			;move in new data
;
;	call PKILL
;
	LD	HL,PKILL	;command line
RESOL4	EQU	$-2
	LD	DE,CODE1	;exit vector
RESOL5	EQU	$-2
	JR	EXECUTE		;setup and execute
;
;	call PCLEAR
;
CODE1	LD	HL,PCLEAR	;command line
RESOL6	EQU	$-2
	LD	DE,CODE2	;exit vector
RESOL7	EQU	$-2
	JR	EXECUTE		;setup and execute
;
;	call PCHECK
;
CODE2	LD	HL,PCHECK	;command line
RESOL8	EQU	$-2
	LD	DE,CODE3	;exit vector
RESOL9	EQU	$-2
	JR	EXECUTE		;setup and execute
;
;	restore dos vectors and exit program
;
CODE3	XOR	A		;set NO error
	JR	DONE		;exit program
;
;	error on command, abort
;
ABORT	OR	0C0H		;setup for error
	CALL	@ERROR		;display error
	XOR	A		;set NO error
;
;	program completed, restore DOS vectors
;
DONE	LD	HL,EXIT		;saved vectors
RESOL10	EQU	$-2
	LD	DE,@EXIT	;dos vector area
	LD	BC,6		;code length
	LDIR			;put it back
;
;	restore previous topmem
;
	LD	HL,$-$		;get old high memory
OLDTOP	EQU	$-2
	LD	(@TOPMEM),HL	;update pointer
;
;	restore stack and exit program
;
	LD	SP,$-$		;get old stack pointer
SPSAVE	EQU	$-2
	XOR	A		;set NO error
	LD	H,A		;for extended errors
	LD	L,A		;HL = 0000
	RET			;back to next level
;
;	execute dos call
;
EXECUTE	LD	SP,(SPSAVE)	;reset stack
RESOL11	EQU	$-2
	LD	(@EXIT+1),DE	;pass return vector
	LD	DE,@EXIT	;leave vector on stack
	PUSH	DE		;for RET exit
	PUSH	HL		;save command
	CALL	@DISPLY		;display command
	POP	HL		;restore command
	JP	@CMDI		;go command interpreter
;
;	command lines to execute
;
PKILL	DEFM	'PKILL :'
PKILLD	DEFM	'x,A'
	DEFB	0DH
;
PCLEAR	DEFM	'PCLEAR :'
PCLEARD	DEFM	'x,D'
	DEFB	0DH
;
PCHECK	DEFM	'PCHECK :'
PCHECKD	DEFM	'x'
	DEFB	0DH
;
;	storage for dos exit vectors
;
EXIT	DEFB	0,0,0,0,0,0
;
;	new dos exit vectors
;
VECTS	JP	$-$		;normal exit vector
	JP	ABORT		;error  exit vector
RESOL12	EQU	$-2
;
CODEE	EQU	$		;end of code
CODEL	EQU	CODEE-CODES	;length of code
;
	END	ENTRY		;done
