DR     	;TITLE	'<DR/ASM version 84.07.19>'
 	ORG	5200H
 BEGIN	EQU	$
 ROUTAS	EQU	4033H		;route address start
 OPNOPT	EQU	4420H		;open file
 OPNIPT	EQU	4424H		;open input
 CLSFIL	EQU	4428H		;close file
 HIMEM1	EQU	4049H		;himem mod 1
 HIMEM3	EQU	4411H		;himem mod 3
 EXDOSC	EQU	4405H		;execute dos command
 DSERRM	EQU	4409H		;error exit
 OVLFG1	EQU	4369H		;overlay active dos
 OVLFG3	EQU	4289H		;ovlay active mod 3
 DOSCMD	EQU	4419H		;dos command
 WRTSEC	EQU	4439H		;write disk sector
 SELDRV	EQU	445BH		;select drive
 PRVDRV	EQU	4308H		;prev drive mod 1
 PRVDR3	EQU	427EH		;prev drive mod 3
 ALLOCF	EQU	444BH		;allocate space
 POSFCB	EQU	4442H		;position file
 POSBEG	EQU	443FH		;position file begin
 DISPMS	EQU	4467H		;display message
 	LD	SP,STAK		;stack pointer
 	PUSH	HL		;comd addr
 	LD	HL,RTEBUF	;route command buffer
 	LD	(NBUFOT),HL	;next output byte
 	LD	DE,TTBL1-3	;for mod 1
 	LD	A,(54H)		;ind mod 3
 	DEC	A
 	JR	Z,INMOD1
 	LD	DE,TTBL3-3	;for mod 3
 	LD	HL,HIMEM3	;himem addr
 	LD	(HMA1),HL
 	LD	(HMA2),HL
 	LD	(HMA3),HL
 	LD	(HMA4),HL
 	LD	(HMA5),HL
 	INC	HL		;next byte
 	LD	(HMAP),HL
 	LD	HL,PRVDR3	;prev drive #
 	LD	(PDRA),HL	;save addr
 INMOD1	EQU	$
 	POP	HL		;comd input
 	LD	(NBUFIN),HL	;pointer to next move
 FNTYEN	EQU	$		;find type entry
 	INC	DE
 	INC	DE
 	INC	DE		;to entry name
 	LD	A,(DE)		;first char
 	OR	A
 	JP	Z,SENRBY	;not found, send comd
 	CP	(HL)		;check with comd line
 	INC	DE
 	LD	A,(DE)		;next char
 	INC	DE
 	JR	NZ,FNTYEN	;not found
 	INC	HL		;else next char
 	CP	(HL)
 	DEC	HL
 	JR	NZ,FNTYEN	;not this entry
 	INC	HL
 	INC	HL		;to next char
 	CALL	CHCHTY		;check type
 	JP	C,SENRBY	;type not found
 ;clear route information for type found
 	PUSH	HL
 	PUSH	DE
 	INC	DE		;to addr
 	EX	DE,HL
 	LD	E,(HL)		;orig fcb addr
 	INC	HL
 	LD	D,(HL)
 	LD	HL,(ROUTAS+1)	;route pointer
 CHNXRT	EQU	$
 	INC	HL		;to ptr next fcb
 	LD	A,(HL)
 	INC	HL
 	LD	H,(HL)		;ptr msb
 	LD	L,A		;ptr lsb
 	OR	H
 	JR	Z,CLROUX	;end of routes, exit
 	LD	A,(HL)
 	CP	E		;check required
 	INC	HL
 	LD	A,(HL)
 	INC	HL
 	JR	NZ,CHNXRT	;not reqd fcb
 	CP	D		;fcb msb
 	JR	NZ,CHNXRT	;not found
 	LD	A,H		;check in dos area
 	CP	52H
 	JR	C,CHNXRT	;yes, leave entry
 	DI			;no interrupt in delete
 	PUSH	HL		;save addr
 	LD	BC,6		;to fcb part
 	ADD	HL,BC
 	LD	(HL),0C9H	;set to ret
 	LD	B,H		;save value
 	LD	C,L
 	INC	HL		;to addr ptr
 	LD	(HL),C
 	INC	HL
 	LD	(HL),B		;pointer to code
 	LD	BC,OTL+6	;offset for fcb
 	ADD	HL,BC
 	EX	DE,HL		;fcb addr to de
 	CALL	CLSFIL		;close file
 	EX	DE,HL		;fcb addr to hl
 	LD	BC,-OTL-16-1	;addr of himem
 	ADD	HL,BC
 	LD	A,(HIMEM1)	;check if lowest
 HMA1	EQU	$-2
 	CP	L
 	JR	NZ,LVHIME	;no, leave himem
 	LD	A,(HIMEM1+1)
 HMAP	EQU	$-2
 	CP	H		;check if msb
 	JR	NZ,LVHIME
 	LD	BC,256+32+OTL+16 ;len used
 	ADD	HL,BC
 	LD	(HIMEM1),HL	;save new
 HMA2	EQU	$-2
 LVHIME	EQU	$
 	POP	HL		;restore ptr
 	JR	CHNXRT		;check next route
 CLROUX	EQU	$
 	POP	DE		;restore adrs
 	POP	HL
 RPNEXT	EQU	$		;find next param
 	LD	B,0FFH		;MM count
 INNEXM	EQU	$
 	INC	B		;incr MM count
 FNEQSN	EQU	$
 	CALL	CHCHTY		;check type
 	JP	Z,SENROU	;end of mesg
 	JR	NC,RPNEXT	;delimiter, clear count
 	INC	HL
 	CP	'M'		;check MM
 	JR	Z,INNEXM	;incr M count
 	CP	'='		;check MM=
 	JR	NZ,FNEQSN	;not found
 	LD	A,B		;get M count
 	CP	2
 	JR	NZ,RPNEXT	;not 2, try next
 	LD	A,(HL)		;next char
 	CP	'A'		;check if alpha
 	JR	C,RPNEXT	;no, pass thru
 	CALL	XFCMLN		;xfer to comd line
 	PUSH	DE
 	PUSH	HL		;save adrs
 	LD	HL,(HIMEM1)	;current high
 HMA3	EQU	$-2
 	DEC	H		;sub 256
 	INC	HL		;for allowed start
 	LD	(BUFRAD),HL	;buffer addr
 	LD	A,(DE)		;check output
 	LD	(OUFG),A	;save flag
 	OR	A
 	JR	NZ,NBUFCL	;no, no buff clr
 	PUSH	HL
 	LD	B,0
 CLOBFR	EQU	$
 	LD	(HL),0		;clear buffer
 	INC	HL
 	DJNZ	CLOBFR
 	POP	HL		;buffer start
 NBUFCL	EQU	$
 	LD	BC,-32		;room for fcb
 	ADD	HL,BC
 	LD	(FCAD1),HL	;fcb 1
 	LD	(FCAD2),HL	;fcb 2
 	LD	D,H		;save fcb addr
 	LD	E,L
 	LD	BC,-OTL		;code length
 	ADD	HL,BC
 	LD	(HL),0C9H	;set RET instr
 	LD	(CODA),HL	;save code addr
 	LD	BC,CNLSB-OUTCOD	;offset for count
 	ADD	HL,BC
 	LD	(CTLS1),HL	;save addr
 	LD	BC,CNMSB-CNLSB	;offset to msb
 	ADD	HL,BC
 	LD	(CTMS1),HL	;save count addr
 	POP	HL		;file name
 XFLNMA	EQU	$
 	CALL	CHCHTY		;check type
 	JR	NC,SVEON	;delimiter
 	LD	(DE),A
 	INC	HL
 	INC	DE
 	JR	XFLNMA		;xfer next
 SVEON	EQU	$
 	LD	A,03H		;end char
 	LD	(DE),A
 	PUSH	HL		;save pos in comd
 	LD	(NBUFIN),HL	;next move start
 	LD	HL,(HIMEM1)	;old himem
 HMA5	EQU	$-2
 	LD	BC,-256-32-OTL-16 ;used bytes
 	ADD	HL,BC
 	LD	(HIMEM1),HL	;save new himem
 HMA4	EQU	$-2
 	INC	HL		;to entry byte
 	EX	DE,HL
 	LD	HL,(NBUFOT)	;next in out buff
 	LD	A,D		;addr msb
 	CALL	CNVEXH		;conv to ext hex
 	LD	A,E
 	CALL	CNVEXH		;convert lsb
 	LD	(HL),'H'	;set type = hex
 	INC	HL
 	LD	(HL),' '	;delimiter
 	INC	HL
 	LD	(NBUFOT),HL	;next comd out
 	LD	DE,(FCAD1)	;fcb addr
 	LD	HL,0		;buffer addr
 BUFRAD	EQU	$-2
 	LD	B,0		;rec len
 	LD	A,0		;flag output
 OUFG	EQU	$-1
 	OR	A		;check input
 	JR	NZ,INPUFL	;yes, open input
 	CALL	OPNIPT		;open file
 	JR	Z,FLIFND	;file found
 	CP	24		;check not in directory
 	JR	NZ,JDSERM	;no, error
 	CALL	OPNOPT		;try open output
 	JR	NZ,JDSERM	;not found
 	LD	BC,512		;# records
 	CALL	POSFCB		;position fcb
 	CALL	ALLOCF		;allocate space
 	CALL	POSBEG		;to file begin
 	JR	TRYWRT		;try writing file
 FLIFND	EQU	$
 	INC	DE		;to flag byte
 	INC	DE
 	LD	A,(DE)
 	OR	0C0H		;set no file extend
 	LD	(DE),A
 	DEC	DE
 	DEC	DE
 TRYWRT	EQU	$		;write file sectors
 	LD	BC,0		;sector count 0
 WRNWSE	EQU	$
 	CALL	WRTSEC		;write sector
 	JR	NZ,EFILIN	;no more room
 	INC	BC		;count sectors
 	LD	A,B		;check max
 	CP	2		;max 512 sectors
 	JR	NZ,WRNWSE	;no, write next
 EFILIN	EQU	$
 	LD	A,B
 	OR	C
 	LD	A,33		;no spcae
 	JR	Z,JDSERM	;error
 	LD	(CNMSB),BC	;save sector count
 	CALL	CLSFIL		;close file
 	LD	B,0		;rec len
 INPUFL	EQU	$
 	CALL	OPNIPT		;open file
 	JR	NZ,JDSERM	;dos error
 	LD	DE,(CODA)	;addr for code
 	LD	HL,OUTCOD	;assume output
 	LD	A,(OUFG)	;flag for out
 	OR	A
 	JR	Z,MVOTCD	;move code
 	LD	HL,INPCOD	;else input code
 MVOTCD	EQU	$
 	LD	BC,OTL		;length for move
 	LDIR
 	POP	HL		;comd line addr
 	POP	DE		;type addr
 	JP	RPNEXT		;find next entry
 JDSERM	EQU	$
 	AND	7FH		;set dead end
 	JP	DSERRM		;dos error mesg
 SENRBY	EQU	$
 	CALL	CHCHTY		;check next char
 	INC	HL
 	JR	C,SENRBY	;normal char
 	DEC	HL		;else back to char
 	JR	NZ,SENRBY	;not eoline
 SENROU	EQU	$		;send route comd
 	CALL	XFCMLN		;xfer comd line
 	LD	HL,(NBUFOT)	;next out
 SETMBY	EQU	$
 	LD	(HL),0DH	;terminate
 	DEC	HL
 	LD	A,(HL)		;previous byte
 	CP	' '		;remove spaces
 	JR	Z,SETMBY
 	LD	HL,RTECMD	;command to send
 	CALL	DISPMS		;displ route comd
 	JP	EXDOSC		;execute DOS command
 INPCOD	EQU	$		;code for disk input
 	LD	DE,0		;fcb addr
 FCAD1	EQU	$-2
 	CALL	13H		;get char
 	RET	Z		;no error
 	LD	HL,-OTL		;len of entry
 	ADD	HL,DE		;to first byte
 	LD	(HL),0C9H	;set to RET
 	XOR	A
 	RET			;else no inp
 OUTCOD	EQU	$		;out to file
 	LD	DE,0		;fcb addr
 FCAD2	EQU	$-2
 	LD	A,0		;count lsb
 CNLSB	EQU	$-1
 	DEC	A
 	LD	(CNLSB),A	;save count
 CTLS1	EQU	$-2
 	JR	NZ,OUCBY	;output byte
 	LD	HL,0		;msb count
 CNMSB	EQU	$-2
 	DEC	HL		;decr count
 	LD	A,H
 	OR	L
 	JR	Z,ENOVFB	;no more room
 	LD	(CNMSB),HL	;save new count
 CTMS1	EQU	$-2
 OUCBY	EQU	$
 	LD	HL,PRVDRV	;previous drive
 PDRA	EQU	$-2		;prev drive store
 	LD	B,(HL)		;get drive
 	LD	A,C		;char to output
 	CALL	1BH		;output
 	JR	NZ,ENOVFB	;error on write
 	LD	A,B		;previous drive
 	CP	(HL)		;same as new
 	CALL	NZ,SELDRV	;select drive if not
 	RET	Z		;same, exit
 ENOVFB	EQU	$
 	LD	HL,0		;code begin
 CODA	EQU	$-2		;code addr
 	LD	(HL),0C9H	;set to ret
 	RET			;exit
 OTL	EQU	$-OUTCOD	;code length
 CNVEXH	EQU	$		;convert to hex
 	PUSH	AF		;save char
 	RR	A		;msd to lsd
 	RR	A
 	RR	A
 	RR	A
 	CALL	CNVHEX		;conv nibble
 	POP	AF
 CNVHEX	EQU	$
 	AND	0FH		;remove rest
 	OR	30H
 	CP	3AH		;check num
 	JR	C,SVHXCH
 	ADD	A,7		;else to alpha
 SVHXCH	EQU	$
 	LD	(HL),A		;to output
 	INC	HL
 	RET
 ;check character type
 CHCHTY	EQU	$
 	LD	A,(HL)
 	CP	0DH
 	RET	Z		;eoline
 	CP	','
 	INC	HL
 	JR	Z,EXINOC	;comma, bypass
 	CP	' '
 	DEC	HL
 	SCF			;carry not delim
 	RET	NZ		;not space
 BPSPAC	EQU	$
 	INC	HL
 	CP	(HL)		;still space
 	JR	Z,BPSPAC	;yes
 EXINOC	EQU	$
 	OR	A
 	RET
 XFCMLN	EQU	$		;xfer to comd line buffer
 	PUSH	DE
 	PUSH	HL
 	LD	BC,0		;prev moved
 NBUFIN	EQU	$-2
 	LD	DE,0		;prev dest
 NBUFOT	EQU	$-2
 	OR	A
 	SBC	HL,BC		;# bytes to move
 	JR	Z,XFCMEX	;zero len move
 	LD	B,H		;len to bc
 	LD	C,L
 	LD	HL,(NBUFIN)	;prev move end
 	LDIR			;else xfer
 	LD	(NBUFIN),HL	;next to move
 	LD	(NBUFOT),DE	;next dest
 XFCMEX	EQU	$
 	POP	HL
 	POP	DE
 	RET
 ;
 ;type table
 TTBL3	EQU	$		;mod 3 table
 	DEFM	'RI'		;rs232 input
 	DEFB	1
 	DEFW	41E5H
 	DEFM	'RO'		;rs232 output
 	DEFB	0
 	DEFW	41EDH
 TTBL1	EQU	$		;mod 1 table
 	DEFM	'KB'		;keybd input
 	DEFB	1
 	DEFW	4015H		;addr of fcb
 	DEFM	'DO'		;display output
 	DEFB	0
 	DEFW	401DH
 	DEFM	'PR'		;print output
 	DEFB	0
 	DEFW	4025H		;fcb addr
 	DEFB	0
 RTECMD	DEFM	'ROUTE '
 RTEBUF	DEFS	75
 	DEFS	256		;room for stack
 STAK	EQU	$
 	END	BEGIN
