MENU   ;MENU/CMD by Jim Doffing of Tacoma, Washington  11/26/83
 ;This program will make it easier for the novice
 ;computer user to make the most of (his,her) Mod III, IV
 ;using TRSDOS 1.3.  It will recognize programs with an
 ;extension of /CMD or /BLD, treating all others as basic
 ;programs.  By using the arrow keys you can move the cur-
 ;sors to enclose the desired program.  Pressing the ENTER
 ;key, will run the program or DO the /BLD File.  Pressing
 ;a number between 0 and 3 will get a directory of that
 ;drive, pressing BREAK will return to TRSDOS 1.3., and
 ;pressing 'D' will load and run DEBUG.  MENU/CMD will
 ;modify the return to DOS vector so the system will load
 ;and run MENU/CMD instead of return to DOS.
 	ORG	4E00H		;PROGRAM LOCATION & START
 ST	LD	SP,409FH	;RESTORE STACK POINTER
 	PUSH	AF		;SAVE REGISTERS 'AF'
 ST1	LD	A,0FFH		;PUT OVERLAY 15 NUMBER
 	LD	(4297H),A	;  INTO RETDOS OVERLAY
 	POP	AF		;  AND 'AF'
 	JP	START		;GO TO PROG START
 ;SYSTEM CALLS AND STANDARD ADDRESSES
 READ	EQU	4B0DH	;SYSTEM "READ DIR SECTOR" ROUTINE
 PRTLN	EQU	021BH	;SYSTEM "PRINT LINE OF TEXT" RTN
 CURPOS	EQU	4020H	;SYSTEM STOR FOR CURSOR POSITION
 INKEY	EQU	0049H	;SYSTEM "GET KEY PRESS" ROUTINE
 DOS	EQU	402DH	;SYSTEM "RETURN TO DOS" CALL
 VDCHR	EQU	0033H	;SYSTEM "CHARACTER TO VIDEO" RTN
 COMDOS	EQU	429CH	;EXECUTE DOS COMMAND ROUTINE
 DOSBUF	EQU	4225H	;DOS COMMAND BUFFER ADDRESS
 TOPMEM	EQU	4411H	;TOP OF USER MEMORY STORAGE
 SECBUF	EQU	4D00H	;PROGRAM "SECTOR STORAGE" ADDRESS
 DRNO	EQU	0FFFFH	;STORAGE OF LAST DRIVE #
 SECEND	EQU	4EH	;PROGRAM "END OF SECTOR" CHECK
 SPACE	EQU	20H	;ASCII ' ' (SPACE)
 CLS	EQU	1FH	;CLEAR TO BOTTOM OF SCREEN
 CR	EQU	0DH	;CARRIAGE RETURN & LINE FEED
 DNLN	EQU	1AH	;DOWN ONE LINE ON VIDEO
 UPLN	EQU	1BH	;UP ONE LINE ON VIDEO
 BKSP	EQU	18H	;BACKSPACE WITHOUT ERASE
 BKSPER	EQU	08H	;BACKSPACE WITH ERASE
 ;PROGRAM STORAGE OF VARIABLES
 TABLE	EQU	$	;ADDRESS FOR LOADING TRK AND SEC
 SEC	DEFB	03H	;FIRST SECTOR OF DIRECTORY
 TRK	DEFB	11H	;TRACK NUMBER OF DIRECTORY
 DR	DEFB	00H	;BINARY DRIVE NUMBER
 TEMSEC	DEFB	00H	;TEMP STOR OF ACTIVE SECTOR #
 FILOFF	DEFW	0030H	;OFFSET FROM ONE FILE TO NEXT
 FILNAM	DEFW	0005H	;OFFSET FILE START TO FILE NAME
 HLSAV	DEFS	2	;IN MEM NEXT FILE LOCAT.
 FILE1	DEFS	2	;PRESENT FILE LOCATION
 HL2	DEFS	2	;TEMP STOR FOR 'HL' REGISTER
 LAST	DEFS	2	;LAST FILE NAME DISPLAYED
 ;
 ;START OF PROGRAM
 ;
 START	AND	0F0H		;MASK OFF OVERLAY
 	CP	0F0H		;CALL FROM MODIFIED DOS
 				;ENTRY?
 	JR	NZ,STRT1	;IF NOT GOTO START1
 	LD	A,0FH		;TURN OFF
 	CALL	PRTCHR		;  CURSOR
 	LD	A,0B0H		;DEFAULT CURSOR CHAR
 	LD	(4023H),A	;STORE IN CURSOR CHAR
 	LD	A,(DRNO)	;SEE IF MAYBE STILL GOOD
 	JR	START1		;GET DRIVE #0 MENU
 STRT1	LD	A,(HL)		;CHECK TO FIND
 	CP	0DH		;EITHER A CARRIAGE RETURN
 	JR	Z,PUTMIN	;if CR then Drive #0
 	CP	':'		;OR A COLON
 	JR	NZ,START1	;if not assume drive #
 	INC	HL		;IF SO THEN NEXT CHAR
 	LD	A,(HL)		;INTO THE 'A' REGISTER
 START1	LD	(DRNO),A	;SAVE FOR PROG ENDS
 	SUB	'0'		;MAKE IT BINARY
 	JP	C,PUTMIN	;IF < 0 THEN DRIVE #0
 	LD	C,A		;PUT VALUE INTO 'C'
 	LD	A,(4413H)	;# OF DRIVES IN SYS TO'A'
 	CP	C		;IS IT TOO HIGH
 	JR	C,PUTMIN	;IF SO DRIVE #0
 	LD	A,C		;PUT VALUE BACK IN 'A'
 	JP	DISDIR		;ELSE CONTINUE
 PUTMIN	LD	A,'0'		;IF NOT THEN
 	LD	(DRNO),A	;SAVE FOR PROG ENDS
 	SUB	'0'		;DRIVE #0
 DISDIR	LD	(DR),A		;INSERT DRIVE NUM IN PROG
 	CALL	DISMES		;DISPLAY SIGN-ON MESSAGE
 	LD	DE,(TABLE)	;DE=> TRK17 AND SEC3
 DISD0	LD	A,E		;SECTOR NUM INTO 'A'
 	LD	(TEMSEC),A	;STORE FOR LATER
 	LD	HL,SECBUF	;HL=> SECTOR STORAGE LOC
 	LD	A,(DR)		;GET BINARY DRIVE# AND
 	LD	C,A		;  PUT IT INTO 'C'
 	LD	B,00H		;B=> 256 BYTE SECTOR READ
 	CALL	READ		;PUT SECTOR INTO BUFFER
 DISD1	LD	(HLSAV),HL	;STORE 'HL' FOR LATER
 	LD	A,(HL)		;FIRST FILE CHAR INTO 'A'
 	BIT	3,A		;IS IT AN INVISIBLE FILE
 	JR	NZ,NXTFIL	;IF SO NEXT FILE
 	CP	00H		;IS IT A BLANK POSITION
 	JR	NZ,DISFIL	;IF SO, DISPLAY NAME
 NXTFIL	LD	HL,(HLSAV)	;GET LAST FILE LOCATION
 	LD	DE,(FILOFF)	;DE=> OFFSET TO NEXT FILE
 	ADD	HL,DE		;ADD WITH SUM IN 'HL'
 	LD	A,H		;'H' INTO 'A' FOR TEST
 	CP	SECEND		;IS IT PAST END OF BUFFER
 	JR	NC,NXTSEC	;IF => THEN NEXT SECTOR
 	JR	DISD1		;IF NOT GET NEXT FILE
 NXTSEC	LD	A,(TEMSEC)	;A=> PRESENT SECTOR NUM
 	LD	DE,(TABLE)	;DE=> TRK & SEC
 	INC	A		;'A'='A'+1
 	LD	E,A		;NEW SECTOR INTO 'E'
 	CP	19D		;ARE WE PAST SECTOR 18
 	JR	C,DISD0		;IF < 19 THEN NEXT SECTOR
 	LD	HL,(CURPOS)	;ELSE GET CURSOR POSITION
 	LD	(LAST),HL	;STORE FOR COMPARE
 	JP	SEL1		;GOTO SELECTION ROUTINE
 ;
 ;NOW WE DISPLAY THE FILE NAME OF THE USER FILE
 ;
 DISFIL	LD	DE,(FILNAM)	;DE=> OFFSET TO FILE NAME
 	ADD	HL,DE		;ADD TO 'HL' INTO 'HL'
 	LD	B,8		;B=> MAX CHARS IN NAME
 	LD	C,00H		;C=> ZERO FOR COUNTER
 DISF0	LD	A,(HL)		;NEXT CHAR INTO 'A'
 	CP	SPACE		;IS IT A SPACE
 	JR	Z,EXT		;IF SO PUT ON EXTENSION
 	CALL	PRTCHR		;ELSE PRINT CHR TO VIDEO
 	INC	C		;KEEP TRACK OF VIDEO CHRS
 	INC	HL		;SET UP FOR NEXT CHAR
 	DJNZ	DISF0		;DISPLAY NAME UNTIL DONE
 EXT	CALL	LOOP		;MOVE 'HL' TO EXT. CHRS
 	LD	B,3		;MAX NUM EXT. CHARS
 	LD	A,(HL)		;FIRST CHR INTO 'A'
 	CP	SPACE		;IS IT A SPACE (NO EXT)
 	JR	Z,DRNUM		;IF SO ADD DRIVE NUMBER
 	LD	A,'/'		;ELSE PUT SLASH INTO 'A'
 	CALL	PRTCHR		;PUT IT ON VIDEO
 	INC	C		;KEEP TRACK OF VIDEO CHRS
 EXT1	LD	A,(HL)		;PUT NEXT CHR INTO 'A'
 	CP	SPACE		;IS IT A SPACE
 	JR	Z,DRNUM		;IF SO ADD DRIVE NUMBER
 	CALL	PRTCHR		;ELSE PUT ON VIDEO
 	INC	C		;KEEP TRACK OF VIDEO CHRS
 	INC	HL		;POINT TO NEXT CHAR
 	DJNZ	EXT1		;DO UNTIL DONE WITH EXT
 DRNUM	LD	A,':'		;A=> COLON
 	CALL	PRTCHR		;PUT ON VIDEO
 	INC	C		;KEEP TRACK
 	LD	A,(DRNO)	;A=> ASCII DRIVE NUMBER
 	CALL	PRTCHR		;PUT ON VIDEO
 	INC	C		;KEEP TRACK
 	LD	A,(CURPOS)	;A=> LSB CURSOR POSITION
 	AND	3FH		;MASK BITS 6 & 7
 	CP	50D		;ARE WE PAST TAB(49)
 	JR	C,DRNUM1	;IF NOT GOTO NEXT VID POS
 	LD	A,CR		;ELSE ISSUE CAR RET
 	CALL	PRTCHR		;PUT ON SCREEN
 	LD	A,SPACE		;  AND A SPACE
 	CALL	PRTCHR		;  ALSO ON SCREEN
 	JR	NXTFIL		;    THEN NEXT FILE
 DRNUM1	LD	A,16D		;CHRS TO NEXT VIDEO POS.
 	SUB	C		;SUBTRACT CHARS TO VIDEO
 	LD	B,A		;PUT INTO 'B' FOR LOOP
 DRNUM2	LD	A,SPACE		;A=> SPACE TO BE PRINTED
 	CALL	PRTCHR		;PUT ON VIDEO
 	DJNZ	DRNUM2		;DO UNTIL DONE
 	JP	NXTFIL		;GO GET NEXT FILE
 LOOP	LD	A,B		;CHRS LEFT IN 'B' FOR LOP
 	CP	00H		;COMPARE TO ZERO (DONE?)
 	RET	Z		;IF SO RETURN
 LOOP1	INC	HL		;SPACE OVER 1 CHR AT TIME
 	DJNZ	LOOP1		;  UNTIL AT EXTENSION
 	RET			;THEN RETURN
 ;
 ;THIS ROUTINE DISPLAYES SIGN ON MESSAGE AND RETURNS.
 ;
 DISMES	LD	HL,MESS1	;HL=> MESS1 LOCATION
 	CALL	VIDEO		;DISPLAY LINE ON VIDEO
 GETGRN	LD	A,(DR)		;GET BINARY DRIVE NUMBER
 	LD	C,A		;  INTO 'C'
 	CALL	4A93H		;GET GRAN SEC
 	LD	L,0D0H		;LOCATE NAME & DATE
 ;
 ;PUT NAME ON VIDEO
 ;
 	LD	B,8		;SET UP FOR LOOP
 	CALL	GETG1		;8 CHARS TO VIDEO (NAME)
 ;
 ;PUT DATE ON VIDEO
 ;
 	LD	B,8		;SET UP FOR LOOP
 	CALL	GETG1		;8 CHARS TO VIDEO (DATE)
 ;
 ;SET UP FOR GRANS TO VIDEO
 ;
 	LD	L,00H		;POSITION TO TOP BUFFER
 	PUSH	HL		;PUT 'HL' ON STACK
 	POP	IX		;BACK INTO 'IX'
 	LD	HL,0000H	;ZERO HL
 	PUSH	HL		;  AND ALSO
 	POP	DE		;    'DE'
 	LD	C,28H		;SEARCH 40 TRACKS
 GETG2	INC	(IX+60H)	;IS IT A FLAWED TRACK
 	JR	NZ,GETG3	;SKIP IF NOT
 	LD	(IX+00H),3FH	;MARK THIS GRAN USED
 GETG3	LD	A,(IX+00H)	;TRACK ALLOC INTO 'A'
 	LD	B,06H		;6 GRANS PER TRACK
 GETG4	RRA			;CHECK GRAN
 	CCF			;FIX STATUS
 	ADC	HL,DE		;ADD TO COUNT
 	DJNZ	GETG4		;LOOP OVER TRACK
 	INC	IX		;NEXT TRACK
 	DEC	C		;ONE LESS TO DO
 	JR	NZ,GETG2	;DO FOR ALL 40 TRACKS
 ;
 ;PUT GRANS ON VIDEO
 ;
 	CALL	0A9AH		;CONVERT HL TO INT ACCUM
 	XOR	A		;NO FORMATTING
 	CALL	1034H		;CONVERT
 	OR	(HL)		;  "ACCUM"
 	CALL	0FD9H		;    TO ASCII.
 	LD	HL,4131H	;HL=> CONVERTED NUMBER
 GETG5	LD	A,(HL)		;GET CHAR
 	OR	A		;TEST FOR END
 	JR	Z,ENDMES	;IF SO DO END OF MESSAGE
 	CALL	PRTCHR		;CHAR TO VIDEO
 	INC	HL		;NEXT CHARATER
 	JR	GETG5		;DO UNTIL DONE
 ENDMES	LD	HL,GRNMES	;HL=> 'Free Granules'
 	CALL	VIDEO		;PUT IT ON THE VIDEO
 	LD	A,SPACE		;ONE SPACE BEFORE FILE
 	CALL	PRTCHR		;  NAME OF FIRST FILE
 	RET			;BACK TO CALLER
 GETG1	LD	A,(HL)		;PUT NEXT CHAR INTO 'A'
 	CALL	PRTCHR		;PUT ON VIDEO
 	INC	HL		;NEXT POSITION
 	DJNZ	GETG1		;ALL 8 CHARCTERS
 	LD	A,SPACE		;PUT SPACE ON THE
 	CALL	PRTCHR		;  VIDEO
 	RET			;GO BACK TO CALLER
 MESS1	DEFB	1CH		;HOME CURSOR
 	DEFB	1FH		;CLEAR TO BOT OF SCREEN
 	DEFM	'MENU/CMD'	;START OF ACTUAL MESSAGE
 	DEFM	' by Jim Doffing  '
 	DEFB	03H		;END OF MESSAGE W/O LF
 GRNMES	DEFM	' Free Granules'
 	DEFB	0DH		;END OF MESSAGE W/LF
 RETDOS	CALL	RSTCUR		;FIX SCREEN AND ERASE CUR
 	LD	A,91H		;RESET RETURN TO DOS
 	LD	(4297H),A	;OVERLAY NUMBER
 	JP	DOS		;AND GOTO DOS READY
 GOBAS	CALL	RSTCUR		;GET READY TO PRINT
 	LD	HL,GBMES	;HL=> MESSAGE TERMINATED
 	LD	DE,DOSBUF	;DE=> DOS COMMAND BUFFER
 	PUSH	DE		;SAVE FOR LATER
 	LD	BC,000BH	;SET UP FOR TRANSFER
 	LDIR			;TRANSFER
 	POP	HL		;GET BUFFER ADDRESS
 	CALL	VIDEO		;PUT ON VIDEO
 	JP	4299H		;EXECUTE COMMAND & RETDOS
 GBMES	DEFM	'BASIC -F:3'
 	DEFB	0DH		;TERMINATED BY CR
 SEL1	CALL	TOP		;GET TOP OF SCREEN
 	LD	HL,(CURPOS)	;HL=> CURSOR POSITION
 	LD	(FILE1),HL	;SAVE FOR LATER
 SELECT	LD	(HL2),HL	;SAVE FOR PRESENT FILE #
 	LD	A,'<'		;PUT FIRST MARKER BEFORE
 	CALL	PRTCHR		;  FILE NAME
 SEL2	INC	HL		;NEXT CHAR POSIT.
 	LD	A,(HL)		;GET NEXT CHAR INTO 'A'
 	CP	SPACE		;IS IT A SPACE
 	JR	Z,SEL3		;IF SO GOTO SEL3
 	CALL	PRTCHR		;ELSE PUT ON VIDEO
 	JR	SEL2		;DO AGAIN
 SEL3	LD	A,'>'		;PUT SECOND MARK AFTER
 	CALL	PRTCHR		;  THE FILE NAME
 ;
 ;THE NEXT ROUTINE GETS THE COMMANDS AND ACTS APPROPIATELY
 ;
 GETCOM	CALL	INKEY	;GET SINGLE KEY FROM KEYBOARD
 	LD	BC,LENGTH ;LENGTH OF TABLE ARGUMENT
 	LD	HL,COMTBL ;LAST ENTRY IN COMMAND TABLE
 	LD	D,B	;COPY LENGTH FROM BC (BYTE COUNT)
 	LD	E,C	;...INTO DE (TO SAVE FOR LATER)
 	CPDR		;SEARCH UP ARGUMENT ENTRIES LIST
 	JP	NZ,GETCOM ;NO COMPARE FOUND TRY AGAIN
 	INC	HL	;COMPENSATE FOR CPDR OVERSHOT
 	ADD	HL,BC	;ADD REMNANT OF BYTE COUNT
 	ADD	HL,DE	;ADD ORIGINAL LENGTH
 	LD	E,(HL)	;PUT LOW ORDER BYTE INTO 'E'
 	INC	HL	;NEXT BYTE
 	LD	D,(HL)	;PUT HIGH ORDER BYTE INTO 'D'
 	EX	DE,HL	;PUT IN HL
 	JP	(HL)	;GOTO ADDRESS OF ROUTINE
 LENGTH	EQU	000EH	;FOURTEEN (14) COMMANDS IN TBL
 TBL	DEFB	'0'	;FIRST COMMAND
 	DEFB	'1'
 	DEFB	'2'
 	DEFB	'3'
 	DEFB	'D'
 	DEFB	'K'
 	DEFB	'C'
 	DEFB	'B'
 	DEFB	01H
 	DEFB	0DH
 	DEFB	5BH	;UP ARROW
 	DEFB	0AH	;DOWN ARROW
 	DEFB	08H	;LEFT ARROW
 COMTBL	DEFB	09H	;RIGHT ARROW ALSO LAST COM ENTRY
 	DEFW	DRIVE
 	DEFW	DRIVE
 	DEFW	DRIVE
 	DEFW	DRIVE
 	DEFW	DEBUG
 	DEFW	KILL
 	DEFW	COPY
 	DEFW	GOBAS
 	DEFW	RETDOS
 	DEFW	RUN
 	DEFW	UPAR
 	DEFW	DNAR
 	DEFW	LTAR
 	DEFW	RTAR
 			;PROGRAM
 ;
 ;THIS ROUTINE ERASES CURSOR1 AND CURSOR2 AND RETURNS
 ;TO THE CALLING ROUTINE
 ;
 ERASE	LD	A,BKSPER	;BACKSPACE AND ERASE
 	CALL	PRTCHR		;  CURSOR2
 	LD	HL,(CURPOS)	;HL=> CURSOR POSITION
 ERA1	DEC	HL		;GET PREVIOUS CHAR
 	LD	A,(HL)		;PUT CHAR INTO 'A'
 	CP	'<'		;IS IT CURSOR CHAR
 	JR	Z,ERA2		;IF SO CONTINUE
 	LD	A,BKSP		;IF NOT BACK SPACE
 	CALL	PRTCHR		;  TO PREV CHAR
 	JR	ERA1		;DO UNTIL DONE
 ERA2	LD	A,BKSPER	;BACK SPACE AND ERASE
 	CALL	PRTCHR		;  CURSOR1
 	DEC	HL		;POINT TO CURSOR POSIT
 	RET			;RETURN TO CALLER
 DRIVE	JP	START1		;GET DRIVE DIRECTORY
 DEBUG	XOR	A		;NO STATUS
 	JP	440DH		;LOAD AND JUMP TO DEBUG
 RUN	LD	HL,(HL2)	;GET PRESENT FILE LOCAT.
 	INC	HL		;NEXT POSITION AFTER '<'
 	LD	BC,10D		;SET UP FOR SEARCH LOOP
 	LD	A,'/'		;SEARCH CHAR INTO 'A'
 	CPIR			;AUTOMATIC SEARCH
 	JP	NZ,BASIC	;IF NOT MUST BE BASIC
 RUN11	LD	DE,0005H	;BYTES BETWEEN COMMANDS
 	LD	IX,EXTTBL	;IX=> EXTENT TABLE
 RUN2	PUSH	HL		;SAVE 'HL' FOR LATER
 	LD	A,(IX+00H)	;PUT FIRST CHAR INTO 'A'
 	CP	00H		;IS IT END OF TABLE
 	JP	Z,BASICR	;IF ZERO TABLE END, BASIC
 	LD	A,(HL)		;1ST FILE CHAR INTO 'A'
 	CP	(IX+00H)	;IS IT SAME AS TABLE
 	JR	NZ,NXTEXT	;IF NOT, NEXT EXT. LOC.
 	INC	HL		;POINT TO NEXT CHAR
 	LD	A,(HL)		;NEXT CHAR INTO 'A'
 	CP	(IX+01H)	;IS IT SAME AS 2ND CHAR
 	JR	NZ,NXTEXT	;IF NOT, NEXT EXT. LOC.
 	INC	HL		;POINT TO THIRD CHAR
 	LD	A,(HL)		;PUT IT INTO 'A'
 	CP	(IX+02H)	;IS IT SAME AS 3RD CHAR
 	JR	NZ,NXTEXT	;IF NOT, NEXT EXT LOC
 	POP	HL		;FIX STACK
 	LD	L,(IX+03H)	;PUT ROUTINE ADDRESS
 	LD	H,(IX+04H)	;  INTO 'HL'
 	JP	(HL)		; GO TO IT
 NXTEXT	ADD	IX,DE		;INC TO NEXT EXT
 	POP	HL		;GET ORIGINAL FILE LOC
 	JR	RUN2		;CHECK ANOTHER FILE EXT.
 BASICR	POP	HL		;CORRECT STACK
 	JP	BASIC
 TOP	LD	A,(CURPOS)	;GET LSB SCREEN ADDR
 	AND	3FH		;MASK OFF BITS 6&7
 	CP	0		;IS IT POSISION 0 OF LINE
 	JR	Z,TO1		;IF SO CONTINUE
 	LD	A,BKSP		;ELSE BACKSPACE
 	CALL	PRTCHR		;  ONE SPACE
 	JR	TOP		;AND CHECK AGAIN
 TO1	LD	HL,(CURPOS)	;PUT ADDRESS INTO 'HL'
 	LD	DE,0040H	;SET UP 'DE' FOR
 	SBC	HL,DE		;  SUBTRACTION
 	LD	A,(HL)		;PUT CHAR INTO 'A'
 	CP	SPACE		;IS IT A SPACE
 	RET	NZ		;IF NOT RETURN TO CALLER
 	LD	A,UPLN		;ELSE PRINT A
 	CALL	PRTCHR		;UP LINE FEED
 	JR	TO1		;  AND CONTINUE
 EXTTBL	DEFM	'CMD'		;COMMAND FILE EXT
 	DEFW	COMAND		;COMMAND FILE ROUTINE
 	DEFM	'BLD'		;BUILD FILE EXT
 	DEFW	DO		;DO BUILD ROUTINE
 	DEFB	00H		;END OF EXTTBL MARKER
 RSTCUR	CALL	ERASE		;GET RID OF CURSORS
 	CALL	TOP		;GO TO TOP OF VIDEO
 RST1	LD	HL,(CURPOS)	;GET CURRENT POSITION
 	INC	HL		;POINT AT NEXT CHAR
 	LD	A,(HL)		;PUT INTO 'A'
 	CP	SPACE		;IS IT A SPACE
 	RET	Z		;IF SO RETURN TO CALLER
 	LD	A,DNLN		;ELSE MOVE DOWN ONE
 	CALL	PRTCHR		;  LINE ON VIDEO
 	JR	RST1		;    AND TRY AGAIN
 KILL	CALL	RSTCUR		;GET CURSOR TO CLEAR LINE
 	LD	DE,KMES2	;DE=> KMES2 STOR AREA
 	LD	A,SPACE		;'A'= CHAR AT END OF FILE
 	CALL	MOVFIL		;MOVE FILE TO =>'DE'
 KIL2	LD	A,03H		;EOF MARKER INTO 'A'
 	LD	(DE),A		;PUT INTO MESSAGE
 	LD	HL,KILMES	;HL=> KILL MESSAGE?
 	CALL	VIDEO		;PUT LINE ON VIDEO
 	LD	HL,KMES3	;HL=> SECOND HALF KILMES
 	CALL	VIDEO		;PUT LINE ON VIDEO
 KIL3	CALL	INKEY		;GET KEY PRESSED
 	CP	01H		;WAS BREAK KEY PRESSED
 	JR	Z,QTBK		;IF SO CORRECT SCREEN RTN
 	CP	'N'		;IS IT AN "N"
 	JR	NZ,KIL4		;IF NOT MAYBE A "Y"
 QTBK	LD	HL,ERAKIL	;HL=> ERASE KILL MESSAGE
 	CALL	VIDEO		;PUT IT ON THE VIDEO
 	CALL	TOP		;GO TO TOP SCREEN
 	LD	HL,(CURPOS)	;HL=> CURSOR POSITION
 	JP	SELECT		;START OVER WITH SELECT
 KIL4	CP	'Y'		;IS IT A "Y"
 	JR	NZ,KIL3		;IF NOT GET ANOTHER COMM
 	CALL	PRTCHR		;PUT IT ON VIDEO
 	LD	A,CR		;MOVE TO NEXT LINE
 	CALL	PRTCHR		;DO IT NOW
 	LD	HL,KMES1	;HL=> KMES1 LOCATION
 	LD	DE,DOSBUF	;DE=> 4225H COMMAND BUFF
 	PUSH	DE		;SAVE FOR LATER
 	DEC	HL		;BACKUP ONE SPACE
 	LD	A,03H		;END OF FILE INTO 'A'
 	LD	(MOV2+01H),A	;PUT INTO RTN FOR COMPAR
 	CALL	MOV1		;MOVE IT
 KIL6	LD	A,CR		;PUT CAR RET INTO 'A'
 	LD	(DE),A		;STORE IT
 	POP	HL		;NOW WE CAN USE IT
 	CALL	VIDEO		;PUT ON SCREEN
 	JP	DOSCMD		;USE ROUTINE IN DOS
 KILMES	DEFM	'Are you sure you want to '
 KMES1	DEFM	'KILL '
 KMES2	DEFS	16D		;RESERVE 16 SPACES
 KMES3	DEFM	'? (Y/N)'
 	DEFB	0EH		;TURN ON CURSOR
 	DEFB	03H		;EOF MARKER
 ERAKIL	DEFB	0FH		;TURN OFF CURSOR
 	DEFB	0AH		;ISSUE LINE FEED & CR
 	DEFB	UPLN		;GO UP ONE LINE
 	DEFB	CLS		;CLEAR TO BOTT OF SCREEN
 	DEFB	03H		;TERMINATE WITH EOF MARK
 DO	CALL	RSTCUR		;GOTO FIRST BLANK LINE
 	LD	HL,DOMES	;HL=> BUILD MESSAGE
 	LD	DE,DOSBUF	;DE=> DOS INPUT BUFFER
 	PUSH	DE		;SAVE BUF ADDR FOR LATER
 	LD	BC,0003H	;NUMBER OF CHARS TO TRANS
 	LDIR			;MOVE'EM
 	LD	A,'/'		;'A'= CHAR AT END OF FILE
 	CALL	MOVFIL		;MOVE NAME TO BUFFER
 DO2	LD	A,CR		;TERMINATE COMMAND
 	LD	(DE),A		;IN COMMAND BUFFER
 	POP	HL		;HL=> DOS BUFFER
 	CALL	VIDEO		;PUT COMMAND ON VIDEO
 	LD	A,91H		;RE DO OVERLAY#1 INFO
 	LD	(4297H),A	;STORE IT
 	JP	4299H		;EXECUTE COMMAND
 DOMES	DEFM	'DO '		;DO COMMAND MESSAGE
 	DEFB	03H		;EOF MARKER
 BASMES	DEFM	'BASIC,'
 BASIC	CALL	RSTCUR		;FIX VIDEO
 	LD	HL,BASMES	;HL=> BASIC RTN MESSAGE
 	LD	DE,DOSBUF	;DE=> DOS INPUT BUFFER
 	LD	BC,0006H	;BC = LENGTH OF MESSAGE
 	PUSH	DE		;SAVE 'DE' FOR LATER
 	LDIR			;MOVE MES INTO DOSBUF
 	LD	A,SPACE		;'A'= END OF FILE MARK
 	CALL	MOVFIL		;MOVE IT TO =>'DE'
 BAS2	LD	A,CR		;PUT A CARRIAGE RETURN
 	LD	(DE),A		;AT END OF COMMAND
 	POP	HL		;NOW WE NEED THAT INFO
 	CALL	VIDEO		;PUT IT ON THE SCREEN
 	JP	4299H		;TURN IT OVER TO DOS
 COMAND	CALL	RSTCUR		;FIX SCREEN
 	LD	DE,DOSBUF	;DE=> DOS COMMAND BUFFER
 	PUSH	DE		;SAVE FOR LATER
 	LD	A,'/'		;'A'=END OF FILE MARK
 	CALL	MOVFIL		;PUT IT INTO BUF=>'DE'
 COM2	LD	A,':'		;PUT COLON INTO 'A'
 	LD	(DE),A		;PUT INTO BUFFER
 	INC	DE		;POINT TO NEXT POSITION
 	LD	A,(DRNO)	;PUT ASCII DR# INTO'A'
 	LD	(DE),A		;PUT INTO BUFFER
 	INC	DE		;NEXT POSITION
 	LD	A,CR		;TERMINATE COMMAND IN THE
 	LD	(DE),A		;COMMAND BUFFER
 	POP	HL		;HL=> COMMAND BUFFER
 	CALL	VIDEO		;PUT LINE ON VIDEO
 	JP	4299H		;TURN IT OVER TO DOS
 DNAR	LD	DE,0040H	;DE=> NUM CHAR TO NEXT
 	CALL	DNRTCK		;CHECK FOR FILE THERE
 	JP	Z,GETCOM	;IF SO THEN NO MORE FILES
 	CALL	ERASE		;ELSE GET RID OF CURSORS
 	LD	A,DNLN		;DUMMY VALUE
 	CALL	PRTCHR		;PUT IT ON THE SCREEN
 	LD	HL,(CURPOS)	;HL=> CURSOR POSITION
 	JP	SELECT		;GOTO SELECT ROUTINE
 RTAR	LD	DE,0010H	;DE = NUM CHARS TO NEXT
 	CALL	DNRTCK		;CHECK FOR FILE THERE
 	JP	Z,GETCOM	;IF SO THEN NO MORE FILES
 	CALL	ERASE		;ELSE GET RID OF CURSORS
 	LD	B,16D		;MOVE TO NEXT FILE
 RTAR1	INC	HL		;POINT TO NEXT CHAR
 	LD	A,(HL)		;PUT NEXT CHAR INTO 'A'
 	CALL	PRTCHR		;PUT IT ON VIDEO
 	DJNZ	RTAR1		;DO UNTIL DONE
 	LD	HL,(CURPOS)	;HL=> CURSOR LOCATION
 	JP	SELECT		;TURN OVER TO SELECT
 DNRTCK	LD	HL,(HL2)	;HL=> CURR FILE NAME
 	ADD	HL,DE		;ADD, RESULTS IN 'HL'
 	INC	HL		;MOVE TO NEXT CHAR
 	LD	A,(HL)		;PUT CHAR INTO 'A'
 	CP	SPACE		;IS IT A SPACE
 	RET			;RETUR NO MATTER
 UPAR	LD	DE,0040H	;DE = CHARS TO NEXT FILE
 	CALL	UPLTCK		;IS TOO FAR UP OR LEFT
 	JP	C,GETCOM	;IF SO GET NEXT COMMAND
 	CALL	ERASE		;GET RID OF CURSORS
 	LD	A,UPLN		;ELSE LOAD UP LINE IN 'A'
 	CALL	PRTCHR		;PUT TO VIDEO
 	LD	HL,(CURPOS)	;HL=> NEW FILE NAME
 	JP	SELECT		;GET ANOTHER CHOICE
 LTAR	LD	DE,0010H	;DE = CHARS TO NEXT FILE
 	CALL	UPLTCK		;IS TOO FAR UP OR LEFT
 	JP	C,GETCOM	;IF SO GET NEXT COMMAND
 	CALL	ERASE		;GET RID OF CURSORS
 	LD	B,10H		;MOVE TO NEXT FILE
 LTAR1	LD	A,BKSP		;BACK SPACE W/O ERASE 'A'
 	CALL	PRTCHR		;PUT ON SCREEN
 	LD	A,(CURPOS)	;GET LSB OF CURSOR POSIT
 	AND	3FH		;MASK BITS 6 & 7
 	CP	3FH		;IS IT END OF LINE
 	JR	NZ,LTAR2	;IF NOT FIRST CHAR CONT
 	LD	A,UPLN		;MOVE UP ONE LINE
 	CALL	PRTCHR		;PUT IT ON VIDEO
 LTAR2	DJNZ	LTAR1		;DO UNTIL DONE
 	LD	HL,(CURPOS)	;GET CURRENT FILE
 	JP	SELECT		;GET NEXT SELECTION
 UPLTCK	LD	HL,(HL2)	;HL=> FILE NAME
 	SBC	HL,DE		;SUBTRACT TO SEE IF WE
 	LD	BC,3C40H	;  ARE TRYING TO SELECT
 	SBC	HL,BC		;  THE FIRST LINE
 	RET			;GO BACK EITHER WAY
 MOVFIL	LD	(MOV2+01H),A	;PUT COMP VALUE IN RTN
 	LD	HL,(HL2)	;HL=> FILE NAME ADDRESS
 MOV1	INC	HL		;NEXT CHAR
 	LD	A,(HL)		;PUT CHAR INTO 'A'
 MOV2	CP	00H		;DUMMY CHECK SET BY RTN
 	RET	Z		;BACK TO CALLER IF END
 	LD	(DE),A		;ELSE STORE AT =>'DE'
 	INC	DE		;NEXT POSITION
 	JR	MOV1		;CONTINUE UNTIL DONE
 COPY	CALL	RSTCUR		;MOVE CURSOR TO EMTY LINE
 	LD	HL,COPMES	;HL=> Which Drive?
 	CALL	VIDEO		;PUT ON SCREEN
 COP1	CALL	INKEY		;GET CHARACTER
 	CP	01H		;WAS BREAK PRESSED
 	JP	Z,QTBK		;IF SO CORRECT SCREEN RTN
 	LD	(COPNUM),A	;STORE FOR LATER
 	SUB	30H		;MAKE IT BINARY
 	JR	C,COP1		;IF LESS THAN 0 TRY AGAIN
 	LD	C,A		;PUT IN 'C' FOR COMPARE
 	LD	A,(4413H)	;GET HIGH SYS DR #
 	CP	C		;IS IT TOO BIG
 	JR	C,COP1		;IF SO TRY AGAIN
 	LD	HL,COPMES	;HL=> "COPY "
 	LD	DE,DOSBUF	;DE=> DOS INPUT BUFFER
 	PUSH	DE		;SAVE BUFFER ADDRESS
 	LD	BC,0005H	;LENGTH OF COPY MESSAGE
 	LDIR			;MOVE IT
 	LD	A,SPACE		;'A'= CHAR AT END OF FILE
 	CALL	MOVFIL		;MOVE IT TO =>'DE'
 COP3	LD	HL,COPSPC	;HL=> COPY SPACE MESSAGE
 	LD	BC,0004H	;MOVE THREE CHARS TO
 	LDIR			;DOSBUF
 	LD	HL,COPNUM	;HL=> DRIVE NUMBER AND CR
 	CALL	VIDEO
 	POP	HL		;RESTORE BUFFER ADDRESS
 	CALL	VIDEO		;PUT COMMAND ON SCREEN
 	JP	DOSCMD		;TURN IT OVER TO DOS
 COPMES	DEFM	'COPY to which Drive?'
 	DEFB	0EH		;TURN ON CURSOR
 	DEFB	03H
 COPSPC	DEFB	SPACE
 	DEFB	':'
 COPNUM	DEFB	00H
 	DEFB	0DH
 VIDEO	PUSH	BC		;SAVE POINTER
 	PUSH	HL		;SAVE 'HL'
 	CALL	PRTLN		;PUT IT ON THE VIDEO
 	POP	HL		;GET 'HL'
 	POP	BC		;PUT BACK
 	RET			;BACK TO CALLER
 PRTCHR	PUSH	BC		;SAVE POINTER
 	CALL	VDCHR		;PUT IT ON THE VIDEO
 	POP	BC		;PUT IT BACK
 	RET
 	ORG	0FFF0H		;RST ROUTINE LOCATION
 DOSCMD	PUSH	HL		;SAVE 'HL' FOR NOW
 	LD	HL,TEMTOP	;PROTECT RETURN FROM DOS
 	LD	(TOPMEM),HL	;  STORE IT
 	POP	HL		;GET 'HL' BACK
 	CALL	COMDOS		;EXECUTE COMMAND & RETURN
 TEMTOP	LD	A,0FFH		;LOAD OVERLAY 15 &
 	RST	28H		;AND EXECUTE IT
 	END	ST		;END STATEMENT
