; dman07d/asm - kjw/bci - EDIT support
;
;	created 09/14/83	- kjw
;	revised 09/24/83	- kjw
;
;	clear expanded buffer to nil data
;
CLREBUF	LD	HL,EBUFF	;start buffer
	LD	BC,5<8+0	;flags 5 bytes
	CALL	$CLEAR		;zero it out
	LD	HL,EBUFF+5	;links
	LD	BC,6<8+0FFH	;links 6 bytes
	CALL	$CLEAR		;reset links
	LD	HL,EBUFF+11	;phone
	LD	BC,10<8+'*'	;length + fill
	CALL	$CLEAR		;reset data
	LD	HL,EBUFF+21	;name etc
	LD	B,12+5+12+10+8+6
	LD	C,' '
	CALL	$CLEAR		;reset data
	LD	HL,EBUFF+74	;flags
	LD	BC,12<8+0	;length + fill
	JP	$CLEAR		;clear and return
;
;	get full mask from user
;
GETMASK	LD	HL,MSKMSG	;'enter mask'
	CALL	$DOLINE		;display to video
;
	CALL	CLREBUF		;clear buffer
	LD	HL,$		;get wildmask pointer
WILDPTR	EQU	$-2
	LD	DE,EBUFF+21	;name here
	LD	BC,11		;length
	LDIR			;move it
	CALL	DISPLAY		;display record
	CALL	EDITRC		;edit record
	LD	IX,@DATA	;reset pointer
	LD	HL,EBUFF	;expanded buffer
	LD	DE,MBUFF	;mask buffer
	LD	BC,86		;max length
	LDIR			;save it
	SET	6,(IX+22)	;set full mask
	RET			;done
;
TSTMASK	BIT	6,(IX+22)	;mask on?
	RET	Z		;go if not
	BIT	6,(IX+10)	;compressed?
	JR	Z,TST2		;go if yes
	LD	A,(MBUFF+11)	;any phone here?
	CP	'*'		;nil?
	JR	NZ,TST0		;go if not
	LD	A,(MBUFF+14)	;any phone here?
	CP	'*'		;nil?
	JR	Z,TST2		;go if yes
	LD	BC,14		;offset
	LD	A,7		;length
	JR	TST1		;continue
TST0	LD	BC,11		;offset
	LD	A,10		;length
TST1	CALL	TESTIT		;match?
	RET	NZ		;nope, go!
;
TST2	LD	A,(MBUFF+33)	;any version?
	CP	' '		;nil?
	JR	Z,TST3		;go if yes
	LD	BC,33		;offset
	LD	A,5		;length
	CALL	TESTIT		;compare
	RET	NZ		;go if not same
;
TST3	BIT	6,(IX+10)	;compressed?
	JR	Z,TST7		;go if yes
	LD	A,(MBUFF+38)	;any author?
	CP	' '		;nil?
	JR	Z,TST4		;go if yes
	LD	BC,38		;offset
	LD	A,10		;length
	CALL	TESTIT		;compare
	RET	NZ		;go if not same
;
TST4	LD	A,(MBUFF+48)	;any company?
	CP	' '		;nil?
	JR	Z,TST5		;yes, go!
	LD	BC,48		;offset
	LD	A,12		;length
	CALL	TESTIT		;compare
	RET	NZ		;go if not same
;
TST5	LD	A,(MBUFF+60)	;any group?
	CP	' '		;nil?
	JR	Z,TST6		;go if yes
	LD	BC,60		;offset
	LD	A,8		;length
	CALL	TESTIT		;compare
	RET	NZ		;go if not same
;
TST6	LD	A,(MBUFF+68)	;any class?
	CP	' '		;nil?
	JR	Z,TST7		;go if yes
	LD	BC,68		;offset
	LD	A,6		;length
	CALL	TESTIT		;compare
	RET	NZ		;go if not same
;
TST7	LD	DE,MBUFF+74	;flags
	LD	HL,EBUFF+74	;current data
	LD	B,12		;flag count
;
TST8	LD	A,(DE)		;get mask
	OR	A		;zero?
	JR	Z,TST9		;go if yes
	CP	(HL)		;same?
	RET	NZ		;go if not
TST9	INC	HL		;bump
	INC	DE		;bump
	DJNZ	TST8		;go for count
	XOR	A		;set MATCH!
	RET			;done!
;
;	compare mask and current file
;
TESTIT	LD	HL,MBUFF	;mask buffer
	ADD	HL,BC		;HL => mask
	EX	DE,HL		;DE => mask
	LD	HL,EBUFF	;current buffer
	ADD	HL,BC		;HL => data
	LD	B,A		;pass char count
;
TEST1	LD	A,(DE)		;get a char
	CP	'?'		;don't care?
	JR	Z,TEST2		;go if yes
	CP	'*'		;match rest field?
	RET	Z		;yes, match remainder
	CALL	$UCASE		;make mask upper case
	LD	C,A		;save
	LD	A,(HL)		;get data
	CALL	$UCASE		;make upper case
	CP	C		;match?
	RET	NZ		;nope, go!
TEST2	INC	HL		;bump source
	INC	DE		;bump mask
	DJNZ	TEST1		;go for length
	XOR	A		;set MATCH
	RET			;done!
;
;	just browsing through the file
;
BROWSER	PUSH	HL		;save HL
	LD	HL,ERROR	;error exit
	EX	(SP),HL		;leave and get HL
	LD	IX,@DATA	;reset pointer
	RES	2,(IX+22)	;set FORWARD scan
	LD	A,B		;check if any drive #
	AND	H
	AND	L
	INC	A		;any?
	JR	NZ,BROWDSK	;go if drive #
	LD	HL,1		;init drive #
	LD	B,H		;BHL = 1 for start disk
;
BROWDSK	LD	(IX+23),B	;save disk #
	LD	(IX+24),H
	LD	(IX+25),L
	XOR	A		;init current index
	BIT	2,(IX+22)	;forward?
	JR	Z,$+4		;go if yes
	LD	A,26		;else set at end
	LD	(IX+26),A	;save current
;
;	read disk name/date
;
	CALL	$DEC24		;adjust 0 relative
	LD	C,16		;entries / sector
	CALL	$DIVID		;divide out
	ADD	A,A		;*2
	ADD	A,A		;*4
	ADD	A,A		;*8
	ADD	A,A		;*16
	LD	(IX+36),A	;save offset
	CALL	$INC24		;adjust sector#
	CALL	READIT		;read sector
	RET	NZ		;go on error
	LD	C,(IX+36)	;get offset
	LD	B,0		;BC = offset
	ADD	HL,BC		;HL => disk name/date
;
;	check for deleted disk
;
	BIT	7,(HL)		;deleted?
	JR	Z,BROWXX	;nope, continue
	BIT	2,(IX+22)	;forward?
	JP	Z,BROWU		;yes, go up
	JP	BROWDN		;backward, go down
;
BROWXX	LD	DE,NAMDAT	;store here
	LD	C,16		;length
	LDIR			;saved!
;
;	read index file for current disk
;
	CALL	LDINDF		;load index buffer
	RET	NZ		;go on disk error
	CALL	SHOW1		;display type
	LD	A,(IX+26)	;get current link
;
BROWLNK	LD	(IX+26),A	;save new link#
	ADD	A,A		;*2
	ADD	A,A		;*4
	ADD	A,A		;*8
	BIT	2,(IX+22)	;forward?
	JR	Z,$+4		;go if yes
	ADD	A,3		;offset to backward
	LD	L,A		;update lsb
	LD	H,INDF<-8	;msb index
	LD	B,(HL)		;get msb
	INC	HL		;bump
	LD	D,(HL)		;get nsb
	INC	HL		;bump
	LD	E,(HL)		;get lsb
	EX	DE,HL		;BHL = next record#
;
BROWFIL	LD	A,B		;check if any
	AND	H
	AND	L
	INC	A		;nil?
	JR	NZ,BROWFI	;go if valid record
	BIT	2,(IX+22)	;forward?
	JP	Z,BROWSR	;go if yes
	JP	BROWSL		;else backward
;
BROWFI	CALL	GETREC		;read record
	RET	NZ		;go on error
	CALL	UNPACK		;unpack record
	PUSH	IY		;save file pointer
	CALL	DISPLAY		;display record
	POP	IY		;restore pointer
	LD	IX,@DATA	;reset pointer
	JR	BROWD		;continue
;
BROWE	LD	HL,BROWMS	;end of file
	CALL	$DOLINE		;display
	LD	HL,BROWMG	;remainder
	JR	BROWD+3		;continue
;
BROWD	LD	HL,BROWMSG	;'command?'
	CALL	$DOLINE		;display
BROWDD	CALL	$INKEY		;get key input
	JP	C,DONE		;go on BREAK
	JR	Z,BROWR		;default next
	CALL	$UCASE		;make upper case
	LD	HL,BROWTBL	;command table
	CALL	$GOTABL		;vector to routine
	JR	BROWDD		;continue
;
;	last disk #
;
BROWDN	SET	2,(IX+22)	;set backward
	LD	B,(IX+23)	;get current disk#
	LD	H,(IX+24)
	LD	L,(IX+25)
	CALL	$DEC24		;decrement
	LD	A,B		;check if at first
	OR	H
	OR	L
	JR	Z,BROWE		;can't go that way!
	JP	BROWDSK		;new disk #
;
;	next disk #
;
BROWU	RES	2,(IX+22)	;set forward
	LD	B,(IX+23)	;get current disk#
	LD	H,(IX+24)
	LD	L,(IX+25)
	LD	C,(IX+51)	;get # disks used
	LD	D,(IX+52)
	LD	E,(IX+53)
	CALL	$CMP24		;at last disk?
	JR	Z,BROWE		;yes, can't go!
	CALL	$INC24		;bump disk #
	JP	BROWDSK		;go next disk
;
;	follow forward link
;
BROWR	RES	2,(IX+22)	;set forward
	LD	B,(IY+5)	;get forward link
	LD	H,(IY+6)
	LD	L,(IY+7)
	JP	BROWFIL		;nope, next file
;
;	follow next index link
;
BROWSR	RES	2,(IX+22)	;set forward
	LD	A,(IX+26)	;get current index link
	INC	A		;bump to next
	CP	27		;0-26?
	JP	C,BROWLNK	;in range, go next link
	JR	BROWU		;end, go next disk#
;
;	follow backward link
;
BROWL	SET	2,(IX+22)	;set backward
	LD	B,(IY+8)	;get back link
	LD	H,(IY+9)
	LD	L,(IY+10)
	JP	BROWFIL		;yes, get the file
;
;	follow backward index link
;
BROWSL	SET	2,(IX+22)	;set backward
	LD	A,(IX+26)	;get current index link
	OR	A		;at first?
	JP	Z,BROWDN	;go last disk if at first
	DEC	A		;else decrement it
	JP	BROWLNK		;go next link
;
	PAGE
;
;	edit flag names
;
FLAGS	LD	IX,@DATA	;data pointer
	CALL	$POSHL		;any more input?
	LD	A,0		;set no flags
	JR	Z,FLAGSC	;go if not
	LD	A,(HL)		;re-fetch input
	CP	'('		;param?
	JP	NZ,INVALID	;go if not
	INC	HL		;bump pointer
	CALL	$POSHL		;find data
	JP	Z,INVALID	;nothing here!
	CALL	$UCASE		;make upper case
	CP	'E'		;edit?
	JP	NZ,INVALID	;invalid command
FLAGSC	LD	(FLAGSD),A	;save input data
;
	LD	HL,0		;record 0
	LD	B,H		;BHL = first record
	CALL	READIT		;read it
	JR	NZ,FLAGERR	;go on error
	LD	BC,60H		;offset to names
	ADD	HL,BC		;HL => names
	LD	DE,EBUFF	;move here
	LD	C,12*8		;length
	LDIR			;move!
;
;	display flags
;
	LD	A,1		;init flag #
	LD	(FNUMB),A	;clear
	LD	HL,FLAGSET	;setup text
	CALL	$DOLINE		;display
	CALL	$VIDON		;enable video memory
	LD	IY,FLAGT	;flag table
	CALL	DISPLP		;display flags
	LD	A,0		;get data
FLAGSD	EQU	$-1
	OR	A		;edit?
	JR	Z,FLAGSR	;nope, return!
;
;	edit flags
;
	LD	IX,FLAGT	;command table
	LD	IY,FLAGV	;vector table
	CALL	EDITRC0		;edit names
;
;	update flag data to disk
;
	LD	IX,@DATA	;reset pointer
	LD	HL,(@IOBUFF)	;I/O buffer
	LD	BC,60H		;offset to names
	ADD	HL,BC		;HL => buffer
	EX	DE,HL		;DE => buffer
	LD	HL,EBUFF	;buffer here
	LD	C,12*8		;length
	LDIR			;update I/O buffer
	SET	4,(IX+21)	;set buffer updated
	CALL	WRITIT		;write the buffer
	JR	NZ,FLAGERR	;go on error
;
FLAGSR	LD	A,0<4+1		;command
	JP	$OVRLAY		;back to command mode
;
FLAGERR	LD	DE,FLGEMG	;'flag error'
	CALL	$DOERR		;display error
	JP	GODOS		;exit to dos
;
EDITF	INC	HL		;bump
	INC	HL		;bump
	INC	HL		;bump
	JP	EDIT1		;go editor
;
DVRF	LD	A,0		;get flag number
FNUMB	EQU	$-1
	PUSH	BC		;save
	CALL	ASCII		;convert to ascii
	EX	DE,HL		;HL => video
	LD	(HL),C		;load msb
	INC	HL		;bump
	LD	(HL),B
	INC	HL
	LD	(HL),'='	;separator
	INC	HL		;bump
	EX	DE,HL		;swap back
	LD	A,(FNUMB)	;get current number
	INC	A		;bump for next
	LD	(FNUMB),A	;update
	POP	BC		;restore
	LDIR			;move data
	RET			;done
;
;	command table for browsing
;
BROWTBL	DEFB	_RIGHT		;right arrow
	DEFW	BROWR
	DEFB	'R'
	DEFW	BROWR
	DEFB	_LEFT
	DEFW	BROWL
	DEFB	'L'
	DEFW	BROWL
	DEFB	_SRIGHT
	DEFW	BROWSR
	DEFB	';'
	DEFW	BROWSR
	DEFB	'+'
	DEFW	BROWSR
	DEFB	_SLEFT
	DEFW	BROWSL
	DEFB	'-'
	DEFW	BROWSL
	DEFB	'='
	DEFW	BROWSL
	DEFB	_UP
	DEFW	BROWU
	DEFB	_DOWN
	DEFW	BROWDN
	DEFB	'U'
	DEFW	BROWU
	DEFB	'D'
	DEFW	BROWDN
	DEFB	'B'
	DEFW	DONE
	DEFW	0000H
;
