; dman07c/asm - kjw/bci - EDIT support
;
;	delete current record
;
DELREC	CALL	$SAVREG		;save registers
	LD	HL,DELMSG1	;'deleting..'
	CALL	$DOLINE		;display
;
	LD	IX,@DATA	;reset pointer
	LD	HL,$		;get table pointer
INDFPTR	EQU	$-2
	LD	(RECIY),HL	;save it
	LD	B,(IX+30)	;get current file #
	LD	H,(IX+31)
	LD	L,(IX+32)
	LD	(RECBC),BC	;save current #
	LD	(RECHL),HL
	CALL	GETREC		;read record
	RET	NZ		;go if error
;
;	delete current file and store pointers
;
	PUSH	IY		;pass pointer
	POP	HL		;restore pointer
	LD	BC,5		;offset to links
	ADD	HL,BC		;HL => links
	LD	DE,RECSTOR	;record storage
	INC	C		;record link length
	LDIR			;move it
;
;	de-link current record
;
DELRECA	LD	B,(IY+5)	;get forward link
	LD	H,(IY+6)
	LD	L,(IY+7)
	LD	A,B		;check if any
	AND	H
	AND	L
	INC	A		;BHL = FFFFFF?
	JR	NZ,DELRAY	;yes, go!
;
DELRAN	LD	B,(IY+8)	;get backward link
	LD	H,(IY+9)
	LD	L,(IY+10)
	LD	A,B		;check for nil
	AND	H
	AND	L
	INC	A		;BHL = FFFFFF?
	JR	NZ,DELRANY	;yes, go!
;
;	file is nil!
;
DELRANN	DEC	A		;load FF
	LD	IY,$		;load index pointer
RECIY	EQU	$-2
	LD	(IY+0),A	;clear pointers
	LD	(IY+1),A
	LD	(IY+2),A
	LD	(IY+3),A
	LD	(IY+4),A
	LD	(IY+5),A
	LD	(IY+6),'*'
	LD	(IY+7),'*'
	SET	6,(IX+21)	;set needs update
	JP	DELRE		;continue
;
DELRANY	CALL	GETREC		;load backward record
	RET	NZ		;go if error
	LD	A,-1		;load nil
	LD	(IY+5),A	;clear forward link
	LD	(IY+6),A
	LD	(IY+7),A
	SET	4,(IX+21)	;set buffer updated
;
	LD	IY,RECSTOR	;record storage
	LD	B,(IY+3)	;get backward link
	LD	H,(IY+4)
	LD	L,(IY+5)
	LD	IY,(RECIY)	;get index pointer
	LD	(IY+3),B	;set as last record
	LD	(IY+4),H
	LD	(IY+5),L
	SET	6,(IX+21)	;set buffer needs update
	JP	DELRE		;continue
;
DELRAY	CALL	GETREC		;load forward record
	RET	NZ		;go if error
	PUSH	IY		;save pointer
	LD	IY,RECSTOR	;get record storage
	LD	B,(IY+3)	;get backward link
	LD	H,(IY+4)
	LD	L,(IY+5)
	POP	IY		;restore
	LD	(IY+8),B	;update backward link
	LD	(IY+9),H
	LD	(IY+10),L
	SET	4,(IX+21)	;set update needed
;
	LD	A,B		;check for nil
	AND	H
	AND	L
	INC	A		;BHL = FFFFFF?
	JR	NZ,DELRB	;go if not
;
	LD	IY,RECSTOR	;get record storage
	LD	B,(IY+0)	;get forward link
	LD	H,(IY+1)
	LD	L,(IY+2)
	LD	IY,(RECIY)	;get index pointer
	LD	(IY+0),B	;set as first record
	LD	(IY+1),H
	LD	(IY+2),L
	LD	(IY+6),'['	;flag table
	SET	6,(IX+21)	;flag for update
;
DELRB	LD	IY,RECSTOR	;record storage
	LD	B,(IY+3)	;get back link
	LD	H,(IY+4)
	LD	L,(IY+5)
	LD	A,B		;any back link?
	AND	H
	AND	L
	INC	A		;=FFFFFF?
	JR	NZ,DELRC	;yes, continue
;
	LD	B,(IY+0)	;get forward link
	LD	H,(IY+1)
	LD	L,(IY+2)
	LD	IY,(RECIY)	;get index pointer
	LD	(IY+0),B	;set index first
	LD	(IY+1),H
	LD	(IY+2),L
	SET	6,(IX+21)	;buffer needs update
	JR	DELRE		;continue
;
DELRC	CALL	GETREC		;get record
	RET	NZ		;go on error
	PUSH	IY		;save pointer
	LD	IY,RECSTOR	;get storage
	LD	B,(IY+0)	;get forward link
	LD	H,(IY+1)
	LD	L,(IY+2)
	POP	IY		;restore
	LD	(IY+5),B	;update forward link
	LD	(IY+6),H
	LD	(IY+7),L
	SET	4,(IX+21)	;set buffer updated
;
;	file is de-linked
;	add file space to delted list for re-use
;	get last deleted file in link and append
;
DELRE	LD	B,(IX+73)	;get # files used
	LD	H,(IX+74)
	LD	L,(IX+75)
	CALL	$DEC24		;decrement
	LD	(IX+73),B	;update count
	LD	(IX+74),H
	LD	(IX+75),L
;
	LD	B,(IX+67)	;get last deleted file
	LD	H,(IX+68)
	LD	L,(IX+69)
;
;	check if any at all
;
	LD	A,B
	AND	H
	AND	L
	INC	A		;terminator?
	JR	NZ,DELRG	;go if not
;
;	current record is first and only link
;
DELRF	LD	BC,(RECBC)	;get record #
	LD	HL,(RECHL)
	LD	(IX+64),B	;deleted file link start
	LD	(IX+65),H
	LD	(IX+66),L
	LD	(IX+67),B	;deleted file link end
	LD	(IX+68),H
	LD	(IX+69),L
;
;	clear links in current record
;
	CALL	GETREC		;read record
	RET	NZ		;go on error
	LD	A,-1		;set nil
	LD	(IY+5),A	;clear forward link
	LD	(IY+6),A
	LD	(IY+7),A
	LD	(IY+8),A	;clear backward link
	LD	(IY+9),A
	LD	(IY+10),A
	SET	7,(IY+0)	;set deleted bit
	SET	4,(IX+21)	;set buffer updated
	JR	DELRH		;continue
;
DELRG	CALL	GETREC		;get last deleted record
	RET	NZ		;go on error
	LD	BC,$		;get current record
RECBC	EQU	$-2
	LD	HL,$
RECHL	EQU	$-2
	LD	(IY+5),B	;update forward link
	LD	(IY+6),H
	LD	(IY+7),L
	SET	4,(IX+21)	;set buffer updated
;
	LD	BC,(RECBC)	;get again
	LD	HL,(RECHL)
	CALL	GETREC		;read record
	RET	NZ		;go on error
	LD	B,(IX+67)	;get old deleted end
	LD	H,(IX+68)
	LD	L,(IX+69)
	LD	(IY+8),B	;update back link
	LD	(IY+9),H
	LD	(IY+10),L
	LD	A,-1		;load FF
	LD	(IY+5),A	;clear forward link
	LD	(IY+6),A
	LD	(IY+7),A
	SET	7,(IY+0)	;set delete flag
	SET	4,(IX+21)	;set update flag
;
;	update new link end
;
	LD	BC,(RECBC)	;get record #
	LD	HL,(RECHL)
	LD	(IX+67),B	;update last link
	LD	(IX+68),H
	LD	(IX+69),L
;
DELRH	CALL	UPDAT0		;set as updated
	LD	IX,@DATA	;reset pointer
	CALL	WRITIT		;update buffer
	RET	NZ		;go on error
	CALL	$SHOWF		;display new facts
	LD	IX,@DATA	;reset pointer
;
;	index sector needs update?
;
	BIT	6,(IX+21)	;needs update?
	JR	Z,DELRI		;go if not
;
	LD	B,(IX+27)	;get sector #
	LD	H,(IX+28)
	LD	L,(IX+29)
	CALL	READIT		;read the sector
	RET	NZ		;go on error
	EX	DE,HL		;DE => I/O buffer
	LD	HL,INDF		;alt buffer
	LD	BC,100H		;buffer length
	LDIR			;load it
	SET	4,(IX+21)	;set buffer updated
	CALL	WRITIT		;update to disk
	RET	NZ		;go on error
;
DELRI	XOR	A		;set NO error
	RET			;done
;
;	pack record from EBUFF => CBUFF
;
PACK	LD	HL,EBUFF	;expanded buffer
	LD	DE,CBUFF	;compressed buffer
	LD	BC,11		;11 bytes already set
	LDIR			;move 'em
;
;	check if expanded/compressed
;
	LD	A,(@FLAG1)	;system flag
	BIT	6,A		;expanded?
	JR	NZ,PACKE	;yes, go!
;
;	pack compressed
;
PACKC	LD	HL,EBUFF+21	;name here
	LD	B,17		;bytes to move
	CALL	MBITS		;move the bits in
	LD	IX,EBUFF+74	;start flags
	LD	B,12		;12 flags to go
	CALL	MBITS0		;move flags in
;
;	align last packed byte to high bits
;
PACKD	SLA	E		;align bits
	DEC	D		;less bit counter
	JR	NZ,PACKD	;go for count
	LD	(IY+0),E	;load last byte
	RET			;done!
;
;	move telephone
;
PACKE	LD	B,5		;10 digit total
PACK1	LD	A,(HL)		;get data
	CALL	PACKR		;adjust char
	RLCA			;align digits
	RLCA
	RLCA
	RLCA
	AND	0F0H		;4 bits only
	LD	C,A		;save it
	INC	HL		;bump pointer
	LD	A,(HL)		;get data
	CALL	PACKR		;adjust char
	OR	C		;combine
	LD	(DE),A		;to buffer
	INC	HL		;bump source
	INC	DE		;bump dest
	DJNZ	PACK1		;go for 10 digits
;
	LD	B,53		;53 bytes to move
	CALL	MBITS		;move bits
;
;	move flag data
;
	LD	B,12		;12 flags
	JR	MBITS0		;move flags
;
;	compute digit for packed record
;
PACKR	CP	'*'		;nil?
	JR	Z,PACKRR	;yes, reset
	SUB	'0'		;remove ascii
	JR	C,PACKRR	;go if not digit
	CP	10		;0-9?
	RET	C		;yes, go!
PACKRR	XOR	A		;return 0 digit
	RET			;done!
;
;	move BC bits from (HL) => (DE)
;
MBITS	PUSH	HL		;pass to IX
	POP	IX
	PUSH	DE		;pass to IY
	POP	IY		;IX=>source, IY=>dest
	LD	DE,8<8+0	;D=bits/byte, E=byte
	LD	L,7		;bits to move / byte
	JR	MBITS1		;continue
;
MBITS0	LD	L,1		;bits to move / byte
MBITS1	LD	A,(IX+0)	;get data
	ADD	A,A		;ignore bit 7
	INC	IX		;bump pointer
	PUSH	HL		;save bits to move
	CALL	MBITS2		;move 'em
	POP	HL		;restore bits/byte
	DJNZ	MBITS1		;go for byte count
	LD	(IY+0),E	;update last partial
	RET			;done!
;
MBITS2	ADD	A,A		;move bit to carry
	RL	E		;move to data byte
	DEC	D		;less bits/byte
	JR	NZ,MBITS3	;go if not full
	LD	(IY+0),E	;load data byte
	INC	IY		;bump dest
	LD	DE,8<8+0	;reset count/byte
;
MBITS3	DEC	L		;less bits to move
	JR	NZ,MBITS2	;go for count
	RET			;byte moved!
