; dman07/asm - kjw/bci - EDIT/FIND/BROWSE/FLAGS
;
;	created 09/06/83	- kjw/bci
;	revised 09/06/83	- kjw/bci
;
;	system data usage
;
;	+20	7 / 0=find, 1=edit
;		6 / 0=find/edit, 1=browse
;		5 / 1=invisible also
;		4 / 1=system also
;		3 / 1=mod only
;		2 / 1=mask is NOT form
;		1 / 1=mask field found
;		0 / 1=nonstop mode
;	+21	7 / 1=INDF buffer loaded
;		6 / 1=INDF buffer updated
;		5 / 1=I/O buffer loaded
;		4 / 1=I/O buffer updated
;		3 / 1=IND0 buffer loaded
;		2 / 1=IND0 buffer updated
;		1 / 1=global disks
;		0 / 1=unused
;	+22	7 / 1=match file with index value
;		6 / 1=full mask compare engaged
;		1+0 / index value for test
;	+23-25	current disk #
;	+26	current index position 0-26
;	+27-29	current INDF sector pointer
;	+30-32	current file number
;	+33-35	current sector in I/O buffer
;	+36	temporary offset use
;	+37-39	match counter
;
ENTRY	LD	(CMDDAT),A	;entry command
	LD	IX,@DATA	;start data block
	LD	(IX+20),0	;reset flags
	LD	(IX+21),0	;alt flags
	LD	(IX+22),0
	LD	(IX+23),-1	;set global disks
	LD	(IX+24),-1
	LD	(IX+25),-1
	LD	(IX+37),0	;clear match counter
	LD	(IX+38),0
	LD	(IX+39),0
	BIT	7,(IX+10)	;file open?
	JR	NZ,START	;yes, go!
;
;	index file not open
;
	LD	HL,NOTMSG	;'not available'
ERREX	CALL	$DOLINE		;display
	JP	GODOS		;back to command mode
;
START	LD	A,0		;get command
CMDDAT	EQU	$-1
	DEC	A		;command 1 = EDIT
	JR	Z,EDIT		;go if yes
	DEC	A		;command 2 = FIND
	JR	Z,FIND		;go if yes
	DEC	A		;command 3 = BROWSE
	JR	Z,BROWSE	;go if yes
	DEC	A		;command 4 = FLAGS
	JP	Z,FLAGS		;go if yes
	DEC	A		;command 5 = KILL
	JR	Z,KILL		;go if yes
	JP	$CMD		;can't get here!
;
BROWSE	CALL	NEFILES		;any files here?
	SET	6,(IX+20)	;set BROWSE
	CALL	$POSHL		;any more input?
	JP	Z,CONT3		;nope, continue
	CP	'#'		;disk number?
	JP	NZ,INVALID	;nope, error!
	CALL	DISKNO		;valid disk #
	LD	(IX+23),B	;save disk #
	LD	(IX+24),H
	LD	(IX+25),L
	EX	DE,HL		;swap
	CALL	$POSHL		;any more input?
	JP	Z,CONT3		;nope, continue
	JP	INVALID		;invalid commands
;
KILL	SET	5,(IX+22)	;set KILL mode
EDIT	SET	7,(IX+20)	;set edit
;
;	setup nil mask
;
FIND	CALL	NEFILES		;any files?
	PUSH	HL		;save input
	LD	HL,NILMASK	;nil mask
	LD	B,1		;command
	CALL	$WILD		;make mask
	LD	(WILDPTR),DE	;save mask pointer
	POP	HL		;restore
;
;	evaluate input command
;	valid inputs:
;
;	nil			= global all disks
;	#disknumber		= global disknumber
;	mask			= mask global all disks
;	mask#disknumber		= mask disknumber
;
	CALL	$POSHL		;any input?
	JP	Z,CONT3		;global all disks
	CP	'#'		;disknumber?
	JR	Z,GLDN		;global disk number
	CP	'('		;params?
	JR	Z,PARAM		;yes, go!
	CALL	HAVMASK		;have mask
	JR	Z,CONT1		;go if OK
;
;	unrecognized command
;
INVALID	LD	HL,ERMSG1	;'invalid command line'
	CALL	$DOLINE		;display
	JP	GODOS		;exit to command mode
;
;	mask found, check if disk # included
;
CONT1	CALL	$POSHL		;any more input?
	JP	Z,CONT3		;mask all disks
	CP	'('		;params?
	JR	Z,PARAM		;yes, go!
	CP	'#'		;must be disk #
	JR	NZ,INVALID	;invalid input!
GLDN	CALL	DISKNO		;get disk number
;
;	disk number with/without mask specified
;
	LD	(IX+23),B	;save disk #
	LD	(IX+24),H
	LD	(IX+25),L
	EX	DE,HL		;HL => input remainder
	CALL	$POSHL		;any more?
	JP	Z,CONT3		;go if not
	CP	'('		;must be params
	JR	NZ,INVALID	;else bad!
;
;	evaluate user params
;
PARAM	INC	HL		;bump pointer
	CALL	$POSHL		;any more input?
	JP	Z,CONT3		;go if done!
	CP	')'		;close?
	JP	Z,CONT3		;yes, go!
	CP	_REMARK		;remark?
	JP	Z,CONT3		;yes, go!
	CALL	$UCASE		;make upper case
	CP	'I'		;invis?
	JR	Z,PARAMI	;yes, go!
	CP	'S'		;system?
	JR	Z,PARAMS	;yes, go!
	CP	'N'		;nonstop?
	JR	Z,PARAMN	;yes, go!
	CP	'M'		;mod?
	JR	Z,PARAMM	;go if yes
	CP	'F'		;full mask?
	JR	Z,PARAMF	;go if yes
	CP	'E'		;index value?
	JR	NZ,INVALID	;none, go!
	INC	HL		;bump to next
	LD	A,(HL)		;get data
	CALL	$UCASE		;make upper case
	SUB	'A'		;remove ascii
	JR	C,INVALID	;go if bad
	CP	4		;0-3?
	JR	NC,INVALID	;go if bad
;
;	have INDEX value
;
	OR	80H		;set found flag
	LD	(IX+22),A	;set index found
	JR	PARAM		;continue
;
PARAMM	SET	3,(IX+20)	;set MOD only
	JR	PARAM		;continue
PARAMI	SET	5,(IX+20)	;set INVIS
	JR	PARAM		;continue
PARAMS	SET	4,(IX+20)	;set system
	JR	PARAM		;continue
PARAMN	SET	0,(IX+20)	;nonstop
	JR	PARAM		;continue
PARAMF	SET	6,(IX+22)	;full compare mask
	JR	PARAM		;continue
;
;	error!
;
ERROR	LD	DE,DISKERR	;disk error
	CALL	$DOERR		;display error
;
;	check for any buffer updating
;
	LD	IX,@DATA	;data block
	LD	A,(IX+21)	;get flags
;
;	check if any buffers need updating
;
	AND	01010100B	;any updating?
	JP	Z,GODOS		;nope, exit
;
;	error occured, check if attempt to update
;
CHECK	LD	HL,PROMPT2	;'attempt to update?'
	CALL	$DOLINE		;display
	CALL	$INKEY		;get user input
	JP	C,GODOS		;go on BREAK
	JR	Z,EXIT		;default on enter
	CALL	$UCASE		;make upper case
	CP	'N'		;no?
	JP	Z,GODOS		;nope, exit
	CP	'Y'		;yes?
	JR	NZ,CHECK	;neither, ask again
;
;	check if buffers need update and exit to menu
;
EXIT	LD	IX,@DATA	;start data block
;
;	any need updating?
;
	CALL	WRITIT		;update I/O buffer
	JP	NZ,ERROR	;go on error
;
EXIT1	BIT	3,(IX+21)	;IND0 buffer loaded?
	JR	Z,EXIT2		;nope, go!
	BIT	2,(IX+21)	;buffer needs update?
	JR	Z,EXIT2		;nope, go!
;
;	update IND0 buffer
;
	LD	HL,0		;load sector #
	LD	B,H		;BHL = 000000
	CALL	READIT		;read the sector
	JP	NZ,ERROR	;go on disk error
	EX	DE,HL		;DE => I/O buffer
	LD	HL,IND0		;point to buffer
	LD	BC,100H		;buffer length
	LDIR			;move it
	SET	4,(IX+21)	;set file updated
	CALL	WRITIT		;write the buffer
	JP	NZ,ERROR	;go on error
	RES	2,(IX+21)	;set updated
;
;	check if file pointer buffer needs update
;
EXIT2	BIT	7,(IX+21)	;INDF buffer loaded?
	JR	Z,GODOS		;nope, exit
	BIT	6,(IX+21)	;needs update?
	JR	Z,GODOS		;nope, exit
;
;	update index file pointer buffer
;
	LD	B,(IX+27)	;get record #
	LD	H,(IX+28)
	LD	L,(IX+29)
	CALL	READIT		;read the sector
	JP	NZ,ERROR	;go on disk error
	EX	DE,HL		;DE => I/O buffer
	LD	HL,INDF		;index file buffer
	LD	BC,100H		;buffer length
	LDIR			;move it
	SET	4,(IX+47)	;set buffer updated
	CALL	WRITIT		;write the sector
	JP	NZ,ERROR	;go on error
	RES	6,(IX+21)	;set updated
;
;	exit to command mode
;
GODOS	LD	A,0<4+1		;return command mode
	JP	$OVRLAY		;go!
;
DONE	LD	IX,@DATA	;set pointer
	BIT	6,(IX+20)	;browsing?
	JP	NZ,$CMD		;yes, ignore count
	BIT	5,(IX+22)	;kill?
	LD	B,(IX+37)	;get match counter
	LD	H,(IX+38)
	LD	L,(IX+39)
	JR	NZ,DONEK	;go if kill
	LD	IX,MMSG1	;'matches'
	LD	DE,8<8+10	;length + base
	CALL	$BINASC		;binary => ascii
	LD	HL,MMSG		;start of text
DONEK2	CALL	$DOLINE		;display
	JP	EXIT		;exit program
DONEK	LD	IX,KMSG1	;'deleted'
	LD	DE,8<8+10	;length + base
	CALL	$BINASC		;convert to ascii
	LD	HL,KMSG		;'xx deleted'
	JR	DONEK2		;continue
;
;	parameters evaluated, and correct, init loop
;	display video mask area
;
CONT3	LD	IX,@DATA	;reset pointer
	LD	HL,0		;load IND0 buffer
	LD	B,H		;BHL = 000000
	CALL	READIT		;read it
	JP	NZ,ERROR	;go if error
	LD	DE,IND0		;buffer
	LD	BC,100H		;length
	LDIR			;move it
	SET	3,(IX+21)	;set loaded flag
	LD	HL,FILEMSK	;file mask
	CALL	$DOLINE		;display
	LD	HL,FILEMSE	;expanded fields
	BIT	6,(IX+10)	;expanded file?
	CALL	NZ,$DOLINE	;display rest if yes
	CALL	FLAGNAM		;display flag names
	BIT	6,(IX+22)	;full mask compare
	CALL	NZ,GETMASK	;yes, get from user
	LD	IX,@DATA	;reset pointer
	LD	B,(IX+23)	;check for global
	LD	H,(IX+24)
	LD	L,(IX+25)
;
	BIT	6,(IX+20)	;browsing?
	JP	NZ,BROWSER	;yes, go!
	LD	A,B		;check if nil
	AND	H
	AND	L
	INC	A		;=FFFFFF?
	JR	Z,GLOBAL	;yes, go global
;
;	edit/find on single drive
;
	CALL	PERFORM		;display BHL disk #
	JP	NZ,ERROR	;go on disk error
	JP	DONE		;exit if no error
;
;	on global drive
;
GLOBAL	LD	B,A		;set current disk #
	LD	H,A
	LD	L,1		;disk # = 000001
;
LOOP	CALL	PERFORM		;display BHL disk #
	JP	NZ,ERROR	;go on disk error
;
;	check if completed
;
	LD	B,(IX+23)	;get current disk #
	LD	H,(IX+24)
	LD	L,(IX+25)
	LD	C,(IX+51)	;get # disks used
	LD	D,(IX+52)
	LD	E,(IX+53)
	CALL	$CMP24		;at end?
	JP	Z,DONE		;yes, done!
	CALL	$INC24		;bump to next disk
	JR	LOOP		;continue
;
;	locate entries
;
PERFORM	LD	(IX+23),B	;set current disk #
	LD	(IX+24),H
	LD	(IX+25),L
;
;	compute sector number where name/date resides
;
	CALL	$DEC24		;adjust to zero relative
	LD	C,16		;entries / sector
	CALL	$DIVID		;divide it out
	ADD	A,A		;*2
	ADD	A,A		;*4
	ADD	A,A		;*8
	ADD	A,A		;*16
	LD	(IX+36),A	;save offset
	CALL	$INC24		;correct to sector #
;
;	read sector to locate name/date
;
	CALL	READIT		;load I/O buffer
	RET	NZ		;go on error
;
;	move disk name/date into string
;
	LD	C,(IX+36)	;name/date offset
	LD	B,0		;BC = offset
	ADD	HL,BC		;HL => name
;
;	check if deleted disk
;
	LD	A,(HL)		;get first byte
	AND	80H		;bit 7 only
	XOR	80H		;reverse it
	RET	Z		;disk does not exist
;
	LD	DE,NAMDAT	;put it here
	LD	C,16		;length
	LDIR			;move it
;
;	read INDF data to fetch disk type
;
	CALL	LDINDF		;load it
	RET	NZ		;go on disk error
	CALL	SHOW1		;display file data
	JP	DISP2		;continue
;
;	load disk type ascii string
;
SHOW1	LD	B,(IX+23)	;get disk #
	LD	H,(IX+24)
	LD	L,(IX+25)
	PUSH	IX		;save
	LD	IX,HMSG1	;text to load
	LD	DE,5<8+10	;length + base
	CALL	$BINASC		;binary => ascii
	POP	IX		;restore
;
	LD	HL,NAMDAT	;name/date stored here
	LD	DE,HMSG2	;text to load it
	LD	BC,8		;length
	LDIR			;move name
	LD	DE,HMSG3	;text to load
	LD	C,8		;length
	LDIR			;move date
;
	LD	A,(INDF+0FFH)	;get cylinder count
	INC	A		;FF = unknown?
	JR	Z,UNKNTYP	;go if yes
	DEC	A		;00 = added disk?
	JR	Z,SETUNKN	;yes, go!
	LD	L,A		;pass to LSB
	LD	H,0		;init nsb
	LD	B,H		;BHL = cylinder count
	PUSH	IX		;save
	LD	IX,HMSG5	;point to text
	LD	DE,3<8+10	;length + base
	CALL	$BINASC		;cyl count to ascii
	POP	IX		;restore pointer
	JR	CNTTPE		;continue
;
UNKNTYP	LD	A,'?'		;set unknown
	LD	(HMSG5),A	;to string
	LD	(HMSG5+1),A
	LD	(HMSG5+2),A
;
CNTTPE	LD	HL,INDF+0FEH	;point to flags
	LD	A,'S'		;single den?
	BIT	6,(HL)		;yes?
	JR	Z,$+4		;go if yes
	LD	A,'D'		;double den
	LD	(HMSG6),A	;pass to text
;
	LD	A,'S'		;single side?
	BIT	5,(HL)		;yes?
	JR	Z,$+4		;go if yes
	LD	A,'D'		;double sided
	LD	(HMSG7),A	;to string
;
	LD	A,'5'		;5"
	BIT	4,(HL)		;yes?
	JR	Z,$+4		;go if yes
	LD	A,'8'		;8"
	LD	(HMSG8),A	;to string
;
	LD	A,'F'		;floppy
	BIT	7,(HL)		;yes?
	JR	Z,$+4		;go if yes
	LD	A,'R'		;rigid drive
	LD	(HMSG9),A	;to string
;
	LD	HL,(INDF+0FCH)	;get free space
	LD	A,H		;check for nil
	AND	L
	INC	A		;=FFFF?
	LD	C,'?'		;set unknown
	JR	Z,SHOW1AB	;go if yes
	LD	A,H		;check for nil
	OR	L		;=0000?
	JR	Z,SHOW1AA	;go if yes
	LD	B,0		;BHL = free space
	PUSH	IX		;save
	LD	IX,HMSGA	;text to load
	LD	DE,5<8+10	;length +base
	CALL	$BINASC		;binary => ascii
	POP	IX		;restore
	JR	SHOW1A		;display
;
;	set unknown disk
;
SETUNKN	LD	A,'-'		;unknown text
	LD	(HMSG5),A	;cyl count
	LD	(HMSG5+1),A
	LD	(HMSG5+2),A
	LD	(HMSG6),A
	LD	(HMSG7),A
	LD	(HMSG8),A
	LD	(HMSG9),A
SHOW1AA	LD	C,'-'		;default char
SHOW1AB	LD	HL,HMSGA	;text
	LD	B,5		;length
	CALL	$CLEAR		;clear text
;
SHOW1A	LD	HL,HMSG		;start of text
	JP	$DOLINE		;display and return
;
;	setup loop to display files
;
;	check if all indexes to be read
;
DISP2	BIT	1,(IX+20)	;mask found?
	JR	Z,GLLINK	;global if not!
	BIT	2,(IX+20)	;reverse mask?
	JR	NZ,GLLINK	;yes, go!
	LD	A,'?'		;get first char mask
MASK	EQU	$-1
	CP	'?'		;all global?
	JR	Z,GLLINK	;global links
;
;	create index link pointer
;
	SUB	'A'		;convert to table entry
	JR	C,MAKECH1	;go if out range
	CP	26		;0-25?
	JR	C,MAKECH2	;go if OK
MAKECH1	LD	A,26		;set all others
MAKECH2	JR	SNLINK		;display single link
;
;	global links, setup loop
;
GLLINK	XOR	A		;set first link
;
GLOOP	PUSH	AF		;save link #
	CALL	SNLINK		;display link
	POP	BC		;B = current link#
	RET	NZ		;go on error
	LD	A,B		;get link #
	INC	A		;+1
	CP	27		;in range?
	JR	C,GLOOP		;yes, go next
	XOR	A		;set completed OK
	RET			;done!
;
;	display single link A
;
SNLINK	ADD	A,A		;*2
	ADD	A,A		;*4
	ADD	A,A		;*8
	LD	L,A		;pass LSB
	LD	H,INDF<-8	;load MSB
	LD	(INDFPTR),HL	;save pointer
	LD	B,(HL)		;get record start
	INC	HL		;bump
	LD	D,(HL)		;get nsb
	INC	HL		;bump
	LD	E,(HL)		;get lsb
	EX	DE,HL		;BHL = record #
;
SNLOOP	LD	A,B		;check for terminator
	AND	H
	AND	L
	INC	A		;BHL = FFFFFF?
	RET	Z		;yes, done!
	CALL	GETREC		;read record
	RET	NZ		;go on disk error
	CALL	$KBCHAR		;scan keyboard
	CP	_BREAK		;break key?
	JP	Z,DONE		;abort if yes
	LD	B,(IY+5)	;get forward link
	LD	H,(IY+6)
	LD	L,(IY+7)
	CALL	CKFILE		;check if file includes
	RET	NZ		;go on error
	JR	SNLOOP		;continue in link
;
;	evaluate user mask
;
HAVMASK	LD	A,(HL)		;get the char
	CP	'-'		;not mask?
	JR	NZ,HAVMSK1	;go if not
	SET	2,(IX+20)	;set NOT mask
	INC	HL		;bump past
;
HAVMSK1	CALL	$POSHL		;any more input?
	JR	NZ,HAVMSK2	;go if yes
	OR	-1		;invalid!
	RET			;error
;
HAVMSK2	LD	B,1		;command #
	CALL	$WILD		;load mask
	RET	NZ		;go if error
	SET	1,(IX+20)	;set mask found
	LD	A,(DE)		;get first mask char
	LD	(MASK),A	;save it
	RET			;and return
;
CKMASK	BIT	1,(IX+20)	;any mask found?
	JR	Z,CKMASKY	;check mask if not
	LD	B,2		;set <>0
	LD	HL,EBUFF+21	;start filename
	CALL	$WILD		;compare cracked
	JR	NZ,CKMASK1	;go if NO match
	BIT	2,(IX+20)	;NOT mask?
	JR	NZ,CKMASKN	;go if reverse
CKMASKY	OR	-1		;set MATCH
	RET
CKMASK1	BIT	2,(IX+20)	;NOT mask?
	JR	NZ,CKMASKY	;go if reverse
CKMASKN	XOR	A		;set NO MATCH
	RET			;done
CKMASKF	BIT	6,(IX+22)	;any mask?
	JR	Z,CKMASKY	;nope, set mask
	CALL	TSTMASK		;test against mask
	JR	Z,CKMASKY	;go if match
	JR	CKMASKN		;else set no match
;
;	check if valid disk # issued and return in BHL
;
DISKNO	INC	HL		;bump past #
	CALL	$VALUE		;fetch input value
	PUSH	HL		;save pointer
	JR	NZ,BADDISK	;go if error
	LD	B,C		;pass msb to B
	EX	DE,HL		;pass lsbs to HL (BHL=#)
	LD	A,B		;check msb
	OR	A		;>65536?
	JR	NZ,BADDISK	;disk # too big!
	OR	H		;check for 000000
	OR	L		;BHL = 000000?
	JR	Z,BADDISK	;yes, invalid #
	LD	C,(IX+51)	;get # disks used
	LD	D,(IX+52)
	LD	E,(IX+53)
	LD	A,C		;check for nil disks
	OR	D
	OR	E
	JR	Z,BADDISK	;yes, invalid #
	CALL	$CMP24		;compare
	JR	Z,OKDISK	;OK if equal
	JR	NC,BADDISK	;too big!
;
;	disk # bhl is OK
;
OKDISK	XOR	A		;set OK
	POP	DE		;restore pointer
	RET			;return disk #
;
;	disk is bad, return code
;
BADDISK	LD	HL,DISKMSG	;'bad disk #'
	CALL	$DOLINE		;display message
	JP	EXIT		;exit to command mode
;
;	read sector BHL from (@FCB)
;
READIT	CALL	WRITIT		;update buffer first!
	RET	NZ		;go on error
;
	BIT	5,(IX+21)	;buffer loaded?
	JR	Z,READYES	;nope, load it
;
;	check if requested sector loaded
;
	LD	C,(IX+33)	;get current buffer
	LD	D,(IX+34)
	LD	E,(IX+35)
	CALL	$CMP24		;BHL = CDE?
	JR	Z,READNO	;no need to read it!
;
READYES	RES	5,(IX+21)	;set buffer NO loaded
	RES	4,(IX+21)	;set NOT updated
	LD	(IX+33),B	;set as current sector
	LD	(IX+34),H
	LD	(IX+35),L
	LD	DE,(@FCB)	;file block
	LD	BC,@DATA+33	;point to record #
	CALL	$POSN		;position file
	RET	NZ		;go on error
	CALL	$READ		;read sector
	RET	NZ		;go on error
;
READNO	SET	5,(IX+21)	;set buffer loaded
	LD	HL,(@IOBUFF)	;get I/O buffer
	XOR	A		;set no error
	RET			;return with status
;
;	update I/O buffer before next read
;
WRITIT	BIT	5,(IX+21)	;buffer loaded?
	RET	Z		;nope, go!
	BIT	4,(IX+21)	;buffer updated?
	RET	Z		;nope, go!
;
	PUSH	BC		;save record #
	PUSH	HL
	LD	DE,(@FCB)	;get file block
	LD	BC,@DATA+33	;record #
	CALL	$POSN		;position to file
	JR	NZ,WRITER	;go if error
	CALL	$WRITE		;write the sector
WRITER	POP	HL		;restore record #
	POP	BC
	RET	NZ		;go if error
	RES	4,(IX+21)	;set buffer updated
	RET			;done
;
;	load record # BHL and return IY
;
GETREC	LD	(IX+30),B	;save file #
	LD	(IX+31),H
	LD	(IX+32),L
;
;	compute physical sector #/byte
;
	CALL	$DEC24		;adjust 0 relative
	BIT	6,(IX+10)	;running compressed?
	JR	NZ,GETRECE	;nope, get expanded
;
;	compute sector/byte compressed
;
	LD	C,8		;entries / sector
	CALL	$DIVID		;divide it
	RRCA			;align remainder
	RRCA
	RRCA
	AND	0E0H		;high 3 bits
	JR	GETRECC		;continue
;
GETRECE	LD	C,4		;entries / sector
	CALL	$DIVID		;divide it out
	RRCA			;align remainder
	RRCA			;to high bits
	AND	0C0H		;keep 2 only
;
GETRECC	LD	(IX+36),A	;save byte offset
	LD	C,(IX+70)	;get sector start files
	LD	D,(IX+71)
	LD	E,(IX+72)
	CALL	$ADD24		;BHL = sector #
	CALL	READIT		;read the sector
	RET	NZ		;go on error
	LD	C,(IX+36)	;get byte offset
	LD	B,0		;BC = offset
	ADD	HL,BC		;HL => record
	PUSH	HL		;pass to IY
	POP	IY		;IY => record
	XOR	A		;set NO error
	RET			;return with pointer
;
;	check if file qualifies for display
;
CKFILE	OR	A		;clear carry
	BIT	7,(IY+0)	;deleted file?
	JR	NZ,CKNOT	;yes, ignore
	BIT	6,(IY+0)	;never used?
	JR	NZ,CKNOT	;yes, ignore
	BIT	5,(IY+2)	;system file?
	JR	Z,CKFILE1	;continue if not
	BIT	4,(IX+20)	;system OK?
	JR	NZ,CKFILE2	;continue
;
CKNOT	XOR	A		;set NO error
	RET			;done
;
CKFILE1	BIT	6,(IY+2)	;invisible file?
	JR	Z,CKFILE2	;continue if not
	BIT	5,(IX+20)	;invis OK?
	JR	Z,CKNOT		;nope, skip
;
CKFILE2	BIT	3,(IX+20)	;mod only?
	JR	Z,CKFILE3	;go if all files
	BIT	7,(IY+2)	;file modified?
	JR	Z,CKNOT		;nope, go!
;
;	file OK, check for cat/dir
;
CKFILE3	LD	A,(IX+22)	;get data
	BIT	7,A		;index value?
	JR	Z,CKFILE4	;go if not
	AND	3		;low 2 bits
	LD	C,A		;save
	LD	A,(IY+0)	;get data
	RRCA			;align index
	RRCA
	AND	3		;low 2 bits
	CP	C		;match?
	JR	NZ,CKNOT	;go if NOT
;
CKFILE4	CALL	$SAVREG		;save registers
	CALL	UNPACK		;unpack record
	CALL	CKMASK		;compare file to mask
	RET	Z		;nope, go!
	CALL	CKMASKF		;check mask to file
	RET	Z		;no match, go!
	BIT	7,(IX+20)	;get flag
	JR	NZ,DOEDIT	;go if EDIT
;
;	FIND command, update count and wait for a key
;
DOFIND	CALL	UPDCNT		;update count
	CALL	DISPLAY		;display file info
	LD	IX,@DATA	;reset pointer
	LD	B,(IX+37)	;get match count
	LD	H,(IX+38)
	LD	L,(IX+39)
	LD	IX,FNDMSG1	;text to load
	LD	DE,8<8+10	;length + base
	CALL	$BINASC		;binary => ascii
	LD	HL,FNDMSG	;'found, key to cont'
	CALL	$DOLINE		;display message
;
	LD	IX,@DATA	;reset pointer
	BIT	0,(IX+20)	;nonstop mode?
	JR	NZ,SKPWAIT	;yes, continue
	CALL	$INKEY		;wait for enter key
	JP	C,DONE		;abort on BREAK
	JR	Z,SKPWAIT	;go on eneter
	CALL	$UCASE		;make upper case
	CP	'C'		;set nonstop?
	JR	NZ,SKPWAIT	;nope, go!
	SET	0,(IX+20)	;set nonstop
SKPWAIT	XOR	A		;else set NO error
	RET			;done!
;
;	edit file here
;
DOEDIT	BIT	5,(IX+22)	;kill?
	JR	Z,DOEDITA	;no, edit, continue
;
	BIT	0,(IX+20)	;nonstop kill?
	JR	NZ,DOKILL2	;go if yes
	CALL	PACK		;pack file
	CALL	DISPLAY		;and display it
	LD	IX,@DATA	;reset pointer
DOKILL1	LD	HL,KILLMSG	;'delete?'
	CALL	$DOLINE		;display
	CALL	$INKEY		;get key input
	JP	C,DONE		;abort on break
	JR	Z,DOKILL2	;default kill!
	CALL	$UCASE		;make upper case
	CP	'Y'		;yes?
	JR	Z,DOKILL2	;go if yes
	CP	'N'		;no?
	RET	Z		;yes, return
	CP	'C'		;set nonstop?
	JR	NZ,DOKILL1	;ask again if neither
	SET	0,(IX+20)	;set continuous
;
DOKILL2	CALL	UPDCNT		;bump counter
	JP	DELREC		;delete record
;
DOEDITA	CALL	UPDCNT		;update count
DOEDIT0	CALL	PACK		;re-pack file
	CALL	DISPLAY		;display file data
DOEDIT1	LD	IX,@DATA	;reset pointer
	LD	HL,EDITMSG	;'edit/delete/next/quit
	CALL	$DOLINE		;display prompt
	CALL	$INKEY		;get input key
	JP	C,DONE		;abort on break
	JR	Z,DEDIT		;default edit
	CALL	$UCASE		;make upper case
	CP	'E'		;edit?
	JR	Z,DEDIT		;go if yes
	CP	'D'		;delete?
	JR	Z,DDELETE	;go if yes
	CP	'Q'		;quit?
	JP	Z,DONE		;yes, go!
	SUB	'N'		;next?
	RET	Z		;yes, go!
	JR	DOEDIT1		;none, ask again
DDELETE	JP	DELREC		;delete record
DEDIT	CALL	EDITREC		;edit record
DEDIT1	LD	HL,EDTMSG1	;'save/edit/cont/quit
	CALL	$DOLINE		;display
	CALL	$INKEY		;get input
	JP	C,DONE		;go on break
	JR	Z,DEDITS	;save default
	CALL	$UCASE		;make upper case
	CP	'S'		;save?
	JR	Z,DEDITS	;go if yes
	CP	'E'		;edit?
	JR	Z,DEDIT		;re-edit
	CP	'Q'		;quit?
	JP	Z,DONE		;go if yes
	CP	'C'		;continue
	JR	NZ,DEDIT1	;re-ask if none
	JR	DOEDIT0		;continue
;
;	update current record
;
DEDITS	CALL	PACK		;re-pack record
	LD	IX,@DATA	;data pointer
	LD	B,(IX+30)	;current file #
	LD	H,(IX+31)
	LD	L,(IX+32)
	CALL	GETREC		;read record
	RET	NZ		;go on error
	PUSH	IY		;pass to DE
	POP	DE		;DE => current record
	LD	HL,CBUFF	;compressed buffer
	LD	BC,64		;expanded length
	BIT	6,(IX+10)	;running expanded?
	JR	NZ,$+4		;go if yes
	LD	C,32		;compressed length
	LDIR			;update buffer
	SET	4,(IX+21)	;set buffer updated
	XOR	A		;set NO error
	RET			;done, go next file
;
;	unpack record into ascii format
;
UNPACK	CALL	$SAVREG		;save registers
	PUSH	IY		;save
	POP	HL		;HL => compressed rec
	LD	DE,EBUFF	;DE => expanded rec
	LD	BC,11		;count
	LDIR			;move flags
;
;	check for expanded/compressed
;
	LD	A,(@FLAG1)	;get system flag
	BIT	6,A		;expanded?
	JR	NZ,UNPACKE	;go if yes
	LD	DE,EBUFF+21	;name goes here
	LD	B,17		;17 bytes to move
	CALL	UBITS		;unpack by bits
	LD	IY,EBUFF+74	;flags go here
	JR	UNPACKC		;do flags
;
;	move telephone
;
UNPACKE	LD	B,5		;5 compressed digits
UNPACK1	LD	A,(HL)		;get compressed digit
	INC	HL		;bump pointer
	LD	C,A		;save
	RRCA			;align high bits
	RRCA
	RRCA
	RRCA
	CALL	UNPACK2		;make ascii
	LD	A,C		;get digit
	CALL	UNPACK2		;make ascii
	DJNZ	UNPACK1		;go for count
	JR	UNPACK3		;continue
;
UNPACK2	AND	0FH		;low 4 bits only
	ADD	A,'0'		;make ascii
	LD	(DE),A		;load
	INC	DE		;bump
	RET			;loaded
;
UNPACK3	LD	B,53		;53 bits to move
	CALL	UBITS		;move bits
;
;	move flag data
;
UNPACKC	LD	B,12		;12 flags
UNPACK4	ADD	A,A		;bump count
	LD	E,0		;set flag off
	JR	NC,$+3		;go if off
	DEC	E		;set flag on
	LD	(IY+0),E	;load data
	INC	IY		;bump
	DEC	D		;less bits / byte
	JR	NZ,UNPACK5	;continue
	LD	D,8		;reset count
	LD	A,(IX+0)	;get next data
	INC	IX		;bump source
UNPACK5	DJNZ	UNPACK4		;go for flag count
	XOR	A		;set OK
	RET			;done
;
;	move bits from (HL) to (DE)
;
UBITS	PUSH	HL		;pass to IX
	POP	IX		;IX => source
	PUSH	DE		;pass to IY
	POP	IY		;IY => dest
	LD	DE,8<8+0	;D=bits/byte, E=byte
	LD	L,7		;bits to move / byte
	LD	A,(IX+0)	;get first data byte
	INC	IX		;bump pointer
;
UBITS2	ADD	A,A		;move bit to carry
	RL	E		;catch bit
	DEC	D		;less bits / byte
	JR	NZ,UBITS3	;more to go
	LD	D,8		;reset bit count
	LD	A,(IX+0)	;get next source
	INC	IX		;bump pointer
;
UBITS3	DEC	L		;less # bits / byte
	JR	NZ,UBITS2	;go till have 7
	LD	L,7		;reset # bits needed
	LD	(IY+0),E	;load data byte
	INC	IY		;bump pointer
	LD	E,0		;reset byte
UBITS4	DJNZ	UBITS2		;go for count
	RET			;done!
;
;	load INDF buffer
;
;	read current disk index link for record pointers
;
LDINDF	BIT	7,(IX+21)	;buffer loaded?
	JR	Z,LDINDF0	;go if not
	BIT	6,(IX+21)	;buffer updated?
	JR	Z,LDINDF0	;go if not
;
	LD	B,(IX+27)	;get sector #
	LD	H,(IX+28)
	LD	L,(IX+29)
	CALL	READIT		;read the sector
	RET	NZ		;go on error
	EX	DE,HL		;DE => buffer
	LD	HL,INDF		;index buffer
	LD	BC,100H		;buffer length
	LDIR			;move it
	SET	4,(IX+21)	;set buffer updated
	RES	6,(IX+21)	;clear flag
;
LDINDF0	LD	B,(IX+23)	;get current disk #
	LD	H,(IX+24)
	LD	L,(IX+25)
	CALL	$DEC24		;adjust 0 relative
	LD	C,(IX+57)	;get start disk tables
	LD	D,(IX+58)
	LD	E,(IX+59)
	CALL	$ADD24		;BHL = sector needed
	RES	7,(IX+21)	;set NOT loaded
	LD	(IX+27),B	;save rel sector #
	LD	(IX+28),H
	LD	(IX+29),L
	CALL	READIT		;read the critter
	RET	NZ		;go on error
	LD	DE,INDF		;place buffer here
	LD	BC,100H		;buffer length
	LDIR			;save it
	SET	7,(IX+21)	;set LOADED
	XOR	A		;set Z flag for OK
	RET			;return Z
;
;	update file counter
;
UPDCNT	LD	IX,@DATA	;data pointer
	LD	B,(IX+37)	;get match count
	LD	H,(IX+38)
	LD	L,(IX+39)
	CALL	$INC24		;bump it
	LD	(IX+37),B	;update count
	LD	(IX+38),H
	LD	(IX+39),L
	RET			;done
;
;	check if any files available
;
NEFILES	LD	A,(IX+73)	;get data
	OR	(IX+74)
	OR	(IX+75)
	RET	NZ		;go if some here
	LD	HL,EMPMSG	;'index empty'
	JP	ERREX		;display and exit
;
*GET	DMAN07A
*GET	DMAN07B
*GET	DMAN07C
*GET	DMAN07D
;
;	text area
;
ERMSG1	DEFB	_STX
	DEFB	@VID+1,00
	DEFB	_EREOF
	DEFM	'Invalid Command Parameter - Use HELP'
	DEFB	_ETX
;
NILMASK	DEFM	'!'
	DEFB	_CR
;
MSKMSG	DEFB	_STX
	DEFB	@VID,000
	DEFM	'Enter Search Mask:'
	DEFB	_EREOL
	DEFB	_ETX
;
FLGEMG	DEFB	_STX
	DEFB	@VID+1,000
	DEFM	'Flag I/O Error - '
	DEFB	_ETX
;
KILLMSG	DEFB	_STX
	DEFB	@VID,000
	DEFM	'Delete? '
	DEFB	_EREOL
	DEFB	_ETX
;
BROWMSG	DEFB	_STX
	DEFB	@VID,000
BROWMG	DEFM	'Paging Command (U/D/L/R/+/-/B)? '
	DEFB	_EREOL
	DEFB	_ETX
;
BROWMS	DEFB	_STX
	DEFB	@VID,000
	DEFM	'End Of File, '
	DEFB	_ETX
;
EDITMSG	DEFB	_STX
	DEFB	@VID,000
	DEFM	'E(dit, D)elete, N)ext, Q)uit? '
	DEFB	_EREOL
	DEFB	_ETX
;
DELMSG1	DEFB	_STX
	DEFB	@VID,000
	DEFM	'Deleting ...'
	DEFB	_EREOL
	DEFB	_ETX
;
PROMPT2	DEFB	_STX
	DEFB	@VID,000
	DEFM	'Buffers Need Updating, Attempt? '
	DEFB	_EREOL
	DEFB	_ETX
;
EDTMSG1	DEFB	_STX
	DEFB	@VID,000
	DEFM	'S(ave, E)dit, C)ontinue, Q)uit? '
	DEFB	_EREOL
	DEFB	_ETX
;
FNDMSG	DEFB	_STX
	DEFB	@VID,000
	DEFM	'Found:'
FNDMSG1	DEFM	'........, Key <ENTER> to continue:'
	DEFB	_EREOL
	DEFB	_ETX
;
NOTMSG	DEFB	_STX
	DEFB	@VID+1,000
	DEFB	_EREOF
	DEFM	'Index File Not Available - Use OPEN'
	DEFB	_ETX
;
EMPMSG	DEFB	_STX
	DEFB	@VID+1,000
	DEFB	_EREOF
	DEFM	'Index Empty - Use LOG'
	DEFB	_ETX
;
DISKMSG	DEFB	_STX
	DEFB	@VID+1,000
	DEFB	_EREOF
	DEFM	'Invalid Disk Number'
	DEFB	_ETX
;
DISKERR	DEFB	_STX
	DEFB	@VID+1,00
	DEFB	_EREOF
	DEFM	'System Error - '
	DEFB	_ETX
;
HMSG	DEFB	_STX
	DEFB	@VID+2,00
	DEFM	'#'
HMSG1	DEFM	'..... - '
HMSG2	DEFM	'........ - '
HMSG3	DEFM	'........ - '
HMSG5	DEFM	'.../'
HMSG6	DEFM	'.D/'
HMSG7	DEFM	'.S/'
HMSG8	DEFM	'."/'
HMSG9	DEFM	'. - '
HMSGA	DEFM	'.....k'
	DEFB	_EREOL
	DEFB	_ETX
;
MMSG	DEFB	_STX
	DEFB	@VID+1,000
	DEFB	_EREOF
MMSG1	DEFM	'........ Matches Total'
	DEFB	_ETX
;
KMSG	DEFB	_STX
	DEFB	@VID+1,000
	DEFB	_EREOF
KMSG1	DEFM	'........ Files Deleted'
	DEFB	_ETX
;
;	buffers
;
NAMDAT	DEFM	'................'
;
DBUFF	EQU	$&0FF00H
IND0	EQU	DBUFF+100H	;first sector buffer
INDF	EQU	IND0+100H	;index sector buffer
CBUFF	EQU	INDF+100H	;compressed buffer
EBUFF	EQU	CBUFF+100H	;expanded buffer
MBUFF	EQU	EBUFF+100H	;mask buffer
;
_______	EQU	MBUFF+100H	;free byte
	ORG	_______-1	;last used
	DEFB	0
;
	END	ENTRY
