; dman06/asm - kjw/bci - CHECK/TEST
;
;	created 08/29/83	- kjw/bci
;	revised 09/24/83	- kjw/bci
;
;	system data usage
;
;	+20-22	- current disk #
;	+23	- current index position
;	+24-26	- current link start
;	+27-29	- current link end
;	+30-32	- current record #
;	+33-35	- current sector in buffer
;	+36	- current byte offset in buffer
;	+37-39	- non-corrected error count
;	+40-42	- corrected error count
;	+43-45	- last record number in linkage
;	+46	- unused
;	+47	7 / 1=buffer loaded
;		6 / 1=backward link check
;		5 / 1=display mode only, no prompt
;		4 / 1=continuous repair, no prompt
;		3 / 1=INDF buffer needs update
;		2 / 1=dual output to video/printer
;
ENTRY	LD	IX,@DATA	;start data block
	EX	DE,HL		;DE => input
	BIT	7,(IX+10)	;file open?
	JR	NZ,START	;yes, go!
;
;	index file not open
;
	LD	HL,NOTMSG	;'not available'
	JP	ERREX		;back to command mode
;
START	LD	A,(IX+51)	;any disks used?
	OR	(IX+52)
	OR	(IX+53)
	JR	NZ,START0	;go if yes
	LD	HL,EMPMSG	;index empty
	JP	ERREX		;to command mode
;
START0	XOR	A		;init zero
	LD	(IX+47),A	;clear flags
	LD	(IX+37),A	;non-corrected errors
	LD	(IX+38),A
	LD	(IX+39),A
	LD	(IX+40),A	;corrected errors
	LD	(IX+41),A
	LD	(IX+42),A
	LD	(IX+96),0	;init start disk #
	LD	(IX+97),0
	LD	(IX+98),1
	LD	B,(IX+51)	;get # disks used
	LD	H,(IX+52)
	LD	L,(IX+53)
	LD	(IX+99),B	;set high disk #
	LD	(IX+100),H
	LD	(IX+101),L
	EX	DE,HL		;HL => input
;
;	evaluate user input
;
	CALL	$POSHL		;any input?
	JP	Z,BEGIN		;nope, go!
	CP	'#'		;disk #
	JR	Z,GETDISK	;yes, go!
	CP	'('		;params?
	JR	Z,PARAM		;yes, go!
;
;	invalid input
;
	LD	HL,DSKMSG	;'invalid disk #'
	JR	ERREX		;continue
;
INVALID	LD	HL,INVMSG	;'invalid parameters'
ERREX	CALL	$DOLINE		;display
	JP	EXIT		;and return to cmd mode
;
;	fetch disk # from user
;
GETDISK	INC	HL		;bump past indicator
	LD	A,(HL)		;get next char
	CP	'-'		;range to?
	JR	Z,SETHI		;yes, low preset
;
SETLO	CALL	DISKNO		;get disk number
	LD	(IX+96),B	;set start number
	LD	(IX+97),H
	LD	(IX+98),L
	EX	DE,HL		;HL => data
	LD	A,(HL)		;get next char
	CP	'-'		;range?
	JR	NZ,SETONE	;nope, single disk
	INC	HL		;bump past
	LD	A,(HL)		;get next char
	CP	'0'		;numeric?
	JR	C,SETCNT	;nope, go!
	CP	'9'+1		;numeric?
	JR	NC,SETCNT	;nope, go!
	DEC	HL		;adjust for immed inc
;
SETHI	INC	HL		;bump pointer
	CALL	DISKNO		;get disk number
INSTHI	LD	(IX+99),B	;save high disk #
	LD	(IX+100),H
	LD	(IX+101),L
	EX	DE,HL		;swap to pointer
	JR	SETCNT		;continue
;
SETONE	EX	DE,HL		;swap back
	JR	INSTHI		;install high
;
SETCNT	CALL	$POSHL		;any more input?
	JR	Z,BEGIN		;nope, go!
	CP	'('		;must be params
	JR	NZ,INVALID	;nope, syntax error
;
;	evaluate disk parameters
;
PARAM	INC	HL		;bump to next entry
	CALL	$POSHL		;any more input?
	JR	Z,BEGIN		;nope, go!
	CP	')'		;terminator?
	JR	Z,BEGIN		;yes, go!
	CP	_REMARK		;terminator?
	JR	Z,BEGIN		;yes, go!
	CALL	$UCASE		;make upper case
	CP	'B'		;backward test?
	JR	Z,PARAMB	;yes, go!
	CP	'F'		;forward test?
	JR	Z,PARAMF	;yes, go!
	CP	'R'		;continuous repair?
	JR	Z,PARAMR	;yes, go!
	CP	'P'		;dual output?
	JR	Z,PARAMP	;yes, go!
	CP	'D'		;continuous display only?
	JR	NZ,INVALID	;none, abort
;
PARAMC	SET	5,(IX+47)	;set non-prompting
	JR	PARAM		;continue
PARAMB	SET	6,(IX+47)	;set backward link check
	JR	PARAM		;continue
PARAMF	RES	6,(IX+47)	;set forward link check
	JR	PARAM		;continue
PARAMR	SET	4,(IX+47)	;set continuous repair
	JR	PARAM		;continue
PARAMP	SET	2,(IX+47)	;set dual output
	JR	PARAM		;continue
;
;	parameters evaluated, setup loop
;
BEGIN	LD	HL,VIDSET	;video clear and setup
	CALL	$DOLINE		;display
	JR	GLOBAL		;setup loop
;
;	exit to dos command mode
;
ABORT	LD	HL,CRMSG	;carriage return
	CALL	TEXT		;display
RSTART	LD	A,9<4+1		;command 9, sys1
	JP	$OVRLAY		;back to it
;
EXIT	LD	A,0<4+1		;command 0, sys1
	JP	$OVRLAY		;back to it
;
ERROR	LD	DE,ERRMSG	;'system error - '
	CALL	$DOERR		;display error
	JR	RSTART		;exit to command mode
;
;	setup loop to go global disks
;
GLOBAL	LD	IX,@DATA	;reset pointer
	LD	B,(IX+96)	;get start disk #
	LD	H,(IX+97)
	LD	L,(IX+98)
;
LOOP	CALL	$KBCHAR		;scan keyboard
	CP	_BREAK		;break key?
	JP	Z,ABORT		;yes, abort it!
;
	CALL	CHECK		;check it out
	JR	NZ,ERROR	;go if error
;
;	check if completed
;
	LD	B,(IX+20)	;get current disk #
	LD	H,(IX+21)
	LD	L,(IX+22)
	LD	C,(IX+99)	;get highest disk #
	LD	D,(IX+100)
	LD	E,(IX+101)
	CALL	$CMP24		;compare
	JR	Z,COMPLET	;done, display error cnt.
	CALL	$INC24		;bump disk #
	JR	LOOP		;check next disk #
;
;	routine completed, display error counts
;
COMPLET	LD	B,(IX+40)	;get # corrected errors
	LD	H,(IX+41)
	LD	L,(IX+42)
	PUSH	BC		;save on stack
	PUSH	HL
	PUSH	IX		;save data pointer
	LD	IX,CMPMSG1	;text to load
	LD	DE,8<8+10	;length + base
	CALL	$BINASC		;binary => ascii
	POP	IX		;restore data pointer
	LD	B,(IX+37)	;get # non-corrected
	LD	H,(IX+38)
	LD	L,(IX+39)
	PUSH	BC		;save on stack
	PUSH	HL
	PUSH	IX		;save data pointer
	LD	IX,CMPMSG2	;text to load
	LD	DE,8<8+10	;length + base
	CALL	$BINASC		;convert to ascii
	POP	IX		;restore pointer
	POP	HL		;get # non-corrected
	POP	BC		;BHL = non-corrected
	POP	DE		;get # corrected
	POP	AF
	LD	C,A		;CDE = corrected
	CALL	$ADD24		;get total error count
	PUSH	IX		;save data pointer
	LD	IX,CMPMSG0	;text to load
	LD	DE,8<8+10	;length + base
	CALL	$BINASC		;convert to ascii
	POP	IX		;restore data
	LD	HL,CMPMSG	;message start
	CALL	TEXT		;display
	JP	RSTART		;and exit program
;
	PAGE
;
;	check if disk links OK
;
CHECK	LD	(IX+20),B	;save current disk #
	LD	(IX+21),H
	LD	(IX+22),L
	PUSH	BC		;save disk #
	PUSH	HL
	PUSH	IX		;save pointer
	LD	IX,HMSG0	;text to load ascii
	LD	DE,5<8+10	;length + base
	CALL	$BINASC		;disk # to ascii
	POP	IX		;restore data pointer
	POP	HL		;get disk #
	POP	BC
;
;	compute sector/byte for disk name/date
;
	CALL	$DEC24		;adjust 0 relative
	LD	C,16		;entries / sector
	CALL	$DIVID		;divide it
	ADD	A,A		;*2
	ADD	A,A		;*4
	ADD	A,A		;*8
	ADD	A,A		;*16
	LD	(IX+36),A	;save byte offset
	CALL	$INC24		;BHL = relative sector
	CALL	READIT		;read the sector
	RET	NZ		;go if disk error
	LD	C,(IX+36)	;get byte offset
	LD	B,0		;BC = offset
	ADD	HL,BC		;HL => disk name/date
;
;	check if deleted disk
;
	BIT	7,(HL)		;bit 7 set?
	JP	NZ,DELDISK	;yes, go!
	LD	DE,HMSG1	;text to load
	LD	C,8		;name length
	LDIR			;move disk name
	LD	DE,HMSG2	;text to load
	LD	C,8		;name length
	LDIR			;move disk date
;
;	read INDEX sector to fetch disk type and links
;
	LD	B,(IX+20)	;get disk # back
	LD	H,(IX+21)
	LD	L,(IX+22)
	CALL	$DEC24		;adjust 0 relative
	LD	C,(IX+57)	;get start disk tables
	LD	D,(IX+58)
	LD	E,(IX+59)
	CALL	$ADD24		;get table sector
	CALL	READIT		;read the sector
	RET	NZ		;go on disk error
	LD	DE,INDF		;index buffer
	LD	BC,100H		;buffer length
	LDIR			;save it
	RES	3,(IX+47)	;flag as new buffer
;
;	get cylinder count/disk type flags
;
	LD	A,(INDF+0FFH)	;get cylinder count
	INC	A		;FF = unknown?
	JR	Z,UNKNTYP	;go if yes
	DEC	A		;00 = added disk?
	JR	Z,NILTYPE	;nope, default text
	LD	L,A		;pass to BHL
	LD	H,0
	LD	B,H
	PUSH	IX		;save data pointer
	LD	IX,HMSG3	;text to load
	LD	DE,3<8+10	;length + base
	CALL	$BINASC		;convert to ascii
	POP	IX		;restore pointer
	JR	CNTTPE		;continue
;
UNKNTYP	LD	A,'?'		;set unknown
	LD	(HMSG3),A	;to text
	LD	(HMSG3+1),A
	LD	(HMSG3+2),A
;
CNTTPE	LD	HL,INDF+0FEH	;point to flags
	LD	A,'S'		;single den?
	BIT	6,(HL)		;yes?
	JR	Z,$+4		;go if yes
	LD	A,'D'		;else double
	LD	(HMSG4),A	;to text
;
	LD	A,'S'		;single side?
	BIT	5,(HL)		;yes?
	JR	Z,$+4		;go if yes
	LD	A,'D'		;double side
	LD	(HMSG5),A	;to text
;
	LD	A,'5'		;5" disk?
	BIT	4,(HL)		;yes?
	JR	Z,$+4		;go if yes
	LD	A,'8'		;8" disk
	LD	(HMSG6),A	;to text
;
	LD	A,'F'		;floppy
	BIT	7,(HL)		;yes?
	JR	Z,$+4		;go if yes
	LD	A,'R'		;rigid
	LD	(HMSG7),A	;to text
;
	LD	HL,(INDF+0FCH)	;get free space
	LD	A,H		;check for nil
	AND	L
	INC	A		;=FFFF?
	LD	C,'?'		;set unknown
	JR	Z,SHOW1AB	;go if yes
	LD	A,H		;check for nil
	OR	L		;=0000?
	JR	Z,SHOW1AA	;go if yes
	LD	B,0		;BHL = free space
	PUSH	IX		;save
	LD	IX,HMSG8	;text to load
	LD	DE,5<8+10	;length + base
	CALL	$BINASC		;binary => ascii
	POP	IX		;restore
	JR	CONTTYP		;continue
;
NILTYPE	LD	A,'-'		;set nil type
	LD	(HMSG3),A	;to text
	LD	(HMSG3+1),A
	LD	(HMSG3+2),A
	LD	(HMSG4),A
	LD	(HMSG5),A
	LD	(HMSG6),A
	LD	(HMSG7),A
SHOW1AA	LD	C,'-'		;default char
SHOW1AB	LD	HL,HMSG8	;start of text
	LD	B,5		;length
	CALL	$CLEAR		;clear text
;
CONTTYP	LD	HL,HMSG		;start of message
	CALL	TEXT		;display output
;
;	setup loop to check disk linkages
;
	XOR	A		;set current index posit
CLOOP	LD	(IX+23),A	;save current posit
	ADD	A,A		;*2
	ADD	A,A		;*4
	ADD	A,A		;*8
	LD	L,A		;pass to L
	LD	H,INDF<-8	;HL => current index
	LD	(INDPOS),HL	;save index pointer
	PUSH	HL		;pass to IY
	POP	IY		;IY => links
;
;	display current link being checked
;
	LD	A,(IX+23)	;get current link
	ADD	A,'A'		;add ascii
	CP	'Z'+1		;at last?
	JR	C,$+4		;go if not
	LD	A,'?'		;else set last link
	LD	(LNKMSG1),A	;load to text
	LD	HL,LNKMSG	;start of text
	CALL	$DOLINE		;display
;
;	check if forward/backward
;
	BIT	6,(IX+47)	;backward check?
	JP	NZ,BACKCHK	;yes, go!
;
;	checking in forward manner
;
FORWCHK	LD	B,(IY+0)	;get first record
	LD	H,(IY+1)
	LD	L,(IY+2)
	LD	A,B		;check if any
	AND	H
	AND	L
	INC	A		;term?
	JR	NZ,FORW0	;not term, check it out
;
;	no first record indicates nil linkage
;
	LD	B,(IY+3)	;get last record
	LD	H,(IY+4)
	LD	L,(IY+5)
	LD	A,B		;check for terminator
	AND	H
	AND	L
	INC	A		;bump
	JP	Z,FORWB2	;go if nil also
	LD	HL,POSMSG	;'possible records lost'
	LD	DE,LNKMSG	;message 2
	CALL	TEXT2		;display message
	JP	FORWB2		;continue
;
FORW0	CALL	GETREC		;read record
	RET	NZ		;go if error
	CALL	DELCHK		;check for deleted
	RET	NZ		;go on error
	LD	B,(IY+8)	;get backward link
	LD	H,(IY+9)
	LD	L,(IY+10)
	LD	A,B		;check if any
	AND	H
	AND	L
	INC	A		;terminator?
	JR	Z,FORW1		;OK, go forward loop
;
;	error in first record, check if to be fixed
;
	LD	HL,FRECMSG	;'first record bad link
	CALL	FIXIT		;fix it?
	JR	NZ,FORW1	;nope, continue forward
;
;	keep looking backward to get first record
;
FIRLP	LD	B,(IY+8)	;get backward link
	LD	H,(IY+9)
	LD	L,(IY+10)
	LD	A,B		;check for terminator
	AND	H
	AND	L
	INC	A		;last?
	JR	Z,FIRFND	;yes, first found!
	CALL	GETREC		;read backward link
	RET	NZ		;go on error
	CALL	DELCHK		;check for deleted
	RET	NZ		;go on error
	JR	FIRLP		;keep looking backward
;
FIRFND	LD	IY,-1		;get index pointer
INDPOS	EQU	$-2
	LD	B,(IX+30)	;get current record #
	LD	H,(IX+31)
	LD	L,(IX+32)
	LD	(IY+0),B	;save as first record
	LD	(IY+1),H
	LD	(IY+2),L
	SET	3,(IX+47)	;set buffer needs update
	JR	FORWCHK		;check forward links
;
;	scan forward records
;
FORW1	LD	(IX+43),-1	;reset last record #
	LD	(IX+44),-1
	LD	(IX+45),-1
;
FORW2	LD	B,(IY+8)	;get backward link
	LD	H,(IY+9)
	LD	L,(IY+10)
	LD	C,(IX+43)	;get last record read
	LD	D,(IX+44)
	LD	E,(IX+45)
	CALL	$CMP24		;match?
	JR	Z,FORW2A	;continue if OK
;
	LD	HL,BADBMSG	;'bad backward link
	CALL	FIXIT		;fix the link?
	JR	NZ,FORW2A	;nope, continue looking
	LD	B,(IX+43)	;get last record
	LD	H,(IX+44)
	LD	L,(IX+45)
	LD	(IY+8),B	;fix backward link
	LD	(IY+9),H
	LD	(IY+10),L
	CALL	WRITIT		;write to disk
	RET	NZ		;go if error
FORW2A	LD	B,(IY+5)	;get forward link
	LD	H,(IY+6)
	LD	L,(IY+7)
	LD	A,B		;check for terminator
	AND	H
	AND	L
	INC	A		;terminator?
	JR	Z,FORW3		;yes, check if link OK
	PUSH	HL		;save record #
	PUSH	BC
;
	LD	B,(IX+30)	;get current record
	LD	H,(IX+31)
	LD	L,(IX+32)
	LD	(IX+43),B	;update last record
	LD	(IX+44),H
	LD	(IX+45),L
	POP	BC		;restore record #
	POP	HL
	CALL	GETREC		;read record
	RET	NZ		;go if error
	CALL	DELCHK		;check deleted
	RET	NZ		;go on error
	JR	FORW2		;continue
;
FORW3	LD	IY,(INDPOS)	;point to links
	LD	B,(IX+30)	;get current record #
	LD	H,(IX+31)
	LD	L,(IX+32)
	LD	C,(IY+3)	;get last link #
	LD	D,(IY+4)
	LD	E,(IY+5)
	CALL	$CMP24		;match?
	JR	Z,FORWB		;yes, OK, go next link
;
	LD	HL,LRECMSG	;'last link in error'
	CALL	FIXIT		;fix it?
	JR	NZ,FORWB	;nope, continue
	LD	B,(IX+30)	;get last record #
	LD	H,(IX+31)
	LD	L,(IX+32)
	LD	(IY+3),B	;set as last link
	LD	(IY+4),H
	LD	(IY+5),L
	SET	3,(IX+47)	;set buffer needs update
;
FORWB	BIT	3,(IX+47)	;buffer needs update?
	JR	Z,FORWB2	;nope, continue
;
	LD	B,(IX+20)	;get current disk #
	LD	H,(IX+21)
	LD	L,(IX+22)
	CALL	$DEC24		;adjust 0 relative
	LD	C,(IX+57)	;start disk tables
	LD	D,(IX+58)
	LD	E,(IX+59)
	CALL	$ADD24		;BHL = sector #
	CALL	READIT		;read again
	RET	NZ		;go if error
	EX	DE,HL		;DE => buffer
	LD	HL,INDF		;updated table
	LD	BC,100H		;buffer length
	LDIR			;move buffer
	CALL	WRITIT		;update to disk
	RET	NZ		;go on disk error
;
FORWB2	LD	A,(IX+23)	;get current index posit
	INC	A		;+1
	CP	27		;0-26?
	JP	C,CLOOP		;in range, continue
	XOR	A		;else set completed
	RET			;done!
;
;	search via backward links
;
BACKCHK	LD	B,(IY+3)	;get last record
	LD	H,(IY+4)
	LD	L,(IY+5)
	LD	A,B		;check if any
	AND	H
	AND	L
	INC	A		;terminator?
	JR	NZ,BACK0	;nope, continue
;
;	no last record indicates nil linkage
;
	LD	B,(IY+0)	;get first record
	LD	H,(IY+1)
	LD	L,(IY+2)
	LD	A,B		;check for term
	AND	H
	AND	L
	INC	A		;=FFFFFF?
	JP	Z,BACKB2	;OK, nil also!
	LD	HL,POSMSG2	;possible record loss
	LD	DE,LNKMSG	;message 2
	CALL	TEXT2		;display
	JP	BACKB2		;continue
;
BACK0	CALL	GETREC		;read record
	RET	NZ		;go on error
	CALL	DELCHK		;deleted record
	RET	NZ		;go on error
	LD	B,(IY+5)	;get forward link
	LD	H,(IY+6)
	LD	L,(IY+7)
	LD	A,B		;check if any
	AND	H
	AND	L
	INC	A		;terminator?
	JR	Z,BACK1		;OK, continue
;
;	error in last record, check if to be fixed
;
	LD	HL,LRECMSG	;'last record bad link'
	CALL	FIXIT		;repair?
	JR	NZ,BACK1	;nope, continue
;
;	keep looking forward to get last entry
;
LASLP	LD	B,(IY+5)	;get forward link
	LD	H,(IY+6)
	LD	L,(IY+7)
	LD	A,B		;check for last
	AND	H
	AND	L
	INC	A		;terminator?
	JR	Z,LASFND	;yes, found last!
	CALL	GETREC		;read next record
	RET	NZ		;go on error
	CALL	DELCHK		;check for deleted
	RET	NZ		;go if error
	JR	LASLP		;keep looking forward
;
LASFND	LD	IY,(INDPOS)	;get index position
	LD	B,(IX+30)	;get current record
	LD	H,(IX+31)
	LD	L,(IX+32)
	LD	(IY+3),B	;set as last record
	LD	(IY+4),H
	LD	(IY+5),L
	SET	3,(IX+47)	;set buffer needs update
	JR	BACKCHK		;check new linkage!
;
;	scan backward records
;
BACK1	LD	(IX+43),-1	;reset first record #
	LD	(IX+44),-1
	LD	(IX+45),-1
;
BACK2	LD	B,(IY+5)	;get forward link
	LD	H,(IY+6)
	LD	L,(IY+7)
	LD	C,(IX+43)	;get last record #
	LD	D,(IX+44)
	LD	E,(IX+45)
	CALL	$CMP24		;compare
	JR	Z,BACK2A	;continue if OK
;
	LD	HL,BADFMSG	;'bad forward link'
	CALL	FIXIT		;repair?
	JR	NZ,BACK2A	;nope, continue
	LD	B,(IX+43)	;get last record
	LD	H,(IX+44)
	LD	L,(IX+45)
	LD	(IY+5),B	;correct forward link
	LD	(IY+6),H
	LD	(IY+7),L
	CALL	WRITIT		;update to disk
	RET	NZ		;go on error
;
BACK2A	LD	B,(IY+8)	;get backward link
	LD	H,(IY+9)
	LD	L,(IY+10)
	LD	A,B		;check for terminator
	AND	H
	AND	L
	INC	A		;done?
	JR	Z,BACK3		;yes, check if link OK
;
	PUSH	HL		;save record #
	PUSH	BC
	LD	B,(IX+30)	;get current record #
	LD	H,(IX+31)
	LD	L,(IX+32)
	LD	(IX+43),B	;update last record #
	LD	(IX+44),H
	LD	(IX+45),L
	POP	BC		;restore record #
	POP	HL
	CALL	GETREC		;read from disk
	RET	NZ		;go on disk error
	CALL	DELCHK		;check if deleted
	RET	NZ		;go if error
	JR	BACK2		;continue link
;
BACK3	LD	IY,(INDPOS)	;point to links
	LD	B,(IX+30)	;get current record #
	LD	H,(IX+31)
	LD	L,(IX+32)
	LD	C,(IY+0)	;get first link#
	LD	D,(IY+1)
	LD	E,(IY+2)
	CALL	$CMP24		;compare
	JR	Z,BACKB		;yes, ok, go next link
;
	LD	HL,FRECMSG	;'first link is bad'
	CALL	FIXIT		;repair?
	JR	NZ,BACKB	;nope, continue
	LD	B,(IX+30)	;get last record #
	LD	H,(IX+31)
	LD	L,(IX+32)
	LD	(IY+0),B	;set as first link rec
	LD	(IY+1),H
	LD	(IY+2),L
	SET	3,(IX+47)	;set buffer needs update
;
BACKB	BIT	3,(IX+47)	;buffer needs update?
	JR	Z,BACKB2	;nope, continue
;
	LD	B,(IX+20)	;get current disk #
	LD	H,(IX+21)
	LD	L,(IX+22)
	CALL	$DEC24		;adjust 0 relative
	LD	C,(IX+57)	;start disk tables
	LD	D,(IX+58)
	LD	E,(IX+59)
	CALL	$ADD24		;BHL = sector #
	CALL	READIT		;read the sector
	RET	NZ		;go on error
	EX	DE,HL		;DE => I/O buffer
	LD	HL,INDF		;index buffer
	LD	BC,100H		;length
	LDIR			;move buffer
	CALL	WRITIT		;write to disk
	RET	NZ		;go on disk error
;
BACKB2	LD	A,(IX+23)	;get current index posit
	INC	A		;bump to next
	CP	27		;at end?
	JP	C,CLOOP		;nope, continue
	XOR	A		;set NO error
	RET			;done!
;
;	current disk is deleted
;
DELDISK	LD	HL,HMSG0	;disk #
	LD	DE,DELMSG1	;move it here
	LD	BC,5		;length
	LDIR			;disk # loaded
	LD	HL,DELMSG	;'disk is deleted'
	CALL	TEXT		;display
	XOR	A		;set NO error
	RET			;done
;
FIXIT	CALL	TEXT		;display error
	BIT	4,(IX+47)	;continuous repair?
	JR	NZ,FIXYES	;yes, force fix
	BIT	5,(IX+47)	;display only?
	JR	NZ,FIXNO	;nope, no prompt
;
FIXQU	LD	HL,FIXMSG	;'repair error?'
	CALL	$DOLINE		;display it
	CALL	$INKEY		;get key input
	PUSH	AF		;save input
	LD	HL,LNKMSG	;restore video
	CALL	$DOLINE		;display it
	POP	AF		;restore key input
	JP	C,ABORT		;abort on break
	JR	Z,FIXYES	;default yes
	CALL	$UCASE		;make upper case
	CP	'Q'		;quit?
	JP	Z,ABORT		;go if yes
	CP	'C'		;continuous repair?
	JR	Z,FIXR		;yes, go!
	CP	'D'		;set display only?
	JR	Z,FIXD		;yes, go!
	CP	'F'		;yes?
	JR	Z,FIXYES	;yes, go!
	CP	'I'		;no?
	JR	NZ,FIXQU	;neither, ask again
;
FIXNO	LD	B,(IX+37)	;get non corrected errors
	LD	H,(IX+38)
	LD	L,(IX+39)
	CALL	$INC24		;bump it
	LD	(IX+37),B	;update count
	LD	(IX+38),H
	LD	(IX+39),L
	OR	-1		;set NO fix
	RET			;done
;
FIXYES	LD	B,(IX+40)	;get corrected errors
	LD	H,(IX+41)
	LD	L,(IX+42)
	CALL	$INC24		;bump it
	LD	(IX+40),B	;update count
	LD	(IX+41),H
	LD	(IX+42),L
	XOR	A		;set YES fix
	RET			;done
;
FIXR	SET	4,(IX+47)	;set repair mode
	RES	5,(IX+47)	;reset display only
	JR	FIXYES		;continue
FIXD	SET	5,(IX+47)	;set display only
	RES	4,(IX+47)	;disable repair mode
	JR	FIXNO		;continue
;
;	read record from disk
;
READIT	BIT	7,(IX+47)	;buffer loaded?
	JR	Z,READYES	;nope, force read
;
;	check if requested sector is loaded
;
	LD	C,(IX+33)	;get current sector
	LD	D,(IX+34)
	LD	E,(IX+35)
	CALL	$CMP24		;in buffer?
	JR	Z,READNO	;no need to read!
;
READYES	RES	7,(IX+47)	;set no data in buffer
	LD	(IX+33),B	;set as current sector
	LD	(IX+34),H
	LD	(IX+35),L
	LD	DE,(@FCB)	;get FCB address
	LD	BC,@DATA+33	;point to record #
	CALL	$POSN		;position file
	RET	NZ		;go on error
	CALL	$READ		;read the sector
	RET	NZ		;go on error
;
READNO	SET	7,(IX+47)	;set buffer loaded
	LD	HL,(@IOBUFF)	;get I/O buffer pointer
	XOR	A		;set NO error
	RET			;done, return
;
;	read specific disk record
;
GETREC	LD	(IX+30),B	;save current record #
	LD	(IX+31),H
	LD	(IX+32),L
	CALL	$DEC24		;adjust 0 relative
;
;	check if expanded/compressed
;
	BIT	6,(IX+10)	;expanded?
	JR	NZ,GETRECE	;go if yes
;
;	compute compressed
;
	LD	C,8		;entries / sector
	CALL	$DIVID		;divide it out
	RRCA			;align remainder
	RRCA
	RRCA
	AND	0E0H		;high 3 bits = offset
	JR	GETRECC		;continue
;
GETRECE	LD	C,4		;4 entries / sector
	CALL	$DIVID		;divide it out
	RRCA			;align remainder
	RRCA
	AND	0C0H		;A = byte offset
GETRECC	LD	(IX+36),A	;save current byte
	LD	C,(IX+70)	;get start sector files
	LD	D,(IX+71)
	LD	E,(IX+72)
	CALL	$ADD24		;BHL = sector #
	CALL	READIT		;read the sector
	RET	NZ		;go on error
	LD	C,(IX+36)	;get byte offset
	LD	B,0		;BC = offset
	ADD	HL,BC		;HL => record
	PUSH	HL		;pass to IY
	POP	IY		;IY => record
	XOR	A		;set NO error
	RET			;done!
;
;	check for deleted record linking
;
DELCHK	BIT	7,(IY+0)	;deleted record?
	RET	Z		;nope, continue
;
;	links to deleted record!
;
	LD	HL,FIXDEL	;'fix deleted record?
	CALL	FIXIT		;yes?
	JR	Z,DELFIX	;yes, fix it
	XOR	A		;set NO error
	RET			;don't fix it
;
DELFIX	RES	7,(IY+0)	;un-delete
	JP	WRITIT		;write record to disk
;
;	write current buffer to disk
;
WRITIT	LD	DE,(@FCB)	;file block
	LD	BC,@DATA+33	;point to current sector
	CALL	$POSN		;position file
	RET	NZ		;go on error
	JP	$WRITE		;write the sector and ret
;
;	send output to video/printer
;
TEXT2	PUSH	DE		;save message 2
	CALL	TEXT		;display first
	POP	HL		;get second
	RET	C		;go on break
;
TEXT	PUSH	HL		;save text pointer
	CALL	$DOLINE		;to display
	POP	HL		;restore pointer
	BIT	2,(IX+47)	;dual output?
	CALL	NZ,$PRLINE	;yes, to printer too
	CALL	$KBCHAR		;scan keyboard
	CP	_BREAK		;break key?
	JP	Z,ABORT		;yes, exit on BREAK
	CP	' '		;spacebar?
	RET	NZ		;nope, continue
;
PAUSE	CALL	$KBCHAR		;scan keyboard
	CP	' '		;blank?
	JR	NZ,PAUSE	;nope, wait
	RET			;else continue
;
;	check for valid disk number input
;
DISKNO	CALL	$VALUE		;get input value
	PUSH	HL		;save
	JR	NZ,BADDISK	;go if error
	LD	B,C		;pass msb to B
	EX	DE,HL		;BHL = input number
	LD	A,B		;check msb
	OR	A		;>65535?
	JR	NZ,BADDISK	;go if yes
	OR	H		;check for 000000
	OR	L
	JR	Z,BADDISK	;yes, invalid
	LD	C,(IX+51)	;get # disks used
	LD	D,(IX+52)
	LD	E,(IX+53)
	LD	A,C		;check for nil disks
	OR	D
	OR	E
	JR	Z,BADDISK	;file empty!
	CALL	$CMP24		;compare
	JR	Z,OKDISK	;go if in range
	JR	NC,BADDISK	;out of range!
;
OKDISK	XOR	A		;set OK
	POP	DE		;DE => remainder input
	RET			;return
;
BADDISK	LD	HL,DSKMSG	;'invalid disk #
	JP	ERREX		;exit program
;
	PAGE
;
;	text area
;
NOTMSG	DEFB	_STX
	DEFB	@VID+1,000
	DEFB	_EREOF
	DEFM	'Index Not Available - Use OPEN'
	DEFB	_ETX
;
EMPMSG	DEFB	_STX
	DEFB	@VID+1,000
	DEFB	_EREOF
	DEFM	'Index Empty - Use LOG'
	DEFB	_ETX
;
DSKMSG	DEFB	_STX
	DEFB	@VID+1,000
	DEFB	_EREOF
	DEFM	'Invalid Disk Number'
	DEFB	_ETX
;
POSMSG	DEFM	'Lost Record - Use BACKWARD Check'
CRMSG	DEFB	_CR
	DEFB	_ETX
;
POSMSG2	DEFM	'Lost Record - Use FORWARD Check'
	DEFB	_CR
	DEFB	_ETX
;
INVMSG	DEFB	_STX
	DEFB	@VID+1,000
	DEFB	_EREOF
	DEFM	'Invalid Command Parameter - Use HELP'
	DEFB	_ETX
;
VIDSET	DEFB	_STX
	DEFB	00,000
	DEFB	_EREOF
	DEFB	_ETX
;
ERRMSG	DEFB	_CR
	DEFM	'System Error - '
	DEFB	_ETX
;
CMPMSG	DEFB	_BOL
CMPMSG0	DEFM	'........ Total Errors/'
CMPMSG1	DEFM	'........ Corrected/'
CMPMSG2	DEFM	'........ Not Corrected'
	DEFB	_EREOL
	DEFB	_CR
	DEFB	_ETX
;
HMSG	DEFB	_BOL
	DEFM	'#'
HMSG0	DEFM	'..... - '
HMSG1	DEFM	'........ - '
HMSG2	DEFM	'........ - '
HMSG3	DEFM	'.../'
HMSG4	DEFM	'.D/'
HMSG5	DEFM	'.S/'
HMSG6	DEFM	'."/'
HMSG7	DEFM	'. - '
HMSG8	DEFM	'.....k'
	DEFB	_EREOL
	DEFB	_CR
	DEFB	_ETX
;
LNKMSG	DEFB	_BOL
	DEFM	'Checking Link: '
LNKMSG1	DEFM	'. - '
	DEFB	_EREOL
	DEFB	_ETX
;
FRECMSG	DEFM	'First Record Bad Link'
	DEFB	_CR
	DEFB	_ETX
;
LRECMSG	DEFM	'Last Record Bad Link'
	DEFB	_CR
	DEFB	_ETX
;
BADBMSG	DEFM	'Bad Backward Link'
	DEFB	_CR
	DEFB	_ETX
;
FIXDEL	DEFM	'Link To Deleted Record'
	DEFB	_CR
	DEFB	_ETX
;
BADFMSG	DEFM	'Bad Forward Link'
	DEFB	_CR
	DEFB	_ETX
;
FIXMSG	DEFB	_BOL
	DEFM	'F(ix, I)gnore, C)ontinuous, '
	DEFM	'D)isplay, Q)uit? '
	DEFB	_EREOL
	DEFB	_ETX
;
DELMSG	DEFB	_BOL
	DEFB	'#'
DELMSG1	DEFM	'.....  * Deleted Disk *'
	DEFB	_EREOL
	DEFB	_CR
	DEFB	_ETX
;
DBUFF	EQU	$&0FF00H
INDF	EQU	DBUFF+100H
;
_______	EQU	INDF+100H
	ORG	_______-1	;last used byte
	DEFB	0
;
	END	ENTRY
