; dman05/asm - kjw/bci - DIR/NAMES
;
;	created 08/24/83	- kjw/bci
;	revised 09/30/83	- kjw/bci
;
;	system data usage
;
;	+20	7 / 0=files, 1=dir
;		6 / 0=names, 1=files/dir
;		5 / 1=invisible also
;		4 / 1=system also
;		3 / 1=mod only
;		2 / 1=mask is NOT form
;		1 / 1=mask field found
;		0 / 1=dual output to video/printer
;	+21	7 / 1=INDF buffer loaded
;		6 / 1=nonstop mode
;		5 / 1=display disk types with NAMES cmd
;		4 / 1=I/O buffer loaded
;		3 / 1=files found this link
;		2 / 1=delay header until first file found
;		1 / 1=header has been displayed this disk
;		0 / 1=extended display mode
;	+22	7 / 1=match file with index value
;		1+0 / index value for test
;	+23	unused
;	+24	unused
;	+25-27	disk number specified by user
;	+28-30	unused
;	+31	disk name/date sector offset
;	+32-34	disk name/date sector #
;	+35	unused
;	+36	INDF pointer start for current link
;	+37-39	current file #
;	+40	current video display line
;	+41	file counter for FILES command
;	+42	unused
;	+43	byte offset in sector for current record
;	+44-46	current sector # in I/O buffer
;	+47	7 / 1=buffer loaded
;		6 / 1=INDF buffer loaded
;		5 / 1=nonstop mode
;	+96-98	lowest disk # to scan
;	+99-101	highest disk # to scan
;
ENTRY	LD	(CMDDAT),A	;save command
	EX	DE,HL		;DE => command line
	LD	IX,@DATA	;start data block
	LD	(IX+20),0	;reset flags
	LD	(IX+21),0	;alt flags
	LD	(IX+22),0
	BIT	7,(IX+10)	;file open?
	JR	NZ,START	;yes, go!
;
;	index file not open
;
	LD	HL,NOTMSG	;'not available'
ERREX	CALL	$DOLINE		;display
	JP	EXIT		;back to command mode
;
;	check if any diskettes logged
;
START	LD	A,(IX+73)	;get # files logged
	OR	(IX+74)
	OR	(IX+75)
	JR	NZ,START2	;go if any
	LD	HL,EMPMSG	;'no files logged'
	JR	ERREX		;exit
;
START2	LD	(IX+96),0	;init start disk #
	LD	(IX+97),0
	LD	(IX+98),1	;disk #1
	LD	B,(IX+51)	;get # disks used
	LD	H,(IX+52)
	LD	L,(IX+53)
	LD	(IX+99),B	;set highest disk #
	LD	(IX+100),H
	LD	(IX+101),L
	EX	DE,HL		;HL => command
	LD	A,0		;get command
CMDDAT	EQU	$-1
	DEC	A		;command 1 = DIR
	JR	Z,DIR		;go if yes
	DEC	A		;command 2 = NAMES
	JR	Z,FREE		;go if yes
	JP	$CMD		;can't get here!
;
DIR	SET	6,(IX+20)	;set cat.or.dir
FREE	LD	(IX+41),0	;clear file count
;
;	setup nil mask
;
	PUSH	HL		;save input
	LD	HL,NILMASK	;nil mask
	LD	B,1		;command
	CALL	$WILD		;make mask
	POP	HL		;restore
;
;	evaluate input command
;	valid inputs:
;
;	nil			= global all disks
;	#disknumber		= global disknumber
;	mask			= mask global all disks
;	mask#disknumber		= mask disknumber
;
	CALL	$POSHL		;any input?
	JP	Z,CONT3		;global all disks
	CP	'#'		;disknumber?
	JR	Z,GLDN		;global disk number
	CP	'('		;params?
	JP	Z,PARAM		;yes, go!
	CALL	HAVMASK		;have mask
	JR	Z,CONT1		;go if OK
;
;	unrecognized command
;
INVALID	LD	HL,ERMSG1	;'invalid command line'
	CALL	$DOLINE		;display
	JP	EXIT		;exit to command mode
;
;	mask found, check if disk # included
;
CONT1	CALL	$POSHL		;any more input?
	JP	Z,CONT3		;mask all disks
	CP	'('		;params?
	JP	Z,PARAM		;yes, go!
	CP	'#'		;must be disk #
	JR	NZ,INVALID	;invalid input!
;
;	allow disk range
;
GLDN	INC	HL		;bump pointer
	LD	A,(HL)		;get char
	CP	'-'		;range to?
	JR	Z,SETHI		;yep, low preset
;
SETLO	CALL	DISKNO		;check disk #
	LD	(IX+96),B	;save low disk #
	LD	(IX+97),H
	LD	(IX+98),L
	EX	DE,HL		;HL => data
	LD	A,(HL)		;get data
	CP	'-'		;range?
	JR	NZ,SETONE	;continue if not
	INC	HL		;bump pointer
	LD	A,(HL)		;disk number?
	CP	'0'		;numeric?
	JR	C,SETCNT	;nope, continue
	CP	'9'+1		;numeric?
	JR	NC,SETCNT	;nope, continue
	DEC	HL		;adjust for immed inc
;
SETHI	INC	HL		;bump pointer
	CALL	DISKNO		;check disk number
INSTHI	LD	(IX+99),B	;save high disk #
	LD	(IX+100),H
	LD	(IX+101),L
	EX	DE,HL		;HL => rest input
	JR	SETCNT		;continue
;
SETONE	EX	DE,HL		;BHL = disk # low
	JR	INSTHI		;insert low as high!
;
SETCNT	CALL	$POSHL		;any more?
	JP	Z,CONT3		;go if not
	CP	'('		;must be params
	JR	NZ,INVALID	;else bad!
;
;	evaluate user params
;
PARAM	INC	HL		;bump pointer
	CALL	$POSHL		;any more input?
	JP	Z,CONT3		;go if done!
	CP	')'		;close?
	JP	Z,CONT3		;yes, go!
	CP	_REMARK		;remark?
	JP	Z,CONT3		;yes, go!
	CALL	$UCASE		;make upper case
	CP	'I'		;invis?
	JR	Z,PARAMI	;yes, go!
	CP	'S'		;system?
	JR	Z,PARAMS	;yes, go!
	CP	'P'		;printer?
	JR	Z,PARAMP	;yes, go!
	CP	'C'		;nonstop?
	JR	Z,PARAMN	;yes, go!
	CP	'T'		;titles also?
	JR	Z,PARAMT	;yes, go!
	CP	'X'		;extended listing?
	JR	Z,PARAMX	;yes, go!
	CP	'M'		;mod?
	JR	Z,PARAMM	;go if yes
	CP	'A'		;total?
	JR	Z,PARAMA	;yes, go!
	CP	'F'		;free space
	JR	Z,PARAMF	;go if yes
	CP	'E'		;index value?
	JP	NZ,INVALID	;none, go!
	INC	HL		;bump to next
	LD	A,(HL)		;get data
	CALL	$UCASE		;make upper case
	SUB	'A'		;remove ascii
	JP	C,INVALID	;go if bad
	CP	4		;0-3?
	JP	NC,INVALID	;go if bad
;
;	have INDEX value
;
	OR	80H		;set found flag
	LD	(IX+22),A	;set index found
	JR	PARAM		;continue
;
PARAMM	SET	3,(IX+20)	;set MOD only
	JR	PARAM		;continue
PARAMI	SET	5,(IX+20)	;set INVIS
	JR	PARAM		;continue
PARAMS	SET	4,(IX+20)	;set system
	JR	PARAM		;continue
PARAMP	SET	0,(IX+20)	;enable printer
	LD	(IX+102),60	;lines / page default
	LD	(IX+103),66	;lines / page
	LD	(IX+104),0	;line counter
	INC	HL		;bump pointer
	LD	A,(HL)		;get next char
	CP	'='		;printed / page?
	JP	NZ,PARAM+1	;continue if not
	INC	HL		;bump past
	CALL	$VALUE		;get input value
	JP	NZ,INVALID	;invalid command
	LD	(IX+102),E	;load printed lines
	JP	PARAM+1		;continue
PARAMN	SET	6,(IX+21)	;nonstop
	JP	PARAM		;continue
PARAMT	SET	5,(IX+21)	;set titles
	JP	PARAM		;continue
PARAMA	SET	7,(IX+20)	;set DIR
	JP	PARAM		;continue
PARAMX	BIT	6,(IX+10)	;running compressed?
	JP	Z,PARAM		;yes, ignore it!
	BIT	6,(IX+20)	;running NAMES
	JP	Z,PARAM		;yes, ignore
	SET	0,(IX+21)	;set expanded
	JP	PARAM		;continue
PARAMF	INC	HL		;bump to next
	LD	A,(HL)		;get next char
	CP	'<'		;less?
	JR	Z,PUTF		;yes, go!
	CP	'>'		;greater?
	JR	Z,PUTF		;yes, go!
	CP	'='		;equal?
	JP	NZ,INVALID	;nope, invalid!
PUTF	LD	(FREET),A	;save free type
	INC	HL		;bump to next char
	CALL	$VALUE		;get input value
	JP	NZ,INVALID	;invalid input!
	LD	A,C		;get msb
	OR	A		;>65535?
	JP	NZ,INVALID	;too big!
	LD	(FREES),DE	;save free size
	JR	PARAMT		;force T parameter
PARAML	INC	HL		;bump pointer
	LD	A,(HL)		;get next char
	CP	'='		;must be
	JP	NZ,INVALID	;go if error
	INC	HL		;bump past
	CALL	$VALUE		;get input value
	JP	NZ,INVALID	;go on error
	LD	(IX+103),E	;update page length
	JP	PARAM+1		;continue
;
;	error!
;
ERROR	LD	DE,DISKERR	;disk error
	CALL	$DOERR		;display error
;
RSTART	LD	A,(IX+41)	;any filenames on line
	OR	A		;>0?
	LD	HL,CRMSG	;carriage return
	CALL	NZ,DUAL		;display if yes
;
	BIT	0,(IX+20)	;dual on?
	CALL	NZ,TOPFORM	;yes, go top of form
	LD	A,9<4+1		;restart command mode
	JP	$OVRLAY		;go!
;
;	exit to command mode with screen intact
;
EXIT	LD	A,0<4+1		;return command mode
	JP	$OVRLAY		;go!
;
;	parameters evaluated, and correct, init loop
;
CONT3	LD	HL,VIDSET	;video clear and set
	CALL	$DOLINE		;display clear video
;
	LD	(IX+40),0	;set current display line
;
;	setup loop for global disks
;
	LD	IX,@DATA	;reset pointer
	LD	B,(IX+96)	;get low disk #
	LD	H,(IX+97)
	LD	L,(IX+98)
;
LOOP	CALL	$KBCHAR		;scan keyboard
	CP	_BREAK		;break key?
	JP	Z,RSTART	;go if yes
	CALL	DISPLAY		;display BHL disk #
	JR	NZ,ERROR	;go on disk error
	JR	C,RSTART	;exit on BREAK
;
;	check if completed
;
	LD	B,(IX+28)	;get current disk #
	LD	H,(IX+29)
	LD	L,(IX+30)
	LD	C,(IX+99)	;get highest disk #
	LD	D,(IX+100)
	LD	E,(IX+101)
	CALL	$CMP24		;at end?
	JR	Z,RSTART	;yes, done!
	CALL	$INC24		;bump to next disk
	JR	LOOP		;continue
;
;	display disk number BHL
;
DISPLAY	LD	(IX+28),B	;set current disk #
	LD	(IX+29),H
	LD	(IX+30),L
;
;	load ascii disk number into header text
;
	PUSH	BC		;save disk #
	PUSH	HL
	PUSH	IX		;save
	LD	IX,HMSG1	;text to load ascii
	LD	DE,5<8+10	;length + base
	CALL	$BINASC		;convert to ascii
	POP	IX		;restore @data
	POP	HL		;restore disk #
	POP	BC		;restore
;
;	compute sector number where resides
;
	CALL	$DEC24		;adjust to zero relative
	LD	C,16		;entries / sector
	CALL	$DIVID		;divide it out
	ADD	A,A		;*2
	ADD	A,A		;*4
	ADD	A,A		;*8
	ADD	A,A		;*16
	LD	(IX+31),A	;save offset
	CALL	$INC24		;correct to sector #
;
;	read sector to locate name/date
;
	CALL	READIT		;load I/O buffer
	RET	NZ		;go on error
;
;	move disk name/date into string
;
	LD	C,(IX+31)	;name/date offset
	LD	B,0		;BC = offset
	ADD	HL,BC		;HL => name
;
;	check if deleted disk
;
	LD	A,(HL)		;get first byte
	AND	80H		;bit 7 only
	XOR	80H		;reverse it
	RET	Z		;disk does not exist
;
	LD	DE,HMSG2	;put it here
	LD	C,8		;length
	LDIR			;move it
	LD	DE,HMSG3	;put date here
	LD	C,8		;length
	LDIR			;move it
;
	LD	A,_ETX		;end text char
	LD	(HMSG4),A	;terminate string
	BIT	6,(IX+20)	;free?
	JR	NZ,DISP4X	;go if cat/dir
	BIT	5,(IX+21)	;titles also?
	JP	Z,DISP2		;skip if not
;
;	read INDF data to fetch disk type
;
DISP4X	CALL	LDINDF		;load it
	RET	NZ		;go on disk error
	LD	A,0		;check if free space
FREET	EQU	$-1
	OR	A		;anything?
	JR	Z,DISPA4	;go if not
	LD	DE,0		;get required space
FREES	EQU	$-2
	LD	HL,(INDF+0FCH)	;get disk free space
	LD	A,H		;check for nil
	AND	L		;anything?
	INC	A		;=FFFF?
	JR	Z,DISPB4	;yes, cannot tell
	LD	A,(FREET)	;get type again
	CP	'='		;exact match?
	JR	NZ,FREEC1	;nope, continue
	SBC	HL,DE		;compare?
	JR	Z,DISPA4	;go if exact
	JR	DISPB4		;else abort!
FREEC1	CP	'<'		;less?
	JR	NZ,FREEC2	;go if not
	SBC	HL,DE		;compare?
	JR	C,DISPA4	;go if OK
	JR	DISPB4		;else abort
;
FREEC2	CP	'>'		;greater?
	JR	NZ,DISPA4	;cannot happen!
	SBC	HL,DE		;compare
	JR	Z,DISPB4	;abort if equal
	JR	NC,DISPA4	;go if OK
;
DISPB4	XOR	A		;set NO error
	RET			;return this disk
;
;	load disk type ascii string
;
DISPA4	LD	A,(INDF+0FFH)	;get cylinder count
	INC	A		;FF = unknown?
	JR	Z,UNKNTYP	;go if unknown
	DEC	A		;00 = added disk?
	JR	Z,NILTYPE	;go if yes
	LD	L,A		;pass to LSB
	LD	H,0		;init nsb
	LD	B,H		;BHL = cylinder count
	PUSH	IX		;save
	LD	IX,HMSG5	;point to text
	LD	DE,3<8+10	;length + base
	CALL	$BINASC		;cyl count to ascii
	POP	IX		;restore pointer
	JR	CNTTPE		;continue
;
UNKNTYP	LD	A,'?'		;set unknown
	LD	(HMSG5),A	;to text
	LD	(HMSG5+1),A
	LD	(HMSG5+2),A
;
CNTTPE	LD	HL,INDF+0FEH	;point to flags
	LD	A,'S'		;single den?
	BIT	6,(HL)		;yes?
	JR	Z,$+4		;go if yes
	LD	A,'D'		;double den
	LD	(HMSG6),A	;pass to text
;
	LD	A,'S'		;single side?
	BIT	5,(HL)		;yes?
	JR	Z,$+4		;go if yes
	LD	A,'D'		;double sided
	LD	(HMSG7),A	;to string
;
	LD	A,'5'		;5"
	BIT	4,(HL)		;yes?
	JR	Z,$+4		;go if yes
	LD	A,'8'		;8"
	LD	(HMSG8),A	;to string
;
	LD	A,'F'		;floppy
	BIT	7,(HL)		;yes?
	JR	Z,$+4		;go if yes
	LD	A,'R'		;rigid drive
	LD	(HMSG9),A	;to string
	LD	HL,(INDF+0FCH)	;free space
	LD	A,H		;check for nil
	AND	L
	INC	A		;FFFF?
	LD	C,'?'		;set unknown
	JR	Z,SHOW1AB	;go if unknown
	LD	A,H		;check for nil
	OR	L		;=0000?
	JR	Z,SHOW1AA	;go if yes
	LD	B,0		;BHL = free K
	PUSH	IX		;save
	LD	IX,HMSGA	;text to load
	LD	DE,5<8+10	;length +base
	CALL	$BINASC		;convert
	POP	IX		;restore
	JR	CONTTYP		;continue
;
NILTYPE	LD	A,'-'		;default char
	LD	(HMSG5),A	;to text
	LD	(HMSG5+1),A
	LD	(HMSG5+2),A
	LD	(HMSG6),A
	LD	(HMSG7),A
	LD	(HMSG8),A
	LD	(HMSG9),A
SHOW1AA	LD	C,'-'		;default char
SHOW1AB	LD	HL,HMSGA	;text
	LD	B,5		;length
	CALL	$CLEAR		;clear text
;
CONTTYP	LD	A,' '		;load blank
	LD	(HMSG4),A	;reset ETX char
;
DISP2	RES	1,(IX+21)	;set header NOT displayed
	CALL	HEADER		;check if time yet
	RET	C		;go on BREAK
	RES	3,(IX+21)	;set no files
;
;	check if outputting a directory/catalog
;
	BIT	6,(IX+20)	;free only?
	RET	Z		;yes, go!
;
;	check if INDF buffer needs loading
;
	CALL	CKINDF		;check if yes
	RET	NZ		;go on error
;
;	setup loop to display files
;
;	check if all indexes to be read
;
	BIT	1,(IX+20)	;mask found?
	JR	Z,GLLINK	;global if not!
	BIT	2,(IX+20)	;reverse mask?
	JR	NZ,GLLINK	;yes, go!
	LD	A,'?'		;get first char mask
MASK	EQU	$-1
	CP	'?'		;all global?
	JR	Z,GLLINK	;global links
;
;	create index link pointer
;
	SUB	'A'		;convert to table entry
	JR	C,MAKECH1	;go if out range
	CP	26		;0-25?
	JR	C,MAKECH2	;go if OK
MAKECH1	LD	A,26		;set all others
MAKECH2	JR	SNLINK		;display single link
;
;	global links, setup loop
;
GLLINK	XOR	A		;set first link
;
GLOOP	PUSH	AF		;save link #
	CALL	SNLINK		;display link
	POP	BC		;B = current link#
	RET	NZ		;go on error
	RET	C		;go on BREAK
	LD	A,B		;get link #
	INC	A		;+1
	CP	27		;in range?
	JR	C,GLOOP		;yes, go next
	XOR	A		;set completed OK
	RET			;done!
;
;	display single link A
;
SNLINK	ADD	A,A		;*2
	ADD	A,A		;*4
	ADD	A,A		;*8
	LD	L,A		;pass LSB
	LD	H,INDF<-8	;load MSB
	LD	B,(HL)		;get record start
	INC	HL		;bump
	LD	D,(HL)		;get nsb
	INC	HL		;bump
	LD	E,(HL)		;get lsb
	EX	DE,HL		;BHL = record #
;
SNLOOP	LD	A,B		;check for terminator
	AND	H
	AND	L
	INC	A		;BHL = FFFFFF?
	RET	Z		;yes, done!
	CALL	GETREC		;read record
	RET	NZ		;go on disk error
	CALL	CKFILE		;check if file includes
	RET	C		;go on break
	LD	B,(IY+5)	;get forward link
	LD	H,(IY+6)
	LD	L,(IY+7)
	JR	SNLOOP		;continue in link
;
;	evaluate user mask
;
HAVMASK	BIT	6,(IX+20)	;free?
	JR	NZ,HAVMSK0	;dir/cat, OK
	OR	-1		;set ERROR
	RET			;done
;
;	evaluate input mask
;
HAVMSK0	LD	A,(HL)		;get the char
	CP	'-'		;not mask?
	JR	NZ,HAVMSK1	;go if not
	SET	2,(IX+20)	;set NOT mask
	INC	HL		;bump past
;
HAVMSK1	CALL	$POSHL		;any more input?
	JR	NZ,HAVMSK2	;go if yes
	OR	-1		;invalid!
	RET			;error
;
HAVMSK2	LD	B,1		;command #
	CALL	$WILD		;load mask
	RET	NZ		;go if error
	SET	1,(IX+20)	;set mask found
	LD	A,(DE)		;get first mask char
	LD	(MASK),A	;save it
	RET			;and return
;
CKMASK	BIT	1,(IX+20)	;any mask found?
	JR	Z,CKMASKY	;set MATCH if not
	LD	B,2		;set <>0
	LD	HL,EBUFF+21	;start filename
	CALL	$WILD		;compare cracked
	JR	NZ,CKMASK1	;go if NO match
	BIT	2,(IX+20)	;NOT mask?
	JR	NZ,CKMASKN	;go if reverse
CKMASKY	OR	-1		;set MATCH
	RET
CKMASK1	BIT	2,(IX+20)	;NOT mask?
	JR	NZ,CKMASKY	;go if reverse
CKMASKN	XOR	A		;set NO MATCH
	RET			;done
;
;	check if valid disk # issued and return in BHL
;
DISKNO	CALL	$VALUE		;fetch input value
	PUSH	HL		;save pointer
	JR	NZ,BADDISK	;go if error
	LD	B,C		;pass msb to B
	EX	DE,HL		;pass lsbs to HL (BHL=#)
	LD	A,B		;check msb
	OR	A		;>65536?
	JR	NZ,BADDISK	;disk # too big!
	OR	H		;check for 000000
	OR	L		;BHL = 000000?
	JR	Z,BADDISK	;yes, invalid #
	LD	C,(IX+51)	;get # disks used
	LD	D,(IX+52)
	LD	E,(IX+53)
	LD	A,C		;check for nil disks
	OR	D
	OR	E
	JR	Z,BADDISK	;yes, invalid #
	CALL	$CMP24		;compare
	JR	Z,OKDISK	;OK if equal
	JR	NC,BADDISK	;too big!
;
;	disk # bhl is OK
;
OKDISK	XOR	A		;set OK
	POP	DE		;restore pointer
	RET			;return disk #
;
;	disk is bad, return code
;
BADDISK	LD	HL,DISKMSG	;'bad disk #'
	CALL	$DOLINE		;display message
	JP	EXIT		;exit to command mode
;
;	read sector BHL from (@FCB)
;
READIT	BIT	4,(IX+21)	;buffer loaded?
	JR	Z,READYES	;nope, load it
;
;	check if requested sector loaded
;
	LD	C,(IX+44)	;get current buffer
	LD	D,(IX+45)
	LD	E,(IX+46)
	CALL	$CMP24		;BHL = CDE?
	JR	Z,READNO	;no need to read it!
;
READYES	RES	4,(IX+21)	;set buffer NO loaded
	LD	(IX+44),B	;set as current sector
	LD	(IX+45),H
	LD	(IX+46),L
	LD	DE,(@FCB)	;file block
	LD	BC,@DATA+44	;point to record #
	CALL	$POSN		;position file
	RET	NZ		;go on error
	CALL	$READ		;read sector
	RET	NZ		;go on error
;
READNO	SET	4,(IX+21)	;set buffer loaded
	LD	HL,(@IOBUFF)	;get I/O buffer
	XOR	A		;set no error
	RET			;return with status
;
;	load record # BHL and return IY
;
GETREC	LD	(IX+37),B	;save file #
	LD	(IX+38),H
	LD	(IX+39),L
;
;	compute physical sector #/byte
;
	CALL	$DEC24		;adjust 0 relative
	BIT	6,(IX+10)	;running compressed?
	JR	NZ,GETRECE	;nope, get expanded
;
;	compute sector/byte compressed
;
	LD	C,8		;entries / sector
	CALL	$DIVID		;divide it
	RRCA			;align remainder
	RRCA
	RRCA
	AND	0E0H		;high 3 bits
	JR	GETRECC		;continue
;
GETRECE	LD	C,4		;entries / sector
	CALL	$DIVID		;divide it out
	RRCA			;align remainder
	RRCA			;to high bits
	AND	0C0H		;keep 2 only
;
GETRECC	LD	(IX+43),A	;save byte offset
	LD	C,(IX+70)	;get sector start files
	LD	D,(IX+71)
	LD	E,(IX+72)
	CALL	$ADD24		;BHL = sector #
	CALL	READIT		;read the sector
	RET	NZ		;go on error
	LD	C,(IX+43)	;get byte offset
	LD	B,0		;BC = offset
	ADD	HL,BC		;HL => record
	PUSH	HL		;pass to IY
	POP	IY		;IY => record
	XOR	A		;set NO error
	RET			;return with pointer
;
;	display text to video with pause function
;
TEXT1	CALL	DUAL		;display text at HL
	SET	3,(IX+21)	;set files found
	INC	(IX+41)		;bump display line
	LD	A,(IX+41)	;get result
;
	IF	@COLS.EQ.64
	CP	4		;4 displayed 64 cols?
	ENDIF
	IF	@COLS.EQ.80
	CP	5		;5 displayed 80 cols?
	ENDIF
;
	JR	NZ,TEXTR	;nope, go!
	LD	HL,CRMSG	;carriage return
;
TEXT	CALL	DUAL		;display text at HL
	LD	(IX+41),0	;reset count
	INC	(IX+40)		;bump display line
	LD	A,(IX+40)	;get result
	SUB	@ROWS-1		;at last line
	JR	NZ,TEXTR	;nope, continue
;
PAUSE	BIT	6,(IX+21)	;pause on?
	JR	Z,PAUSEL	;pause ON, wait
;
;	nonstop mode set, check for break only once
;
	CALL	$KBCHAR		;scan keyboard
	CP	_BREAK		;break key?
	JR	NZ,PAUSEE	;go if not
	RES	6,(IX+21)	;turn off nonstop
;
PAUSEL	CALL	$KBCHAR		;scan keyboard
	CP	_BREAK		;break key?
	SCF			;carry = yes
	RET	Z		;yes, go!
	CALL	$UCASE		;make upper case
	CP	'C'		;set continuous?
	JR	Z,PAUSEC	;yes, go!
	CP	_CR		;carriage return?
	JR	NZ,PAUSEL	;nope, wait here
	JR	PAUSEE		;continue
;
PAUSEC	SET	6,(IX+21)	;set nonstop mode
;
PAUSEE	LD	HL,VIDSET	;set cursor and clear vid
	CALL	$DOLINE		;display
	LD	(IX+40),0	;reset current line #
	BIT	6,(IX+20)	;free?
	JR	Z,TEXTR		;yes, return
	BIT	7,(IX+20)	;cat?
	JR	Z,TEXTR		;yes, return
	LD	HL,SMSGH	;new header
	CALL	$DOLINE		;dual output
	INC	(IX+40)		;bump line number
;
TEXTR	XOR	A		;set NO break
	RET			;return OK
;
BRKCHK	CALL	$KBCHAR		;scan keyboard
	CP	_BREAK		;test for break key
	RET			;return with status
;
;	check if file qualifies for display
;
CKFILE	OR	A		;clear carry
	BIT	7,(IY+0)	;deleted file?
	RET	NZ		;yes, ignore
	BIT	6,(IY+0)	;never used?
	RET	NZ		;yes, ignore
	BIT	5,(IY+2)	;system file?
	JR	Z,CKFILE1	;continue if not
	BIT	4,(IX+20)	;system OK?
	RET	Z		;nope, skip it
	JR	CKFILE2		;continue
;
CKFILE1	BIT	6,(IY+2)	;invisible file?
	JR	Z,CKFILE2	;continue if not
	BIT	5,(IX+20)	;invis OK?
	RET	Z		;nope, skip it
;
CKFILE2	BIT	3,(IX+20)	;mod only?
	JR	Z,CKFILE3	;go if all files
	BIT	7,(IY+2)	;file modified?
	RET	Z		;nope, go!
;
;	file OK, check for cat/dir
;
CKFILE3	LD	A,(IX+22)	;get data
	BIT	7,A		;index value?
	JR	Z,CKFILE4	;go if not
	AND	3		;low 2 bits
	LD	C,A		;save
	LD	A,(IY+0)	;get data
	RRCA			;align index
	RRCA
	AND	3		;low 2 bits
	CP	C		;match?
	JR	Z,CKFILE4	;go if OK
	XOR	A		;set no error
	RET			;done
;
CKFILE4	CALL	$SAVREG		;save registers
	CALL	UNPACK		;unpack record
	CALL	CKMASK		;compare file to mask
	RET	Z		;nope, go!
	CALL	HEADERS		;display header if delay
	BIT	7,(IX+20)	;get flag
	JP	Z,DOCAT		;go CAT
;
;	display file directory here
;
DODIR	LD	HL,EBUFF+21	;name stored here
	LD	DE,DMSG		;place text here
	CALL	PUTNAME		;move filename
;
	LD	HL,EBUFF+33	;version
	LD	DE,DMSG2	;move it here
	LD	BC,5		;text length
	LDIR			;move it
;
	LD	HL,EBUFF	;point to date
	LD	DE,DMSG3	;move it here
	CALL	PUTDATE		;load date
;
	LD	HL,EBUFF	;flags start
	LD	DE,DMSG4	;place here
	CALL	PUTDFL		;put dos flags
;
	LD	HL,EBUFF+74	;user flags
	LD	DE,DMSG5	;move here
	CALL	PUTUFL		;put user flags
;
;	check if expanded display
;
	BIT	0,(IX+21)	;expanded?
	LD	HL,DMSG		;message start
	JP	Z,TEXT		;go if not expanded
	LD	A,(IX+10)	;get flags
	AND	40H		;compressed?
	RET	Z		;yes, do not attempt
;
;	expanded here
;
	LD	A,(IX+40)	;get display line
	CP	@ROWS-3		;room for 2 lines?
	JR	C,GOEXP		;go if room
	CALL	PAUSE		;wait for enter
	RET	C		;go on break
GOEXP	LD	HL,DMSG		;first line
	CALL	TEXT		;display
	RET	C		;go on BREAK
;
;	create second line of text
;
	LD	HL,SMSG		;second message
	LD	BC,SMSGL<8+' '	;length + fill
	CALL	$CLEAR		;clear work area
;
	LD	HL,EBUFF+38	;author
	LD	DE,SMSG		;second message
	LD	BC,10		;length
	LDIR			;move it
;
	LD	HL,EBUFF+48	;company
	LD	DE,SMSG2	;text
	LD	C,12		;length
	LDIR			;move it
;
	LD	HL,EBUFF+60	;group
	LD	DE,SMSG5	;text
	LD	C,8		;length
	LDIR			;move it
;
	LD	HL,EBUFF+68	;class
	LD	DE,SMSG6	;text
	LD	C,6		;length
	LDIR			;move it
;
;	check if any data entered
;
	LD	HL,SMSG		;start of message
	LD	B,SMSGL		;length of message
CKNILM	LD	A,(HL)		;get a char
	CP	' '		;blank?
	JR	NZ,CKNILO	;nope, have data!
	INC	HL		;bump
	DJNZ	CKNILM		;go for length
	XOR	A		;clear flags
	RET			;done!
;
CKNILO	LD	HL,EBUFF+11	;phone digits
	LD	DE,SMSG3	;text to load
	CALL	PUTPHON		;put phone number
	LD	A,(EBUFF)	;get first flag
	RRCA			;align
	RRCA
	AND	3		;low 2 bits only
	ADD	A,'A'		;make ascii
	LD	(SMSG4),A	;to string
;
	LD	HL,SMSG		;start of text
	JP	TEXT		;display and return
;
;	display file catalog here
;
DOCAT	LD	HL,EBUFF+21	;name stored here
	LD	DE,CATTXT	;text display
	PUSH	DE		;save start
	CALL	PUTNAME		;place filename
	POP	HL		;HL => text
	SET	3,(IX+21)	;set file displayed
	JP	TEXT1		;display single file
;
;	unpack record into ascii format
;
UNPACK	CALL	$SAVREG		;save registers
	PUSH	IY		;save
	POP	HL		;HL => compressed rec
	LD	DE,EBUFF	;DE => expanded rec
	LD	BC,11		;count
	LDIR			;move flags
;
;	check for expanded/compressed
;
	LD	A,(@FLAG1)	;get system flag
	BIT	6,A		;expanded?
	JR	NZ,UNPACKE	;go if yes
	LD	DE,EBUFF+21	;name goes here
	LD	B,17		;17 bytes to move
	CALL	MBITS		;unpack by bits
	LD	IY,EBUFF+74	;flags go here
	JR	UNPACKC		;do flags
;
;	move telephone
;
UNPACKE	LD	B,5		;5 compressed digits
UNPACK1	LD	A,(HL)		;get compressed digit
	INC	HL		;bump pointer
	LD	C,A		;save
	RRCA			;align high bits
	RRCA
	RRCA
	RRCA
	CALL	UNPACK2		;make ascii
	LD	A,C		;get digit
	CALL	UNPACK2		;make ascii
	DJNZ	UNPACK1		;go for count
	JR	UNPACK3		;continue
;
UNPACK2	AND	0FH		;low 4 bits only
	ADD	A,'0'		;make ascii
	LD	(DE),A		;load
	INC	DE		;bump
	RET			;loaded
;
UNPACK3	LD	B,53		;53 bits to move
	CALL	MBITS		;move bits
;
;	move flag data
;
UNPACKC	LD	B,12		;12 flags
UNPACK4	ADD	A,A		;bump count
	LD	E,0		;set flag off
	JR	NC,$+3		;go if off
	DEC	E		;set flag on
	LD	(IY+0),E	;load data
	INC	IY		;bump
	DEC	D		;less bits / byte
	JR	NZ,UNPACK5	;continue
	LD	D,8		;reset count
	LD	A,(IX+0)	;get next data
	INC	IX		;bump source
UNPACK5	DJNZ	UNPACK4		;go for flag count
	XOR	A		;set OK
	RET			;done
;
;	move bits from (HL) to (DE)
;
MBITS	PUSH	HL		;pass to IX
	POP	IX		;IX => source
	PUSH	DE		;pass to IY
	POP	IY		;IY => dest
	LD	DE,8<8+0	;D=bits/byte, E=byte
	LD	L,7		;bits to move / byte
	LD	A,(IX+0)	;get first data byte
	INC	IX		;bump pointer
;
MBITS2	ADD	A,A		;move bit to carry
	RL	E		;catch bit
	DEC	D		;less bits / byte
	JR	NZ,MBITS3	;more to go
	LD	D,8		;reset bit count
	LD	A,(IX+0)	;get next source
	INC	IX		;bump pointer
;
MBITS3	DEC	L		;less # bits / byte
	JR	NZ,MBITS2	;go till have 7
	LD	L,7		;reset # bits needed
	LD	(IY+0),E	;load data byte
	INC	IY		;bump pointer
	LD	E,0		;reset byte
MBITS4	DJNZ	MBITS2		;go for count
	RET			;done!
;
;	check if INDF buffer loaded
;
CKINDF	BIT	7,(IX+21)	;indf loaded?
	JR	Z,LDINDF	;nope, load it!
	XOR	A		;set Z for OK
	RET			;yes, loaded, return Z
;
;	load INDF buffer
;
;	read current disk index link for record pointers
;
LDINDF	LD	B,(IX+28)	;get current disk #
	LD	H,(IX+29)
	LD	L,(IX+30)
	CALL	$DEC24		;adjust 0 relative
	LD	C,(IX+57)	;get start disk tables
	LD	D,(IX+58)
	LD	E,(IX+59)
	CALL	$ADD24		;BHL = sector needed
	RES	7,(IX+21)	;set NOT loaded
	CALL	READIT		;read the critter
	RET	NZ		;go on error
	LD	DE,INDF		;place buffer here
	LD	BC,100H		;buffer length
	LDIR			;save it
	SET	7,(IX+21)	;set LOADED
	XOR	A		;set Z flag for OK
	RET			;return Z
;
;	'normalize' filespec
;
PUTNAME	LD	A,(EBUFF)	;get first char
	BIT	5,A		;normal format?
	LD	B,3		;command #
	JP	Z,$WILD		;yes, convert file
	LD	BC,11		;BC = length
	LDIR			;alternate format
	LD	A,' '		;clear last space
	LD	(DE),A
	RET			;done
;
;	move date into field
;
PUTDATE	BIT	4,(HL)		;active date?
	JR	NZ,PUTDAT0	;go if not!
;
	INC	HL		;flags2
	INC	HL		;flags3
	INC	HL		;flags4
	EX	DE,HL		;HL => string
	LD	A,(DE)		;get month
	AND	0FH		;low 4 bits
	CALL	ASCII		;to decimal ascii
	LD	(HL),C		;msb
	INC	HL		;bump
	LD	(HL),B		;lsb
	INC	HL		;bump past /
	INC	HL
	DEC	DE		;flags3
	DEC	DE		;flags2
	LD	A,(DE)		;get data
	RRCA			;align data
	RRCA
	RRCA
	AND	00011111B	;low 5 bits = day
	CALL	ASCII		;to decimal ascii
	LD	(HL),C		;msb
	INC	HL		;bump
	LD	(HL),B		;lsb
	INC	HL		;bump past /
	INC	HL
	LD	A,(DE)		;get data
	AND	7		;low 3 bits
	ADD	A,80		;correct to year
	CALL	ASCII		;make ascii
	LD	(HL),C		;msb
	INC	HL		;bump
	LD	(HL),B		;lsb
	RET			;done!
;
;	nil date
;
PUTDAT0	EX	DE,HL		;HL => data
	LD	B,3		;go for 3 count
;
PUTDAT1	LD	(HL),'*'	;load nil char
	INC	HL		;bump
	LD	(HL),'*'	;nil char
	INC	HL		;bump
	INC	HL		;bump past
	DJNZ	PUTDAT1		;go for count
	RET			;done
;
ASCII	LD	C,'0'		;init msb
ASC1	SUB	10		;less 10's place
	JR	C,ASC2		;go if found
	INC	C		;bump digit
	JR	ASC1		;go till found
ASC2	ADD	A,'0'+10	;last sub + ascii
	LD	B,A		;pass to B
	RET			;done!
;
;	load ascii for dos flags
;
PUTDFL	LD	A,'P'		;pds file?
	BIT	1,(HL)		;yes?
	JR	NZ,$+4		;go if yes
	LD	A,'-'		;else no
	LD	(DE),A		;to text
	INC	DE		;bump
;
	INC	HL		;bump
	INC	HL		;bump
	LD	A,'I'		;invis?
	BIT	6,(HL)		;yes?
	JR	NZ,$+4		;go if yes
	LD	A,'-'
	LD	(DE),A		;to string
	INC	DE		;bump
;
	LD	A,'S'		;system?
	BIT	5,(HL)		;yes?
	JR	NZ,$+4		;go if yes
	LD	A,'-'
	LD	(DE),A		;to string
	INC	DE		;bump
;
	LD	A,'M'		;modified?
	BIT	7,(HL)		;yes?
	JR	NZ,$+4		;go if yes
	LD	A,'-'
	LD	(DE),A		;to string
	INC	DE		;bump
;
	LD	A,'C'		;created?
	BIT	3,(HL)		;yes?
	JR	NZ,$+4		;go if yes
	LD	A,'-'
	LD	(DE),A		;to string
	INC	DE		;bump
;
	LD	A,'N'		;non-shrink?
	BIT	4,(HL)		;yes?
	JR	NZ,$+4		;go if yes
	LD	A,'-'
	LD	(DE),A		;to string
	INC	DE		;bump
;
	LD	A,(HL)		;get data
	AND	7		;prot level
	ADD	A,'0'		;make ascii
	LD	(DE),A		;to string
	RET			;done
;
;	load user flag data
;
PUTUFL	LD	B,12		;12 flags to do
PUTUFL1	LD	A,(HL)		;get a char
	INC	A		;ON?
	LD	A,'X'		;set ON char
	JR	Z,$+4		;go if yes
	LD	A,'.'		;set OFF char
	LD	(DE),A		;to string
	INC	HL		;bump source
	INC	DE		;bump string
	DJNZ	PUTUFL1		;go for count
	RET			;done
;
;	dual output to printer/video
;
DUAL	PUSH	HL		;save string pointer
	CALL	$DOLINE		;display to video
	POP	HL		;restore
	BIT	0,(IX+20)	;dual ON?
	RET	Z		;nope, go!
;
DUAL1	LD	A,(HL)		;get data
	INC	HL		;bump pointer
	CP	_ETX		;end text?
	RET	Z		;yes, go!
	CP	_CR		;carriage return?
	JR	Z,DUAL2		;go if yes
	CALL	$PRCHAR		;print character
	JR	DUAL1		;continue
DUAL2	CALL	$PRCHAR		;send carriage return
	INC	(IX+104)	;bump line count
	LD	A,(IX+104)	;get count
	CP	(IX+102)	;printed enough?
	JR	NZ,DUAL1	;nope, continue
;
DUAL3	CALL	TOPFORM		;printer to top
	BIT	7,(IX+20)	;cat?
	JR	Z,DUAL1		;go if yes
	BIT	6,(IX+20)	;free
	JR	Z,DUAL1		;go if yes
	PUSH	HL		;save current string
	LD	HL,SMSGH	;header
	CALL	DUAL1		;display it to printer
	POP	HL		;restore pointer
	JR	DUAL1		;go next char
;
TOPLOOP	LD	A,_LF		;linefeed
	CALL	$PRCHAR		;print character
	INC	(IX+104)	;get line count
TOPFORM	LD	A,(IX+104)	;get result
	CP	(IX+103)	;at page length?
	JR	NZ,TOPLOOP	;nope, continue
	LD	(IX+104),0	;clear line count
	RET			;done
;
;	controlled headers
;
HEADER	OR	A		;clear carry
	BIT	1,(IX+20)	;delayed header?
	RET	NZ		;yes, don't display yet
	JR	HEADGO		;display!
;
HEADERS	OR	A		;clear carry
	BIT	1,(IX+21)	;displayed?
	RET	NZ		;yes, go!
;
HEADGO	SET	1,(IX+21)	;flag displayed
;
;	determine if linefeeds needed
;
	BIT	6,(IX+20)	;cat/dir?
	LD	A,(IX+40)	;get current display line
	JR	NZ,$+6		;go if cat/dir
	CP	@ROWS		;at last row?
	JR	$+4		;continue
	CP	@ROWS-3		;line 7 or greater?
	JR	C,DISP3		;continue if less
	CALL	PAUSE		;restart screen
	RET	C		;go on BREAK
;
DISP3	LD	A,(IX+41)	;any characters pending?
	OR	A		;0?
	JR	Z,DISP4		;continue if yes
	LD	HL,CRMSG	;else send carriage ret
	CALL	TEXT		;display
	RET	C		;go on break
;
;	check if extra carriage returns on CAT/DIR
;
DISP4	BIT	6,(IX+20)	;names?
	JR	Z,DISP5		;go if yes
	LD	HL,CRMSG	;carriage return
	CALL	TEXT		;display
	RET	C		;go on break
;
DISP5	LD	HL,HMSG		;point to start
	CALL	DUAL		;display header
	LD	HL,CRMSG	;carriage return
	BIT	6,(IX+20)	;free?
	JP	Z,TEXT		;yes, go!
	BIT	7,(IX+20)	;cat?
	JP	Z,TEXT		;yes, go!
;
;	display header
;
	CALL	TEXT		;display line
	RET	C		;go on break
	LD	HL,SMSGH	;second line message
	JP	TEXT		;go!
;
;	load phone number into ascii string
;
PUTPHON	PUSH	HL		;save start
	LD	B,5		;check 5 digits
	XOR	A		;init
PUTPHO1	OR	(HL)		;check for zeroes
	INC	HL		;bump
	DJNZ	PUTPHO1		;go for count
	POP	HL		;restore start
	RET	Z		;go if no digits!
;
	EX	DE,HL		;HL => string
	LD	(HL),'('	;start area
	INC	HL		;bump pointer
	LD	B,3		;3 char area
	CALL	PHON		;move data
	LD	(HL),')'	;end area code
	INC	HL		;bump
	INC	HL		;bump
	LD	B,3		;3 char prefix
	CALL	PHON		;move data
	LD	(HL),'-'	;separator
	INC	HL		;bump
	LD	B,4		;4 digit number
;
PHON	LD	A,(DE)		;get data byte
	LD	(HL),A		;to text string
	INC	DE		;bump
	INC	HL		;bump
	DJNZ	PHON		;go for length
	RET			;done!
;
;	text area
;
ERMSG1	DEFB	_STX
	DEFB	@VID+1,00
	DEFB	_EREOF
	DEFM	'Invalid Command Parameter - Use HELP'
	DEFB	_ETX
;
NILMASK	DEFM	'!'
	DEFB	_CR
;
VIDSET	DEFB	_STX
	DEFB	00,000
	DEFB	_EREOF
	DEFB	_ETX
;
NOTMSG	DEFB	_STX
	DEFB	@VID+1,000
	DEFB	_EREOF
	DEFM	'Index File Not Available - Use OPEN'
	DEFB	_ETX
;
EMPMSG	DEFB	_STX
	DEFB	@VID+1,000
	DEFB	_EREOF
	DEFM	'Index Empty - Use LOG'
	DEFB	_ETX
;
DISKMSG	DEFB	_STX
	DEFB	@VID+1,000
	DEFB	_EREOF
	DEFM	'Invalid Disk Number'
	DEFB	_ETX
;
DISKERR	DEFB	_CR
	DEFM	'System Error - '
	DEFB	_ETX
;
HMSG	DEFM	'#'
HMSG1	DEFM	'..... - '
HMSG2	DEFM	'........ - '
HMSG3	DEFM	'........'
HMSG4	DEFB	_ETX
	DEFM	' - '
HMSG5	DEFM	'.../'
HMSG6	DEFM	'.D/'
HMSG7	DEFM	'.S/'
HMSG8	DEFM	'."/'
HMSG9	DEFM	'. - '
HMSGA	DEFM	'.....k'
	DEFB	_ETX
;
DMSG	DEFM	'......../... -- '
DMSG2	DEFM	'..... -- '
DMSG3	DEFM	'../../.. -- '
DMSG4	DEFM	'....... -- '
DMSG5	DEFM	'............'
	DEFB	_CR
	DEFB	_ETX
;
SMSGH	DEFM	'Filename     --'
	DEFM	'Version-- '
	DEFM	'  Date   -- '
	DEFM	' Flags  -- '
	DEFM	'123456789012'
	DEFB	_CR
	DEFB	_ETX
;
SMSG	DEFM	'..........  '
SMSG2	DEFM	'............  '
SMSG3	DEFM	'(...) ...-....  '
SMSG4	DEFM	'.  '
SMSG5	DEFM	'........  '
SMSG6	DEFM	'......'
SMSGL	EQU	$-SMSG
	DEFB	_CR
	DEFB	_ETX
;
CRMSG	DEFB	_CR
	DEFB	_ETX
;
CATTXT	DEFM	'......../...   '
	DEFB	_ETX
;
;	buffers
;
DBUFF	EQU	$&0FF00H
EBUFF	EQU	DBUFF+100H	;expanded record buffer
INDF	EQU	EBUFF+100H	;first free next page
;
_______	EQU	INDF+100H	;first free byte
	ORG	_______-1	;last byte used
	DEFB	0
;
	END	ENTRY
