; dman04d/asm - kjw/bci - Log Diskettes
;
;	created 08/30/83	- kjw/bci
;	revised 09/22/83	- kjw/bci
;
UPDREC	CALL	PACK		;pack the record CBUFF
	LD	IX,@DATA	;reset pointer
	SET	4,(IX+108)	;set update search
	CALL	SEARCH		;locate the record
	RET	NZ		;go on error
	JP	C,EDITOR	;go if new record
;
;	updating existing record
;
	PUSH	IY		;save pointer to file
	CALL	UNPACK		;unpack current record
	CALL	DISPLAY		;display file data
	POP	DE		;DE => current file
	LD	IX,@DATA	;reset pointer
	LD	HL,CBUFF	;new packed data
;
;	check if any difference
;
	LD	B,3		;count
	PUSH	DE		;save
	PUSH	HL		;save
CKIFUP	LD	A,(DE)		;get a byte
	CP	(HL)		;updated?
	JR	NZ,CKIFYS	;yes, go!
	INC	HL		;bump
	INC	DE		;bump
	DJNZ	CKIFUP		;go for count
CKIFYS	POP	HL		;unstack
	POP	DE
	LD	BC,3		;flag count
	LDIR			;update new flags
	LD	A,0		;set NO error
	JR	NZ,MSTUPD	;changed, must update
	BIT	7,(IX+114)	;exact mode?
	RET	Z		;nope, go!
;
MSTUPD	LD	HL,UPMSG	;'updating..'
	CALL	$DOLINE		;display
	SET	4,(IX+47)	;set buffer needs update
	SET	0,(IY+0)	;flag as updated
	XOR	A		;set NO error
	RET			;done!
;
;	unpack existing record into EBUFF
;
UNPACK	CALL	$SAVREG		;save registers
	CALL	CLREBUF		;reset Expanded buffer
	PUSH	IY		;save
	POP	HL		;HL => compressed rec
	LD	DE,EBUFF	;DE => expanded rec
	LD	BC,11		;count
	LDIR			;move flags
;
;	check if compressed, expanded
;
	LD	A,(@FLAG1)	;get sys flag
	BIT	6,A		;expanded?
	JR	NZ,UNPACKE	;yes, go!
;
;	unpack compressed
;
	LD	B,17		;17 bytes to uncompress
	LD	DE,EBUFF+21	;name/version here
	CALL	UBITS		;unpack bits
	LD	IY,EBUFF+74	;flag storage
	JR	UNPACKC		;continue
;
;	move telephone
;
UNPACKE	LD	B,5		;5 compressed digits
UNPACK1	LD	A,(HL)		;get compressed digit
	INC	HL		;bump pointer
	LD	C,A		;save
	RRCA			;align high bits
	RRCA
	RRCA
	RRCA
	CALL	UNPACK2		;make ascii
	LD	A,C		;get digit
	CALL	UNPACK2		;make ascii
	DJNZ	UNPACK1		;go for count
	JR	UNPACK3		;continue
;
UNPACK2	AND	0FH		;low 4 bits only
	ADD	A,'0'		;make ascii
	LD	(DE),A		;load
	INC	DE		;bump
	RET			;loaded
;
UNPACK3	LD	B,53		;53 bits to move
	CALL	UBITS		;move bits
;
;	move flag data
;
UNPACKC	LD	B,12		;12 flags
UNPACK4	ADD	A,A		;bump count
	LD	E,0		;set flag off
	JR	NC,$+3		;go if off
	DEC	E		;set flag on
	LD	(IY+0),E	;load data
	INC	IY		;bump
	DEC	D		;less bits / byte
	JR	NZ,UNPACK5	;continue
	LD	D,8		;reset count
	LD	A,(IX+0)	;get next data
	INC	IX		;bump source
UNPACK5	DJNZ	UNPACK4		;go for flag count
	XOR	A		;set OK
	RET			;done
;
;	move bits from (HL) to (DE)
;
UBITS	PUSH	HL		;pass to IX
	POP	IX		;IX => source
	PUSH	DE		;pass to IY
	POP	IY		;IY => dest
	LD	DE,8<8+0	;D=bits/byte, E=byte
	LD	L,7		;bits to move / byte
	LD	A,(IX+0)	;get first data byte
	INC	IX		;bump pointer
;
UBITS2	ADD	A,A		;move bit to carry
	RL	E		;catch bit
	DEC	D		;less bits / byte
	JR	NZ,UBITS3	;more to go
	LD	D,8		;reset bit count
	LD	A,(IX+0)	;get next source
	INC	IX		;bump pointer
;
UBITS3	DEC	L		;less # bits / byte
	JR	NZ,UBITS2	;go till have 7
	LD	L,7		;reset # bits needed
	LD	(IY+0),E	;load data byte
	INC	IY		;bump pointer
	LD	E,0		;reset byte
UBITS4	DJNZ	UBITS2		;go for count
	RET			;done!
;
;	clear expanded buffer to nil data
;
CLREBUF	LD	HL,EBUFF	;start buffer
	LD	BC,5<8+0	;flags 5 bytes
	CALL	$CLEAR		;zero it out
	LD	HL,EBUFF+5	;links
	LD	BC,6<8+0FFH	;links 6 bytes
	CALL	$CLEAR		;reset links
	LD	HL,EBUFF+11	;phone
	LD	BC,10<8+'*'	;length + fill
	CALL	$CLEAR		;reset data
	LD	HL,EBUFF+21	;name etc
	LD	B,12+5+12+10+8+6
	LD	C,' '
	CALL	$CLEAR		;reset data
	LD	HL,EBUFF+74	;flags
	LD	BC,12<8+0	;length + fill
	JP	$CLEAR		;clear and return
;
	PAGE
;
;	manual add of new records
;
GOADD	LD	IX,@DATA	;reset pointer
	CALL	CLREBUF		;clear expanded buffer
	LD	A,(EBUFF)	;get first char
	OR	00110000B	;alt format, no date!
	LD	(EBUFF),A	;update
	CALL	PACK		;pack data to CBUFF
	CALL	DISPLAY		;display mask
;
GETADD	LD	HL,ADDMSG	;'filename?'
	CALL	$DOLINE		;display
	LD	B,12		;max length
	CALL	$KBLINE		;get key input
	JP	C,EXIT		;go on BREAK
	JR	Z,GETADD	;ignore nil input
	LD	DE,EBUFF+21	;place it here
	LD	C,B		;pass length
	LD	B,0		;BC = length
	LDIR			;move to buffer
	CALL	PACK		;pack data
	CALL	DISPLAY		;display data
	CALL	EDITREC		;edit record
	CALL	PACK		;repack from edit
;
ADDSAV	LD	HL,ADDSVMG	;'save?
	CALL	$DOLINE		;display
	CALL	$INKEY		;get key input
	PUSH	AF		;save
	LD	HL,EDITMSC	;clear input area
	CALL	$DOLINE		;display
	POP	AF		;restore
	JP	C,EXIT		;go on break
	JR	Z,ASAVE		;default save
	CALL	$UCASE		;make upper case
	CP	'S'		;save?
	JR	Z,ASAVE		;go if yes
	CP	'E'		;edit?
	JR	Z,AEDIT		;go if yes
	CP	'I'		;ignore?
	JR	Z,GOADD		;yes, next
	CP	'Q'		;quit?
	JP	Z,EXIT		;go if yes
	JR	ADDSAV		;invalid, ask again
;
ASAVE	CALL	ADDREC		;add record
	JR	Z,GOADD		;done, go next
	JP	ERRORX		;go if done
;
AEDIT	CALL	EDITREC		;edit record
	JR	ADDSAV		;check again
;
