; dman03/asm - kjw/bci - INIT/OPEN
;
;	created 08/15/83	- kjw/bci
;	revised 09/24/83	- kjw/bci
;
ENTRY	LD	IX,@DATA	;reset pointer
	LD	(IX+96),0	;reset flags
	LD	(COMMAND),A	;save command
;
;	check if file already open
;
	BIT	7,(IX+10)	;file open?
	JR	Z,START		;go if OK
;
	LD	HL,ALRMSG	;'file already open'
	JR	GODOSV		;continue
INVALID	LD	HL,INVMSG	;invalid command
GODOSV	CALL	$DOLINE		;display prompt
GODOS	LD	A,0<4+1		;exit to command mode
	JP	$OVRLAY		;go!
;
;	check for any input
;
START	CALL	$POSHL		;any input?
	JR	NZ,HAVFILE	;have filespec, go!
;
;	ask user for filespec
;
ASKFILE	LD	HL,PROMPT0	;'filespec'
	CALL	$DOLINE		;display prompt
	LD	B,40		;max key input length
	CALL	$KBLINE		;fetch key input
	JP	C,$CMD		;exit on BREAK
	JR	START		;check if any input
;
;	evaluate filespec
;
HAVFILE	LD	DE,(@FCB)	;init fileblock
	CALL	$FSPEC		;evaluate filespec
	JR	Z,OPNFILE	;go if no error
;
ERROR	LD	BC,(COMMAND)	;get sys command
	DEC	C		;init?
	LD	DE,DOSMSG	;'init error'
	JR	Z,ERROR0	;go if yes
	LD	DE,OPEMSG	;'open error'
;
;	error on file
;
ERROR0	CALL	$DOERR		;display error
	JP	GODOS		;back to command mode
;
;	program aborted
;
ABORT	LD	HL,ABTMSG	;'aborted'
	JP	GODOSV		;continue and display
;
;	open filespec
;
OPNFILE	LD	(RECPOS),HL	;save input pointer
	LD	HL,(@FCB)	;file block
	LD	DE,(@FNAME)	;filename storage
	LD	BC,50		;max length
	LDIR			;move it
;
	LD	HL,$		;get input pointer
RECPOS	EQU	$-2
	LD	A,'$'		;get command
COMMAND	EQU	$-1
	DEC	A		;init?
	JR	Z,DOINIT	;yes, go!
	DEC	A		;open?
	JP	Z,DOOPEN	;yes, go!
	JP	$CMD		;program error!
;
DOINIT	CALL	$POSHL		;any more input?
	JR	Z,DOINIT1	;continue if not
	CP	'('		;param starter?
	JP	NZ,INVALID	;nope, invalid command!
;
;	evaluate user params
;
PARAM	INC	HL		;bump to next char
	CALL	$POSHL		;any more input?
	JR	Z,DOINIT1	;continue if end
	CP	')'		;terminator?
	JR	Z,DOINIT1	;go if yes
	CP	_REMARK		;remark?
	JR	Z,DOINIT1	;go if yes
	CALL	$UCASE		;make char upper case
	CP	'O'		;overwrite?
	JR	Z,PARAMO	;go if yes
	CP	'N'		;no space verify?
	JR	Z,PARAMN	;go if yes
	CP	'C'		;compressed?
	JR	Z,PARAMC	;go if yes
	CP	'E'		;expanded?
	JR	Z,PARAME	;go if yes
	CP	'D'		;# disks?
	JP	NZ,INVALID	;none, invalid command!
;
PARAMD	INC	HL		;bump past
	LD	A,(HL)		;get next char
	CP	'='		;must be this!
	JP	NZ,INVALID	;go if wrong
	INC	HL		;bump pointer
	CALL	$VALUE		;get input value
	JP	NZ,INVALID	;invalid number
	LD	A,C		;get msb
	OR	A		;>65535?
	JP	NZ,INVALID	;go if out of range
	LD	(IX+97),C	;save value
	LD	(IX+98),D
	LD	(IX+99),E
	SET	5,(IX+96)	;set value found
	DEC	HL		;setup for immed inc
	JR	PARAM		;go next param
;
PARAMO	SET	7,(IX+96)	;overwrite
	JR	PARAM		;continue
PARAMN	SET	6,(IX+96)	;no prompt on space
	JR	PARAM		;continue
PARAMC	BIT	0,(IX+96)	;expanded issued?
	JP	NZ,INVALID	;yes, only one allowed!
	SET	1,(IX+96)	;set compressed
	JR	PARAM		;continue
PARAME	BIT	1,(IX+96)	;compressed issued?
	JP	NZ,INVALID	;yes, only one allowed!
	SET	0,(IX+96)	;set expanded
	JR	PARAM		;continue
;
DOINIT1	LD	HL,CHKMSG	;'checking for existing'
	CALL	$DOLINE		;display message
	LD	DE,(@FCB)	;get file block start
	LD	HL,(@IOBUFF)	;I/O buffer
	LD	BC,0<8+'R'	;LRL=0 + read only
	CALL	$OPEN		;open existing
	CALL	Z,EXISTS	;exists, replace?
;
;	open file for output
;
	LD	HL,CREMSG	;'creating file'
	CALL	$DOLINE		;display message
	LD	HL,(@FNAME)	;start name again
	LD	DE,(@FCB)	;file block
	LD	BC,50		;max length
	PUSH	DE		;save start
	LDIR			;move it back
	POP	DE		;DE => filename
	LD	HL,(@IOBUFF)	;I/O buffer
	LD	BC,0<8+'W'	;open for write
	CALL	$INIT		;open/create file
	JP	NZ,ERROR	;go on error
	BIT	5,(IX+96)	;# diskettes issued?
	JR	Z,ASK1		;nope, have to ask
	LD	C,(IX+97)	;get # disks
	LD	D,(IX+98)
	LD	E,(IX+99)
	JR	HAVE1		;continue
;
;	ask user for # of diskettes file is to hold
;
ASK1	LD	HL,PROMPT2	;'# diskettes max'
	CALL	$DOLINE		;display prompt
	LD	B,5		;5 digits max
	CALL	$KBLINE		;get key input
	JP	C,ABORT		;routine aborted
;
	CALL	$VALUE		;fetch input value
	JR	NZ,ASK1		;go if invalid numerical
;
;	must be less than 65536
;
	LD	A,C		;get msb
	OR	A		;zero?
	JR	NZ,ASK1		;too big!
;
;	compute # sectors needed in file
;
HAVE1	LD	B,C		;shift input value
	EX	DE,HL		;BHL = input value
	LD	(IX+48),B	;max diskettes
	LD	(IX+49),H
	LD	(IX+50),L
	XOR	A		;load zero
	LD	(IX+51),A	;reset # disks used
	LD	(IX+52),A
	LD	(IX+53),A
	LD	(IX+73),A	;reset # files used
	LD	(IX+74),A
	LD	(IX+75),A
	DEC	A		;load ffh
	LD	(IX+54),A	;reset deleted disk links
	LD	(IX+55),A
	LD	(IX+56),A
	LD	(IX+64),A	;reset deleted file links
	LD	(IX+65),A
	LD	(IX+66),A
;
;	load ascii max diskettes into prompt text
;
	PUSH	BC		;save
	PUSH	HL		;save
	LD	IX,PMPT3A	;text to load
	LD	DE,6<8+10	;length + base
	CALL	$BINASC		;binary => ascii
	POP	HL		;restore
	POP	BC		;restore
;
;	save # diskettes
;
	PUSH	BC		;save
	PUSH	HL		;BHL on stack
	LD	C,16		;entries / sector
	CALL	$DIVID		;BHL+A = BHL/C
	OR	A		;any remainder?
	CALL	NZ,$INC24	;increment if yes
	CALL	$INC24		;+ index sector
	LD	IX,@DATA	;data storage
	LD	(IX+57),B	;update disk table start
	LD	(IX+58),H
	LD	(IX+59),L
;
;	BHL = # sectors needed for disk name/date/pointer
;
	POP	DE		;nsb/lsb # diskettes
	POP	AF		;A = msb
	LD	C,A		;CDE = # diskettes
	CALL	$ADD24		;BHL = BHL + CDE
;
;	needed disk space found
;
	LD	(IX+60),B	;msb
	LD	(IX+61),H	;nsb
	LD	(IX+62),L	;lsb
;
;	calculate file size in K to check with user
;
	CALL	$INC24		;adjust for 0 relative
	LD	C,4		;sectors / K
	CALL	$DIVID		;BHL = # K
	OR	A		;any remainder?
	CALL	NZ,$INC24	;yes, add 1 for it
	LD	IX,PMPT3B	;prompt 3 text
	LD	DE,8<8+10	;length + base
	CALL	$BINASC		;binary => ascii
	LD	IX,@DATA	;reset pointer
	BIT	6,(IX+96)	;no prompt on space?
	JR	NZ,DEFH2	;go if no prompt
;
;	ask user if OK
;
ASK2	LD	HL,PROMPT3	;prompt 3
	CALL	$DOLINE		;display prompt
	CALL	$INKEY		;get key input
	JP	C,ABORT		;routine aborted!
	JR	Z,DEFH2		;go on ENTER
;
	CALL	$UCASE		;make upper case
	CP	'N'		;not ok?
	JP	Z,ASK1		;nope, re-prompt
	CP	'Y'		;yes?
	JR	NZ,ASK2		;neither, ask again
;
;	allocate disk space
;
DEFH2	LD	HL,ALLMSG	;'allocating'
	CALL	$DOLINE		;display
	LD	BC,@EOFS	;point to record
	LD	DE,(@FCB)	;get fcb pointer
	CALL	$POSN		;position to end of file
	JR	Z,SPACEOK	;go if no error
	CP	1CH		;end of file?
	JR	Z,SPACEOK	;go if yes
	CP	1DH		;beyond file?
	JP	NZ,ERROR	;go if neither
;
SPACEOK	LD	HL,(@IOBUFF)	;get I/O buffer
	LD	BC,0<8+0FFH	;length + fill
	CALL	$CLEAR		;zero buffer
	CALL	$WRITE		;allocate space
	JP	NZ,ERROR	;go if error
;
	LD	A,'C'		;compressed
	BIT	1,(IX+96)	;yes?
	JR	NZ,DATA9	;go if yes
	LD	A,'E'		;expanded
	BIT	0,(IX+96)	;yes?
	JR	NZ,DATA9	;go if yes
;
;	ask if file is to be compressed/expanded
;
ASK9	LD	HL,CEMSG	;'compressed/expanded?'
	CALL	$DOLINE		;display
	CALL	$INKEY		;from keyboard
	JP	C,ABORT		;abort on BREAK
	JR	Z,DATAD9	;go default if enter
DATA9	CALL	$UCASE		;first char upper case
	CP	'C'		;compressed
DATAD9	LD	B,0		;set flag
	JR	Z,HAVE9		;go if have
	CP	'E'		;expanded?
	JR	NZ,ASK9		;neither, ask again
	DEC	B		;set FF flag for E
HAVE9	LD	A,B		;get flag
	LD	(SIZE),A	;save the size of it
;
	LD	HL,INIMSG	;'initializing'
	CALL	$DOLINE		;display
	LD	DE,(@FCB)	;refetch FCB
	CALL	$REWIND		;rewind file
	JP	NZ,ERROR	;go if error
;
;	reset # sectors to be used for name/date/index
;
	PUSH	DE		;save FCB
	LD	HL,(@IOBUFF)	;get I/O buffer start
	LD	IX,@DATA	;data storage
	LD	H,(IX+49)	;max diskettes
	LD	L,(IX+50)
	LD	BC,0<8+16	;BHL=diskettes, C=#/sect
	CALL	$DIVID		;BHL+A = BHL/C
	OR	A		;any remainder?
	CALL	NZ,$INC24	;+1 if yes
	POP	DE		;DE => FCB
;
BUFFF2	CALL	$WRITE		;write a sector
	JP	NZ,ERROR	;go if disk error
	CALL	$DEC24		;BHL = BHL-1
	LD	A,B		;check if done
	OR	H
	OR	L		;BHL = 000000?
	JR	NZ,BUFFF2	;go if not
;
;	reset # disk indexes
;
	LD	IX,@DATA	;data storage
	LD	B,(IX+49)	;max diskettes
	LD	C,(IX+50)
;
BUFFF3	CALL	$WRITE		;write a sector
	JP	NZ,ERROR	;go if disk error
	DEC	BC		;less counter
	LD	A,B		;check if done
	OR	C		;BC = 0000?
	JR	NZ,BUFFF3	;continue if not
;
;	all sectors filled, read verify back
;
	LD	HL,VERMSG	;'verifying file'
	CALL	$DOLINE		;display
;
;	write init data to all sectors of file
;
	CALL	$REWIND		;rewind file
	JP	NZ,ERROR	;go if disk error
	PUSH	DE		;save FCB pointer
	CALL	SETID		;setup ID data
	POP	DE		;DE => fcb
	CALL	$WRITE		;write first sector
	JP	NZ,ERROR	;go if error
;
	CALL	$REWIND		;re-rewind file
	JP	NZ,ERROR	;go if error
	LD	IX,@DATA	;reset data pointer
	LD	B,(IX+60)	;get EOF sector
	LD	H,(IX+61)
	LD	L,(IX+62)	;BHL = EOF sector
;
VERLP	CALL	$READ		;read a sector
	JP	NZ,ERROR	;go on disk error
	CALL	$DEC24		;BHL = BHL -1
	LD	A,B		;check if completed
	OR	H
	OR	L		;BHL = 000000?
	JR	NZ,VERLP	;continue till end
;
;	file created/allocated/initialized/verified
;
	CALL	$CLOSE		;close file
	JP	NZ,ERROR	;go if disk error
;
;	re-open file for index access
;
	CALL	SETUP		;open and load data
	JP	NZ,ERROR	;go if disk error
;
;	completed
;
	LD	HL,COMMSG	;'completed'
	JP	GODOSV		;back to command mode
;
;	file exists, ask if to be replaced
;
EXISTS	LD	IX,@DATA	;reset pointer
	BIT	7,(IX+96)	;overwrite?
	RET	NZ		;yes, don't ask
;
EXIST1	LD	HL,EXISMG	;'file exists, replace?'
	CALL	$DOLINE		;display message
	CALL	$INKEY		;get key input
	JP	C,ABORT		;abort on break key
	RET	Z		;default yes
EXIST2	CALL	$UCASE		;first char upper case
	CP	'Y'		;replace?
	RET	Z		;yes, go!
	CP	'N'		;no?
	JR	NZ,EXIST1	;neither, ask again
EXIST2D	JP	ABORT		;abort if not
;
;	initialize identification data in first sector
;
SETID	LD	HL,IDDATA	;ID data
	LD	DE,(@IOBUFF)	;I/O buffer
	LD	BC,100H		;sector length
	PUSH	DE		;save buffer
	LDIR			;move init data
	POP	IY		;IY => data
;
	LD	HL,(@IOBUFF)	;buffer start
	LD	DE,58H		;offset to data
	ADD	HL,DE		;HL => date
	CALL	$DATE		;load system date
;
	LD	HL,(@IOBUFF)	;start I/O buffer
	LD	DE,30H		;offset to data
	ADD	HL,DE		;HL => buffer data
	EX	DE,HL		;DE => buffer data
	LD	HL,@DATA+30H	;start setup data
	LD	BC,16		;data list length
	LDIR			;move it in
;
	LD	IX,@DATA	;start data
	LD	B,(IX+60)	;get EOFS
	LD	H,(IX+61)
	LD	L,(IX+62)
	LD	(IY+70),B	;start sector files
	LD	(IY+71),H
	LD	(IY+72),L
	LD	(IY+76),0	;update file free record
	LD	(IY+77),0
	LD	(IY+78),0
	LD	A,0		;get size factor
SIZE	EQU	$-1
	LD	HL,(@IOBUFF)	;get i/o buffer start
	LD	BC,0FFH		;offset to last byte
	ADD	HL,BC		;HL => last byte
	LD	(HL),A		;save size factor
	RET			;I/O buffer set
;
;	open existing file
;
DOOPEN	CALL	$POSHL		;any more input?
	JP	NZ,INVALID	;yes, invalid command!
;
	CALL	SETUP		;open/load file
	JP	NZ,ERROR	;go if disk error
	JP	$CMD		;back to command mode
;
	PAGE
;
;	open filespec pointed to by (@FNAME)
;
SETUP	LD	HL,@FLAG1	;system flag
	RES	7,(HL)		;set file not open
	CALL	$SHOWF		;display filespec
;
	LD	HL,(@FNAME)	;filename
	LD	DE,(@FCB)	;fileblock
	LD	BC,50		;max name length
	PUSH	DE		;save fileblock
	LDIR			;move it in
	POP	DE		;DE => FCB
	LD	HL,(@IOBUFF)	;I/O buffer
	LD	BC,0<8+'W'	;lrl=256 + read/write
	CALL	$OPEN		;open the file
	RET	NZ		;go if disk error
;
;	set random positioning bit
;
	LD	HL,0		;set record 0
	LD	(@POSIT),HL	;load pointer
	LD	(@POSIT+1),HL	;3 byte pointer
	LD	BC,@POSIT	;point to record #
	CALL	$POSN		;rewind and set random ac
	RET	NZ		;go if disk error
;
;	read first sector and load data to RECPTR
;
	CALL	$READ		;read first sector
	RET	NZ		;go if disk error
	LD	HL,(@IOBUFF)	;start I/O buffer
	LD	DE,(@RECPTR)	;record pointer
	LD	BC,100H		;length of sector
	PUSH	DE		;save record pointer
	LDIR			;save buffer
;
;	check if file compressed/expanded
;
	DEC	HL		;HL => last byte in buff
	LD	A,(HL)		;get flag
	OR	A		;0=compressed
	LD	HL,@FLAG1	;system flag 1
	RES	6,(HL)		;set compressed
	JR	Z,$+4		;go if compressed
	SET	6,(HL)		;set expanded
;
;	load data pointers with size/etc
;
	POP	HL		;HL => data
	LD	DE,30H		;offset to data
	ADD	HL,DE		;HL => useable data
	LD	DE,@DATA+30H	;offset to storage
	LD	BC,48		;data length
	LDIR			;move it!
;
;	verify header on first sector
;
	LD	HL,IDDATA	;data length
	LD	DE,(@RECPTR)	;record pointer
	LD	B,16		;length to test
	CALL	$COMPAR		;test strings
	LD	HL,FMTMSG	;'invalid file format'
	LD	A,0		;set system error
	RET	NZ		;go if invalid header
;
;	display file specifics and flag file open
;
	LD	HL,@FLAG1	;system flag
	SET	7,(HL)		;set file open
	LD	IY,(@BUFTBL)	;buffer table
	XOR	A		;load zero
	LD	(IY+1),A	;# buffers used
	OR	(IY+0)		;any available?
	LD	A,01000000B	;set nil flags
	JR	Z,$+4		;go if none
	OR	80H		;set available
	LD	(IY+2),A	;load flags
	CALL	$SHOWF		;display facts
	XOR	A		;set NO error
	RET			;done!
;
;	default identity sector
;
IDDATA	DEFB	05H,0EH
	DEFM	'diskman by BCI'
;
	DEFB	001H,01AH,000H,070H,021H,006H,070H,0C3H
	DEFB	067H,044H,044H,069H,073H,06BH,04DH,041H
;
	DEFB	04EH,020H,064H,061H,074H,061H,020H,066H
	DEFB	069H,06CH,065H,00DH,002H,002H,000H,070H
;
	DEFB	0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0
;
	DEFB	-1,-1,-1,-1,-1,-1,0,0,0
	DEFB	0,0,0,0,0,0,0
;
	DEFM	'Created-../../..'
;
;	+60h
;
	DEFM	'Flag 01 Flag 02 Flag 03 Flag 04 '
	DEFM	'Flag 05 Flag 06 Flag 07 Flag 08 '
	DEFM	'Flag 09 Flag 10 Flag 11 Flag 12 '
	DEFM	'********************************'
	DEFM	'********************************'
;
;	text area
;
PROMPT3	DEFB	_STX
	DEFB	@VID,000
	DEFB	_EREOF
PMPT3A	DEFM	'...... Disks takes '
PMPT3B	DEFM	'........k minimum, OK? '
	DEFB	_ETX
;
CEMSG	DEFB	_STX
	DEFB	@VID,000
	DEFB	_EREOF
	DEFM	'C(ompressed or E)xpanded format? '
	DEFB	_ETX
;
ALRMSG	DEFB	_STX
	DEFB	@VID+1,00
	DEFB	_EREOF
	DEFM	'Index Already Open - Use CLOSE'
	DEFB	_ETX
;
PROMPT0	DEFB	_STX
	DEFB	@VID,000
	DEFB	_EREOF
	DEFM	'Filespec? '
	DEFB	_ETX
;
DOSMSG	DEFB	_STX
	DEFB	@VID+1,000
	DEFB	_EREOF
	DEFM	'Initialize Error - '
	DEFB	_ETX
;
INVMSG	DEFB	_STX
	DEFB	@VID+1,00
	DEFB	_EREOF
	DEFM	'Invalid Command Parameter - Use HELP'
	DEFB	_ETX
;
OPEMSG	DEFB	_STX
	DEFB	@VID+1,000
	DEFB	_EREOF
	DEFM	'Open',_SEP,'Mount Error - '
	DEFB	_ETX
;
FMTMSG	DEFM	'Invalid File Format'
	DEFB	_ETX
;
ABTMSG	DEFB	_STX
	DEFB	@VID+1,000
	DEFB	_EREOF
	DEFM	'Open',_SEP,'Init Aborted'
	DEFB	_ETX
;
CHKMSG	DEFB	_STX
	DEFB	@VID+1,000
	DEFB	_EREOF
	DEFM	'Checking For Existing File ...'
	DEFB	_ETX
;
CREMSG	DEFB	_STX
	DEFB	@VID+1,000
	DEFB	_EREOF
	DEFM	'Creating Index File ...'
	DEFB	_ETX
;
PROMPT2	DEFB	_STX
	DEFB	@VID,000
	DEFB	_EREOF
	DEFM	'Maximum # Diskettes? '
	DEFB	_ETX
;
ALLMSG	DEFB	_STX
	DEFB	@VID+1,000
	DEFB	_EREOF
	DEFM	'Allocating Required Disk Space ...'
	DEFB	_ETX
;
INIMSG	DEFB	_STX
	DEFB	@VID+1,000
	DEFB	_EREOF
	DEFM	'Initializing Index File Data ...'
	DEFB	_ETX
;
VERMSG	DEFB	_STX
	DEFB	@VID+1,000
	DEFB	_EREOF
	DEFM	'Verifying Index File ...'
	DEFB	_ETX
;
COMMSG	DEFB	_STX
	DEFB	@VID+1,000
	DEFB	_EREOF
	DEFM	'Index Created',_SEP
	DEFM	'Initialized',_SEP
	DEFM	'Verified'
	DEFB	_ETX
;
EXISMG	DEFB	_STX
	DEFB	@VID,000
	DEFB	_EREOF
	DEFM	'File Exists, Replace? '
	DEFB	_ETX
;
_______	EQU	$
;
	END	ENTRY
