; dman01/asm - kjw/bci - LIB/EXIT/CLOSE/DOS/WHO/VERSION
;
;	created 08/12/83	- kjw/bci
;	revised 10/07/83	- kjw/bci
;
;	index sector relative 0 image
;
;	+0-0F	- header ID string 'Diskman by BCI'
;	10-2F	- accident execute message code
;	30-32	- # diskettes maximum
;	33-35	- # diskettes used
;	36-38	- start link deleted disks
;	39-3B	- start sector disk tables
;	3C-3E	- EOFS sector current
;	3F	- unused (00)
;	40-42	- deleted file link start
;	43-45	- deleted file link end
;	46-48	- start sector file data
;	49-4B	- # files active
;	4C-4E	- next free file record RSN
;	4F	- next free file record byte
;	50-57	- 'Created'
;	58-5F	- creation date MM/DD/YY
;	60-	- flag names (12 bytes each)
;
ENTRY	LD	SP,(@STACK)	;reset stack
	JR	Z,START		;prompt only
	DEC	A		;command 1?
	JR	Z,CMDMODE	;yes, command mode
	DEC	A		;command 2?
	JP	Z,DOLIB		;list library
	DEC	A		;command 3?
	JP	Z,DOLIB0	;library at curr cursor
	DEC	A		;command 4?
	JP	Z,DOEXIT	;exit program
	DEC	A		;command 5
	JP	Z,DOCLOSE	;close/unload
	DEC	A		;command 6
	JP	Z,DODOS		;dos command line
	DEC	A		;command 7
	JP	Z,SHOWHO	;display author
	DEC	A		;command 8
	JP	Z,SCREEN	;reset screen
	DEC	A		;command 9
	JR	Z,RSTART	;yes, restart
	DEC	A		;command 10
	JP	Z,BUFCTL	;buffer control
	DEC	A		;command 11
	JP	Z,DOVERSN	;display version
;
;	additional commands
;
CMDMODE	LD	HL,MODE		;command mode
	CALL	$DOLINE		;display prompt
	JR	START		;continue
;
RSTART	LD	SP,(@STACK)	;reset stack
	LD	HL,PROMPT1	;command prompt
	CALL	$DOLINE		;display prompt
	LD	B,@COLS-4	;max key input
	CALL	$KBLINE		;fetch key input
	PUSH	AF		;save flags
	PUSH	HL		;save input
	CALL	$DOHEAD		;re-display header
	LD	HL,PROMPT	;command prompt
	CALL	$DOLINE		;re-display
	POP	HL		;get input pointer
	PUSH	HL		;save again
	CALL	$DOLINE		;display input
	POP	HL		;restore input
	POP	AF		;restore flags
	JP	C,RESLINE	;go on break
	JR	START0		;interpret
;
RESLINE	LD	HL,EXBUF$	;stored data
	LD	BC,@COLS<8+' '	;length + fill
	CALL	$CLEAR		;reset area
	LD	A,_ETX		;terminator
	LD	(EXBUF$+@COLS),A
;
START	LD	SP,(@STACK)	;reset stack
	LD	HL,PROMPT	;command prompt
	CALL	$DOLINE		;display prompt
	LD	B,@COLS-4	;max key input
	CALL	$KBLINE		;fetch key input
	JR	C,RESLINE	;back to command mode
;
;	check for any input
;
START0	PUSH	HL		;save pointer start
	CALL	$POSHL		;any input?
	JR	NZ,START1	;go if yes
;
	POP	HL		;restore
	LD	HL,PROMPT	;prompt line
	CALL	$DOLINE		;reset cursor
	CALL	$CURADD		;get cursor address
	PUSH	HL		;save address
	EX	DE,HL		;DE => video area
	LD	HL,EXBUF$	;stored command
	CALL	$VIDON		;enable video
	LD	BC,@COLS-4	;length
	LDIR			;move to video
	CALL	$VIDOFF		;disable video
	POP	HL		;HL => video
	LD	DE,EXBUF$	;stored command
	LD	B,@COLS-4	;max length
	CALL	$KBEDIT		;edit command
	LD	HL,EXBUF$	;command
	JP	C,RESLINE	;reset line on break
	JR	START0		;continue
;
START1	EX	(SP),HL		;leave pointer, get start
	LD	DE,EXBUF$	;stored command
	LD	BC,@COLS-4	;length
	LDIR			;save command for editing
	POP	DE		;DE => current command
	LD	HL,LIBRY	;HL => library commands
	CALL	FIND		;locate command
	JR	NZ,GOTLIB	;have library, go!
;
	LD	HL,UNREC	;'unrecognized command'
	CALL	$DOLINE		;display text
	JR	START		;back to command mode
;
;	have library command, execute
;
GOTLIB	LD	DE,LOOKUP-1	;lookup table
	ADD	A,E		;add offset
	LD	E,A		;update lsb
	JR	NC,$+3		;go if no overflow
	INC	D		;bump msb
	LD	A,(DE)		;fetch command
	OR	A		;defined command?
	JP	NZ,$OVRLAY	;execute command if yes
;
;	undefined system command
;
	LD	HL,UNDEF	;undefined command
	CALL	$DOLINE		;display
	JR	START		;re-prompt for command
;
;	locate command word in lookup table
;
FIND	LD	B,0		;position counter
FINDLP	INC	B		;bump command #
	LD	A,(HL)		;fetch table entry
	INC	HL		;bump pointer
	OR	A		;end list?
	JP	P,FINDLP+1	;locate first byte
	AND	7FH		;remove high bit
	RET	Z		;not found!
;
	PUSH	DE		;save string
FINDLP1	CALL	$UCASE		;make upper case
	LD	C,A		;C = char
	LD	A,(DE)		;get input char
	CALL	$UCASE		;make upper case
	CP	C		;match?
	JR	NZ,FINDLP2	;go if not
	LD	A,(HL)		;get next char
	INC	DE		;bump input string
	INC	HL		;bump lookup table
	JR	FINDLP1		;continue
;
FINDLP2	LD	(FINDAD),DE	;save current pointer
	POP	DE		;restore string pointer
	BIT	7,C		;end table entry?
	JR	Z,FINDLP	;nope, go next word
	CP	30H		;terminator/separator?
	JR	NC,FINDLP	;nope, continue
	LD	HL,$		;re-fetch string pointer
FINDAD	EQU	$-2
	LD	A,B		;get table position
	OR	A		;set NZ for found
	RET			;return command #
;
	PAGE
;
;	display library command
;
DOLIB	LD	HL,LIBMSG	;set cursor and clear
	CALL	$DOLINE		;send to video
DOLIB0	LD	HL,LIBRY1	;library commands
;
DOLIB2	LD	E,8		;names / line
DOLIB3	LD	D,8		;chars / name
;
;	fetch a character, check for terminator
;
	LD	A,(HL)		;get a character
	AND	7FH		;remove high bit
	JP	Z,START		;back to command mode
;
DOLIB4	CALL	$DOCHAR		;character to video
	INC	HL		;bump text pointer
	DEC	D		;less byte counter
	LD	A,(HL)		;fetch next char
	BIT	7,A		;start of next word?
	JR	Z,DOLIB4	;continue if not
;
;	check if at end of line
;
	DEC	E		;dec word counter
	JR	Z,DOLIB6	;go if end of line
;
;	else pad rest of word length with spaces
;
DOLIB5	LD	A,' '		;blank char
	CALL	$DOCHAR		;char to video
	DEC	D		;less byte counter
	JR	NZ,DOLIB5	;finish length
	JR	DOLIB3		;resume next word
;
;	line completed, send CR
;
DOLIB6	LD	A,_CR		;carriage return
	CALL	$DOCHAR		;char to video
	JR	DOLIB2		;next word
;
;	exit program
;
DOEXIT	LD	A,(@FLAG1)	;get system flag
	BIT	7,A		;index file open?
	JR	Z,EXITER	;go if not
;
	LD	IY,(@BUFTBL)	;buffer pointer
	LD	(IY+1),0	;clear # used
	LD	A,(IY+2)	;get flags
	AND	0C0H		;drop current posit
	LD	(IY+2),A	;update flags
	LD	DE,(@FCB)	;file block
	CALL	$CLOSE		;close file
	JR	Z,EXITER	;go if OK
	LD	DE,CLOMSG	;'close error'
	CALL	$DOERR		;display message
	LD	HL,KEYMSG	;'key to continue'
	CALL	$DOLINE		;display prompt
	CALL	$ENKEY		;wait for enter key
;
EXITER	CALL	$SHOWF		;display stats
	LD	HL,EXITMSG	;exit message
	CALL	$DOLINE		;display text
	JP	$EXIT		;exit program
;
;	execute close function
;
DOCLOSE	LD	A,(@FLAG1)	;get system flag
	RLCA			;file open?
	JR	C,CLOSURE	;go if yes
;
	LD	HL,NOTOMSG	;'file not open'
	CALL	$DOLINE		;display message
	JP	START		;abort
;
CLOSURE	LD	IY,(@BUFTBL)	;buffer pointer
	LD	(IY+1),0	;clear # loaded
	LD	A,(IY+2)	;get flags
	AND	0C0H		;drop 2 low bits
	LD	(IY+2),A	;reset flags
	LD	DE,(@FCB)	;file block
	CALL	$CLOSE		;close the file
;
ERROR	PUSH	AF		;save status
	PUSH	HL		;save
	LD	HL,@FLAG1	;system flag 1
	RES	7,(HL)		;set file closed
	CALL	$SHOWF		;display file stats
	POP	HL		;restore
	POP	AF		;restore status
	JP	Z,$CMD		;command mode if OK
;
	LD	DE,CLOMSG	;'close error'
	CALL	$DOERR		;display message
	JP	START		;back to command mode
;
;	execute dos command
;
DODOS	PUSH	HL		;save input
	CALL	CKIFMEM		;check if enough memory
	POP	HL		;restore input
;
	CALL	$POSHL		;any input?
	JR	NZ,DODOS1	;go if yes!
;
DODOS0	LD	HL,PROMPT2	;input prompt
	CALL	$DOLINE		;display prompt
	LD	B,@COLS-4	;max input length
	CALL	$KBLINE		;get key input
	JP	C,CMDMODE	;go on BREAK
	JR	DODOS		;see if any input
;
DODOS1	LD	DE,DOSBUF$	;dos input buffer
	LD	A,@COLS		;max length
	LD	BC,-1		;all bits on
;
DODOS2	EX	AF,AF'		;save count
	LD	A,(HL)		;get a character
	CP	' '		;blank?
	JR	Z,DODOS3	;go if not
	CP	_CR		;term?
	JR	Z,DODOS5	;go if yes
	CP	_REMARK		;remark block
	JR	Z,DODOS5	;yes, termianate
	CP	_ETX		;end text?
	JR	Z,DODOS5	;go if yes
	LD	B,D		;save last posit
	LD	C,E		;BC = last space
DODOS3	LD	(DE),A		;load to dest
	INC	HL		;bump source
	INC	DE		;bump dest
	EX	AF,AF'		;restore count
	DEC	A		;less count
	JR	NZ,DODOS2	;continue till end
;
DODOS5	LD	A,B		;check if anything
	AND	C
	INC	A		;BC = FFFF?
	JR	Z,DODOS0	;go if yes
	INC	BC		;bump past last char
	LD	A,_CR		;terminator
	LD	(BC),A		;to string
	INC	BC		;bump to next
	LD	A,_ETX		;end text
	LD	(BC),A		;to buffer
;
	CALL	CKIFMEM		;check enough, get hi$
	LD	(OLDHI),HL	;save old high memory
	LD	BC,LAST-FIRST	;program length
	OR	A		;clear carry flag
	SBC	HL,BC		;HL = new high memory
	LD	(ISHERE),HL	;save data address
	LD	SP,(@STACK)	;reset stack
	PUSH	HL		;save
	LD	DE,RESUME-FIRST	;offset to restore vector
	ADD	HL,DE		;HL = return vector
	LD	(RET1),HL	;save address
	LD	(RET2),HL	;need 2 vectors
	LD	A,0C3H		;JP opcode
	LD	(RET0),A	;save into table
	LD	(RET0+3),A	;2 vectors
	EX	(SP),HL		;leave vector, get HL
	DEC	HL		;new free high memory
	CALL	$MSIZE		;update new high memory
	INC	HL		;restore load address
;
;	if ldos must link into dos return vectors
;
	IF	LDOS1.OR.LDOS3.OR.MDOS1.OR.MDOS3
	PUSH	HL		;save address
	LD	HL,RET0		;dos intercept vectors
	LD	DE,402DH	;dos exit vector
	LD	B,6		;code length
	CALL	SWAP		;swap data
	POP	HL		;restore return
	ENDIF
;
	EX	DE,HL		;DE => new save address
	LD	HL,FIRST	;HL => current location
	LD	BC,LAST-FIRST	;program length
	LDIR			;move code => high mem
	LD	HL,MODE2	;clear lower video
	CALL	$DOLINE		;display
	LD	HL,DOSBUF$	;get command
	PUSH	HL		;save start
	CALL	$DOLINE		;display command
	POP	HL		;HL => command
;
	IF	LDOS1.OR.LDOS3.OR.MDOS1.OR.MDOS3
	JP	@RETCMD		;execute and return
	ENDIF
;
	IF	LDOS4.OR.LDOS2
	LD	A,@RETCMD	;SVC#
	JP	@SVC		;execute and return
	ENDIF
;
;	re-move program back to original location
;
RESUME	LD	HL,$		;where program is now
ISHERE	EQU	$-2
	LD	DE,FIRST	;where it goes
	LD	BC,LAST-FIRST	;program length
	LDIR			;move it back!
	JP	RESFIN		;continue
RESFIN	EQU	$
;
;	resume command mode
;
;	if ldos restore dos exit vectors
;
	IF	LDOS1.OR.LDOS3.OR.MDOS1.OR.MDOS3
	LD	HL,RET0		;dos storage
	LD	DE,402DH	;data goes here
	LD	B,6		;data length
	CALL	SWAP		;re-swap data
	ENDIF
;
;	fetch current high memory to check
;	that dos service did not change previous himem
;
	LD	HL,0		;set FETCH command
	CALL	$MSIZE		;get current high$
	INC	HL		;correct to location
	LD	DE,(ISHERE)	;get set high memory
	OR	A		;clear carry
	SBC	HL,DE		;is current = set?
	JR	NZ,CKBFS	;do not change if not!
;
;	reset previous high memory
;
	LD	HL,$		;get old high memory
OLDHI	EQU	$-2
	CALL	$MSIZE		;reset memory size
;
;	reset number of memory buffers available
;
CKBFS	LD	HL,0		;init command
	CALL	$MSIZE		;get current topmem
	LD	BC,BUFFS	;start buffers
	OR	A		;clear carry
	SBC	HL,BC		;compare
	LD	A,H		;get # full buffers
	CP	51		;0-50?
	JR	C,$+4		;go if ok
	LD	A,50		;else set max
	LD	(BUFTBL-1),A	;set max
	LD	(BUFTBL),A	;set available
	XOR	A		;load zero
	LD	(BUFTBL+1),A	;set used
	LD	A,0C0H		;set active
	LD	(BUFTBL+2),A	;set pointers
	JP	RSTART		;restart program
;
;	dos storage vectors for dos
;
RET0	JP	$
RET1	EQU	$-2
	JP	$
RET2	EQU	$-2
;
;	swap contents of (HL) with (DE) for B bytes
;
SWAP	LD	C,(HL)		;get first
	LD	A,(DE)		;get second
	LD	(HL),A		;swap one
	LD	A,C		;get first
	LD	(DE),A		;swap two
	INC	HL		;bump pointer 1
	INC	DE		;bump pointer 2
	DJNZ	SWAP		;go for data length
	RET			;done!
;
;	check if sufficient memory exists to move
;	program above dos useage level
;	enter HL = current high memory, exit unchanged
;
CKIFMEM	LD	HL,0		;set FETCH command
	CALL	$MSIZE		;get high memory
	PUSH	HL		;save high$
	LD	DE,LAST-FIRST	;program length
	OR	A		;clear carry
	SBC	HL,DE		;resulting himem
	JR	C,NOTMEM	;insufficient
	LD	DE,BUFFS	;lowest desired
	SBC	HL,DE		;enough minimum?
	POP	HL		;restore original
	RET	NC		;enough, go!
;
;	insufficient memory to execute DOS command
;
NOTMEM	POP	AF		;remove HL on stack
	LD	HL,MEMMSG	;'not enough'
	CALL	$DOLINE		;display
	JP	START		;back to command mode
;
SHOWHO	CALL	$DOHEAD		;re-draw header
	LD	HL,WHOMSG	;author message
	CALL	$DOLINE		;display
	JP	START		;re-start command mode
;
SCREEN	CALL	$DOHEAD		;re-draw header
	JP	START		;back to command mode
;
;	buffer control
;
BUFCTL	LD	IY,(@BUFTBL)	;buffer table
	CALL	$POSHL		;any more input?
	JR	Z,SHOBUF	;nope, display
;
	CALL	$VALUE		;get input value
	JR	NZ,BADBUF	;invalid
	LD	A,C		;get msb
	OR	A		;>65536?
	JR	NZ,BADBUF	;invalid if yes
	LD	A,D		;get nsb
	OR	A		;>256?
	JR	NZ,BADBUF	;invalid if yes
	LD	A,E		;get lsb
	OR	A		;0?
	JR	Z,SETBUF	;yes, go!
	DEC	A		;adjust for compare
	CP	(IY-1)		;compare to max avail
	JR	C,SETBUF	;OK, continue
;
BADBUF	LD	HL,BADBFM	;'invalid command'
	CALL	$DOLINE		;display
	JP	START		;go command mode
;
;	install new memory buffer count
;
SETBUF	LD	(IY+0),E	;set # available
	LD	(IY+1),0	;clear # loaded
	LD	A,E		;get # avail
	OR	A		;none?
	LD	A,01000000B	;clear flags
	JR	Z,$+4		;go if none
	OR	80H		;set available
	LD	(IY+2),A	;update flags
;
;	display current buffer settings
;
SHOBUF	LD	L,(IY+0)	;# avail
	LD	H,0		;clear nsb
	LD	B,H		;BHL = # available
	LD	IX,BUFMSG1	;text
	LD	DE,2<8+10	;length + base
	CALL	$BINASC		;convert to ascii
	LD	L,(IY+1)	;# used
	LD	H,0		;clear nsb
	LD	B,H		;BHL = # used
	LD	IX,BUFMSG2	;text
	LD	DE,2<8+10	;length + base
	CALL	$BINASC		;convert to ascii
	LD	L,(IY-1)	;max total
	LD	H,0		;nsb
	LD	B,H		;msb
	LD	IX,BUFMSG3	;text
	LD	DE,2<8+10	;length + base
	CALL	$BINASC		;convert
	LD	HL,BUFMSG	;start of message
	CALL	$DOLINE		;display to video
	JP	START		;back to command mode
;
;	display current # patches/version
;
DOVERSN	LD	A,(@PATCHS)	;get # patches
	LD	L,A		;pass value
	LD	H,0		;init nsb
	LD	B,H		;init msb
	LD	IX,VERMSG1	;text to load
	LD	DE,3<8+10	;length + base
	CALL	$BINASC		;binary => ascii
	LD	HL,VERMSG	;start of text
	CALL	$DOLINE		;display
	JP	START		;back to command mode
;
LIBRY	DEFB	'/'+80H		;who
	DEFM	'Who/'
	DEFB	'N'+80H		;names
	DEFM	'ames'
	DEFB	'B'+80H		;buffers
	DEFM	'uffers'
;
LIBRY1	DEFB	'A'+80H		;add
	DEFM	'dd'
	DEFB	'B'+80H		;buffers
	DEFM	'uffer'
	DEFB	'B'+80H		;browse
	DEFM	'rowse'
	DEFB	'C'+80H		;change
	DEFM	'hange'
	DEFB	'C'+80H		;check
	DEFM	'heck'
	DEFB	'C'+80H		;close
	DEFM	'lose'
	DEFB	'D'+80H		;dir
	DEFM	'ir'
	DEFB	'D'+80H		;dos
	DEFM	'os'
	DEFB	'E'+80H		;edit
	DEFM	'dit'
	DEFB	'E'+80H		;exit
	DEFM	'xit'
	DEFM	'F'+80H		;find
	DEFM	'ind'
	DEFM	'F'+80H		;flags
	DEFM	'lags'
	DEFB	'H'+80H		;help
	DEFM	'elp'
	DEFM	'I'+80H		;init
	DEFM	'nit'
	DEFB	'K'+80H		;kill
	DEFM	'ill'
	DEFB	'L'+80H		;lib
	DEFM	'ib'
	DEFB	'L'+80H		;log
	DEFM	'og'
	DEFB	'M'+80H		;mount
	DEFM	'ount'
	DEFB	'N'+80H		;name
	DEFM	'ame'
	DEFB	'O'+80H		;open
	DEFM	'pen'
	DEFB	'Q'+80H		;quit
	DEFM	'uit'
	DEFB	'R'+80H		;remove
	DEFM	'emove'
	DEFB	'S'+80H		;screen
	DEFM	'creen'
	DEFB	'T'+80H		;test
	DEFM	'est'
	DEFB	'U'+80H		;unload
	DEFM	'nload'
	DEFB	'U'+80H		;update
	DEFM	'pdate'
	DEFB	'V'+80H		;version
	DEFM	'ersion'
	DEFB	80H		;terminator
;
;	lookup table for library responses
;
LOOKUP	DEFB	7<4+1		;who
	DEFB	2<4+5		;names
	DEFB	10<4+1		;buffers
;
ULOOPUP	DEFB	3<4+4		;add
	DEFB	10<4+1		;buffer
	DEFB	3<4+7		;browse
	DEFB	1<4+8		;change
	DEFB	1<4+6		;check
	DEFB	5<4+1		;close
	DEFB	1<4+5		;dir
	DEFB	6<4+1		;dos
	DEFB	1<4+7		;edit
	DEFB	4<4+1		;exit
	DEFB	2<4+7		;find
	DEFB	4<4+7		;flags
	DEFB	1<4+2		;help
	DEFB	1<4+3		;init
	DEFB	5<4+7		;kill
	DEFB	2<4+1		;lib
	DEFB	1<4+4		;log
	DEFB	2<4+3		;mount
	DEFB	2<4+5		;names
	DEFB	2<4+3		;open
	DEFB	4<4+1		;quit
	DEFB	4<4+4		;remove
	DEFB	8<4+1		;screen
	DEFB	1<4+6		;test
	DEFB	5<4+1		;unload
	DEFB	2<4+4		;update
	DEFB	11<4+1		;version
;
;	text area
;
BADBFM	DEFB	_STX
	DEFB	@VID+1,00
	DEFB	_EREOF
	DEFM	'Invalid Buffer Count'
	DEFB	_ETX
;
BUFMSG	DEFB	_STX
	DEFB	@VID+1,00
	DEFB	_EREOF
BUFMSG3	DEFM	'.. Buffers Maximum, '
BUFMSG1	DEFM	'.. Available, '
BUFMSG2	DEFM	'.. Used'
	DEFB	_ETX
MEMMSG	DEFB	_STX
	DEFB	@VID+1,00
	DEFB	_EREOF
	DEFM	'Insufficient Memory For DOS Command'
	DEFB	_ETX
;
WHOMSG	DEFB	_STX
	DEFB	@VID+1,00
	DEFB	_EREOF
	DEFM	'DiskMAN - Version '
	VERSION
	DEFB	_CR
	DEFM	'Created August 1983 by'
	DEFB	_CR
	DEFM	'Kim J Watt'
	DEFB	_CR
	DEFM	'Copyright (C) 1983'
	DEFB	_CR
	DEFM	'Breeze Computing, Inc.'
	DEFB	_CR
	DEFM	'7267 W. Marine Drive'
	DEFB	_CR
	DEFM	'Milwaukee, Wisconsin 53223'
	DEFB	_CR
	DEFM	'(414) 355-2332 / 9-6cst'
	DEFB	_ETX
;
MODE	DEFB	_STX		;cursor command
	DEFB	@VID,00		;row/column
	DEFB	_EREOF		;erase to end of frame
	DEFB	_ETX		;end text
;
MODE2	DEFB	_STX		;cursor
	DEFB	00,00		;home
	DEFB	_EREOF		;clear video
	DEFB	_ETX		;end text
;
PROMPT	DEFB	_STX		;cursor command
	DEFB	@VID,00		;row/column
	DEFB	_EREOL		;erase to end of line
	DEFM	'*>'		;command prompt
	DEFB	_ETX		;end text
;
PROMPT1	DEFM	'*>'
	DEFB	_ETX
;
PROMPT2	DEFB	_STX
	DEFB	@VID,000
	DEFB	_EREOF
	DEFM	'Dos Command:'
CRMSG	DEFB	_CR
	DEFB	_ETX
;
VERMSG	DEFB	_STX
	DEFB	@VID+1,00
	DEFB	_EREOF
	DEFM	'Version '
	VERSION
	DEFM	' - Assembled '
	ASMDATE
	DEFB	_CR
VERMSG1	DEFM	'... Patches Installed'
	DEFB	_ETX
;
UNREC	DEFB	_STX		;cursor posit
	DEFB	@VID+1,00	;row/column
	DEFB	_EREOF		;clear frame
	DEFM	'Invalid Command - Use HELP'
	DEFB	_ETX
;
UNDEF	DEFB	_STX		;set cursor
	DEFB	@VID+1,00	;row/column
	DEFB	_EREOF		;clear frame
	DEFM	'Command Currently Unimplemented'
	DEFB	_ETX		;end text
;
LIBMSG	DEFB	_STX		;set cursor
	DEFB	@VID+1,00	;row/column
	DEFB	_EREOF		;clear frame
	DEFB	_ETX		;end text
;
EXITMSG	DEFB	_STX		;set cursor
	DEFB	02,00		;row/column
	DEFB	_EREOF		;clear frame
	DEFB	_CR		;linefeed
	DEFB	_ETX		;end text
;
CLOMSG	DEFB	_STX
	DEFB	@VID+1,000
	DEFB	_EREOF
	DEFM	'Index Close Error - '
	DEFB	_ETX
;
NOTOMSG	DEFB	_STX
	DEFB	@VID+1,000
	DEFB	_EREOF
	DEFM	'Index File Not Available - Use OPEN'
	DEFB	_ETX
;
KEYMSG	DEFB	_CR
	DEFM	'Key <ENTER> to Exit to OpSystem:'
	DEFB	_ETX
;
LAST	EQU	$		;last byte needed
;
_______	EQU	$
;
	END	ENTRY
