; diskmanb/asm - kjw/bci - Data/Vector Storage
;
;	created 08/11/83	- kjw/bci
;	revised 10/08/83	- kjw/bci
;
;	resident jump table
;
	ORG	@CODE		;dos free memory
FIRST	EQU	$		;first byte
$CMD	JP	START		;resume command mode
$KBCHAR	JP	KBCHAR		;keyboard character
$KBLINE	JP	KBLINE		;keyboard string
$KBEDIT	JP	KBLINE1		;keyboard editor
$KBWKEY	JP	KBLINE3		;keyboard editor
$DOCHAR	JP	DOCHAR		;display character
$DOLINE	JP	DOLINE		;display string
$PRCHAR	JP	PRCHAR		;char to printer
$PRLINE	JP	PRLINE		;string to printer
$MSIZE	JP	MSIZE		;fetch free memory
$DATE	JP	DATE		;fetch system date
$ERROR	JP	ERROR		;display dos error
$FSPEC	JP	FSPEC		;extract filespec
$INIT	JP	INIT		;open/create file
$OPEN	JP	OPEN		;open file
$POSN	JP	POSN		;position file
$READ	JP	READ		;read file record
$WRITE	JP	WRITE		;write file record
$CLOSE	JP	CLOSE		;close file record
$KILL	JP	KILL		;delete file
$DSIZE	JP	DSIZE		;fetch disk size
$CKDRV	JP	CKDRV		;check drive ready
$RDDIR	JP	RDDIR		;read disk directory
$WRDIR	JP	WRDIR		;write disk directory
$OVRLAY	JP	OVRLAY		;overlay loader
;
$MULT	JP	MULT		;24/8 bit multiply
$DIVID	JP	DIVID		;24/8 bit divide
$ADD24	JP	ADD24		;24/24 bit addition
$SUB24	JP	SUB24		;24/24 bit subtraction
$INC24	JP	INC24		;24 bit increment
$DEC24	JP	DEC24		;24 bit decrement
$CMP24	JP	CMP24		;24 bit compare
$BINASC	JP	BINASC		;binary => ascii convert
$VALUE	JP	VALUE		;ascii => binary convert
$GOTABL	JP	GOTABL		;table search/branch
$UCASE	JP	UCASE		;character to upper case
$SAVREG	JP	SAVREG		;preserve registers
$POSHL	JP	POSHL		;position HL to valid dat
$COMPAR	JP	COMPAR		;string comparison
$EXIT	JP	EXIT		;exit program
$DOERR	JP	DOERR		;display error
$ENKEY	JP	ENKEY		;get enter key
$REWIND	JP	REWIND		;rewind file
$SHOWF	JP	SHOWF		;display file/records
$CLEAR	JP	CLEAR		;clear data block
$VIDON	JP	VIDON		;enable video
$VIDOFF	JP	VIDOFF		;disable video
$INKEY	JP	INKEY		;get input key
$INKEY1	JP	INKEY1		;special input
$DOHEAD	JP	DOHEAD		;display header
$WILD	JP	WILD		;wild card load/compare
$GET	JP	GET		;get from device
$PUT	JP	PUT		;put to device
$GETDCT	JP	GETDCT		;get drive code table
$CURADD	JP	CURADD		;get cursor address
$DFREE	JP	DFREE		;get free space
$POSNR	JP	POSNR		;non-buffered posn
$LEOF	JP	LEOF		;locate end of file
$READR	JP	READR		;non-buffered read
$WRITER	JP	WRITER		;non-buffered write
;
;	system data storage
;
@BUFTBL	DEFW	BUFTBL		;buffer table
@BUFFS	DEFW	BUFFS		;start buffers
@DATA	EQU	$		;system data block
;
;	system data useage
;
;	+00-03	- system file positioning
;	+04	- current command to overlay
;	+05	- current overlay number resident
;	+06/07	- system overlay entry point
;	+08/09	- entry stack pointer address
;	+10	- flags 1
;	+11	- flags 2
;	+12/13	- pointer to filename storage
;	+14/15	- pointer to FCB
;	+16/17	- pointer to I/O Buffer
;	+18/19	- pointer to record pointer
;	+20-47	- available to overlays
;	+48-50	- maximum # diskettes available
;	+51-53	- # diskettes used in file
;	+54-56	- start deleted disk link
;	+57-59	- start sector disk tables
;	+60-62	- end of file sector for index
;	+63	- unused
;	+64-66	- deleted file link start
;	+67-69	- deleted file link end
;	+70-72	- start sector for file data
;	+73-75	- # files in index
;	+76-78	- next free file record rel sector #
;	+79	- next free file record byte
;	+80	- 'Created-'
;	+88	- date created
;	90-127	- available to overlays
;
@POSIT	DEFM	'....'		;for file positioning
@CURCMD	DEFW	0000H		;system overlay command
@SYSADD	DEFW	0000H		;system vector address
@STACK	DEFW	-1		;stack storage
@FLAG1	DEFB	00H		;flags 1
@FLAG2	DEFB	00H		;flags 2
@FNAME	DEFW	FNAME		;filename storage
@FCB	DEFW	FCB		;file block index
@IOBUFF	DEFW	IOBUFF		;file i/o buffer
@RECPTR	DEFW	RECPTR		;record pointer
;
@FREE1	DEFM	'............................'
;
@DISKM	DEFB	0,0,0		;max # disks
@DISKS	DEFB	0,0,0		;# disks used
@DELD	DEFB	-1,-1,-1	;deleted disk link
@SDT	DEFB	0,0,0		;start disk table
@EOFS	DEFB	0,0,0		;end of file sector
@PATCHS	DEFB	0		;patch count
@DDLS	DEFB	-1,-1,-1	;deleted file link start
@DDLE	DEFB	-1,-1,-1	;deleted file link end
@SSF	DEFB	0,0,0		;start sector files
@NFU	DEFB	0,0,0		;number files used
@NFFR	DEFB	0,0,0		;next free file record
@NFFB	DEFB	0		;next free file byte
	DEFM	'Created-'
@CRDATE	DEFM	'../../..'	;created date
@FREE2	DEFM	'......................................'
;
WILDMSK	DEFM	'???????????'
WILDTMP	DEFM	'?????????????'
;
;	system buffers
;
KBBUFF	DEFM	'....................'
	DEFM	'....................'
	DEFM	'....................'
	DEFM	'....................'
	DEFM	'..'
;
SYSFCB	DEFM	'DMAN/CMD'
	DEFB	_CR
SYSNAME	EQU	$-SYSFCB
	DC	50-SYSNAME,'.'
;
SYSTABL	DEFS	100H
SYSBUFF	DEFS	100H
;
FCB	DEFS	50
IOBUFF	DEFS	100H
FNAME	DEFS	32
RECPTR	DEFS	100H
;
	PAGE
;
;	actual program entry point
;
ENTRY	LD	(@STACK),SP	;save stack pointer
	LD	(@DISKM),HL	;save input pointer
	CALL	DOHEAD		;display header
;
;	verify correct computer
;
	IF	MOD1
	LD	A,(0125H)	;rom ID byte
	CP	'I'		;must be this
	LD	HL,ERRCOD	;error code
	JP	Z,MISFMT	;go if wrong
	LD	HL,0		;address where rom is!
	LD	A,(HL)		;read byte
	CPL			;reverse bits
	LD	(HL),A		;load byte
	CP	(HL)		;take a byte, = RAM!
	CPL			;adjust back in case
	LD	(HL),A		;update original
	LD	HL,ERRCOD	;error code
;	JP	Z,MISFMT	;RAM not ROM !
	NOP
	NOP
	NOP
	ENDIF
;
	IF	MOD3
	LD	A,(0125H)	;rom ID byte
	CP	'I'		;must be this
	LD	HL,ERRCOD	;error code
	JP	NZ,MISFMT	;go if wrong computer!
	LD	HL,0		;address where rom is!
	LD	A,(HL)		;read byte
	CPL			;reverse bits
	LD	(HL),A		;load byte
	CP	(HL)		;still there?
	CPL			;reverse back
	LD	HL,ERRCOD	;error code
	JP	Z,MISFMT	;RAM not ROM!
	ENDIF
;
	IF	MOD4.OR.MOD2
	LD	HL,0		;address for RAM
	LD	A,(HL)		;get a byte
	CPL			;reverse bits
	LD	(HL),A		;load byte
	CP	(HL)		;still there?
	CPL			;reverse back
	LD	(HL),A		;update
	LD	HL,ERRCOD	;message
	JP	NZ,MISFMT	;wrong computer!
	ENDIF
;
;	verify correct dos version
;
	IF	LDOS1
	LD	A,(403EH)	;read OS version #
	CP	51H		;5.1x ?
	LD	HL,ERRCOD	;error code
	JP	NZ,MISFMT	;wrong LDOS!
	ENDIF
;
	IF	LDOS3
	LD	A,(441FH)	;read OS version #
	CP	51H		;5.1x ?
	LD	HL,ERRCOD	;error message
	JP	NZ,MISFMT	;wrong LDOS!
	ENDIF
;
	IF	LDOS4.OR.LDOS2
	PUSH	IY		;save
	LD	A,@FLAGS	;svc #
	RST	@SVC		;get flags
	LD	A,(IY+27)	;get version #
	POP	IY		;restore
	CP	60H		;6.0?
	LD	HL,ERRCOD	;error message
	JP	NZ,MISFMT	;wrong ldos!
	ENDIF
;
	IF	MDOS1
	LD	HL,ERRCOD	;error message
	LD	A,(44E4H)	;read dos
	CP	0AFH		;must be
	JP	NZ,MISFMT	;go if wrong
	ENDIF
;
	IF	MDOS3
	LD	HL,ERRCOD	;message
	LD	A,(44E4H)	;read dos
	CP	0AFH		;must be
	JP	NZ,MISFMT	;go if wrong
	ENDIF
;
;	init number of memory buffers available
;
	LD	HL,0		;setup for call
	CALL	MSIZE		;fetch memory size
	LD	BC,BUFFS	;buffers start
	OR	A		;clear carry
	SBC	HL,BC		;compare
	LD	A,H		;get # buffers max
	CP	51		;50 max
	JR	C,$+4		;go if less
	LD	A,50		;else set max
	LD	(BUFTBL-1),A	;save max count
	LD	(BUFTBL),A	;save total avail
	XOR	A		;load zero
	LD	(BUFTBL+1),A	;set total used
	LD	A,0C0H		;set AVAILABLE
	LD	(BUFTBL+2),A	;reset pointers
;
;	open program file and read first sector
;	to store system overlay table in ram
;
	LD	DE,SYSFCB	;system FCB
	LD	HL,SYSBUFF	;system I/O buffer
	LD	BC,0<8+'R'	;lrl + read only
	CALL	OPEN		;open file
	JR	NZ,CANNOT	;cannot run program!
	CALL	READR		;read first sector
	JR	NZ,CANNOT	;cannot run program
;
;	move I/O buffer to system overlay lookup table
;
	LD	DE,SYSTABL	;system overlay table
	PUSH	DE		;save table start
	LD	BC,100H		;table length
	LDIR			;move buffer to table
	POP	HL		;HL => I/O table
	LD	A,(SYSTABL+0FFH)	;get # patches
	LD	(@PATCHS),A	;store number
;
;	verify sector header for file format
;
	LD	DE,HEADER	;header string
	LD	B,16		;header length
	CALL	COMPAR		;compare to header
	JR	NZ,FMTERR	;file format error!
;
;	setup loop to verify overlay headers
;
	LD	C,8		;8 system files active
SYSVER	LD	B,9		;header length
	LD	DE,HEADER1	;overlay headers
	CALL	COMPAR		;compare to header
	JR	NZ,FMTERR	;file format error
	INC	HL		;bump past file #
	INC	HL
	LD	A,(HL)		;get ID marker
	CP	'@'		;match?
	JR	NZ,FMTERR	;file format error
	INC	HL		;bump past header point
	INC	HL		;5 more bytes
	INC	HL
	INC	HL
	INC	HL
	DEC	C		;less overlay count
	JR	NZ,SYSVER	;go for count
;
	LD	HL,EXBUF$	;input buffer
	LD	BC,100<8+' '	;length + fill
	CALL	CLEAR		;clear area
	LD	A,_ETX		;terminator
	LD	(EXBUF$+@COLS),A
;
;	check if any input commands issued
;
	LD	HL,(@DISKM)	;get input pointer
	CALL	POSHL		;any input?
	JR	Z,START		;go if not
	LD	A,2<4+3		;command 2, system 3
	JR	START0		;execute OPEN
;
;	system OK and verified, enter command mode
;
START	LD	SP,(@STACK)	;reset stack
	CALL	SHOWF		;display filespecs
	LD	A,1<4+1		;command 1, system 1
START0	JP	OVRLAY		;execute overlay!
;
MISERR	LD	HL,CMDMSG	;'missing interpreter'
	JR	MISFMT		;continue
;
FMTERR	LD	HL,FMTMSG	;'file format error'
MISFMT	XOR	A		;set SYSTEM error
;
CANNOT	LD	DE,CANMSG	;'cannot execute system'
	CALL	DOERR		;display error string
	LD	HL,STOPMSG	;'key to exit to dos
	CALL	DOLINE		;display text
	CALL	ENKEY		;wait for enter key
;
EXIT	LD	SP,(@STACK)	;reset stack to entry
	XOR	A		;set NO error
	LD	L,A		;pass to extended error
	LD	H,A		;HLA = error code 000000
	RET			;return to op system
;
DOHEAD	LD	HL,HELLO	;header text
	CALL	DOLINE		;display to video
	JP	SHOWF		;display file facts
;
;	entry error text
;
CANMSG	DEFB	_STX		;cursor set
	DEFB	@VID,00		;row/column for cursor
	DEFB	_EREOF
	DEFM	'Cannot Execute System - '
	DEFB	_ETX
;
FMTMSG	DEFM	'Overlay Format Error'
	DEFB	_ETX
;
CMDMSG	DEFM	'Command Interpreter Missing'
	DEFB	_ETX
;
STOPMSG	DEFB	_CR
	DEFM	'Key <ENTER> to exit back to opsystem:'
	DEFB	_ETX
;
;	sign on header message
;
HELLO	DEFB	_HOME		;home cursor
	DEFB	_EREOF		;clear screen
	DEFM	'        '
	IF	@COLS.EQ.80
	DEFM	'        '
	ENDIF
	DEFM	'DISKMAN '
	VERSION
	DEFM	' - Diskette Manager - '
	DEFM	'by Kim Watt'
	DEFB	_CR
	DEFM	'          '
	DEFM	'Copyright (C) 1983 - '
	DEFM	'Breeze Computing, Inc.'
	DEFB	_CR
	DC	@COLS,'*'
	DEFB	_CR
	IF	@COLS.EQ.80
	DEFB	_CR
	DEFB	_CR
	DC	@COLS,'*'
	DEFB	_CR
	ENDIF
	DEFB	_ETX
;
FILEMSG	DEFB	_STX
	DEFB	03,00
FILEMST	DEFM	'.Index: '
FILEMS0	DEFM	'................................'
	DEFM	'   Created: '
FILEMS1	DEFM	'../../..'
	DEFB	_CR
	DEFM	'Disks: '
FILEMS2	DEFM	'...../'
FILEMS3	DEFM	'.....   Files: '
FILEMS4	DEFM	'........   Filesize: '
FILEMS5	DEFM	'.........'
FILEMSD	DEFM	'..k'
	DEFB	_STX
	DEFB	@VID,000
	DEFB	_ETX
;
HEADER	DEFB	05H,0EH,'DISKMAN by BCI'
HEADER1	DEFB	1FH,0EH,'diskman..@....'
;
;	error messages for wrong computer/OS version
;
ERRCOD	EQU	$
;
	IF	LDOS1
	DEFM	'Run Under Mod I LDOS Only!'
	DEFB	_ETX
	ENDIF
;
	IF	LDOS3
	DEFM	'Run Under Mod III LDOS Only!'
	DEFB	_ETX
	ENDIF
;
	IF	LDOS2
	DEFM	'Run Under Mod II LDOS Only!'
	DEFB	_ETX
	ENDIF
;
	IF	LDOS4
	DEFM	'Run Under Mod IV LDOS Only!'
	DEFB	_ETX
	ENDIF
;
	IF	MDOS1
	DEFM	'Run Under Mod I MultiDOS Only!'
	DEFB	_ETX
	ENDIF
;
	IF	MDOS3
	DEFM	'Run Under Mod III MultiDOS Only!'
	DEFB	_ETX
	ENDIF
;
