DIALER ;DIALER - Dave McGlumphy 4429 Paula Ln
 ;Chattanooga, Tennessee 37415   03/26/84
 ;MCI# 181-7759
 ;This program has model III defaults but also runs on a
 ;model 1 without changes.  I don't know about model IV
 ;It controls the "REMOTE" plug of the cassette cable
 ;Use that plug to control a normally-closed relay which
 ;is in series with the red or green wire of the phone
 ;line to achieve pulse dialing.  If it dials too fast
 ;for your phone system, increase the pause duration
 ;at the two places in the code that say "WITHIN DIGIT"
 	ORG	7000H
 BRKROW	EQU	3840H		;KEYBOARD ROW WITH BREAK
 BYTOUT	EQU	33AH		;DISPLAY SINGLE BYTE
 CKKEY	EQU	2BH		;CHECK FOR KEY-PRESS
 CLS	EQU	1C9H		;CLEAR SCREEN
 CURSOR	EQU	4020H		;CURSOR POSITION LSB
 DODOS	EQU	4405H		;EXIT & DO DOS COMMAND
 DOS	EQU	402DH		;DOS EXIT
 DSPLY	EQU	4467H		;DISPLAY MSG ON SCREEN
 LBUFPT	EQU	40A7H		;LINE INPUT BUFFER PTR
 LIPT	EQU	361H		;BASIC LINE INPUT RTN
 PAUSE	EQU	60H		;(BC) DETERMINES DURATION
 PORTF1	EQU	403DH		;MODEL 1 CASS PORT FLAG
 PORTF3	EQU	4210H		;MODEL III CASS PORT FLAG
 START	EQU	$
 	LD	SP,41FEH	;SET STACK POINTER
 	LD	HL,41A6H	;PLUG THE DISK BASIC
 	LD	B,15H		; LINKS FROM 41A6H
 BASLP	LD	(HL),0C9H	; TO 41E2H
 	INC	HL
 	INC	HL
 	INC	HL
 	DJNZ	BASLP		; WITH RETURNS
 	LD	A,(54H)		;CHECK MODEL 1/III
 	DEC	A		;Z IF MODEL 1
 	CALL	Z,MODEL1	;INITIALIZE FOR MODEL 1
 	LD	HL,LBUFPT	;SET UP THE
 	LD	(HL),0CAH	; LINE
 	INC	HL		; INPUT
 	LD	(HL),64H	; BUFFER
 MENU	EQU	$		;DISPLAY THE OPTIONS
 	LD	HL,SCREEN	;PT AT MENU SCREEN
 	CALL	DSPLY		;PRINT IT
 MENGET	EQU	$		;WHAT FUNCTION?
 	CALL	GETKEY		;GET UPPERCASE REQUEST
 	CP	'A'
 	JR	Z,ATC		;YES. PLAY AIR TRAFFIC
 	CP	'B'		;B?
 	JR	Z,BASIC		;BRING UP BASIC
 	CP	'C'		;C?
 	JR	Z,MODM80	;BRING UP MODEM80/CMD
 	CP	'D'		;D?
 	JR	Z,DIL68M	;YES. CALL 6800 BOARD
 	CP	'E'		;E?
 	JR	Z,GETPHN	;YES. GET KEYED PHONE#
 	CP	'F'		;F?
 	JR	Z,DILCRB	;YES. CALL CRABAPPLE
 	CP	'G'		;G?
 	JR	Z,DILMCI	;YES. CALL MCI
 	CP	'H'		;H?
 	JR	Z,DILDCS	;YES. CALL CHRIS SMITH
 	CP	'I'
 	JR	Z,DILWSM	;CALL BUTCH
 	CP	'J'
 	JR	Z,DILPET	;CALL PETE
 	CP	'K'
 	JR	Z,BOOT		;A HALT INSTRUCTION
 	CP	'L'
 	JR	Z,DILWOM	;DIAL WOMACK'S BBS
 	CP	'M'
 	JR	Z,HNG		;HANG UP
 	CP	'N'
 	JR	Z,PIC		;PICK UP THE PHONE
 MENUXT	EQU	$		;EXIT FROM MENU FUNCTION
 	JR	MENGET		;GO TO GET NEXT FUNCTION
 ATC	LD	HL,ATCPGM	;POINT AT ATC COMMAND
 	JP	DODOS		;GO DO IT
 BASIC	LD	HL,BASPGM
 	JP	DODOS		;GO INTO BASIC
 MODM80	LD	HL,MODPGM
 	JP	DODOS		;EXECUTE MODEM80/CMD
 DIL68M	LD	HL,M68PHN
 	CALL	DIAL		;DIAL 68MICRO JOURNAL
 	JR	MENUXT		;START OVER
 GETPHN	EQU	$		;GET PHONE# FROM KEYBOARD
 	LD	HL,NBRMSG	;POINT TO NUMBER? MSG
 	CALL	DSPLY		;PRINT IT
 	LD	HL,(LBUFPT)	;POINT TO INPUT BUFFER
 	PUSH	HL		;SAVE IT
 	CALL	LIPT		;GET THE NUMBER
 	POP	HL		;POINT AT PHONE #
 	CALL	DIAL		;DIAL IT
 	CALL	GETKEY		;PAUSE FOR A KEYPRESS
 	JR	MENUXT		;START OVER
 DILCRB	LD	HL,CRBPHN	;POINT TO CRABAPPLE PHONE
 	CALL	DIAL		;DIAL IT
 	JR	MENUXT		;START OVER
 DILMCI	LD	HL,MCIPHN	;POINT TO MCI PHONE#
 	CALL	DIAL		;DIAL IT
 	JR	MENUXT		;START OVER
 DILDCS	LD	HL,DCSPHN	;POINT AT CHRIS' PHONE#
 	CALL	DIAL		;DIAL IT
 	JR	MENUXT		;START OVER
 DILWSM	LD	HL,WSMPHN	;POINT AT BUTCH'S PHONE
 	CALL	DIAL		;DIAL IT
 	JR	MENUXT		;START OVER
 DILPET	LD	HL,PETPHN	;POINT AT PETE'S PHONE#
 	CALL	DIAL		;DIAL IT
 	JR	MENUXT		;START OVER
 BOOT	HALT			;CAUSES BOOT
 DILWOM	LD	HL,WOMPHN	;POINT AT WOMACK'S PHN
 	CALL	DIAL		;DIAL IT
 	JR	MENUXT		;START OVER
 HNG	CALL	HANGUP		;HANG UP THE PHONE
 	JR	MENUXT		;START OVER
 PIC	CALL	PICKUP		;PICK UP THE PHONE
 	JR	MENUXT		;START OVER
 DIAL	EQU	$		;HL POINTS TO PHONE#
 	PUSH	HL		;SAVE IT
 	CALL	HANGUP		;HANGUP THE PHONE
 	LD	BC,0		;DO A LONG
 	CALL	PAUSE		; PAUSE
 	CALL	PICKUP		;PICK IT UP. (DIALTONE)
 	LD	BC,0		;DO A LONG
 	CALL	PAUSE		; PAUSE
 	POP	HL		;RESTORE PTR TO PHONE#
 	DEC	HL		;POINT TO BYTE BEFORE
 	PUSH	HL		; PHONE# & SAVE IT
 GETDIG	EQU	$		;GET PHONE DIGIT
 	CALL	CKBRK		;BREAK EXITS TO DOS
 	POP	HL		;RESTORE PHONE# PTR
 	INC	HL		;POINT TO NEXT DIGIT
 	PUSH	HL		;SAVE PHN# PTR
 	LD	A,(HL)		;PUT IN A
 	CP	0		;END?
 	JR	Z,EXIT		;YES
 	CP	13		;C/R?
 	JR	Z,EXIT		;YES
 	CP	30H		;< 0 ?
 	JP	M,GETDIG	;YES
 	CP	39H+1		;> 9 ?
 	JP	P,GETDIG	;YES
 	PUSH	AF		;SAVE A
 	CALL	BYTOUT		;PRINT IT
 	POP	AF		;RESTORE IT
 	SUB	30H		;CHG ASCII# TO HEX#
 	CP	0		;ZERO?
 	JR	NZ,HAVDIG	;NO
 	ADD	A,10
 HAVDIG	EQU	$		;HAVE DIGIT TO DIAL
 	LD	(PULSCT),A	;SAVE IT
 	CALL	DIGIT		;DIAL THE DIGIT
 	LD	BC,25000	;PAUSE BETWEEN
 	CALL	PAUSE		; DIGITS
 	JR	GETDIG		;DO NEXT DIGIT
 DIGIT	EQU	$
 	LD	A,(PULSCT)	;# PULSES LEFT
 	CP	0		;DONE YET?
 	RET	Z		;YES. GOTO NEXT DIGIT
 	DEC	A		;SUBTRACT 1 &
 	LD	(PULSCT),A	; SAVE IT
 	LD	A,(PORT)	;PUT CASSETTE PORT #
 	LD	C,A		; IN C
 	LD	A,(MODEL)	;MODEL 1/III?
 	CP	1		;1?
 	JR	Z,DIGM1		;YES
 	LD	A,(PORTF3)	;GET PORT SETTINGS
 	JR	DIGXOR		;TURN OFF CASSETTE
 DIGM1	LD	A,(PORTF1)
 DIGXOR	EQU	$		;RESET PROPER MODEL
 	LD	HL,CASBIT	; CASSETTE BIT
 	XOR	(HL)		;TURN OFF
 	OUT	(C),A		; CASSETTE MOTOR
 	LD	BC,2200		;PUT DURATION IN BC
 	CALL	PAUSE		;WITHIN DIGIT
 	LD	A,(PORT)	;WHICH PORT TO CHANGE
 	LD	C,A		;PUT IT IN C
 	LD	A,(MODEL)	;MODEL 1/III?
 	CP	1		;1
 	JR	Z,DIGM1A
 	LD	A,(PORTF3)	;MODEL III PORT FLAGS
 	JR	DIGAND		;TO TURN ON CASSETTE
 DIGM1A	LD	A,(PORTF1)	;MODEL 1 CASSETTE FLAGS
 DIGAND	LD	HL,CASBIT	;MODEL CASS MTR BIT
 	AND	(HL)		; TO TURN IT ON
 	OUT	(C),A
 	LD	BC,2200		;PUT DURATION IN BC
 	CALL	PAUSE		;WITHIN DIGIT
 	JR	DIGIT
 EXIT	EQU	$		;HOUSEKEEP & EXIT
 	POP	HL
 	RET
 MODEL1	LD	A,0FFH		;LOAD PORT WITH
 	LD	(PORT),A	;MODEL 1 ADDRESS
 	LD	HL,MODEL	;PT TO MODEL BYTE
 	LD	(HL),1		;INDICATE MODEL1
 	LD	HL,CASBIT	;PT TO CASBIT
 	LD	(HL),4		;PUT 4 IN IT
 	LD	HL,14308	;SELECT CASSETTE
 	LD	(HL),1		; #2
 	RET
 HANGUP	EQU	$		;HANG UP THE PHONE
 	LD	A,(PORT)	;PUT CASSETTE PORT#
 	LD	C,A		;INTO C
 	LD	A,(MODEL)	;WHICH 'PUTER?
 	CP	1		;MODEL 1?
 	JR	Z,HANG1		;YES
 	LD	A,(PORTF3)	;GET CASS PORT FLAGS
 	JR	HANXOR		;GO TURN OFF
 HANG1	LD	A,(PORTF1)	;GET MOD1 CASS PORT FLAGS
 HANXOR	LD	HL,CASBIT	;MODEL CASS MTR BIT
 	XOR	(HL)		; TO TURN OFF
 	OUT	(C),A		;TURN OFF MOTOR
 	RET			;FROM HANG-UP
 PICKUP	EQU	$		;PICK UP THE PHONE
 	LD	A,(PORT)	;PUT CASSETTE PORT#
 	LD	C,A		;INTO C
 	LD	A,(MODEL)	;WHICH 'PUTER?
 	CP	1		;MODEL 1?
 	JR	Z,PICK1		;YES
 	LD	A,(PORTF3)	;GET CASS PORT FLAGS
 	JR	PICAND		;GO TURN ON
 PICK1	LD	A,(PORTF1)	;GET MOD1 CASS PORT FLAGS
 PICAND	LD	HL,CASBIT	;MODEL CASS MTR BIT
 	AND	(HL)		; TO TURN ON
 	OUT	(C),A		;TURN ON MOTOR
 	RET			;FROM PICKUP
 GETKEY	CALL	CKBRK		;<BREAK> EXITS TO DOS
 	LD	A,0		;CLEAR KEY BUFFER
 	CALL	CKKEY		;KEY PRESSED?
 	OR	A		;CONDITION THE FLAGS
 	JR	Z,GETKEY	;NO KEY PRESSED
 	PUSH	AF		;SAVE A
 	LD	IX,CURSOR	;SET UP PRINT@ POSITION
 	LD	A,58H		; AT
 	LD	(IX),A		; END
 	LD	A,3FH		; OF
 	LD	(IX+1),A	; MENU
 	LD	A,31		;ERASE EOF
 	CALL	BYTOUT		;DO IT
 	LD	A,14		;TURN CURSOR
 	CALL	BYTOUT		; ON
 	POP	AF		;GET A AGAIN
 	PUSH	AF		;SAVE IT AGAIN
 	CALL	BYTOUT		;PRINT IT
 	POP	AF		;RESTORE A
 	CP	'Z'+1		;LOWERCASE?
 	RET	M		;NO
 	SUB	20H		;MAKE IT UPPERCASE
 	RET			;WITH KEY IN A
 CKBRK	PUSH	AF		;SAVE A
 	LD	A,(BRKROW)	;BREAK KEY
 	AND	4		; PRESSED?
 	JP	NZ,DOS		;YES
 	POP	AF		;RESTORE A
 	RET			;NO
 NBRMSG	DEFB	8		;BACKSPACE CHARACTER
 	DEFM	'NUMBER?	'
 	DEFB	3		;END LINE WITH NO C/R
 SCREEN	DEFB	1CH		;HOME CURSOR
 	DEFB	1FH		;EREOF (CLEAR SCREEN)
 	DEFM	'A.	ATC				(<BREAK>	EXITS	'
 	DEFM	'TO	DOS.)
 	DEFB	10
 	DEFM	'B.	BASIC'
 	DEFB	10
 	DEFM	'C.	MODEM80'
 	DEFB	10
 	DEFM	'D.	68MICRO	JOURNAL....	'
 M68PHN	DEFM	'842-6809'
 	DEFB	0
 	DEFB	10
 	DEFM	'E.	ENTER	A	NUMBER	TO	DIAL'
 	DEFB	10
 	DEFM	'F.	CRABAPPLE..........	'
 CRBPHN	DEFM	'875-6035'
 	DEFB	0
 	DEFB	10
 	DEFM	'G.	MCI................	'
 MCIPHN	DEFM	'1-800-323-7751'
 	DEFB	0
 	DEFB	10
 	DEFM	'H.	CHRIS	SMITH........	'
 DCSPHN	DEFM	'899-5377'
 	DEFB	0
 	DEFB	10
 	DEFM	'I.	BUTCH..............	'
 WSMPHN	DEFM	'1-614-695-3056'
 	DEFB	0
 	DEFB	10
 	DEFM	'J.	PETE...............	'
 PETPHN	DEFM	'870-1324'
 	DEFB	0
 	DEFB	10
 	DEFM	'K.	BOOT	THE	SYSTEM'
 	DEFB	10
 	DEFM	'L.	WOMACK	BBS.........	'
 WOMPHN	DEFM	'891-0136'
 	DEFB	0
 	DEFB	10
 	DEFM	'M.	HANG	UP	THE	PHONE'
 	DEFB	10
 	DEFM	'N.	PICK	UP	THE	PHONE		'
 	DEFB	03
 ATCPGM	DEFM	'ATC'
 	DEFB	13
 BASPGM	DEFM	'BASIC'
 	DEFB	13
 MODPGM	DEFM	'MODEM80'
 	DEFB	13
 CASBIT	DEFB	2		;MIII CASSETTE MTR BIT
 MODEL	DEFB	3		;MIII (1=MODEL 1)
 PORT1	DEFB	0FFH		;M1 CASSETTE PORT
 PORT	DEFB	03CH		;MIII CASSETTE PORT
 PULSCT	DEFB	0		;PULSE COUNT
 	END	START
