DDSD1  ;
 ;************************************************
 ;*						*
 ;*	   ADR for NEWDOS-80 Version 1		*
 ;*						*
 ;*         	  TRS-80 Model I		*
 ;*						*
 ;*	 	        by			*
 ;*						*
 ;*		 Allan J. Domuret		*
 ;*						*
 ;*		  (916) 967-7331		*
 ;*						*
 ;*		     12/12/81			*
 ;*						*
 ;************************************************
 ;
 ;
 ;This segment sets up the ADR PDRIVE code blocks.
 ; Original PDRIVE settings are left unchanged except
 ; for those patches that affect DD/SD operation.
 ;
 ;If a drive was originally PDRIVE'd as SD by the user,
 ; it is assumed that TI=CK for DD operation for that
 ; drive.
 ;
 	ORG	5200H
 ;
 START	LD	HL,MATH		;Math patch
 	LD	DE,4080H
 	LD	BC,0EH
 	DI
 	LDIR
 ;
 	LD	IX,4371H
 	LD	IY,DR0DD	;ADR Buffer
 ;
 	LD	HL,4371H	;Move DOS PDRIVE codes
 	LD	DE,DR0DD
 	LD	BC,0028H	;40 BYTES = 4 DRIVES
 	PUSH	HL		; to DDSD areas
 	PUSH	BC
 	LDIR			;DD block
 	POP	BC
 	POP	HL
 	LDIR			;SD block
 ;
 ;If original PDRIVE was for SD, convert SD parameters
 ; to DD. SD track count is multiplied by 1.8 to get
 ; number of lumps as required by N82.
 ;
 	LD	A,(439FH)	;# Drives in system
 	LD	B,A		;Set counter
 MAKDBL	PUSH	BC
 	BIT	0,(IY+07)	;Ck if already DD
 	JR	NZ,SKIP		;Already DD if NZ
 	LD	H,00
 	LD	L,(IY+03)	;TRUE TRACK COUNT
 	LD	DE,0008		;MULT BY 8/10 DECIMAL
 	CALL	0BF2H		;MULT IN ROM
 	PUSH	HL
 	POP	DE		;HL TO DE
 	LD	HL,000AH	;DIVIDE BY 10 DECIMAL
 	CALL	2490H		;DIVIDE IN ROM
 	CALL	0A8AH		;CONVERT (CINT)
 	XOR	A
 	LD	A,L
 	ADD	A,(IY+03)
 	LD	(IY+01),A	;OFFSET LUMPS
 ;
 	SET	4,(IY+02)	;Make DD
 	RES	2,(IY+02)	;Undo SD
 ;
 	LD	(IY+04),12H	;12H SECTORS/TRK
 ;
 	SET	0,(IY+07)	;Set DD code
 ;
 SKIP	POP	BC
 	XOR	A
 	LD	DE,000AH
 	ADD	IY,DE		;Point to next block
 	DJNZ	MAKDBL
 ;
 	LD	IY,DR0SD
 	LD	A,(439FH)	;Drives in system
 	LD	B,A		;Set counter
 	LD	DE,000AH	;Pointer bumper
 MAKSGL	BIT	0,(IY+07)
 	JR	Z,SKPSGL	;Skip if already SD
 	LD	A,(IY+03)	;TRUE TRACKS
 	LD	(IY+01),A	;SAME WHEN SD
 	SET	2,(IY+02)	;Set SD
 	RES	4,(IY+02)	;Undo DD
 	RES	6,(IY+02)	;Ditto
 	LD	(IY+04),0AH	;0AH SECTORS/TRK
 	RES	0,(IY+07)	;Set SD code
 	RES	1,(IY+07)	;No flip trk zero in SD
 	LD	(IY+09),02	;2 for DDGA=2, SD only
 SKPSGL	ADD	IY,DE		;Bump pointer
 	DJNZ	MAKSGL
 ;
 ;Apply relocate patches
 ;
 	LD	BC,HI-OFFSET+01
 	LD	DE,(4049H)
 	LD	HL,HI
 	LDDR
 	LD	(4049H),DE
 	INC	DE
 	LD	(490DH),DE
 DIR	LD	A,0C3H		;Insert DOS patch
 	LD	(490CH),A
 ;
 ;Insert label addresses.
 	LD	HL,0011H
 	CALL	REPLAC
 	LD	HL,0025H
 	CALL	REPLAC
 	LD	HL,0047H
 	CALL	REPLAC
 	LD	HL,0052H
 	CALL	REPLAC
 	LD	HL,007DH
 	CALL	REPLAC
 	LD	HL,0082H
 	CALL	REPLAC
 	LD	HL,00AAH
 	CALL	REPLAC
 ;
 	LD	HL,(4049H)
 	INC	HL
 	LD	DE,DDSD-OFFSET
 	ADD	HL,DE
 	LD	(473DH),HL	;Patch DOS; DE=>DDSD
 	LD	A,0C2H		;Z80 code for JP NZ
 	LD	(473CH),A
 	EI
 	JR	DSPLY
 ;
 ;
 REPLAC	ADD	HL,DE
 	LD	C,(HL)
 	INC	HL
 	LD	B,(HL)
 	DEC	HL
 	PUSH	DE
 	EX	DE,HL
 	ADD	HL,BC
 	EX	DE,HL
 	LD	(HL),E
 	INC	HL
 	LD	(HL),D
 	POP	DE
 	RET
 ;
 ;End of relocate
 ;
 DSPLY	CALL	01C9H
 	LD	HL,3C40H	;Set cursor
 	LD	(4020H),HL
 	LD	HL,TEXT
 	CALL	4467H
 ;
 	JP	402DH
 ;
 ;
 TEXT	DB	'DDSD/CMD -- Double/Single Density -- Version I.0 -- Feb. 1982',0AH
 	DB	'Automatic PDRIVE Utility For Use With NEWDOS-80 Version 2 (c)',0AH,0AH
 	DB	'  Distributed by: The Alternate Source, Lansing, Michigan.',0AH
 	DB	'                '	;18 blanks
 	DB	'Written by Allan J. Domuret',0AH,0AH,0AH
 ;
 	DB	'                           '	;28x20H
 	DB	'Model I',0AH
 	DB	'     '			;5 blanks
 	DB	'      Automatic Density Recognition Enabled ',0AH,0AH,0DH
 ;
 ;
 MATH	DB	0D6H,00,6FH,7CH,0DEH,00,67H
 	DB	78H,0DEH,00,47H,3EH,00,0C9H
 ;
 ;********************************************
******
 ;
 ;Next is the actual DDSD working code which is to
 ; be automatically relocated to HIMEM and protected.
 ;
 ;	ORG	0001H
 OFFSET	EQU	$
 ;
 	PUSH	AF
 	PUSH	BC
 	PUSH	DE
 	PUSH	HL
 	EXX
 	EX	AF,AF'
 	POP	HL
 	POP	DE
 	POP	BC
 	POP	AF
 ;
 	CALL	48FDH
 	JP	Z,491CH
 ;
 FLIP0	CALL	FLIPTRK-OFFSET	;Fliptrack
 	EXX
 	EX	AF,AF'
 	CALL	48FDH
 	JP	Z,491CH
 ;
 	LD	DE,0000
 	CALL	4630H
 	JP	Z,4917H
 ;
 FLIP1	CALL	FLIPTRK-OFFSET	;Fliptrack
 	LD	DE,0000
 	CALL	4630H
 	JP	4917H		;Back to DOS
 ;
 ;
 FLIPTRK	PUSH	AF
 	PUSH	BC
 	PUSH	DE
 	PUSH	HL
 	PUSH	IY
 	LD	IY,(4399H)
 	LD	A,(IY+07)
 	BIT	0,A		;If already SD, skip it
 	JR	Z,SKIPIT
 	XOR	02
 	LD	(IY+07),A
 SKIPIT	CALL	ZAP-OFFSET		;CALL ZAP
 	POP	IY
 	POP	HL
 	POP	DE
 	POP	BC
 	POP	AF
 	RET
 ;
 	NOP
 ;
 ;The next CALL allows a CALL to DDSDX from another
 ; program, etc., to change DCT and DD/SD
 ;
 DDSD	CALL	DDSDX-OFFSET
 	JP	4660H
 ;
 DDSDX	PUSH	BC
 	PUSH	DE
 	PUSH	HL
 	PUSH	IX
 ;
 	LD	IX,(4399H)	;Points to crnt DCT block
 	LD	A,(IX+07)	;SD OR DD?
 	OR	0FEH
 	XOR	01		;FLIP DD - SD
 	PUSH	AF		;SAVE DD OR SD (FF OR FE)
 	DI
 	LD	(37ECH),A
 	LD	A,0D0H
 	LD	(37ECH),A
 	CALL	47E3H		;Delay
 	PUSH	BC
 	CALL	4745H		;Restore
 	POP	BC
 	POP	AF
 	BIT	0,A		;IF = 0, MAKE SD
 CONVDD	LD	HL,DR0DD-OFFSET	;DD DCT pointer
 	JR	NZ,ADR		;Make DD
 CONVSD	LD	HL,DR0SD-OFFSET	;SD DCT pointer
 ;
 ;Adjust DCT pointer for current drive
 ;
 ;
 ADR	LD	C,0AH		;Count 10 bytes
 	LD	DE,0000
 	LD	A,(4308H)	;Current drive
 	OR	A
 	JR	Z,DRV0
 	LD	B,A		;# Drives (0 - 3)
 BUMP	LD	A,C		;C=0AH (10 count)
 	ADD	A,E
 	LD	E,A		;No carries; HL=42 alwys
 	DJNZ	BUMP
 	ADD	HL,DE		;Set HL as DCT pointer
 ;
 ;HL now points to current DCT block used by DDSD/CMD
 ;
 ;Change NEWDOS-82's PDRIVE DCTs in RAM
 ;
 DRV0	LD	BC,000AH	;Move 10 bytes
 	LD	DE,(4399H)	;Current DCT pointer
 	PUSH	HL		;save pointer
 	LDIR
 	POP	HL		;Reset pointer
 	LD	DE,430AH
 	LD	BC,0008H	;Move 8 bytes
 	LDIR
 ;
 	CALL	ZAP-OFFSET	;Ck for ZAP & DIRCK
 ;
 	EI
 	POP	IX		;RESTORE REGS
 	POP	HL
 	POP	DE
 	POP	BC
 	RET
 ;
 ;SUPERZAP working?
 ;
 ZAP	LD	A,(5EF9H)	;IF 4436H, ASSUME ZAP
 	CP	36H
 	JR	NZ,DIRCK
 	LD	A,(5EFAH)
 	CP	44H
 	JR	NZ,DIRCK
 	LD	A,(430EH)	;SPT
 	LD	(549BH),A	;Patch ZAP
 	RET
 ;
 ;
 ;DIRCHECK working?
 ;
 DIRCK	LD	A,(5827H)
 	CP	36H
 	RET	NZ
 	LD	A,(5828H)
 	CP	44H
 	RET	NZ
 	LD	HL,(4399H)	;Current DCT pointer
 	LD	DE,5260H	;DCT location for DRCK
 	LD	BC,0008H
 	LDIR
 ;
 	RET
 ;
 	NOP
 SRCEND	DB	0ADH
 ;
 ;
 ;DR0DD TO DR3DD are DD PDRIVE code table values.
 ;
 DR0DD	DB	00,00,00,00,00,00,00,00,00,00
 DR1DD	DB	00,00,00,00,00,00,00,00,00,00
 DR2DD	DB	00,00,00,00,00,00,00,00,00,00
 DR3DD	DB	00,00,00,00,00,00,00,00,00,00
 ;
 ;DR0SD to DR3SD are SD PDRIVE code table values.
 ;
 DR0SD	DB	00,00,00,00,00,00,00,00,00,00
 DR1SD	DB	00,00,00,00,00,00,00,00,00,00
 DR2SD	DB	00,00,00,00,00,00,00,00,00,00
 DR3SD	DB	00,00,00,00,00,00,00,00,00,00
 ;
 HI	DB	0ADH
 ;
 	END	START
de table values.
 ;
 DR0SD	DB	00,00,00,00,00,00,00,00,00,00
 DR1SD	DB	00,00,00,00,00,00,00,00,00,00
 DR2S