	PRINT	NOMAC,SHORT
	TITLE	'CLEANER/80 MODEL III FREEWARE VERSION'
	OBJ	'CLEANER3/CMD'
;**************************************************************
;*							      *
;*	CLEANER/80 Disk Drive Cleaning and Timing Program     *
;*							      *
;*	Copyright (c) 1985, 1986 by			      *
;*							      *
;*	J. Russell Jones				      *
;*	709 Litchfield					      *
;*	Wichta KS 67203					      *
;*							      *
;*	This program is placed in the public domain by the    *
;*	author. Sale of this program is strictly prohibited.  *
;*							      *
;*	If you find this program useful, any comments (or     *
;*	donations) would be greatly appreciated.	      *
;*							      *
;*	This code is in Radio Shack Model III ALDS format.    *
;*							      *
;*							      *
;**************************************************************
;
;	ROM routines
;
@CLS:	EQU	01C9H		;clear screen routine
@KBW:	EQU	0049H		;wait for a keyboard character
@KBD:	EQU	002BH		;scan for a keyboard character
@EXIT	EQU	402DH		;exit to DOS
@DELAY:	EQU	0060H		;delay routine
@LPRT:	EQU	003BH		;send byte to printer
;
@VIDEO	EQU	3C00H		;start of memory mapped video display
CMD	EQU	0F0H		;FDC command port
TRK	EQU	0F1H		;FDC track register
DAT	EQU	0F3H		;FDC data register
SEL	EQU	0F4H		;FDC select port
COUNT	DEFL	12		;initial cursor offset for speed timer
HITRK	EQU	'4'		;if you want to allow for 80
				; track drives, change this to '8'
;
;
;	CLRLN macro clears a line of the video screen.
;	The parameter is the actual "print @" start of the line
;	to clear. The first and last characters will not be
;	cleared to leave the border.
;
CLRLN	MACRO	#1
	LD	HL,@VIDEO+#1
	INC	HL
	LD	(HL),32
	INC	HL
	LD	DE,HL
	DEC	HL
	LD	BC,61
	LDIR
	ENDM
;
;
;	PRTLN macro uses the SCRPRT subroutine to print a
;	line on the display. The first parameter is the 
;	"PRINT @" location to start, followed by the
;	label of the message to print
;
PRTLN	MACRO	#1,#2
	LD	DE,@VIDEO+#1
	LD	HL,#2
	CALL	SCRPRT
	ENDM
;
;	DATA macro builds the drive speed timer table
;
DATA	MACRO	#1
	DW	#1
	DB	COUNT
COUNT	DEFL	COUNT+1
	ENDM
;
;	LPRT macro calls LPRINT to print a line
;	on the line printer
;
LPRT	MACRO	#1
	LD	HL,#1
	CALL	LPRINT
	ENDM
;
;
;
;
	PSECT	5200H		;beginning of program - relocatable
;
;
;	Main menu screen
;	
;	Each line is 64 bytes long
;
MMENU	DEFM	''
	DEFM	'                            '
	DEFM	'                              '
	DEFM	'                               '
	DEFM	'                         Version  2.0                         '
	DEFM	''
	DEFM	'                          MAIN MENU                           '
	DEFM	'                                                              '
	DEFM	'                     1. Clean disk drives                     '
	DEFM	'                     2. Print usage chart                     '
	DEFM	'                     3. Check drive speed                     '
	DEFM	'                                                              '
	DEFM	'                     0. Exit to DOS                           '
	DEFM	'                                                              '
	DEFM	''
	DEFM	' Copyright (C) 1985,86  -  J. Russell Jones  -  Wichita, Kansas '
;
CHOICE	DEFB	0		;save main menu choice
;
;
;
START	EQU	$
MAIN	LD	DE,@VIDEO	;point to start of screen
	LD	HL,MMENU	;point to start of menu text
	LD	BC,1024		;number of bytes to move
	LDIR			;display the screen
MN10	CALL	@KBW		;get user's choice
	LD	(CHOICE),A	;save it
	CP	'4'		;is char < '4'
	JR	NC,MN10		;if not, invalid - go back
	CP	'0'		;is char < '0'
	JR	C,MN10		;if so, invalid - go back
	JP	Z,EXIT		;if char = '0' go to exit routine
	LD	A,(CHOICE)	;recall choice
	CP	'1'		;if choice = '1'
	CALL	Z,CLEAN		;  then perform cleaner routine
	LD	A,(CHOICE)	;recall choice
	CP	'2'		;if choice = '2'
	CALL	Z,CHART		;  then perform chart routine
	LD	A,(CHOICE)	;recall choice
	CP	'3'		;if choice = '3'
	CALL	Z,SPEED		;  then perform speed routine
	JP	MAIN		;loop until user chooses to quit
;
;
;	screen print subroutine
;
;	expects DE to be loaded with the location on the
;	  screen at which to begin printing, and HL to point
;	  to a string that was defined with the DEFT directive.
;
SCRPRT	LD	C,(HL)		;get number of bytes to print
	LD	B,0		;  into BC
	INC	HL		;bump to point to text
	LDIR			;print text
	RET			;return
;
;
;	clear display area of screen subroutine
;
CLS	CLRLN	384
	CLRLN	448
	CLRLN	512
	CLRLN	576
	CLRLN	640
	CLRLN	704
	CLRLN	768
	CLRLN	832
	RET
;
;
;
;	Exit the system
;
EXIT	CALL	CLS		;clear the screen
	PRTLN	465,EX10	;print first exit msg
	PRTLN	536,EX20	;print second exit msg
EXIT10	CALL	@KBW		;get character
	CP	0DH		;is it <ENTER>?
	JR	NZ,EXIT10	;jump if not
	CALL	@CLS		;else clear screen
	JP	@EXIT		;and bug out
;
EX10	DEFT	'Press <ENTER> when system disk'
EX20	DEFT	'is in drive zero'
;
;
SPEED	CALL	CLS		;clear display area
	PRTLN	397,SP010	;print msg
	PRTLN	461,SP020	;print msg
	PRTLN	525,SP030	;print msg
	PRTLN	589,SP040	;print msg
SP01	PRTLN	725,SP050	;print msg
	PRTLN	787,SP060	;print msg
	PRTLN	842,SP070	;print msg
SPSL	CALL	@KBW		;get selection
	CP	0DH		;is char an <ENTER>?
	RET	Z		;if so, return
	CP	'0'		;is char < '0'?
	JR	C,SPSL		;if so, invalid - go back
	CP	'4'		;is char < '4'
	JR	NC,SPSL		;if not, invalid - go back
	PRTLN	386,SP080	;print msg
	PRTLN	450,SP090	;print msg
	PRTLN	514,SP100	;print msg
	LD	HL,@VIDEO+520	;point to screen
	LD	(HL),A		;print drive number to time
	SUB	30H		;convert from ascii to binary
	LD	(SDRV),A	;save drive number
	CALL	CLRMEN		;clear menu portion of screen
	CALL	SPSEL		;select drive
	JR	NC,SP04		;jump if drive is ready
	JR	NZ,SP02		;jump if no diskette
	PRTLN	789,SP110	;print "Drive is not in system"
	JR	SP03		;jump
SP02	PRTLN	789,SP111	;print "Diskette is not in drive"
SP03	PRTLN	845,SP112	;ask for key
	CALL	@KBW		;wait for key
	JP	SPEED		;and return to timer menu
SP04	PRTLN	845,SP112	;print "press to return" msg
SP05	CALL	@KBD		;scan the keyboard
	OR	A		;was a key pressed?
	JP	NZ,SPEED	;jump if key pressed
	CALL	GETSP		;get the new cursor offset
	LD	A,(CUROFF)	;A=old cursor offset
	CP	C		;are cursor offsets the same?
	JR	Z,SP05		;loop if they are
	PUSH	BC		;save new cursor offset
	LD	C,A		;BC=old cursor offset
	LD	HL,@VIDEO+640	;HL=video line pointer
	ADD	HL,BC		;HL=video memory location
	LD	(HL),' '	;erase the indicator
	POP	BC		;restore the new cursor offset
	LD	A,C		;A=new cursor offset
	LD	(CUROFF),A	;save it
	LD	HL,@VIDEO+640	;HL=video line pointer
	ADD	HL,BC		;HL=video memory location
	LD	(HL),255	;display the indicator
	JR	SP05		;loop
;
;
;	select drive for speed timer
;
SPSEL	LD	C,A		;C=drive number
	LD	B,0		;BC=drive number
	LD	HL,SDRVT	;HL=drive select mask table pointer
	ADD	HL,BC		;HL=drive select mask pointer
	LD	A,(HL)		;A=drive select mask
	LD	(SDRVS),A	;save it
SPSEL0	IN	A,(CMD)		;A=drive status
	PUSH	AF		;save it
	LD	A,(SDRVS)	;A=drive select mask
	OUT	(SEL),A		;select drive
	POP	AF		;get the status
	RLCA			;already selected?
	JR	NC,SPSEL1	;jump if it was
	LD	BC,0000H	;BC=delay counter
	CALL	@DELAY		;wait for drive to get up to speed
	JR	SPSEL0		;loop unitl selected
SPSEL1	LD	A,(SDRVS)	;A=drive select mask
	OUT	(SEL),A		;reselect the drive
	LD	A,0D0H		;A=FDC reset command
	OUT	(CMD),A		;reset the FDC
	LD	B,10		;B=delay counter
SPSEL2	DJNZ	SPSEL2		;wait for FDC to react
	LD	BC,2400H	;BC=loop counter
SPSEL3	CALL	SPSEL5		;index hole?
	JR	NZ,SPSEL3	;loop if it is
SPSEL4	CALL	SPSEL5		;index hole?
	JR	Z,SPSEL4	;loop if it isn't
	XOR	A		;flag drive ready
	RET			;and return to caller
SPSEL5	PUSH	AF		;save flags
	DEC	BC		;decrement loop counter
	LD	A,B		;is the loop
	OR	C		; complete?
	JR	NZ,SPSEL6	;jump if it isn't
	POP	AF		;restore flags
	POP	BC		;clean up stack
	SCF			;flag error
	RET			;return
SPSEL6	POP	AF		;clean up the stack
	IN	A,(CMD)		;A=FDC status
	BIT	1,A		;set zero flag for index hole status
	RET			;return
;
;	time drive and figure cusor offset
;
GETSP	DI			;disable interrupts
	LD	HL,0		;HL=time counter
	LD	A,(SDRVS)	;A=select mask
	OUT	(SEL),A		;reselect the drive
	LD	A,0D0H		;A=FDC reset command
	OUT	(CMD),A		;reset the FDC
	LD	B,10		;B=delay counter
GETSP0	DJNZ	GETSP0		;wait for FDC to react
GETSP1	IN	A,(CMD)		;A=FDC status
	BIT	1,A		;index hole?
	JP	NZ,GETSP1	;loop if it is
GETSP2	IN	A,(CMD)		;A=FDC status
	BIT	1,A		;index hole?
	JP	Z,GETSP2	;loop if it isn't
GETSP3	INC	HL		;bump time counter
	IN	A,(CMD)		;A=FDC status
	BIT	1,A		;index hole?
	JP	NZ,GETSP3	;loop if it isn't
GETSP4	INC	HL		;bump time counter
	IN	A,(CMD)		;A=FDC status
	BIT	1,A		;index hole?
	JP	Z,GETSP4	;loop if not
	EI			;enable interrupts
	LD	IX,SPTAB	;IX=speed lookup table pointer
	LD	B,37		;B=number of speed values
GETSP5	LD	E,(IX)		;E=LSB of speed value
	INC	IX		;bump table pointer
	LD	D,(IX)		;DE=speed value
	INC	IX		;bump table pointer
	INC	IX		;bump table pointer
	LD	A,H		;A=MSB of time counter
	CP	D		;compare with speed value
	JR	NZ,GETSP6	;jump if MSB's don't match
	LD	A,L		;A=LSB of time counter
	CP	E		;compare with speed value
GETSP6	JR	NC,GETSP7	;jump if it isn't the correct position
	DJNZ	GETSP5		;else loop till end of table
GETSP7	LD	C,(IX-1)	;C=new video memory offset
	LD	B,0		;BC=new video memory offset
	RET			;return
;
;	subroutine to clear speed menu area
;
CLRMEN	CLRLN	704
	CLRLN	768
	CLRLN	832
	RET
;
;	Speed timer variables, tables and messages
;
SDRV	DEFB	0
CUROFF	DEFB	12
SDRVS	DEFB	0
SDRVT	DEFB	81H,82H,84H,88H
;
SPTAB	DATA	11933
	DATA	11914
	DATA	11895
	DATA	11875
	DATA	11856
	DATA	11837
	DATA	11818
	DATA	11798
	DATA	11779
	DATA	11760
	DATA	11740
	DATA	11721
	DATA	11702
	DATA	11682
	DATA	11663
	DATA	11644
	DATA	11624
	DATA	11605
	DATA	11586
	DATA	11567
	DATA	11547
	DATA	11528
	DATA	11509
	DATA	11489
	DATA	11470
	DATA	11451
	DATA	11431
	DATA	11412
	DATA	11393
	DATA	11373
	DATA	11354
	DATA	11335
	DATA	11315
	DATA	11296
	DATA	11277
	DATA	11258
	DATA	11238
;
SP010	DEFT	'2                 3                 3'
SP020	DEFT	'9                 0                 0'
SP030	DEFT	'1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9'
SP040	DEFT	':.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:'
SP050	DEFT	'Drive Speed Timer Menu'
SP060	DEFT	'Select drive to time (0-3)'
SP070	DEFT	'or press <ENTER> to return to the Main Menu'
SP080	DEFT	'Now'
SP090	DEFT	'timing'
SP100	DEFT	'drive'
SP110	DEFT	'Drive is not in system'
SP111	DEFT	'Diskete is not in drive'
SP112	DEFT	'Press any key to return to Timer Menu'
;
;	Clean disk drives
;
;
;	text for CLEANER/80
;
$M10	DEFT	'Remove disks from drive to clean'
$M11	DEFT	'and press <ENTER>'
$M12	DEFT	'Drive to clean (0-3)? _'
$M13	DEFT	'Track number on cleaning'
$M14	DEFT	'disk to use (00-39)? __'
				;to allow for 80 track drives
				; change this prompt
$M15	DEFT	'Insert cleaning disk in drive'
$M16	DEFT	'Do you wish to clean another drive (Y/N)?'
$M17	DEFT	'Insert system disk in drive 0'
$M18	DEFT	'Seconds left to go __'
;
;	variables for CLEANER/80
;
$TKIN	DEFW	0		;2 byte input buffer
	DEFB	0		; with zero terminator
$TKHEX	DEFB	0		;track number in hex
$DRVNO	DEFB	0		;drive number in ASCII
$DRVSE	DEFB	0		;drive select code
$COUNT	DEFB	0		;30 second counter
$COUNT0	DEFB	0		;ASCII area for counter
$COUNT1	DEFB	0		;
$COUNT2	DEFB	0		;
$COUNT3	DEFB	0		;10's digit
$COUNT4	DEFB	0		;1's digit
$COUNT5	DEFB	0		;
;
;
CLEAN	EQU	$
	CALL	CLS		;clear screen
	PRTLN	527,$M10	;print 'remove disks'
	PRTLN	600,$M11	;print 'and press <ENTER>'
CL010	CALL	@KBD		;get character
	CP	0DH		;is it <ENTER>?
	JR	NZ,CL010	;jump if not
$NXTDR	CALL	CLS		;clear screen
	PRTLN	404,$M12	;print 'Drive to clean?'
$DRVIN	CALL	@KBD		;get kbd char
	LD	HL,$DRVNO	;point to ASCII strg area
	LD	(HL),A		;save drive number
	LD	HL,$DRVSE	;select code storage area
$DR0	CP	'0'		;is it '0'?
	JR	NZ,$DR1		;go if not
	LD	(HL),1		; else store select code
	JR	$DSPDR		; and skip
$DR1	CP	'1'		;is it '1'
	JR	NZ,$DR2		;go if not
	LD	(HL),2		; else store select code
	JR	$DSPDR		; and skip
$DR2	CP	'2'		;is it '2'
	JR	NZ,$DR3		;go if not
	LD	(HL),4		; else store select code
	JR	$DSPDR		; and skip
$DR3	CP	'3'		;is it '3'
	JR	NZ,$DRVIN	;go back - invalid drive number
	LD	(HL),8		; else store select code
$DSPDR	LD	HL,@VIDEO+426	;print @ 426
	LD	(HL),A		;print drive number
;
;	get track number to use
$TRKIN	PRTLN	468,$M13	;print 'track number'
	PRTLN	532,$M14	;print 'to use'
$TKINP	LD	HL,@VIDEO+553	;print two underline
	LD	(HL),95		; characters
	INC	HL		;
	LD	(HL),95		;
$GETTK1	CALL	@KBD		;get 10's digit
	CP	'0'		;is char < '0'?
	JR	C,$GETTK1	;if so, invalid - go back
	CP	HITRK		;is char < highest valid trk?
	JR	NC,$GETTK1	;if not, invalid, go back
	LD	IX,$TKIN	;point to input buffer
	LD	(IX+0),A	;save 10's digit
	LD	HL,@VIDEO+553	; and
	LD	(HL),A		; display it
$GETTK2	CALL	@KBD		;get 1's digit
	CP	'0'		;is char < '0'?
	JR	C,$GETTK2	;if so, invalid - go back
	CP	':'		;is char < ':' ('9' + 1)?
	JR	NC,$GETTK2	;if not, invalid - go back
	LD	(IX+1),A	;save 1's digit
	INC	HL		;bump screen pointer
	LD	(HL),A		;display 1's digit
;
;	convert track number from ASCII to HEX
;
	LD	HL,$TKIN	;point to buffer
	LD	IX,0		;clear result register
$L4	LD	A,(HL)		;get next char
	OR	A		;check for 0H (end)
	JR	Z,$LL		;go if end
	ADD	IX,IX		;result * 2
	PUSH	IX		;save on stack	
	ADD	IX,IX		;result * 4
	ADD	IX,IX		;result * 8
	POP	DE		;get result * 2
	ADD	IX,DE		;result * 10
	SUB	30H		;convert ASCII digit to HEX
	LD	E,A		;now in E
	LD	D,0		;now in DE
	ADD	IX,DE		;merge with previous
	INC	HL		;bump pointer
	JR	$L4		;loop until done
$LL	PUSH	IX		;put track number
	POP	HL		; into HL
	LD	A,L		; then into A
	LD	($TKHEX),A	; then into storage
;
;	insert cleaning disk
;
	PRTLN	657,$M15	;print 'insert cleaning disk'
	PRTLN	727,$M11	;print 'and press <ENTER>'
	CALL	$ENTER		;wait for <ENTER>
;
;	select and restore drive
;
	CALL	$RESTOR		;restore drive
;
;	position head over desired track
;
	XOR	A		;A=0 (current track)
	OUT	(TRK),A		; to track register
	LD	A,($TKHEX)	;get desired track
	OUT	(DAT),A		; to data register
	LD	A,13H		;issue seek at
	OUT	(CMD),A		; at 40 ms rate
	CALL	$DELAY		;wait for FDC to react
	CALL	$BUSY		;wait until FDC is done
;
;	exercise drive for 30 seconds
;
	PRTLN	789,$M18	;print 'seconds left'
	LD	HL,$COUNT	;point to counter reg
	LD	(HL),30		;load with 30 seconds
$WAIT	CALL	$DSPCT		;display counter
	LD	BC,0		;max delay time
	CALL	@DELAY		;delay 1 second
	LD	A,($DRVSE)	;drive select code
	OUT	(0F5H),A	;exercise drive
	DEC	(HL)		;sub 1 from counter
	JR	NZ,$WAIT	;loop till done
;
;	ask if user wants to clean another drive
;
	CALL	CLS		;clear screen
	PRTLN	779,$M16	;prompt for another drive
$LP	CALL	@KBW		;get character
	CP	'Y'		;is it a 'Y'?
	JP	Z,$NXTDR	; then run again
	CP	'N'		;is it a 'N'?
	RET	Z		;then return to main menu
;
;	convert delay counter to ASCII
;
$DSPCT	SAVE	I		;save registers
	LD	A,($COUNT)	;put value into A
	LD	L,A		; then into L
	LD	H,0		; HL=count
	LD	DE,$COUNT0	;put buffer addr into DE
	LD	BC,-10000	;10 to the fourth
	JR	SUBPWR		;find the first digit
BXD010	LD	BC,-1000	;10 to the third
	JR	SUBPWR		;find the second digit
BXD020	LD	BC,-100		;10 to the second
	JR	SUBPWR		;find the third digit
BXD030	LD	BC,-10		;10 to the first
	JR	SUBPWR		;find the 4th digit
BXD040	LD	BC,-1		;10 to the zero
	JR	SUBPWR		;find the 5th digit
BXD050	XOR	A		;zero
	LD	(DE),A		;store null
	LD	DE,@VIDEO+808	;point to screen
	LD	HL,$COUNT3	;point to ASCII counter
	LD	BC,2		;two bytes to display
	LDIR			;display them
	RSTR	I		;restore registers
	RET			;return to caller
;
SUBPWR	LD	A,0FFH		;-1 t0 A
SUB010	INC	A		;bump digit count
	ADD	HL,BC		;subtract power of ten
	JR	C,SUB010	;go if not negative
	OR	A		;clear carry
	SBC	HL,BC		;restore last result
	ADD	A,30H		;convert to ASCII
	LD	(DE),A		;store in buffer
	INC	DE		;point to next slot
	LD	A,C		;get LSB of power
	CP	0F0H		;test for -10000
	JR	Z,BXD010	;go if -10000
	CP	18H		;test for -1000
	JR	Z,BXD020	;go if -1000
	CP	9CH		;test for -100
	JR	Z,BXD030	;go if -100
	CP	0F6H		;test for -10
	JR	Z,BXD040	;go if -10
	JR	BXD050		;must be -1
;
;	wait for enter
;
$ENTER	CALL	@KBW		;get character
	CP	0DH		;is it <ENTER>?
	JR	NZ,$ENTER	;if not, get another
	RET			;else return
;
;	waste time for FDC to react
;
$DELAY	EX	(SP),HL		;
	EX	(SP),HL		;
	EX	(SP),HL		;
	EX	(SP),HL		;
	RET			;return
;
;	select and restore drive
;
$RESTOR	CALL	$BUSY		;make sure FDC not busy
	XOR	A		;A=0 (NMI off code)
	OUT	(0E4H),A	; to FDC
	LD	A,($DRVSE)	;get select code
	OUT	(SEL),A		; to FDC
	LD	A,3		;restore command at
	OUT	(CMD),A		; 40 ms rate to FDC
	CALL	$DELAY		;wait for FDC to react
;
;	make sure FDC is done
;
$BUSY	IN	A,(CMD)		;get FDC status
	RRCA			;shift busy into carry
	RET	NC		;return if not busy
	JR	$BUSY		; else loop
;
;	print a line on the printer
;
LPRINT	LD	A,(HL)		;get print character
	CP	00H		;is it the terminator?
	RET	Z		;return if it is
	CALL	@LPRT		;else send it to the printer
	INC	HL		;bump the pointer
	JR	LPRINT		;loop till done
;
;	text for usage chart
;
C1	DEFT	'Press <ENTER> when printer is ready'
C2	DEFM	'                      CLEANER/80'
	DEFB	0DH
	DEFB	0DH
	DEFB	00H
C3	DEFM	'                    CLEANING DISK'
	DEFB	0DH
	DEFB	00H
C4	DEFM	'                     USAGE CHART'
	DEFB	0DH
	DEFB	0DH
	DEFB	0DH
	DEFB	00H
C5	DEFM	'                    TRACK NUMBER'
	DEFB	0DH
	DEFB	0DH
	DEFB	00H
C6	DEFM	'         0         0         1         1       1'
	DEFB	0DH
	DEFB	00H
C7	DEFM	'         2         2         3         3       3'
	DEFB	0DH
	DEFB	00H
C8	DEFM	'        '
	DEFB	00H
C9	DEFM	'C  N  1 '
	DEFB	00H
C10	DEFM	'L  U    '
	DEFB	00H
C11	DEFM	'E  M  2 '
	DEFB	00H
C12	DEFM	'A  B    '
	DEFB	00H
C13	DEFM	'N  E  3 '
	DEFB	00H
C14	DEFM	'I  R    '
	DEFB	00H
C15	DEFM	'N     4 '
	DEFB	00H
C16	DEFM	'G       '
	DEFB	00H
C17	DEFM	'      5 '
	DEFB	00H
C18	DEFM	'+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+'
	DEFB	0DH
	DEFB	00H
C19	DEFM	': : : : : : : : : : : : : : : : : : : : :'
	DEFB	0DH
	DEFB	00H
C20	DEFM	'         0         5         0         5       9'
	DEFB	0DH
	DEFB	00H
C21	DEFB	0DH
	DEFB	0DH
	DEFB	0DH
	DEFB	0DH
	DEFB	0DH
	DEFB	00H
;
;	print usage chart
;
CHART	CALL	CLS		;clear the screen
	PRTLN	526,C1		;print 'press <ENTER> printer ready'
	CALL	$ENTER		;wait for <ENTER>
	LPRT	C2
	LPRT	C3
	LPRT	C4
	LPRT	C5
	LPRT	C6
	CALL	BODY
	LPRT	C5
	LPRT	C7
	CALL	BODY
	RET
;
BODY	LPRT	C20
	LPRT	C8
	LPRT	C18
	LPRT	C9
	LPRT	C19
	LPRT	C10
	LPRT	C18
	LPRT	C11
	LPRT	C19
	LPRT	C12
	LPRT	C18
	LPRT	C13
	LPRT	C19
	LPRT	C14
	LPRT	C18
	LPRT	C15
	LPRT	C19
	LPRT	C16
	LPRT	C18
	LPRT	C17
	LPRT	C19
	LPRT	C8
	LPRT	C18
	LPRT	C21
	RET
;
	END	START
