TRAK13 ; TRAKCESS Disk I/O, Editing and System Routines.
;
; BY ROXTON BAKER  5/1/81
; VERSION 1.3
;
	ORG	52721		;AS REQUIRED TO MAKE
ZZBEGN	DEFW	START1		;  WRKMEM = DF00H !
	DEFW	START2
	DEFW	START3
	DEFW	START4
	DEFW	START5
	DEFW	START6
	DEFW	START7
	DEFW	START8
	DEFW	START9
	DEFW	PENRAM
	DEFW	FILL
	DEFW	WRKMEM		;*** MUST BE DF00H ! ***
	DEFW	BUF00
	DEFW	HATYPE
	DEFW	STRPLC
	DEFW	PDUMP
	DEFW	ADDSTR
	DEFW	MENU
	DEFW	TRKLEN
	DEFW	SPARE
	DEFW	STRT1A
	DEFW	SPARE
;
STRTUP	EQU	$
	LD	HL,ZZBEGN
	DEC	HL
	LD	(4049H),HL	;Set Memory Size.
	CALL	CLS
	LD	HL,3D00H
	LD	(CURPOS),HL
	LD	HL,CMSG
	CALL	OUTSTR		;Display message:
	JP	402DH
;
CMSG	DEFM	'TRAKCESS  (C) 1980 by ROXTON BAKER'
	DEFB	0DH
	DEFM	'Box 8272, APO San Francisco 96555'
	DEFW	0D0DH
	DEFM	'Go into Basic without setting Memory Size.'
	DEFB	0DH
	DEFM	'Then:  RUN "TRAKCESS"'
	DEFW	0D0DH
	DEFB	3
;
SPARE	EQU	0
DELAY	EQU	0060H
GETARG	EQU	0A7FH
CMHLDE	EQU	1C90H
BASIC	EQU	0A9AH
DRVSEL	EQU	37E0H
STATUS	EQU	37ECH
CMMD	EQU	37ECH
TRKREG	EQU	37EDH
SECREG	EQU	37EEH
DATA	EQU	37EFH
ADSIZE	EQU	1140
TRKLEN	EQU	3299
;
;::::::::::::::::::::::::::::::::::::::::::::::::::::::::
;Read sector addresses
;
HDRONE	DEFW	00		;TN,SN of first good sec.
HDRTWO	DEFW	00		;TN,SN of rec following
RCDCNT	DEFB	0		;Total # records on track
NUMSEC	DEFB	0		;# Sectors w/data
NUMBAD	DEFB	0		;# these w/bad len or CRC
TCOUNT	DEFB	0		;Counts # tries IBM/NBM
;
; -------------------------------
;Read ID's
;
START1	LD	HL,ADDSTR	;Clear area into which
	LD	BC,ADSIZE	;  sector ID packs will
SFILL	LD	(HL),0		;  be read.
	INC	HL
	DEC	BC
	LD	A,B
	OR	C
	JR	NZ,SFILL
;
	LD	IX,ADDSTR-4	;Set up header
	LD	(IX+4),'$'
	LD	(IX+8),'/'
;
	LD	A,(BUF02)	;Active drive # in BUF02
	LD	(DRVSEL),A	;Turn on drive
	LD	BC,8000H	;Allow to reach speed
	CALL	DELAY
;
	LD	A,0D0H		;FI causes status re-
	LD	(CMMD),A	;  turned to show IP
	LD	BC,3000H
	CALL	DELAY
;
	LD	H,125		;Read 125 packs
	LD	BC,9		;Each will take 9 bytes.
;
INDEX	LD	A,(STATUS)	;Loop until index hole
	BIT	1,A
	JR	Z,INDEX
;
GETADD	CALL	PACKIN		;Main loop.  Read H packs
	LD	A,(BUF02)	;  into area provided,
	LD	(DRVSEL),A	;  then go to SECSCN.
	LD	A,(3802H)	;CHECK: IS 'M' PRESSED?
	CP	20H
	JR	NZ,NOM		;GO IF NOT.
	LD	HL,00FFH	;ELSE RETURN W/HL=255.
	JP	BASIC
NOM	DEC	H
	JR	NZ,GETADD
	JR	SECSCN
;
PACKIN	LD	A,0C0H		;Subroutine reads in each
	LD	(CMMD),A	;  sector's ID pack.
	ADD	IX,BC		;Allocate 9 bytes to each
	PUSH	IX
	POP	DE
	LD	L,6		;6 bytes expected on read
	EX	(SP),IY		;Delay
	EX	(SP),IY
	EX	(SP),IY
	EX	(SP),IY
PACK1	LD	A,(STATUS)
	RRCA
	JR	NC,GOTPAK	;Done when Not Busy
	RRCA
	JR	NC,PACK1	;Loop 'till Data Ready
	LD	A,(DATA)	;Then take the byte
	LD	(DE),A		;  and save it.
	INC	DE
	DEC	L
	JR	PACK1		;And go back for next.
;
GOTPAK	RLCA
	LD	(DE),A
	LD	A,L		;Back w/Z set if 6 bytes
	AND	A		;  read in (OK).
	RET	Z
	LD	A,0FFH		;Else put FF in sixth
	LD	(IX+6),A	;  position.
	RET
;
; -------------------------------
;Sector Scan
;
SECSCN	LD	IX,ADDSTR-4	;Initialize pointers and
	LD	IY,ADDSTR-4	;  counters.
	XOR	A
	LD	(RCDCNT),A
	LD	(NUMSEC),A
	LD	(NUMBAD),A
;
RCDCHK	LD	BC,9
	ADD	IX,BC
	LD	A,(BUF02)
	LD	(DRVSEL),A
	LD	A,(3802H)	;CHECK: IS 'M' PRESSED?
	CP	20H		;BACK W/255 IN HL IF SO.
	LD	HL,0FFH
	JP	Z,BASIC
;
	LD	L,(IX+0)
	LD	H,(IX+2)
	LD	A,(RCDCNT)
	OR	A
	JR	NZ,CHKFST
	LD	(HDRONE),HL
	LD	L,(IX+9)
	LD	H,(IX+11)
	LD	(HDRTWO),HL
	JR	DTLOOK
;
CHKFST	LD	DE,(HDRONE)
	CALL	CMHLDE
	JR	NZ,DTLOOK
	LD	L,(IX+9)
	LD	H,(IX+11)
	LD	DE,(HDRTWO)
	CALL	CMHLDE
	JP	Z,SCNDUN
;
DTLOOK	LD	A,(RCDCNT)	;CHECK: HAVE 125 PACKS
	INC	A		;  BEEN PROCESSED W/O
	LD	(RCDCNT),A	;  FINDING FIRST AGAIN?
	LD	HL,00		;  (MEANING NO SECTORS ON
	CP	126		;  TRACK).  BACK WITH 0
	JP	Z,BASIC		;  HL IF SO.
;
	LD	A,(IX+6)	;Skip if ID CRC bad.
	AND	A
	JR	NZ,RCDCHK
;
	LD	B,5
	LD	L,(IX+0)
	LD	H,(IX+2)
DATRY	LD	A,8CH		;OK TO TRY AS IBM
	CALL	SECRD
	BIT	4,A
	JR	Z,TRYTYP	;Go if data present.
	DJNZ	DATRY
	JR	RCDCHK
;
TRYTYP	LD	BC,9
	ADD	IY,BC
	LD	A,3
	CP	(IX+3)		;Don't try IBM if SL>3.
	JR	C,TRYNBM
;
TRYIBM	LD	A,5
	LD	(TCOUNT),A
TRYI2	LD	A,(BUF02)
	LD	(DRVSEL),A
	LD	A,8CH
	CALL	SECRD
	LD	(IY+5),E	;# bytes in.
	LD	(IY+6),D
	LD	D,A		;Save status.
	AND	0FH
	LD	A,1
	JR	Z,GOODSC
	LD	A,(TCOUNT)	;Try the above 5 times
	DEC	A
	LD	(TCOUNT),A
	JR	NZ,TRYI2
;
TRYNBM	LD	A,5
	LD	(TCOUNT),A
TRYN2	LD	A,(BUF02)
	LD	(DRVSEL),A
	LD	A,84H
	CALL	SECRD
	LD	(IY+5),E
	LD	(IY+6),D
	LD	D,A
	AND	0FH
	LD	A,0
	JR	Z,GOODSC
	LD	A,(TCOUNT)
	DEC	A
	LD	(TCOUNT),A
	JR	NZ,TRYN2	;Try the above 5 times
;
BADLEN	LD	A,(NUMBAD)
	INC	A
	LD	(NUMBAD),A
	LD	A,2
;
GOODSC	LD	(IY+4),A
	LD	A,D
	AND	60H
	RLCA
	RLCA
	RLCA
	LD	(IY+7),A	;Save DAM 0-3 = FB-F8
	LD	(IY+8),'/'
	LD	A,(IX+0)	;Save TN
	LD	(IY+0),A
	LD	A,(IX+1)	;Save SN
	LD	(IY+1),A
	LD	A,(IX+2)	;Save SD
	LD	(IY+2),A
	LD	A,(IX+3)	;Save SL
	LD	(IY+3),A
	LD	A,(NUMSEC)
	INC	A
	LD	(NUMSEC),A
	JP	RCDCHK
;
SCNDUN	LD	(IY+9),'#'	;Mark end of records.
	LD	IY,ADDSTR
	LD	A,(RCDCNT)
	LD	(IY+1),A	;This is # rec on track.
	LD	A,(NUMSEC)
	LD	(IY+2),A
	LD	H,0		;Send # valid sectors
	LD	L,A		;  back to Basic.
	LD	A,(NUMBAD)	;# OF THESE BAD LEN/CRC
	LD	(IY+3),A
	JP	BASIC
;
SECRD	LD	(TRKREG),HL
	LD	(CMMD),A
	LD	DE,0
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
SC1	LD	A,(STATUS)
	RRCA
	JR	NC,SECDUN
	RRCA
	JR	NC,SC1
	LD	A,(DATA)
	INC	DE
	JR	SC1
SECDUN	LD	A,(STATUS)
	PUSH	AF
	LD	A,D		;Flag no data if 0 bytes
	OR	E		;  read.
	JR	NZ,NOT0
	POP	AF
	LD	A,16
	RET
NOT0	POP	AF
	RET
;
;::::::::::::::::::::::::::::::::::::::::::::::::::::::::
;Track Maker
;
FMTEND	DEFW	00
STRT1A	CALL	GETARG
	PUSH	HL
	PUSH	HL
	LD	BC,3120		;Set up FMTEND - no track
	ADD	HL,BC		;  longer than this.
	LD	(FMTEND),HL
	POP	HL
	LD	BC,TRKLEN+1	;3.3K FF's into HL+
	LD	E,0FFH
FLP1	LD	(HL),E
	INC	HL
	DEC	BC
	LD	A,B
	OR	C
	JR	NZ,FLP1
	POP	HL
;
	LD	A,(ADDSTR+2)	;# sectors w/data.
	LD	(NUMSEC),A
	LD	BC,14		;14 bytes of FF leader.
	ADD	HL,BC
	LD	B,15		;And 15 zeros.
LP1	LD	(HL),0
	INC	HL
	DJNZ	LP1
	LD	IX,ADDSTR+5	;Point to first TN.
;
MAINLP	CALL	LENCHK
	JR	C,TRKEXT	;Go if track too long.
	CALL	IDWRIT
	CALL	LENCHK
	JR	C,TRKEXT
	CALL	BLK1
	CALL	SCWRIT
	JR	C,TRKEXT
	LD	A,(NUMSEC)
	DEC	A
	LD	(NUMSEC),A
	JR	Z,TRKEXT
	CALL	BLK1
	LD	DE,9
	ADD	IX,DE
	JR	MAINLP
;
TRKEXT	JR	NC,LENOK
	LD	HL,00		;Return 0 if too long.
LENOK	JP	BASIC
;
IDWRIT	LD	(HL),0FEH
	INC	HL
	LD	A,(IX+0)
	LD	(HL),A
	INC	HL
	LD	A,(IX+1)
	LD	(HL),A
	INC	HL
	LD	A,(IX+2)
	LD	(HL),A
	INC	HL
	LD	A,(IX+3)
	LD	(HL),A
	INC	HL
	LD	(HL),0F7H
	INC	HL
	RET
;
BLK1	LD	B,12
BLP1	LD	(HL),0FFH
	INC	HL
	DJNZ	BLP1
	LD	B,6
BLP2	LD	(HL),0
	INC	HL
	DJNZ	BLP2
	RET
;
SCWRIT	LD	B,(IX+6)
	LD	C,(IX+5)
	INC	BC
	PUSH	HL
	LD	DE,(FMTEND)
	ADD	HL,BC
	EX	DE,HL
	SBC	HL,DE
	POP	HL
	RET	C		;Will make track too long
	LD	(HL),0FBH
	INC	HL
SCFILL	LD	E,0E5H
SCLP1	DEC	BC
	LD	A,B
	OR	C		;CCF too.
	JR	Z,SCQUIT
	LD	(HL),E
	INC	HL
	JR	SCLP1
SCQUIT	LD	(HL),0F7H
	INC	HL
	RET
;
LENCHK	LD	DE,(FMTEND)	;Returns Carry set if
	EX	DE,HL		;  past FMTEND.
	CALL	CMHLDE
	EX	DE,HL
	RET
;
;::::::::::::::::::::::::::::::::::::::::::::::::::::::::
;Block Compare
;
START2	LD	BC,(BUF09)
	LD	DE,(BUF05)
	LD	HL,(BUF07)
LOOP1	LD	A,(DE)
	INC	DE
	CPI
	JR	NZ,FIN1
	JP	PE,LOOP1
	LD	HL,00
FIN1	JP	BASIC
;
;Sector Read
;
START3	CALL	GETARG
	LD	(BUF00),HL
	LD	(TRKREG),HL
	LD	A,8CH
	LD	HL,BUF03
	AND	(HL)
	LD	HL,(BUF05)
	LD	BC,00
	LD	(CMMD),A
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
STCHK1	LD	A,(STATUS)
	RRCA
	JR	NC,DONE1
	RRCA
	JR	NC,STCHK1
	LD	A,(DATA)
	LD	(HL),A
	INC	HL
	INC	BC
	JR	STCHK1
DONE1	LD	A,(STATUS)
	LD	(BUF04),A
	LD	E,A
	AND	60H
	RLCA
	RLCA
	RLCA
	LD	(BUF14),A	;Note DAM
	LD	A,E
	AND	1CH
	LD	H,0
	LD	L,A
	LD	(BUF09),BC
	JP	BASIC
;
;Sector Write
;
START4	CALL	GETARG
	LD	(BUF00),HL
	LD	(TRKREG),HL
	LD	A,0ACH
	LD	HL,BUF03
	AND	(HL)		;AND w/IBM
	LD	HL,BUF14
	OR	(HL)		;OR w/DAM
	LD	HL,(BUF05)
	LD	BC,00
	LD	(CMMD),A
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
STCHK2	LD	A,(STATUS)
	RRCA
	JR	NC,DONE2
	RRCA
	JR	NC,STCHK2
	LD	A,(HL)
	LD	(DATA),A
	INC	HL
	INC	BC
	JR	STCHK2
DONE2	LD	A,(STATUS)
	LD	(BUF04),A
	LD	(BUF09),BC
	AND	7CH
	JR	Z,SWVRFY
	LD	H,0
	LD	L,A
	JP	BASIC
;
SWVRFY	LD	A,8CH
	LD	HL,BUF03
	AND	(HL)
	LD	(CMMD),A
	LD	HL,(BUF05)
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
STCHK6	LD	A,(STATUS)
	RRCA
	JR	NC,DONE6
	RRCA
	JR	NC,STCHK6
	LD	A,(DATA)
	CP	(HL)
	INC	HL
	JR	Z,STCHK6
DONE6	LD	HL,00
	JR	Z,DONESW
	DEC	L		;Return FF if no verify
DONESW	JP	BASIC
;
;Track Write
;
START5	LD	HL,(BUF05)
	LD	A,0F4H
	LD	BC,0
	LD	(CMMD),A
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
STCHK4	LD	A,(STATUS)
	RRCA
	JR	NC,DONE4
	RRCA
	JR	NC,STCHK4
	LD	A,(HL)
	LD	(DATA),A
	INC	HL
	INC	BC
	JR	STCHK4
DONE4	LD	A,(STATUS)
	LD	(BUF04),A
	AND	7CH
	LD	H,0
	LD	L,A
	LD	(BUF09),BC
	JP	BASIC
;
;Track Read
;
START6	LD	HL,(BUF05)
	LD	BC,00
	LD	A,0E4H
	LD	(CMMD),A
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
STCHK3	LD	A,(STATUS)
	RRCA
	JR	NC,DONE3
	RRCA
	JR	NC,STCHK3
	LD	A,(DATA)
	LD	(HL),A
	INC	HL
	INC	BC
	JR	STCHK3
DONE3	LD	A,(STATUS)
	LD	(BUF04),A
	AND	1CH
	LD	H,0
	LD	L,A
	LD	(BUF09),BC
	JP	BASIC
;
;CRC Check
;
START7	CALL	GETARG
	LD	BC,(BUF09)
	LD	DE,(BUF0D)
CRC1	PUSH	BC
	LD	A,(HL)
	CALL	NEWCRC
	POP	BC
	INC	HL
	DEC	BC
	LD	A,B
	OR	C
	JR	NZ,CRC1
	LD	(BUF0D),DE
	EX	DE,HL
	JP	BASIC
;
;CRC One Byte
;
START8	CALL	GETARG
	LD	A,L
	LD	DE,(BUF0D)
	CALL	NEWCRC
	LD	(BUF0D),DE
	EX	DE,HL
	JP	BASIC
;
NEWCRC	XOR	D
	LD	D,A
	SRL	A
	SRL	A
	SRL	A
	SRL	A
	XOR	D
	LD	D,E
	LD	E,A
	RL	A
	RL	A
	RL	A
	RL	A
	LD	C,A
	RL	A
	RL	A
	AND	1FH
	XOR	D
	LD	D,A
	LD	A,C
	AND	0F0H
	XOR	D
	LD	D,A
	LD	A,C
	RL	A
	AND	0E0H
	XOR	E
	LD	E,A
	RET
;
;Drive Check
;
START9	CALL	GETARG		;1,2,4,8
	LD	E,L
	XOR	A
	LD	L,A
;
	LD	A,0D0H		;FI for IP in Status.
	LD	(CMMD),A
	LD	A,E
	LD	(DRVSEL),A	;Reselect
;
	LD	H,2
	LD	BC,20001
BZLOOP	LD	A,(STATUS)
	BIT	0,A
	JR	Z,IPFIND
	DEC	BC
	LD	A,B
	OR	C
	JR	NZ,BZLOOP
	DEC	H
	LD	A,H
	JR	NZ,BZLOOP
	SET	0,L		;Stuck busy
	JR	CKRET
IPFIND	LD	A,E
	LD	(DRVSEL),A
	LD	BC,16000
IPLOOK	LD	A,(STATUS)
	BIT	1,A
	JR	NZ,DCHEK
	DEC	BC
	LD	A,B
	OR	C
	JR	NZ,IPLOOK
	SET	0,L		;No IP
	JR	CKRET
DCHEK	LD	A,E
	LD	(DRVSEL),A
	LD	BC,6802
	CALL	DELAY
	LD	A,(STATUS)
	BIT	1,A
	JR	Z,WPCHEK
	SET	0,L		;Still IP
	JR	CKRET
WPCHEK	BIT	6,A
	JR	Z,SECHEK
	SET	1,L		;WP
SECHEK	LD	A,0C0H
	LD	(CMMD),A
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
STCHK5	LD	A,(STATUS)
	INC	BC
	BIT	7,B
	JR	Z,CONTU
	SET	2,L		;ET
	JR	CKRET
CONTU	BIT	1,A
	JR	Z,STCHK5
CKRET	LD	H,0
	JP	BASIC
;
;STORAGE AREA
;
BUF00	DEFB	0
BUF01	DEFB	0
BUF02	DEFB	0
BUF03	DEFB	0
BUF04	DEFB	0
BUF05	DEFB	0
BUF06	DEFB	0
BUF07	DEFB	0
BUF08	DEFB	0
BUF09	DEFB	0
BUF0A	DEFB	0
BUF0B	DEFB	0
BUF0C	DEFB	0
BUF0D	DEFB	0
BUF0E	DEFB	0
BUF0F	DEFB	0
BUF10	DEFB	0
BUF11	DEFB	0
BUF12	DEFB	0
BUF13	DEFW	00
BUF14	DEFB	0
;
;Penram Editor
;
KI	EQU	002BH
CLS	EQU	01C9H
NUMTYP	EQU	4121H
CURPOS	EQU	4020H
KIBUF	EQU	4036H
LINEIN	EQU	05D9H
BYTDIS	EQU	0033H
NTF2	EQU	0A9DH
NUMSTR	EQU	0FBDH
KDLAY1	EQU	2500H
KDLAY2	EQU	1200H
BDELAY	EQU	0A0H
BLANK	EQU	' '
CURCHR	EQU	8AH
CLEAR	EQU	1FH
BREAK	EQU	4
SHFBRK	EQU	5
SHFTUP	EQU	9
SHFTDN	EQU	17
SHFLFT	EQU	21H
UPAROW	EQU	5BH
DNAROW	EQU	0AH
LFAROW	EQU	8
RTAROW	EQU	9
KEYS1	EQU	3801H
CNTL	EQU	3840H
SHCNTL	EQU	38C0H
SHIFT	EQU	3880H
;
STRPLC	EQU	$
	DEFS	82
STORAG	EQU	STRPLC+66
ADDR	EQU	STORAG
HOMADD	EQU	STORAG+2
EDCUR	EQU	STORAG+4
BYTED	EQU	STORAG+6
RGTCUR	EQU	STORAG+8
DWNCUR	EQU	STORAG+9
HATYPE	EQU	STORAG+10
KEY	EQU	STORAG+11
KEYH	EQU	STORAG+12
LSTARW	EQU	STORAG+13
ATADD	EQU	STORAG+14
;
LINE01	EQU	3C00H
LINE02	EQU	3C40H
LINE05	EQU	3D00H
LINE16	EQU	3FC0H
VIDFST	EQU	3C00H
VIDLST	EQU	3FFFH
;
PENRAM	CALL	GETARG			;Start address
	LD	(HOMADD),HL
	LD	(ATADD),HL
	CALL	CLS
	XOR	A
	LD	(HATYPE),A
	LD	(DWNCUR),A
	LD	(RGTCUR),A
	LD	HL,3C78H
	LD	(CURPOS),HL
	LD	HL,PENMSG
	CALL	OUTSTR
	LD	A,'>'
	LD	(3CF8H),A
	LD	A,'<'
	LD	(3CFFH),A
	LD	A,'='
	LD	(3D78H),A
	LD	A,'H'
	LD	(3D7EH),A
REINIT	LD	HL,(HOMADD)
	LD	(ADDR),HL
	LD	B,16
	LD	HL,VIDFST-1
	LD	(CURPOS),HL
INITLP	EXX
	LD	HL,(CURPOS)
	INC	HL
	LD	(CURPOS),HL
	LD	HL,(ADDR)
	CALL	MAKSTR
	LD	HL,STRPLC
	CALL	OUTSTR
	LD	BC,16
	CALL	AADDR
	EXX
	DJNZ	INITLP
	LD	A,1
	LD	(LSTARW),A
UPDATE	LD	HL,(EDCUR)
	LD	(HL),BLANK
	LD	A,(DWNCUR)
	INC	A
	LD	B,A
	LD	HL,VIDFST-61
	LD	DE,64
	EXX
	LD	HL,(HOMADD)
	LD	BC,17
	XOR	A
	SBC	HL,BC
	LD	DE,16
	EXX
LINEDN	ADD	HL,DE
	EXX
	ADD	HL,DE
	EXX
	DJNZ	LINEDN
	LD	A,(RGTCUR)
	INC	A
	LD	B,A
	LD	DE,3
SPCRGT	ADD	HL,DE
	EXX
	INC	HL
	EXX
	DJNZ	SPCRGT
	LD	(EDCUR),HL
	LD	(HL),CURCHR
	EXX
	LD	(BYTED),HL
	EXX
	LD	HL,3CFAH
	LD	(CURPOS),HL
	LD	HL,STRPLC+4
	LD	(HL),3
	DEC	HL
	LD	BC,(BYTED)
	CALL	BSTRNG
	CALL	OUTSTR
	LD	HL,3D7AH
	LD	(CURPOS),HL
	LD	HL,STRPLC+3
	LD	BC,(ATADD)
	CALL	BSTRNG
	CALL	OUTSTR
	LD	HL,3DB8H
	LD	(CURPOS),HL
	LD	A,1EH
	CALL	BYTDIS
	LD	HL,(BYTED)
	LD	DE,(ATADD)
	XOR	A
	SBC	HL,DE
	LD	(NUMTYP),HL
	CALL	NTF2
	CALL	NUMSTR
	CALL	OUTSTR
	LD	A,'D'
	LD	(3DBEH),A
	LD	HL,3DB8H
	LD	A,(HL)
	CP	'-'
	JR	Z,KBDSCN
	LD	(HL),'+'
KBDSCN	LD	B,BDELAY
HALFCK	LD	A,(SHIFT)
	AND	A
	JR	Z,REGKI
	LD	A,(SHCNTL)
	CP	SHFLFT
	RET	Z			;Back to Basic
	CP	SHFTUP
	JR	Z,DOUP
	CP	SHFTDN
	JR	Z,DODN
	CP	SHFBRK
	JR	NZ,REGKI
	LD	HL,(BYTED)
	LD	(ATADD),HL
	JR	JUPDAT
REGKI	CALL	KIR
	JR	NZ,KPRESS
	DJNZ	HALFCK
	LD	HL,(EDCUR)
	LD	A,(HL)
	XOR	0AH
	LD	(HL),A
	JR	KBDSCN
KPRESS	LD	(KEY),A
	CP	CLEAR
	JR	NZ,DBNC
	LD	A,(HATYPE)
	XOR	1
	LD	(HATYPE),A
	JP	REINIT
DBNC	LD	BC,KDLAY1
	CALL	DELAY
	LD	A,(KEY)
CKUP	CP	UPAROW
	JR	Z,DOUP
	JR	CKDN
DOUP	CALL	CURSUP
	JR	JUPDAT
CKDN	CP	DNAROW
	JR	Z,DODN
	JR	CKLF
DODN	CALL	CURSDN
	JR	JUPDAT
CKLF	CP	LFAROW
	JR	Z,DOLF
	JR	CKRT
DOLF	LD	A,(RGTCUR)
	DEC	A
	CP	0FFH
	LD	(RGTCUR),A
	JR	NZ,JUPDAT
	LD	A,15
	LD	(RGTCUR),A
	CALL	CURSUP
	JR	JUPDAT
CKRT	CP	RTAROW
	JR	Z,DORT
	JR	KEYIN
DORT	LD	A,(RGTCUR)
	INC	A
	CP	16
	LD	(RGTCUR),A
	JR	NZ,JUPDAT
	XOR	A
	LD	(RGTCUR),A
	CALL	CURSDN
JUPDAT	JP	UPDATE
KEYIN	LD	BC,KDLAY2
	CALL	DELAY
	LD	A,(HATYPE)
	AND	A
	JR	NZ,ASCIN
	LD	A,(KEY)
	CALL	VALHEX
	JP	C,UPDATE
	RLCA
	RLCA
	RLCA
	RLCA
	LD	(KEYH),A
	LD	HL,(EDCUR)
	LD	A,CURCHR
	LD	(HL),A
	LD	A,(KEY)
	CALL	CURINC
	CALL	BYTDIS
WAITNX	LD	A,(CNTL)	;Break from hex entry
	OR	A		;  on any control key.
	JP	NZ,REINIT
	CALL	KIR
	CALL	VALHEX
	JR	C,WAITNX
	LD	C,A
	LD	A,(KEYH)
	OR	C
	LD	HL,(BYTED)
	LD	(HL),A
	LD	A,(HL)
	CALL	CURINC
	LD	C,A
	CALL	ASCII
	EX	DE,HL
	LD	A,H
	CALL	BYTDIS
	LD	A,L
	CALL	BYTDIS
	LD	BC,KDLAY1+KDLAY2
	CALL	DELAY
	JR	DORT
ASCIN	LD	A,(KEY)
	LD	C,A
	CALL	VALASC
	JR	NC,JUPDAT
	LD	HL,(BYTED)
	LD	(HL),A
	LD	A,(HL)
	LD	C,A
	CALL	VALASC
	JR	NC,ENDASC
	CALL	CURINC
	CALL	BYTDIS
ENDASC	JP	DORT
VALHEX	LD	(KEY),A
	LD	C,A
	LD	A,'F'
	CP	C
	JR	C,NOTHEX
	LD	A,'/'
	CP	C
	JR	NC,NOTHEX
	LD	A,'@'
	CP	C
	JR	C,ATHRUF
	LD	A,C
	CP	':'
	JR	C,ZTHRU9
NOTHEX	SCF
	RET
ZTHRU9	SUB	30H
	RET
ATHRUF	LD	A,(KEY)
	SUB	37H
	RET
VALASC	LD	A,7FH
	CP	C
	JR	C,NOTASC
	LD	A,1FH
	CP	C
	LD	A,C
	RET	C
NOTASC	LD	A,5FH
	AND	A
	RET
FRMBYT	LD	A,(HL)
	CALL	VALHEX
	RET	C
	LD	E,A
	DEC	HL
	LD	A,(HL)
	CALL	VALHEX
	RET	C
	RLCA
	RLCA
	RLCA
	RLCA
	OR	E
	DEC	HL
	RET
CURINC	LD	HL,(EDCUR)
	INC	HL
	LD	(CURPOS),HL
	RET
KIR	CALL	KI
	LD	D,A
	LD	E,7
	LD	HL,KIBUF
	XOR	A
RPT	LD	(HL),A
	INC	HL
	DEC	E
	JR	NZ,RPT
	LD	A,D
	AND	A
	RET
CURSUP	LD	A,(DWNCUR)
	AND	A
	JR	Z,CONTU1
	DEC	A
	LD	(DWNCUR),A
	RET
CONTU1	LD	A,(LSTARW)
	AND	A
	JR	Z,CONTUP
	LD	BC,272
	CALL	SADDR
CONTUP	LD	HL,(EDCUR)
	LD	(HL),BLANK
	LD	HL,(ADDR)
	CALL	MAKSTR
	LD	A,15
	LD	HL,3F80H
	LD	DE,3FC0H
MVLOPS	LD	BC,37H
	LDIR
	LD	BC,-119
	ADD	HL,BC
	EX	DE,HL
	ADD	HL,BC
	EX	DE,HL
	DEC	A
	JR	NZ,MVLOPS
	LD	HL,LINE01
	LD	(CURPOS),HL
	LD	HL,STRPLC
	CALL	OUTSTR
	LD	BC,16
	CALL	SADDR
	CALL	SHOMAD
	XOR	A
	LD	(LSTARW),A
	RET
CURSDN	LD	A,(DWNCUR)
	CP	15
	JR	Z,CONTD1
	INC	A
	LD	(DWNCUR),A
	RET
CONTD1	LD	A,(LSTARW)
	AND	A
	JR	NZ,CONTD2
	LD	BC,272
	CALL	AADDR
CONTD2	LD	HL,(EDCUR)
	LD	(HL),BLANK
	LD	HL,(ADDR)
	CALL	MAKSTR
	LD	A,15
	LD	HL,3C40H
	LD	DE,3C00H
MVLOPA	LD	BC,37H
	LDIR
	LD	BC,9
	ADD	HL,BC
	EX	DE,HL
	ADD	HL,BC
	EX	DE,HL
	DEC	A
	JR	NZ,MVLOPA
	LD	HL,LINE16
	LD	(CURPOS),HL
	LD	HL,STRPLC
	CALL	OUTSTR
	LD	BC,16
	CALL	AADDR
	CALL	AHOMAD
	LD	A,1
	LD	(LSTARW),A
	RET
MAKSTR	PUSH	HL
	PUSH	HL
	POP	IX
	POP	BC
	LD	HL,STRPLC+3
	CALL	BSTRNG
	LD	HL,STRPLC+4
	LD	(HL),':'
	INC	HL
	LD	(HL),' '
	INC	HL
	LD	B,16
CHRBLK	LD	(HL),' '
	INC	HL
	LD	C,(IX+0)
	LD	A,(HATYPE)
	AND	A
	JR	NZ,ACHAR
	CALL	ASCII
	LD	(HL),D
	INC	HL
	LD	(HL),E
	JR	CHRDN
ACHAR	CALL	VALASC
	LD	(HL),A
	INC	HL
	LD	(HL),' '
CHRDN	INC	IX
	INC	HL
	DJNZ	CHRBLK
	LD	(HL),0AAH
	INC	HL
	LD	B,8
TRALER	LD	(HL),19H
	INC	HL
	DJNZ	TRALER
	LD	(HL),03H
	RET
BSTRNG	CALL	ASCII
	LD	(HL),E
	DEC	HL
	LD	(HL),D
	DEC	HL
	LD	C,B
	CALL	ASCII
	LD	(HL),E
	DEC	HL
	LD	(HL),D
	RET
ASCII	LD	A,C
	CALL	SBRASC
	LD	E,A
	LD	A,C
	RRCA
	RRCA
	RRCA
	RRCA
	CALL	SBRASC
	LD	D,A
	RET
SBRASC	AND	0FH
	OR	30H
	CP	3AH
	RET	C
	ADD	A,07
	RET
OUTSTR	LD	A,(HL)
	CP	04
	RET	C
	CALL	BYTDIS
	INC	HL
	JR	OUTSTR
AADDR	LD	HL,(ADDR)
	ADD	HL,BC
	LD	(ADDR),HL
	RET
AHOMAD	LD	HL,(HOMADD)
	ADD	HL,BC
	LD	(HOMADD),HL
	RET
SADDR	LD	HL,(ADDR)
	XOR	A
	SBC	HL,BC
	LD	(ADDR),HL
	RET
SHOMAD	LD	HL,(HOMADD)
	XOR	A
	SBC	HL,BC
	LD	(HOMADD),HL
	RET
INMSG	DEFM	'ADDRESS?'
	DEFB	03
PENMSG	DEFM	'TRAKCESS'
	DEFB	03
;
PDUMP	CALL	GETARG
	LD	(ADDR),HL
	CALL	MAKSTR
	LD	BC,16
	CALL	AADDR
	JP	BASIC
;
;Fill Block
;
FILL	CALL	GETARG
	LD	C,L
	LD	HL,(BUF05)
	LD	DE,(BUF07)
	DEC	HL
FLOOP	INC	HL
	LD	(HL),C
	CALL	CMHLDE
	JR	NZ,FLOOP
	RET
;
;Menu
;
MENU	LD	BC,02C0H
	LD	DE,3D40H
	LD	HL,MSTR
	LDIR
	RET
;
MSTR	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	0B0H
	DEFB	90H
	DEFB	0BFH
	DEFM	'0-3'
	DEFB	0AAH
	DEFB	95H
	DEFM	'TO SELECT DRIVE         '	;24
	DEFB	0AAH
	DEFB	0BFH
	DEFM	' G '
	DEFB	0AAH
	DEFB	95H
	DEFM	'TO GO TO HEAD POSITION   '	;25
	DEFB	0AAH
	DEFB	95H
	DEFB	0BFH
	DEFM	' I '
	DEFB	0AAH
	DEFB	95H
	DEFM	'TO STEP HEAD IN         '	;24
	DEFB	0AAH
	DEFB	0BFH
	DEFM	' O '
	DEFB	0AAH
	DEFB	95H
	DEFM	'TO STEP HEAD OUT         '	;25
	DEFB	0AAH
	DEFB	95H
	DEFB	0BFH
	DEFM	' R '
	DEFB	0AAH
	DEFB	95H
	DEFM	'TO READ A SECTOR        '	;24
	DEFB	0AAH
	DEFB	0BFH
	DEFM	' W '
	DEFB	0AAH
	DEFB	95H
	DEFM	'TO WRITE A SECTOR        '	;25
	DEFB	0AAH
	DEFB	95H
	DEFB	0BFH
	DEFM	' T '
	DEFB	0AAH
	DEFB	95H
	DEFM	'TO TAKE TRACK FROM DISK '	;24
	DEFB	0AAH
	DEFB	0BFH
	DEFM	' P '
	DEFB	0AAH
	DEFB	95H
	DEFM	'TO PUT TRACK ON DISK     '	;25
	DEFB	0AAH
	DEFB	95H
	DEFB	0BFH
	DEFM	' S '
	DEFB	0AAH
	DEFB	95H
	DEFM	'TO SCAN TRACK SECTORS   '	;24
	DEFB	0AAH
	DEFB	0BFH
	DEFM	' L '
	DEFB	0AAH
	DEFB	95H
	DEFM	'TO LOCATE DISK SECTORS   '	;25
	DEFB	0AAH
	DEFB	95H
	DEFB	0BFH
	DEFM	' C '
	DEFB	0AAH
	DEFB	95H
	DEFM	'TO COPY TRACK           '	;24
	DEFB	0AAH
	DEFB	0BFH
	DEFM	' D '
	DEFB	0AAH
	DEFB	95H
	DEFM	'TO DUPLICATE DISK        '	;25
	DEFB	0AAH
	DEFB	95H
	DEFB	0BFH
	DEFM	' B '
	DEFB	0AAH
	DEFB	95H
	DEFM	'TO BUILD FORMAT TRACK   '	;24
	DEFB	0AAH
	DEFB	0BFH
	DEFM	' E '
	DEFB	0AAH
	DEFB	95H
	DEFM	'TO EDIT MEMORY           '	;25
	DEFB	0AAH
	DEFB	95H
	DEFB	0BFH
	DEFM	' F '
	DEFB	0AAH
	DEFB	95H
	DEFM	'TO FIGURE CRC VALUES    '	;24
	DEFB	0AAH
	DEFB	0BFH
	DEFM	'   '
	DEFB	0AAH
	DEFB	95H
	DEFM	'                         '	;25
	DEFB	0AAH
	DEFB	95H
	DEFB	0BFH
	DEFM	'   '
	DEFB	0AAH
	DEFB	95H
	DEFM	'                        '	;24
	DEFB	0AAH
	DEFB	0BFH
	DEFM	'   '
	DEFB	0AAH
	DEFB	95H
	DEFM	'      TRAKCESS V         '	;25
	DEFB	0AAH
	DEFB	95H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	83H
	DEFB	81H
;
ADDSTR	DEFS	ADSIZE
WRKMEM	EQU	$		;*** MUST BE DF00H ! ***
ZZEND	EQU	$
	END	STRTUP
 