TRAK1  ; TRAK1/ASM    4/24/83
;
; TRAKCESS II  Disk I/O, Editing and System Routines.
; by Roxton Baker
;
;
; :::::::::::::::::::::::::::::::::::::::::::::::::::::::
; System definitions:
;
CRTBYT	EQU	0033H
LPTBYT	EQU	003BH
USRINP	EQU	0A7FH
USROUT	EQU	0A9AH
RST24	EQU	1C90H
DSELCT	EQU	37E1H
FDCADR	EQU	37ECH
TRKREG	EQU	37EDH
SECREG	EQU	37EEH
DATREG	EQU	37EFH
KBDADR	EQU	4016H
CURPOS	EQU	4020H
DOSVEC	EQU	402DH
DOSMEM	EQU	4049H
OUTLIN	EQU	4467H
RAMTOP	EQU	0FFFFH
;
FI	EQU	0D0H		;Force Interrupt cmd.
STDCUR	EQU	05FH
CURCHR	EQU	8AH
LOMARK	EQU	0B7H
HIMARK	EQU	0BBH
TPMARK	EQU	0BFH
CR	EQU	0DH
CLEAR	EQU	1
BREAK	EQU	2
UPAROW	EQU	3
DNAROW	EQU	4
LFAROW	EQU	5
RTAROW	EQU	6
ENTER	EQU	05DH
SPACE	EQU	20H
SCLR	EQU	7
SBRK	EQU	8
SUPARW	EQU	9
SDNARW	EQU	0AH
SLFARW	EQU	0BH
SRTARW	EQU	0CH
SENTER	EQU	10H
SSPACE	EQU	0EH
SATSGN	EQU	0FH
DWNH	EQU	48H
DWNL	EQU	4CH
DWNO	EQU	4FH
DWNY	EQU	59H
SHFTH	EQU	68H
SHFTL	EQU	6CH
SHFTN	EQU	6EH
;
KB1	EQU	3801H
KB2	EQU	3802H
KB3	EQU	3804H
KB4	EQU	3808H
KB5	EQU	3810H
KB6	EQU	3820H
KB7	EQU	3840H
KB8	EQU	3880H
KB1TO4	EQU	380FH
KB1TO7	EQU	387FH
KB1TO8	EQU	38FFH
SHKB7	EQU	38C0H
CRTR1	EQU	3C00H
CRTR2	EQU	3C40H
CRTR5	EQU	3D00H
CRTR16	EQU	3FC0H
;
ADSIZE	EQU	1140
;
; -------------------------------
; Entry from DOS, and initialization.
;
STRTUP	EQU	$
	LD	HL,ZZBEGN
	DEC	HL
	LD	(DOSMEM),HL	;Set Memory Size.
	CALL	CLSCRN
	LD	HL,CRTR5
	LD	(CURPOS),HL
	LD	HL,CMSG
	CALL	STRVID
	JP	DOSVEC
;
CMSG	DEFM	'---- TRAKCESS II ----'
	DEFW	0D0DH
	DEFM	'Enter Basic.  Set 0 Files, but no Mem Size.'
	DEFB	0DH
	DEFM	'Then:  RUN "TRAKCESS"'
	DEFW	0D0DH
	DEFB	0		;End msg.
; -------------------------------
; Basic Link Information
;
ZZBEGN	DEFW	START1		;Sector scan FNPS(0)
	DEFW	0000		;Spare FNPS(2)
	DEFW	START3		;Sector read FNPS(4)
	DEFW	START4		;Sector write FNPS(6)
	DEFW	START5		;Track write FNPS(8)
	DEFW	START6		;Track read FNPS(10)
	DEFW	0000		;Spare FNPS(12)
	DEFW	0000		;Spare FNPS(14)
	DEFW	START9		;Check drive FNPS(16)
	DEFW	PENRAM		;Penram editor FNPS(18)
	DEFW	WMFILL		;Fill working memory
	DEFW	ADRCLR		;Clear ADDSTR+ FNPS(22)
	DEFW	PDUMP		;Dump mem to prtr.
	DEFW	BLKMOV		;Block move routine
	DEFW	0000		;Spare FNPS(28)
	DEFW	BUF00		;Main param storage.
	DEFW	HATYPE		;Hex/ASCII flag Penram
	DEFW	STRPLC		;Penram work area
	DEFW	ADDSTR		;Sector spec storage
	DEFW	0000		;Spare FNPS(38)
	DEFW	STRT1A		;Track maker
	DEFW	LOMADR		;Low marker Penram
	DEFW	HIMADR		;High marker Penram
	DEFW	0000		;Spare FNPS(46)
	DEFW	PGFLG		;Printer graphics Penram
	DEFW	ULOMRK		;Show low marker Penram
	DEFW	UHIMRK		;Show high marker Penram
	DEFW	WRKMEM		;Trakcess main work area
	DEFW	BYTED		;Edit byte Penram
	DEFW	ADSIZE		;Size of ADSTR+ area
	DEFW	MEMLIM		;Top of mem for Penram
	DEFW	TPMADR		;Top marker Penram
;
; -------------------------------
; Main System Storage Area
;
BUF00	DEFB	0		;BS - Dupe bad ID CRCs
BUF01	DEFB	0		;
;
BUF02	DEFB	0		;B2
BUF03	DEFB	0		;IB
BUF04	DEFB	0
BUF05	DEFB	0		;L1
BUF06	DEFB	0		;H1
BUF07	DEFB	0		;L2
BUF08	DEFB	0		;H2
BUF09	DEFB	0		;NL
BUF0A	DEFB	0		;NH
BUF0B	DEFB	0
BUF0C	DEFB	0
BUF0D	DEFB	0
BUF0E	DEFB	0
BUF0F	DEFB	0		;HP(0) = head pos Drive 0
BUF10	DEFB	0		;HP(1)     "        "   1
BUF11	DEFB	0		;HP(2)     "        "   2
BUF12	DEFB	0		;HP(3)     "        "   3
BUF13	DEFW	00
BUF14	DEFB	0		;MD (DAM type)
;
TRAK23 ; TRAK23/ASM    4/24/83
;
;::::::::::::::::::::::::::::::::::::::::::::::::::::::::
;Read sector addresses
;
;
ADDSTR	DEFS	ADSIZE		;Store sector specs here.
;
; -------------------------------
;Read ID's
;
START1	EQU	$
	CALL	ADRCLR		;Clear ADDSTR+.
;
	LD	IX,ADDSTR-4	;Set up header
	LD	(IX+4),'$'
	LD	(IX+8),'/'
;
	LD	A,(BUF02)	;Drive # (1,2,4,8)
	LD	(DSELCT),A	;Turn on drive
	LD	BC,8000H	;Allow to reach speed
	CALL	MYDELY
;
	LD	A,0D0H		;FI causes status re-
	LD	(FDCADR),A	;  turned to show IP
	LD	BC,3000H
	CALL	MYDELY
;
INDEX	LD	A,(FDCADR)	;Loop until index hole
	BIT	1,A
	JR	Z,INDEX
;
	LD	HL,0
NXTPAK	EQU	$
	LD	A,(BUF02)	;Keep drive spinning
	LD	(DSELCT),A
	LD	A,(3802H)	;Quit if M pressed.
	CP	20H
	JP	Z,GPBORT
;
	LD	BC,9
	ADD	IX,BC		;Records take 9 bytes.
	CALL	PACKIN		;Read in pack at IX.
				;Spin count in HL.
	LD	A,(ADDSTR+1)	;Count another rcd in.
	INC	A
	LD	(ADDSTR+1),A
;
	LD	DE,2000H	;Has the disk spun long
	CALL	RST24		;  enough yet to be sure
	JP	NC,DUPOUT	;  we got whole track?
;
	JP	NXTPAK		;If not, back for another
				;  pack.
GPBORT	LD	HL,00FFH	;Exit w/FF if M pressed.
	JP	USROUT
;
; - - - - - - - - - - - - - - - -
; Read in the next sector ID pack.  Store at IX+.  If six
; bytes not read in (counted in C) then return 4 in byte
; 7 of record, to show bad pack.  HL keeps a running
; total of DRQ loops each time this routine is called.
; Record is ended with '/'.
;
PACKIN	EQU	$
	LD	A,0C0H		;Read ID command.
	LD	(FDCADR),A
	LD	C,6		;Counts down each byte.
	LD	(IX+8),'/'	;Mark record end.
	PUSH	IX
	POP	DE
	EX	(SP),IY
	EX	(SP),IY
	EX	(SP),IY
	EX	(SP),IY
;
PACK1	LD	A,(FDCADR)
	RRCA
	JR	NC,GOTPAK	;Done when NOT BUSY.
	INC	HL		;Counts each BSY check.
	RRCA
	JP	NC,PACK1	;Loop on DRQ.
	LD	A,(DATREG)	;Got DRQ - take byte.
	LD	(DE),A		;Put in record.
	INC	DE
	DEC	C		;Count another byte in.
	JR	PACK1
;
GOTPAK	RLCA			;Restore status
	INC	DE		;DE at IX+7
	LD	(DE),A		;Status at 7th byte.
	LD	A,C		;See if six bytes came
	OR	A		;  in on this pack.
	RET	Z		;Back if so.
	LD	(IX+7),4	;Else 4 in 7th byte to
	RET			;  mark bad ID pack.
;
; -------------------------------
; Remove Duplicate Records
;
; A series of ID pack records, of 9 bytes each, have been
; generated at ADDSTR+.  This routine chops any duplicate
; records off the end of this list by taking the last
; record and comparing it against the first, then against
; the second, etc. up to the next-to-last record.  If any
; of these records match it, it is dropped from the end,
; and the process is repeated with the new "last record".
; When the current "last record" matches no other record,
; it is taken as the true last record and the existing
; string of records is assumed to represent what is
; really on the track.
;
DUPOUT	EQU	$
	LD	IY,ADDSTR+5	;Point to first record.
;
DUPLUP	EQU	$
	CALL	CPIXIY		;Both pointers same?
	JP	Z,DUPDUN	;Go if so - done.
	CALL	COMPAK		;Else are records same?
	JP	Z,PAKSAM	;Go if so - chop last.
	LD	BC,9		;Else point IY to next
	ADD	IY,BC		;  record to compare last
	JP	DUPLUP		;  one to.
;
PAKSAM	EQU	$		;Here if records same.
	LD	BC,-9		;Drop last one.
	ADD	IX,BC
	LD	A,(ADDSTR+1)	;Count one less, total.
	DEC	A
	LD	(ADDSTR+1),A
	DEC	A		;Are we down to one?
	JP	NZ,DUPOUT	;Quit if so.
;
DUPDUN	LD	(IX+9),'#'	;Duplicates out.  Mark
	JP	SECSCN		;  end of string.
;
; - - - - - - - - - - - - - - - -
CPIXIY	EQU	$		;Compare IX, IY
	PUSH	HL		;Return Z if same, NZ
	PUSH	DE		;  else.
	PUSH	IX
	PUSH	IY
	POP	DE
	POP	HL
	CALL	RST24
	POP	DE
	POP	HL
	RET
;
; - - - - - - - - - - - - - - - -
COMPAK	EQU	$		;Compare two sector rec-
	LD	A,(IX+0)	;  cords pointed to by
	CP	(IY+0)		;  IX and IY.  Return Z
	RET	NZ		;  set if the same, NZ if
	LD	A,(IX+1)	;  different.
	CP	(IY+1)
	RET	NZ
	LD	A,(IX+2)
	CP	(IY+2)
	RET	NZ
	LD	A,(IX+3)
	CP	(IY+3)
	RET	NZ
;
; If packs don't match in byte 4,5, and 6, see if they
; both have a non-zero byte 7.  If so, they're both bad
; and we assume they are the same sector.
;
	LD	A,(IX+4)
	CP	(IY+4)
	JP	NZ,MAYBF
	LD	A,(IX+5)
	CP	(IY+5)
	JP	NZ,MAYBF
	LD	A,(IX+6)
	CP	(IY+6)
	JP	NZ,MAYBF
	RET			;Z set on match.
;
MAYBF	LD	A,(IX+7)	;Assume good compare if
	OR	A		;  both ID packs bad.
	JP	Z,BADCMP
	LD	A,(IY+7)
	OR	A
	JP	Z,BADCMP
	XOR	A		;Set Z flag for good com-
	RET			;  pare.
;
BADCMP	XOR	A
	INC	A		;Set NZ for bad compare.
	RET
;
; -------------------------------
;Sector Scan
;
; Here with the number of distinct ID packs found in
; ADDSTR+1.  Any one with a bad ID CRC has a nonzero
; byte 8.  For the rest, determine if each has data,
; and if so is it IBM, NBM, or indeterminate because of
; bad data block length or missing data CRC.
; Return the results in the sector record as:
;
;	Record bytes 1-4  = TN, SD, SN, SL
;
; 	Record byte 5:	0 = Good NBM sector.
;			2 = Good IBM sector.
;			4 = No data record found
;			5 = Bad Len/CRC in data record
;
;	Record byte 6:	Low byte of # bytes of data
;	Record byte 7:	High byte of # bytes of data
;
;	Record byte 8:	0 = FB DAM
;			1 = FA DAM
;			2 = F9 DAM
;			3 = F8 DAM
;			4 = Bad ID pack CRC
;
; Records showing a bad ID pack (nonzero byte 8) will get
; bytes 4,5,6 filled with FF to assist later processing
; under Basic.  Byte 8 will be set to 4.  If M is pressed
; during the scans, a return to Basic is made w/FF.
;
TCOUNT	DEFB	0		;Counts # tries IBM/NBM
LSTSEC	DEFB	0		;Last sector was IBM/NBM
;
SECSCN	EQU	$
	LD	IX,ADDSTR-4	;Initialize pointers and
	LD	A,(ADDSTR+1)	;  counters.
	INC	A
	EXX
	LD	B,A		;# rcds to check ==> B.
	XOR	A
	LD	D,A		;# ID packs w/data
	LD	E,A		;# of these w/data we
	EXX			;  can't read.
;
	LD	A,(BUF02)	;Keep drive spinning.
	LD	(DSELCT),A
;	LD	BC,3000		;In case it was stopped
;	CALL	MYDELY		;  (for debugging).
;
RCDCHK	LD	BC,9
	ADD	IX,BC
	LD	A,(BUF02)
	LD	(DSELCT),A
	LD	A,(3802H)	;Check M pressed?
	CP	20H
	LD	HL,0FFH		;Back w/FF if so.
	JP	Z,USROUT
	EXX			;Count a rcd checked.
	DEC	B
	EXX
	JP	Z,SCNDUN	;Quit if all checked.
;
	LD	A,(IX+7)	;Don't look for sector
	OR	A		;  data if ID pack was
	JP	Z,RCD2		;  found bad.
	LD	(IX+4),0FFH
	LD	(IX+5),0FFH
	LD	(IX+6),0FFH
	LD	(IX+7),4
	JR	RCDCHK
;
RCD2	LD	L,(IX+0)	;TN in L
	LD	H,(IX+2)	;SN in H
	LD	A,3
	CP	(IX+3)		;Was SL > 3?
	JP	C,TRYNBM	;Go if so - not IBM.
	LD	A,(LSTSEC)	;Was last sector IBM or
	OR	A		;  NBM?
	JP	NZ,TRYNBM	;Go if was NBM.
;
;  Here if the first attempt at reading the sector is to
;  be as IBM type.
;
TRYIBM	EQU	$		;Try reading as IBM.
	LD	B,5		;Will try as IBM 5 times.
TRYI2	LD	A,(BUF02)	;Keep drive spinning.
	LD	(DSELCT),A
	LD	A,88H		;Read IBM sector.
	CALL	SECRD
	LD	(IX+5),E	;Low byte of bytes read.
	LD	(IX+6),D	;High byte of bytes read.
	LD	A,C		;Check status returned.
	AND	9FH
	JP	Z,PERFI		;Go if good data block.
	DJNZ	TRYI2		;Else try up to 5 times.
	BIT	3,C		;If bad len/CRC, may be
	JP	NZ,MAYBN	;  an NBM sector.
	LD	(IX+4),4	;Else mark as missing
	JP	RCDCHK		;  data, and do next.
;
MAYBN	EQU	$		;It wasn't IBM - try NBM.
	LD	B,5		;Will try as NBM 5 times.
MBN2	LD	A,(BUF02)	;Keep drive spinning.
	LD	(DSELCT),A
	LD	A,80H		;Read NBM sector.
	CALL	SECRD
	LD	(IX+5),E	;Low byte of bytes read.
	LD	(IX+6),D	;High byte of bytes read.
	LD	A,C		;Check status returned.
	AND	9FH
	JP	Z,PERFN		;Go if good data block.
	DJNZ	MBN2		;Else try up to 5 times.
	BIT	3,C		;Go if bad len/CRC.
	JP	NZ,BADCRC
	LD	(IX+4),4	;Else mark as missing
	JP	RCDCHK		;  data, and do next.
;
;  Here if the first attempt at reading the sector is to
;  be as NBM type.
;
TRYNBM	EQU	$
	LD	B,5
TRYN2	LD	A,(BUF02)
	LD	(DSELCT),A
	LD	A,80H
	CALL	SECRD
	LD	(IX+5),E
	LD	(IX+6),D
	LD	A,C
	AND	9FH
	JP	Z,PERFN
	DJNZ	TRYN2
	BIT	3,C
	JP	NZ,MAYBI
	LD	(IX+4),4
	JP	RCDCHK
;
MAYBI	EQU	$		;It wasn't NBM - try IBM.
	LD	B,5
MBI2	LD	A,(BUF02)
	LD	A,(DSELCT)
	LD	A,88H
	CALL	SECRD
	LD	(IX+5),E
	LD	(IX+6),D
	LD	A,C
	AND	9FH
	JP	Z,PERFI
	DJNZ	MBI2
	BIT	3,C
	JP	NZ,BADCRC
	LD	(IX+4),4
	JP	RCDCHK
;
PERFI	EQU	$		;Was good IBM sector.
	LD	(IX+4),2
	LD	A,C
	AND	60H
	RLCA
	RLCA
	RLCA
	LD	(IX+7),A	;Save DAM.
	EXX
	INC	D
	EXX
	XOR	A
	LD	(LSTSEC),A
	JP	RCDCHK
;
PERFN	EQU	$		;Was good NBM sector.
	LD	(IX+4),0
	LD	A,C
	AND	60H
	RLCA
	RLCA
	RLCA
	LD	(IX+7),A	;Save DAM.
	EXX
	INC	D
	EXX
	LD	A,1
	LD	(LSTSEC),A
	JP	RCDCHK
;
;  Here if sector ID pack had data following it, but it
;  gave a CRC error whether read as IBM or NBM.
;
BADCRC	EQU	$
	LD	(IX+4),5	;Note bad len/CRC.
	LD	A,C
	AND	60H
	RLCA
	RLCA
	RLCA
	LD	(IX+7),A	;Save DAM
	EXX
	INC	D		;Inc. # found w/data.
	INC	E		;Inc. # with bad len/CRC
	EXX
	JP	RCDCHK
;
;  Here when all of the distinct ID packs found by READID
;  and DUPOUT have been checked for data and type.
;
SCNDUN	LD	IY,ADDSTR
	EXX
	LD	(IY+2),D	;# ID packs w/data.
	LD	(IY+3),E	;# of these w/data we
	EXX			;  can't read.
	LD	H,0
	LD	L,(IY+2)	;Send # sectors w/data
	JP	USROUT		;  back to Basic.
;
; - - - - - - - - - - - - - - - -
; Read a sector.  HL = SNTN.  Return # bytes read in DE,
; status of read in C.  C = 10H if no bytes read.  On
; entry, A must hold some type of sector read command.
;
SECRD	EQU	$
	LD	(TRKREG),HL	;Sector to read.
	LD	(FDCADR),A	;Read sector command.
	LD	DE,0
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
SC1	LD	A,(FDCADR)
	RRCA
	JR	NC,SCRDUN
	RRCA
	JR	NC,SC1
	LD	A,(DATREG)
	INC	DE
	JR	SC1
SCRDUN	LD	A,(FDCADR)
	LD	C,A
	LD	A,D		;Flag no data if 0 bytes
	OR	E		;  read.
	RET	NZ
	LD	C,16
	RET
;
;
;::::::::::::::::::::::::::::::::::::::::::::::::::::::::
;Track Maker
;
; Builds track at WRKMEM+.   Looks at ADDSTR+ for sector
; records.  Will create sectors with bad ID or Data CRCs
; if required.  Returns the last address used to Basic,
; unless the condition of "track too long" is detected
; (length > 3120 bytes), in which case a 0 is returned
; to Basic.  Also, if any sector is unspecified as to
; type, a 1 is returned to Basic.
;
FMTEND	DEFW	00		;Holds end address.
SCTODO	DEFB	0		;Counts sectors to do.
;
STRT1A	LD	HL,WRKMEM	;Get address to build at.
	LD	(LOMADR),HL	;Set low mark there.
	LD	A,1		;Call for low and high
	LD	(ULOMRK),A	; marks under Penram.
	LD	(UHIMRK),A
	LD	BC,3120		;Set up FMTEND - no track
	ADD	HL,BC		;  longer than this.
	LD	(FMTEND),HL
	LD	(HIMADR),HL	;Put High Mark there.
;
	LD	A,0FFH		;Fill WRKMEM+ w/FF.
	CALL	WMFIL2
;
	LD	A,(ADDSTR+1)	;Get # sectors to do.
	LD	(SCTODO),A
;
	LD	HL,WRKMEM
	LD	BC,14		;14 bytes of FF leader.
	ADD	HL,BC
	LD	B,15		;And 15 zeros.
LP1	LD	(HL),0
	INC	HL
	DJNZ	LP1
	LD	IX,ADDSTR-4	;Point to first record.
;
MAINLP	EQU	$		;Main loop. Do once for
	LD	DE,9		;  each sector.
	ADD	IX,DE		;Records 9 bytes long.
	CALL	LENCHK		;Check: track too long?
	JR	NZ,TRKXT1	;Go if so.
	LD	A,3		;Check: bad ID CRC?
	CP	(IX+7)
	JR	NC,DOIDF	;Go if not (3 or less).
	LD	A,(BUF00)	;Else check: are bad ID
	OR	A		; CRCs to be reproduced?
	JR	Z,SCTDUN	;Go if not.
;
DOIDF	CALL	IDWRIT		;Write ID pack.
	CALL	LENCHK		;Check: track too long?
	JR	NZ,TRKXT1	;Go if so.
	CALL	BLK1		;Write filler block.
	LD	A,(IX+4)	;See if data wanted.
	CP	4		; 4 means no data.
	JR	Z,SCTDUN	;Go if no data wanted.
	CP	5		;Is type even known?
	JR	NZ,TYPKNW	;Go if so.
	LD	HL,1		;Else incomplete specs.
	JR	TRKXT2		;Go with complaint.
TYPKNW	LD	A,3		;None on bad ID either...
	CP	(IX+7)		;Should be 3 or less.
	JR	C,SCTDUN	;Go if bad ID pack.
	CALL	SCWRIT		;Write sector data block.
	JR	NZ,TRKXT1	;Go if track too long.
;
SCTDUN	LD	A,(SCTODO)	;Note one sector done.
	DEC	A
	LD	(SCTODO),A
	JR	Z,TRKXT1	;Go if all sectors done.
	CALL	BLK1		;Else more filler.
	JR	MAINLP		;Back for next sector.
;
TRKXT1	JR	Z,TRKXT2	;Go if track length OK.
	LD	HL,00		;Return 0 if too long.
TRKXT2	JP	USROUT		;Back to Basic.
;
; - - - - - - - - - - - - - - - -
IDWRIT	EQU	$		;Write ID block.
	LD	(HL),0FEH	;IDAM
	INC	HL
	LD	A,(IX+0)	;Get TN
	LD	(HL),A		;  and write it.
	INC	HL
	LD	A,(IX+1)	;Get SD
	LD	(HL),A		;  and write it.
	INC	HL
	LD	A,(IX+2)	;Get SN
	LD	(HL),A		;  and write it.
	INC	HL
	LD	A,(IX+3)	;Get SL
	LD	(HL),A		;  and write it.
	INC	HL
	LD	A,3		;Want good ID CRC?
	CP	(IX+7)		;Yes if this is 0-3
	JR	C,IDCDUN	;Go if not. Leave FF here
	LD	(HL),0F7H	;Call for ID CRC.
IDCDUN	INC	HL
	RET
;
; - - - - - - - - - - - - - - - -
BLK1	LD	B,12		;Write 12 bytes of FF and
BLP1	LD	(HL),0FFH	;  then 6 bytes of 00
	INC	HL		;  into (HL)+.
	DJNZ	BLP1
	LD	B,6
BLP2	LD	(HL),0
	INC	HL
	DJNZ	BLP2
	RET
;
; - - - - - - - - - - - - - - - -
SCWRIT	EQU	$		;Writes sector data block
	LD	B,(IX+6)	;Get # bytes to write in
	LD	C,(IX+5)	;  BC.
	INC	BC
	PUSH	HL		;Will write at (HL)+.
	LD	DE,(FMTEND)	;Make sure will not
	ADD	HL,BC		;  exceed FMTEND.
	EX	DE,HL
	SBC	HL,DE
	POP	HL
	JR	C,SCLONG	;Go if will make too long
	LD	(HL),0FBH	;Write DAM = FB.
	INC	HL
;
SCFILL	LD	E,0E5H		;Write BC bytes of E5.
SCLP1	DEC	BC
	LD	A,B
	OR	C
	JR	Z,SCQUIT
	LD	(HL),E
	INC	HL
	JR	SCLP1
;
SCQUIT	LD	A,(IX+4)	;Bad len/CRC wanted?
	CP	1
	JR	Z,SCWRET	;Go if so - leave FF here
	CP	3
	JR	Z,SCWRET
	LD	(HL),0F7H	;Else call for data CRC.
;
SCWRET	INC	HL
	XOR	A		;Set Z for OK finish.
	RET
;
SCLONG	XOR	A
	INC	A		;Set NZ for too long.
	RET
;
; - - - - - - - - - - - - - - - -
LENCHK	LD	DE,(FMTEND)	;Returns A=1, NZ if
	EX	DE,HL		;  HL is past FMTEND.
	CALL	RST24		;  Affects DE.
	EX	DE,HL
	XOR	A
	RET	NC		;Back w/Z if OK.
	INC	A		;Else back w/NZ.
	RET
;
; :::::::::::::::::::::::::::::::::::::::::::::::::::::::
;Sector Read
;
START3	CALL	USRINP		;Get SN in H, TN in L.
	LD	(TRKREG),HL
	LD	A,1		;Call for marks in Penram
	LD	(ULOMRK),A
	LD	(UHIMRK),A
	LD	A,8CH		;Sector read command.
	LD	HL,BUF03
	AND	(HL)		;AND w/IBM.
	LD	HL,(BUF05)	;Place to read into.
	LD	(LOMADR),HL	;Set Low Mark there.
	LD	BC,00		;Count # bytes in.
	LD	(FDCADR),A
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
STCHK3	LD	A,(FDCADR)
	RRCA
	JR	NC,DONE3
	RRCA
	JR	NC,STCHK3
	LD	A,(DATREG)
	LD	(HL),A
	INC	HL
	INC	BC
	JR	STCHK3
;
DONE3	LD	A,(FDCADR)
	LD	(BUF04),A	;Save status of read.
	AND	60H		;Get DAM.
	RLCA
	RLCA
	RLCA
	LD	(BUF14),A	;Note DAM
	LD	(HIMADR),HL	;Mark last loc filled.
	LD	(BUF09),BC	;Number of bytes read.
	LD	A,(BUF04)	;Status again.
	AND	1CH		;Drop some flags.
	LD	L,A		;And return it to Basic.
	LD	H,0
	JP	USROUT
;
; :::::::::::::::::::::::::::::::::::::::::::::::::::::::
;Sector Write
;
START4	CALL	USRINP		;Get SN in H, TN in L.
	LD	(TRKREG),HL
	LD	IX,(BUF05)	;See where to get data.
;
	LD	DE,(BUF09)	;Max # bytes to write.
	DEC	DE		;Minus 1.
;
SW4	LD	A,0ACH		;Write Sector command.
	LD	HL,BUF03
	AND	(HL)		;AND w/IBM
	LD	HL,BUF14
	OR	(HL)		;OR w/DAM
;
	LD	BC,DATREG
	LD	HL,FDCADR
	LD	(HL),A		;Do it.
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	DEC	IX
;
ST4A	INC	IX		;Get next data byte.
	LD	A,(IX+0)
;
ST4B	BIT	0,(HL)		;Check Busy bit.
	JR	Z,DONE4		;Done when not Busy.
	BIT	1,(HL)		;If Busy, have DRQ?
	JR	Z,ST4B		;Back if not.
	LD	(BC),A		;Yes - write data out.
	DEC	DE		;See if next-to-last byte
	LD	A,D		;If so, FI and no CRCs.
	OR	E
	JR	NZ,ST4A		;If not, go do another.
	INC	IX		;Get last byte.
	LD	A,(IX+0)
;
ST4C	BIT	1,(HL)		;Await last DRQ.
	JR	Z,ST4C
	LD	(BC),A		;Write out last byte.
	EX	(SP),HL		;Delay for best chance of
	EX	(SP),HL		;  getting last byte on.
	LD	(HL),FI		;Force Interrupt causes
	JR	ST4B		;  Status to be BB.
;
DONE4	LD	A,(HL)		;Get status of write.
	LD	(BUF04),A	;Save it here.
	AND	7FH		;If no errors and not FI,
	JR	Z,SWVRFY	;  go verify the write.
	LD	H,0		;Else back to Basic with
	LD	L,A		;  status.
	JP	USROUT
;
;-------------------------------
; Verify the sector just written by reading it back and
; comparing it byte-for-byte with the orig. data.
;
SWVRFY	EQU	$
	LD	A,8CH		;Read Sector command.
	LD	HL,BUF03
	AND	(HL)		;AND w/IBM.
	LD	(FDCADR),A	;Do it.
	LD	HL,(BUF05)	;Where we wrote from.
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
STCHKV	LD	A,(FDCADR)
	RRCA
	JR	NC,DONEV	;Done when not BUSY.
	RRCA
	JR	NC,STCHKV	;Back if no DRQ.
	LD	A,(DATREG)	;Get byte from disk.
	CP	(HL)		;Same as in memory?
	INC	HL
	JR	Z,STCHKV	;Back for another if so.
	JR	BADVRF		;Go if bytes don't match.
;
DONEV	LD	A,(FDCADR)	;Get status again, and
	AND	60H		; isolate DAM.
	RLCA
	RLCA
	RLCA
	LD	HL,BUF14	;Does DAM match what we
	CP	(HL)		; thought we wrote?
	JR	NZ,BADVRF	;Go if not.
;
	LD	HL,00		;All data and DAM same.
	JP	USROUT		;So return w/0.
;
BADVRF	LD	HL,255		;Return FF if cannot
	JP	USROUT		;  verify.
;
; :::::::::::::::::::::::::::::::::::::::::::::::::::::::
;Track Write
;
START5	LD	HL,WRKMEM	;Where to write from.
	LD	BC,0		;Count bytes written.
;
	LD	A,0F4H		;Track write cmd.
	LD	(FDCADR),A
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
;
STCHK5	LD	A,(FDCADR)
	RRCA
	JR	NC,DONE5
	RRCA
	JR	NC,STCHK5
	LD	A,(HL)
	LD	(DATREG),A	;Write a byte.
	INC	HL
	INC	BC		;Count another written.
	JR	STCHK5
;
DONE5	LD	A,(FDCADR)
	LD	(BUF04),A
	AND	7CH
	LD	H,0
	LD	L,A
	LD	(BUF09),BC	;# bytes written.
	JP	USROUT		;Back w/status.
;
; :::::::::::::::::::::::::::::::::::::::::::::::::::::::
;Track Read
;
; No. bytes read put in BUF09 and returned in BC.
; Status of read returned in HL.  Low and High marks set
; at start and end of data read in.
;
START6	LD	HL,WRKMEM	;Where to read into.
	LD	(LOMADR),HL	;Set Low Mark there.
	LD	A,1		;Call for marks in Penram
	LD	(ULOMRK),A
	LD	(UHIMRK),A
	LD	BC,00		;Counts bytes in.
	LD	A,0E4H		;Read w/synch.
	LD	(FDCADR),A
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
;
STCHK6	LD	A,(FDCADR)
	RRCA
	JR	NC,DONE6
	RRCA
	JR	NC,STCHK6
	LD	A,(DATREG)
	LD	(HL),A
	INC	HL
	INC	BC
	JR	STCHK6
;
DONE6	LD	A,(FDCADR)	;Status of read.
	LD	(BUF04),A	;Save it.
	LD	(HIMADR),HL	;Last loc read into.
	LD	(TPMADR),HL	;Top and High Marks there
	LD	(BUF09),BC	;# bytes read.
	AND	1CH		;Drop some Status flags.
	LD	H,0		;Pass rest back to Basic.
	LD	L,A
	JP	USROUT
;
; :::::::::::::::::::::::::::::::::::::::::::::::::::::::
;Drive Check
;
START9	CALL	USRINP		;1,2,4,8
	LD	E,L
	XOR	A
	LD	L,A
;
	LD	A,0D0H		;FI for IP in Status.
	LD	(FDCADR),A
	LD	A,E
	LD	(DSELCT),A	;Reselect
;
	LD	H,2
	LD	BC,20001
BZLOOP	LD	A,(FDCADR)
	BIT	0,A
	JR	Z,IPFIND
	DEC	BC
	LD	A,B
	OR	C
	JR	NZ,BZLOOP
	DEC	H
	LD	A,H
	JR	NZ,BZLOOP
	SET	0,L		;Stuck busy
	JR	CKRET
IPFIND	LD	A,E
	LD	(DSELCT),A
	LD	BC,16000
IPLOOK	LD	A,(FDCADR)
	BIT	1,A
	JR	NZ,DCHEK
	DEC	BC
	LD	A,B
	OR	C
	JR	NZ,IPLOOK
	SET	0,L		;No IP
	JR	CKRET
DCHEK	LD	A,E
	LD	(DSELCT),A
	LD	BC,6802
	CALL	MYDELY
	LD	A,(FDCADR)
	BIT	1,A
	JR	Z,WPCHEK
	SET	0,L		;Still IP
	JR	CKRET
WPCHEK	BIT	6,A
	JR	Z,SECHEK
	SET	1,L		;WP
SECHEK	LD	A,0C0H
	LD	(FDCADR),A
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
STCHK9	LD	A,(FDCADR)
	INC	BC
	BIT	7,B
	JR	Z,CONTU
	SET	2,L		;ET
	JR	CKRET
CONTU	BIT	1,A
	JR	Z,STCHK9
CKRET	LD	H,0
	JP	USROUT
;
;::::::::::::::::::::::::::::::::::::::::::::::::::::::::
; Clears ADDSTR+ sector record area.
;
ADRCLR	EQU	$
	LD	HL,ADDSTR	;Clear area for records.
	LD	DE,ADDSTR+ADSIZE-1
	XOR	A
	CALL	FILL
	RET
;
;::::::::::::::::::::::::::::::::::::::::::::::::::::::::
;Fill Working Memory:  WRKMEM+
;
WMFILL	EQU	$
	CALL	USRINP		;Entry from Basic.
	LD	A,L		;Value to fill with.
WMFIL2	LD	HL,WRKMEM	;Entry from M/L.
	LD	(LOMADR),HL	;Set Low mark here.
	LD	DE,WRKMEM+3300
	LD	(HIMADR),DE	;Set High Mark at end.
	LD	(TPMADR),DE	;Top Mark there too.
	CALL	FILL
	LD	A,1		;Call for marks.
	LD	(ULOMRK),A
	LD	(UHIMRK),A
	RET
;
; -------------------------------------------------------
; Hex/ASCII Printer Dump
;
PDUMP	EQU	$
	CALL	USRINP
	LD	(ADDR),HL
	PUSH	HL
	PUSH	HL
	POP	IX
	POP	BC
	LD	HL,STRPLC+3
	CALL	BSTRNG
	LD	HL,STRPLC+4
	LD	(HL),':'
	INC	HL
	LD	(HL),' '
	INC	HL
	LD	B,16
PCRBLK	LD	(HL),' '
	INC	HL
	LD	C,(IX+0)
	LD	A,(HATYPE)
	AND	A
	JP	NZ,PACHAR
	CALL	ASCII
	LD	(HL),D
	INC	HL
	LD	(HL),E
	JP	PCHRDN
PACHAR	EQU	$		;Here if ASCII dump.
	LD	A,1FH
	CP	C
	JP	NC,BADCOD	;Go if C <= 1F
	LD	A,(PGFLG)
	OR	A
	JP	NZ,OKCODE	;Go if graphics printer
	LD	A,7FH
	CP	C
	JP	NC,OKCODE	;Go if C <= 7F.
BADCOD	LD	C,5FH		;Substitute underscore
OKCODE	LD	(HL),C
	INC	HL
	LD	(HL),' '
PCHRDN	INC	IX
	INC	HL
	DJNZ	PCRBLK
	LD	(HL),0AAH
	LD	BC,16
	LD	HL,(ADDR)
	ADD	HL,BC
	JP	USROUT
;
TRAKS5 ; :::::::::::::::::::::::::::::::::::::::::::::::::::::::
; Hansen's Disassembler    9/21/81
;
; Enter with address to start in BUF05, address to end
;  in BUF07.  PFG should be set to 1 for output to
;  printer, else 0.  Spacebar single-steps disassembly.
;  Enter restarts it.  Shift restarts it and/or allows
;  high-speed disassembly.
;
;  Uses ROM video and printer routines.
;  NMDIS originally set no. of instructions to dis.  It
;  should now always contain FFFF.
;
DISASM	EQU	$
	LD	HL,(BUF05)
	LD	(STDIS),HL
	LD	(S1),HL
	XOR	A
	LD	(BARFLG),A
	LD	BC,(NMDIS)
	INC	A
	LD	(PRINT),A	;Want display.
;
C02	EQU	$
	CALL	REGHEX
	CALL	SPCD
C02A	LD	A,(PRINT)
	PUSH	AF
	XOR	A
	LD	(PRINT),A
	CALL	BDIS
	POP	AF
	LD	(PRINT),A
	CALL	INCHL
	LD	HL,(STDIS)
	LD	DE,(S1)
	SBC	HL,DE
	LD	B,L
	LD	A,(PRINT)
	OR	A
	LD	A,B
	JP	Z,DISXIT
	LD	HL,(S1)
	LD	(STDIS),HL
WRLOOP	CALL	SHEX1
	INC	HL
	DJNZ	WRLOOP
C02B	CALL	BDIS
	CALL	INCHL
	LD	A,(PRINT)
	OR	A
	JR	Z,C02D
C02C	LD	A,0DH
	CALL	BYTOUT
;
C02D	EQU	$
	PUSH	HL		;See if last address
	PUSH	DE		;  reached.
	LD	HL,(S1)
	LD	DE,(BUF07)
	XOR	A
	SBC	HL,DE
	POP	DE
	POP	HL
	JP	C,NTDUN		;Go if not
	LD	HL,0
	JP	DISXIT		;Return 0 if so.
;
NTDUN	LD	A,(KB2)
	CP	20H		;M down?
	JP	NZ,NOM1
	LD	HL,2
	JP	DISXIT		;Return 2 if so.
;
NOM1	LD	A,(KB3)
	CP	4		;R down?
	JP	NZ,NOR1
	LD	HL,1
	JP	DISXIT		;Return 1 if so.
;
NOR1	LD	A,(KB7)
	CP	80H		;Spacebar?
	JP	Z,STBFLG	;Go if so.
	LD	A,(KB8)
	CP	1		;Shift?
	LD	BC,1200		;Short delay if so.
	JP	Z,LOPDLY
	LD	BC,18000	;Else long delay.
LOPDLY	CALL	MYDELY
	JP	NOSPC
STBFLG	LD	A,1		;BARFLG indicates space-
	LD	(BARFLG),A	;  bar has us in SS.
CKSPC1	LD	A,(KB7)
	CP	80H
	JP	Z,CKSPC1	;Loop til bar released
	LD	BC,1000
	CALL	MYDELY		;Debounce
NOSPC	LD	A,(BARFLG)
	OR	A
	JP	Z,NOBAR		;Go if not sngl. step.
CKSPC2	LD	A,(KB7)
	CP	80H
	JP	Z,SPCDEL	;Go if bar down.
	CP	1		;Enter breaks from SS.
	JP	Z,RSTBFG
	LD	A,(KB8)
	CP	1		;So does shift.
	JP	Z,RSTBFG
	LD	A,(KB2)
	CP	20H		;M down?
	JP	NZ,NOM2		;Go if not
	LD	HL,2
	JP	DISXIT		;Return 2 if so.
;
NOM2	LD	A,(KB3)
	CP	4		;R down?
	JP	NZ,NOR2
	LD	HL,1
	JP	DISXIT		;Return 1 if so.
;
NOR2	JP	CKSPC2
;
RSTBFG	XOR	A
	LD	(BARFLG),A
	JP	NOBAR
SPCDEL	LD	BC,1000		;Here if stepping w/bar
	CALL	MYDELY
CKSPC3	LD	A,(KB7)
	CP	80H
	JP	Z,CKSPC3	;Loop til released.
	JP	NOBAR
;
DISXIT	EQU	$		;Exit from disassembler.
	JP	USROUT
;
NOBAR	LD	BC,(NMDIS)	;Back to orig. code.
	DEC	BC
	LD	(NMDIS),BC
	LD	DE,(S1)
	XOR	A
	SBC	HL,DE
	LD	A,B
	OR	C
	JR	NZ,C01
	LD	A,L
	RET
;
C01	LD	HL,(STDIS)
	LD	(S1),HL
	JP	C02
BDIS	XOR	A
	LD	(TYPE),A
	LD	HL,(STDIS)
	LD	A,(HL)
	CP	0DDH
	JR	Z,NS10
	CP	0FDH
	JR	NZ,NS20
NS10	LD	(TYPE),A
	CALL	INCHL
NS20	LD	HL,(STDIS)
	LD	A,(HL)
	LD	HL,SBITBL
	LD	B,21
	LD	DE,SBITXT
	CALL	MST
	RET	Z
	LD	A,(HL)
	AND	192
	CP	64
	JR	NZ,N07
	LD	A,(HL)
	PUSH	AF
	LD	HL,LDTXT
	CALL	W0
	POP	AF
	PUSH	AF
	CALL	REGXTA
	CALL	COMMA
	POP	AF
	JP	RGEXTA
N07	LD	A,(HL)
	CP	3AH
	JR	NZ,N10
	LD	HL,LDA
	CALL	W0
	CALL	INCHL
	JP	RHEX
N10	CP	32H
	JR	NZ,N12
	LD	HL,LDTXT
	CALL	W0
	LD	A,'('
	CALL	BYTOUT
	CALL	INCHL
	CALL	THEX
	LD	HL,PA
	JP	WRT
N12	CP	2AH
	JR	NZ,N13
	LD	HL,LDTXT
	CALL	W0
	CALL	HIXIY
	CALL	COMMA
	CALL	INCHL
	JP	RHEX
N13	CP	22H
	JR	NZ,N22
	LD	HL,LDTXT
	CALL	W0
	CALL	INCHL
	CALL	RHEX
	CALL	COMMA
	JP	HIXIY
N22	CP	0C6H
	JR	NZ,N41
	LD	HL,ADDA
	CALL	W0
	CALL	INCHL
	JP	SHEX
N41	CP	0C3H
	JR	NZ,N43
	LD	HL,JPTX
	CALL	W0
N41A	CALL	INCHL
	JP	THEX
N43	CP	18H
	JR	NZ,N44
	LD	HL,JRTX
	JR	S03
N44	CP	38H
	JR	NZ,N45
	LD	HL,JRCTX
	JR	S03
N45	CP	30H
	JR	NZ,N46
	LDZ	HL,JRNCTX
S03	CALL	W0
	CALL	INCHL
	JP	JRADD
N46	CP	28H
	JR	NZ,N47
	LD	HL,JRZTX
	JR	S03
N47	CP	20H
	JR	NZ,N48
	LD	HL,JRNZTX
	JR	S03
N48	CP	0E9H
	JR	NZ,N49
	LD	HL,JPTX
	CALL	W0
	LD	A,'('
	CALL	BYTOUT
	CALL	HIXIY
	LD	A,')'
	JP	BYTOUT
N49	CP	10H
	JR	NZ,N50
	LD	HL,DJNZTX
	JR	S03
N50	CP	0CDH
	JR	NZ,N52
	LD	HL,CALLTX
	CALL	W0
N50A	CALL	INCHL
	JP	THEX
N52	CP	0C9H
	JR	NZ,N55
	LD	HL,RETTX
	JP	W0
N55	CP	0DBH
	JR	NZ,N56
	LD	HL,INAN
	CALL	W0
	CALL	INCHL
	CALL	SHEX
	LD	A,')'
	JP	BYTOUT
N56	CP	0D3H
	JR	NZ,N58
	LD	HL,OUTNA
	CALL	W0
	CALL	INCHL
	CALL	SHEX
	LD	HL,PA
	JP	WRT
N58	CP	0CEH
	JR	NZ,N59
	LD	HL,ADCA
	JR	N63A
N59	CP	0D6H
	JR	NZ,N62
	LD	HL,SUBTX
	JR	N63A
N62	CP	0DEH
	JR	NZ,N63
	LD	HL,SBCA
	JR	N63A
N63	CP	0E6H
	JR	NZ,N66
	LD	HL,ANDTX
N63A	CALL	W0
	CALL	INCHL
	JP	SHEX
N66	CP	0F6H
	JR	NZ,N67
	LD	HL,ORTX
	JR	N63A
N67	CP	0EEH
	JR	NZ,N70
	LD	HL,XORTX
	JR	N63A
N70	CP	0FEH
	JR	NZ,N01
	LD	HL,CPTX
	JR	N63A
N01	AND	199
	CP	6
	JR	NZ,N24
	LD	HL,LDTXT
	CALL	W0
	CALL	REGXT
	CALL	COMMA
	CALL	INCHL
	JP	SHEX
N24	CP	4
	JR	NZ,N42
	LD	HL,INCTX
	CALL	W0
	JP	REGXT
N42	CP	194
	JR	NZ,N51
	LD	HL,JPTX
	CALL	W0
	CALL	CONEXT
	CALL	COMMA
	JP	N41A
N51	CP	196
	JR	NZ,N53
	LD	HL,CALLTX
	CALL	W0
	CALL	CONEXT
	CALL	COMMA
	JP	N50A
N53	CP	192
	JR	NZ,N54
	LD	HL,RETTX
	CALL	W0
	JP	CONEXT
N54	CP	199
	JR	NZ,N71
	LD	HL,RSTTX
	CALL	W0
	LD	HL,(STDIS)
	LD	A,(HL)
	AND	56
	JP	SHEX3
N71	CP	5
	JR	NZ,N11
	LD	HL,DECTX
	CALL	W0
	JP	REGXT
N11	LD	A,(HL)
	AND	207
	CP	1
	JR	NZ,N15
	LD	HL,LDTXT
	CALL	W0
	CALL	PEXT
	CALL	INCHL
	CALL	COMMA
	JP	THEX
N15	CP	197
	JR	NZ,N16
	LD	HL,PUSHTX
	JR	N16A
	RET
N16	CP	193
	JR	NZ,N21
	LD	HL,POPTX
N16A	CALL	W0
	JP	QEXT
N21	LD	A,(HL)
	AND	248
	CP	128
	JR	NZ,N57
	LD	HL,ADDA
	CALL	W0
	JP	RGEXT
N57	CP	136
	JR	NZ,N60
	LD	HL,ADCA
	JR	N64A
N60	CP	144
	JR	NZ,N61
	LD	HL,SUBTX
	JR	N64A
N61	CP	152
	JR	NZ,N64
	LD	HL,SBCA
	JR	N64A
N64	CP	160
	JR	NZ,N65
	LD	HL,ANDTX
N64A	CALL	W0
	JP	RGEXT
N65	CP	176
	JR	NZ,N68
	LD	HL,ORTX
	JR	N64A
N68	CP	168
	JR	NZ,N69
	LD	HL,XORTX
	JR	N64A
N69	CP	184
	JR	NZ,N34
	LD	HL,CPTX
	JR	N64A
N34	LD	A,(HL)
	AND	207
	CP	9
	JR	NZ,N35
	LD	HL,ADTX
	CALL	W0
	CALL	HIXIY
	CALL	COMMA
	JP	PEXT
N34A	CALL	W0
	JP	PEXT
N35	CP	3
	JR	NZ,N36
	LD	HL,INCTX
	JR	N34A
N36	CP	11
	JR	NZ,N72
	LD	HL,DECTX
	JR	N34A
N72	LD	A,(HL)
	CP	0CBH
	JP	NZ,EDSTUF
	CALL	INCHL
	LD	A,(TYPE)
	OR	A
	CALL	NZ,INCHL
	LD	A,(HL)
	AND	248
	CP	0
	JR	NZ,N73
	LD	HL,RLCTX
	JR	N76A
N73	CP	16
	JR	NZ,N74
	LD	HL,RLTX
	JR	N76A
N74	CP	8
	JR	NZ,N75
	LD	HL,RRCTX
	JR	N76A
N75	CP	24
	JR	NZ,N76
	LD	HL,RRTX
	JR	N76A
N76	CP	32
	JR	NZ,N77Z
	LD	HL,SLATX
N76A	CALL	W0
	LD	A,(TYPE)
	OR	A
	JR	NZ,N76B
	JP	RGEXT
N76B	CALL	TDEC
	CALL	RIXIY
	JP	INCHL
N77Z	CP	48
	JR	NZ,N77
	LD	HL,SLSTX
	JR	N76A
N77	CP	40
	JR	NZ,N78
	LD	HL,SRATX
	JR	N76A
N78	CP	56
	JR	NZ,N79
	LD	HL,SRLTX
	JR	N76A
N79	LD	A,(HL)
	AND	192
	CP	64
	JR	NZ,N80
	LD	HL,BITTX
	JR	N80A
N80	CP	192
	JR	NZ,N81
	LD	HL,SETTX
N80A	CALL	W0
	CALL	BEXT
	LD	A,(TYPE)
	OR	A
	JP	Z,RGEXT
	JR	N76B
N81	CP	128
	JP	NZ,NOFIND
	LD	HL,RESTX
	JR	N80A
EDSTUF	LD	A,(TYPE)
	OR	A
	JR	Z,EDS10
	LD	A,(HL)
	CP	0F9H
	JR	NZ,IXS10
	LD	HL,SPTX
	JR	IXS20
IXS10	CP	0E3H
	JP	NZ,NOFIND
	LD	HL,EXSP
IXS20	CALL	W0
	JP	IXIY
EDS10	LD	A,(HL)
	CP	0EDH
	JP	NZ,NOFIND
	CALL	INCHL
	LD	A,(HL)
	LD	HL,EDTBL
	LD	B,26
	LD	DE,EDTXT
	CALL	MST
	RET	Z
	LD	A,(HL)
	AND	207
	CP	75
	JR	NZ,E05
	LD	HL,LDTXT
	CALL	W0
	CALL	PEXT
	CALL	COMMA
	CALL	INCHL
	JP	RHEX
E05	CP	67
	JR	NZ,E18
	LD	HL,LDTXT
	CALL	W0
	CALL	INCHL
	CALL	RHEX
	CALL	TDEC
	CALL	COMMA
	CALL	PEXT
	CALL	INCHL
	JP	INCHL
E18	LD	A,(HL)
	AND	207
	CP	74
	JR	NZ,E19
	LD	HL,ADCHL
	JR	E19A
E19	CP	66
	JR	NZ,E22
	LD	HL,SBCHL
E19A	CALL	W0
	JP	PEXT
E22	LD	A,(HL)
	CP	4DH
	JR	NZ,E23
	LD	HL,RETITX
E22A	EQU	$
	JP	W0
E23	CP	45H
	JR	NZ,E25
	LD	HL,RETNTX
	JR	E22A
E25	AND	199
	CP	64
	JR	NZ,E29
	LD	HL,INTX
	CALL	W0
	CALL	REGXT
	CALL	COMMA
	LD	HL,RC
	JP	WRT
E29	LD	A,(HL)
	AND	199
	CP	65
	JP	NZ,NOFIND
	LD	HL,OUTTX
	CALL	W0
	JP	REGXT
W0	DEC	HL	LD	A,(PRINT)
	OR	A
	RET	Z
	JR	WAZA
WRT	EQU	$
	LD	A,(PRINT)
	OR	A
	RET	Z
WRITE	LD	A,(HL)
	CP	03
	RET	Z
	CP	09
	JR	NZ,W01
WAZA	CALL	WAZ
	JR	W02
WAZ	LD	A,(4020H)
	AND	63
	LD	B,A
	AND	56
	OR	A
	JR	NZ,W04
	ADD	A,16
	JR	W05
W04	ADD	A,8
W05	SUB	B
	LD	B,A
TB1	CALL	SPCD
	DJNZ	TB1
	RET
W01	LD	A,(HL)
	CALL	BYTOUT
W02	INC	HL
	CP	0DH
	RET	Z
	JR	WRITE
BYTOUT	PUSH	AF
BT1A	LD	A,(PRINT)
	OR	A
	JR	NZ,BT1
BT2	POP	AF
	RET
BT1	POP	AF
	CALL	WR
	PUSH	AF
	LD	A,(PFG)
	OR	A
	JR	Z,BT2
	POP	AF
	JP	PNTIT
REGPRT	CP	4
	JR	Z,UNDC10
	CP	5
	JR	NZ,NREG
UNDC10	LD	C,A
	LD	A,(TYPE)
	OR	A
	LD	A,C
	JR	Z,NREG
	LD	A,(TYPE)
	LD	HL,HXTX
	CP	0FDH
	JR	NZ,UNDC20
	INC	HL
	INC	HL
	INC	HL
	INC	HL
UNDC20	LD	A,C
	CP	5
	JR	NZ,UNDC30
	INC	HL
	INC	HL
UNDC30	LD	A,(HL)
	CALL	BYTOUT
	INC	HL
	LD	A,(HL)
	JP	BYTOUT
NREG	CP	6
	JR	NZ,S04
	LD	A,(TYPE)
	OR	A
	JP	NZ,RIXIY
	LD	HL,RHL
	JP	WRT
S04	LD	C,A
	LD	B,0
	LD	HL,REG1
	ADD	HL,BC
	LD	A,(HL)
	JP	BYTOUT
REGXT	LD	HL,(STDIS)
	LD	A,(HL)
REGXTA	AND	56
	SRL	A
	SRL	A
	SRL	A
	JP	REGPRT
RGEXT	LD	HL,(STDIS)
	LD	A,(HL)
RGEXTA	AND	7
	JR	REGPRT
INCHL	LD	HL,(STDIS)
	INC	HL
	LD	(STDIS),HL
	RET
SHEX	LD	HL,(STDIS)
SHEX1	LD	A,(HL)
SHEX3	PUSH	AF
	SRL	A
	SRL	A
	SRL	A
	SRL	A
	CALL	HEXIT
	POP	AF
	AND	15
HEXIT	ADD	A,30H
	CP	3AH
	JR	C,S01
	ADD	A,7
S01	JP	BYTOUT
RHEX	LD	A,'('
	CALL	BYTOUT
	CALL	THEX
	LD	A,')'
	JP	BYTOUT
THEX	EQU	$
	INC	HL
	CALL	SHEX1
	DEC	HL
	CALL	SHEX1
	JP	INCHL
HIXIY	LD	B,0
	LD	C,4
	LD	HL,REG2
	JP	NS40
PEXT	LD	HL,(STDIS)
	LD	A,(HL)
	AND	48
	SRL	A
	SRL	A
	SRL	A
	LD	C,A
	LD	B,0
	LD	HL,REG3
SS10	CP	4
	JR	Z,NS40
S02	ADD	HL,BC
	LD	A,(HL)
	CALL	BYTOUT
	INC	HL
	LD	A,(HL)
	JP	BYTOUT
NS40	LD	A,(TYPE)
	OR	A
	JR	Z,S02
	JP	IXIY
QEXT	LD	HL,(STDIS)
	LD	A,(HL)
	AND	48
	SRL	A
	SRL	A
	SRL	A
	LD	C,A
	LD	B,0
	LD	HL,REG2
	JR	SS10
CONEXT	LD	HL,(STDIS)
	LD	A,(HL)
	AND	56
	SRL	A
	SRL	A
	LD	C,A
	LD	B,0
	LD	HL,CC
	JR	S02
BEXT	LD	HL,(STDIS)
	LD	A,(HL)
	AND	56
	SRL	A
	SRL	A
	SRL	A
	ADD	A,30H
	CALL	BYTOUT
	JP	COMMA
JRADD	LD	HL,(STDIS)
	LD	A,(HL)
	LD	C,A
	LD	B,0
	INC	BC
	LD	A,C
	BIT	7,A
	JR	Z,JA1
	DEC	H
JA1	ADD	HL,BC
	JP	REGHEX
TDEC	LD	HL,(STDIS)
	DEC	HL
	DEC	HL
	LD	(STDIS),HL
	RET
RIXIY	LD	A,'('
	CALL	BYTOUT
	LD	A,(TYPE)
	CP	0DDH
	LD	HL,IXPL
	JR	Z,IY2
IY1	LD	HL,IYPL
IY2	CALL	WRT
	CALL	INCHL
	CALL	SHEX
	LD	A,')'
	JP	BYTOUT
IXIY	LD	A,(TYPE)
	CP	0DDH
	LD	HL,IXTX
	JR	Z,IY4
	LD	HL,IYTX
IY4	JP	WRT
REGHEX	EQU	$
RHDSK	LD	A,H
	SRL	A
	SRL	A
	SRL	A
	SRL	A
	CALL	HEXIT
	LD	A,H
	AND	15
	CALL	HEXIT
	LD	A,L
	SRL	A
	SRL	A
	SRL	A
	SRL	A
	CALL	HEXIT
	LD	A,L
	AND	15
	JP	HEXIT
DECHL	LD	HL,(STDIS)
	DEC	HL
	LD	(STDIS),HL
	RET
COMMA	LD	A,','
	JP	BYTOUT
SPCD	EQU	$
	LD	A,(PRINT)
	OR	A
	RET	Z
SPCD1	LD	A,32
	CALL	WR
	LD	A,(PFG)
	OR	A
	RET	Z
	LD	A,32
	JP	PNTIT
NOFIND	LD	HL,(S1)
	LD	(STDIS),HL
	LD	HL,NOINST
	CALL	W0
	JP	SHEX
MST	LD	C,B
MTEST	CP	(HL)
	JR	Z,ME01
	INC	HL
	DJNZ	MTEST
	LD	HL,(STDIS)
	LD	A,1
	OR	A
	RET
ME01	LD	A,C
	SUB	B
	INC	A
	EX	DE,HL
	LD	E,A
	LD	A,3
	LD	BC,0
ME02	CPIR
	DEC	E
	JR	NZ,ME02
	CALL	W0
	LD	HL,(STDIS)
	XOR	A
	RET
WR	PUSH	DE
	CALL	33H
	POP	DE
	RET
PNTIT	PUSH	DE
	CALL	3BH
	POP	DE
	RET
TYPE	DEFB	0
PRINT	DEFB	0
PFG	DEFB	0
IXPL	DEFM	'IX+'
	DEFB	3
IYPL	DEFM	'IY+'
	DEFB	3
IXTX	DEFM	'IX'
	DEFB	3
IYTX	DEFM	'IY'
	DEFB	3
NOINST	DEFM	'DEFB'
	DEFB	9
	DEFB	3
SBITBL	DEFW	1A0AH
	DEFW	1202H
	DEFW	0EBF9H
	DEFW	0D908H
	DEFW	27E3H
	DEFW	3F2FH
	DEFW	0037H
	DEFW	0F376H
	DEFW	7FBH
	DEFW	0F17H
	DEFB	1FH
EDTBL	DEFW	5F57H
	DEFW	4F47H
	DEFW	0B0A0H
	DEFW	0B8A8H
	DEFW	0B1A1H
	DEFW	0B9A9H
	DEFW	4644H
	DEFW	5E56H
	DEFW	676FH
	DEFW	0B2A2H
	DEFW	0BAAAH
	DEFW	0B3A3H
	DEFW	0BBABH
REG1	DEFM	'BCDEHL A'
REG2	DEFM	'BCDEHLAF'
REG3	DEFM	'BCDEHLSP'
REG4	DEFM	'BCDEIXSP'
REG5	DEFM	'BCDEIYSP'
CC	DEFM	'NZ'
	DEFB	0
	DEFM	'ZNC'
	DEFB	0
	DEFM	'CPOPE'
	DEFB	0
	DEFB	'P'
	DEFB	0
	DEFB	'M'
LDTXT	DEFM	'LD'
	DEFB	9
	DEFB	3
RHL	DEFM	'(HL)'
	DEFB	3
LDA	DEFM	'LD'
	DEFB	9
	DEFM	'A,'
	DEFB	3
PA	DEFM	'),A'
	DEFB	3
HLNN	DEFM	'LD'
	DEFB	9
	DEFM	'HL,'
	DEFB	3
PHL	DEFM	',HL'
	DEFB	3
PUSHTX	DEFM	'PUSH'
	DEFB	9
	DEFB	3
POPTX	DEFM	'POP'
	DEFB	9
	DEFB	3
ADDA	DEFM	'ADD'
	DEFB	9
	DEFM	'A,'
	DEFB	3
INCTX	DEFM	'INC'
	DEFB	9
	DEFB	3
ADDTX	DEFM	'ADD'
	DEFB	9
	DEFM	'HL,'
	DEFB	3
DECTX	DEFM	'DEC'
	DEFB	9
	DEFB	3
JPTX	DEFM	'JP'
	DEFB	9
	DEFB	3
JRTX	DEFM	'JR'
	DEFB	9
	DEFB	3
JRCTX	DEFM	'JR'
	DEFB	9
	DEFM	'C,'
	DEFB	3
JRNCTX	DEFM	'JR'
	DEFB	9
	DEFM	'NC,'
	DEFB	3
JRZTX	DEFM	'JR'
	DEFB	9
	DEFM	'Z,'
	DEFB	3
JRNZTX	DEFM	'JR'
	DEFB	9
	DEFM	'NZ,'
	DEFB	3
DJNZTX	DEFM	'DJNZ'
	DEFB	9
	DEFB	3
CALLTX	DEFM	'CALL'
	DEFB	9
	DEFB	3
RETTX	DEFM	'RET'
	DEFB	9
	DEFB	3
RSTTX	DEFM	'RST'
	DEFB	9
	DEFB	3
INAN	DEFM	'IN'
	DEFB	9
	DEFM	'A,('
	DEFB	3
OUTNA	DEFM	'OUT'
	DEFB	9
	DEFM	'('
	DEFB	3
ADCA	DEFM	'ADC'
	DEFB	9
	DEFM	'A,'
	DEFB	3
SUBTX	DEFM	'SUB'
	DEFB	9
	DEFB	3
SBCA	DEFM	'SBC'
	DEFB	9
	DEFM	'A,'
	DEFB	3
ANDTX	DEFM	'AND'
	DEFB	9
	DEFB	3
ORTX	DEFM	'OR'
	DEFB	9
	DEFB	3
XORTX	DEFM	'XOR'
	DEFB	9
	DEFB	3
CPTX	DEFM	'CP'
	DEFB	9
	DEFB	3
RLCTX	DEFM	'RLC'
	DEFB	9
	DEFB	3
RLTX	DEFM	'RL'
	DEFB	9
	DEFB	3
RRCTX	DEFM	'RRC'
	DEFB	9
	DEFB	3
RRTX	DEFM	'RR'
	DEFB	9
	DEFB	3
SLATX	DEFM	'SLA'
	DEFB	9
	DEFB	3
SLSTX	DEFM	'SLS'
	DEFB	9
	DEFB	3
HXTX	DEFM	'HXLXHYLY'
SRLTX	DEFM	'SRL'
	DEFB	9
	DEFB	3
SRATX	DEFM	'SRA'
	DEFB	9
	DEFB	3
BITTX	DEFM	'BIT'
	DEFB	9
	DEFB	3
SETTX	DEFM	'SET'
	DEFB	9
	DEFB	3
RESTX	DEFM	'RES'
	DEFB	9
	DEFB	3
ADCHL	DEFM	'ADC'
	DEFB	9
	DEFM	'HL,'
	DEFB	3
SBCHL	DEFM	'SBC'
	DEFB	9
	DEFM	'HL,'
	DEFB	3
RETITX	DEFM	'RETI'
	DEFB	3
RETNTX	DEFM	'RETN'
	DEFB	3
INTX	DEFM	'IN'
	DEFB	9
	DEFB	3
RC	DEFM	'(C)'
	DEFB	9
	DEFB	3
OUTTX	DEFM	'OUT'
	DEFB	9
	DEFM	'(C),'
	DEFB	3
SPTX	DEFM	'LD'
	DEFB	9
	DEFM	'SP,'
	DEFB	3
EXSP	DEFM	'EX'
	DEFB	9
	DEFM	'(SP),'
	DEFB	3
ADTX	DEFM	'ADD'
	DEFB	9
	DEFB	3
LHL	DEFM	'LD'
	DEFB	9
	DEFM	'(HL),'
SBITXT	DEFB	3
	DEFM	'LD'
	DEFB	9
	DEFM	'A,(BC)'
	DEFB	3
	DEFM	'LD'
	DEFB	9
	DEFM	'A,(DE)'
	DEFB	3
	DEFM	'LD'
	DEFB	9
	DEFM	'(BC),A'
	DEFB	3
	DEFM	'LD'
	DEFB	9
	DEFM	'(DE),A'
	DEFB	3
	DEFM	'LD'
	DEFB	9
	DEFM	'SP,HL'
	DEFB	3
	DEFM	'EX'
	DEFB	9
	DEFM	'DE,HL'
	DEFB	3
	DEFM	'EX'
	DEFB	9
	DEFM	'AF,AF'
	DEFB	27H
	DEFB	3
	DEFM	'EXX'
	DEFB	3
	DEFM	'EX'
	DEFB	9
	DEFM	'(SP),HL'
	DEFB	3
	DEFM	'DAA'
	DEFB	3
	DEFM	'CPL'
	DEFB	3
	DEFM	'CCF'
	DEFB	3
	DEFM	'SCF'
	DEFB	3
	DEFM	'NOP'
	DEFB	3
	DEFM	'HALT'
	DEFB	3
	DEFM	'DI'
	DEFB	3
	DEFM	'EI'
	DEFB	3
	DEFM	'RLCA'
	DEFB	3
	DEFM	'RLA'
	DEFB	3
	DEFM	'RRCA'
	DEFB	3
	DEFM	'RRA'
EDTXT	DEFB	3
	DEFM	'LD'
	DEFB	9
	DEFM	'A,I'
	DEFB	3
	DEFM	'LD'
	DEFB	9
	DEFM	'A,R'
	DEFB	3
	DEFM	'LD'
	DEFB	9
	DEFM	'I,A'
	DEFB	3
	DEFM	'LD'
	DEFB	9
	DEFM	'R,A'
	DEFB	3
	DEFM	'LDI'
	DEFB	3
	DEFM	'LDIR'
	DEFB	3
	DEFM	'LDD'
	DEFB	3
	DEFM	'LDDR'
	DEFB	3
	DEFM	'CPI'
	DEFB	3
	DEFM	'CPIR'
	DEFB	3
	DEFM	'CPD'
	DEFB	3
	DEFM	'CPDR'
	DEFB	3
	DEFM	'NEG'
	DEFB	3
	DEFM	'IM'
	DEFB	9
	DEFB	'0'
	DEFB	3
	DEFM	'IM'
	DEFB	9
	DEFB	'1'
	DEFB	3
	DEFM	'IM'
	DEFB	9
	DEFB	'2'
	DEFB	3
	DEFM	'RLD'
	DEFB	3
	DEFM	'RRD'
	DEFB	3
	DEFM	'INI'
	DEFB	3
	DEFM	'INIR'
	DEFB	3
	DEFM	'IND'
	DEFB	3
	DEFM	'INDR'
	DEFB	3
	DEFM	'OUTI'
	DEFB	3
	DEFM	'OTIR'
	DEFB	3
	DEFM	'OUTD'
	DEFB	3
	DEFM	'OTDR'
	DEFB	3
STDIS	DEFW	0
S1	DEFW	0
NMDIS	DEFW	0FFFFH
BARFLG	DEFB	0
;
TRAKS6 ;::::::::::::::::::::::::::::::::::::::::::::::::::::::::
; TRAK6  5/31/82
; Utilities for Penram and Trakcess.
;
;-------------------------------
; Clear CTRL actions.
;
CTLCLR	EQU	$
	CALL	MSGCLR
	XOR	A
	LD	(INSFLG),A
	LD	(LCONT),A
	LD	(FCONT),A
	RET
;
;-------------------------------
; Abort because of no room at top.
;
NOROOM	EQU	$
	CALL	CTLCLR
	LD	HL,ML14
	LD	(DISPOS),HL
	LD	HL,NORMSG
	CALL	OUTZER
	CALL	WTKYDN
	CALL	WTKYUP
	RET
;
;-------------------------------
; Clear message area.
;
MSGCLR	EQU	$
	LD	DE,ML14
	LD	(DISPOS),DE
	LD	HL,BLANK9
	CALL	OUTZER
	LD	DE,ML15
	LD	(DISPOS),DE
	LD	HL,BLANK9
	CALL	OUTZER
	LD	DE,ML16
	LD	(DISPOS),DE
	LD	HL,BLANK9
	CALL	OUTZER
	RET
;
;-------------------------------
; Clear Msg. lines 5,6.
;
C56	EQU	$
	LD	HL,ML5
	LD	(DISPOS),HL
	LD	HL,BLANK9
	CALL	OUTZER
	LD	HL,ML6
	LD	(DISPOS),HL
	LD	HL,BLANK9
	CALL	OUTZER
	RET
;
;-------------------------------
; Clear msg. lines 6,7,8.
;
C678	EQU	$
	LD	HL,ML6
	LD	(DISPOS),HL
	LD	HL,BLANK9
	CALL	OUTZER
	LD	HL,ML7
	LD	(DISPOS),HL
	LD	HL,BLANK9
	CALL	OUTZER
	LD	HL,ML8
	LD	(DISPOS),HL
	LD	HL,BLANK9
	CALL	OUTZER
	RET
;
;-------------------------------
; Clear msg. line 16.
;
CSIXTN	EQU	$
	LD	HL,ML16
	LD	(DISPOS),HL
	LD	HL,BLANK9
	CALL	OUTZER
	RET
;
;-------------------------------
; Print MATCH FOUND.
;
PTMFND	EQU	$
	LD	HL,ML14
	LD	(DISPOS),HL
	LD	HL,MCHMSG
	CALL	OUTZER
	RET
;
;-------------------------------
; Print MATCH NOT FOUND.
;
PTNFND	EQU	$
	LD	HL,ML14
	LD	(DISPOS),HL
	LD	HL,NOMMSG
	CALL	OUTZER
	RET
;
	IF TRAK	;****
;-------------------------------
; Print CRC IS:
;
PTCRC	EQU	$
	CALL	MSGCLR
	LD	HL,ML14
	LD	(DISPOS),HL
	LD	HL,CRCMSG
	CALL	OUTZER
	RET
;
	ENDIF	;****
;-------------------------------
; Print CHECKSUM
;
PTCHEK	EQU	$
	CALL	MSGCLR
	LD	HL,ML14
	LD	(DISPOS),HL
	LD	HL,CHKMSG
	CALL	OUTZER
	RET
;
;-------------------------------
; Print FIND
;
PTLOOK	EQU	$
	CALL	MSGCLR
	LD	HL,ML14
	LD	(DISPOS),HL
	LD	HL,LOKMSG
	CALL	OUTZER
	RET
;
;-------------------------------
;  Print INSERT
;
PTINSR	EQU	$
	CALL	MSGCLR
	LD	HL,ML14
	LD	(DISPOS),HL
	LD	HL,INSMSG
	CALL	OUTZER
	RET
;
;-------------------------------
; Print FILL
;
PTFILL	EQU	$
	CALL	MSGCLR
	LD	HL,ML14
	LD	(DISPOS),HL
	LD	HL,FILMSG
	CALL	OUTZER
	RET
;
;-------------------------------
; Print CONTINUE
;
PTCONT	EQU	$
	LD	HL,ML16
	LD	(DISPOS),HL
	LD	HL,CONMSG
	CALL	OUTZER
	RET
;
;-------------------------------------------------------
BYTDIS	EQU	$
	PUSH	HL
	LD	HL,(DISPOS)
	LD	(HL),A
	INC	HL
	LD	(DISPOS),HL
	POP	HL
	RET
;
;-------------------------------
FRMBYT	LD	A,(HL)
	CALL	VALHEX
	RET	C
	LD	E,A
	DEC	HL
	LD	A,(HL)
	CALL	VALHEX
	RET	C
	RLCA
	RLCA
	RLCA
	RLCA
	OR	E
	DEC	HL
	RET
;
;-------------------------------
CURINC	EQU	$
	PUSH	HL
	LD	HL,(EDCUR)
	INC	HL
	LD	(DISPOS),HL
	POP	HL
	RET
;
;-------------------------------
CURSUP	LD	A,(DWNCUR)
	AND	A
	JR	Z,CONTU1
	DEC	A
	LD	(DWNCUR),A
	RET
;
CONTU1	EQU	$
	LD	HL,(EDCUR)
	LD	(HL),80H
	LD	A,(LSTARW)
	AND	A
	JR	Z,CONTU2
	LD	BC,-272
	LD	HL,(ADDR)
	ADD	HL,BC
	LD	(ADDR),HL
CONTU2	LD	HL,(EDCUR)
	LD	BC,64
	ADD	HL,BC
	LD	(EDCUR),HL
	LD	A,15
	LD	HL,3F80H
	LD	DE,3FC0H
MVLOPU	LD	BC,37H
	LDIR
	LD	BC,-119
	ADD	HL,BC
	EX	DE,HL
	ADD	HL,BC
	EX	DE,HL
	DEC	A
	JR	NZ,MVLOPU
	LD	HL,CRTR1
	LD	(DISPOS),HL
	LD	HL,(ADDR)
	CALL	MAKSTR
	LD	HL,STRPLC
	LD	B,55
	CALL	OUTSTR
	LD	BC,-16
	LD	HL,(ADDR)
	ADD	HL,BC
	LD	(ADDR),HL
	LD	HL,(HOMADD)
	ADD	HL,BC
	LD	(HOMADD),HL
	XOR	A
	LD	(LSTARW),A
	RET
;
;-------------------------------
CURSDN	LD	A,(DWNCUR)
	CP	15
	JR	Z,CONTD1
	INC	A
	LD	(DWNCUR),A
	RET
;
CONTD1	LD	HL,(EDCUR)
	LD	(HL),80H
	LD	A,(LSTARW)
	AND	A
	JR	NZ,CONTD2
	LD	BC,272
	LD	HL,(ADDR)
	ADD	HL,BC
	LD	(ADDR),HL
CONTD2	LD	HL,(EDCUR)
	LD	BC,-64
	ADD	HL,BC
	LD	(EDCUR),HL
	LD	A,15
	LD	HL,CRTR2
	LD	DE,CRTR1
MVLOPD	LD	BC,37H
	LDIR
	LD	BC,9
	ADD	HL,BC
	EX	DE,HL
	ADD	HL,BC
	EX	DE,HL
	DEC	A
	JR	NZ,MVLOPD
	LD	HL,CRTR16
	LD	(DISPOS),HL
	LD	HL,(ADDR)
	CALL	MAKSTR
	LD	HL,STRPLC
	LD	B,55
	CALL	OUTSTR
	LD	BC,16
	LD	HL,(ADDR)
	ADD	HL,BC
	LD	(ADDR),HL
	LD	HL,(HOMADD)
	ADD	HL,BC
	LD	(HOMADD),HL
	LD	A,1
	LD	(LSTARW),A
	RET
;
;-------------------------------
MAKSTR	PUSH	HL
	PUSH	HL
	POP	IX
	POP	BC
	LD	HL,STRPLC+3
	CALL	BSTRNG
	LD	HL,STRPLC+4
	LD	(HL),':'
	INC	HL
	LD	(HL),' '
	INC	HL
	LD	B,16
CHRBLK	LD	(HL),' '
	LD	A,(ULOMRK)
	OR	A
	JR	Z,NOTLO
	LD	DE,(LOMADR)
	DEFW	7CDDH		;LD  A,HX
	CP	D
	JR	NZ,NOTLO
	DEFW	7DDDH		;LD  A,LX
	CP	E
	JR	NZ,NOTLO
	LD	(HL),LOMARK
	JR	DUNMRK
;
NOTLO	EQU	$
	LD	A,(UHIMRK)
	OR	A
	JR	Z,NOTHI
	LD	DE,(HIMADR)
	INC	DE
	DEFW	7CDDH		;LD  A,HX
	CP	D
	JR	NZ,NOTHI
	DEFW	7DDDH		;LD  A,LX
	CP	E
	JR	NZ,NOTHI
	LD	(HL),HIMARK
	JR	DUNMRK
;
NOTHI	EQU	$
	LD	DE,(TPMADR)
	INC	DE
	DEFW	7CDDH		;LD  A,HX
	CP	D
	JR	NZ,DUNMRK
	DEFW	7DDDH		;LD  A,LX
	CP	E
	JR	NZ,DUNMRK
	LD	(HL),TPMARK
;
DUNMRK	INC	HL
	LD	C,(IX+0)
	LD	A,(HATYPE)
	AND	A
	JR	NZ,ACHAR
	CALL	ASCII
	LD	(HL),D
	INC	HL
	LD	(HL),E
	JR	CHRDN
ACHAR	LD	(HL),C
	INC	HL
	LD	(HL),' '
CHRDN	INC	IX
	INC	HL
	DJNZ	CHRBLK
	LD	(HL),0AAH
	RET
;
;-------------------------------
BSTRNG	CALL	ASCII
	LD	(HL),E
	DEC	HL
	LD	(HL),D
	DEC	HL
	LD	C,B
	CALL	ASCII
	LD	(HL),E
	DEC	HL
	LD	(HL),D
	RET
;
;-------------------------------
ASCII	LD	A,C
	AND	0FH
	ADD	A,90H
	DAA
	ADC	A,40H
	DAA
	LD	E,A
	LD	A,C
	RRCA
	RRCA
	RRCA
	RRCA
	AND	0FH
	ADD	A,90H
	DAA
	ADC	A,40H
	DAA
	LD	D,A
	RET
;
;-------------------------------
BINSTR	EQU	$
	LD	C,11H
	CALL	BCDA
	LD	(IX+4),C
	LD	(IX+3),B
	LD	C,11H
	CALL	BCDA
	LD	(IX+2),C
	LD	(IX+1),B
	LD	A,L
	ADD	A,30H
	LD	(IX+0),A
	RET
;
BCDA	XOR	A
CVT	DEC	C
	JR	Z,BCDA1
	ADD	HL,HL
	ADC	A,A
	DAA
	JR	NC,CVT
	INC	HL
	JR	CVT
BCDA1	LD	B,A
	AND	0FH
	OR	30H
	LD	C,A
	LD	A,B
	RRCA
	RRCA
	RRCA
	RRCA
	AND	0FH
	OR	30H
	LD	B,A
	RET
;
;-------------------------------
OUTSTR	EQU	$
	LD	A,(HL)
	CALL	BYTDIS
	INC	HL
	DJNZ	OUTSTR
	RET
;
;-------------------------------
OUTZER	EQU	$
	LD	A,(HL)
	OR	A
	RET	Z
	CALL	BYTDIS
	INC	HL
	JR	OUTZER
;
;-------------------------------
POSMRK	EQU	$
	LD	(ATADD),HL
	LD	DE,-102
	ADD	HL,DE
	LD	(HOMADD),HL
	LD	A,6
	LD	(DWNCUR),A
	LD	(RGTCUR),A
	RET	
;
;-------------------------------
; Messages
;
REFMSG	DEFM	'REF'
	DEFB	0
CRSMSG	DEFM	'CRSR'
	DEFB	0
STRMSG	DEFM	'LOW'
	DEFB	0
ENDMSG	DEFM	'HIGH'
	DEFB	0
TOPMSG	DEFM	'TOP'
	DEFB	0
LIMSG	DEFM	'LIM'
	DEFB	0
FILMSG	DEFM	'FILL'
	DEFB	0
LOKMSG	DEFM	'FIND'
	DEFB	0
BYTMSG	DEFM	'BYTE?    '
	DEFB	0
INSMSG	DEFM	' INSERT '
	DEFB	0
;
	IF TRAK	;****
CRCMSG	DEFM	'  CRC=   '
	DEFB	0
	ENDIF	;****
;
CHKMSG	DEFM	'CHECKSUM='
	DEFB	0
MCHMSG	DEFM	'MATCH    '
	DEFB	0
NOMMSG	DEFM	'NO MATCH '
	DEFB	0
NORMSG	DEFM	' NO ROOM '
	DEFB	0
CONMSG	DEFM	'(CONT...)'
	DEFB	0
BLANK9	DEFM	'         '
	DEFB	0
BARMSG	DEFB	8CH,8CH,8CH,8CH,8CH,8CH,8CH,8CH,8CH
	DEFB	0
;
;-------------------------------
; Checks if HL points to ROM.  Return NZ if so.
;
INROM	EQU	$
	LD	A,(HL)
	LD	B,A
	CPL
	LD	(HL),A
	LD	A,(HL)
	CPL
	CP	B
	LD	(HL),B
	RET
;
;-------------------------------
; Get two bytes at STRPLC.  Show at (DE).
;
GET2BT	EQU	$
	LD	(DISPOS),DE
	LD	HL,BYTMSG
	CALL	OUTZER
	LD	HL,6
	ADD	HL,DE
	LD	(INSHOW),HL	;Show at DE+6.
	LD	HL,STRPLC
	LD	(INBLD),HL
	LD	A,2		;Take in two hex char.
	LD	(NGET),A
GTB2	LD	A,(KB1TO8)
	OR	A
	JR	NZ,GTB2
	LD	BC,8000
	CALL	MYDELY
	CALL	HEXLIM
	RET
;
;-------------------------------
; Loops until any key pressed, then returns.
;
WTKYDN	EQU	$
	PUSH	AF
	PUSH	BC
WTK1	LD	A,(KB1TO8)
	OR	A
	JR	Z,WTK1
	LD	BC,5000
	CALL	MYDELY
	LD	A,(KB1TO8)
	OR	A
	JR	Z,WTK1
	POP	BC
	POP	AF
	RET
;
;-------------------------------
; Waits until all keys are up.
;
WTKYUP	EQU	$
	PUSH	AF
	PUSH	BC
WTKU1	LD	A,(KB1TO8)
	OR	A
	JR	NZ,WTKU1
	LD	BC,5000
	CALL	MYDELY
	LD	A,(KB1TO8)
	OR	A
	JR	NZ,WTKU1
	POP	BC
	POP	AF
	RET
;
;-------------------------------
; Moves BYTED-TPMADR up by one byte if there's room
;  below MEMLIM.  Else returns carry set.
;
INSRTB	EQU	$
	LD	HL,(MEMLIM)
	LD	DE,(TPMADR)
	CALL	CPHLDE
	JR	C,RCHLIM	;Go if TPMADR >= MEMLIM
	JR	Z,RCHLIM
;
INSOK	EQU	$
	INC	DE
	LD	(TPMADR),DE
	DEC	DE
	LD	(BUF07),DE
	LD	HL,(BYTED)
	LD	(BUF05),HL
	INC	HL
	CALL	BLKMOV
	LD	HL,(BYTED)
	LD	DE,(LOMADR)
	INC	DE
	CALL	CPHLDE
	JR	NC,INSMVH	;Go if BYTED > LOMADR
	LD	(LOMADR),DE	;Move Low Marker up.
;
INSMVH	LD	DE,(HIMADR)
	INC	DE
	CALL	CPHLDE
	JR	NC,INBTDN	;Go if BYTED > HIMADR
	LD	(HIMADR),DE	;Move High Marker up.
;
INBTDN	EQU	$
	XOR	A		;CCF
	JR	INBXIT
;
RCHLIM	EQU	$
	SCF
;
INBXIT	EQU	$
	RET
;
;-------------------------------
; Delete block at (LDLADR)-(HDLADR), end at (TPMADR).
; Fills in above (TPMADR) with zeros.  Modifies (TPMADR).
;
BLKDEL	EQU	$
	LD	HL,(HDLADR)
	LD	DE,(MEMLIM)
	CALL	CPHLDE
	JR	NZ,NTSPC1	;Go if not special case
	LD	HL,(LDLADR)	;Here if HDLADR=MEMLIM
	LD	DE,(HDLADR)
	XOR	A
	CALL	FILL
	JR	BDLDUN
;
NTSPC1	LD	DE,(TPMADR)	;Maybe special case of
	CALL	CPHLDE		;  HDLADR = TPMADR.
	JR	NZ,BDOK		;Go if not.
	LD	(HL),0
	DEC	DE
	LD	(TPMADR),DE
	JR	BDLDUN
;
BDOK	INC	HL
	LD	(BUF05),HL
	LD	BC,(LDLADR)
	XOR	A
	SBC	HL,BC
	LD	(DSTNCE),HL
	LD	HL,(TPMADR)
	LD	(BUF07),HL
	LD	HL,(LDLADR)
	CALL	BLKMOV
	LD	HL,(TPMADR)
	LD	BC,(DSTNCE)
SDLP1	LD	(HL),0
	DEC	HL
	DEC	BC
	LD	A,B
	OR	C
	JR	NZ,SDLP1
	LD	(TPMADR),HL
;
BDLDUN	RET
;
;---------------
; Prompt user for byte to be used in Find or Zero
; operation.  Accept only two hex bytes.  Use STRPLC+
; to form the byte from ASCII entries.  Return byte
; in A with NZ set if good.  Return Z if <Enter> only.
; Return C set if BREAK or incomplete entry.
;
SPECBT	LD	DE,ML15		;Screen loc for display.
	CALL	GET2BT		;Get two digits at STRPLC
	JP	C,SPBAD		;Go if BREAK.
	CP	1		
	JP	Z,SPBAD		;Go if only one char in.
	OR	A		;Any char in?
	RET	Z		;Go if ENTER only.
	LD	HL,STRPLC	;Form hex byte from two
	LD	A,(HL)		;  digits.
	RLCA
	RLCA
	RLCA
	RLCA
	INC	HL
	OR	(HL)		;Byte is in A.
	OR	A		;Was 00 spec'd?
	RET	NZ		;Back if some other byte.
	CP	(HL)		;Was 00 so set NZ like
	RET			;  this to keep A = 00.
;
SPBAD	SCF			;Here on BREAK or only
	RET			;   one char. input.
;
;----------------
; Determine the appropriate start and end addresses for
; a block search or fill operation.  If cursor is not
; within block , do whole block.  Else do just from
; cursor on.
;
CKBLK	LD	DE,(TPMADR)
	LD	A,(UHIMRK)
	OR	A
	JR	Z,CKBLK1
	LD	DE,(HIMADR)
CKBLK1	LD	HL,(BYTED)
	CALL	CPHLDE
	JR	C,CKBLK3
	JR	Z,CKBLK3
CKBLK2	LD	HL,(LOMADR)
	RET
CKBLK3	LD	BC,(LOMADR)
	CALL	CPHLBC
	JR	C,CKBLK2
	RET
;
;-------------------------------
; Fill from HL to DE with byte in A.
;
FILL	EQU	$
	PUSH	HL
	PUSH	BC
	LD	C,A
	DEC	HL
FLOP2	INC	HL
	LD	(HL),C
	CALL	CPHLDE
	JR	NZ,FLOP2
	POP	BC
	POP	HL
	RET
;
;-------------------------------------------------------
; Hex entry, limited to (NGET) char.
;
; Enter with address to display characters at in (INSHOW)
;   and with address to store them at in (INBLD).
; Enter with # characters to accept in (NGET).
; Operator must press <Enter> to return from this sub.
;
; Returns Z set if incomplete entry (BREAK pressed).
; Returns Carry set if only <Enter) is pressed.
;
;
NGET	DEFB	0
NGOT	DEFB	0
HLMKEY	DEFB	0
INSHOW	DEFW	00
INBLD	DEFW	00
;
HEXLIM	EQU	$
	PUSH	IX
	PUSH	IY
	XOR	A
	LD	(NGOT),A
;
HLMINT	LD	IX,(INSHOW)
	LD	IY,(INBLD)
	LD	A,(NGET)
;
HLINT2	LD	(IX+0),' '
	LD	(IY+0),0
	DEC	A
	JR	Z,HLINT3
	INC	IX
	INC	IY
	JR	HLINT2
;
HLINT3	LD	IX,(INSHOW)
	LD	IY,(INBLD)
	LD	(IX+0),STDCUR
;
HLM1	EQU	$
	CALL	READKB
	JR	NZ,HLM1
	LD	BC,2000
	CALL	MYDELY
HLM1A	CALL	READKB
	JR	Z,HLM1A
	LD	(HLMKEY),A
;
HLM1F	LD	A,(KB1TO8)	;Prevents returning
	OR	A		;  w/a key down.
	JR	NZ,HLM1F
	LD	A,(HLMKEY)
;
	CP	BREAK
	JR	NZ,HLM1C
	SCF
	JR	HLMXIT
;
HLM1C	CP	CR
	JR	NZ,HLM1B
	LD	A,(NGOT)
	OR	A
	JR	HLMXIT
;
HLM1B	CP	SLFARW
	JR	Z,HEXLIM
;
	CP	LFAROW
	JR	NZ,HLM2
;
	LD	A,(NGOT)
	OR	A
	JR	Z,HLM4
	DEC	A
	LD	(NGOT),A
	LD	(IX+0),' '
	LD	(IY+0),0
	DEC	IX
	DEC	IY
	LD	(IX+0),STDCUR
	JR	HLM4
;
HLM2	EQU	$
	LD	A,(NGOT)
	LD	B,A
	LD	A,(NGET)
	CP	B
	JR	Z,HLM4
;
	LD	A,(HLMKEY)
	CALL	VALHEX
	JR	C,HLM4
;
	LD	(IY+0),A
	LD	A,(HLMKEY)
	LD	(IX+0),A
	INC	IX
	INC	IY
	LD	A,(NGOT)
	INC	A
	LD	(NGOT),A
	LD	B,A
	LD	A,(NGET)
	CP	B
	JR	Z,HLM4
	LD	(IX+0),STDCUR
	LD	(IY+0),0
	JR	HLM4
;
HLM4	EQU	$
	JP	HLM1
;
HLM5	EQU	$
	XOR	A
	SCF
	JR	HLMXIT
;
HLMXIT	POP	IY
	POP	IX
	RET
;
;------------------------------
; Compare HL to DE.
;
CPHLDE	EQU	$
	LD	A,H
	SUB	D
	RET	NZ
	LD	A,L
	SUB	E
	RET
;
;-------------------------------
; Compare HL to BC.
;
CPHLBC	EQU	$
	LD	A,H
	SUB	B
	RET	NZ
	LD	A,L
	SUB	C
	RET
;
;-------------------------------
; Check if two marks exist.  Return NZ if so.
;
TWOMRK	EQU	$
	LD	A,(ULOMRK)
	OR	A
	RET	Z
	LD	A,(UHIMRK)
	OR	A
	RET
;
;-------------------------------
VALHEX	EQU	$
	LD	C,A
	LD	A,'F'
	CP	C
	JR	C,NOTHEX
	LD	A,'/'
	CP	C
	JR	NC,NOTHEX
	LD	A,'@'
	CP	C
	LD	A,C
	JR	C,ATHRUF
	CP	':'
	JR	C,ZTHRU9
NOTHEX	SCF
	RET
;
ZTHRU9	SUB	30H
	RET
;
ATHRUF	SUB	37H
	RET
;----------------
;
;
	IF TRAK	;****
;-------------------------------------------------------
; Figure CRC of one byte.  Address of the byte expected
;  in HL.  Current CRC expected in DE.  New CRC returned
;  in DE.  AF, BC, DE altered.
;
NEWCRC	EQU	$
	XOR	D
	LD	D,A
	SRL	A
	SRL	A
	SRL	A
	SRL	A
	XOR	D
	LD	D,E
	LD	E,A
	RL	A
	RL	A
	RL	A
	RL	A
	LD	C,A
	RL	A
	RL	A
	AND	1FH
	XOR	D
	LD	D,A
	LD	A,C
	AND	0F0H
	XOR	D
	LD	D,A
	LD	A,C
	RL	A
	AND	0E0H
	XOR	E
	LD	E,A
	RET
;
	ENDIF	;****
;
; -------------------------------------------------------
; Block Move
;
BLKMOV	EQU	$
	EX	DE,HL		;Start of Dest. in DE.
	LD	BC,(BUF05)	;Start of source in BC.
	LD	HL,(BUF07)	;End of source in HL.
	XOR	A		;Clear carry.
	SBC	HL,BC
	JR	C,BMVDUN	;Go if END < START
	INC	HL
	PUSH	HL
	POP	BC		;# bytes in BC
	LD	HL,(BUF05)	;Start of source in HL.
	CALL	CPHLDE		;Compare HL:DE.
	JR	Z,BMVDUN	;Done if same.
	JR	C,DOLDDR	;Go if moving up.
	LDIR			;Move down.
	JP	BMVDUN		;Done.
;
DOLDDR	EX	DE,HL		;To move up must work
	ADD	HL,BC		;  from ends.
	DEC	HL
	EX	DE,HL		;End of dest. in DE.
	BIT	7,D		;Is DE > 0 ?
	JR	Z,ATROM		;Go if so.
	LD	HL,(BUF07)	;End of source in HL.
	LDDR			;Move up.
	JP	BMVDUN		;Done.
;
ATROM	INC	DE		;Will move into ROM.
	PUSH	BC
	POP	HL		;# bytes in HL.
	XOR	A		;Clear Carry.
	SBC	HL,DE
	PUSH	HL
	POP	BC		;New # bytes in BC.
	LD	HL,(BUF07)	;End of source in HL.
	XOR	A		;Clear Carry.
	SBC	HL,DE		;New end of source in HL.
	LD	DE,RAMTOP	;New end of dest. in DE.
	LDDR			;Move up.
;
BMVDUN	RET			;Block-move done.
;
; ------------------------------------------------------
; Clear Screen
;
CLSCRN	EQU	$
	PUSH	HL
	PUSH	DE
	PUSH	BC
	LD	HL,CRTR1
	LD	DE,CRTR1+1
	LD	BC,1023
	LD	(HL),SPACE
	LDIR
	POP	BC
	POP	DE
	POP	HL
	RET
;
; -------------------------------------------------------
; String to Video
;
STRVID	EQU	$
STV1	LD	A,(HL)
	OR	A
	RET	Z
	CALL	CRTBYT
	INC	HL
	JP	STV1
;
; -------------------------------------------------------
; Delay (Equal to ROM routine)
;
MYDELY	EQU	$
	PUSH	AF
MDLY1	DEC	BC
	LD	A,B
	OR	C
	JR	NZ,MDLY1
	POP	AF
	RET
;
; -------------------------------------------------------
; Read Keyboard.  From Barden's routine in 80-Micro.
;
READKB	EQU	$
	PUSH	BC
	PUSH	DE
	PUSH	HL
	LD	A,(KB1TO8)
	OR	A
	JR	Z,NOKEY
	LD	HL,KB1
ROWCHK	LD	A,(HL)
	OR	A
	JR	NZ,GETIDX
	SLA	L
	JP	P,ROWCHK
NOKEY	XOR	A
	JP	KBDUN
GETIDX	LD	C,A
	XOR	A
GIDX1	SRL	L
	JR	C,GIDX3
GIDX2	ADD	A,8
	JP	GIDX1
GIDX3	LD	B,0FFH
GIDX4	INC	B
	SRL	C
	JR	NC,GIDX4
	ADD	A,B
	LD	C,A
	LD	A,(KB8)
	OR	A
	JR	Z,SHFDUN
	LD	A,40H
SHFDUN	ADD	A,C
	LD	C,A
	LD	B,0
	LD	HL,KBTAB
	ADD	HL,BC
	LD	A,(HL)
KBDUN	POP	HL
	POP	DE
	POP	BC
	OR	A
	RET
;
KBTAB	EQU	$
	DEFB	40H
	DEFB	41H
	DEFB	42H
	DEFB	43H
	DEFB	44H
	DEFB	45H
	DEFB	46H
	DEFB	47H
	DEFB	48H
	DEFB	49H
	DEFB	4AH
	DEFB	4BH
	DEFB	4CH
	DEFB	4DH
	DEFB	4EH
	DEFB	4FH
	DEFB	50H
	DEFB	51H
	DEFB	52H
	DEFB	53H
	DEFB	54H
	DEFB	55H
	DEFB	56H
	DEFB	57H
	DEFB	58H
	DEFB	59H
	DEFB	5AH
	DEFB	0
	DEFB	0
	DEFB	0
	DEFB	0
	DEFB	0
	DEFB	30H
	DEFB	31H
	DEFB	32H
	DEFB	33H
	DEFB	34H
	DEFB	35H
	DEFB	36H
	DEFB	37H
	DEFB	38H
	DEFB	39H
	DEFB	3AH
	DEFB	3BH
	DEFB	2CH
	DEFB	2DH
	DEFB	2EH
	DEFB	2FH
	DEFB	CR
	DEFB	CLEAR
	DEFB	BREAK
	DEFB	UPAROW
	DEFB	DNAROW
	DEFB	LFAROW
	DEFB	RTAROW
	DEFB	SPACE
	DEFB	0
	DEFB	0
	DEFB	0
	DEFB	0
	DEFB	0
	DEFB	0
	DEFB	0
	DEFB	0
	DEFB	0FH
	DEFB	61H
	DEFB	62H
	DEFB	63H
	DEFB	64H
	DEFB	65H
	DEFB	66H
	DEFB	67H
	DEFB	68H
	DEFB	69H
	DEFB	6AH
	DEFB	6BH
	DEFB	6CH
	DEFB	6DH
	DEFB	6EH
	DEFB	6FH
	DEFB	70H
	DEFB	71H
	DEFB	72H
	DEFB	73H
	DEFB	74H
	DEFB	75H
	DEFB	76H
	DEFB	77H
	DEFB	78H
	DEFB	79H
	DEFB	7AH
	DEFB	0
	DEFB	0
	DEFB	0
	DEFB	0
	DEFB	0
	DEFB	30H		;Shift/0 = 0.
	DEFB	21H
	DEFB	22H
	DEFB	23H
	DEFB	24H
	DEFB	25H
	DEFB	26H
	DEFB	27H
	DEFB	28H
	DEFB	29H
	DEFB	2AH
	DEFB	2BH
	DEFB	3CH
	DEFB	3DH
	DEFB	3EH
	DEFB	3FH
	DEFB	SENTER
	DEFB	SCLR
	DEFB	SBRK
	DEFB	SUPARW
	DEFB	SDNARW
	DEFB	SLFARW
	DEFB	SRTARW
	DEFB	SSPACE
;
 