UD     ; UD/ASM
 DISPLY	EX	(SP),HL		;get data address
 	PUSH	DE		;save this
 	PUSH	AF		;save accum too.
 	EX	DE,HL		;de => data
 	LD	HL,(CURSOR)	;get cursor addr.
 DISLP	LD	A,(DE)		;get a byte
 	INC	DE		;bump the pointer
 	OR	A		;set flags
 	JR	Z,DISDN		;terminator
 	CALL	CKDUL		;see if dual is on
 	CP	20H		;control code?
 	JR	C,DISCTL	;do it if <20H
 	LD	(HL),A		;display the byte
 	CP	(HL)		;still there?
 	JR	Z,DISOK		;yes, lowercase in
 	SUB	20H		;make it uppercase
 	LD	(HL),A		;put it back
 DISOK	INC	HL		;bump the cursor
 	JR	DISLP		;continue
 DISDN	LD	(CURSOR),HL	;put cursor back
 	EX	DE,HL		;hl => return address
 	POP	AF		;restore af
 	POP	DE		;restore de
 	EX	(SP),HL		;get hl back, leave ret.
 	RET			;go to it
 DISCTL	CALL	CONTRL		;make it a call
 	JR	DISLP		;continue
 CONTRL	CP	8		;backspace
 	JR	Z,BKSPA
 	CP	9		;center screen?
 	JR	Z,CENTR
 	CP	10		;linefeed?
 	JR	Z,LINFEED
 	CP	13		;carriage return?
 	JR	Z,LINFEED	;same thing
 	CP	11		;up linefeed?
 	JR	Z,UPFEED
 	CP	1DH		;BOL?
 	JR	Z,BOL
 	CP	1EH		;EOL?
 	JR	Z,EOL
 	CP	7		;clear screen
 	JR	Z,CLS		;do it
 	RET
 BKSPA	DEC	HL		;go back one space
 	JR	OFFVID		;make sure it's on video
 LINFEED	PUSH	DE		;save it
 	LD	DE,40H		;64 char/line
 	CALL	BOL		;get begin of line
 	ADD	HL,DE		;go to next line
 	POP	DE		;restore it
 	JR	OFFVID		;frame it
 BOL	LD	A,L		;get lsb byte
 	AND	0C0H		;put to beginning of line
 	LD	L,A		;put that back
 	RET			;no frame needed
 EOL	CALL	BOL		;go beginning of line
 	PUSH	BC		;save these
 	LD	BC,3FH		;line length -1
 FIXCON	PUSH	HL		;save the rest
 	PUSH	DE
 	LD	D,H		;give to DE
 	LD	E,L
 	INC	DE		;start +1
 	LD	(HL),20H	;clear byte
 	LD	A,(FLAGA)
 	PUSH	AF
 	RES	1,A
 	LD	(FLAGA),A
 	LDIR			;put spaces all over
 	POP	AF
 	LD	(FLAGA),A
 	POP	DE
 	POP	HL
 	POP	BC		;get 'em all back
 OFFVID	LD	A,H		;check for boundrys
 	CP	3CH		;less than video?
 	JR	NC,OFFAOK	;test one ok
 	LD	HL,3C00H	;top of vid
 	RET			;resume
 OFFAOK	CP	40H		;more than top?
 	RET	C		;it's OK
 	PUSH	DE		;save this
 	PUSH	BC		;this too
 	LD	DE,3C00H	;scroll the screen
 	LD	HL,3C40H	;2'nd line
 	LD	BC,3C0H		;screen less one line
 	LDIR			;move it up
 	POP	BC		;get 'em back
 	POP	DE
 	LD	HL,3FC0H	;bottom line
 	JR	EOL		;clear bottom line
 CLS	LD	HL,3C00H	;top of screen
 	PUSH	BC		;save from use
 	LD	BC,1023		;screen size -1
 	JR	FIXCON		;fill with spaces
 CENTR	LD	A,L		;get lsb cursor
 	AND	0C0H		;beginning of line
 	OR	20H		;put in the middle
 	LD	L,A		;that goes back
 	RET			;must be in video
 UPFEED	PUSH	DE		;save from add
 	LD	DE,-40H		;1 line up
 	ADD	HL,DE		;move hl up
 	POP	DE		;restore DE
 	JR	OFFVID		;check if it's on video
 GETSTR	LD	C,B
 	PUSH	DE		;save from use
 	LD	HL,(CURSOR)	;get cursor posit
 	PUSH	HL		;save a second
 	INC	B
 PUTPER	LD	(HL),'.'	;periods to display line
 	INC	HL
 	DJNZ	PUTPER		;prompt displayed
 	POP	HL		;restored
 	LD	DE,STRING	;input buffer
 CURCUR	LD	A,152		;standard cursor
 	JR	CUROFF
 CURON	LD	A,164		;cursor on char
 CUROFF	LD	(HL),A		;display it
 	LD	A,4		;1/8 second flash
 	LD	(FLCOUNT),A	;save the count
 SCAN	LD	A,0		;get counter
 FLCOUNT	EQU	$-1
 	DEC	A		;less one
 	LD	(FLCOUNT),A	;resave it
 	JR	NZ,SCAN2	;continue if not time
 	LD	A,(HL)		;get cursor char.
 	CP	152		;off?
 	JR	NZ,CURCUR	;display cursor/init cnt.
 	JR	CURON		;cursor on
 SCAN2	CALL	INKEY		;scan keyboard
 	JR	Z,SCAN		;loop till have key
 	CP	13		;enter key?
 	JR	Z,SCDON
 	CP	14		;sh enter?
 	JR	Z,SCDON
 	CP	5DH		;backspace?
 	JR	Z,BAKSPCE
 	CP	18H		;shift back?
 	JR	Z,NEWST
 	CP	3
 	JR	Z,NEWST
 	CP	20H		;valid code?
 	JR	C,SCAN		;skip if not
 	LD	(ASVE),A	;save the key
 	LD	A,B		;get length
 	CP	C		;test for max
 	JR	NC,SCAN		;don't take it
 	LD	A,0
 ASVE	EQU	$-1		;get key back
 	CALL	CKDUL		;see if dual on
 	LD	(HL),A		;display the byte
 	LD	(DE),A		;put in buffer
 	CP	(HL)		;lower case ?
 	JR	Z,CHAROK	;yes if Z
 	SUB	20H		;make it uppercase
 	LD	(HL),A		;put it back
 CHAROK	INC	DE		;bump buffer
 	INC	B		;bump length
 	INC	HL		;bump video pointer
 	JR	CURCUR		;resume
 SCDON	LD	A,13
 	CALL	CKDUL
 	CALL	DLON
 	LD	(DE),A
 	LD	A,C
 	SUB	B
 	INC	A
 	PUSH	BC
 	LD	B,A
 	LD	A,20H
 	CALL	FILL
 	POP	BC
 	POP	DE		;restore old DE
 	LD	A,B		;set flags for length
 	OR	A
 	LD	HL,STRING	;hl => input string
 	LD	A,(HL)		;a has first char
 	RET			;done
 BAKSPCE	LD	A,B		;any length?
 	OR	A
 	JR	Z,SCAN		;don't do it then
 	LD	(HL),'.'	;put a period there
 	DEC	HL		;move it back
 	DEC	DE		;move buffer back
 	DEC	B		;char. count back
 	JP	CURCUR		;resume
 NEWST	LD	A,B		;any length?
 	OR	A
 	JP	Z,SCAN		;don't bother
 NEWSTL	LD	(HL),'.'	;periods to video
 	DEC	HL
 	DEC	DE		;move buffer back
 	DJNZ	NEWSTL		;go till length 0
 	JP	CURCUR		;cursor on
 KEY	PUSH	HL		;save all registers
 	PUSH	DE
 	PUSH	BC
 	LD	HL,GET		;return address
 	PUSH	HL		;to the stack
 	LD	A,(FLAGB)
 	BIT	1,A
 	JR	Z,BADJOY
 	IN	A,(0)
 	CP	0FFH
 	JP	NZ,JOYSTK
 BADJOY	LD	A,(387FH)	;any keys on?
 	OR	A		;set flags
 	JR	NZ,ADDRPT	;countdown
 GONEWKEY	LD	A,(FLAGA)
 	BIT	6,A
 	LD	A,20
 	JR	Z,I80
 	LD	A,40
 I80	LD	(DLY1),A
 CONTRPT	LD	A,(FLAGA)
 	BIT	6,A
 	LD	A,2
 	JR	Z,I85
 	LD	A,4
 I85	LD	(DLY2),A
 	JR	KIGO		;go single key
 ADDRPT	CP	0		;same as last key?
 LSTKEY	EQU	$-1
 	LD	(LSTKEY),A	;put into mask byte
 	JR	NZ,GONEWKEY	;go to new key
 	LD	A,0		;get first key count
 DLY1	EQU	$-1
 	OR	A		;down to 0 yet?
 	JR	Z,CKDLY2	;if yes, check delay2
 	DEC	A		;reduce it on this pass
 	LD	(DLY1),A	;put it back
 	JR	KIGO		;continue
 CKDLY2	LD	A,0		;get between key count
 DLY2	EQU	$-1
 	DEC	A		;less one
 	LD	(DLY2),A	;back
 	JR	NZ,KIGO		;go if not time
 	LD	HL,KEYBRD
 	LD	DE,KEYBRD+1	;7 byte last key mask
 	LD	BC,6
 	LD	(HL),0
 	LDIR
 	JR	CONTRPT		;reset counter
 KIGO	LD	HL,KEYBRD	;work area
 	LD	BC,3801H	;keyboard memory
 	LD	D,0		;row counter
 NEXROW	LD	A,(BC)		;get key byte
 	LD	E,A		;save it here
 	XOR	(HL)		;reverse with mask
 	LD	(HL),E		;save new key
 	AND	E		;same as last key?
 	JR	NZ,HAVEIT	;have a new one
 	INC	D		;bump row count
 	INC	L		;bump mask byte
 	RLC	C		;move key memory
 	JP	P,NEXROW	;go for 7 rows
 	RET			;done
 HAVEIT	LD	E,A		;save masked byte
 	LD	A,D		;get row count
 	RLCA			;*2
 	RLCA			;*4
 	RLCA			;*8
 	LD	D,A		;row * 8
 	LD	C,1		;column mask bit
 MKT1	LD	A,C
 	AND	E		;this the right key?
 	JR	NZ,MKT2		;yup
 	INC	D		;bump row*8
 	RLC	C		;shift mask bit left
 	JR	MKT1		;continue
 MKT2	LD	A,(FLAGA)
 	LD	C,A
 	LD	A,(3880H)	;get shift key
 	LD	B,-1		;set mask for shift
 	OR	A		;any bits on?
 	JR	NZ,KI3		;continue if yes
 	INC	B		;else clear B
 KI3	LD	A,D		;get value back
 	ADD	A,40H		;make it ascii
 	CP	60H		;a-z?
 	JR	NC,LXH3		;go if not
 	RRC	C		;reverse lower case?
 	JR	C,REVKEY	;works reverse if -1
 	RRC	B		;shift key pressed?
 	JR	NC,GOTKEY	;have the key
 	ADD	A,20H		;make it lower
 CKCTL	LD	D,A		;save char
 	LD	A,(3840H)	;get last row
 	AND	10H		;down arrow?
 	LD	A,D		;get char back
 	JR	Z,GOTKEY	;continue if not
 	CALL	UCASE
 	SUB	40H		;make it a control key
 	JR	GOTKEY
 REVKEY	RRC	B		;shift key on?
 	JR	C,CKCTL		;have the key
 	ADD	A,20H		;make it lower
 	JR	GOTKEY
 LXH3	SUB	70H		;check for last row
 	JR	NC,LXH5		;get byte from table
 	ADD	A,40H		;adjust ascii back
 	CP	3CH		;test for =*/
 	JR	C,LXH4		;don't adjust
 	XOR	10H		;works backwards
 LXH4	RRC	B		;shift key?
 	JR	NC,GOTKEY	;continue if not
 	XOR	10H		;reverse back
 	JR	GOTKEY
 LXH5	RLCA			;double it for table
 	RRC	B		;check for shift
 	JR	NC,LXH6		;go
 	INC	A		;add one for shift entry
 LXH6	LD	HL,KEYTABL	;look up key table
 	LD	C,A
 	LD	B,0		;bc=displacement
 	ADD	HL,BC
 	LD	A,(HL)		;get the byte
 GOTKEY	CP	4		;sh clear?
 	JR	Z,SCREENPRT	;screen printer
 	CP	20H		;check for sh 0
 	RET	NZ		;not that
 	LD	D,A		;save here
 	LD	A,(3880H)	;check shift key
 	OR	A
 	LD	A,D
 	RET	Z
 	JP	ULCASE
 SCREENPRT	LD	B,16	;16 lines on video
 	LD	HL,3C00H	;start of video
 VIDE1	LD	C,64		;64 char/line
 	PUSH	HL		;save BOL
 	LD	A,L		;get lsb
 	ADD	A,3FH		;put at end of line
 	LD	E,A		;give to de
 	LD	D,H		;de = end of line
 VIDE3	LD	A,(DE)		;get a byte from screen
 	CP	20H		;space?
 	JR	NZ,VIDIT	;end of that line
 	DEC	DE		;go back
 	DEC	C		;reduce count
 	JR	NZ,VIDE3	;look for more chars
 	LD	A,10		;send a linefeed
 	CALL	POUT		;display it
 	JR	VIDNEX		;continue
 VIDIT	INC	DE		;bump for end
 VIDIT1	LD	A,(HL)		;get printer flag
 	PUSH	AF
 	LD	(HL),191
 	CP	20H		;needs adjust?
 	JR	NC,VID4
 	ADD	A,40H		;adjust to letter
 VID4	CALL	POUT
 	POP	AF
 	LD	(HL),A
 	INC	HL		;bump position
 	PUSH	HL		;test for end of line
 	OR	A		;clear carry flag
 	SBC	HL,DE		;at end yet?
 	POP	HL
 	JR	NZ,VIDIT1
 	LD	A,13		;send a carriage return
 	CALL	POUT
 VIDNEX	POP	HL		;restore hl
 	LD	DE,40H		;for next line
 	ADD	HL,DE		;go there
 	DJNZ	VIDE1		;continue for 16 lines
 	LD	A,13
 	CALL	POUT
 VIDBK	XOR	A		;return with zero
 	RET			;done
 POUTXX	LD	B,A		;will use this one
 	LD	C,A		;will save original
 	LD	A,(FLAGB)	;get printer flag
 	BIT	7,A		;graphics?
 	JR	NZ,POUT11	;continue if yes
 	BIT	7,B
 	JR	Z,POUT11
 	LD	B,'.'
 POUT11	BIT	6,A		;lower case?
 	PUSH	AF
 	JR	NZ,POUT12
 	BIT	7,B
 	JR	NZ,POUT12
 	LD	A,B
 	CALL	UCASE
 	LD	B,A
 POUT12	POP	AF		;get flag back
 	BIT	5,A		;MX80 graphics?
 	PUSH	AF
 	JR	Z,POUT12A
 	LD	A,B
 	BIT	7,A
 	JR	Z,POUT12A
 	RES	6,A
 	ADD	A,20H
 	LD	B,A
 POUT12A	POP	AF
 	BIT	4,A		;serial?
 	LD	A,B
 	JR	NZ,POUT13
 ;i*
 	IF	MODI
 	LD	(37E8H),A
 	ENDIF
 ;iii*
 	IF	MODIII
 	OUT	(0F8H),A
 	ENDIF
 ;
 POUT15A	LD	A,C		;get char back
 	CP	13		;linefeed?
 	RET	NZ		;nope
 	LD	A,(FLAGB)	;get flag back
 	BIT	3,A		;need linefeeds?
 	JR	Z,NOLINFD
 	LD	A,10		;send linefeed
 	CALL	POUTXX		;will return from above
 NOLINFD	LD	A,13		;restore linefeed
 	RET			;done
 POUT13	PUSH	HL		;save these
 	PUSH	BC
 	CP	10
 	JR	Z,POUT13X
 	CALL	SERIALOUT
 POUT13Y	POP	BC
 	POP	HL
 	JR	POUT15A		;restore everything
 POUT13X	LD	B,20H
 	CALL	SERIALOUT
 	LD	B,13
 	CALL	SERIALOUT
 	LD	A,10
 	JR	POUT13Y
 SERIALOUT	LD	L,B	;the char to send
 	LD	H,9
 	CALL	ZEROXXU
 	LD	A,L
 	SCF
 SERIALBIT	RRA
 	PUSH	AF
 	CALL	NC,ZEROXXU
 	LD	A,0
 	CALL	C,ONEXXU
 	POP	AF
 	DEC	H
 	JR	NZ,SERIALBIT
 	RET
 ZEROXXU	LD	A,1
 ONEXXU	OUT	(0FFH),A
 	LD	BC,222
 	CALL	DELAY
 	OR	A
 	RET
 GET	POP	BC
 	POP	DE
 	POP	HL
 	OR	A
 	RET			;restore 'em all
 KEYTABL	DB	13		;enter
 	DB	14		;sh enter
 	DB	3		;clear
 	DB	4		;sh clear
 	DB	1		;break
 	DB	2		;sh break
 	DB	5BH		;u arr
 	DB	1BH		;sh u arr
 	DB	5CH		;d arr
 	DB	1AH		;sh d arr
 	DB	5DH		;l arr
 	DB	18H		;sh l arr
 	DB	5EH		;r arrow
 	DB	19H		;sh r arr
 	DB	20H		;space
 	DB	80H		;sh space
 ULCASE	LD	A,(FLAGA)	;get key flag
 	XOR	1		;reverse bit 0
 	LD	(FLAGA),A	;put it back
 	XOR	A		;return with nill
 	RET			;done
 CKDUL	LD	(CKDSAV),A	;save the char
 	LD	A,(FLAGA)
 	RLCA
 	LD	A,0		;get char back
 CKDSAV	EQU	$-1
 	JP	C,POUT		;send to printer
 	RET			;done
 DLON	PUSH	AF
 	LD	A,(FLAGA)
 	BIT	5,A
 	RES	7,A
 	JR	Z,DLCMM
 	SET	7,A
 DLCMM	LD	(FLAGA),A	;set the dual flag
 	POP	AF
 	RET
 DLOFF	PUSH	AF
 	LD	A,(FLAGA)
 	RES	7,A
 	JR	DLCMM
 IFPRINTER	PUSH	BC
 	LD	BC,0
 PRCOUNT	EQU	$-2
 	LD	A,B
 	OR	C
 	JR	Z,IFPRINTD	;nothing, go back
 	LD	A,(3880H)
 	OR	A
 	JR	NZ,PRTYR
 	LD	A,(3840H)	;check for clear key
 	BIT	1,A
 	JR	NZ,IFPRINTE	;end all printing
 PRTYR	LD	A,(FLAGB)
 	BIT	4,A
 	JR	NZ,PPYYHG
 	LD	A,(37E8H)
 	AND	0F0H
 	CP	30H
 	JR	NZ,IFPRINTD
 PPYYHG	PUSH	HL
 	LD	HL,PRBUFF	;start of buffer
 	ADD	HL,BC
 	LD	A,(HL)		;get a byte
 	POP	HL
 	DEC	BC
 	LD	(PRCOUNT),BC
 	CALL	POUTXX		;print the byte
 	JP	IFPRINTER+1
 IFPRINTD	POP	BC	;restore this
 	RET			;done with task
 IFPRINTE	LD	BC,0
 	LD	(PRCOUNT),BC	;zero the print buffer
 	JR	IFPRINTD	;return
 POUT	PUSH	HL
 	PUSH	BC
 	PUSH	AF
 POUTXXX	LD	BC,(PRCOUNT)	;check counter
 	INC	BC
 	LD	A,B
 	CP	4
 	JR	NC,POUTXXX	;wait for 1 byte space
 	DI
 	LD	BC,(PRCOUNT)
 	INC	BC
 	LD	(PRCOUNT),BC
 	POP	AF
 	PUSH	DE
 	PUSH	AF
 	LD	HL,PRBUFF	;start of buffer
 	PUSH	HL
 	LD	DE,PRBUFF+1
 	CALL	MOVE
 	POP	HL
 	POP	AF
 	LD	(HL),A
 	EI
 	POP	DE
 	POP	BC
 	POP	HL
 	RET
 JOYSTK	LD	BC,1000H
 	CALL	DELAY
 	IN	A,(0)
 	CPL
 	CP	5
 	JP	Z,JOYSPACE
 	CP	9
 	JP	Z,JOYADV
 	CP	6
 	JP	Z,JOYRET
 	CP	10
 	JP	Z,JOYINS
 	LD	B,A
 	LD	A,5BH
 	BIT	0,B
 	JR	NZ,GOTJOY
 	INC	A
 	BIT	1,B
 	JR	NZ,GOTJOY
 	INC	A
 	BIT	2,B
 	JR	NZ,GOTJOY
 	INC	A
 	BIT	3,B
 	JR	NZ,GOTJOY
 	LD	A,13
 	BIT	4,B
 	JP	Z,BADJOY
 GOTJOY	LD	BC,500H
 	JP	DELAY
 JOYSPACE	LD	A,','
 	JR	GOTJOY
 JOYADV	LD	A,(3C00H+62)
 	INC	A
 	JR	JOYRET+4
 JOYRET	LD	A,(3C00H+62)
 	DEC	A
 	LD	(3C00H+62),A
 	XOR	A
 	JR	GOTJOY
 JOYINS	LD	A,(3C00H+62)
 	JR	GOTJOY
 	JP	DELAY
 JOYSPACE	LD	A,','
 	JR	GOTJOY
 JOYADV	LD	A,(3C00H+62)
 	INC	A
 	JR	JOYRET+4
 JOYRET	LD	A,(3C00H+62)
 	DEC	A
 	LD	(3C00H+62),A
 	XOR	A
 	JR	GOTJOY
 JOYINS	LD	A,(3C00H+6