SUPCOP ; supcopy/asm
 	ORG	4400H
 STAK	EQU	43E0H
 DRIVES	DB	0,0,0,0
 XDRIVES	DB	0,0,0,0
 CTRACK	DB	0,0,0,0
 COPIES	DW	0
 COUNT	DW	0
 RETNMI	RETN
 STRING	EQU	4300H
 CLRLIN	DB	1DH,1EH,10,13
 CLRIT	DB	1DH,1EH,3
 SER0	DB	'xxxxxxx'
 SER1	DB	'xxxxxxx'
 SER2	DB	'xxxxxxx'
 SER3	DB	'xxxxxxx'
 SERX	DB	'xxxxxxx'
 SERTBL	DW	SER0
 	DW	SER1
 	DW	SER2
 	DW	SER3
 TABLE
 TSKCNT	DB	8	;alive counter
 TSKRES	DB	8	;alive reset byte
 ALIVON	DB	238	;alive 'on'
 ALIVOF	DB	240	;alive 'off'
 VERIFY	DB	'Y'	;verify flag
 SDRIVE	DB	0	;source drive
 AUTO	DB	'Y'	;auto serial #
 DDRIVE	DB	1	;dest drive
 TRACK	DB	0	;current track
 MAXTRKS	DB	33	;track count dest
 FLAG	DB	0	;verify retry flag
 START3	DB	23	;start track mod iii
 START1	DB	6	;start track mod i
 SECTS	DB	162	;# sectors in pgm
 CURCNT	DB	0	;current counter
 TRIES	DB	6	;# retries
 TRY	DB	0	;current try
 FLAGA	DB	0	;inner loop retry
 HELLO	DB	1CH,1FH,'Super-Utility Plus '
 	DB	'Copy Utility - by '
 KIM	DB	'Kim Watt - '
 	DB	'Version 1.2',10
 	DB	'(c) Copyright 1982 Breeze/QSD, Inc. - '
 	DB	'Dallas, Texas',10,13
 MSG1	DB	'Number of Copies (default 100) ? ',3
 MSG2	DB	'Byte for Byte Verify (default Yes) ? ',3
 MSG3	DB	'Source Drive (default 0) ? ',3
 MSG4	DB	'Destination Drives (default '
 MSG4A	DB	'x,x,x) ? ',3
 MSG5	DB	'Mount all disks, key <ENTER>'
 	DB	' to begin: ',3
 MSG6	DB	'All Copies Completed - '
 	DB	'Key <ENTER> to restart: ',3
 MSG7	DB	1DH,'Formatting Drive '
 MSG7A	DB	'x ',1EH,3
 MSG8	DB	'Source and Destination '
 	DB	'SAME DRIVE !',13
 MSG9	DB	'No DESTINATION Drives !',13
 MSG10	DB	10,'Drive NOT READY on Write - ',3
 MSG11	DB	10,'Diskette WRITE PROTECTED - ',3
 MSG12	DB	10,'Hardware WRITE FAULT - ',3
 MSG13	DB	10,'Sector NOT FOUND on Write - ',3
 MSG14	DB	10,'CRC Error on Write - ',3
 MSG15	DB	10,'LOST DATA on Write - ',3
 MSG16	DB	10,'Drive NOT READY on Read - ',3
 MSG17	DB	10,'Sector NOT FOUND on Read - ',3
 MSG18	DB	10,'CRC Error on Read - ',3
 MSG19	DB	10,'LOST DATA on Read - ',3
 MSG20	DB	10,'Program Error - ',3
 MSG21	DB	'Drive '
 MSG21A	DB	'x Removed From Que !',13
 MSG22	DB	10,'NO DISKETTE in Drive - ',3
 MSG23	DB	10,'DOOR NOT CLOSED on Drive - ',3
 MSG24	DB	10,'Drive NOT READY - ',3
 MSG25	DB	1DH,'Reading    Drive '
 MSG25A	DB	'x ',1EH,3
 MSG26	DB	1DH,'Writing    Drive '
 MSG26A	DB	'x ',1EH,3
 MSG27	DB	1DH,'Verifying  Drive '
 MSG27A	DB	'x ',1EH,3
 MSG28	DB	10,'Drive NOT IN SYSTEM - ',3
 MSG29	DB	'SOURCE ERROR - cannot continue!',13
 MSG30	DB	'Drive '
 MSG30A	DB	'x Copied OK',3
 MSG31	DB	'Drive '
 MSG31A	DB	'x BAD COPY - Do Not Use',3
 MSG32A	DB	'xxxxx Copies Completed of '
 MSG32B	DB	'xxxxx.',10,13
 MSG33	DB	'Testing Buffer Memory ...',13
 MSG34	DB	'FAULTY MEMORY - 48K Required',13
 MSG35	DB	10,'Data Mismatch - ',3
 MSG36	DB	'Auto Serial Number (default yes) ? ',3
 MSG37	DB	'Starting Serial Number ? ',3
 MSG38	DB	'Serial Number for Drive '
 MSG38A	DB	'x ? ',3
 MSG39	DB	1DH,'Installing Serial Numbers ...',1EH,13
 SERMSG	DB	' - Serial #: '
 SERMSGA	DB	'xxxxxxx',13
 	DS	10
 TASK	PUSH	AF
 	IN	A,(0E0H)
 	AND	4
 	JR	NZ,TASKDN
 	PUSH	HL
 	PUSH	DE
 	PUSH	BC
 	LD	HL,KIM
 	LD	DE,KIM2
 	LD	B,8
 TSTKIM	LD	A,(DE)
 	AND	7FH
 	CP	(HL)
 	JR	NZ,KILL
 	INC	DE
 	INC	HL
 	DJNZ	TSTKIM
 	POP	BC
 	POP	DE
 	POP	HL
 	DEC	(IY)
 	JR	NZ,TASKMORE
 	LD	A,(IY+1)
 	LD	(IY),A
 	LD	A,(3C3FH)
 	CP	(IY+2)
 	LD	A,(IY+2)
 	JR	NZ,TASKPUT
 	LD	A,(IY+3)
 TASKPUT	LD	(3C3FH),A
 TASKMORE	LD	A,(3840H)
 	AND	4
 	JR	Z,TASKDN
 	LD	A,(3880H)
 	OR	A
 	JR	NZ,ENTRY
 TASKDN	IN	A,(0ECH)
 	POP	AF
 	EI
 	RETI
 KILL	LD	HL,4000H
 	LD	DE,4001H
 	LD	BC,0-3FFFH
 	LD	(HL),76H	;HALT opcodes all over
 	LDIR
 	RST	0
 ENTRY	DI
 	LD	IY,TABLE
 	LD	HL,TASK
 	LD	(4013H),HL
 	LD	A,0C3H
 	LD	(4012H),A
 	LD	SP,STAK
 	XOR	A
 	OUT	(0E4H),A
 	LD	A,28H
 	OUT	(0ECH),A
 	LD	A,4
 	OUT	(0E0H),A
 	LD	A,0D0H
 	OUT	(0F0H),A
 	LD	A,0C3H
 	LD	(4049H),A
 	LD	HL,RETNMI
 	LD	(404AH),HL
 	LD	HL,473H
 	LD	(401EH),HL
 	LD	HL,3024H
 	LD	(4016H),HL
 	IN	A,(0ECH)
 	EI
 START	LD	HL,HELLO
 	CALL	DISPLAY
 	LD	HL,MSG33
 	CALL	DISPLAY
 	CALL	TESTMEM
 BAD1	LD	HL,MSG1
 	CALL	DISPLAY
 	LD	B,5
 	CALL	GETSTR
 	LD	BC,100
 	JR	Z,BAD1D
 	CALL	VALUE
 	JR	C,BAD1
 BAD1D	LD	(COPIES),BC
 BAD2	LD	HL,MSG2
 ;	CALL	DISPLAY
 	LD	B,1
 ;	CALL	GETSTR
 	LD	A,'Y'
 	JR	BAD2O
 	JR	Z,BAD2O
 	LD	A,(HL)
 	CALL	UCASE
 	CP	'Y'
 	JR	Z,BAD2O
 	CP	'N'
 	JR	NZ,BAD2
 BAD2O	LD	(IY+4),A
 BAD3	LD	HL,MSG3
 	CALL	DISPLAY
 	LD	B,1
 	CALL	GETSTR
 	LD	A,0
 	JR	Z,BAD3D
 	LD	A,(HL)
 	SUB	30H
 	JR	C,BAD3
 	CP	4
 	JR	NC,BAD3
 BAD3D	LD	(IY+5),A
 BAD4	LD	B,0
 	LD	IX,MSG4A
 BAD3E	LD	A,B
 	LD	HL,DRIVES
 	ADD	A,L
 	LD	L,A
 	LD	(HL),0
 	LD	A,(IY+5)
 	CP	B
 	JR	Z,BAD3F
 	LD	A,B
 	ADD	A,30H
 	LD	(IX),A
 	INC	IX
 	INC	IX
 	LD	(HL),-1
 BAD3F	INC	B
 	LD	A,B
 	CP	4
 	JR	C,BAD3E
 	LD	HL,MSG4
 	CALL	DISPLAY
 	LD	B,10
 	CALL	GETSTR
 	JR	Z,BAD5
 	PUSH	HL
 	LD	HL,DRIVES
 	LD	DE,DRIVES+1
 	LD	BC,3
 	LD	(HL),0
 	LDIR
 	POP	HL
 	XOR	A		;set z flag
 	EX	AF,AF'		;save here
 BAD4L	CALL	POSHL		;anything?
 	JR	C,BAD4O
 	SUB	30H
 	JR	C,BAD4
 	CP	4
 	JR	NC,BAD4
 	PUSH	HL
 	LD	HL,DRIVES
 	ADD	A,L
 	LD	L,A
 	LD	A,-1
 	LD	(HL),A
 	EX	AF,AF'
 	POP	HL
 	INC	HL
 	JR	BAD4L
 BAD4O	EX	AF,AF'
 	OR	A
 	JR	NZ,BAD5
 	LD	HL,MSG9
 	CALL	DISPLAY
 	JR	BAD4
 BAD5	LD	A,(IY+5)
 	LD	HL,DRIVES
 	ADD	A,L
 	LD	L,A
 	LD	A,(HL)
 	INC	A
 	JR	NZ,BAD6
 	LD	HL,MSG8
 	CALL	DISPLAY
 	JR	BAD4
 BAD6	LD	HL,MSG36
 	CALL	DISPLAY
 	LD	B,1
 	CALL	GETSTR
 	LD	A,'Y'
 	JR	Z,BAD6A
 	LD	A,(HL)
 	CALL	UCASE
 	CP	'Y'
 	JR	Z,BAD6A
 	CP	'N'
 	JR	NZ,BAD6
 BAD6A	LD	(IY+6),A
 	CP	'N'
 	JR	Z,BAD7
 BAD6B	LD	HL,MSG37
 	CALL	DISPLAY
 	LD	B,7
 	CALL	GETSTR
 	LD	A,B
 	CP	7
 	JR	NZ,BAD6B
 	LD	DE,SERX
 	LD	C,B
 	LD	B,0
 	LDIR
 BAD7	LD	HL,0
 	LD	(COUNT),HL
 LOOPER	DI
 	LD	SP,STAK
 	EI
 	CALL	SERIALNOS
 	LD	HL,MSG5
 	CALL	DISPLAY
 	LD	B,1
 	CALL	GETSTR
 	LD	HL,DRIVES
 	LD	DE,XDRIVES
 	LD	BC,4
 	LDIR
 	CALL	COPY
 	CALL	PUTSERIAL
 	CALL	RESULT
 	LD	HL,(COUNT)
 	LD	DE,(COPIES)
 	OR	A
 	SBC	HL,DE
 	JR	C,LOOPER
 	LD	HL,MSG6
 	CALL	DISPLAY
 	LD	B,1
 	CALL	GETSTR
 	JP	START
 TERMIN
 	CALL	RERROR
 TERMINATE
 	CALL	DISPLAY
 	LD	HL,MSG29
 	CALL	DISPLAY
 	JR	LOOPER
 DISPLAY	PUSH	IY
 DISPLP	LD	A,(HL)
 	INC	HL
 	CP	3
 	JR	Z,DISPDN
 	PUSH	AF
 	CALL	33H
 	POP	AF
 	CP	13
 	JR	NZ,DISPLP
 DISPDN	POP	IY
 	RET
 GETSTR	LD	HL,STRING
 	PUSH	IY
 	CALL	40H
 	POP	IY
 	JP	C,ENTRY
 	LD	A,B
 	OR	A
 	LD	A,(HL)
 	RET
 UCASE	CP	60H
 	RET	C
 	CP	80H
 	RET	NC
 	AND	5FH
 	RET
 	INC	HL
 POSHL	LD	A,(HL)
 	CP	20H
 	JR	Z,POSHL-1
 	CP	','
 	JR	Z,POSHL-1
 	CP	13
 	SCF
 	RET	Z
 	CCF
 	RET
 VALUE	CALL	POSHL
 	RET	C
 	LD	BC,0
 VALLP	LD	A,(HL)
 	CP	20H
 	RET	Z
 	CP	','
 	RET	Z
 	CP	13
 	RET	Z
 	CALL	MAKNUM
 	RET	C
 	PUSH	HL
 	LD	H,B
 	LD	L,C
 	ADD	HL,HL	;*2
 	ADD	HL,HL	;*4
 	ADD	HL,BC	;*5
 	ADD	HL,HL	;*10
 	LD	C,A
 	LD	B,0	;BC = new number
 	ADD	HL,BC
 	LD	B,H
 	LD	C,L
 	POP	HL
 	INC	HL
 	JR	VALLP
 MAKNUM	SUB	30H
 	RET	C
 	CP	10
 	CCF
 	RET
 COPY	XOR	A
 	LD	(IY+7),A
 LOOPF	LD	HL,XDRIVES
 	ADD	A,L
 	LD	L,A
 	LD	A,(HL)
 	INC	A
 	CALL	Z,FORMAT
 	INC	(IY+7)
 	LD	A,(IY+7)
 	CP	4
 	JR	C,LOOPF
 	LD	HL,CLRIT
 	CALL	DISPLAY
 	CALL	READ1		;read boot/config
 	LD	HL,WRITE1
 	CALL	DCOMMON
 	CALL	READ2
 	LD	HL,WRITE2
 	CALL	DCOMMON
 	CALL	READ3
 	LD	HL,WRITE3
 DCOMMON	XOR	A
 	LD	(IY+7),A
 	LD	(DCALL),HL
 DCLP	LD	HL,XDRIVES
 	ADD	A,L
 	LD	L,A
 	LD	A,(HL)
 	INC	A
 	CALL	Z,0
 DCALL	EQU	$-2
 	INC	(IY+7)
 	LD	A,(IY+7)
 	CP	4
 	JR	C,DCLP
 	RET
 FORMAT	LD	A,(IY+7)
 	CALL	SETDRV
 	LD	(MSG7A),A
 	LD	HL,MSG7
 	CALL	DISPLAY
 	LD	(IY+8),0
 	CALL	STAT
 	PUSH	HL
 	JP	NZ,REMDRIVE
 	POP	HL
 	CALL	RESTORE
 	JP	NZ,REMWRITE
 FORMLP	CALL	FFLICK
 	CALL	BUILD
 	LD	BC,BUFFER
 	CALL	WRITETR
 	JR	NZ,REMWRITE
 	INC	(IY+8)
 	LD	A,(IY+8)
 	CP	(IY+9)
 	JR	C,FORMLP
 	RET
 REMWRITE PUSH	HL
 	CALL	WERROR
 	JR	REMDRIVE
 REMREAD	PUSH	HL
 	CALL	RERROR
 REMDRIVE CALL	DISPLAY
 	LD	A,(IY+7)
 	ADD	A,30H
 	LD	(MSG21A),A
 	LD	HL,MSG21
 	CALL	DISPLAY
 	LD	HL,XDRIVES
 	LD	A,(IY+7)
 	ADD	A,L
 	LD	L,A
 	LD	(HL),0
 	LD	HL,XDRIVES
 	LD	B,4
 CKLP	LD	A,(HL)
 	INC	A
 	JR	Z,CKDN
 	INC	HL
 	DJNZ	CKLP
 	LD	HL,MSG9
 	CALL	DISPLAY
 	JP	LOOPER
 CKDN	POP	HL
 	OR	1
 	RET
 KIM2	DB	'K'+80H,'i'+80H,'m'+80H,' '+80H
 	DB	'W'+80H,'a'+80H,'t'+80H,'t'+80H
 WERROR	LD	HL,TABLEW
 	JR	RWERR
 RERROR	LD	HL,TABLER
 RWERR	RLCA
 	JR	C,ERRHV
 	INC	HL
 	INC	HL
 	JR	RWERR
 ERRHV	LD	A,(HL)
 	INC	HL
 	LD	H,(HL)
 	LD	L,A
 	RET
 TABLEW	DW	MSG10
 	DW	MSG11
 	DW	MSG12
 	DW	MSG13
 	DW	MSG14
 	DW	MSG15
 	DW	MSG20
 	DW	MSG28
 TABLER	DW	MSG10
 	DW	MSG20
 	DW	MSG20
 	DW	MSG17
 	DW	MSG18
 	DW	MSG19
 	DW	MSG20
 	DW	MSG28
 FFLICK	LD	A,':'#20H
 	PUSH	BC
 	PUSH	HL
 	PUSH	AF
 	LD	HL,(4020H)
 	XOR	(HL)
 	LD	(HL),A
 	INC	HL
 	INC	HL
 	LD	A,(IY+8)
 	CALL	ASCII
 	LD	(HL),C
 	INC	HL
 	LD	(HL),A
 	INC	HL
 	INC	HL
 	POP	AF
 	XOR	(HL)
 	LD	(HL),A
 	POP	HL
 	POP	BC
 	RET
 RFLICK	LD	A,'-'#20H
 	JR	FLICKER
 WFLICK	LD	A,'+'#20H
 	JR	FLICKER
 VFLICK	LD	A,'='#20H
 FLICKER	PUSH	HL
 	PUSH	BC
 	LD	HL,(4020H)
 	PUSH	AF
 	XOR	(HL)
 	LD	(HL),A
 	LD	A,D
 	CALL	ASCII
 	INC	HL
 	INC	HL
 	LD	(HL),C
 	INC	HL
 	LD	(HL),A
 	INC	HL
 	INC	HL
 	POP	AF
 	PUSH	AF
 	XOR	(HL)
 	LD	(HL),A
 	LD	A,E
 	CALL	ASCII
 	INC	HL
 	INC	HL
 	LD	(HL),C
 	INC	HL
 	LD	(HL),A
 	INC	HL
 	INC	HL
 	POP	AF
 	POP	BC
 	PUSH	BC
 	PUSH	AF
 	XOR	(HL)
 	LD	(HL),A
 	INC	HL
 	INC	HL
 	LD	A,B
 	CALL	HEXCV
 	LD	(HL),C
 	INC	HL
 	LD	(HL),A
 	INC	HL
 	LD	(HL),'0'
 	INC	HL
 	LD	(HL),'0'
 	INC	HL
 	INC	HL
 	POP	AF
 	XOR	(HL)
 	LD	(HL),A
 	POP	BC
 	POP	HL
 	RET
 STAT	LD	A,0D0H
 	OUT	(0F0H),A
 	CALL	SELECT
 	LD	HL,MSG24
 	JR	NZ,HOLDER
 	LD	HL,MSG22
 	LD	BC,300H
 TT1	DEC	BC
 	LD	A,B
 	OR	C
 	JR	Z,HOLDER
 	IN	A,(0F0H)
 	AND	2
 	JR	NZ,TT1
 	LD	BC,6000H
 	LD	HL,MSG23
 TT2	DEC	BC
 	LD	A,B
 	OR	C
 	JR	Z,HOLDER
 	IN	A,(0F0H)
 	AND	2
 	JR	Z,TT2
 	LD	HL,MSG22
 	LD	BC,300H
 TT3	DEC	BC
 	LD	A,B
 	OR	C
 	JR	Z,HOLDER
 	IN	A,(0F0H)
 	AND	2
 	JR	NZ,TT3
 	XOR	A
 	RET
 HOLDER	OR	1
 	RET
 VERIFY2	LD	A,(IY+7)
 	CALL	SETDRV
 	LD	(MSG27A),A
 	LD	HL,MSG27
 	CALL	DISPLAY
 	CALL	STAT
 	PUSH	HL
 	JP	NZ,REMDRIVE
 	POP	HL
 	LD	DE,0600H
 	LD	BC,BUFFER
 	LD	(IY+17),6
 	LD	A,(IY+13)
 	LD	(IY+14),A
 VERIFY2L LD	(IY+8),D
 	CALL	VFLICK
 	PUSH	BC
 	LD	BC,VBUFF
 	CALL	READ
 	POP	BC
 	JP	NZ,REMREAD
 	CALL	COMPARE
 	JR	Z,V2OK
 	CALL	REWRITE
 	DEC	(IY+17)
 	JR	NZ,VERIFY2L
 	DEC	(IY+10)
 	JP	NZ,WRITE2Z
 	LD	HL,MSG35
 	PUSH	HL
 	JP	REMDRIVE
 V2OK	INC	B
 	LD	(IY+17),6
 	CALL	NEXT2
 	DEC	(IY+14)
 	JR	NZ,VERIFY2L
 	RET
 WRITE2	LD	(IY+10),3
 WRITE2Z	LD	A,(IY+7)
 	CALL	SETDRV
 	LD	(MSG26A),A
 	LD	HL,MSG26
 	CALL	DISPLAY
 	CALL	STAT
 	PUSH	HL
 	JP	NZ,REMDRIVE
 	POP	HL
 	LD	DE,0600H
 	LD	BC,BUFFER
 	LD	A,(IY+13)
 	LD	(IY+14),A
 WRITE2L	LD	(IY+8),D
 	CALL	WFLICK
 	CALL	WRITE
 	JP	NZ,REMWRITE
 	INC	B
 	CALL	NEXT2
 	DEC	(IY+14)
 	JR	NZ,WRITE2L
 	LD	A,(IY+4)
 	CP	'Y'
 	RET	NZ
 	JP	VERIFY2
 READ3	LD	(IY+10),3
 READ3Z	LD	A,(IY+5)
 	CALL	SETDRV
 	LD	(MSG25A),A
 	LD	HL,MSG25
 	CALL	DISPLAY
 	CALL	STAT
 	JP	NZ,TERMINATE
 	LD	D,(IY+11)
 	LD	E,0
 	LD	BC,BUFFER
 	LD	A,(IY+13)
 	LD	(IY+14),A
 READ3L	LD	(IY+8),D
 	CALL	RFLICK
 	CALL	READ
 	JP	NZ,TERMIN
 	INC	B
 	CALL	NEXSEC
 	DEC	(IY+14)
 	JR	NZ,READ3L
 	LD	A,(IY+4)
 	CP	'Y'
 	RET	NZ
 	LD	A,(IY+5)
 	CALL	SETDRV
 	LD	(MSG27A),A
 	LD	HL,MSG27
 	CALL	DISPLAY
 	LD	D,(IY+11)
 	LD	E,0
 	LD	BC,BUFFER
 	LD	(IY+17),6
 	LD	A,(IY+13)
 	LD	(IY+14),A
 READ3V	LD	(IY+8),D
 	CALL	VFLICK
 	PUSH	BC
 	LD	BC,VBUFF
 	CALL	READ
 	POP	BC
 	JP	NZ,TERMIN
 	CALL	COMPARE
 	JR	Z,READ3P
 	CALL	MOVBUF
 	DEC	(IY+17)
 	JR	NZ,READ3V
 	DEC	(IY+10)
 	JP	NZ,READ3Z
 	LD	HL,MSG35
 	JP	TERMINATE
 READ3P	LD	(IY+17),6
 	INC	B
 	CALL	NEXSEC
 	DEC	(IY+14)
 	JR	NZ,READ3V
 	RET
 WRITE3	LD	(IY+10),3
 WRITE3Z	LD	A,(IY+7)
 	CALL	SETDRV
 	LD	(MSG26A),A
 	LD	HL,MSG26
 	CALL	DISPLAY
 	CALL	STAT
 	PUSH	HL
 	JP	NZ,REMDRIVE
 	POP	HL
 	LD	DE,0601H
 	LD	A,80H
 	LD	(DENSITY),A
 	LD	BC,BUFFER
 	LD	A,(IY+13)
 	LD	(IY+14),A
 WRITE3L	LD	(IY+8),D
 	CALL	WFLICK
 	CALL	WRITE
 	JP	NZ,REMWRITE
 	INC	B
 	CALL	NEXT3
 	DEC	(IY+14)
 	JR	NZ,WRITE3L
 	LD	A,(IY+4)
 	CP	'Y'
 	RET	NZ
 	LD	A,(IY+7)
 	CALL	SETDRV
 	LD	(MSG27A),A
 	LD	HL,MSG27
 	CALL	DISPLAY
 	CALL	STAT
 	PUSH	HL
 	JP	NZ,REMDRIVE
 	POP	HL
 	LD	DE,0601H
 	LD	BC,BUFFER
 	LD	A,80H
 	LD	(DENSITY),A
 	LD	(IY+17),6
 	LD	A,(IY+13)
 	LD	(IY+14),A
 VERIFY3L LD	(IY+8),D
 	CALL	VFLICK
 	PUSH	BC
 	LD	BC,VBUFF
 	CALL	READ
 	POP	BC
 	JP	NZ,REMREAD
 	CALL	COMPARE
 	JR	Z,V3OK
 	CALL	REWRITE
 	DEC	(IY+17)
 	JR	NZ,VERIFY3L
 	DEC	(IY+10)
 	JP	NZ,WRITE3Z
 	LD	HL,MSG35
 	PUSH	HL
 	JP	REMDRIVE
 V3OK	INC	B
 	LD	(IY+17),6
 	CALL	NEXT3
 	DEC	(IY+14)
 	JR	NZ,VERIFY3L
 	RET
 READ2	LD	(IY+10),3
 READ2Z	LD	A,(IY+5)
 	CALL	SETDRV
 	LD	(MSG25A),A
 	LD	HL,MSG25
 	CALL	DISPLAY
 	CALL	STAT
 	JP	NZ,TERMINATE
 	LD	D,(IY+12)
 	LD	E,0
 	LD	BC,BUFFER
 	LD	A,(IY+13)
 	LD	(IY+14),A
 READ2L	LD	(IY+8),D
 	CALL	RFLICK
 	CALL	READ
 	JP	NZ,TERMIN
 	INC	B
 	CALL	NEXSEC
 	DEC	(IY+14)
 	JR	NZ,READ2L
 	LD	A,(IY+4)
 	CP	'Y'
 	RET	NZ
 	LD	A,(IY+5)
 	CALL	SETDRV
 	LD	(MSG27A),A
 	LD	HL,MSG27
 	CALL	DISPLAY
 	LD	D,(IY+12)
 	LD	E,0
 	LD	BC,BUFFER
 	LD	(IY+17),6
 	LD	A,(IY+13)
 	LD	(IY+14),A
 READ2V	LD	(IY+8),D
 	CALL	VFLICK
 	PUSH	BC
 	LD	BC,VBUFF
 	CALL	READ
 	POP	BC
 	JP	NZ,TERMIN
 	CALL	COMPARE
 	JR	Z,READ2P
 	CALL	MOVBUF
 	DEC	(IY+17)
 	JR	NZ,READ2V
 	DEC	(IY+10)
 	JP	NZ,READ2Z
 	LD	HL,MSG35
 	JP	TERMINATE
 READ2P	LD	(IY+17),6
 	INC	B
 	CALL	NEXSEC
 	DEC	(IY+14)
 	JR	NZ,READ2V
 	RET
 READ1	LD	(IY+10),3
 READ1Z	LD	A,(IY+5)
 	CALL	SETDRV
 	LD	(MSG25A),A
 	LD	HL,MSG25
 	CALL	DISPLAY
 	CALL	STAT
 	JP	NZ,TERMINATE
 	LD	DE,0
 	LD	BC,BUFFER
 READ1L	LD	(IY+8),D
 	CALL	RFLICK
 	CALL	READ		;read the sector
 	JP	NZ,TERMIN
 	CALL	NEXSEC		;next sector
 	INC	B
 	LD	A,D
 	CP	4
 	JR	C,READ1L
 	LD	A,(IY+4)
 	CP	'Y'
 	RET	NZ
 	LD	A,(IY+5)
 	CALL	SETDRV
 	LD	(MSG27A),A
 	LD	HL,MSG27
 	CALL	DISPLAY
 	LD	DE,0
 	LD	BC,BUFFER
 	LD	(IY+17),6
 READ1V	LD	(IY+8),D
 	CALL	VFLICK
 	PUSH	BC
 	LD	BC,VBUFF
 	CALL	READ
 	POP	BC
 	JP	NZ,TERMIN
 	CALL	COMPARE
 	JR	Z,READ1P
 	CALL	MOVBUF
 	DEC	(IY+17)
 	JR	NZ,READ1V
 	DEC	(IY+10)
 	JP	NZ,READ1Z
 	LD	HL,MSG35
 	JP	TERMINATE
 READ1P	CALL	NEXSEC
 	LD	(IY+17),6
 	INC	B
 	LD	A,D
 	CP	4
 	JR	C,READ1V
 	RET
 WRITE1	LD	(IY+10),3
 WRITE1Z	LD	A,(IY+7)
 	CALL	SETDRV
 	LD	(MSG26A),A
 	LD	HL,MSG26
 	CALL	DISPLAY
 	LD	DE,0
 	LD	BC,BUFFER
 WRITE1L	LD	(IY+8),D
 	CALL	WFLICK
 	CALL	WRITE
 	JP	NZ,REMWRITE	;remove the drive
 	INC	B
 	CALL	NEXT1		;next pass 1
 	JR	C,WRITE1L	;go if more
 	LD	A,(IY+4)
 	CP	'Y'
 	RET	NZ
 	LD	A,(IY+7)
 	CALL	SETDRV
 	LD	(MSG27A),A
 	LD	HL,MSG27
 	CALL	DISPLAY
 	LD	DE,0
 	LD	BC,BUFFER
 	LD	(IY+17),6
 VERIFY1L LD	(IY+8),D
 	CALL	VFLICK
 	PUSH	BC
 	LD	BC,VBUFF
 	CALL	READ
 	POP	BC
 	JP	NZ,REMREAD
 	CALL	COMPARE
 	JR	Z,V1OK
 	CALL	REWRITE
 	DEC	(IY+17)
 	JR	NZ,VERIFY1L
 	DEC	(IY+10)
 	JP	NZ,WRITE1Z
 	LD	HL,MSG35
 	PUSH	HL
 	JP	REMDRIVE	;remove if from que
 V1OK	INC	B
 	LD	(IY+17),6
 	CALL	NEXT1
 	JR	C,VERIFY1L
 	RET
 NEXT1	XOR	A
 	LD	(DENSITY),A
 	LD	A,D
 	OR	A
 	JR	Z,NEXT10
 	CP	3
 	JR	Z,NEXT10
 	INC	E
 	LD	A,E
 	SUB	10
 	JR	NZ,NEXT1R
 	LD	E,A
 	INC	D
 NEXT1R	LD	A,D
 	CP	4
 	RET
 NEXT10	INC	E
 	LD	A,E
 	SUB	10
 	JR	NZ,NEXT11
 	LD	E,A
 	INC	D
 NEXT11	LD	A,E
 	RRCA
 	LD	A,0
 	JR	NC,NEXT13
 	LD	A,80H
 NEXT13	LD	(DENSITY),A
 	JR	NEXT1R
 NEXSEC	INC	E
 	LD	A,E
 	SUB	10
 	RET	NZ
 	LD	E,A
 	INC	D
 	RET
 SELECT	XOR	A
 	LD	(DRIV0),A
 	LD	A,(IY+8)
 	CP	16H
 	JR	C,SELEC
 	LD	A,20H
 	LD	(DRIV0),A
 SELEC	IN	A,(0F0H)
 	AND	80H
 	PUSH	AF
 	LD	A,0
 DRIVE	EQU	$-1
 	AND	0FH
 	OR	0
 DRIV0	EQU	$-1
 	OR	0
 DENSITY	EQU	$-1
 	LD	(DRIVE),A
 	OUT	(0F4H),A
 	POP	AF
 	RET	Z
 	PUSH	BC
 	LD	BC,0
 	CALL	60H
 	POP	BC
 	IN	A,(0F0H)
 	AND	80H
 	RET
 SETDRV	PUSH	BC
 	PUSH	AF
 	LD	(DRV),A
 	LD	C,1
 	OR	A
 SETDLP	JR	Z,SETDN
 	SLA	C
 	DEC	A
 	JR	SETDLP
 SETDN	LD	A,C
 	LD	(DRIVE),A
 	XOR	A
 	LD	(DENSITY),A
 	POP	AF
 	ADD	A,30H
 	POP	BC
 	RET
 READ	LD	HL,SREAD
 	LD	A,9FH
 	JR	COMMON
 WRITE	LD	HL,SWRITE
 	LD	A,0FFH
 	JR	COMMON
 WRITETR	LD	HL,TWRITE
 	LD	A,0FFH
 COMMON	LD	(VECTOR),HL
 	LD	(MASK),A
 	LD	A,(IY+15)
 	LD	(IY+16),A
 COMMLP	PUSH	BC
 	CALL	0		;call vector
 VECTOR	EQU	$-2
 	POP	BC
 	AND	0
 MASK	EQU	$-1
 	RET	Z		;OK now
 	EX	AF,AF'		;save error
 	LD	A,0D0H
 	OUT	(0F0H),A
 	DEC	(IY+16)
 	JR	NZ,COMMLP	;try again
 	EX	AF,AF'		;restore error
 	RET
 SREAD	CALL	SEEK
 	RET	NZ		;error now
 	LD	(STACK),SP
 	CALL	SETNMI		;setup for NMI return
 	LD	A,80H		;read command
 	OUT	(0F0H),A
 	CALL	DSKSLO		;short wait
 R1	IN	A,(0F0H)
 	AND	E
 	JR	Z,R1
 	INI			;read it
 	LD	A,D
 R2	OUT	(0F4H),A
 	INI
 	JR	NZ,R2
 	JR	$
 SWRITE	CALL	SEEK
 	RET	NZ
 	LD	(STACK),SP
 	CALL	SETNMI
 	LD	A,0A0H
 	OUT	(0F0H),A
 	CALL	DSKSLO
 W1	IN	A,(0F0H)
 	AND	E
 	JR	Z,W1
 	OUTI
 	LD	B,60H
 	DJNZ	$
 	DEC	B
 	LD	A,D
 W2	OUT	(0F4H),A
 	OUTI
 	JR	NZ,W2
 	JR	$
 TWRITE	CALL	SEEK
 	RET	NZ
 	LD	(STACK),SP
 	CALL	SETNMI
 	LD	A,0F0H
 	OUT	(0F0H),A
 	CALL	DSKSLO
 	LD	B,3
 	JP	W0
 SETNMI	LD	(BUFFPASS),BC
 	LD	(SECPASS),DE
 	LD	HL,NMIRET
 	LD	(404AH),HL
 	LD	H,B
 	LD	L,C
 	LD	A,(DRIVE)
 	OUT	(0F4H),A
 	OR	40H
 	LD	D,A
 	DI
 	LD	A,0C0H
 	OUT	(0E4H),A
 	LD	E,2		;for bit 1 mask
 	LD	BC,0F3H		;count, port
 	IN	A,(0F0H)
 	RET
 DSKSLO	EX	(SP),HL
 	EX	(SP),HL
 	EX	(SP),HL
 	EX	(SP),HL
 	EX	(SP),HL
 	EX	(SP),HL
 	RET
 NMIRET	XOR	A
 	OUT	(0E4H),A
 	LD	HL,RETNMI
 	LD	(404AH),HL
 	LD	SP,0
 STACK	EQU	$-2
 	LD	DE,0
 SECPASS	EQU	$-2
 	LD	BC,0
 BUFFPASS EQU	$-2
 	IN	A,(0F0H)
 	EI
 	RET
 SEEK	PUSH	HL
 	LD	HL,CTRACK
 	LD	A,0
 DRV	EQU	$-1
 	ADD	A,L
 	LD	L,A
 	LD	A,(HL)
 	OUT	(0F1H),A
 	OR	A
 	JR	NZ,SEEK0
 	CALL	RESTORE
 	JR	NZ,BADSEEK	;force restore next time
 SEEK0	LD	A,(IY+8)
 	OUT	(0F3H),A
 	CALL	SELECT
 	JR	NZ,BADSEEK
 	LD	A,18H
 	OUT	(0F0H),A
 	CALL	DSKSLO
 SEEKWT	IN	A,(0F0H)
 	BIT	0,A
 	JR	NZ,SEEKWT
 	AND	18H
 	JR	NZ,BADSEEK
 	PUSH	AF
 	LD	A,E
 	OUT	(0F2H),A
 	IN	A,(0F1H)	;get new track
 SEEKRET	LD	(HL),A
 	POP	AF
 	POP	HL
 	RET
 BADSEEK	PUSH	AF
 	XOR	A		;force restore next time
 	JR	SEEKRET
 RESTORE	CALL	SELECT
 	RET	NZ
 	LD	A,8
 	OUT	(0F0H),A
 	CALL	DSKSLO
 RESWT	IN	A,(0F0H)
 	BIT	0,A
 	JR	NZ,RESWT
 	CPL
 	AND	4
 	RET	Z
 	LD	A,1		;use this for error code
 	RET			;NZ = error
 RESULT	LD	HL,CLRLIN
 	CALL	DISPLAY
 	XOR	A
 	LD	(IY+7),A
 RESLP	LD	HL,DRIVES
 	ADD	A,L
 	LD	L,A
 	LD	A,(HL)
 	INC	A
 	JR	NZ,RESNXT
 	LD	A,(IY+7)
 	LD	HL,XDRIVES
 	ADD	A,L
 	LD	L,A
 	LD	A,(HL)
 	INC	A
 	JR	NZ,BADDRV
 	LD	HL,(COUNT)
 	INC	HL
 	LD	(COUNT),HL
 	LD	A,(IY+7)
 	ADD	A,30H
 	LD	(MSG30A),A
 	LD	HL,MSG30
 	CALL	DISPLAY
 	CALL	SHOWSER
 	JR	RESNXT
 BADDRV	LD	A,(IY+7)
 	ADD	A,30H
 	LD	(MSG31A),A
 	LD	HL,MSG31
 	CALL	DISPLAY
 	CALL	SHOWSER
 RESNXT	INC	(IY+7)
 	LD	A,(IY+7)
 	CP	4
 	JR	C,RESLP
 	LD	HL,(COUNT)
 	PUSH	IY
 	LD	IY,MSG32A
 	CALL	WRLNO
 	LD	HL,(COPIES)
 	LD	IY,MSG32B
 	CALL	WRLNO
 	POP	IY
 	LD	HL,MSG32A
 	JP	DISPLAY
 SHOWSER	CALL	FSER
 	EX	DE,HL
 	LD	DE,SERMSGA
 	LD	BC,7
 	LDIR
 	LD	HL,SERMSG
 	JP	DISPLAY
 FSER	LD	A,(IY+7)
 	SLA	A
 	PUSH	HL
 	LD	HL,SERTBL
 	ADD	A,L
 	LD	L,A
 	LD	E,(HL)
 	INC	HL
 	LD	D,(HL)
 	POP	HL
 	RET
 TENTBL	DW	-10000,-1000,-100,-10,-1
 WRLNO	LD	DE,TENTBL
 	PUSH	IY
 WRL1	LD	A,(DE)
 	LD	C,A
 	INC	DE
 	LD	A,(DE)
 	LD	B,A
 	INC	DE
 	PUSH	DE
 	LD	A,2FH
 WRL2	INC	A
 	LD	D,H
 	LD	E,L
 	ADD	HL,BC
 	JR	C,WRL2
 	EX	DE,HL
 	POP	DE
 	LD	(IY),A
 	INC	IY
 	INC	C
 	JR	NZ,WRL1
 	POP	IY
 	LD	B,4
 STPLP	LD	A,(IY)
 	CP	'0'
 	RET	NZ
 	LD	A,20H
 	LD	(IY),A
 	INC	IY
 	DJNZ	STPLP
 	RET
 BUILD	LD	A,(IY+8)
 	PUSH	AF
 	OR	A
 	CALL	Z,ZBUFF
 	POP	AF
 	PUSH	AF
 	CP	3
 	CALL	Z,ZBUFF
 	POP	AF
 	CP	6
 	CALL	Z,ZBUFF
 	JP	BUILDTRK
 TESTMEM	LD	HL,VBUFF	;start of buffer area
 TESTLP	LD	A,-1
 	LD	(HL),A
 	CP	(HL)
 	JR	NZ,BADMEM
 	XOR	A
 	LD	(HL),A
 	CP	(HL)
 	JR	NZ,BADMEM
 	INC	HL
 	LD	A,H
 	OR	L
 	JR	NZ,TESTLP
 	RET
 BADMEM	LD	HL,MSG34
 	CALL	DISPLAY
 DEAD	JP	DEAD
 COMPARE	PUSH	HL
 	PUSH	DE
 	PUSH	BC
 	LD	D,B
 	LD	E,0
 	LD	HL,VBUFF
 	LD	B,0
 COMPLP	LD	A,(DE)
 	CP	(HL)
 	JR	NZ,COMPRET
 	INC	DE
 	INC	HL
 	DJNZ	COMPLP
 	XOR	A
 COMPRET	POP	BC
 	POP	DE
 	POP	HL
 	RET
 NEXT2	INC	E
 	INC	E
 	LD	A,E
 	SUB	12
 	JR	NZ,NEXOK
 	LD	E,A
 	INC	D
 NEXOK	LD	A,D
 	CP	33
 	RET
 NEXT3	INC	E
 	INC	E
 	LD	A,E
 	SUB	13
 	JR	NZ,NEXOK
 	LD	E,1
 	INC	D
 	JR	NEXOK
 BUILDTRK	LD	A,0F7H
 	LD	(CRC1),A
 	LD	(CRC2),A
 	LD	A,(IY+8)
 	OR	A
 	JP	Z,BUILDTK0
 	CP	3
 	JP	Z,BUILDTK0
 	CP	6
 	JP	NC,BUILDTK0
 	PUSH	AF
 	XOR	A
 	LD	(CRC1),A
 	POP	AF
 	CP	4
 	JP	Z,BUILDTK0
 	PUSH	AF
 	LD	A,0F7H
 	LD	(CRC1),A
 	XOR	A
 	LD	(CRC2),A
 	POP	AF
 	CP	5
 	JP	Z,BUILDTK0
 	LD	A,0F7H
 	LD	(CRC1),A
 	LD	(CRC2),A
 	LD	HL,ORDER
 	LD	DE,BUFFER
 FIGBUILD LD	C,(HL)
 	INC	HL
 	PUSH	DE
 	LD	E,(HL)
 	INC	HL
 	LD	D,(HL)
 	INC	HL
 	EX	DE,HL
 	EX	(SP),HL
 	CALL	MOVEIN
 	LD	(DESVE),DE
 SECLP	CALL	MOVEIN
 	CALL	MOVEIN
 	LD	(HL),0FEH
 	INC	HL
 	LD	A,(IY+8)
 	LD	(HL),A
 	INC	HL
 	LD	(HL),0
 	INC	HL
 	EX	(SP),HL
 	LD	A,(HL)
 	INC	HL
 	EX	(SP),HL
 	LD	(HL),A
 	INC	HL
 	LD	(HL),1
 	INC	HL
 	LD	(HL),0F7H
 CRC1	EQU	$-1
 	INC	HL
 	CALL	MOVEIN
 	CALL	MOVEIN
 	CALL	MOVEIN
 	LD	(HL),0FBH
 	INC	HL
 	LD	A,0
 	CALL	FILL
 	LD	(HL),0F7H
 CRC2	EQU	$-1
 	INC	HL
 	CALL	MOVEIN
 	LD	DE,0
 DESVE	EQU	$-2
 	DEC	C
 	JR	NZ,SECLP
 	INC	SP
 	INC	SP
 	DEC	DE
 	LD	A,(DE)
 	LD	B,62
 	JP	FILL
 ORDER	DB	10
 	DW	ORDERD
 	DB	1FH,0FFH
 	DB	3,0
 	DB	3,0
 	DB	0BH,0FFH
 	DB	3,0
 	DB	3,0
 	DB	0BH,0FFH
 ORDERD	DB	0,5,1,6,2,7,3,8,4,9
 ORDER1	DB	6
 	DW	ORDERD1
 	DB	31,0FFH
 	DB	3,0
 	DB	3,0
 	DB	11,0FFH
 	DB	3,0
 	DB	3,0
 	DB	11,0FFH
 ORDERD1	DB	0,6,2,8,4,10
 ORDER2	DB	6
 	DW	ORDERD2
 	DB	62,4EH
 	DB	12,0
 	DB	3,0F5H
 	DB	22,4EH
 	DB	12,0
 	DB	3,0F5H
 	DB	22,4EH
 ORDERD2	DB	1,5,9,3,7,11
 MOVEIN	LD	A,(DE)
 	INC	DE
 	LD	B,A
 	LD	A,(DE)
 	INC	DE
 FILL	LD	(HL),A
 	INC	HL
 	DJNZ	FILL
 	RET
 W0	LD	A,(IY+8)
 	OR	A
 	JP	Z,W0SPCL
 	CP	3
 	JP	NC,W0SPCL
 WW101	IN	A,(0F0H)
 	AND	B
 	JP	PO,WW101
 	OUTI
 WW102	LD	A,D
 	OUT	(0F4H),A
 	IN	A,(0F0H)
 	AND	E
 	JR	Z,WW102
 	OUTI
 	LD	A,D
 WW103	OUT	(0F4H),A
 	OUTI
 	JP	WW103
 ZBUFF	LD	HL,BUFFER
 	LD	DE,BUFFER+1
 	LD	BC,3000H
 	LD	(HL),0
 	DI
 	LDIR
 	EI
 	RET
 BUILDTK0	LD	DE,BUFFER
 	LD	HL,ORDER1
 	CALL	FIGBUILD
 	EX	DE,HL
 	LD	HL,ORDER2
 	JP	FIGBUILD
 W0SPCL	IN	A,(0F0H)
 	AND	B
 	JP	PO,W0SPCL
 	OUTI
 	LD	B,-1
 WS2	LD	A,D
 	OUT	(0F4H),A
 	IN	A,(0F0H)
 	AND	E
 	JR	Z,WS2
 	OUTI
 	LD	A,D
 WS3	OUT	(0F4H),A
 	OUTI
 	JR	NZ,WS3
 WS4	OUT	(0F4H),A
 	OUTI
 	JR	NZ,WS4
 WS40	OUT	(0F4H),A
 	OUTI
 	JR	NZ,WS40
 WS41	OUT	(0F4H),A
 	OUTI
 	JR	NZ,WS41
 WS42	OUT	(0F4H),A
 	OUTI
 	JR	NZ,WS42
 WS43	OUT	(0F4H),A
 	OUTI
 	JR	NZ,WS43
 WSS44	OUT	(0F4H),A
 	OUTI
 	JR	NZ,WSS44
 	LD	B,58
 WS5	OUT	(0F4H),A
 	OUTI
 	JR	NZ,WS5
 	SET	7,A
 WS6	OUT	(0F4H),A
 	OUTI
 	JR	WS6
 ASCII	LD	C,'0'
 ASC1	SUB	10
 	JR	C,ASC2
 	INC	C
 	JR	ASC1
 ASC2	ADD	A,3AH
 	RET
 SERIALNOS
 	LD	A,(IY+6)
 	CP	'Y'
 	JR	Z,DOAUTO
 	XOR	A
 	LD	(IY+7),A
 SERLP	LD	HL,DRIVES
 	ADD	A,L
 	LD	L,A
 	LD	A,(HL)
 	INC	A
 	CALL	Z,GETSER
 	INC	(IY+7)
 	LD	A,(IY+7)
 	CP	4
 	JR	C,SERLP
 	RET
 DOAUTO	XOR	A
 	LD	(IY+7),A
 AUTOLP	LD	HL,DRIVES
 	ADD	A,L
 	LD	L,A
 	LD	A,(HL)
 	INC	A
 	CALL	Z,ASERIAL
 	INC	(IY+7)
 	LD	A,(IY+7)
 	CP	4
 	JR	C,AUTOLP
 	RET
 ASERIAL	CALL	FSER
 	LD	HL,SERX
 	LD	BC,7
 	LDIR
 	LD	HL,SERX+6
 	LD	B,7
 NEWSER	INC	(HL)
 	LD	A,(HL)
 	CP	3AH
 	RET	C
 	LD	(HL),'0'
 	DEC	HL
 	DJNZ	NEWSER
 	RET
 GETSER	LD	A,(IY+7)
 	ADD	A,30H
 	LD	(MSG38A),A
 	LD	HL,MSG38
 	CALL	DISPLAY
 	LD	B,7
 	CALL	GETSTR
 	LD	A,B
 	CP	7
 	JR	NZ,GETSER
 	CALL	FSER
 	LD	C,B
 	LD	B,0
 	LDIR
 	RET
 PUTSERIAL LD	HL,MSG39
 	CALL	DISPLAY
 	XOR	A
 	LD	(IY+7),A
 PUTSLP	LD	HL,XDRIVES
 	ADD	A,L
 	LD	L,A
 	LD	A,(HL)
 	INC	A
 	CALL	Z,THISONE
 	INC	(IY+7)
 	LD	A,(IY+7)
 	CP	4
 	JR	C,PUTSLP
 	RET
 THISONE
 	LD	A,(IY+7)
 	CALL	SETDRV
 	LD	BC,BUFFER
 	LD	DE,0302H
 	LD	(IY+8),D
 	CALL	READ
 	JP	NZ,REMREAD
 	CALL	DOTHIS
 	CALL	WRITE
 	JP	NZ,REMWRITE
 	LD	A,(IY+4)
 	CP	'Y'
 	JR	NZ,SKSVER
 	PUSH	BC
 	LD	BC,VBUFF
 	CALL	READ
 	POP	BC
 	JP	NZ,REMREAD
 	CALL	COMPARE
 	JR	Z,SKSVER
 	LD	HL,MSG35
 	PUSH	HL
 	JP	REMDRIVE
 SKSVER	INC	E
 	LD	A,80H
 	LD	(DENSITY),A
 	CALL	READ
 	JP	NZ,REMREAD
 	CALL	DOTHIS
 	CALL	WRITE
 	JP	NZ,REMWRITE
 	LD	A,(IY+4)
 	CP	'Y'
 	RET	NZ
 	PUSH	BC
 	LD	BC,VBUFF
 	CALL	READ
 	POP	BC
 	JP	NZ,REMREAD
 	CALL	COMPARE
 	RET	Z
 	LD	HL,MSG35
 	PUSH	HL
 	JP	REMDRIVE
 DOTHIS	PUSH	DE
 	PUSH	BC
 	CALL	FSER
 	EX	DE,HL
 	LD	DE,BUFFER+0DBH
 	LD	BC,0700H
 THISLP	LD	A,(HL)
 	XOR	44H
 	LD	(DE),A
 	NEG
 	ADD	A,C
 	LD	C,A
 	INC	HL
 	INC	DE
 	DJNZ	THISLP
 	POP	BC
 	POP	DE
 	LD	(BUFFER+0DAH),A
 	RET
 HEXCV	LD	B,A
 	SRL	A
 	SRL	A
 	SRL	A
 	SRL	A
 	CALL	HEXTST
 	LD	C,A
 	LD	A,B
 	AND	0FH
 HEXTST	ADD	A,30H
 	CP	3AH
 	RET	M
 	ADD	A,7
 	RET
 MOVBUF	PUSH	DE
 	PUSH	BC
 	LD	D,B
 	LD	E,C
 	LD	HL,VBUFF
 	LD	BC,100H
 	LDIR
 	POP	BC
 	POP	DE
 	RET
 REWRITE	CALL	WRITE
 	JP	NZ,REMWRITE
 	RET
 DBUFF	EQU	$&0FF00H
 VBUFF	EQU	DBUFF+100H
 BUFFER	EQU	VBUFF+200H
 	END	ENTRY
