; susub2/asm - kjw/bqsd - 08/78 - version 3.0 - 11/82
;
	PAGE
;
	SUBTTL	'<SUSUB2/ASM - Subroutine Section 2>'
;
;	$FLICKS - flash cursor and fetch a key
;
;	ENT	B  = OFF byte to display
;		C  = ON byte to display
;		HL = video location for flash
;		A  = flash speed byte
;
;	EXT	A = character input from keyboard
;		cursor byte turned off
;
FLICKS	LD	(FLK2),A	;save init count
	LD	(HL),C		;turn on prompt
;
FLKRES	LD	A,0		;get init counter
FLK2	EQU	$-1
	LD	(FLK1),A	;countdown counter
;
FLKWT	CALL	INKEY		;fetch a key
	JR	NZ,FLKDON	;have one, go!
;
	LD	A,0		;get countdown
FLK1	EQU	$-1
	DEC	A		;less count
	LD	(FLK1),A	;put it back
	JR	NZ,FLKWT	;wait if not time
;
	LD	A,(HL)		;get video char
	CP	C		;on?
	LD	A,C		;get on byte
	JR	NZ,FLKPUT	;put on video
	LD	A,B		;get off byte
FLKPUT	LD	(HL),A		;display it
	JR	FLKRES		;reset counter
;
FLKDON	LD	(HL),B		;put OFF byte
	RET			;done, A = char
;
;	$FLICKSP - special cursor activity
;
;	ENT	DE = buffer address
;		IX = HEX side of video display
;		IY = ASCII side of video display
;		B  = off character to display
;		C  = on character, if 0 use $MODIFX
;		A  = flash delay time
;
;	EXT	A = char input from keyboard
;		display restored to normal
;
FLICKSP	LD	(FLICK4),A	;save reset byte
	LD	(IX+0),B	;turn on flick
	LD	(IX+1),B
	LD	(IY+0),B
;
FLKSRET	LD	A,0		;get reset byte
FLICK4	EQU	$-1
	LD	(FLICK3),A	;reset counter
;
FLKSWT	CALL	INKEY		;check for a key
	JR	NZ,FLKSDON	;have one, go!
;
	LD	A,0		;get counter
FLICK3	EQU	$-1
	DEC	A		;less one
	LD	(FLICK3),A	;put it back
	JR	NZ,FLKSWT	;not time to change curs.
;
	LD	A,(IX)		;get video byte
	CP	B		;is it off?
	JR	NZ,FLICK5	;nope, turn it off
;
	INC	C		;check for 0
	DEC	C		;is it?
	JR	NZ,FLICK6	;nope, turn it on
;
	CALL	MODFIX		;reset display
	JR	FLKSRET		;reset counters
;
FLICK5	LD	A,B		;get OFF byte
	JR	FLICK7		;go common
;
FLICK6	LD	A,C		;get ON byte
;
FLICK7	LD	(IX),A		;to hex side
	LD	(IX+1),A	;2 chars per byte
	LD	(IY),A		;to ascii side
	JR	FLKSRET		;reset counters
;
FLKSDON	PUSH	AF		;save character
	CALL	MODFIX		;reset video display
	POP	AF		;restore character
	RET			;return with it
;
	PAGE
;
;	$HEXCV - convert binary to hex ascii
;
;	ENT	A = byte to convert
;
;	EXT	CB = converted byte in hex ascii
;
HEXCV	LD	B,A		;save the byte
	RRCA			;align to low nibble
	RRCA
	RRCA
	RRCA
	CALL	HEXTST		;adjust digit to ascii
	LD	C,A		;save MSB here
;
	LD	A,B		;fetch again
	CALL	HEXTST		;adjust to hex
	LD	B,A		;save LSB here
	RET			;done, CB = hex ascii
;
HEXTST	AND	0FH		;low 4 bits only
	ADD	A,'0'		;add ascii to it
	CP	'9'+1		;0-9?
	RET	C		;yes, done!
	ADD	A,7		;adjust for A-F
	RET			;done, return
;
	PAGE
;
;	$SHOWST	- display error status byte in A
;
;	ENT	A = error status byte
;		Carry set = READ operation
;
;	EXT	error message(s) displayed
;
;	All registers preserved except F
;
SHOWST	RST	8		;send initial linefeed
;
	DEFB	LF		;all registers preserved
	DEFB	ETX
;
	BIT	7,A		;drive time out?
	JR	Z,BIT6		;nope, continue
	RST	@08		;else display message
;
	DEFM	'Drive TIME OUT'
	DEFB	LF
	DEFB	ETX
;
BIT6	JR	C,BIT4		;go if read
	BIT	6,A		;write protect?
	JR	Z,BIT5		;nope, check bit 5
	RST	@08		;display error
;
	DEFM	'WRITE PROTECTED Disk'
	DEFB	LF
	DEFB	ETX
;
BIT5	BIT	5,A		;hardware fault?
	JR	Z,BIT4		;nope, go!
	RST	@08		;else display error
;
	DEFM	'HARDWARE Write Fault'
	DEFB	LF
	DEFB	ETX
;
BIT4	BIT	4,A		;not found error?
	JR	Z,BIT3		;nope, check CRC
	RST	@08		;display error
;
	DEFM	'Sector NOT FOUND'
	DEFB	LF
	DEFB	ETX
;
BIT3	BIT	3,A		;CRC error?
	JR	Z,BIT2		;nope, continue
	BIT	4,A		;error in ID field?
	JR	Z,DATERR	;nope, go DATA CRC error
	RST	@08		;display error
;
	DEFM	'ID CRC Error'
	DEFB	LF
	DEFB	ETX
;
	JR	BIT2		;continue
;
DATERR	RST	@08		;display error
;
	DEFM	'DATA CRC Error'
	DEFB	LF
	DEFB	ETX
;
BIT2	BIT	2,A		;data lost?
	JR	Z,BIT1		;nope, continue
	RST	@08		;display error
;
	DEFM	'DATA LOST'
	DEFB	LF
	DEFB	ETX
;
BIT1	BIT	1,A		;special error bit
	JR	Z,BIT0		;go if not
	RST	@08		;display error
;
	DEFM	'Drive DROPPED READY'
	DEFB	LF
	DEFB	ETX
;
BIT0	BIT	0,A		;not completed?
	RET	Z		;nope, continue
	RST	@08		;display
;
	DEFM	'Interrupt on Pending Command'
	DEFB	LF
	DEFB	ETX
;
	RET
;
	PAGE
;
;	$SHOWWH	- display current drive, track, sector
;
;	ENT	current drive has been set up
;		DE = track/sector
;
;	EXT	message displayed to video
;
SHOWWH	PUSH	AF		;save registers
	PUSH	BC
;
	CALL	DRVASC		;get ascii drive #
	LD	(WHDR),A	;put in the string
;
	LD	A,E		;get sector
	RST	@18		;to decimal ascii
	LD	(WHSC),A	;to the string
	LD	(WHSC+1),BC
;
	LD	A,D		;get the track
	RST	@18		;to decimal ascii
	LD	(WHTR),A	;to the string
	LD	(WHTR+1),BC
;
	RST	@08		;display it
;
	DEFM	'Drive '
WHDR	DEFM	'x, Track '
WHTR	DEFM	'xxx, Sector '
WHSC	DEFM	'xxx'
	DEFB	ETX
;
	POP	BC		;unstack & return
	POP	AF
	RET
;
	PAGE
;
;	$BADRD	 - disk read error monitor
;	$BADWRT  - disk write error monitor
;	$BDRDCLS - read monitor with clear screen
;	$BDWTCLS - write monitor with clear screen
;
;	ENT	drive setup as accessed
;		DE = track sector
;		A = error status byte
;
;	EXT	NZ = RETRY selected
;		Z  = SKIP selected
;
;	if BREAK is pressed, program will abort
;	back to the last sub-menu
;
BDRDCLS	LD	HL,BADRD	;bad read monitor
	JR	BDWTCLS+3	;go common
;
BDWTCLS	LD	HL,BADWRT	;bad write monitor
	LD	(BADCLSD),HL	;save vector
;
	PUSH	AF		;save error code
	LD	A,(FLAGA)	;get system flag
	RES	1,A		;turn on 'alive'
	LD	(FLAGA),A	;put it back
	POP	AF		;restore status
;
	RST	@08		;clear the screen
;
	DEFB	CLSF
	DEFB	ETX
;
	CALL	0		;call the vector
BADCLSD	EQU	$-2
	RST	@08		;clear screen again
;
	DEFB	CLSA
	DEFB	ETX
;
	RET			;back with result
;
;	bad read monitor
;	may be turned off by inserting a RET @ $BADRD
;
BADRD	NOP
	RST	@08		;display message
;
	DEFB	LF
	DEFB	LF
	DEFM	'Disk READ ERROR'
	DEFB	LF
	DEFB	ETX
;
	SCF			;C = read error
	JR	RWCNT1		;go common
;
;	bad write monitor
;	may be disabled by placing a RET opcode at BADWRT
;
BADWRT	NOP
	RST	@08		;display message
;
	DEFB	LF
	DEFB	LF
	DEFM	'Disk WRITE ERROR'
	DEFB	LF
	DEFB	ETX
;
	OR	A		;no carry = write
;
RWCNT1	CALL	SHOWWH		;display error source
	CALL	SHOWST		;display error message(s)
;
;	check for CLEAR key disabling NONSTOP
;
	LD	A,(3840H)	;read keyboard
	AND	2		;clear pressed?
	JR	Z,RWCNT		;nope, continue
;
	XOR	A		;NOP opcode
	LD	(BWRTCPT),A	;intercept bytes
	LD	(NONSTP),A	;turn off nonstop
;
RWCNT	OR	1		;set error mon flag
	LD	(ZAPFLAG),A	;save it
;
BWRTCPT	NOP
;
NONSTP	NOP
;
RETRY	RST	@08		;display message
;
	DEFB	EOL		;clear this line
	DEFM	'R>etry, S>kip, C>ontinuous, '
	DEFM	'N>onstop, Q>uit ? '
	DEFB	ETX
;
	PUSH	BC		;save needed registers
	PUSH	HL
;
	LD	B,1		;one key input
	RST	@10		;get from keyboard
;
	POP	HL		;unstack
	POP	BC
;
	JR	NZ,RETRY1	;input, interpret it
	LD	A,'R'		;else default to RETRY
;
RETRY1	CALL	UCASE		;make it upper case
;
	CP	'S'		;skip?
	JR	Z,DOSKIP
;
	CP	'R'		;retry?
	JR	Z,DORETRY
;
	CP	'N'		;nonstop?
	JR	Z,NOSPT
;
	CP	'Q'		;quit?
	JP	Z,SUBMENU	;back to sub-menu pronto
;
	CP	'C'		;continuous?
	JR	NZ,RETRY	;invalid, try again
;
	LD	A,0C9H		;RET opcode
	LD	(BWRTCPT),A	;set continuous
;
DORETRY	OR	1		;return NZ for retry
;
	RST	@08		;display linefeed
;
	DEFB	LF
	DEFB	ETX
;
	RET			;back to caller
;
NOSPT	LD	A,0C9H		;RET opcode
	LD	(NONSTP),A	;set NONSTOP
	JR	DORETRY		;return NZ
;
DOSKIP	INC	B		;bump buffer pointer
	XOR	A		;set Z
	SCF			;set carry for detect
	JR	DORETRY+2	;linefeed and return
;
;	initialize various non-stop proceedures
;
INITBAD	XOR	A		;turn off continuous
	LD	(BWRTCPT),A	;set it up
	RET			;done
;
INITBD1	XOR	A		;turn of nonstop
	LD	(NONSTP),A	;set it up
;
INITBD3	LD	(BADRD),A	;enable $BADRD
	LD	(BADWRT),A	;enable $BADWRT
	RET			;done
;
INITBD2	LD	A,0C9H		;RET opcode
	JR	INITBD3		;disable $BADRD/$BADWRT
;
	PAGE
;
;	$SAVEREG - save registers on stack
;
;	ENT	none
;
;	EXT	all registers EXCEPT AF saved on stack
;
;	AF' destoryed
;
SAVEREG	EX	AF,AF'		;save AF
	POP	AF		;get caller address
;
	PUSH	IY		;push 'em
	PUSH	IX
	PUSH	BC
	PUSH	DE
	PUSH	HL
;
;	leave return address on stack
;
	PUSH	HL		;push again
	LD	HL,REGFIX	;return vector
	EX	(SP),HL		;leave on stack, fetch HL
;
	PUSH	AF		;put caller back
	EX	AF,AF'		;restore AF
	RET			;back to caller
;
;	unstacker
;
REGFIX	POP	HL		;unstack & return
	POP	DE
	POP	BC
	POP	IX
	POP	IY
	RET			;done
;
	PAGE
;
;	$SHOREAD - read sector with display
;
;	ENT	DE = track/sector
;		BC = buffer
;		(DRIVE) already setup
;
;	EXT	Z = OK
;		NZ = error
;
SHOREAD	CALL	DLOFF		;turn off dual for prompt
	RST	@08		;display following
;
	DEFB	BOL		;cur to begin of line
	DEFM	'Reading    '
	DEFB	ETX
;
	CALL	DLON		;re-activate dual
;
;	setup stack for common vector
;
	LD	HL,READ		;sector read
	PUSH	HL		;to the stack
	LD	HL,BADRD	;error monitor
	PUSH	HL		;to the stack
	LD	HL,SHOREAD	;return back to here
	RES	3,(IY+3)	;operation is READ
	JR	SHRWCOM		;go common
;
;	$SHOWRIT - write sector with display
;
;	ENT	same as $SHOREAD
;
;	EXT	same
;
SHOWRIT	CALL	DLOFF		;deactivate dual
	RST	@08		;display message
;
	DEFB	BOL		;BOL
	DEFM	'Writing    '
	DEFB	ETX
;
	CALL	DLON		;re-activate dual
;
	LD	HL,WRITE	;sector write
	PUSH	HL		;to the stack
	LD	HL,BADWRT	;error monitor
	PUSH	HL		;to the stack
	LD	HL,SHOWRIT	;return back to here
	SET	3,(IY+3)	;operation is WRITE
	JR	SHRWCOM		;go common
;
;	$SHOVERF - verify sector with display
;
;	ENT	same as $SHOREAD
;
;	EXT	same
;
SHOVERF	CALL	SHVERF		;display prompt
	LD	HL,READ		;sector read
	PUSH	HL		;to the stack
	LD	HL,BADRD	;error monitor
	PUSH	HL		;to the stack
	LD	HL,SHOVERF	;vector back here
	RES	7,(IY+5)	;operation is READ
;
;	$SHRWCOM - read/write/verify with display
;
;	ENT	header message already displayed
;		DE = track/sector
;		BC = data buffer
;		(DRIV) setup for disk activity
;		HL = vector back to initial call
;		(SP) = call vector for error monitor
;		(SP+2) = call vector for disk I/O
;
;	EXT	Z = OK
;		NZ = error
;
;	NOTE	if 'skip' is selected on a bad read/write
;		an error counter is bumped at $ADDCNT
;
;
SHRWCOM	LD	(SHO003),HL	;save vector back
	POP	HL		;get monitor address
	LD	(SHO002),HL	;save vector
	POP	HL		;get I/O vector
	LD	(SHO001),HL	;save vector
;
	CALL	DLOFF		;turn off dual for disply
	CALL	SHOWWH		;display drive,track,sec
	CALL	DLON		;dual back on
;
	CALL	0		;call disk I/O
SHO001	EQU	$-2
	RET	Z		;successful, return
;
	CALL	0		;call error monitor
SHO002	EQU	$-2
	JP	C,ADDCNT	;bump 'skip' counter
;
	CALL	DSTAT		;check status again
	RET	NZ		;skip, return
	JP	0		;try again
SHO003	EQU	$-2
;
;	display title for verifying
;
SHVERF	CALL	DLOFF		;dual deactive
	RST	@08		;display
;
	DEFB	BOL		;cursor to begin of row
	DEFM	'Verifying  '
	DEFB	ETX
;
	JP	DLON		;dual back on & return
;
;	$SHOVERX - 2 attempts to read sector
;
SHOVERX	CALL	SHVERF		;display message
	CALL	SHOWWH		;show data source
	CALL	READ		;read a sector
	CALL	NZ,READ		;try again if not good
	RET			;that's all, Z = OK
;
;	$SHOFMT - format track with display
;
SHOFMT	LD	A,(IY+3)	;get current track
	PUSH	BC		;save buffer
	RST	@18		;to decimal ascii
	LD	(FTR),A		;to the string
	LD	(FTR+1),BC
	CALL	DRVASC		;ascii drive number
	LD	(FDR),A		;put in string
	POP	BC		;restore buffer
	CALL	DLOFF		;dual deactive
	RST	@08		;display
;
	DEFB	BOL		;beginning of curr line
	DEFM	'Formatting Drive '
FDR	DEFM	'x, Track '
FTR	DEFM	'xxx                 '
	DEFB	ETX
;
	CALL	DLON		;dual back on
	CALL	WRITETR		;write the track
	RET	Z		;successful
;
;	error on track write, display error
;
	AND	64H		;bits 6,5 and 2 only
	JP	SHOWST		;display error
;
	PAGE
;
;	$INITCNT $ADDCNT $SHOCNT
;	$INITACNT $ADDACNT $SHOACNT
;
;	initialize, add, and display alternate counters
;	each is independent any may value to 99999
;	no registers are used to increment the counters
;	normally, the first counter ($CNT) will
;	be used to keep track of the number of sectors
;	'skipped' in multiple sector operations
;
;	display counters
;
SHOACNT	LD	HL,(XACOUNT)	;get $ACNT counter
	JR	SHOCNT+3	;go common
;
SHOCNT	LD	HL,(XCOUNT)	;get $CNT counter
	PUSH	IY		;save DCT pointer
	LD	IY,CNTMSG	;text for counter
	CALL	BINASC		;convert decimal ascii
	POP	IY		;restore it
	RST	@08		;display it
;
	DEFB	LF		;linefeed first
CNTMSG	DEFM	'xxxxx '
	DEFB	ETX
;
	RET			;back to caller
;
;	initialize counters
;
INTACNT	PUSH	HL		;must save it
	LD	HL,XACOUNT	;counter word
	JR	INTCNT+4	;go common
;
INTCNT	PUSH	HL		;save it
	LD	HL,XCOUNT	;counter word
	LD	(HL),0		;zero LSB
	INC	HL		;bump pointer
	LD	(HL),0		;zero MSB
	POP	HL		;restore HL
	RET			;done
;
;	increment counters
;
ADDACNT	PUSH	HL		;save it
	LD	HL,XACOUNT	;counter
	JR	ADDCNT+4	;go common
;
ADDCNT	PUSH	HL		;save it
	LD	HL,XCOUNT	;counter
	INC	(HL)		;bump LSB
	JR	NZ,ADDCLP	;go if not 0
	INC	HL		;point to MSB
	INC	(HL)		;bump MSB
ADDCLP	POP	HL		;restore HL
	RET			;back to caller
;
	PAGE
;
;	$GETCNT - prompt user for sector count
;
;	ENT	none
;
;	EXT	HL = sector count
;
;	NOTE	if enter is pressed alone, then the
;		total number of sectors on the disk
;		is the default value
;
GETCNT	RST	@08		;display linefeed
;
	DEFB	LF
	DEFB	ETX
;
BADCNT	RST	@08		;display prompt
;
	DEFB	EOL		;clear current line
	DEFM	'Sector Count ? '
	DEFB	ETX
;
	PUSH	BC		;save it
	LD	B,15		;allow 15 char input
	RST	@10		;fetch from keyboard
	JR	Z,CNTOTAL-1	;default to total count
	CALL	VALUE		;compute string value
	LD	H,B		;give it to hl
	LD	L,C
	POP	BC		;restore this
	JR	C,BADCNT	;bad input
	RET			;else HL has it
;
	PAGE
;
;	$CNTOTAL - compute the total number of sectors
;
;	ENT	none
;
;	EXT	HL = total number of sectors on disk
;
	POP	BC		;dummy pop for above
CNTOTAL	PUSH	BC		;need it
	LD	C,(IY+0)	;get track count
	LD	B,0		;BC = track count
	LD	H,B		;load HL with 0
	LD	L,B
;
	LD	A,10		;10 sectors single den
	BIT	6,(IY+6)	;double density?
	JR	Z,CNTLP		;nope, go single
	LD	A,18		;18 sectors double den
;
CNTLP	ADD	HL,BC		;add # tracks
	DEC	A		;go till sector count
	JR	NZ,CNTLP	;finish it up
;
;	check if double sided
;
	BIT	0,(IY+5)	;side 2 available?
	JR	Z,CNTRET	;continue if not
	ADD	HL,HL		;double it
	BIT	6,(IY+4)	;single density?
	JR	Z,CNTRET	;yes, done
	BIT	7,(IY+4)	;track 0 double den?
	JR	NZ,CNTRET	;yes, done!
;
;	disk is double den with single den
;	track 0, remove 8 sectors from count
;
	LD	BC,-8		;adjust for single tk 0
	ADD	HL,BC		;HL = new total
	BIT	0,(IY+5)	;2 sides?
	JR	Z,CNTRET	;go if not
	ADD	HL,BC		;remove 8 more
;
CNTRET	POP	BC
	RET
;
	PAGE
;
;	$MREAD - $MWRITE - $MVERIFY
;	multiple sector read/write/verify
;
;	ENT	DE = track/sector to start
;		BC = start buffer
;		HL = number of sectors to read/write/ver
;
;	EXT	HL = number of remaining sectors
;		DE = next track/sector
;		BC = next buffer address
;		C  = attempt to read beyond diskette
;		NZ = error
;
;	NOTE	these routines will all honor topmem
;		and return when the buffer has been
;		filled.  The user must test HL to
;		see if any sectors are pending
;	NOTE	the associated write byte to re-create
;		each sectors data address marks is
;		placed sequentially in a buffer starting
;		at $DAMBUFF
;
;
MVERIFY	PUSH	HL		;save count
	LD	HL,SHOVERF	;routine address
	JR	MCOMM		;go common routine
;
MREAD	PUSH	HL		;save count
	LD	HL,SHOREAD	;routine
	JR	MCOMM		;go common
;
MWRITE	PUSH	HL		;save count
	LD	HL,SHOWRIT	;I/O vector
;
MCOMM	LD	(MLADD),HL	;put in call code
	CALL	INITBAD		;allow monitor
	POP	HL		;restore counter
	LD	IX,DAMBUFF	;Data Address Marks buff
;
MCLP	PUSH	HL		;save from call
;
;	fetch write byte from buffer
;	check to see that a valid sector write
;	command is there and not a 'write track'
;	byte or something else disastrous
;	if out of range, force a standard IBM write
;
	LD	A,(IX)		;get write type byte
	AND	0FH		;force to proper limits
	OR	0A0H		;now for sure in range
	LD	(WRTYPE),A	;pass to write command
	CALL	0		;call the read/write/ver
MLADD	EQU	$-2
	POP	HL		;restore count
	BIT	7,(IY+5)	;current operation write?
	JR	NZ,NOTABF	;don't put byte in buff
	EX	AF,AF'		;get write byte
	LD	(IX),A		;put in buffer
NOTABF	INC	IX		;bump buffer
;
	DEC	HL		;less one sector done
	CALL	NEXSEC		;advance DE to next sect
	JR	NC,MALDD00	;continue if not disk end
	LD	HL,0		;else set 0 left to go
;
MALDD00	LD	A,H		;any more left
	OR	L		;HL = 0?
	RET	Z		;done if yes
	CALL	BUFFEND		;buffer at end of memory?
	RET	Z		;at end of memory
	CALL	PAUSE		;check for pause
	JR	MCLP		;do some more
;
	PAGE
;
;	$COMPARE - compare two strings
;
;	ENT	DE => first string
;		HL => second string
;		B  = length to compare
;
;	EXT	Z = strings equal
;		C = (DE) string less than (HL) string
;
COMPARE	LD	A,(DE)		;get a byte first string
	CP	(HL)		;compare to second string
	RET	NZ		;not equal, return NZ
	INC	HL		;bump pointers
	INC	DE
	DJNZ	COMPARE		;go for specified length
	RET			;match! return Z
;
	PAGE
;
;	$IFSAME - ask user if disk mount prompts
;		  are to be issued
;
;	ENT	none
;
;	EXT	(MFLAG) will be
;		-1 if no prompts to be issued
;		0  if prompts are to be issued
;
IFSAME	LD	A,-1		;reset flag to NO
	LD	(MFLAG),A	;save default
	RST	@08		;display linefeed
;
	DEFB	LF
	DEFB	ETX
;
ASKSAME	RST	@08		;if source/dest same
;
	DEFB	EOL		;clear current line
	DEFM	'Disk mount prompts ? '
	DEFB	ETX
;
	PUSH	BC		;save these
	PUSH	HL
	LD	B,3		;allow 3 chars
	RST	@10		;fetch from keyboard
	POP	HL		;unstack
	POP	BC
;
	RET	Z		;no input, default NO
	CALL	UCASE		;remove low case
	CP	'N'		;no?
	RET	Z		;already set
	CP	'Y'		;yes ?
	JR	NZ,ASKSAME	;bad input, ask again
;
	XOR	A		;set prompt flag YES
	LD	(MFLAG),A	;save in flag byte
	RET			;done
;
	PAGE
;
;	$SMOUNT - $DMOUNT - disk mount prompts
;
;	ENT	(MFLAG) setting indicates prompting
;
;	EXT	user prompted to mount associated disk
;		if mount flag is true (00)
;
SMOUNT	PUSH	HL		;save HL
	LD	HL,MNTSRC	;mount source
	JR	MOUNTC		;go common
;
DMOUNT	PUSH	HL		;save it
	LD	HL,MNTDES	;mount destination
;
MOUNTC	LD	(MOUNTJ),HL	;save jump vector
	POP	HL		;restore HL
;
	LD	A,(MFLAG)	;get mount flag
	INC	A		;-1 = no mount wait
	RET	Z		;no need to prompt
	JP	0		;else display prompt
MOUNTJ	EQU	$-2
;
;	$DRVSAME - check if source and dest drives same
;
;	ENT	(SDRIVE) (DDRIVE) already set
;
;	EXT	Z = both the same drive
;
DRVSAME	PUSH	BC		;save to use
	LD	A,(SDRIVE)	;get source drive
	LD	B,A		;save here
	LD	A,(DDRIVE)	;dest drive
	CP	B		;same?
	POP	BC		;restore it
	RET			;return Z if yes
;
;	$PAUSE - check for pause action
;
;	ENT	none
;
;	EXT	space bar alone, enter key resumes
;		shift space resumes when released
;
PAUSE	LD	A,0		;get pause flag
PAUFLG	EQU	$-1
	BIT	7,A		;hold key auto wait?
	JR	NZ,PAUSE1	;yes, go!
;
PAUSE0	LD	A,(3840H)	;read bottom key row
	BIT	7,A		;space pressed?
	JR	Z,PAUSEC	;nope, clear pause
	LD	A,(3880H)	;get space bar
	OR	A		;pressed?
	JR	NZ,PAUSE0	;yes, wait here
;
PAUSE1	LD	A,(3840H)	;read bottom key row
	AND	80H		;wait for space release
	JR	NZ,PAUSE1	;must release first
;
PAUSE2	CALL	KEY		;allow screenprint
	LD	A,(3840H)	;read bottom row
	BIT	7,A		;space pressed?
	JR	NZ,PAUSES	;yes, set single step
	BIT	0,A		;enter pressed?
	JR	Z,PAUSE2	;nope, go!
;
PAUSEC	XOR	A		;clear pause
PAUSES	AND	80H		;set pause
	LD	(PAUFLG),A	;save flag
	RET			;back to caller
;
;	$BUFFEND - check for BC at topmem
;
;	ENT	BC = buffer
;		(TOPMEM) = top of memory
;
;	EXT	Z = yes, no more room
;
BUFFEND	LD	A,(TOPMEM+1)	;get MSB topmem
	CP	B		;test for buffer end
	SCF			;must clear carry
	CCF
	RET			;back with Z flag status
;
;	$GETBYTE - prompt user for starting byte
;
;	ent	none
;
;	EXT	HL = starting relative byte (0 default)
;
GETBYTE	RST	@08		;send linefeed
;
	DEFB	LF
	DEFB	ETX
;
GETBYT1	RST	@08		;prompt for input
;
	DEFB	EOL		;clear input line
	DEFM	'Relative Byte ? '
	DEFB	ETX
;
	LD	B,15		;input length
	RST	@10		;get from keyboard
	LD	BC,0		;default value
	JR	Z,GETBYT2	;nil input, use default
	CALL	VALUE		;fetch the value
	JR	C,GETBYT1	;error, ask again
;
GETBYT2	LD	H,B		;pass to HL
	LD	L,C		;HL = byte offset
	RET			;done
;
;	$GETBCNT - prompt user for byte count
;
;	ENT	none
;
;	EXT	BC = byte count (256 default)
;
GETBCNT	RST	@08		;send linefeed
;
	DEFB	LF
	DEFB	ETX
;
	PUSH	HL		;save byte position
;
GETBC1	RST	@08		;display prompt
;
	DEFB	EOL		;clear this line
	DEFM	'Byte Count ? '
	DEFB	ETX
;
	LD	B,20		;20 char input
	RST	@10		;get the input
	LD	BC,256		;default to 1 page
	JR	Z,GETBC2	;go if default
	CALL	VALUE		;fetch the value
	JR	C,GETBC1	;invalid, try again
;
GETBC2	POP	HL		;unstack
	RET			;BC = byte count
;
;	$IFCLEAR - check for clear key pressed
;
;	ENT	none
;
;	EXT	Carry if clear is currently pressed
;
IFCLEAR	LD	A,(3840H)	;check for clear key
	AND	2		;bit 1
	SCF			;carry = yes
	RET	NZ		;NZ = pressed
	OR	A		;clear carry
	RET			;return not pressed
;
;	$SSETUP - $DSETUP - setup for disk activity
;
;	ENT	none
;
;	EXT	IY => drives DCT
;		user prompted to mount the diskette
;		if prompts are enabled
;		Z = drive ready to go
;		NZ = user pressed SKIP in reponse
;			to a disk drive not ready
;
SSETUP	LD	A,(SDRIVE)	;fetch source drive
	CALL	SETDRV		;set it up
	CALL	SMOUNT		;prompt for mounts?
	JP	DSTAT		;check for ready
;
DSETUP	LD	A,(DDRIVE)	;fetch dest drive
	CALL	SETDRV		;set it up for activity
	CALL	DMOUNT		;check for mount prompt
	JP	DSTAT		;check if drive ready
;
	PAGE
;
;	$BINASC - convert binary to decimal ascii
;
;	ENT	HL = binary number to convert
;		IY => 5 char string to hold number
;
;	EXT	(IY) loaded with decimal ascii string
;
BINASC	PUSH	IX		;save
	PUSH	HL		;save numeric
	PUSH	DE		;save from use
	LD	IX,DECTBL	;convert place table
;
BINASC1	LD	E,(IX+0)	;get LSB comparator
	LD	D,(IX+1)	;DE = decimal place
	LD	A,'0'		;start digit
;
BINASC2	OR	A		;clear carry flag
	SBC	HL,DE		;remove decimal place
	JR	C,BINASC3	;go if place found
	INC	A		;bump ascii
	JR	BINASC2		;try another
;
BINASC3	LD	(IY),A		;load ascii to string
	INC	IY		;bump string pointer
	INC	IX		;bump table
	INC	IX		;2 byte entries
	ADD	HL,DE		;add last subtract
	DEC	E		;at ones place now?
	JR	NZ,BINASC1	;nope, continue
;
	POP	DE		;unstack
	POP	HL
	POP	IX		;done
	RET
;
DECTBL	DEFW	10000		;define decimal places
	DEFW	1000
	DEFW	100
	DEFW	10
	DEFW	1
;
	PAGE
;
;	$PUTHEX - convert binary to hex ascii
;
;	ENT	HL => string to load 4 hex digits
;		BC =  numeric value to load
;
;	EXT	HL unchanged
;		BC destroyed
;
PUTHEX	INC	HL		;bump to lsb digit
	INC	HL		;at nsb
	INC	HL		;HL => end digit
;
	PUSH	BC		;save numeric value
	LD	A,C		;get LSB
	RST	@20		;to hex ascii
	LD	(HL),B		;LSB to string
	DEC	HL		;back one
	LD	(HL),C		;NSB to string
	DEC	HL		;bump pointer
	POP	AF		;get numeric value
;
	RST	@20		;to hex ascii
	LD	(HL),B		;NSB to string
	DEC	HL		;bump string
	LD	(HL),C		;MSB to string
;
	RET			;done!
;
