; susub1/asm - kjw/bqsd - 08/78 - version 3.0 - 11/82
;
	SUBTTL	'<SUSUB1/ASM - Subroutine Section 1>'
;
	PAGE
;
;	$MENU00 - force main menu for all returns
;
MENU00	XOR	A		;set sub-menu vector
	CALL	SETUPS		;set it up
	JP	RETURN		;reset all params go menu
;
	PAGE
;
;	$GETSEL	- prompt for user input, go jump table
;
;	ENT	DE => lookup table of valid responsed
;
;	EXT	exit vectored to correct table response
;
GETSEL	RST	@08		;display following
;
	DEFB	LF		;2 linefeeds
	DEFB	LF
	DEFB	ETX
;
BADSEL	RST	@08		;display
;
	DEFB	EOL		;clear current line
	DEFM	'Selection ? '
	DEFB	ETX
;
	LD	B,2		;two keys to input
	RST	@10		;get from keyboard
	LD	C,1		;set as nil
	JR	Z,CKTBLX	;go if no input
	CALL	UCASE		;make first char ucase
	CP	'L'		;requesting 'last'?
	LD	C,'$'		;fetch 'last'
CKTBLS	EQU	$-1
	JR	Z,CKTBLX	;yes, fetch it
;
;	fetch input value, from 1 - (DE)
;
	CALL	VALUE		;fetch input value
	JR	C,BADSEL	;invalid numeric entry
CKTBLX	LD	A,(DE)		;get max input value
	CP	C		;test to LSB
	JR	C,BADSEL	;out of range!
;
	EX	DE,HL		;DE=HL, HL=>table
	INC	HL		;bump past length byte
	LD	A,C		;get LSB value
	LD	(CKTBLS),A	;save for 'last'
	DEC	A		;adjust for 0 to (DE)-1
	ADD	A,A		;two byte table
	ADD	A,L		;add to LSB table
	LD	L,A		;update
	JR	NC,CKTBLY	;go if not carry
	INC	H		;bump page cross
CKTBLY	LD	A,(HL)		;fetch LSB vector
	INC	HL		;bump table
	LD	H,(HL)		;fetch MSB vector
	LD	L,A		;HL = vector
	JP	(HL)		;go vector
;
	PAGE
;
;	$GOTABL	- lookup vector in table
;
;	ENT	DE => lookup table (3 byte entries)
;		A  = character to locate
;
;	EXT	will return if no matches found
;		will pop caller address and vector to
;		table match if one is found
;
;	NOTE	subroutine only returns if not in table
;	NOTE	character in A is converted to upper case
;		to scan the table, but the character is
;		passed unchanged to the vector if matched
;
GOTABL	PUSH	DE		;save table start
	PUSH	HL		;need this
	EX	DE,HL		;HL => table
;
	LD	E,A		;save original here
	CALL	UCASE		;convert to upper case
;
TABLP	PUSH	AF		;save character
	LD	A,(HL)		;get table byte
	CP	ETBL		;end of table byte?
	JR	Z,NOTINT	;not in table!
	POP	AF		;get char back
;
	CP	(HL)		;same as request?
	INC	HL		;point to vector
	JR	Z,HAVTAB	;yes, have table
	INC	HL		;bump past vector
	INC	HL
	JR	TABLP		;try next entry
;
NOTINT	POP	AF		;restore char
	POP	HL		;unstack
	LD	A,E		;fetch original char
	POP	DE		;restore table start
	RET			;not in table
;
;	table entry found!, fetch it
;
HAVTAB	LD	A,(HL)		;fetch LSB vector
	INC	HL		;bump pointer
	LD	H,(HL)		;fetch MSB pointer
	LD	L,A		;HL = vector
;
	LD	A,E		;get unadultered char
	EX	AF,AF'		;save it here
	POP	AF		;dummy pop old HL
	POP	DE		;unstack DE
;
	EX	(SP),HL		;overwrite with vector
	PUSH	AF		;put HL back on stack
	POP	HL		;get in the right place
	EX	AF,AF'		;get original A back
	RET			;all restored, go vector!
;
	PAGE
;
;	$SETUPS	- set stack and sub-menu return vector
;
;	ENT	A = sub-menu return code
;
;	EXT	SMRC saved, stack set to top
;
SETUPS	POP	HL		;get caller address
	LD	SP,STACK	;reset stack to top
	LD	(WHERE),A	;save sub-menu flag
	EI			;enable interrupts
	JP	(HL)		;return!
;
;	$INKEY	- fetch a single key
;
;	ENT	none
;
;	EXT	Z = no key available
;		NZ = A = character
;
;	NOTE	a call to KEY will return immediately
;		INKEY adds appropriate debounce
;
INKEY	CALL	KEY		;strobe with no delay
;
;	add key debounce delay
;
	PUSH	BC		;save it
	LD	BC,500H		;big delay
	CALL	DELAY		;dec BC till 0
	POP	BC		;restore it
;
	OR	A		;set flags on INKEY char
	RET			;return, A = char
;
	PAGE
;
;	$GOBACK	- exit vector to last sub-menu
;		  user is prompted to key to continue
;	$RETURN	- immediate exit to submenu
;
;	ENT	none
;
;	EXT	program vectors to last sub-menu
;
GOBACK	LD	SP,STACK	;reset stack
	CALL	PRESS		;'key enter to continue'
;
RETURN	LD	SP,STACK	;reset stack
	CALL	DLON		;reactivate DUAL if ON
;
	LD	HL,SUBMENU	;sub-menu exit vector
	PUSH	HL		;leave on stack for ret's
;
;	reset all I/O code changes
;
;i*
	IF	MODI
	LD	A,88H		;restore IBM type reads
	LD	(RDTYPE),A
	LD	A,0A8H		;and writes
	LD	(WRTYPE),A
	ENDIF
;i*
;
;iii*
	IF	MODIII
	LD	A,80H		;IBM type III
	LD	(RDTYPE),A
	LD	A,0A0H		;IBM data write III
	LD	(WRTYPE),A
;
;	read track can alter $WXFER, reset it
;
	LD	A,20H		;JR NZ opcode
	LD	(RD3FIX),A	;put into code
	LD	(WR3FIX),A	;put into write code
	ENDIF
;iii*
;
;	reset NOP into code at $STAT
;
	XOR	A		;NOP opcode
	LD	(HOLDIN),A	;put into code
;
	LD	(ZAPFLAG),A	;reset error on disk I/O
;
;	disallow *nn filespec evaluation for TRSDOS III
;	only valid with 'display file sectors'
;
	LD	(MOD3FIL),A	;disallow *nn type fspec
;
	LD	A,(FLAGA)	;get system flag
	RES	1,A		;enable 'alive'
	LD	(FLAGA),A	;put it back
;
;	check to see if an active disk operation
;	was interrupted
;
;i*
	IF	MODI
	LD	A,(37ECH)	;read FDC status I
	ENDIF
;i*
;
;iii*
	IF	MODIII
	IN	A,(0F0H)	;read FDC status III
	ENDIF
;iii*
	BIT	0,A		;active FDC command?
	JR	Z,NOTAXT	;nope, continue
;
	XOR	A		;set NOP opcode
	LD	(TASKDRV),A	;for drive reset
;
NOTAXT	CALL	TASKDRV		;reset drive on error
;	CALL	TURNSPD		;reset high speed clock
	CALL	DLON		;activate DUAL if ON
;
	LD	A,(WHERE)	;fetch sub-menu #
	INC	A		;adjust for actual
;
	LD	DE,RETADD	;jump table for sub-menus
	CALL	GOTABL		;go!
	JP	MASTER		;corrupt! exit main menu
;
RETADD	DEFB	1
	DEFW	MENU		;main menu
	DEFB	2
	DEFW	ZAP		;disk zap
	DEFB	3
	DEFW	PURGE		;disk purge
	DEFB	4
	DEFW	FORMAT		;disk format
	DEFB	5
	DEFW	COPY		;disk backup
	DEFB	6
	DEFW	REPAIR		;disk repair
	DEFB	7
	DEFW	TAPE		;tape utilities
	DEFB	8
	DEFW	MEMORY		;memory utilities
	DEFB	9
	DEFW	FILES		;file utilities
	DEFB	10
	DEFW	CONFIG		;configuration
	DEFB	11
	DEFW	EXIT		;exit program
	DEFB	ETBL		;term
;
	PAGE
;
;	$PRESS	- prompt user to key enter to continue
;
;	ENT	none
;
;	EXT	A = character input
;
;	all other registers preserved
;
PRESS	RST	@08		;display prompt
;
	DEFB	LF
	DEFM	'<KEY> to continue:'
	DEFB	ETX
;
	JP	ONEKEY		;fetch single key
;
	PAGE
;
;	$NEXSEC	- advance to next sector
;
;	ENT	DE = current track/sector
;
;	EXT	C = disk boundary exceeded
;		NC = OK, DE still in bounds
;		DE = next track sector in sequence
;
NEXSEC	INC	E		;bump sector
	CALL	TRKEND		;fetch last sec on track
	CP	E		;past track end?
	JR	NC,NEXTUI	;go if not
;
	INC	D		;bump the track
	CALL	FIRSTS		;load E with low sector
;
NEXTUI	LD	A,(IY+1)	;get tracks relative
	DEC	A		;A = highest track
	CP	D		;beyond disk boundary?
	RET			;Carry = yes!
;
;	$RETSEC	- retard to next sector back
;
;	ENT	DE = current track/sector
;
;	EXT	DE = previous track/sector
;
;	NOTE	DE unchanged if already at the
;		first sector on a disk
;
RETSEC	PUSH	DE		;save sector
	CALL	FIRSTS		;get lowest
	LD	A,E		;fetch it
	POP	DE		;restore original
	CP	E		;at lowest sector?
	JR	Z,DOWNSEC	;yes, go back last track
;
	DEC	E		;else back a sector
	RET			;done, return
;
DOWNSEC	LD	A,D		;get track
	OR	A		;on track 0?
	RET	Z		;if yes, don't change it
;
	DEC	D		;else move back a track
	CALL	TRKEND		;get last sector on track
	LD	E,A		;give it to DE
	RET			;done, return
;
;	$TRKEND	- compute last sector on a track
;
;	ENT	D  = current track
;
;	EXT	A = highest sector on the track
;
TRKEND	LD	A,D		;fetch track
	OR	A		;on track 0?
	LD	A,(IY+8)	;highest sector track 0
	JR	Z,TRKEND0	;go if yes
;
	LD	A,(IY+9)	;highest sector non-0
;
TRKEND0	BIT	0,(IY+5)	;double side available?
	RET	Z		;nope, done!
	INC	A		;bump to actual # secs
	ADD	A,A		;*2
	DEC	A		;for new highest sector
	RET			;done
;
;	$FIRSTS - locate first sector on track
;
;	ENT	D = current track
;
;	EXT	E = first sector on that track
;
FIRSTS	LD	A,D		;get track number
	OR	A		;check for zero
	LD	A,(IY+6)	;get system flag
	JR	NZ,FRSTG	;not zero, go!
	RRCA			;align track zero bit
	AND	1		;A = lowest sector
	BIT	7,(IY+6)	;density track 0
	JR	FRSTH		;continue
FRSTG	AND	1		;A = lowest sector
	BIT	6,(IY+6)	;density disk
;
FRSTH	LD	E,A		;E = lowest sector
	LD	A,10		;10 sectors/track single
	RET	Z		;single density
	LD	A,18		;18 sectors/track double
	RET			;E=lowest, A=# / track
;
	PAGE
;
;	$ADDR20	- read 20 ID sectors into buffer
;
;	ENT	none
;
;	EXT	NZ = disk error, A = I/O status byte
;		Z = OK
;		HL => buffer containing 20 sector #'s
;
;	NOTE	this is used to locate the highest and
;		lowest sector #'s on a track
;
ADDR20	LD	B,20		;20 iterations
	LD	IX,DAMBUFF	;load into this buffer
;
ADDR20A	CALL	ADDR		;read ID field
	RET	NZ		;error, return NZ
;
	INC	HL		;head
	INC	HL		;sector
	LD	A,(HL)		;fetch sector number
	LD	(IX),A		;put into buffer
	INC	IX		;bump buffer pointer
	DJNZ	ADDR20A		;go for B # times
	XOR	A		;return ZERO
	RET			;back to caller
;
	PAGE
;
;	$GETDAT	- prompt for 'drive, track, sector'
;
;	ENT	none
;
;	EXT	(DRIVE)&(DRIV) set for drive
;		IY => drives DCT
;		DE = track sector
;
;	NOTE	defaults of the lowest possible values
;		are used if not given
;	NOTE	if first character of the input line
;		is an !, then bit one at (FLAGB) will
;		be set to tell 'display disk sectors'
;		that it is to attempt to read a non-
;		standard diskette.  Otherwise a normal
;		sector will be assumed.
;		This is a new feature and is only
;		recognized by $DISDSK
;
GETDAT	RST	@08		;display following
;
	DEFB	LF		;single linefeed
	DEFB	ETX		;terminator
;
BADDAT	RST	@08		;display prompt
;
	DEFB	EOL		;clear the line
	DEFM	'Drive, Track, Sector ? '
	DEFB	ETX
;
;	setup default values
;
	XOR	A		;default to drive 0
	LD	D,A		;default track
	LD	(DATMSK),A	;save current mask
	CALL	SETDRV		;set up drive 0
	CALL	FIRSTS		;get first sector
	RES	4,(IY+5)	;turn off auto detect
	RES	3,(IY+5)	;set normal I/O
;
;	get keyboard input
;
	LD	B,35		;max chars to input
	RST	@10		;get from keyboard
;
	CALL	POSHL		;any more input
	RET	Z		;an accident?
;
;	interpret drive and dos specifiers
;
	CP	'#'		;special char?
	JR	Z,GTDU		;yes, go!
;
	CP	'!'		;disk detect on?
	JR	NZ,GTDV		;nope, continue
	LD	A,(DATMSK)	;get system flag
	SET	4,A		;detect on
	LD	(DATMSK),A	;put it back
	JR	GTDUV		;continue
;
GTDU	LD	A,(DATMSK)	;get mask byte
	SET	3,A		;set 'non-standard' read
	LD	(DATMSK),A	;put it back
;
;	if mod iii, allow non-IBM length sectors
;	to be read/written
;
;iii*
	IF	MODIII
	LD	A,18H		;JR opcode
	LD	(RD3FIX),A	;put into $RXFER code
	LD	(WR3FIX),A	;put into $WXFER code
	ENDIF
;iii*
;
GTDUV	INC	HL		;bump pointer past ! or #
;
GTDV	CALL	FIGDRV		;compute the drive type
	JR	C,BADDAT	;error, invalid data
	CALL	FIRSTS		;compute first sector now
	LD	A,(IY+5)	;get current flags
	AND	0E7H		;reset bits 4,3
	OR	'$'		;merge mask
DATMSK	EQU	$-1
	LD	(IY+5),A	;update flags
;
	CALL	POSHL		;any more?
	RET	Z		;nope, return
;
;	interpret track number
;
	INC	HL		;bump pointer
	CALL	UCASE		;make it upper case
;
	CP	DARR		;down arrow?
	JR	Z,LKSEC		;already there, get sect
;
	CP	'L'		;last?
	JR	Z,DEFLTS	;yes, fetch it
;
	CP	'D'		;directory track?
	JR	Z,DEFDIR	;yes, get it
;
	CP	UARR		;up arrow?
	JR	Z,DEFUPT	;yes, get highest track
;
;	no defaults, get the value
;
	DEC	HL		;put it back
	CALL	VALUE		;get value
	JP	C,BADDAT	;error, return
	LD	D,C		;give track to D
;
;	interpret the sector
;
LKSEC	CALL	FIRSTS		;compute first sector now
	CALL	POSHL		;any more input?
	RET	Z		;nope, return
;
	CALL	VALUE		;get the value
	JP	C,BADDAT	;error, try again
	LD	E,C		;give sector to E
	RET			;done, all set
;
DEFDIR	LD	D,(IY+2)	;get directory track
	JR	LKSEC		;look at sector
;
DEFLTS	LD	DE,(SECTOR)	;last one
	RET			;done, DE = it
;
DEFUPT	LD	D,(IY+1)	;track count relative
	DEC	D		;dec to highest track
	JR	LKSEC		;look at sector #
;
	PAGE
;
;	$ONEDRIV - prompt and setup for one drive
;
;	ENT	none
;
;	EXT	drive setup for activity
;		IY => DCT
;
ONEDRIV	RST	@08		;send linefeed
;
	DEFB	LF
	DEFB	ETX
;
ONEDRI	RST	@08		;display prompt
;
	DEFB	EOL		;clear the line
	DEFM	'Drive ? '
	DEFB	ETX
;
	XOR	A		;default to zero
	CALL	SETDRV		;set it up
	RES	4,(IY+5)	;auto detect off
	RES	3,(IY+5)	;standard I/O
	LD	B,20		;20 chars input
	RST	@10		;fetch keyboard input
	CALL	POSHL		;any input?
	RET	Z		;nil, use default
;
	CALL	FIGDRV		;figure out the drive
	JR	C,ONEDRI	;invalid, try again
	RES	4,(IY+5)	;reset this drive
	RES	3,(IY+5)
	RET			;else have it all set
;
	PAGE
;
;	$ASCII	- convert binary byte to decimal ascii
;
;	ENT	A = binary byte to convert
;
;	EXT	ACB = decimal ascii equivalent
;
ASCII	LD	B,'0'		;start ascii
;
ASC1	SUB	100		;remove a hundred
	JR	C,ASC2		;have it, go!
	INC	B		;bump ascii
	JR	ASC1		;try again
;
ASC2	PUSH	BC		;save MSB on stack
	ADD	A,100		;put it back
	LD	C,'0'		;starting 10's place
;
ASC3	SUB	10		;remove ten
	JR	C,ASC4		;done, go!
	INC	C		;bump ascii
	JR	ASC3		;try again
;
ASC4	ADD	A,'0'+10	;last sub + ascii
	LD	B,A		;give LSB to B
	POP	AF		;get msb
	CP	'0'		;msb = '0'?
	RET	NZ		;nope, return
	LD	A,BLANK		;strip leading zero
	RET			;done
;
	PAGE
;
;	$POSHL	- position HL to first significant char
;
;	ENT	HL => input string
;
;	EXT	Z = terminator found
;		NZ = HL => first significant char
;
	INC	HL		;bump pointer
POSHL	LD	A,(HL)		;fetch a character
;
	CALL	CKSEP		;check for separator
	RET	C		;carry = yes, Z set
	JR	Z,POSHL-1	;yes, skip it
;
	RET			;NC,NZ - valid char
;
	PAGE
;
;	$MOVE	- move block of memory
;
;	ENT	HL => current block address
;		DE => destination block address
;		BC =  length of block
;
;	EXT	block moved (blocks may overlay)
;
MOVE	PUSH	HL		;save from compare
	OR	A		;clear carry flag
	SBC	HL,DE		;compare source & dest
	POP	HL		;restore original
	JR	C,MOVBAK	;move backwards
;
	LDIR			;move it forwards
	RET			;block moved!
;
MOVBAK	ADD	HL,BC		;source + length
	DEC	HL		;point to last byte
;
	EX	DE,HL		;exchange
	ADD	HL,BC		;add length to dest
	DEC	HL		;point to last byte
	EX	DE,HL		;put 'em back
;
	LDDR			;move data
	RET			;data moved!
;
	PAGE
;
;	$VALUE	- extract value from input string
;
;	ENT	HL => input string to parse
;
;	EXT	C = invalid or nil input
;		NC = OK, BC = value
;
VALUE	CALL	POSHL		;position to first char
	SCF			;carry for nil
	RET	Z		;nil, return
;
	PUSH	HL		;save pointer
	CALL	POSEND		;get last character
;
;	interpret base of number specified
;
	LD	HL,ADDHEX	;hex adder
	LD	B,16		;max digit
	CP	'H'		;hex?
	JR	Z,GOVAL		;have it, go!
;
	LD	HL,ADDOCT	;octal adder
	LD	B,8		;max digit
	CP	'O'		;octal?
	JR	Z,GOVAL		;have it!
	CP	'Q'		;octal?
	JR	Z,GOVAL		;have it!
;
	LD	HL,ADDBIN	;binary adder
	LD	B,2		;max digit
	CP	'B'		;binary?
	JR	Z,GOVAL		;have it, go!
;
	LD	HL,ADDDEC	;decimal adder
	LD	B,10		;max digit
	CP	'D'		;decimal?
	JR	Z,GOVAL		;yes, go!
;
	XOR	A		;no base specified
;
GOVAL	LD	(ADDVEC),HL	;save adder vector
	LD	(VALTRM),A	;special terminator
	LD	A,B		;get max digit
	LD	(VALMAX),A	;save into code
;
	POP	HL		;restore pointer
	LD	BC,0		;starting value
;
VALLP	LD	A,(HL)		;get a character
	CALL	UCASE		;make it upper
;
	CALL	CKSEP		;separator/terminator?
	SCF			;clear carry flag
	CCF
	RET	Z		;yes, return
;
	INC	HL		;bump string pointer
	CP	0		;special terminator?
VALTRM	EQU	$-1		;base of number
	RET	Z		;yes, return
;
;	check for valid digit
;
	SUB	'0'		;remove the ascii
	RET	C		;error, return
	CP	10		;0-9?
	JR	C,DIGOK		;ok so far, go!
	SUB	7		;adjust for A-F
	RET	C		;error, return
DIGOK	CP	0		;test for max
VALMAX	EQU	$-1
	CCF			;reverse the carry
	RET	C		;out of range!
;
;	multiply subtotal by base
;
	PUSH	HL		;save pointer
;
	LD	H,B		;get sub-total
	LD	L,C
	CALL	0		;multiply it!
ADDVEC	EQU	$-2
;
;	add new digit
;
	LD	C,A		;give it to C
	LD	B,0		;BC = new number
	ADD	HL,BC		;add it in
;
	LD	B,H		;give subtotal back
	LD	C,L
	POP	HL		;restore pointer
	JR	VALLP		;go more!
;
POSEND	LD	A,(HL)		;get a char
;
	CALL	CKSEP		;separator/terminator?
	JR	Z,POSND		;done if yes
;
	INC	HL		;bump pointer
	JR	POSEND		;try next character
;
POSND	DEC	HL		;put it back
	LD	A,(HL)		;get last character
	JP	UCASE		;convert and return
;
;	decimal/binary adders
;
ADDDEC	ADD	HL,HL		;*2
	ADD	HL,HL		;*4
	ADD	HL,BC		;*5
ADDBIN	ADD	HL,HL		;*10 (*2)
	RET			;done
;
;	hex/octal adders
;
ADDHEX	ADD	HL,HL		;*2
ADDOCT	ADD	HL,HL		;*4 (*2)
	ADD	HL,HL		;*8 (*4)
	ADD	HL,HL		;*16 (*8)
	RET			;done
;
