; supurge/asm - kjw/bqsd - 08/78 - version 3.0 - 11/82
;
	PAGE
;
	SUBTTL	'<SUPURGE/ASM - Disk Purge Section E>'
;
;	$RPDIR - read protect directory
;
RPDIR	RST	@08		;display linefeed
;
	DEFB	LF
	DEFB	ETX
;
	CALL	GETDRVS		;get multiple drives
	LD	DE,RDPRI1	;subroutine vector
;
RPDIRD	LD	BC,GOBACK	;to menu when done
	JP	DRVCOMM		;do all requested drives
;
;	$URPDIR - un read-protect directory
;
URPDIR	RST	@08		;linefeed
;
	DEFB	LF
	DEFB	ETX
;
	CALL	GETDRVS		;get multiple drives
	LD	DE,RDPRI2	;subroutine vector
	JR	RPDIRD		;do all requested drives
;
;	subroutine vectors for read/un-read protect dir
;
RDPRI2	CALL	COMPDAT		;get plain data type
	JR	RPDIRC		;go common
;
RDPRI1	CALL	COMPDIR		;get directory type
;
RPDIRC	LD	(DDIRRS),A	;save write type command
	CALL	RDDIR		;read in the directory
	JR	NZ,DIRNOTA	;can't read, ask where
DDIRRD	LD	A,0		;fetch write type
DDIRRS	EQU	$-1
	JP	WRDIRT		;write directory new mark
;
DIRNOTA	RST	@08		;display message
;
	DEFB	LF
	DEFM	'Cannot locate Directory'
	DEFB	LF
	DEFB	ETX
;
DIRNOTB	RST	@08		;ask where it is
;
	DEFB	EOL		;clear line
	DEFM	'Track, Sector count ? '
	DEFB	ETX
;
	LD	B,20		;20 char input
	RST	@10		;get from keyboard
	JR	Z,DFFDIR	;nil, get default
;
	CALL	VALUE		;fetch user input
	JR	C,DIRNOTB	;invalid numeric
	LD	(IY+2),C	;save directory track
DFFDIR	CALL	GETDIR		;load DE with directory
;
	CALL	POSHL		;any more input?
	JR	C,DFFDIR2	;use track length
	CALL	VALUE		;fetch sector count
	JR	C,DIRNOTB	;invalid numeric
	LD	A,C		;get LSB value
;
DFFDIR3	LD	(DIRSCNT),A	;directory sector count
;
	LD	L,A		;pass to HL for counter
	LD	H,0		;HL = sector count
	LD	BC,GATBUFF	;start of directory
	CALL	MREAD		;read it in
	RET	NZ		;error, return
	JP	DDIRRD		;write it right back!
;
DFFDIR2	LD	A,10		;10 sectors single den
	BIT	6,(IY+6)	;single den?
	JR	Z,DFFDIR3	;yes, go!
	LD	A,18		;else 18 double den
	JR	DFFDIR3		;save it
;
	PAGE
;
;	$REPGAT - repair diskette GAT table
;	$REPHIT - repair diskette HIT table
;	$REPBOOT - repair diskette BOOT sector
;
REPGAT	LD	HL,GATREP	;subroutine vector
	JR	REPCOMM		;go common repair
;
REPHIT	LD	HL,HITREP	;subroutine vector
	JR	REPCOMM		;go common
;
REPBOOT	LD	HL,BOOTREP	;subroutine
;
REPCOMM	PUSH	HL		;save sub address
	CALL	GETDRVS		;get user multiple drives
	POP	DE		;DE = common routine
	LD	BC,GOBACK	;to menu when done
	JP	DRVCOMM		;do all drives requested
;
;	repair GAT table
;
GATREP	CALL	RDDIR		;read in directory
	JP	NZ,NOTDIR	;can't find, next drive
	RST	@08		;display linefeed
;
	DEFB	LF
	DEFB	ETX
;
ASKGRP	RST	@08		;display prompt
;
	DEFB	EOL		;clear line
	DEFM	'A>llocation table or E>ntire sector ? '
	DEFB	ETX
;
	LD	B,2		;two key input
	RST	@10		;fetch from keyboard
	JR	Z,DOALLT	;nil, do alloc table only
	CALL	UCASE		;make input upper case
;
	CP	'A'		;allocation table?
	JR	Z,DOALLT	;yes, go!
;
	CP	'E'		;entire sector?
	JR	NZ,ASKGRP	;nope, try again
;
	CALL	INITGAT		;initialize GAT table
;
DOALLT	CALL	MAKEGAT+3	;don't change track count
	JP	WRDIR		;write it back!
;
;	repair HIT table
;
HITREP	CALL	RDDIR		;read in directory
	JP	NZ,NOTDIR	;report error, next drive
;
	CALL	FIGTKS		;get track count from dsk
	CALL	MAKEHIT		;create the HIT table
	JP	WRDIR		;write back directory!
;
;	repair boot sector
;
BOOTREP	LD	BC,BOOT1SL	;TRS I SD boot length
	LD	HL,BOOT1S+2	;where dir byte goes
	LD	DE,BOOT1S	;TRS I SD boot
	BIT	6,(IY+6)	;single density?
	JR	Z,RXPBOOT	;single, go!
;
	LD	BC,BOOT1DL	;TRS I DD boot length
	LD	DE,BOOT1D	;TRS I DD boot
	LD	HL,BOOT1D+1	;where dir byte goes
	BIT	7,(IY+6)	;double track zero?
	JR	Z,RXPBOOT	;no, go!
;
	LD	BC,BOOT3L	;TRS III DD boot length
	LD	DE,BOOT3	;TRS III DD boot
	LD	HL,BOOT3+1	;where dir track goes
;
RXPBOOT	LD	A,(IY+2)	;get directory track
	LD	(HL),A		;to the buffer
	EX	DE,HL		;HL => boot sector
	PUSH	BC		;save BC length
	LD	BC,BUFFER	;I/O buffer to use
	CALL	ZBUFF		;load with zeroes
	LD	D,B		;pass to De
	LD	E,C		;DE => buffer
	POP	BC		;get length
	LDIR			;move it in!
	LD	A,(IY+7)	;get dos type
	OR	A		;undefined?
	JR	Z,REPTRSX	;yes, can't
	CP	4		;trsdos?
	JR	NC,REPTRSO	;yes, continue
REPTRSX	RST	@08		;display message
;
	DEFB	LF
	DEFM	'Cannot repair non-TRSDOS boot sector!'
	DEFB	ETX
;
	RET
;
REPTRSO	LD	D,0		;track 0
	CALL	FIRSTS		;E now has first sector
	CALL	COMPDAT		;get data DAM
	LD	(WRTYPE),A	;save for write
	CALL	DSTAT		;check drive status
	RET	NZ		;skip, next drive
	LD	BC,BUFFER	;I/O buffer
	RST	@30		;write the sector
	RET			;go next drive
;
	PAGE
;
;	$ZUGRNS - zero unused granules on diskette
;
ZUGRNS	CALL	GETDRVS		;get multiple drives
	LD	DE,ZUNGO	;subroutine vector
	LD	BC,GOBACK	;to menu when done
	JP	DRVCOMM		;do requested drives
;
ZUNGO	CALL	RDDIR		;read in directory
	JP	NZ,NOTDIR	;can't read, next drive
;
	CALL	DIRPART		;name/date/grans/files
	LD	D,0		;start track 0
	LD	IX,GATBUFF	;start allocation table
;
;	check if track 0 available for I/O
;
	BIT	5,(IY+6)	;available?
	JR	Z,ZUNGOLP	;yes, go!
	INC	D		;else start track 1
	INC	IX		;bump gat pointer
;
ZUNGOLP	CALL	FIRSTS		;load E with first sector
	LD	B,(IY+11)	;grans / track
;
ZUNGILP	RRC	(IX)		;granule allocated?
	CALL	NC,ZEGRAN	;zero it if not
	CALL	NXTGRAN		;move E to next gran
	DJNZ	ZUNGILP		;finish this track
;
	INC	D		;bump track
	LD	A,D		;get track
	INC	IX		;bump GAT pointer
	CP	(IY+1)		;test for disk end
	JR	NZ,ZUNGOLP	;not done, go more!
	RET			;else next drive
;
ZEGRAN	PUSH	DE		;save DE
	PUSH	BC		;save counter
	LD	B,(IY+10)	;sectors/gran
;
ZEGRAN1	PUSH	BC		;save count
	LD	BC,BUFFER	;I/O buffer
	CALL	ZBUFF		;zero it out
	RST	@30		;write to disk
	POP	BC		;restore gran counter
	INC	E		;bump sector
	DJNZ	ZEGRAN1		;finish off this gran
;
	POP	BC		;restore count
	POP	DE		;restore current sector
	RET			;done, return
;
;	$GRNSIZE - compute # sectors / granule
;
GRNSIZE	LD	B,(IY+10)	;sectors/gran
	RET			;done
;
;	$NXTGRAN - advance DE to next granule
;
NXTGRAN	LD	A,(IY+10)	;sectors/gran
	ADD	A,E		;add it
	LD	E,A		;E = next sector
	RET			;done, DE = next gran
;
	PAGE
;
;	$CHKDIR - check directory
;
CHKDIR	CALL	GETDRVS		;get multiple drives
	LD	DE,CKDIR0	;subroutine vector
	LD	BC,GOBACK	;to menu when done
	XOR	A		;load zero
	LD	(LINEC),A	;clear line counter
	JP	DRVCOMM		;do requested drives
;
CKDIR0	CALL	RDDIR		;read the directory
	JP	NZ,NOTDIR	;can't, next drive
;
	CALL	DIRPART		;name/date/etc
	CALL	INTCNT		;clear counter
;
;	move GAT table to unused area to save it
;
	LD	HL,GATBUFF	;gat table
	LD	DE,DAMBUFF	;put in dam buffer
	LD	BC,100H		;length
	LDIR			;move it in
;
	CALL	MAKEGAT		;create a GAT table
;
	LD	HL,GATBUFF	;created table
	LD	DE,DAMBUFF	;table from disk
	LD	B,(IY+1)	;relative tracks
	CALL	COMPARE		;same?
	JR	Z,GTOKO		;yes, continue
	RST	@08		;else display message
;
	DEFB	LF
	DEFM	'GAT Table is BAD'
	DEFB	ETX
;
	CALL	PAUSE		;check for pause
	CALL	ADDCNT		;bump counter
;
;	move HIT table to unused area
;
GTOKO	LD	HL,HITBUFF	;start of HIT from disk
	LD	DE,DAMBUFF	;save it here
	LD	BC,100H		;length
	LDIR			;move it in
;
	CALL	MAKEHIT		;create a HIT table
;
;	the first releases of TRSDOS Mod I SD
;	and NEWDOS 2.1 placed an invalid byte into the
;	HIT table for DIR/SYS so that the user could
;	not open it up as a file and read/write to it
;	Since all normal diskettes have a DIR/SYS
;	entry in the directory, we will ignore any
;	errors due to that one byte being invalid
;
	LD	A,(DAMBUFF+1)	;get byte from disk
	LD	(HITBUFF+1),A	;place into created table
;
	LD	HL,HITBUFF	;created hit table
	LD	DE,DAMBUFF	;hit table from disk
;
	LD	B,0		;normal length of HIT
	LD	A,(IY+7)	;get dos type
	CP	02		;trs 1 DD?
	JR	C,NOTTH		;not trsdos HIT
	CP	04		;trs 3 DD?
	JR	NC,NOTTH	;nope, continue
	LD	B,0D0H		;length of HIT Mod I DD
	JR	NZ,NOTTH	;nope, have length
	LD	B,0E0H		;length trsdos III
;
NOTTH	CALL	COMPARE		;are they the same?
	JR	Z,GHTOKO	;yes, continue
	RST	@08		;display error
;
	DEFB	LF
	DEFM	'HIT Table is BAD'
	DEFB	ETX
;
	CALL	PAUSE		;check for pause
	CALL	ADDCNT		;bump error counter
;
GHTOKO	CALL	ENTRIES		;# entries in directory
	LD	IX,FILBUFF	;start of file records
	RST	@08		;linefeed
;
	DEFB	LF
	DEFB	ETX
;
GHTOKI	BIT	4,(IX)		;active file?
	CALL	NZ,CHKOUT	;alive, check it out
	CALL	IXDIR		;move to next entry
	DEC	E		;less this file
	JR	NZ,GHTOKI	;more to go, continue
;
	CALL	SHOCNT		;display error counter
	RST	@08		;message
;
	DEFM	'Total Errors'
	DEFB	LF
	DEFB	ETX
;
	JP	PAUSE		;go next drive
CHKOUT	BIT	7,(IX)		;extension?
	RET	NZ		;yes, skip for now
	CALL	SAVEREG		;save registers
	LD	(TEMP0),IX	;save primary pointer
;
CKEXT	CALL	GETEXTS		;get # extents in file
;
CURKE	LD	A,(IX+16H)	;get extent element
	INC	A		;terminator?
	RET	Z		;yes, done with file
	INC	A		;extension marker?
	JR	Z,CHKITX	;yes, fetch it
	INC	IX		;next extent
	INC	IX		;two bytes each
	DJNZ	CURKE		;finish record off
;
;	no terminator or extendor found in the field!
;
	LD	HL,(CURSOR)	;fetch cursor
	LD	IX,(TEMP0)	;get primary pointer
	CALL	SHOWIT		;display filespec
	RST	@08		;display message
;
	DEFM	' No Extent Terminator'
	DEFB	LF
	DEFB	ETX
	CALL	PAUSE		;check for pause key
	JP	ADDCNT		;count and return
;
CHKITX	LD	A,(IX+17H)	;get DEC of extension
;
	PUSH	AF		;save unadultered
	AND	1FH		;sector offset
	LD	H,A		;to H
	POP	AF		;restore DEC
;
	AND	0E0H		;byte offset
	LD	L,A		;HL => extension offset
	LD	IY,FILBUFF	;start of file records
	ADD	IY,DE		;IY => next file
;
	BIT	4,(IY)		;active file?
	JR	Z,BADFOR	;no, bad forward link
	BIT	7,(IY)		;true extension entry?
	JR	Z,BADFOR	;nope, error
;
;	check for correct backward link
;
	PUSH	IX		;last entry
	POP	HL		;pass to HL for math
	LD	DE,FILBUFF	;start of filenames
	OR	A		;clear carry flag
	SBC	HL,DE		;HL = last DEC
	LD	A,H		;sector offset
	OR	L		;merge with byte offset
	CP	(IY+1)		;link is correct?
	PUSH	IY		;pass back to IX
	POP	IX		;for next pass
	JP	Z,CKEXT		;yes, check out next
;
;	backward link is invalid
;
	LD	HL,(CURSOR)	;fetch cursor
	LD	IX,(TEMP0)	;get primary pointer
	CALL	SHOWIT		;display filespec
	RST	@08		;message
;
	DEFM	' Bad Backward Link'
	DEFB	LF
	DEFB	ETX
;
	CALL	PAUSE		;check for pause
	JP	ADDCNT		;bump error counter
;
BADFOR	LD	HL,(CURSOR)	;fetch cursor
	LD	IX,(TEMP0)	;get primary pointer
	CALL	SHOWIT		;display filespec
	RST	@08		;message
;
	DEFM	' Bad Forward Link'
	DEFB	LF
	DEFB	ETX
;
	CALL	PAUSE		;check for pause
	JP	ADDCNT		;bump error counter
;
	PAGE
;
;	$MOVEDIR - move diskette directory
;
MOVEDIR	CALL	GETDRVS		;get multiple drives
	LD	DE,MOVDIR0	;subroutine vector
	LD	BC,GOBACK	;to menu when done
	JP	DRVCOMM		;do requested drives
;
MOVDIR0	CALL	RDDIR		;read the directory
	JP	NZ,NOTDIR	;can't, go next drive
;
	CALL	DIRPART		;display name/date/etc
	RST	@08		;send linefeed
;
	DEFB	LF
	DEFB	ETX
;
MOVDIR1	RST	@08		;display prompt
;
	DEFB	EOL		;clear input line
	DEFM	'Move to track ? '
	DEFB	ETX
;
	LD	B,20		;20 char input
	RST	@10		;fetch from keyboard
	CALL	POSHL		;position to input
	JP	Z,SHOFTKS	;display free tracks
;
	CALL	VALUE		;fetch numerical value
	JR	C,MOVDIR1	;error, ask again
;
;	check if within disk boundary
;
	LD	A,C		;get requested track
	CP	(IY+1)		;in disk range?
	JR	NC,MOVDIR1	;error, ask again
;
	LD	HL,GATBUFF	;start of directory
	LD	L,C		;point to desired track
;
;	see if directory already on that track
;
	LD	A,(IY+2)	;current directory
	CP	C		;already on that track?
	JP	Z,MOVDIR3	;display message
;
;	see if requested track is completely empty
;
	CALL	MNYGRNS		;get empty gran mask
	LD	A,(HL)		;fetch allocation byte
	CP	E		;completely empty?
	JR	NZ,MOVDIR2	;nope, can't use it
;
	LD	L,(IY+2)	;current directory
	LD	(HL),E		;de-allocate the track
	CALL	GETDIR		;load DE with directory
	LD	(OLDDIR),DE	;save it
	LD	L,C		;new directory
	LD	(HL),-1		;allocate new track
	LD	(IY+2),C	;save into DCT
	LD	A,C		;get track
	LD	(FILBUFF+116H),A ;save into DIR/SYS entry
	CALL	WRDIR		;write new directory
	RET	NZ		;error, abort!
;
	CALL	COMPDAT		;fetch DATA dam's
	LD	HL,DAMBUFF	;dam buffer
	LD	DE,DAMBUFF+1
	LD	BC,0FFH		;length -1
	LD	(HL),A		;insert DAM type
	LDIR			;save it into table
;
;	write back old directory with DATA dam's
;
	LD	BC,GATBUFF	;start of directory
	LD	HL,(DIRSCNT)	;directory sector count
	LD	H,0		;LSB = # sectors
	LD	DE,0		;get old directory loc
OLDDIR	EQU	$-2
	CALL	MWRITE		;write it back
	RET	NZ		;error, abort!
;
;	update directory track location in boot sector
;
	LD	D,0		;track zero
	CALL	FIRSTS		;E = first sector on trk
	LD	BC,BUFFER	;I/O buffer
	RST	@28		;read the boot
;
;	compute which byte holds the track
;
	LD	HL,BUFFER+1	;trsdos DD location
	LD	A,(IY+7)	;get dos type
	SUB	02H		;trsdos 1 DD?
	JR	Z,DOXR		;yep, go!
	DEC	A		;trsdos 3 DD?
	JR	Z,DOXR		;yes, go!
	INC	L		;normal dir location
DOXR	CP	7		;dosplus?
	JR	C,DOYYR		;nope, continue
	CP	10		;dosplus?
	JR	NC,DOYYR	;nope, continue
	LD	A,(IY+2)	;get directory
	BIT	6,(IY+6)	;double density?
	JR	Z,DOYYX		;nope, continue
	OR	80H		;set double den bit
	JR	DOYYX		;continue
;
DOYYR	LD	A,(IY+2)	;get directory
DOYYX	LD	(HL),A		;save it
;	write boot sector back to disk
;
	LD	BC,BUFFER	;where data is
	JP	@30		;write it back!
;
MOVDIR2	RST	@08		;display message
;
	DEFB	LF
	DEFM	'Track Allocated'
	DEFB	LF
	DEFB	ETX
;
	JP	MOVDIR1		;ask again
;
MOVDIR3	RST	@08		;message
;
	DEFB	LF
	DEFM	'Directory There'
	DEFB	LF
	DEFB	ETX
;
	JP	MOVDIR1		;ask again
;
;	display which tracks are free
;
SHOFTKS	RST	@08		;display linefeed
;
	DEFB	LF
	DEFB	ETX
;
	LD	B,(IY+1)	;track count
	DEC	B		;less one
	CALL	MNYGRNS		;mask byte
	LD	D,1		;start track +1
	LD	IX,GATBUFF+1	;start of table +1
	LD	HL,0		;H=dsp cntr, L=tot cntr
	LD	A,E		;get mask
	CP	0C0H		;nil T1D or T3?
	JR	NZ,SHOFTL	;go if not
	LD	E,L		;else actually zero
;
SHOFTL	LD	A,(IX)		;get GAT byte
	CP	E		;available?
	JR	NZ,SHOFT1	;nope, go!
	PUSH	BC		;save it
	LD	A,D		;get track
	RST	@18		;to decimal ascii
	LD	(SHOFT2),BC	;track to message
	POP	BC		;restore counter
	RST	@08		;display it
;
SHOFT2	DEFM	'xx-'
	DEFB	ETX
;
	INC	H		;bump counter
	INC	L		;bump total counter
	LD	A,H		;get dsp counter
	AND	0FH		;15 / line
	JR	NZ,SHOFT1	;go if not
	LD	H,A		;reset counter
	RST	@08		;send linefeed
;
	DEFB	BACKSP		;remove last dash
	DEFB	LF
	DEFB	ETX
;
SHOFT1	INC	IX		;bump gat
	INC	D		;bump track
	DJNZ	SHOFTL		;go till done
;
;	check if any tracks available
;
	LD	A,L		;get # counter
	OR	A		;any?
	JR	Z,SHOFT3	;go if none!
	RST	@08		;send linefeed
;
	DEFB	BACKSP		;backspace last -
	DEFB	LF		;send linefeed
	DEFB	ETX
;
	JP	MOVDIR1		;ask again
;
SHOFT3	RST	@08		;display message
;
	DEFM	'No Tracks Available'
	DEFB	ETX
;
	JP	GOBACK		;cannot move, no room
;
	PAGE
;
;	$MNYGRNS - compute number grans/track
;
;	EXT	D = # grans/track
;		E = empty track bit mask
;
MNYGRNS	BIT	0,(IY+5)	;double sided?
	JR	Z,MNYGRN1	;nope, continue
;
	LD	A,(IY+7)	;get dos type
	CP	7		;dosplus?
	JR	C,MNYGRN3	;nope, go!
	CP	10		;dosplus?
	JR	C,MNYGRN1	;yes, go!
;
MNYGRN3	LD	DE,04F0H	;4 grans / track
	BIT	6,(IY+6)	;single density
	RET	Z		;yes, return
;
	LD	DE,06C0H	;6 grans / track
	RET			;done
;
MNYGRN1	LD	DE,02FCH	;2 grans / track
	BIT	6,(IY+6)	;double density?
	RET	Z		;nope, return
;
	LD	DE,03F8H	;3 grans / track
	LD	A,(IY+7)	;get dos type
	CP	2		;t1d?
	RET	C		;nope, done!
	CP	04		;t3?
	RET	NC		;nope
;
	LD	DE,06C0H	;6 grans / track
	RET			;done
;
