; sufilea/asm - kjw/bqsd - 08/78 - version 3.0 - 11/82
;
	PAGE
;
	SUBTTL	'<SUFILEA/ASM - Files Section A>'
;
;	$DRVSTAT - check out disk drive status
;
DRVSTAT	RST	@08		;display couple linefeeds
;
	DEFB	LF
	DEFB	LF
	DEFB	ETX
;
	CALL	INITDVO		;activate all drives
	LD	A,0C9H		;return opcode for error
	LD	(HOLDIN),A	;return with error messg.
	LD	DE,DRVCHK	;subroutine address
	LD	BC,DRVCKD	;return vector
	JP	DRVCOMM		;do all drives
;
;	de-select all drives
;
DRVCKD	XOR	A		;load zero
;
;i*
	IF	MODI
	LD	(37E1H),A	;to select address I
	ENDIF
;i*
;
;iii*
	IF	MODIII
	OUT	(0F4H),A	;to select address III
	ENDIF
;iii*
;
	JP	GOBACK		;to sub-menu
;
;	check out drive for ready and mounted
;
DRVCHK	CALL	SELECT		;select current drive
	JR	NZ,DRVCHKB	;de-activated drive
;
;	load zero into current track so that the
;	next sector access will execute a $RESTORE
;	to get the tables back aligned.
;	we will do a 'hard' restore here so that we
;	my count the time to determine drive in system
;
	LD	(IY+3),0	;set current track to 0
	LD	A,(IY+4)	;get dct data
	AND	3		;compute step rate
	OR	8		;create 'RESTORE' command
;
;i*
	IF	MODI
	LD	(37ECH),A	;to FDC mod I
	ENDIF
;i*
;
;iii*
	IF	MODIII
	OUT	(0F0H),A	;to FDC mod III
	ENDIF
;iii*
;
	LD	BC,6000H	;count to wait for
;
SKKWWT	CALL	SELECT		;keep drive selected
	JR	NZ,DRVCHKB	;go if not in system
	DEC	BC		;less counter
	LD	A,B		;fetch it
	OR	C		;any bits on?
	JR	Z,DRVCHKB	;wait more if at 0000H
;
;i*
	IF	MODI
	LD	A,(37ECH)	;fetch FDC status I
	ENDIF
;i*
;
;iii*
	IF	MODIII
	IN	A,(0F0H)	;fetch FDC status III
	ENDIF
;iii*
;
	BIT	0,A		;command in progress?
	JR	NZ,SKKWWT	;yes, keep waiting
	BIT	2,A		;head over track zero?
	JR	Z,DRVCHKB	;nope, wait more
;
;	drive is in system - check for disk in drive
;
	CALL	STAT		;check for disk in drive
	JR	Z,DRVCKOK	;go if OK
	LD	HL,(TEMP3)	;get error message vect.
	PUSH	HL		;on the stack
	JP	@08		;display and return
;
;	drive is active and mounted
;
DRVCKOK	CALL	DRVASC		;fetch ascii drive #
	LD	(DVK1),A	;to the string
	RST	@08		;display message
;
	DEFB	LF
	DEFM	'Drive '
DVK1	DEFM	'x mounted and ready'
	DEFB	ETX
;
	RET			;on to next drive
;
;	drive is not in the system
;
DRVCHKB	CALL	DRVASC		;get ascii drive
	LD	(DVK2),A	;to the message
	RST	@08		;display it
;
	DEFB	LF
	DEFM	'Drive '
DVK2	DEFM	'x NOT IN SYSTEM'
	DEFB	ETX
;
	SET	7,(IY+4)	;de-activate the drive
	RET
;
	PAGE
;
;	$FILEMAP - show locations of all files on disk
;
FILEMAP	CALL	GETDRVS		;get requested drives
	LD	DE,FILMAPR	;subroutine vector
	LD	BC,GOBACK	;to sub-menu when done
	XOR	A		;load zero
	LD	(LINEC),A	;clear line counter
	JP	DRVCOMM		;do all requested drives
;
;	mapper for each drive
;
FILMAPR	CALL	INITBD1		;allow error monitor
	CALL	RDDIR		;read the directory
	JP	NZ,NOTDIR	;can't, return
	CALL	DIRPART		;display disk name/date
	CALL	ALINE		;count the line
	CALL	ALINE		;2 lines long
	LD	IX,FILBUFF	;start of filenames
	CALL	ENTRIES		;get # entries in dir.
;
FILELP	BIT	4,(IX)		;active file?
	CALL	NZ,FILETOT	;display if active
	CALL	IXDIR		;advance IX to next entry
	CALL	PAUSE		;check for pause
	DEC	E		;less this entry
	JR	NZ,FILELP	;go if more to do
	RET			;else on to next drive
;
;	mapper for each file
;
FILETOT	BIT	7,(IX)		;extended entry?
	RET	NZ		;yes, skip this drive
	CALL	SAVEREG		;save registers
	LD	(TEMP4),IX	;save file start pointer
	RST	@08		;linefeeds to separate
;
	DEFB	LF
	DEFB	ETX
;
	CALL	ALINE		;for pause checking
	LD	HL,(CURSOR)	;fetch cursor position
	CALL	SHOWIT		;display filespec
	LD	BC,20		;move over 20 spaces
	ADD	HL,BC		;HL => next position
;
	BIT	6,(IX)		;system file?
	LD	A,'S'		;yes?
	JR	NZ,DO1S		;go if bit set
	LD	A,SPACE		;else put a blank
DO1S	LD	(HL),A		;to video
	INC	HL		;bump video pointer
;
	BIT	3,(IX)		;invisible file?
	LD	A,'I'		;yes?
	JR	NZ,DO2S		;go if set
	LD	A,SPACE		;else a blank
DO2S	LD	(HL),A		;to video
	INC	HL		;bump video
;
	LD	A,(IX)		;fetch whole first byte
	AND	7		;get protection level
	JR	Z,DO3S		;go if none
	LD	(HL),'P'	;else insert protection
	INC	HL		;bump video
	LD	(HL),'='	;prot =
	INC	HL		;bump video
	ADD	A,'0'		;make it ascii
	LD	(HL),A		;to video
;
DO3S	LD	HL,0		;load start value (0000H)
	LD	(TEMP0),HL	;FXDE counter
	LD	(TEMP1),HL	;file gran counter
	PUSH	IX		;save
	CALL	FILREL0		;display primary data
	POP	IX		;restore
	PUSH	IX		;save pointer
	CALL	FILMORE		;display EOF, pass's etc
	POP	IX		;restore
	JP	SHOEXTS		;display disk extents
;
;	display information about FPDE
;
FILREL0	RST	@08		;display
;
	DEFB	LF
	DEFM	'FP'
	DEFB	ETX
;
	CALL	ALINE		;count the line
	JR	FILREL		;display relative data
;
;	display data about FXDE
;
FILREL1	LD	A,(TEMP0)	;get current FXDE
	RST	@18		;to hex ascii
	LD	(FILLREY),BC	;NSB,LSB to string
	RST	@08		;display header
;
	DEFB	LF
	DEFM	'#'
FILLREY	DEFM	'xx FX'
	DEFB	ETX
;
	CALL	ALINE		;count this line
;
;	display relative information about dir record
;
FILREL	PUSH	IX		;pass FDE to HL
	POP	HL		;HL => dir record
	CALL	PAUSE		;check for a pause
	LD	A,L		;get byte offset in sect.
;
	PUSH	HL		;save start on stack
	RST	@20		;to hex ascii
	LD	(FN3),BC	;to the string
	OR	A		;clear carry flag
	LD	BC,FILBUFF	;start of file records
	SBC	HL,BC		;H = dir sector offset
	LD	A,H		;fetch offset
	ADD	A,2		;bump for real sector
	EX	AF,AF'		;save it in alternate A
	LD	A,H		;get offset again
	EX	(SP),HL		;fetch original HL
	OR	L		;create DEC code
	RST	@20		;to hex ascii
	LD	(FN4),BC	;to the string
	EX	AF,AF'		;get real sector back
	LD	(FGSSV),A	;save for cont use
	POP	HL		;;unstack
;
;	compute REAL directory track/sector
;
	CALL	GETDIR		;load DE with dir start
;
	LD	A,0		;get sector offset
FGSSV	EQU	$-1
	ADD	A,E		;add to starting sector
	RST	@18		;convert to decimal ascii
	LD	(FN2),BC	;to the string
	LD	A,(IY+2)	;get dir track
	RST	@18		;to decimal ascii
	LD	(FN1),BC	;to the string
	CALL	DRVASC		;get ascii drive #
	LD	(FN0),A		;to the string
	RST	@08		;display message
;
	DEFM	'DE - :'
FN0	DEFM	'x, Track = '
FN1	DEFM	'xx, Sector = '
FN2	DEFM	'xx, Byte = '
FN3	DEFM	'xxH, DEC = '
FN4	DEFM	'xxH'
	DEFB	ETX
;
	RET			;done, return
;
;	enable/disable alt FDE display on extended record
;
FILMOR2	LD	A,0C9H		;RET opcode
	LD	(FILMORX),A	;disable display
	JR	FILMORE-3	;continue
;
FILMOR0	XOR	A		;NOP opcode
	LD	(FILMORX),A	;allow call
	JR	FFLLFF		;continue
;
FILMOR1	LD	A,0C9H		;RET opcode
	LD	(FILMORX),A	;disable call
;
FFLLFF	XOR	A		;NOP opcode
	LD	(FILMORY),A	;enable call
;
FILMORE	CALL	PAUSE		;check for pause key
;
;	fetch end of file byte
;
	LD	A,(IX+3)	;get end of file byte
	LD	DE,0		;load value
	OR	A		;is it zero?
	JR	Z,FILMGO	;yes, go!
	DEC	DE		;set -1
;
FILMGO	RST	@20		;to hex ascii
	LD	(FM2),BC	;end of file byte
;
;	fetch end of file sector
;
	LD	L,(IX+20)	;end of file sector
	LD	H,(IX+21)	;MSB end of file
	ADD	HL,DE		;add 0 or -1 to correct
;
	PUSH	IY		;save DCT
	LD	IY,FM1		;message text
	CALL	BINASC		;load decimal ascii
	POP	IY		;restore stack
;
;	fetch logical record length
;
	LD	A,(IX+4)	;get logical record len.
	RST	@18		;to decimal ascii
	LD	(FM3),A		;MSB to string
	LD	(FM3+1),BC	;rest to string
;
;	fetch update password
;
	LD	C,(IX+16)	;get LSB
	LD	B,(IX+17)	;get MSB
	LD	HL,FM5		;text to load it
	CALL	PUTHEX		;load hex ascii
;
;	fetch access password
;
	LD	C,(IX+18)	;get LSB
	LD	B,(IX+19)	;get MSB
	LD	HL,FM4		;text to store it
	CALL	PUTHEX		;load hex ascii
;
;	setup loop to display all extent elements
;
	LD	BC,0500H	;B=extent counter
	BIT	5,(IY+5)	;trsdos Mod III?
	JR	Z,FLOOP11	;nope, go!
	LD	B,13		;else 13 extents/record
;
FLOOP11	LD	A,(IX+22)	;get extent element
	INC	A		;FF terminator?
	JR	Z,FLOOP12	;yes, done!
	INC	A		;FE extension?
	JR	Z,FLOOP12	;yes, done!
;
	LD	A,(IX+23)	;fetch # grans
	AND	1FH		;low 5 bits only
	CALL	COMPADD		;adjust for TRS III
	ADD	A,C		;add to total
	LD	C,A		;C = subtotal grans
	INC	IX		;bump pointer
	INC	IX		;2 byte pairs
	DJNZ	FLOOP11		;go for 5/13 extents
;
FLOOP12	LD	HL,(TEMP1)	;get grans this file
	LD	B,0		;BC = grans this extent
	ADD	HL,BC		;add total to new count
	LD	(TEMP1),HL	;re-save current total
	LD	A,C		;fetch # grans this xtent
	RST	@18		;to decimal ascii
	LD	(FM6),A		;MSB to string
	LD	(FM6+1),BC	;to the string
;
FILMORY	NOP			;display/return
	RST	@08		;display message
;
	DEFB	LF
	DEFM	'EOFS = '
FM1	DEFM	'xxxxx, EOFB = '
FM2	DEFM	'xxH, LRL = '
FM3	DEFM	'xxx'
	DEFB	ETX
;
FILMORX	NOP			;display/return
	CALL	ALINE		;count the line
	RST	@08		;display message
;
	DEFB	LF
	DEFM	'EACC = '
FM4	DEFM	'xxxxH, EUPD = '
FM5	DEFM	'xxxxH, Grans = '
FM6	DEFM	'xxx'
	DEFB	ETX
;
	CALL	ALINE		;count line
	RST	@08		;display header
;
	DEFB	LF
	DEFM	'Extents / '
	DEFB	ETX
;
	JP	ALINE		;count next line
;
;	display extent elements
;
SHOEXTS	CALL	PAUSE		;check for pause
	XOR	A		;load zero
	LD	(TEMP2),A	;current extent
;
;	check for terminator/extension
;
SHOXTL	LD	A,(IX+22)	;get extent element
	CP	-1		;terminator?
	JR	Z,SHOX1		;yes, go!
	CP	-2		;extension?
	JR	Z,SHOX2		;yes, go!
;
;	display starting track of element
;
	RST	@18		;convert to decimal ascii
	LD	(FO1),A		;MSB to string
	LD	(FO1+1),BC	;NSB,LSB to string
;
;	fetch starting gran (gran offset)
;
	LD	A,(IX+23)	;get extent
	AND	0E0H		;get starting gran
	RLCA			;align bits 7-5
	RLCA			;to bits 2-0
	RLCA			;bits now aligned
	AND	7		;low 3 only
	LD	B,A		;B = gran offset
	LD	A,(IY+6)	;get start sector
	AND	1		;A = starting sector
	INC	B		;B=0?
	DEC	B		;yes?
	JR	Z,FO22X		;go if yes
;
FO33X	ADD	A,(IY+10)	;add # sectors / gran
	DJNZ	FO33X		;go for # grans
;
FO22X	RST	@18		;to decimal ascii
	LD	(FO2),BC	;to the string
;
;	fetch # contiguous grans
;
	LD	A,(IX+23)	;get extent
	AND	1FH		;low 5 bits only
	CALL	COMPADD		;adjust for TRS III
	LD	B,A		;B = # contiguous grans
	LD	HL,0		;starting counter
	LD	E,(IY+10)	;sectors/gran
	LD	D,L		;DE = sectors/gran
	INC	B		;B=0?
	DEC	B		;yes?
	JR	Z,FO3XX		;go if yes
;
FO3YY	ADD	HL,DE		;add counter
	DJNZ	FO3YY		;compute it
;
FO3XX	LD	A,L		;get # sectors
	RST	@18		;to decimal ascii
	LD	(FO3),A		;ascii to text
	LD	(FO3+1),BC	;rest of it
;
	RST	@08		;display it
;
FO1	DEFM	'xxx,'
FO2	DEFM	'xx,'
FO3	DEFM	'xxx / '
	DEFB	ETX
;
;	advance to next element, check for end
;	if entry is corrupt, return immediately
;
	INC	IX		;bump pointer
	INC	IX		;2 bytes / extent
	LD	B,6		;maximum non-trs III
	LD	A,(IY+7)	;get dos type
	CP	03H		;trsdos III?
	JR	NZ,O341X	;nope, go!
	LD	B,14		;else max trs III
;
O341X	LD	A,(TEMP2)	;get current extent
	INC	A		;+1
	LD	(TEMP2),A	;re-save temporary
	CP	B		;at maximum element?
	JR	C,SHOXTL	;nope, continue
	RET			;else abort, corrupt!
;
;	end of file reached
;
SHOX1	RST	@08		;display at end of file
;
	DEFM	'EOF'
	DEFB	LF
	DEFB	ETX
;
	RET			;done, return
;
;	extension found, setup pointers for it
;
SHOX2	LD	A,(IX+23)	;get DEC of extension
	RST	@20		;to hex ascii
	LD	(FO4),BC	;to the string
	RST	@08		;display it
;
	DEFB	LF
	DEFM	'FXDE DEC = '
FO4	DEFM	'xxH'
	DEFB	LF
	DEFB	ETX
;
	LD	A,(IX+23)	;re-fetch it
	AND	1FH		;get sector offset
	LD	B,A		;B = sector offset
	LD	A,(IX+23)	;fetch again
	AND	0E0H		;get byte offset
	LD	C,A		;BC = entry offset
	LD	HL,FILBUFF	;start of records
	ADD	HL,BC		;HL => extension
	PUSH	HL		;pass back to IX
	POP	IX		;IX => extension
	LD	A,(TEMP0)	;get current extension
	INC	A		;bump it
	LD	(TEMP0),A	;save subtotal
;
;	display info about the FXDE
;
	CALL	FILREL1		;file part 1
	PUSH	IX		;save pointer
	CALL	FILMOR0		;file part 0
	POP	IX		;restore pointer
	JP	SHOEXTS		;display extent data
;
