SUU7   ;SUU7/ASM
 COUNTPUT	DW	0
 SUMPUT	DW	0
 TAPECOPY	RST	8
 	DB	7,'Tape Backup',10,10,0
 	CALL	ASKDECK
 	DI
 ;i*
 	IF	MODI
 	LD	A,4
 	OUT	(0FFH),A	;turn motor on
 	ENDIF
 ;iii*
 	IF	MODIII
 	LD	A,2
 	OUT	(0ECH),A
 	ENDIF
 ;
 	LD	DE,3C3FH	;corner of video
 	LD	A,99H
 	LD	(DE),A		;fill with block
 	LD	HL,3840H	;last row keyboard
 PULSE	BIT	1,(HL)		;clear key
 	JR	NZ,TDONE	;done if pressed
 	IN	A,(0FFH)	;get a bit
 	RLA			;get timing pip?
 	JR	NC,PULSE	;wait for it
 	LD	B,32H
 	DJNZ	$
 	LD	A,5
 	OUT	(0FFH),A
 	LD	B,10H
 	DJNZ	$
 	LD	A,6
 	OUT	(0FFH),A
 	LD	B,10H
 	DJNZ	$
 	LD	A,4
 	OUT	(0FFH),A	;send the bit
 	LD	A,(DE)
 	XOR	3FH
 	LD	(DE),A		;flash block on screen
 	JR	PULSE
 TDONE	XOR	A
 	OUT	(0FFH),A
 	EI
 	JP	GOBACK
 TAPEIN	LD	C,8		;go for 8 bits
 	XOR	A
 TAPEIN1	CALL	BITIN		;read 1 bit
 	RET	C
 	DEC	C
 	JR	NZ,TAPEIN1
 	SCF
 	CCF
 	RET
 BITCAN	POP	AF
 	SCF
 	RET
 BITIN	PUSH	AF
 BITIN1	BIT	1,(HL)
 	JR	NZ,BITCAN
 	IN	A,(0FFH)
 	RLA
 	JR	NC,BITIN1	;wait for timing pip
 	LD	B,41H
 	DJNZ	$
 	CALL	RESETPORT	;reset the port
 	LD	B,76H
 	DJNZ	$
 	IN	A,(0FFH)
 	LD	B,A
 	POP	AF
 	RL	B
 	RLA
 	PUSH	AF
 	CALL	RESETPORT
 	POP	AF
 	SCF
 	CCF
 	RET
 RESETPORT	LD	A,4
 	OUT	(0FFH),A
 	RET
 TAPEOUT	PUSH	DE
 	PUSH	BC
 	PUSH	AF
 	PUSH	HL
 	LD	C,8		;go for 8 bits
 	LD	D,A
 TAPEOUT0	CALL	SENDPIP		;send timing pip
 	LD	A,D
 	RLCA			;move to carry bit
 	LD	D,A
 	JR	NC,TAPEOUT1
 	CALL	SENDPIP
 TAPEOUT2	DEC	C
 	JR	NZ,TAPEOUT0
 	POP	HL
 	POP	AF
 	POP	BC
 	POP	DE
 	RET
 TAPEOUT1	LD	B,87H
 	DJNZ	$
 	JR	TAPEOUT2	;send 0 bit (nothing)
 SENDPIP	LD	HL,0FC01H
 	CALL	DOPIP
 	LD	B,0BH
 	DJNZ	$
 	LD	HL,0FC02H
 	CALL	DOPIP
 	LD	B,0BH
 	DJNZ	$
 	LD	HL,0FC00H
 	CALL	DOPIP
 	LD	B,5CH
 	DJNZ	$
 	RET
 DOPIP	LD	A,(PIPZER)
 	AND	H
 	OR	L
 	OUT	(255),A
 	LD	(PIPZER),A
 	RET
 PIPZER	DB	0
 ;i*
 	IF	MODI
 ASKDECK	RST	8
 	DB	1EH,'Use Deck 1 or 2 ? ',0
 	CALL	ONEKEY
 	JR	Z,DECK1
 	SUB	30H
 	JR	C,ASKDECK
 	JR	Z,ASKDECK
 	CP	3
 	JR	NC,ASKDECK
 	DEC	A
 DECK0	LD	(37E4H),A
 	JR	TPROMPT
 DECK1	XOR	A
 	JR	DECK0
 	ENDIF
 ;iii*
 	IF	MODIII
 ASKDECK	JR	TPROMPT
 	ENDIF
 ;
 TPROMPT	RST	8
 	DB	10,'Press <ENTER> to begin. ',0
 	CALL	ONEKEY
 	RST	8
 	DB	1EH,'Press <CLEAR> to terminate.',10,0
 	RET
 TAPEINIT	XOR	A	;setup registers
 	SBC	HL,HL		;HL=0
 	LD	D,H
 	LD	E,L		;DE=0, byte counter
 	EXX			;HL = checksum
 	LD	IY,3C00H+896	;video byte display
 	LD	HL,3840H	;for clear key test
 	LD	DE,DAMBUFF	;lowest page buffer
 	RET			;done
 FINDSYNC	RST	8
 	DB	1EH,'Looking for sync byte.',0
 ;i*
 	IF	MODI
 	LD	A,4
 	OUT	(0FFH),A
 	ENDIF
 ;iii*
 	IF	MODIII
 	LD	A,2
 	OUT	(0ECH),A
 	ENDIF
 ;
 	CALL	DLOFF
 	DI
 TAPELDR	CALL	BITIN		;read 1 bit
 	JR	C,TAPELDRD	;cancel from break
 	CP	0A5H		;have the byte yet?
 	JR	NZ,TAPELDR	;go loop
 	LD	A,99H		;put graphic block
 TAPELDRC	LD	(3C3FH),A
 	RET			;done
 TAPELDRD	LD	A,0	;don't change flags
 ;i*
 	IF	MODI
 	OUT	(0FFH),A
 	ENDIF
 ;iii*
 	IF	MODIII
 	OUT	(0ECH),A
 	ENDIF
 ;
 	LD	A,'C'		;cancel notify
 	JR	TAPELDRC	;put on video
 TAPESHOW	PUSH	AF	;save the key
 	EXX
 	LD	C,A		;pass to BC
 	LD	B,0
 	ADD	HL,BC		;add to checksum
 	INC	DE		;bump byte counter
 	EXX
 	LD	(IY-64),A	;poke ascii direct
 	RST	20H		;make it ascii
 	LD	(IY),C		;MSB
 	LD	(IY+64),B	;LSB ascii
 	INC	IY		;bump video pointer
 	PUSH	IY		;pass to BC
 	POP	BC
 	LD	A,C		;get LSB
 	CP	0C0H
 	JR	NZ,TAPESHOW1	;continue if not at end
 	LD	IY,3C00H+896	;reset to begin of line
 TAPESHOW1	LD	(IY-64),0BFH
 	LD	(IY),0BFH
 	LD	(IY+64),0BFH
 	EXX
 	LD	A,D		;get counter
 	RST	20H
 	LD	(TAPEINA),BC
 	LD	A,E
 	RST	20H
 	LD	(TAPEINA+2),BC
 	EXX
 	RST	8
 	DB	1DH,'Byte Count = '
 TAPEINA	DB	'xxxxH.',0
 	LD	A,(3C3FH)	;change block in corner
 	XOR	3FH
 	LD	(3C3FH),A	;re-draw it
 	POP	AF
 	RET			;restore original
 TAPERD	RST	8
 	DB	7,'Tape Read',10,10,0
 	CALL	ASKDECK
 	CALL	TAPEINIT	;intinialize registers
 	CALL	FINDSYNC	;look for sync byte
 TAPERDL	CALL	TAPEIN		;read 1 byte
 	JR	C,TAPERDD	;done/cancel
 	LD	(DE),A		;put in buffer
 	CALL	TAPESHOW	;display it
 	INC	DE		;bump buffer
 	JR	TAPERDL		;continue in loop
 TAPERDD	XOR	A
 ;i*
 	IF	MODI
 	OUT	(0FFH),A
 	ENDIF
 ;iii*
 	IF	MODIII
 	OUT	(0ECH),A
 	ENDIF
 ;
 	EXX			;get values
 	LD	(COUNTPUT),DE	;save byte count
 	LD	(SUMPUT),HL	;save checksum
 	EI			;can enable now
 	CALL	PRESS		;enter to continue
 	LD	A,D		;get sum
 	OR	E		;anything?
 	JP	Z,RETURN	;back to menu
 	LD	BC,DAMBUFF	;else display the bytes
 	JP	DOADDR		;display address
 TAPEVERNO	RST	8
 	DB	'NO DATA in memory !',0
 	JP	GOBACK
 TAPEVER	RST	8
 	DB	7,'Tape Verify',10,10,0
 	CALL	INITCOUNT
 	LD	HL,(COUNTPUT)
 	LD	A,H
 	OR	L
 	JR	Z,TAPEVERNO
 	CALL	ASKDECK
 	LD	HL,(COUNTPUT)
 	LD	A,H
 	RST	20H
 	LD	(TAPEINA1),BC
 	LD	A,L
 	RST	20H
 	LD	(TAPEINA1+2),BC
 	LD	HL,(SUMPUT)	;get old checksum
 	LD	A,H
 	RST	20H
 	LD	(TAPEINA2),BC
 	LD	A,L
 	RST	20H
 	LD	(TAPEINA2+2),BC
 	RST	8
 	DB	'Last Tape Read: Byte Count = '
 TAPEINA1	DB	'xxxxH, Checksum = '
 TAPEINA2	DB	'xxxxH.',10,0
 	CALL	TAPEINIT	;setup registers
 	CALL	FINDSYNC	;find the sync byte
 TAPEVERL	CALL	TAPEIN	;read 1 byte
 	JR	C,TAPEVERD	;done
 	PUSH	AF
 	EX	DE,HL		;test for same
 	CP	(HL)		;yes?
 	EX	DE,HL
 	LD	A,20H		;space
 	JR	Z,TAPEVER1	;continue
 	CALL	ADDCOUNT	;bump error counter
 	LD	A,5CH		;D arrow
 TAPEVER1	LD	BC,-40H
 	ADD	IY,BC		;point 1 line up
 	LD	(IY-64),A	;put in video
 	LD	BC,40H
 	ADD	IY,BC		;put it back
 	POP	AF		;restore byte back
 	CALL	TAPESHOW	;display it
 	INC	DE		;bump buffer
 	EXX			;get counter
 	PUSH	HL		;save checksum
 	LD	HL,(COUNTPUT)	;get last byte count
 	OR	A		;clear carry
 	SBC	HL,DE		;subtract this count
 	POP	HL		;restore it
 	EXX
 	JR	NZ,TAPEVERL	;go loop if not done
 TAPEVERD	LD	A,0
 ;i*
 	IF	MODI
 	OUT	(0FFH),A
 	ENDIF
 ;iii*
 	IF	MODIII
 	OUT	(0ECH),A
 	ENDIF
 ;
 	EI
 	CALL	SHOCOUNT	;display counter
 	RST	8
 	DB	'errors during verify.',0
 	CALL	PRESS
 	JP	RETURN		;go back
 TAPEWRT	RST	8
 	DB	7,'Tape Write',10,10,0
 	LD	HL,(COUNTPUT)
 	LD	A,H
 	OR	L
 	JP	Z,TAPEVERNO
 	CALL	ASKDECK
 	CALL	TAPEINIT
 	CALL	PUTSYNC
 	EXX
 	LD	DE,(COUNTPUT)
 	EXX
 TAPEWRL	LD	A,(DE)
 	CALL	TAPEOUT
 	CALL	TAPESHOW
 	INC	DE
 	CALL	IFCLEAR
 	JP	C,TAPERDD
 	EXX
 	DEC	DE
 	LD	A,D
 	OR	E
 	EXX
 	JR	NZ,TAPEWRL
 	JP	TAPERDD
 PUTSYNC	RST	8
 	DB	1EH,'Writing Leader.',0
 ;i*
 	IF	MODI
 	LD	A,4
 	OUT	(0FFH),A
 	ENDIF
 ;iii*
 	IF	MODIII
 	LD	A,2
 	OUT	(0ECH),A
 	ENDIF
 ;
 	DI
 	LD	BC,8000H
 	CALL	DELAY
 	LD	B,0
 PUTSNY	XOR	A
 	PUSH	BC
 	CALL	TAPEOUT
 	POP	BC
 	DJNZ	PUTSNY
 	RET
 	ENDIF
 ;iii*
 	IF	MODIII
 	LD	A,2
 	OUT	(0ECH),A
 	ENDIF
 ;
 	DI
 	LD	BC,8000H
 	CALL	DELAY
 