; ptfilec/asm - kjw/bqsd - 10/82
;
	PAGE
;
	SUBTTL	'<PTFILEC/ASM - Files Section C>'
;
SECALLO	CALL	GETDAT		;get drive/track/sector
	RST	@08		;send linefeed
;
	DEFB	LF
	DEFB	ETX
;
	LD	(TEMP7),DE	;save track/sector
	CALL	DSTAT		;drive ready?
	CALL	RDDIR		;read directory
	JP	NZ,NOTDIR	;can't read it!
	CALL	FIGTKS		;compute track count
	CALL	ENTRIES		;get # entries / dir.
	LD	IX,FILBUFF	;start of records
;
REORGLP	BIT	4,(IX)		;active file?
	CALL	NZ,REORGIT	;see if file matches
	CALL	IXDIR		;move IX to next record
	DEC	E		;less this record
	JR	NZ,REORGLP	;finish all files on disk
	RST	@08		;not assigned
;
	DEFB	LF
	DEFM	'Sector NOT ASSIGNED'
	DEFB	ETX
;
	JP	GOBACK		;back to sub-menu
;
;	check out this file for track/sector match
;
REORGIT	BIT	7,(IX)		;extended entry?
	RET	NZ		;yes, don't do yet
;
	CALL	SAVEREG		;save registers
;
	LD	BC,0		;starting relative sector
;
RORGLP	LD	DE,FILBUFF	;start of records
	CALL	POSITBC		;position the file
	RET	C		;end of file!
;
;	DE = track sector of relative file sector
;	     check for match with desired
;
	LD	HL,(TEMP7)	;get desired track/sector
	SBC	HL,DE		;compare actual/desired
	JR	Z,REOGFND	;found! go!
	INC	BC		;bump rel sector
	JR	RORGLP		;check out next
;
;	file found, display
;
REOGFND	PUSH	BC		;save relative sector
	RST	@08		;display header
;
	DEFB	LF
	DEFM	'Assigned to file: '
	DEFB	ETX
;
	LD	HL,(CURSOR)	;fetch cursor position
	CALL	SHOWIT		;display filename
	POP	HL		;restore relative sector
;
	PUSH	IY		;save DCT
	LD	IY,ROG		;text to load
	CALL	BINASC		;convert to decimal ascii
	POP	IY		;restore
;
	RST	@08		;display
;
	DEFB	LF
	DEFM	'Relative File Sector '
ROG	DEFM	'xxxxx'
	DEFB	ETX
;
	CALL	FILMOR1		;display data
	JP	GOBACK		;back to sub-menu
;
	PAGE
;
;	$OFSFILE - offset file entry point
;
OFSFILE	XOR	A		;load zero
	LD	(WRFLAG),A	;allow file write-back
	LD	(PASSB),A	;byte offset passer
;
OFFSE1	RST	@08		;linefeed
;
	DEFB	LF
	DEFB	ETX
;
	CALL	ASKFILE		;fetch filespec
	RST	@08
;
	DEFB	LF
	DEFB	ETX
;
	LD	(IXSAVX),IX	;save directory pointer
;
;	BC = available for byte counting
;	DE = current address of load block
;	HL => data buffer
;	BC'= lowest address so far
;	DE'= highest address so far
;	HL'= available for math on BC & DE
;	(TEMP9) = current relative file sector
;
	LD	BC,-1		;lowest address init
	LD	DE,0		;highest address init
	LD	(TEMP9),BC	;save nil rel sector
;
	PUSH	BC		;save -1 on stack
	EXX			;save alt set
	POP	HL		;HL = -1 for pointer
	LD	D,H		;pass to DE
	LD	E,L		;DE = -1
	INC	DE		;DE = 0 for init address
;
LOADCHK	CALL	GET1B		;get file byte
	CP	1		;block marker?
	JR	Z,NEWLOAD	;yes, get new address
	CP	2		;entry marker?
	JR	Z,NEWENT	;yes, go!
	CP	20H		;in range?
	JP	NC,FMTERR	;nope, go error!
;
;	we have a byte that begins a non-loading block
;	treat the next $LENGTH bytes as a remark block
;
	CALL	GET1B		;get length byte
	LD	B,A		;B = length of block
;
LOADDUM	CALL	GET1B		;fetch a byte / discard
	DJNZ	LOADDUM		;go for specified length
	JR	LOADCHK		;check next block header
;
;	01 load block found - fetch length and address
;
NEWLOAD	CALL	GETFADR		;get file address/length
	CALL	CXBOT		;check for lowest address
;
;	advance DE for this block
;
CNTLDB	CALL	GET1B		;fetch a byte
	INC	DE		;bump address
	DJNZ	CNTLDB		;finish this block
	CALL	CXTOP		;compare high address
	JR	LOADCHK		;check next block
;
;	02 entry point header found
;
NEWENT	CALL	GETFADR		;get block address
	LD	(TEMP2),DE	;save entry point
;
;	get low/high address range
;
	EXX			;get pointers back
	LD	(TEMP0),BC	;save low address
	DEC	DE		;to last real byte
	LD	(TEMP1),DE	;save end address
;
;	check for sufficient space to add appendage
;
	EXX			;get pointers back
	XOR	A		;load zero
	SUB	L		;less byte offset
	CP	24		;room for 24 bytes?
	JR	NC,WAIOK	;yes, continue
	LD	BC,(TEMP9)	;get current file posit
	LD	DE,FILBUFF	;file buffer
	INC	BC		;add one
	CALL	POSITBC		;room for another sector?
	JR	NC,WAIOK	;yes, continue
;
;	insufficient space for appendage
;
	XOR	A		;load zero space
	JR	WAINOT		;continue
;
WAIOK	LD	A,-1		;load true
WAINOT	LD	(TEMP5),A	;save it
;
WAIOFF	CALL	SHOWOFF		;display offset range
	JR	LOADCK0		;continue
;
;	get file address header block
;
GETFADR	CALL	GET1B		;fetch a byte
	DEC	A		;less 2 bytes for
	DEC	A		;length
	LD	B,A		;B = remaining length
	CALL	GET1B		;get address
	LD	E,A		;E = lsb address
	CALL	GET1B		;get rest
	LD	D,A		;D = msb address
	RET			;B=length, DE=address
;
;	display file address range and entry point
;
SHOWOFF	LD	BC,(TEMP2)	;get entry point
	LD	HL,LOW3		;text string
	CALL	PUTHEX		;load hex ascii there
;
	LD	BC,(TEMP0)	;get low address
	LD	HL,LOW1		;text string
	CALL	PUTHEX		;load hex ascii
;
	LD	BC,(TEMP1)	;get high address
	LD	HL,LOW2		;text string
	CALL	PUTHEX		;load hex ascii
;
	RST	@08		;display message
;
	DEFB	LF
	DEFM	'Module load range = '
LOW1	DEFM	'xxxxH to '
LOW2	DEFM	'xxxxH   Entry = '
LOW3	DEFM	'xxxxH'
	DEFB	LF
	DEFB	ETX
;
	RET			;return
;
;	fetch new file information from user
;
LOADCK0	RST	@08		;display prompt
;
	DEFB	EOL
	DEFM	'New Load Address ? '
	DEFB	ETX
;
;	setup default values
;
	LD	HL,4000H	;default low offset
	LD	(TEMP4),HL	;save it
;
	LD	B,20		;20 char input
	RST	@10		;get from keyboard
	CALL	POSHL		;any input?
	JP	Z,WAIOFF	;nope, try again
;
	CALL	VALUE		;get address
	JP	C,WAIOFF	;invalid, ask again
;
;	compute offset factor
;
	PUSH	HL		;save input pointer
	LD	H,B		;pass new value to HL
	LD	L,C		;HL = user address
	LD	BC,(TEMP0)	;get old address
	OR	A		;clear carry flag
	SBC	HL,BC		;HL = offset to blocks
	LD	(TEMP3),HL	;save here
	POP	HL		;restore pointer
;
;	check for low offset address
;
	CALL	POSHL		;any more input
	LD	BC,(TEMP4)	;get default value
	JR	Z,GODODIS	;go default!
;
	CALL	VALUE		;get value from user
	JP	C,WAIOFF	;invalid, ask again
	LD	(TEMP4),BC	;save new address
;
GODODIS	CALL	APPEND		;add appendage?
	LD	A,(TEMP6)	;get response
	CP	'Y'		;yes?
	JP	Z,PUTOFF	;yes, disable interrupts?
	JP	PUTOFF2		;else don't ask
;
	PAGE
;
;	$GET1B - fetch a byte from file
;
GET1B	CALL	FETCHB		;fetch a byte
	RET	NC		;no error!
	JP	NZ,SUBMENU	;disk error!
	RST	@08		;display message
;
	DEFB	LF
	DEFM	'EOF Reached'
	DEFB	ETX
;
	JP	GOBACK		;back to sub menu
;
;	fetch byte from file
;
FETCHB	XOR	A		;load zero
	SCF			;set flag
PASSB	NOP			;RET here for write part
	INC	L		;char in buffer?
	JR	NZ,FETCHGO	;yes, just load it
;
;	need to read a new sector
;
	PUSH	BC		;must save BC and DE
	PUSH	DE
	LD	A,0		;check if to be written
WRFLAG	EQU	$-1
	DEC	A		;flag = 1?
	CALL	Z,WRITSEC	;yes, write out buffer
;
;	read in a relative sector
;
	LD	DE,FILBUFF	;file buffer
	LD	IX,(IXSAVX)	;start of record
	LD	BC,(TEMP9)	;current rel sector
	INC	BC		;bump it
	LD	(TEMP9),BC	;update data
	CALL	POSITBC		;position the file
	CALL	C,BADFET	;bad file, out of range
	LD	BC,BUFFER	;I/O buffer to use
;
	PUSH	BC		;save on stack
	RST	@28		;read the sector
	SCF
	POP	HL		;HL => buffer
;
	POP	DE		;unstack rest
	POP	BC
	RET	NZ		;return in error
;
FETCHGO	XOR	A		;set zero
	LD	A,(HL)		;fetch buffer byte
	RET			;return with flags/byte
;
BADFET	LD	A,0C9H		;load RET opcode for next
	LD	(PASSB),A	;call to attempt a fetch
	RET			;done
;
PUTOFF	RST	@08		;display prompt
;
	DEFB	EOL
	DEFM	'Disable Interrupts ? '
	DEFB	ETX
;
	LD	B,3		;3 char input
	RST	@10		;fetch keyboard input
	CALL	POSHL		;find first char
	LD	A,'Y'		;default response
	JR	Z,PUTOFF1	;nil, use default
;
	LD	A,(HL)		;get key input
	CALL	UCASE		;make upper case
	CP	'Y'		;add offset yes?
	JR	Z,PUTOFF1	;go if yes
	CP	'N'		;no?
	JR	NZ,PUTOFF	;neither, ask again
	XOR	A		;NOP opcode
	JR	PUTOFF2		;continue
;
PUTOFF1	LD	A,0F3H		;DI opcode
;
PUTOFF2	LD	HL,-1		;starting rel sector
	LD	(USEDIX),A	;save appendage opcode
	LD	(TEMP9),HL	;save relative sector
	XOR	A		;load NOP opcode
	LD	(WRFLAG),A	;dis-allow sector update
	RST	@08		;send linefeed
;
	DEFB	LF
	DEFB	ETX
;
	CALL	GET1B		;get first byte
	PUSH	AF		;save input byte
	LD	A,1		;turn on sector update
	LD	(WRFLAG),A	;save it
	POP	AF		;restore byte
	JR	PUTLD+3		;contine!
;
PUTLD	CALL	GET1B		;fetch a byte
	CP	1		;load marker?
	JR	Z,PUTLD1	;yes, write new address
	CP	2		;entry point?
	JR	Z,PUTLD2	;yes, go!
	CP	20H		;load file error?
	JP	NC,FMTERR	;yes, go!
;
;	remark header, load in and ignore
;
	CALL	GET1B		;fetch length byte
	LD	B,A		;B = length
;
PUTLD0	CALL	GET1B		;fetch a dummy byte
	DJNZ	PUTLD0		;finish dummy
	JR	PUTLD		;check next block
;
;	new load block
;
PUTLD1	CALL	GET1B		;fetch buffer byte
	LD	B,A		;save length
	CALL	GET1B		;get LSB address
	LD	E,A		;save it
;
;	add offset to byte in buffer
;
	LD	A,(TEMP3)	;get LSB offset
	ADD	A,E		;add it
	LD	(HL),A		;to the buffer
;
	PUSH	AF		;save carry flag on stack
	CALL	GET1B		;get MSB address
	LD	D,A		;save in D
	LD	A,(TEMP3+1)	;get MSB offset
	ADD	A,D		;add to address
	LD	D,A		;save subtotal
	POP	AF		;get carry flag back
;
	JR	NC,PUTLDX	;didn't change page
	INC	D		;else bump MSB
PUTLDX	LD	(HL),D		;to the buffer
	DEC	B		;less 2 byte address
	DEC	B
	JR	PUTLD0		;go next block
;
PUTLD2	LD	A,(TEMP6)	;add appendage?
	CP	'Y'		;yes?
	JP	NZ,PUTLD4	;nope, put entry point
;
;	add new load block 23 bytes long
;
	LD	(HL),01		;load block header
	CALL	GET1B		;fetch a byte
	LD	(HL),23		;appendage length
	CALL	GET1B		;get LSB old entry
	LD	DE,(TEMP1)	;get high address
	INC	DE		;next free byte
;
	LD	(TEMP2),DE	;new entry point
	PUSH	HL		;save buffer address
	LD	HL,(TEMP3)	;get offset
	ADD	HL,DE		;new load address
	EX	DE,HL		;DE = address
	POP	HL		;restore buffer
;
	LD	(HL),E		;new block address
	CALL	GET1B		;get next
	LD	(HL),D		;MSB new block address
	CALL	GET1B		;get another byte
	LD	A,0		;get NOP or DI opcode
USEDIX	EQU	$-1
	LD	(HL),A		;write to file
;
;	push registers on stack
;
	CALL	GET1B		;get next byte
	LD	(HL),0E5H	;PUSH HL opcode
	CALL	GET1B		;get next
	LD	(HL),0D5H	;PUSH DE opcode
	CALL	GET1B		;get next
	LD	(HL),0C5H	;PUSH BC opcode
;
;	compute direction of move
;
	PUSH	HL		;save buffer address
	LD	HL,(TEMP1)	;get high address
	LD	DE,(TEMP0)	;get low address
	OR	A		;clear carry
	SBC	HL,DE		;HL = data length -1
	INC	HL		;HL = length
	LD	B,H		;pass to BC
	LD	C,L		;BC = length
	EX	DE,HL		;HL = low address
;
	PUSH	HL		;save it
	LD	DE,(TEMP3)	;get offset
	ADD	HL,DE		;HL = where it goes
	POP	DE		;restore start
	LD	A,0B0H		;2nd byte LDIR opcode
	OR	A		;clear carry
	PUSH	HL		;save
	SBC	HL,DE		;compare HL & DE
	POP	HL		;restore start
	JR	NC,ADDAPP	;use LDIR to move it
;
;	moving data backward
;
	ADD	HL,BC		;add length to start
	DEC	HL		;HL => last byte
	EX	DE,HL		;HL = new address
	ADD	HL,BC		;add length
	DEC	HL		;HL => last byte
	EX	DE,HL		;HL=old end, DE=new end
	LD	A,0B8H		;2nd byte LDDR opcode
;
ADDAPP	EX	(SP),HL		;HL = buffer, (SP) = old
	EX	DE,HL		;DE=buffer, HL = new
	EX	(SP),HL		;new on stack, HL = old
	EX	DE,HL		;HL=> buff, DE = old add
;
	LD	(LDIDR),A	;save opcode
	CALL	GET1B		;get a byte
	LD	(HL),21H	;LD HL opcode
	CALL	GET1B		;get a byte
	LD	(HL),E		;LSB address
	CALL	GET1B		;get a byte
	LD	(HL),D		;MSB address
;
	POP	DE		;get new load address
	CALL	GET1B		;get a byte
	LD	(HL),11H	;LD DE opcode
	CALL	GET1B		;get a byte
	LD	(HL),E		;LSB address
	CALL	GET1B		;get a byte
	LD	(HL),D		;MSB address
;
	CALL	GET1B		;get a byte
	LD	(HL),01H	;LD BC opcode
	CALL	GET1B		;get a byte
	LD	(HL),C		;LSB length
	CALL	GET1B		;get a byte
	LD	(HL),B		;MSB length
;
	CALL	GET1B		;get a byte
	LD	(HL),0EDH	;first byte LDIR/LDDR
	CALL	GET1B		;get a byte
	LD	(HL),0		;second byte
LDIDR	EQU	$-1
;
	CALL	GET1B		;get a byte
	LD	(HL),0C1H	;POP BC opcode
	CALL	GET1B		;get a byte
	LD	(HL),0D1H	;POP DE opcode
	CALL	GET1B		;get a byte
	LD	(HL),0E1H	;POP HL opcode
;
	CALL	GET1B		;get a byte
	LD	(HL),0C3H	;JP opcode
;
	LD	DE,(TEMP2)	;old entry point
	CALL	GET1B		;get a byte
	LD	(HL),E		;LSB vector
	CALL	GET1B		;get a byte
	LD	(HL),D		;MSB vector
;
PUTLD4	CALL	GET1B		;get a byte
	LD	(HL),02		;entry header
	CALL	GET1B		;get another
	LD	(HL),02		;entry length
	CALL	GET1B		;get another
;
;	compute new entry point
;
	PUSH	HL		;save buff pointer
	LD	HL,(TEMP3)	;get offset
	LD	DE,(TEMP2)	;get entry point
	ADD	HL,DE		;HL = new entry
	EX	DE,HL		;DE = new entry
	POP	HL		;restore buffer
;
	LD	(HL),E		;LSB address
	CALL	GET1B		;get another
	LD	(HL),D		;MSB address
	CALL	GET1B		;write last byte to file
;
;	file written back, update EOFS and EOFB
;
	LD	A,L		;get end of file byte
	LD	IX,(IXSAVX)	;fetch directory pointer
	LD	(IX+3),A	;set EOF byte
	LD	HL,(TEMP9)	;get end of file sector
	INC	HL		;adjust to actual
	LD	(IX+20),L	;LSB to dir entry
	LD	(IX+21),H	;MSB to dir entry
	CALL	WRITSEC		;write the sector
	CALL	WRDIR		;write the directory
	JP	GOBACK		;back to sub-menu
;
	PAGE
;
;	$FMTERR - attempt to offset non-load format
;
FMTERR	RST	@08		;display message
;
	DEFB	LF
	DEFM	'File is not in Load Format'
	DEFB	ETX
;
	JP	GOBACK		;back to sub-menu
;
;	check for new address in DE against
;	current highest and lowest addresses
;
CXTOP	PUSH	DE		;new address on stack
	EXX			;swap registers
	POP	HL		;HL = new address
;
	PUSH	HL		;leave back on stack
	OR	A		;clear carry
	SBC	HL,DE		;compare to highest addr
	JR	C,CXTOPN	;nope, continue
;
	POP	DE		;DE = new high address
	PUSH	DE		;leave dummy
;
CXTOPN	POP	HL		;fix the stack
	EXX			;swap back
	RET			;done
;
;
CXBOT	PUSH	DE		;pass address
	EXX			;get alt set
	POP	HL		;HL = new address
;
	PUSH	HL		;leave back on stack
	OR	A		;clear carry
	SBC	HL,BC		;test to start
	JR	NC,CXKBD	;not less, go!
;
	POP	BC		;get address from stack
	PUSH	BC		;leave dummy
;
CXKBD	POP	HL		;dummy pop
	EXX			;swap back
	RET			;done
;
;
;	$APPEND - ask user if appendage is to be added
;
APPEND	LD	A,(TEMP5)	;get space flag
	OR	A		;room to add?
	JR	NZ,APPEND0	;yes, go!
	RST	@08		;display message
;
	DEFB	LF
	DEFM	'Insufficient file space for appendage'
	DEFB	LF
	DEFM	'<KEY> to write file:'
	DEFB	ETX
;
	CALL	ONEKEY		;get a key
	LD	A,'N'		;set no appendage
	JR	APPEND2		;continue
;
APPEND0	RST	@08		;display linefeed
;
	DEFB	LF
	DEFB	ETX
;
APPEND1	RST	@08		;display prompt
;
	DEFB	EOL
	DEFM	'Add Appendage ? '
	DEFB	ETX
;
	LD	B,3		;3 char input
	RST	@10		;get from keyboard
;
	CALL	POSHL		;position to char
	LD	A,'Y'		;default yes
	JR	Z,APPEND2	;go default
;
	LD	A,(HL)		;get key input
	CALL	UCASE		;make upper case for test
	CP	'Y'		;yes?
	JR	Z,APPEND2	;yes, go!
	CP	'N'		;no?
	JR	NZ,APPEND1	;neither, ask again
;
APPEND2	LD	(TEMP6),A	;save answer
	RST	@08		;send linefeed
;
	DEFB	LF
	DEFB	ETX
;
	RET			;done
;
;	display load block
;
SHOWBLK	PUSH	HL		;save pointer
	PUSH	DE		;save address
	PUSH	BC		;save counter
;
	LD	B,D		;pass address to BC
	LD	C,E		;BC = load address
	LD	HL,SHOWB1	;text for address
	CALL	PUTHEX		;insert address
;
	POP	BC		;get length back
	PUSH	BC		;leave it
	LD	L,B		;L = length
	LD	H,0		;HL = length
	ADD	HL,DE		;HL => end address
	LD	B,H		;pass to BC
	LD	C,L		;BC = end address
	LD	HL,SHOWB2	;text for address
	CALL	PUTHEX		;insert address
;
	POP	BC		;unstack
	POP	DE
	POP	HL
	RST	@08		;display block
;
	DEFM	'Block Loads from '
SHOWB1	DEFM	'xxxxH to '
SHOWB2	DEFM	'xxxxH'
	DEFB	LF
	DEFB	ETX
;
	RET			;done
;
