; ptdata/asm - kjw/bqsd - 10/82
;
	PAGE
;
	SUBTTL	'<PTDATA/ASM - Equivalences>'
;
@00	EQU	00H		;RST 00H
@08	EQU	08H		;RST 08H
@10	EQU	10H		;RST 10H
@18	EQU	18H		;RST 18H
@20	EQU	20H		;RST 20H
@28	EQU	28H		;RST 28H
@30	EQU	30H		;RST 30H
@38	EQU	38H		;RST 38H
;
VIDEO	EQU	3C00H		;start of video memory
ETX	EQU	00H		;end of text
CR	EQU	0DH		;carriage return
LF	EQU	0AH		;line feed
BLANK	EQU	20H		;blank char
BOL	EQU	1DH		;cursor to line beginning
EOL	EQU	1EH		;clear to end of line
ETBL	EQU	00H		;end of table
CLSF	EQU	05H		;clear screen and frame
CLSA	EQU	06H		;clear all screen
CLSB	EQU	07H		;clear bottom screen
TAB	EQU	09H		;tab
BACKSP	EQU	08H		;backspace
UFEED	EQU	0BH		;up linefeed
PROMPT	EQU	5FH		;prompt char
CURCHR	EQU	8CH		;cursor character
BLOCK	EQU	0BFH		;block character
COMMA	EQU	','		;comma
;
ENTER	EQU	0DH		;enter key
SENTER	EQU	0EH		;shift enter key
CLEAR	EQU	03H		;clear key
SCLEAR	EQU	04H		;shift clear key
BREAK	EQU	01H		;break key
SBREAK	EQU	02H		;shift break key
UARR	EQU	5BH		;up arrow
SUARR	EQU	1BH		;shift up arrow
DARR	EQU	5CH		;down arrow
SDARR	EQU	1AH		;shift down arrow
LARR	EQU	5DH		;left arrow
SLARR	EQU	18H		;shift left arrow
RARR	EQU	5EH		;right arrow
SRARR	EQU	19H		;shift right arrow
SPACE	EQU	20H		;space bar
SSPACE	EQU	80H		;shift space bar
;
	PAGE
;
	SUBTTL	'<PTDATA/ASM - Data Storage Area>'
;
	PAGE
;
;	RST vector table
;
RST08	JP	DISPLY		;string to video
RST10	JP	GETSTR		;keyboard line input
RST18	JP	ASCII		;binary => ascii DECIMAL
RST20	JP	HEXCV		;binary => ascii HEX
RST28	JP	SHOREAD		;sector read / display
RST30	JP	SHOWRIT		;sector write / display
RST38	JP	TASK		;interrupt service
;
;	2 additional vectors for program entry
;
MASTER	JP	MENU		;return main menu
SUBMENU	JP	RETURN		;return sub-menu
;
;	flag bytes
;
WHERE	DEFB	0		;sub-menu return flag
;	0 = main menu
;	1 = disk zap
;	2 = disk purge
;	3 = disk format
;	4 = disk backup
;	5 = disk repair
;	6 = tape utility
;	7 = memory utility
;	8 = file utility
;	9 = configuration
;
MODE	DEFB	0		;modify mode base
;	0 = HEX modify
;	1 = DECIMAL modify
;	2 = BINARY modify
;	3 = OCTAL modify
;	4 = ASCII modify
;
TYPE	DEFB	0		;source of modify data
;	1 = data from direct disk sector
;	2 = data from memory
;	3 = data from file sector
;
;	data
;
SECTOR	DEFB	0		;relative sector
TRAK	DEFB	0		;relative track
TRUE	DEFB	0		;real track
;
CURSOR	DEFW	3C00H		;video cursor location
;
EOFB	DEFB	0		;file end of file byte
EOFS	DEFW	0		;end of file sector
EOAS	DEFW	0		;end of allocation sector
;
FREEG	DEFW	0		;free granules
FREEF	DEFB	0		;free files
CGRANS	DEFW	0		;gran counter
;
ADDRESS	DEFW	BUFFER		;memory display address
DEFADDR	DEFW	MENU		;default address vector
FMTBUFF	DEFW	FBUFF		;buffer for build track
;
DIRSCNT	DEFB	0		;directory sector count
DIRPAGE	DEFB	0		;curr dir display page
;
TOPMEM	DEFW	0000H		;top of memory +1
MIDMEM	DEFW	MIDPNT		;middle free memory
BOTMEM	DEFW	BUFFER		;free memory start
;
;	printer data storage
;
PRSIZE	DEFW	400H		;size of buffer
PRBUFF	DEFW	0000H		;start of buffer
PRADDO	DEFW	0		;add to buffer offset
PRTAKO	DEFW	0		;take from buffer offset
;
NUMTYPE	DEFB	0		;number type for value
RESULT	DEFW	0		;result of disk I/O
;
;	NMI disk vector for Mod III at 4049H
;
	DEFB	0,0,0		;get it there
;
NMIVECT	JP	RETNMI		;NMI disk vector
RETNMI	RETN			;non-disk vector
;
;	temporary storage block for subroutine use
;
TEMP0	DEFW	0		;temporary storage
TEMP1	DEFW	0
TEMP2	DEFW	0
TEMP3	DEFW	0
TEMP4	DEFW	0
TEMP5	DEFW	0
TEMP6	DEFW	0
TEMP7	DEFW	0
TEMP8	DEFW	0
TEMP9	DEFW	0
;
;
;	return vector table
;
VECTOR0	DEFW	0		;#0
VECTOR1	DEFW	0		;#1
VECTOR2	DEFW	0		;#2
VECTOR3	DEFW	0		;#3
VECTOR4	DEFW	0		;#4
;
;	system operation flag
;
FLAGA	DEFB	0		;system flag A
;	7 = 1 = DUAL ACTIVE
;	6 = 1 = HISPEED clock ON
;	5 = 1 = DUAL ON
;	4 = 1 = Task Spooler De-Activated
;	3 = 1 = Extended ID Marks Mode (from ZAP)
;	2 = 1 = String Replace Flag
;	1 = 1 = Alive OFF
;	0 = 1 = Keyboard case lock switch ON
;
FLAGB	DEFB	0		;system flag B
;	7 = 1 = printer graphics ON
;	6 = 1 = printer lower case ON
;	5 = 1 = adjust printer graphics for MX80
;	4 = 1 = NO double density available
;	3 = 1 = send linefeeds on carriage returns
;	2 = 1 = Radio Shack Doubler Installed
;	1 = 1 = attempt non-standard disk read @ $DISDSK
;	0 = 1 = trace OFF
;
ZAPFLAG	DEFB	0		;ZAP error flag
MOD3FIL	DEFB	0		;filespec eval flag
SCANFLG	DEFB	0		;allow multiple drives
;
SDRIVE	DEFB	0		;source drive
DDRIVE	DEFB	0		;destination drive
MFLAG	DEFB	0		;disk mount prompts?
;
DRIV	DEFB	0		;binary drive number
DRIVE	DEFB	1		;bit pattern set for drv
POSA	DEFB	0		;curr drive for mult rout
RSECT	DEFW	0		;relative sector storage
;
RDTYPE	DEFB	88H		;sector read byte
WRTYPE	DEFB	0A8H		;sector write byte
;
BUFPAS	DEFW	0		;buffer save address
SECPAS	DEFW	0		;track/sector saver
TEMPFF	DEFW	0		;address of last byte I/O
;
STRLEN	DEFB	0		;string length
REPLEN	DEFB	0		;replacement length
HASDAT	DEFB	0		;if format over data
;
;	keyboard mask area for new key detect
;
KEYBRD	DEFB	0,0,0,0,0,0,0	;one byte each key row
;
;	keyboard lookup table for special keys
;
KEYTABL	DEFB	ENTER		;enter
	DEFB	SENTER		;sh enter
	DEFB	CLEAR		;clear
	DEFB	SCLEAR		;sh clear
	DEFB	BREAK		;break
	DEFB	SBREAK		;sh break
	DEFB	UARR		;u arr
	DEFB	SUARR		;sh u arr
	DEFB	DARR		;d arr
	DEFB	SDARR		;sh d arr
	DEFB	LARR		;l arr
	DEFB	SLARR		;sh l arr
	DEFB	RARR		;r arr
	DEFB	SRARR		;sh r arr
	DEFB	SPACE		;space
	DEFB	SSPACE		;sh space
;
;	displacement offsets for 'decrypt' mode
;
DISP1	DEFB	'+'		;type flag
DISP2	DEFB	20H		;type modifier
DISP3	DEFB	0		;type value
SHFLG	DEFB	0		;hex side adjust flag
;
COUNT	DEFW	0		;counter word
XCOUNT	DEFW	0		;disk error counter
XACOUNT	DEFW	0		;alternate counter
;
;	keyboard input area (70 bytes)
;
STRING	DEFM	'String String String String String '
	DEFM	'String String String String String '
;
;	system stack area (216 bytes)
;
	DEFM	'Stack Stack Stack Stack Stack Stack '
	DEFM	'Stack Stack Stack Stack Stack Stack '
	DEFM	'Stack Stack Stack Stack Stack Stack '
	DEFM	'Stack Stack Stack Stack Stack Stack '
	DEFM	'Stack Stack Stack Stack Stack Stack '
	DEFM	'Stack Stack Stack Stack Stack Stack '
STACK	EQU	$
;
;	filename storage area
;
FILEDCB	DEFM	'FilenameExt'
PASSWRD	DEFM	'Password'
;
;	checker string to make sure
;	my name doesn't get changed in the program
;
KIMCHK	DEFB	'K'<1,'i'<1,'m'<1,' '<1
	DEFB	'W'<1,'a'<1,'t'<1,'t'<1
;
;	disk drive data storage area, 10 bytes each
;	8 contiguous drive code tables (DCT's)
;
;	+0 = highest track on disk
;	+1 = current directory track
;	+2 = current head location
;	+3 = resident flags
;		7 = 1 = drive NOT IN SYSTEM
;		6 = 1 = software write protected
;		5 = 1 = motor delay 1/2 sec (else 1 sec)
;		4 = 1 = motor delay on reads
;		3 = 1 = current operation is WRITE
;		2 = 1 = double step the drive
;		1&0 = drive step rate (0-3)
;	+4 = disk description flags
;		7 = 1 = double density track 0
;		6 = 1 = double density disk remainder
;		5 = 1 = track 0 unavailable for file I/O
;		4 = unused
;		3 = 1 = active in multiple drive cmds
;		2 = 1 = directory ID marks REVERSED
;		1 = starting sector on track 0
;		0 = starting sector on non-track 0
;	+5 = dos description flags
;		7 = 1 = TRSDOS I Single Density
;		6 = 1 = TRSDOS I Double Density
;		5 = 1 = TRSDOS III Double Density
;		4 = 1 = LDOS I/III Single Density
;		3 = 1 = LDOS I/III Double Density
;		2 = 1 = SOLE I Double Density
;		1 = XTRA
;		0 = 1 = Dos Type Unknown
;	+6 = highest sector # track 0
;	+7 = highest sector # disk remainder
;	+8 = sectors / granule
;	+9 = granules / track
;
;i*
	IF	MODI
;
DCT0	DEFB	34		;00
	DEFB	17		;01
	DEFB	00		;02
	DEFB	00110011B	;03
	DEFB	00000000B	;04
	DEFB	10000000B	;05
	DEFB	09		;06
	DEFB	09		;07
	DEFB	05		;08
	DEFB	02		;09
	DEFB	00		;10
;
DCT1	DEFB	34		;00
	DEFB	17		;01
	DEFB	00		;02
	DEFB	00110011B	;03
	DEFB	00000000B	;04
	DEFB	10000000B	;05
	DEFB	09		;06
	DEFB	09		;07
	DEFB	05		;08
	DEFB	02		;09
	DEFB	00		;10
;
DCT2	DEFB	34		;00
	DEFB	17		;01
	DEFB	00		;02
	DEFB	00110011B	;03
	DEFB	00000000B	;04
	DEFB	10000000B	;05
	DEFB	09		;06
	DEFB	09		;07
	DEFB	05		;08
	DEFB	02		;09
	DEFB	00		;10
;
DCT3	DEFB	34		;00
	DEFB	17		;01
	DEFB	00		;02
	DEFB	00110011B	;03
	DEFB	00000000B	;04
	DEFB	10000000B	;05
	DEFB	09		;06
	DEFB	09		;07
	DEFB	05		;08
	DEFB	02		;09
	DEFB	00		;10
;
DCT4	DEFB	34		;00
	DEFB	17		;01
	DEFB	00		;02
	DEFB	10110011B	;03
	DEFB	00000000B	;04
	DEFB	10000000B	;05
	DEFB	09		;06
	DEFB	09		;07
	DEFB	05		;08
	DEFB	02		;09
	DEFB	00		;10
;
DCT5	DEFB	34		;00
	DEFB	17		;01
	DEFB	00		;02
	DEFB	10110011B	;03
	DEFB	00000000B	;04
	DEFB	10000000B	;05
	DEFB	09		;06
	DEFB	09		;07
	DEFB	05		;08
	DEFB	02		;09
	DEFB	00		;10
;
DCT6	DEFB	34		;00
	DEFB	17		;01
	DEFB	00		;02
	DEFB	10110011B	;03
	DEFB	00000000B	;04
	DEFB	10000000B	;05
	DEFB	09		;06
	DEFB	09		;07
	DEFB	05		;08
	DEFB	02		;09
	DEFB	00		;10
;
DCT7	DEFB	34		;00
	DEFB	17		;01
	DEFB	00		;02
	DEFB	10110011B	;03
	DEFB	00000000B	;04
	DEFB	10000000B	;05
	DEFB	09		;06
	DEFB	09		;07
	DEFB	05		;08
	DEFB	02		;09
	DEFB	00		;10
	ENDIF
;i*
;
;iii*
	IF	MODIII
;
DCT0	DEFB	39		;00
	DEFB	17		;01
	DEFB	00		;02
	DEFB	00110011B	;03
	DEFB	11000111B	;04
	DEFB	00100000B	;05
	DEFB	18		;06
	DEFB	18		;07
	DEFB	03		;08
	DEFB	06		;09
	DEFB	00		;10
;
DCT1	DEFB	39		;00
	DEFB	17		;01
	DEFB	00		;02
	DEFB	00110011B	;03
	DEFB	11000111B	;04
	DEFB	00100000B	;05
	DEFB	18		;06
	DEFB	18		;07
	DEFB	03		;08
	DEFB	06		;09
	DEFB	00		;10
;
DCT2	DEFB	39		;00
	DEFB	17		;01
	DEFB	00		;02
	DEFB	00110011B	;03
	DEFB	11000111B	;04
	DEFB	00100000B	;05
	DEFB	18		;06
	DEFB	18		;07
	DEFB	03		;08
	DEFB	06		;09
	DEFB	00		;10
;
DCT3	DEFB	39		;00
	DEFB	17		;01
	DEFB	00		;02
	DEFB	00110011B	;03
	DEFB	11000111B	;04
	DEFB	00100000B	;05
	DEFB	18		;06
	DEFB	18		;07
	DEFB	03		;08
	DEFB	06		;09
	DEFB	00		;10
;
DCT4	DEFB	39		;00
	DEFB	17		;01
	DEFB	00		;02
	DEFB	10110011B	;03
	DEFB	11000111B	;04
	DEFB	00100000B	;05
	DEFB	18		;06
	DEFB	18		;07
	DEFB	03		;08
	DEFB	06		;09
	DEFB	00		;10
;
DCT5	DEFB	39		;00
	DEFB	17		;01
	DEFB	00		;02
	DEFB	10110011B	;03
	DEFB	11000111B	;04
	DEFB	00100000B	;05
	DEFB	18		;06
	DEFB	18		;07
	DEFB	03		;08
	DEFB	06		;09
	DEFB	00		;10
;
DCT6	DEFB	39		;00
	DEFB	17		;01
	DEFB	00		;02
	DEFB	10110011B	;03
	DEFB	11000111B	;04
	DEFB	00100000B	;05
	DEFB	18		;06
	DEFB	18		;07
	DEFB	03		;08
	DEFB	06		;09
	DEFB	00		;10
;
DCT7	DEFB	39		;00
	DEFB	17		;01
	DEFB	00		;02
	DEFB	10110011B	;03
	DEFB	11000111B	;04
	DEFB	00100000B	;05
	DEFB	18		;06
	DEFB	18		;07
	DEFB	03		;08
	DEFB	06		;09
	DEFB	00		;10
	ENDIF
;iii*
;
;	lookup table to locate a DCT
;
DCTTBL	DEFW	DCT0
	DEFW	DCT1
	DEFW	DCT2
	DEFW	DCT3
	DEFW	DCT4
	DEFW	DCT5
	DEFW	DCT6
	DEFW	DCT7
;
;	lookup table to locate DOS particulars
;	data loaded into DCT from +4 - +10
;
@T1S	DEFB	000H,080H,09,09,05,02
@T1D	DEFB	061H,040H,09,18,03,06
@T3	DEFB	0C7H,020H,18,18,03,06
@LS	DEFB	000H,010H,09,09,05,02
@LD	DEFB	0C0H,008H,17,17,06,03
@S	DEFB	060H,004H,09,17,06,03
@X	DEFB	000H,000H,00,00,00,00
;
;	serial number storage area
;
SERSAVE	DEFB	0,0,0,0,0,0,0,0,0,0
	DEFB	0,0,0,0,0,0,0,0,0,0
	DEFB	0,0,0,0,0,0,0,0,0,0
;
