; ptcopy2/asm - kjw/bqsd - 11/82
;
	SUBTTL	'<Format/Read/Write>'
;
;	format track 1 for 80 track loader
;
FORM80	LD	HL,REMDRIV	;error exit
	PUSH	HL		;leave on stack
	LD	A,LF		;send linefeed
	CALL	VOUT		;to video
	LD	D,0		;load zero
	LD	E,D		;dummy sector
	LD	(IY+8),D	;set density
	INC	D		;track to find
	LD	(IY+0),D	;save it
	CALL	STAT		;check status
	RET	NZ		;lock drive if not ready
	CALL	SEEK		;seek track 1
	RET	NZ		;return if error
	CALL	BUILD		;build the track
	CALL	WRITETR		;format the track
	RET	NZ		;go if error
	POP	AF		;remove error vector
	XOR	A		;load zero
	RET			;return no error
;
;	format entire 35 track disk
;
FORMIT	LD	HL,REMDRIV	;remove drive error exit
	PUSH	HL		;leave on stack
	LD	A,LF		;send linefeed to video
	CALL	VOUT		;display char
	XOR	A		;start track 0
	LD	(IY+0),A	;save it
	LD	(IY+8),A	;setup as single den
	CALL	STAT		;check status
	RET	NZ		;error, return
	CALL	RESTORE		;restore to track 0
	RET	NZ		;error!
;
FORMLP	LD	D,(IY+0)	;pass track to D
	LD	E,0		;dummy for sect register
	CALL	SEEK		;seek the track
	RET	NZ		;format error!
	CALL	BUILD		;create track
	CALL	WRITETR		;write the track
	RET	NZ		;go if error
	LD	A,(IY+0)	;get track
	INC	A		;+1
	LD	(IY+0),A	;update pointer
	CP	(IY+1)		;at end?
	JR	C,FORMLP	;go till done
;
	POP	AF		;remove error vector
	XOR	A		;return Z
	RET			;done!
;
;	build format image in memory
;
BUILD	LD	C,(IY+0)	;get track
	SLA	C		;*2
	LD	B,0		;BC = offset in table
	LD	HL,TABLES	;start of table
	ADD	HL,BC		;HL = indirect address
	LD	E,(HL)		;get LSB
	INC	HL		;table +1
	LD	D,(HL)		;get MSB - DE => table
	EX	DE,HL		;HL => table
;
	PUSH	HL		;pass to IX
	POP	IX		;IX => length bytes
	INC	HL		;bump past length
	INC	HL		;HL => sector data
	LD	DE,BUFFER	;DE => I/O buffer
;
;	create each sector image in memory
;
SECLP	LD	A,(HL)		;get a bytre
	INC	A		;FF terminator?
	RET	Z		;yes, done!
	CALL	MOVE		;fill
	JR	SECLP		;go till done
;
;	move bytes to buffer
;
MOVE	LD	B,(HL)		;get byte count
	INC	HL		;bump table
	LD	A,(HL)		;get fill byte
	INC	HL		;bump table
;
FILL	LD	(DE),A		;char to buffer
	INC	DE		;bump buffer pointer
	DJNZ	FILL		;go till done
	RET			;buffer filled
;
;	read sector
;
READ	EXX			;save
	LD	HL,SREAD	;sector read
	LD	DE,0A2EDH	;INI opcode reversed
	LD	BC,SHOWRD	;display routine
	RES	7,(IY+9)	;set read
	JR	RWCOMM		;go common
;
;	write sector with no seek
;
WRITENS	EXX			;save
	LD	HL,NWRITE	;write no seek
	JR	WRTCM		;go write common
;
;	write sector
;
WRITE	EXX			;save
	LD	HL,SWRITE	;sector write
WRTCM	LD	DE,0A3EDH	;OUTI opcode reversed
	LD	BC,SHOWWR	;display driver
	JR	WRTRCM		;go common
;
;	write track
;
WRITETR	LD	HL,BUFFER	;I/O buffer
	LD	D,(IY+0)	;get track
	EXX			;save
	LD	HL,TRWRITE	;I/O section
	LD	BC,SHOWRTR	;display routine
WRTRCM	SET	7,(IY+9)	;set WRITE
;
RWCOMM	LD	A,(IY+2)	;get # retries
	LD	(IY+3),A	;init this loop
	LD	(RWCALL),HL	;pass call vector
	LD	(RWDIR),DE	;INI/OUTI opcodes
	LD	(RWDIR2),DE	;here also
	LD	(SHOWVEC),BC	;save display vector
	LD	BC,0000H	;NOP NOP
	BIT	7,(IY+9)	;READ?
	JR	Z,RWNOP		;yes, continue
	LD	BC,0FE10H	;DJNZ $  opcodes
RWNOP	LD	(RWTNOP),BC	;save into code
	EXX			;restore
	LD	(IY+0),D	;save track
	CALL	$		;display
SHOWVEC	EQU	$-2
;
WRITLP	PUSH	HL
	PUSH	DE		;save table
	PUSH	BC		;save buffer
	CALL	$		;read/write/format
RWCALL	EQU	$-2
	POP	BC		;restore
	POP	DE		;restore table
	POP	HL		;unstack
;
	OR	A		;check for errors
	RET	Z		;done, return
	EX	AF,AF'		;save error
	LD	A,0D8H		;immediate interrupt
	OUT	(0F0H),A	;reset it
	LD	A,0D0H		;clear FDC
	OUT	(0F0H),A	;to FDC
	DEC	(IY+3)		;any more?
	JR	NZ,WRITLP	;go if yes
	EX	AF,AF'		;get NZ back
	RET			;return in error
;
TRWRITE	LD	(SPSAVE),SP	;save current stack
	CALL	SETNMI		;setup for NMI exit
	INC	E		;bump mask byte
	LD	A,0F0H		;write track command
	OUT	(0F0H),A	;issue to FDC
	CALL	DSKSLO		;short delay
;
TRW1	IN	A,(0F0H)	;read FDC status
	AND	E		;check if ready
	JP	PO,TRW1		;go if not
	OUTI			;send byte
	DEC	E		;change mask
;
TRW2	IN	A,(0F0H)	;read FDC status
	AND	E		;check if ready
	JR	Z,TRW2		;go if not
	OUTI			;to FDC
;
	LD	B,D		;pass select code
	LD	E,(IX+0)	;get lsb length
	LD	D,(IX+1)	;get msb length
	SET	6,B		;set wait bit
;
TRW4	LD	A,B		;get select command
	OUT	(0F4H),A	;set wait states
	OUTI			;go for it
	LD	B,A		;reset B from OUTI
	DEC	DE		;less this byte
	LD	A,D		;any more?
	OR	E		;any bits on?
	JR	NZ,TRW4		;go if not
;
	LD	A,B		;get command
	OR	80H		;set double density
TRW5	OUT	(0F4H),A	;to FDC
	OUTI			;write byte
	JR	TRW5		;go till interrupt
;
;	sector read I/O
;
SREAD	LD	A,80H		;FDC read command
	JR	SRDWTCM		;go common
;
;	sector write with no seek
;
NWRITE	CALL	SELECT		;select drive
	RET	NZ		;error!
	CALL	SEEK		;seek track D
	RET	NZ		;return if error
	LD	A,E		;get sector
	OUT	(0F1H),A	;give to track register
	LD	A,0A0H		;sector write command
	EX	AF,AF'		;pass it here
	JR	WRITRES		;resume with command
;
;	sector write I/O
;
SWRITE	LD	A,0A0H		;sector write
;
SRDWTCM	EX	AF,AF'		;save command
	CALL	SELECT		;select drive
	RET	NZ		;not ready
	CALL	SEEK		;seek track
	RET	NZ		;error
WRITRES	LD	(SPSAVE),SP	;save stack pointer
	CALL	SETNMI		;setup for NMI return
	EX	AF,AF'		;get command back
	OUT	(0F0H),A	;issue command
	CALL	DSKSLO		;short delay for status
;
SRW1	IN	A,(0F0H)	;read status
	AND	E		;byte ready?
	JR	Z,SRW1		;wait if not
RWDIR	DEFW	0000H		;OUTI / INI
	LD	B,60H		;delay here
RWTNOP	DJNZ	$		;before second byte
	LD	A,D		;get wait command
	OR	40H		;set wait states
SWR2	OUT	(0F4H),A	;go wait states
RWDIR2	DEFW	0000H		;OUTI / INI
	JR	SWR2		;go till done!
;
;	select drive
;
SELECT	IN	A,(0F0H)	;read status
	AND	80H		;check if motor on
	LD	A,(IY+5)	;get select code
	OUT	(0F4H),A	;select drive
	RET	Z		;drive already on
;
	PUSH	BC		;save BC
	LD	BC,0000H	;delay before access
	CALL	60H		;call ROM sub
	POP	BC		;restore
;
;	check for ready now!
;
	JR	SELECT		;re-select drive
;
;	seek head to desired track in D register
;
SEEK	CALL	SELECT		;select drive
	RET	NZ		;return in error
	CALL	GETTRK		;get current track
	OUT	(0F1H),A	;to FDC track reg
	OR	A		;on track 0?
	JR	NZ,SEEKOK	;nope, continue
	CALL	RESTORE		;restore drive
	JR	NZ,SEEKER	;error, abort
;
SEEKOK	CALL	SELECT		;reselect drive
	JR	NZ,SEEKER	;dropped ready
	LD	A,D		;get desired track
	OUT	(0F3H),A	;to FDC register
	LD	A,E		;get desired sector
	OUT	(0F2H),A	;to FDC sector reg
	LD	A,18H		;seek with load
	OR	(IY+7)		;combine with step rate
	OUT	(0F0H),A	;to FDC
	CALL	DSKSLO		;wait for valid status
;
SEEKWT	CALL	SELECT		;re-select drive
	JR	NZ,SEEKER	;dropped ready!
	IN	A,(0F0H)	;read FDC status reg
	BIT	0,A		;command in progress?
	JR	NZ,SEEKWT	;wait if not done
;
	AND	98H		;any errors?
	PUSH	AF		;save on stack
	IN	A,(0F1H)	;read track register
	JR	SEEKPT		;continue
;
SEEKER	PUSH	AF		;save error
	XOR	A		;force $restore next time
;
SEEKPT	CALL	PUTTRK		;load track into table
	POP	AF		;restore Z flag
	RET			;return with error
;
;	restore drive to track 0
;
RESTORE	CALL	SELECT		;select drive
	RET	NZ		;return in error
	LD	A,08H		;restore command
	OR	(IY+7)		;combine with step rate
	OUT	(0F0H),A	;issue a command
	CALL	DSKSLO		;wait for valid status
;
RESWT	CALL	SELECT		;select drive
	JR	NZ,SEEKER	;go if error
	IN	A,(0F0H)	;read status
	BIT	0,A		;command in progress?
	JR	NZ,RESWT	;wait if yes
	AND	9CH		;check for errors
	CP	4		;bit 2 must be set
	JR	SEEKER		;load 0 to table
;
;	short wait for FDC to place valid status
;
DSKSLO	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	RET
;
;	setup drive for I/O
;
SETDRV	AND	3		;0-3 only
	LD	(IY+6),A	;save binary drive
	PUSH	BC		;save
	LD	B,1		;bit mask for drive
	JR	Z,SETHAV	;have it, go!
SETDRL	SLA	B		;align bit mask
	DEC	A		;go again
	JR	NZ,SETDRL	;go till found
SETHAV	LD	A,(IY+8)	;get density
	AND	80H		;assure bit 7 only
	OR	B		;merge with select code
	LD	(IY+5),A	;save as select code
	POP	BC		;restore BC
	RET			;done
;
;	setup NMI for activity
;
SETNMI	PUSH	HL		;save buffer
	LD	HL,RETNMI	;nmi return vector
	LD	(404AH),HL	;set fixed address
	LD	A,0C3H		;JP opcode
	LD	(4049H),A	;set into vector
	POP	HL		;restore buffer
;
	LD	BC,00F3H	;counter, I/O port
	IN	A,(0F0H)	;clear FDC latch
	LD	D,(IY+5)	;get select code
	LD	A,(IY+0)	;get current track
	CP	23		;< 23?
	LD	A,0		;zero mask
	JR	C,NOTG23	;not, go!
	LD	A,20H		;pre-comp mask
NOTG23	OR	D		;merge with select
	LD	D,A		;D = select code
	OUT	(0F4H),A	;select drive
	LD	E,2		;set bit 1 for test
	DI			;disable for xfer
	LD	A,0C0H		;enable NMI
	OUT	(0E4H),A	;enabled!
	RET			;done, return
;
;	return from NMI vector
;
RETNMI	XOR	A		;load zero
	OUT	(0E4H),A	;disable any more NMI's
	LD	HL,NMIRET	;non-disk NMI's
	LD	(404AH),HL	;save fixed address
	IN	A,(0F0H)	;read status
	LD	SP,$		;reset stack
SPSAVE	EQU	$-2
	EI			;can enable now
	RET			;return with status
;
NMIRET	RETN			;non-disk
;
;	load/save track into table
;
GETTRK	OR	A		;clear carry flag
	JR	GETPUT		;go common
;
PUTTRK	SCF			;set carry flag
;
GETPUT	PUSH	HL		;save it
	PUSH	AF		;save flags
	LD	HL,CTRACK	;current track table
	CALL	POINT		;point to it
	POP	AF		;restore flags
	JR	C,PUTIN		;go if store
	LD	A,(HL)		;fetch from table
PUTIN	LD	(HL),A		;install in table
	POP	HL		;restore
	RET			;done
;
;	point to table entry for current drive
;
POINT	LD	A,(IY+6)	;get binary drive #
	ADD	A,L		;add offset
	LD	L,A		;update
	RET	NC		;did not cross page
	INC	H		;bump MSB
	RET			;done!
;
;	check out disk drive for ready
;
STAT	CALL	SELECT		;select drive
	LD	A,0D8H		;immediate interrupt
	OUT	(0F0H),A	;issue to FDC
	LD	A,0D0H		;reset FDC
	OUT	(0F0H),A	;to FDC
	CALL	SELECT		;re-select drive
	RET	NZ		;error!
;
	LD	BC,6000H	;max delay
STAT1	CALL	STAT0		;get status
	JR	NZ,STAT1	;wait for no hole
;
STAT2	CALL	STAT0		;get status
	JR	Z,STAT2		;wait for hole
;
STAT3	CALL	STAT0		;get status
	JR	NZ,STAT3	;wait for no hole
	RET			;return, drive OK
;
STAT0	DEC	BC		;less counter
	LD	A,B		;any bits?
	OR	C		;yes?
	JR	Z,STAT4		;go if error!
	IN	A,(0F0H)	;read status
	AND	2		;check for index hole
	RET			;return for check
;
STAT4	POP	BC		;dummy pop BC
	LD	A,0D0H		;clear/reset FDC
	OUT	(0F0H),A
	LD	A,01H		;return not ready
	OR	A		;return NZ
	RET			;back to caller
;
