; ptcopy0/asm - kjw/bqsd - 11/82
;
	SUBTTL	'<Main Program Driver>'
;
;
ENTRY	DI			;disable for setup
	LD	SP,STACK	;reset stack
	LD	A,0C3H		;JP opcode
	LD	(4012H),A	;for RST 38H
	LD	HL,TASK		;interrupt task
	LD	(4013H),HL	;save it
	XOR	A		;load zero
	OUT	(0E4H),A	;disable NMI's
	LD	A,28H		;setup video
	OUT	(0ECH),A	;setup registers
	LD	A,4		;enable RTC
	OUT	(0E0H),A	;enable it
	IM	1		;interrupt mode 1
	EI			;enable interrupts
	LD	HL,HELLO	;sign on message
	CALL	DISPLAY		;display it
	CALL	TESTMEM		;test memory
;
BEGIN	LD	SP,STACK	;reset stack
	LD	IY,SYSTEM	;setup data table
	LD	HL,HELLO	;sign on message
	CALL	DISPLAY		;re-display it
	JP	PARAMS		;get user params
;
;	test memory before using it
;
TESTMEM	LD	HL,TESTMSG	;testing...
	CALL	DISPLAY
	XOR	A		;load all bits off
	CALL	TESTSET		;settling test
	LD	A,-1		;load all bits on
	CALL	TESTSET		;settling test
	LD	HL,PGMEND	;end of program
;
TESTLP1	LD	DE,TESTBL	;test table
TESTLP2	LD	A,(DE)		;get table byte
	CP	80H		;terminator?
	JR	Z,TESTLP3	;go if done with byte
	LD	(HL),A		;to buffer
	CP	(HL)		;still there?
	JR	NZ,BADMEM	;go if bad
	INC	DE		;bump test table
	JR	TESTLP2		;go outer loop
;
TESTLP3	INC	HL		;bump memory
	LD	A,H		;any more?
	OR	L		;any bits set?
	JR	NZ,TESTLP1	;go if not 0000H
	RET			;else done with test!
;
;	test memory with settling time
;
TESTSET	LD	HL,PGMEND	;end of program
	LD	DE,PGMEND+1	;end +1
	LD	BC,-1-PGMEND	;length -1
	LD	(HL),A		;test byte to buffer
	PUSH	HL		;save buffer start
	LDIR			;fill memory
	POP	HL		;restore buffer
;
TESTSL	CP	(HL)		;still there?
	JR	NZ,BADMEM	;go bad if not!
	INC	L		;go till 0000H
	JR	NZ,TESTSL
	INC	H
	JR	NZ,TESTSL
	RET			;done!
;
;	bad memory!
;
BADMEM	LD	HL,BADMSG	;bad memory
	CALL	DISPLAY		;display it
	LD	B,1		;one key input
	CALL	GETSTR		;from keyboard
	JP	ENTRY		;restart program
;
TESTBL	DEFB	11001100B	;pairs
	DEFB	00110011B	;opposite
	DEFB	11110000B	;nybbles
	DEFB	00001111B	;opposite
	DEFB	11111111B	;all bits on
	DEFB	00000000B	;all bits off
	DEFB	80H		;terminator
;
;
;	execute copy here
;
LOOPER	LD	SP,STACK	;reset stack
	CALL	RESET		;reset for loop
	LD	HL,MNTMSGA	;mount message A
	CALL	MOUNT		;mount diskettes
	CALL	FORMAT		;format diskettes
	CALL	COPY		;copy data
	CALL	SERIAL		;install serial #'s
	CALL	RESULT		;display result
	JR	LOOPER		;go again
;
;	prompt user to mount disks or press BREAK
;
MOUNT	CALL	DISPLAY		;display it
	LD	B,1		;one key input
	CALL	GETSTR		;wait for keys
	PUSH	AF		;save key/flags
	LD	A,LF		;send linefeed
	CALL	VOUT		;to video
	POP	AF		;restore input
	JP	C,UPDATE	;update serial <BREAK>
	RET			;return if <ENTER>
;
FORMAT	LD	HL,FORMIT	;subroutine
	JR	COMMON		;go common
;
;	transfer data!
;
COPY	LD	A,LF		;send linefeed to video
	CALL	VOUT		;display it
	LD	A,LF		;another
	CALL	VOUT
;
	CALL	READ0		;read track 0
	LD	HL,WRITE0	;write track 0
	CALL	COMMON		;do all drives
;
	CALL	READ1		;read track 1
	LD	HL,WRITE1	;write track 1
	CALL	COMMON		;do all drives
;
	CALL	READ2		;read I program
	LD	HL,WRITE2	;write I program
	CALL	COMMON		;do all drives
;
	CALL	READ3		;read III program
	LD	HL,WRITE3	;write III program
	CALL	COMMON		;do all drives
;
	RET
;
SERIAL	LD	HL,SERIT	;subroutine
;
;	common vector for active drives
;
COMMON	LD	(VECTOR),HL	;save vector
	XOR	A		;load current drive
;
COMMLP	CALL	SETDRV		;setup for I/O
;
	CALL	ANYDEST		;any dest drives left?
	LD	HL,LTABLE	;lockout table
	CALL	POINT		;point to byte
	LD	A,(HL)		;get flag
	INC	A		;true (FF)?
	CALL	Z,$		;call vector if active
VECTOR	EQU	$-2
	LD	A,(IY+6)	;get current drive
	INC	A		;bump it
	CP	4		;0-3?
	JR	C,COMMLP	;go if more
	RET			;else done!
;
;	reset tables for next loop
;
RESET	LD	HL,ATABLE	;active drive table
	LD	DE,LTABLE	;lockout table
	LD	BC,4		;4 bytes long
	LDIR			;reset for next pass
	RET			;return
;
RESULT	RET
;
;	read boot / config / patch data from source
;
READ0	LD	DE,0100H	;track/sector
	LD	HL,BUFFER	;start of buffer
	LD	A,(IY+4)	;get source drive
	LD	(IY+8),E	;set single density
	CALL	SETDRV		;setup for I/O
;
READ0L	CALL	READ		;read the sector
	JP	NZ,SRCERR	;source error!
	LD	D,0		;reset to track 0 now
	INC	H		;bump buffer
	INC	E		;bump sector
	LD	A,E		;get sector
	CP	10		;0-9?
	JR	C,READ0L	;finish it off
	RET			;else done!
;
;	write boot / config / patch data to disk
;
WRITE0	LD	DE,0000H	;track/sector
	LD	HL,BUFFER	;I/O buffer
	LD	(IY+8),E	;set single density
;
WRITE0L	LD	A,(IY+6)	;current drive
	CALL	SETDRV		;setup for I/O
	CALL	WRITE		;write sector
	JP	NZ,REMDRIV	;remove drive
	INC	H		;bump buffer
	INC	E		;bump sector
	LD	(IY+8),0	;set single density
	LD	A,E		;fetch it
	CP	1		;sector 1?
	JR	NZ,WRITE01	;go if not
	SET	7,(IY+8)	;set double density
WRITE01	CP	10		;0-9?
	JR	C,WRITE0L	;go if more to do
	RET			;else done!
;
;	read loaders from source
;
READ1	LD	DE,0101H	;track 1/ sector 1
	LD	HL,BUFFER	;I/O buffer
	LD	(IY+8),0	;set single density
	LD	A,(IY+4)	;get source drive
	CALL	SETDRV		;setup for I/O
;
READ1L	CALL	READ		;read a sector
	JP	NZ,SRCERR	;go source error
	INC	H		;bump buffer
	INC	E		;bump sector
	LD	A,E		;get sector
	CP	10		;1-9?
	JR	C,READ1L	;go if more
	RET			;else done!
;
;	write loaders to target disk
;
WRITE1	LD	HL,REMDRIV	;leave error vector
	PUSH	HL		;on stack for easy exit
;
	LD	A,(IY+6)	;get current drive
	LD	(IY+8),0	;set single density
	CALL	SETDRV		;setup for I/O
	LD	HL,BUFFER	;start of buffer
	LD	DE,0120H	;track 1/sector 20h
	CALL	WRITENS		;write with no seek!
	RET	NZ		;error!
	LD	E,40H		;sector 40h
	INC	H		;512 byte sectors
	INC	H
	CALL	WRITENS		;write with no seek!
	RET	NZ		;go if any error!
;
	LD	E,50H		;sector 50h
	LD	HL,BUFFER+500H	;start of buffer
	CALL	WRITENS		;write with no seek
	RET	NZ		;return if error
;
	LD	E,70H		;sector 70h
	INC	H		;512 byte sectors
	INC	H
	CALL	WRITENS		;write with no seek
	RET	NZ		;return if error
;
	POP	AF		;remove error vector
	XOR	A		;return zero
	RET			;done
;
;	read program from disk
;
READ2	LD	DE,0500H	;high/low sectors
	JR	READ23		;go common
;
READ3	LD	DE,0A05H	;high/low sectors
;
READ23	LD	(IY+10),E	;load low sector
	LD	(IY+11),D	;load high sector
	LD	(IY+8),0	;set single density
	LD	HL,BUFFER	;start I/O buffer
	LD	A,(IY+4)	;get source drive
	CALL	SETDRV		;setup for I/O
	LD	D,03		;start on track 3
;
READ2L	CALL	READ		;read the sector
	JP	NZ,SRCERR	;go if source error!
	INC	H		;bump buffer
	INC	E		;bump sector
	LD	A,E		;fetch new sector
	CP	(IY+11)		;test to highest +1
	JR	C,READ2L	;go if not
	LD	E,(IY+10)	;reset to 0
	INC	D		;bump track
	LD	A,D		;fetch result
	CP	(IY+1)		;compare to track count
	JR	C,READ2L	;go if more
	XOR	A		;return zero
	RET			;Mod I loaded
;
;	write program file
;
WRITE2	LD	(IY+8),0	;load single density
	JR	WRITE23		;go common
;
WRITE3	LD	(IY+8),80H	;load double density
;
WRITE23	LD	A,(IY+6)	;get current drive
	CALL	SETDRV		;setup for I/O
	LD	D,3		;start track
	LD	HL,BUFFER	;buffer start
;
WRITE2L	LD	E,55H		;sector
	CALL	WRITENS		;write with force
	JP	NZ,REMDRIV	;go if error
	INC	H		;bump buffer
	INC	H		;512 bytes
	LD	E,66H		;sector
	CALL	WRITENS		;force write
	JP	NZ,REMDRIV	;go if error
	INC	H		;bump buffer
	INC	H		;512 bytes
	LD	E,77H		;sector
	CALL	WRITENS		;force write
	JP	NZ,REMDRIV	;go if error
	INC	H		;bump buffer
;
	INC	D		;bump track
	LD	A,D		;fetch result
	CP	(IY+1)		;still in range?
	JR	C,WRITE2L	;go if more
	XOR	A		;return zero
	RET			;done!
;
SERIT	RET
;
;	update serial #'s to disk
;
;*****
UPDATE	JP	PARAMS		;go params
;
;	check if any dest drives left in que
;
ANYDEST	LD	HL,LTABLE	;lockout table
	LD	B,4		;4 entries
;
ANYDESL	LD	A,(HL)		;get a byte
	INC	A		;FF = true?
	RET	Z		;yes, have one!
	INC	HL		;bump table
	DJNZ	ANYDESL		;go if any more
;
;	no dest drives, abort operation!
;
	LD	HL,DESMSG	;text
	CALL	DISPLAY		;display it
	JP	PARAMS		;restart current loop
;
;	fetch parameters from users
;
PARAMS	LD	HL,ATABLE	;active drive table
	LD	DE,ATABLE+1	;start +1
	LD	BC,3		;length -1
	LD	(HL),-1		;activate a drive
	LDIR			;activate all drives
;
PARAM1	LD	HL,SDRMSG	;source drive?
	CALL	DISPLAY
	LD	B,1		;one key input
	CALL	GETSTR		;get from keyboard
	LD	A,'0'		;default to zero
	JR	Z,PARAM1A	;go default
	LD	A,(HL)		;fetch input
PARAM1A	SUB	'0'		;remove ascii
	JR	C,PARAM1	;go if invalid
	CP	4		;0-3?
	JR	NC,PARAM1	;go if bad
	LD	(IY+4),A	;save drive
	CALL	SETDRV		;set it up
	LD	HL,ATABLE	;active table
	CALL	POINT		;point to byte
	LD	(HL),0		;de-activate this drive
;
;	fetch step rate from user
;
PARAM2	LD	HL,STPMSG	;step rate
	CALL	DISPLAY		;display prompt
	LD	B,1		;one key input
	CALL	GETSTR		;get input
	JP	C,PARAM1	;go if break
	LD	A,'0'		;default zero
	JR	Z,PARAM2A	;go if nil
	LD	A,(HL)		;get input from user
PARAM2A	SUB	'0'		;remove ascii
	JR	C,PARAM2	;go if invalid
	CP	4		;0-3?
	JR	NC,PARAM2	;go if invalid
	LD	(IY+7),A	;save step rate
;
;	see if <D>uplicate or <A>pply 80 track loaders
;
PARAM3	LD	HL,OPMSG	;operation message
	CALL	DISPLAY		;display it
	LD	B,1		;one key input
	CALL	GETSTR		;get from keyboard
	JP	C,PARAM2	;go if break
	JP	Z,LOOPER	;go duplicate if nil
	LD	A,(HL)		;get input
	CALL	UCASE		;make upper case
	CP	'D'		;duplicate?
	JP	Z,LOOPER	;go if yes
	CP	'A'		;apply 80 track loaders?
	JR	NZ,PARAM3	;go if neither
;
;	apply 80 track loaders to diskettes
;
APPLY	LD	SP,STACK	;reset stack
	CALL	RESET		;reset active drives
	LD	HL,MNTMSGB	;mount message B
	CALL	MOUNT		;request disk mount
	CALL	APPLY80		;apply the loaders
	JR	APPLY		;continue
;
APPLY80	LD	HL,FORM80	;format first
	CALL	COMMON		;do all drives
;
	LD	DE,2301H	;track 35/ sector 1
	CALL	READ1+3		;read it
	LD	HL,WRITE1	;write to 80 tracks
	JP	COMMON		;do all drives
;
;
