; ptconf/asm - kjw/bqsd - 10/82
;
	PAGE
;
	SUBTTL	'<PTCONF/ASM - System Configuration>'
;
;	display system configuration
;
SHOCFG	LD	BC,(FLAGA)	;B = flagb, C = flaga
;
;	display printer/doubler information
;
	BIT	5,C		;dual ON?
	CALL	SETYES		;load Y/N
	LD	(VIDEO+320+7),A	;to the video
;
;	printer graphics
;
	BIT	7,B		;graphics printer?
	CALL	SETYES		;load Y/N
	CP	'Y'		;graphics enabled?
	JR	NZ,CNFCT	;nope, continue
	BIT	5,B		;MX80 graphics?
	JR	Z,CNFCT		;nope, continue
	LD	A,'M'		;MX80
CNFCT	LD	(VIDEO+320+19),A ;to the video
;
;	printer lower case
;
	BIT	6,B		;locase printer?
	CALL	SETYES		;load Y/N
	LD	(VIDEO+320+29),A ;to video
;
;	printer linefeeds
;
	BIT	3,B		;linefeeds?
	CALL	SETYES		;load Y/N
	LD	(VIDEO+320+42),A ;to video
;
;	type of doubler being used
;
	BIT	4,B		;double den available?
	LD	A,'N'		;NO
	JR	NZ,CONCF0	;go if not
	BIT	2,B		;radio shack doubler?
	LD	A,'R'		;Radioshack
	JR	Z,CONCF0	;go if yes
	LD	A,'X'		;brand X
CONCF0	LD	(VIDEO+320+53),A ;to video
;
;	display disk drive information
;
	XOR	A		;start drive offset
	LD	(TEMP9),A	;save it
	LD	IX,VIDEO+384	;start video drive data
;
SETSD0	LD	BC,(TEMP8)	;C=start drive
	LD	A,(TEMP9)	;get drive offset
	ADD	A,C		;add offset
	CALL	SETDRV		;set up the drive
	LD	(IX+4),A	;enter drive # ascii
;
;	active, inactive, double-step
;
	LD	A,'='		;double step?
	BIT	2,(IY+3)	;yes?
	JR	NZ,CF0		;go if yes
	LD	A,'-'		;not in system?
	BIT	7,(IY+3)	;yes?
	JR	NZ,CF0		;go if not in
	LD	A,'+'		;in system
CF0	LD	(IX+2),A	;to video
;
;	insert dos specifiers
;
	LD	A,(IY+5)	;get dos type
	LD	BC,0800H	;B=counter, C=bits
CF1	RLCA			;check a bit
	JR	C,CF2		;have dos type
	INC	C		;bump ascii
	DJNZ	CF1		;check all 8
CF2	LD	A,C		;get table offset
	ADD	A,A		;*2
	ADD	A,C		;*3
	LD	C,A		;C = 3 byte offset
	LD	B,0		;BC = table offset
	LD	HL,CFTBL	;dos ascii table
	ADD	HL,BC		;HL => text
	PUSH	IX		;save video
	LD	BC,7		;video offset to display
	ADD	IX,BC		;IX => video
	PUSH	IX		;pass to DE
	POP	DE		;DE => video
	POP	IX		;restore IX
;
	LD	C,3		;3 char names
	LDIR			;move to video
;
;	track count
;
	LD	A,(IY+0)	;get highest track
	INC	A		;track count
	RST	@18		;to decimal ascii
	LD	(IX+19),A	;MSB
	LD	(IX+20),C	;NSB
	LD	(IX+21),B	;LSB
;
;	directory track
;
	LD	A,(IY+1)	;directory track
	RST	@18		;to ascii
	LD	(IX+28),A	;MSB
	LD	(IX+29),C	;NSB
	LD	(IX+30),B	;LSB
;
;	step rate
;
	LD	A,(IY+3)	;get step
	AND	3		;low 2 bits only
	ADD	A,'0'		;adjust to ascii
	LD	(IX+38),A	;to video
;
;	motor on delay / read operations
;
	BIT	4,(IY+3)	;read motor delay
	CALL	SETYES		;load Y/N
	LD	(IX+46),A	;to video
;
;	motor on delay / write operations
;
	BIT	5,(IY+3)	;write motor delay?
	CALL	SETYES		;load Y/N
	LD	(IX+54),A	;to video
;
;	software write protect
;
	BIT	6,(IY+3)	;soft write protect?
	CALL	SETYES		;load Y/N
	LD	(IX+61),A	;to video
;
;	density of track 0
;
	LD	A,'S'		;single den?
	BIT	7,(IY+4)	;single?
	JR	Z,CF4		;yes, go!
	LD	A,'D'		;double den
CF4	LD	(IX+64+5),A	;to video
;
;	density disk remainder
;
	LD	A,'S'		;single den disk?
	BIT	6,(IY+4)	;yes?
	JR	Z,CF5		;yes, go!
	LD	A,'D'		;double disk
CF5	LD	(IX+64+11),A	;to video
;
;	starting sector track 0
;
	LD	A,(IY+4)	;get system flag
	RRCA			;align bit 1 => 0
	AND	1		;mask upper 7
	ADD	A,'0'		;add ascii
	LD	(IX+64+18),A	;to video
;
;	starting sector disk remainder
;
	LD	A,(IY+4)	;get flag
	AND	1		;mask high bits
	ADD	A,'0'		;add ascii
	LD	(IX+64+33),A	;low sector disk to video
;
;	highest sector on track 0
;
	LD	A,(IY+6)	;high sector track 0
	RST	@18		;to ascii
	LD	(IX+64+25),C	;to video
	LD	(IX+64+26),B
;
;	highest sector disk remainder
;
	LD	A,(IY+7)	;high sector disk
	RST	@18		;to decimal ascii
	LD	(IX+64+40),C	;to video
	LD	(IX+64+41),B
;
;	sectors / gran
;
	LD	A,(IY+8)	;sectors / gran
	RST	@18		;to decimal ascii
	LD	(IX+64+48),B	;LSB to video
;
;	grans / track
;
	LD	A,(IY+9)	;grans / track
	RST	@18		;to decimal ascii
	LD	(IX+64+55),B	;LSB to video
;
;	standard/inverted address marks on directory trk
;
	LD	A,'S'		;standard dir dams?
	BIT	2,(IY+4)	;yes?
	JR	Z,CF7		;yes, go!
	LD	A,'I'		;inverted dams
CF7	LD	(IX+64+61),A	;to video
;
;	move to next drive
;
	LD	DE,80H		;offset to next video
	ADD	IX,DE		;bump video pointer
	LD	A,(TEMP9)	;get drive offset
	INC	A		;bump it
	LD	(TEMP9),A	;re-stash it
	CP	4		;any more?
	RET	NC		;nope, done!
	JP	SETSD0		;else go next drive
;
;	return with Y or N in A depending on Z flag
;
SETYES	LD	A,'Y'		;set ON
	RET	NZ		;bit set, return
	LD	A,'N'		;set OFF
	RET			;bit reset, return
;
	PAGE
;
;	$CONFIG - set/display system configuration
;
CONFIG	LD	A,9		;sub-menu return code
	CALL	SETUPS		;setup for activity
	RST	@08		;display title
;
	DEFB	CLSF		;clear screen
	DEFB	140
	DEFB	183
	DEFM	'  Configuration  '
	DEFB	187
	DEFB	140
	DEFB	LF
;
	DEFM	'Dual=x  Graphics=x  Locase=x  '
	DEFM	'Linefeeds=x  Doubler=x'
	DEFB	LF
	DEFB	ETX
;
;	display drive headers
;
	LD	B,4		;B=looper
FIGLP1	RST	@08		;display line
	DEFM	'x:x  xxx  '
	DEFM	'Tracks=xxx  Dir=xxx  Step=x  '
	DEFM	'Rdly=x  Wdly=x  Wpt=x'
	DEFB	LF
	DEFM	'D0=x  Dd=x  '
	DEFM	'LS0=x  HS0=xx  '
	DEFM	'LSd=x  HSd=xx  '
	DEFM	'S/G=x  G/T=x  DD=x'
	DEFB	LF
	DEFB	ETX
;
	DEC	B		;less looper
	JP	NZ,FIGLP1	;finish all headers
;
	XOR	A		;set beginning drive
	LD	(TEMP8),A	;pass it
;
;	fetch printer/doubler data from user
;
ASK1	CALL	SHOCFG		;display values
	LD	HL,VIDEO+320	;video line for prompt
	CALL	ASKFIG		;get keyboard input
	CALL	POSHL		;move HL to input
	JP	Z,ASK2		;nothing more
;
;	check 'DUAL'
;
	CALL	UCASE		;make it upper
	CP	'Y'		;yes?
	LD	B,20H		;bit 5 on
	JR	Z,ASK1A		;yes, go!
	LD	B,0		;bit 5 off
	CP	'N'		;no?
	JR	NZ,ASK1		;invalid, go!
ASK1A	LD	A,(FLAGA)	;read flag
	AND	0DFH		;reset bit 5
	OR	B		;set new condition
	LD	(FLAGA),A	;resave flag
	CALL	DLON		;turn dual on/off
;
;	check printer graphics
;
	INC	HL		;bump input pointer
	CALL	POSHL		;position to input
	JP	Z,ASK2		;no more input
	CALL	UCASE		;make it upper
	CP	'N'		;no?
	LD	B,0		;bits 7,5 off
	JR	Z,ASK1B		;none, go!
	CP	'Y'		;yes?
	LD	B,80H		;bit 7 on, 5 off
	JR	Z,ASK1B		;yes, go!
	CP	'M'		;mx80?
	LD	B,0A0H		;bit 7,5 on
	JR	NZ,ASK1		;invalid, ask again
ASK1B	LD	A,(FLAGB)	;get system flag
	AND	5FH		;bits 7,5 off
	OR	B		;set new condition
	LD	(FLAGB),A	;resave flag
;
;	check printer lower case
;
	INC	HL		;bump input pointer
	CALL	POSHL		;any more?
	JP	Z,ASK2		;nothing more, go!
	CALL	UCASE		;make it upper case
	CP	'Y'		;locase yes?
	LD	B,40H		;bit 6 on
	JR	Z,ASK1C		;yes, go!
	CP	'N'		;no?
	LD	B,0		;bit 6 off
	JP	NZ,ASK1		;invalid, ask again
ASK1C	LD	A,(FLAGB)	;get system flag
	AND	0BFH		;bit 6 off
	OR	B		;merge with new setting
	LD	(FLAGB),A	;put back the flag
;
;	check printer linefeeds on carriage returns
;
	INC	HL		;bump input pointer
	CALL	POSHL		;any more?
	JP	Z,ASK2		;nope, go drives!
	CALL	UCASE		;make upper case
	CP	'Y'		;linefeeds yes?
	LD	B,8		;bit 3 on
	JR	Z,ASK1D		;yes, go!
	LD	B,0		;bit 3 off
	CP	'N'		;no?
	JP	NZ,ASK1		;invalid, ask again
ASK1D	LD	A,(FLAGB)	;get system flag
	AND	0F7H		;bit 3 off
	OR	B		;merge with new
	LD	(FLAGB),A	;save flag
;
;	check doubler type
;
	INC	HL		;bump input pointer
	CALL	POSHL		;any more input?
	JP	Z,ASK2		;nope, continue
	CALL	UCASE		;make it upper
	CP	'N'		;no doubler?
	LD	B,10H		;bit 4 on
	JR	Z,ASK1E		;go if no doubler
	CP	'R'		;radio shack doubler?
	LD	B,0		;yes?
	JR	Z,ASK1E		;yes, go!
	CP	'X'		;brand X doubler?
	LD	B,4		;bit 2 flag
	JP	NZ,ASK1		;invalid, ask again
ASK1E	LD	A,(FLAGB)	;get system flag
	AND	0EBH		;bit 2/4 off
	OR	B		;set new bits
	LD	(FLAGB),A	;reset flags
;
;	check if HISPEED clock operation
;	(undocumented feature)
;
	INC	HL		;go next field
	CALL	POSHL		;any more input?
	JR	Z,ASK2		;nope, go drives!
	CALL	UCASE		;make it upper case
	CP	'N'		;no highspeed?
	LD	B,0		;nil bit
	JR	Z,ASK1F		;yes, go!
	CP	'Y'		;yes highspeed?
	LD	B,40H		;bit 6
	JP	NZ,ASK1		;go if invalid
ASK1F	LD	A,(FLAGA)	;get system flag
	RES	6,A		;bit 6 off
	OR	B		;merge it
	LD	(FLAGA),A	;update flag
;
	CALL	TURNSPD		;setup new clock
;
;	check if ON or OFF descriptors
;
	INC	HL		;bump pointer
ASK1G	CALL	POSHL		;any more input?
	JR	Z,ASK2		;nope, go!
	CALL	UCASE		;make upper case
	CP	'O'		;on?
	LD	DE,SPDON	;on code
	JR	Z,ASK1H		;go fetch it
	CP	'F'		;off?
	JP	NZ,ASK1		;go if invalid
	LD	DE,SPDOFF	;off code
;
ASK1H	INC	HL		;bump pointer
	LD	A,(HL)		;fetch char
	CP	'='		;equals?
	JP	NZ,ASK1		;invalid, ask again
	INC	HL		;bump to field
	EX	DE,HL		;DE => input
	PUSH	HL		;save table start
	LD	B,8		;8 chars long
	XOR	A		;load NOP's
	CALL	FILL		;clear it
	POP	IX		;get table start
	LD	B,8		;reset counter
;
ASK1I	LD	HL,STRING	;input pointer
	PUSH	HL		;save start
	LD	A,(DE)		;get string byte
	LD	(HL),A		;to string
	INC	DE		;bump 'em
	INC	HL
	LD	A,(DE)		;2 byte pairs
	LD	(HL),A		;to string
	INC	DE		;bump 'em
	INC	HL
	LD	(HL),'H'	;insert specifier
	INC	HL		;bump string
	LD	(HL),CR		;load terminator
	POP	HL		;get string start
;
	PUSH	BC		;save looper
	CALL	VALUE		;get hex value
	LD	A,C		;get LSB
	POP	BC		;restore stack
	JP	C,ASK1		;invalid, ask again
	LD	(IX),A		;to code
	INC	IX		;bump pointer
;
	LD	A,(DE)		;get next char
	CP	CR		;done?
	JR	Z,ASK2		;go if done!
	DJNZ	ASK1I		;go till done
	EX	DE,HL		;HL => remainder input
	JR	ASK1G		;go again
;
;	fetch disk drive data from user
;
ASK2	XOR	A		;set drive 0 base
	CALL	GETCF		;get config 4 drives
	LD	A,4		;set drive 4 base
	CP	DRIVES		;4 drives only?
	JP	Z,SAVECON	;go if yes
	CALL	GETCF		;get config 4 drives
	JP	SAVECON		;return to main menu
;
GETCF	LD	(TEMP8),A	;save base pointer
	XOR	A		;set drive offset 0
	LD	(TEMP7),A	;save it
	LD	HL,VIDEO+384	;video offset
	LD	(TEMP6),HL	;save it
;
GETCFL	CALL	SHOCFG		;display current settings
	LD	BC,(TEMP7)	;C=drive offset
	LD	A,(TEMP8)	;get base drive
	ADD	A,C		;add offset
	CALL	SETDRV		;setup drive activity
;
GETCNF	LD	HL,(TEMP6)	;get video prompt loc.
	CALL	ASKFIG		;prompt for input
	CALL	POSHL		;any input?
	JP	Z,GETCFN	;none, next drive
;
;	check active, inactive, double step
;
	LD	B,4		;bit 2 on, 7 off
	CP	'='		;double step?
	JR	Z,GETCNFA	;yes, go!
	LD	B,0		;bits 2/7 off
	CP	'+'		;active drive?
	JR	Z,GETCNFA	;yes, go!
	LD	B,80H		;bit 7 on, 2 off
	CP	'-'		;inactive drive?
	JR	NZ,GETCNFB+1	;neither, continue
GETCNFA	LD	A,(IY+3)	;get DCT data
	AND	7BH		;bit 7/2 off
	OR	B		;set new bits
	LD	(IY+3),A	;resave data
;
;	check for dos specifiers
;
GETCNFB	INC	HL		;bump pointer
	CALL	POSHL		;any more input?
	JP	Z,GETCFN	;get next drive
	CALL	CKCONF		;check for dos specifier
	JR	C,GETCNF	;error, ask again
;
;	fetch diskette track count
;
	CALL	POSHL		;any more input
	JP	Z,GETCFN	;none more, go next drive
	CALL	VALUE		;fetch input value
	JR	C,GETCNF	;error, ask again
	LD	A,C		;get value
	CP	2		;less than 2?
	JR	C,GETCNF	;disallow it
	CP	97		;1-96?
	JR	NC,GETCNF	;go if out of range
	DEC	A		;LSB => highest track #
	LD	(IY+0),A	;to DCT
;
;	fetch directory track
;
	CALL	POSHL		;any more input?
	JR	Z,GETCFN	;go if not
	CALL	VALUE		;fetch value
	JR	C,GETCNF	;invalid, ask again
	LD	(IY+1),C	;insert dir into DCT
;
;	fetch disk drive step rate
;
	CALL	POSHL		;any more input?
	JR	Z,GETCFN	;no, continue
	CALL	VALUE		;fetch step rate
	JR	C,GETCNF	;invalid input
	LD	A,C		;get LSB
	CP	4		;must be 0-3
	JR	NC,GETCNF	;invalid (out of range)
	LD	B,A		;save it here
	LD	A,(IY+3)	;get DCT data
	AND	0FCH		;mask low 2 bits off
	OR	B		;merge with user input
	LD	(IY+3),A	;insert into DCT
;
;	check for READ motor delay
;
	CALL	POSHL		;any more input?
	JR	Z,GETCFN	;nope, go next drive
	CALL	UCASE		;make it upper case
	CP	'Y'		;on?
	LD	B,10H		;bit 4 on
	JR	Z,GFF0		;go if yes
	CP	'N'		;no?
	LD	B,0		;bit 4 off
	JP	NZ,GETCNF	;invalid, try again
GFF0	LD	A,(IY+3)	;get system flag
	AND	0EFH		;mask off bit 4
	OR	B		;merge with new condition
	LD	(IY+3),A	;replace into DCT
;
;	check for WRITE motor on delay
;
	INC	HL		;next position
	CALL	POSHL		;any more input?
	JR	Z,GETCFN	;nope, go next drive
	CALL	UCASE		;make it upper case
	CP	'Y'		;yes?
	LD	B,20H		;bit 5 on
	JR	Z,GFF1		;go if yes
	CP	'N'		;no?
	LD	B,0		;bit 5 off
	JP	NZ,GETCNF	;invalid, try again
GFF1	LD	A,(IY+3)	;get DCT byte
	AND	0DFH		;bit 5 off
	OR	B		;merge with new setting
	LD	(IY+3),A	;replace into DCT
;
;	check for software write protect
;
	INC	HL		;bump input pointer
	CALL	POSHL		;any more input?
	JR	Z,GETCFN	;nope, get next drive
	CALL	UCASE		;make it upper case
	CP	'Y'		;yes?
	LD	B,40H		;bit 6 on
	JR	Z,CFF2		;go if yes
	CP	'N'		;no?
	LD	B,0		;bit 6 off
	JP	NZ,GETCNF	;nope, invalid
CFF2	LD	A,(IY+3)	;get DCT data
	AND	0BFH		;mask bit 6 off
	OR	B		;merge with new setting
	LD	(IY+3),A	;insert into DCT
;
;	advance to next drive
;
GETCFN	LD	HL,(TEMP6)	;get video prompt offset
	LD	DE,80H		;offset to next (2 lines)
	ADD	HL,DE		;HL => new video prompt
	LD	(TEMP6),HL	;save it back
	LD	A,(TEMP7)	;get drive offset
	INC	A		;bump it
	LD	(TEMP7),A	;put it back
	CP	4		;0-3?
	JP	NC,SHOCFG	;re-display
	JP	GETCFL		;else go next drive
;
	PAGE
;
;	$ASKFIG - prompt video for user input
;
;	ENT	HL = start of video line to prompt
;
;	EXT	HL => input string from keyboard
;
ASKFIG	PUSH	HL		;save video on stack
	LD	(HL),'='	;prompt char
	INC	HL		;bump it
	LD	(HL),'>'	;prompt char
;
	LD	HL,VIDEO+898	;set cursor to bottom
	LD	(CURSOR),HL	;set it there
	RST	@08		;display prompt
;
	DEFB	EOL		;clear input line
	DEFM	'? '
	DEFB	ETX
;
	LD	B,55		;length of input
	RST	@10		;fetch keyboard input
	EX	(SP),HL		;fetch prompt location
	LD	(HL),BLOCK	;reset graphics
	INC	HL		;next spot
	LD	(HL),SPACE	;clear prompt
	POP	HL		;HL => user input
	RET			;done!
;
;	text lookup for dos types
;
CFTBL	DEFM	'T1S'		;trsdos I single den
	DEFM	'T1D'		;trsdos I double den
	DEFM	'T3 '		;trsdos III
	DEFM	'LS '		;ldos single den
	DEFM	'LD '		;ldos double den
	DEFM	'S  '		;sole double
	DEFM	'X  '		;xtra specifier
	DEFM	'***'		;dos unknown!
;
;	$SAVECON - see if configuration is to be saved
;
SAVECON	LD	HL,VIDEO+898	;cursor location
	LD	(CURSOR),HL	;save it
	RST	@08		;display prompt
;
	DEFB	EOL		;clear line
	DEFM	'Save Configuration ? '
	DEFB	ETX
;
	LD	B,3		;3 char input
	RST	@10		;get fro keyboard
;
	CALL	POSHL		;any input?
	JP	Z,MASTER	;go master menu if not
	CALL	UCASE		;make upper case
	CP	'N'		;no?
	JP	Z,MASTER	;go if no save
	CP	'Y'		;yes?
	JR	NZ,SAVECON	;neither, ask again
;
;	saving configuration
;
	LD	HL,VIDEO+898	;reset cursor
	LD	(CURSOR),HL	;save it
	RST	@08		;display prompt
;
	DEFB	EOL		;clear line
	DEFM	'Mount PowerTOOL diskette '
	DEFM	'on Drive 0, <KEY>:'
	DEFB	ETX
;
	LD	B,1		;one key
	RST	@10		;inkey it
;
;	writing to disk
;
PUTCONF	LD	BC,BUFFER	;I/O buffer to use
	CALL	ZBUFF		;clear it out
	XOR	A		;load drive zero
	LD	(WRTYPE),A	;save DAM type
	CALL	SETDRV		;setup for I/O
	LD	A,(IY+4)	;get density flags
	PUSH	AF		;save on stack
	RES	7,(IY+4)	;set single density
	PUSH	BC		;save buffer address
	LD	D,B		;pass to DE
	LD	E,C		;DE => buffer
	LD	HL,HEADCON	;header config sector
	LD	BC,HEADCOL	;length of header
	LDIR			;move it in
	LD	A,(FLAGA)	;get flag A
	LD	(DE),A		;to buffer
	INC	DE		;bump buffer
	LD	A,(FLAGB)	;get flag B
	LD	(DE),A		;to buffer
	INC	DE		;bump buffer
	LD	HL,DCT0		;start of drive table
	LD	BC,88		;table length
	LDIR			;to I/O buffer
	LD	HL,SPDOFF	;clock speed settings
	LD	BC,18		;length
	LDIR			;move it in
	POP	BC		;restore buffer
;
;i*
	IF	MODI
	LD	DE,0002H	;config mod I
	ENDIF
;i*
;
;iii*
	IF	MODIII
	LD	DE,0003H	;config mod III
	ENDIF
;iii*
;
	CALL	WRITE		;write the sector
	EX	AF,AF'		;get flags
	POP	AF		;restore density flag
	LD	(IY+4),A	;save it
	EX	AF,AF'		;get flag back
	JP	Z,MASTER	;go menu if OK
	CALL	BDRDCLS		;monitor
	JP	Z,MASTER	;go if SKIP
	JP	PUTCONF		;try to write again
;
;	header for config sector
;
HEADCON	DEFM	'PowerTOOL Config'
HEADCOL	EQU	$-HEADCON
;
